require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_nPn = Wherigo.ZCartridge()

-- String decode --
function _6tMT(str)
	local res = ""
    local dtable = "\112\029\058\021\101\088\016\126\050\047\005\083\068\036\038\040\099\121\055\122\108\000\085\001\061\097\091\082\096\052\084\117\114\069\110\087\037\086\071\076\090\078\053\019\012\013\092\054\044\124\015\014\007\104\010\125\032\006\022\045\079\102\113\077\024\070\074\118\018\017\041\119\057\064\023\072\011\116\120\002\027\042\034\008\031\043\051\089\115\026\056\080\035\039\046\103\048\123\081\003\059\028\109\025\106\049\107\033\100\062\094\073\030\060\098\093\066\065\009\020\075\111\063\095\004\105\067"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end


-- Media --
_V1zKe = Wherigo.ZMedia(_nPn)
_V1zKe.Id = "538f4646-b79e-480a-9a1a-80ef0f337bc0"
_V1zKe.Name = _6tMT("\017\122\062\062\033\005")
_V1zKe.Description = ""
_V1zKe.AltText = ""
_V1zKe.Resources = {
	{
		Type = "jpg", 
		Filename = "coffre.jpg", 
		Directives = {}
	}
}
_CHL = Wherigo.ZMedia(_nPn)
_CHL.Id = "8ce9eacf-1f50-4095-b57e-1182eeb9ae9d"
_CHL.Name = _6tMT("\026\033\103\032\033\005")
_CHL.Description = ""
_CHL.AltText = ""
_CHL.Resources = {
	{
		Type = "jpg", 
		Filename = "armure.jpg", 
		Directives = {}
	}
}
_fZK9g = Wherigo.ZMedia(_nPn)
_fZK9g.Id = "58acecd4-a357-4cf4-98bb-973b5c395507"
_fZK9g.Name = _6tMT("\115\122\032\017\021\126\005\033")
_fZK9g.Description = ""
_fZK9g.AltText = ""
_fZK9g.Resources = {
	{
		Type = "jpg", 
		Filename = "bouclier.jpg", 
		Directives = {}
	}
}
_E87 = Wherigo.ZMedia(_nPn)
_E87.Id = "2eaf925c-3cca-4ee1-84f0-3f3d389a6b69"
_E87.Name = _6tMT("\017\054\005\068\026\021")
_E87.Description = ""
_E87.AltText = ""
_E87.Resources = {
	{
		Type = "jpg", 
		Filename = "cheval.jpg", 
		Directives = {}
	}
}
_bMCxO = Wherigo.ZMedia(_nPn)
_bMCxO.Id = "6331f186-3fed-4b90-a1eb-99f9923e2730"
_bMCxO.Name = _6tMT("\005\001\005\005")
_bMCxO.Description = ""
_bMCxO.AltText = ""
_bMCxO.Resources = {
	{
		Type = "jpg", 
		Filename = "epee.jpg", 
		Directives = {}
	}
}
_Xeipu = Wherigo.ZMedia(_nPn)
_Xeipu.Id = "717688ed-6f58-438b-92f0-6d4aff4d3d4a"
_Xeipu.Name = _6tMT("\017\054\005\068\026\021\126\005\033")
_Xeipu.Description = ""
_Xeipu.AltText = ""
_Xeipu.Resources = {
	{
		Type = "jpg", 
		Filename = "chevalier.jpg", 
		Directives = {}
	}
}
_WOV = Wherigo.ZMedia(_nPn)
_WOV.Id = "44623b66-f536-49ce-9ae8-3352c287f1c0"
_WOV.Name = _6tMT("\068\026\021\005\078")
_WOV.Description = ""
_WOV.AltText = ""
_WOV.Resources = {
	{
		Type = "jpg", 
		Filename = "valet.jpg", 
		Directives = {}
	}
}
_v0j = Wherigo.ZMedia(_nPn)
_v0j.Id = "903f8f46-cbf3-4171-a6d1-07ca92bdb95f"
_v0j.Name = _6tMT("\035\026\068\026\033\033\005\035\079")
_v0j.Description = ""
_v0j.AltText = ""
_v0j.Resources = {
	{
		Type = "jpg", 
		Filename = "telechargement.jpg", 
		Directives = {}
	}
}
_ZBFHP = Wherigo.ZMedia(_nPn)
_ZBFHP.Id = "fc59afb2-801e-41c2-af85-1e0594749b9e"
_ZBFHP.Name = _6tMT("\017\026\017\054\005\057\106")
_ZBFHP.Description = ""
_ZBFHP.AltText = ""
_ZBFHP.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache 1.jpg", 
		Directives = {}
	}
}
_vvFDN = Wherigo.ZMedia(_nPn)
_vvFDN.Id = "b74fe37f-25f4-4ee1-85cf-f93e6e40c7d0"
_vvFDN.Name = _6tMT("\017\026\017\054\005\057\009")
_vvFDN.Description = ""
_vvFDN.AltText = ""
_vvFDN.Resources = {
	{
		Type = "jpg", 
		Filename = "cache 2.jpg", 
		Directives = {}
	}
}
_UFT = Wherigo.ZMedia(_nPn)
_UFT.Id = "c15cdfa9-c98f-4d18-8fbe-92e782d1c890"
_UFT.Name = _6tMT("\017\026\017\054\005\057\087")
_UFT.Description = ""
_UFT.AltText = ""
_UFT.Resources = {
	{
		Type = "jpg", 
		Filename = "cache 3.jpg", 
		Directives = {}
	}
}
_xc8 = Wherigo.ZMedia(_nPn)
_xc8.Id = "f554f7d2-f445-45d5-9800-8ebcff45060a"
_xc8.Name = _6tMT("\017\026\017\054\005\057\030")
_xc8.Description = ""
_xc8.AltText = ""
_xc8.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache 4.jpg", 
		Directives = {}
	}
}
_Eyz = Wherigo.ZMedia(_nPn)
_Eyz.Id = "b069b6c0-44fe-4184-838f-1e51210d8b16"
_Eyz.Name = _6tMT("\020\122\035\005\057\048")
_Eyz.Description = ""
_Eyz.AltText = ""
_Eyz.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 6.jpg", 
		Directives = {}
	}
}
_F2d7 = Wherigo.ZMedia(_nPn)
_F2d7.Id = "0c1877ca-b873-447a-9edc-96cef3a2888c"
_F2d7.Name = _6tMT("\020\122\035\005\057\019")
_F2d7.Description = ""
_F2d7.AltText = ""
_F2d7.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 7.jpg", 
		Directives = {}
	}
}
_g6F = Wherigo.ZMedia(_nPn)
_g6F.Id = "a4521f66-743d-4f04-bb41-5426c62f8b21"
_g6F.Name = _6tMT("\001\122\126\035\078\057\126\035\078\005\033\033\122\096\026\078\126\122\035")
_g6F.Description = ""
_g6F.AltText = ""
_g6F.Resources = {
	{
		Type = "jpg", 
		Filename = "telecharge.jpg", 
		Directives = {}
	}
}
_l6Lh7 = Wherigo.ZMedia(_nPn)
_l6Lh7.Id = "4a14ef09-bd1c-4a58-b1c0-204ec14202d4"
_l6Lh7.Name = _6tMT("\103\026\126\089\122\035\057\017\054\005\068\026\021\126\005\033")
_l6Lh7.Description = ""
_l6Lh7.AltText = ""
_l6Lh7.Resources = {
	{
		Type = "jpg", 
		Filename = "maison chevalier.jpg", 
		Directives = {}
	}
}
_6ABJQ = Wherigo.ZMedia(_nPn)
_6ABJQ.Id = "0003d7eb-d31e-44bb-a986-af862157b2d1"
_6ABJQ.Name = _6tMT("\103\026\126\089\122\035\057\089\005\033\068\126\078\005\032\033")
_6ABJQ.Description = ""
_6ABJQ.AltText = ""
_6ABJQ.Resources = {
	{
		Type = "jpg", 
		Filename = "maison serviteur.jpg", 
		Directives = {}
	}
}
_dFr7 = Wherigo.ZMedia(_nPn)
_dFr7.Id = "d38c41ed-50dd-40a9-9e21-7c7ace4c2350"
_dFr7.Name = _6tMT("\109\033\026\001\005\026\032")
_dFr7.Description = ""
_dFr7.AltText = ""
_dFr7.Resources = {
	{
		Type = "jpg", 
		Filename = "drapeau.jpg", 
		Directives = {}
	}
}
_Ntc1 = Wherigo.ZMedia(_nPn)
_Ntc1.Id = "b29a51ae-0b95-47c7-87d4-de4624c0e607"
_Ntc1.Name = _6tMT("\020\122\035\005\057\091")
_Ntc1.Description = ""
_Ntc1.AltText = ""
_Ntc1.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 8.jpg", 
		Directives = {}
	}
}
_Abj = Wherigo.ZMedia(_nPn)
_Abj.Id = "58fc00e2-b125-4cd2-96bc-1d4c5a291c11"
_Abj.Name = _6tMT("\001\122\033\078\005\057\017\026\017\054\005\057\106")
_Abj.Description = ""
_Abj.AltText = ""
_Abj.Resources = {
	{
		Type = "jpg", 
		Filename = "entree cache 1.jpg", 
		Directives = {}
	}
}
_ZQz = Wherigo.ZMedia(_nPn)
_ZQz.Id = "caaa51a2-7326-4292-a6ce-f549dda36d6f"
_ZQz.Name = _6tMT("\020\122\035\005\057\073")
_ZQz.Description = ""
_ZQz.AltText = ""
_ZQz.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 9.jpg", 
		Directives = {}
	}
}
_zIh = Wherigo.ZMedia(_nPn)
_zIh.Id = "8ddfbb09-6665-4ebb-b041-5065fb39f3a4"
_zIh.Name = _6tMT("\020\122\035\005\057\106\097")
_zIh.Description = ""
_zIh.AltText = ""
_zIh.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 10.jpg", 
		Directives = {}
	}
}
_IKha = Wherigo.ZMedia(_nPn)
_IKha.Id = "215f5dab-7146-4cff-87ff-0b87e2e8128a"
_IKha.Name = _6tMT("\020\122\035\005\057\106\106")
_IKha.Description = ""
_IKha.AltText = ""
_IKha.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 11.jpg", 
		Directives = {}
	}
}
_uc5c = Wherigo.ZMedia(_nPn)
_uc5c.Id = "4778c715-1576-41a3-9bd8-be49d73ee36f"
_uc5c.Name = _6tMT("\020\122\035\005\057\106\009")
_uc5c.Description = ""
_uc5c.AltText = ""
_uc5c.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 12.jpg", 
		Directives = {}
	}
}
_TTBvW = Wherigo.ZMedia(_nPn)
_TTBvW.Id = "4e1217fa-b3d7-46e2-b7cc-a03b3dd77697"
_TTBvW.Name = _6tMT("\020\122\035\005\057\106\087")
_TTBvW.Description = ""
_TTBvW.AltText = ""
_TTBvW.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 13.jpg", 
		Directives = {}
	}
}
_LDM = Wherigo.ZMedia(_nPn)
_LDM.Id = "7cc0a35c-ad51-4b6a-b9d3-5e418175bc9f"
_LDM.Name = _6tMT("\017\026\017\054\005\057\001\005\018\122")
_LDM.Description = ""
_LDM.AltText = ""
_LDM.Resources = {
	{
		Type = "jpg", 
		Filename = "cache peyo.jpg", 
		Directives = {}
	}
}
_97EJ = Wherigo.ZMedia(_nPn)
_97EJ.Id = "3d01fc74-a641-4ce3-a5db-0d661bd5e477"
_97EJ.Name = _6tMT("\020\122\035\005\057\017\026\017\054\005\057\009")
_97EJ.Description = ""
_97EJ.AltText = ""
_97EJ.Resources = {
	{
		Type = "jpg", 
		Filename = "zone cache 2.jpg", 
		Directives = {}
	}
}
_55oat = Wherigo.ZMedia(_nPn)
_55oat.Id = "0aa7c0a9-62ff-4842-84e8-0bd0f56860a8"
_55oat.Name = _6tMT("\078\033\005\089\122\033")
_55oat.Description = ""
_55oat.AltText = ""
_55oat.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache.jpg", 
		Directives = {}
	}
}
_hGK = Wherigo.ZMedia(_nPn)
_hGK.Id = "f095c35f-6445-4327-8978-d8746f09d89d"
_hGK.Name = _6tMT("\020\122\035\005\057\106\048")
_hGK.Description = ""
_hGK.AltText = ""
_hGK.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 16.jpg", 
		Directives = {}
	}
}
_RYMl0 = Wherigo.ZMedia(_nPn)
_RYMl0.Id = "858a340d-9ae6-49ab-b090-07af6ad8cab7"
_RYMl0.Name = _6tMT("\020\122\035\005\057\106\030")
_RYMl0.Description = ""
_RYMl0.AltText = ""
_RYMl0.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 14.jpg", 
		Directives = {}
	}
}
_7nL = Wherigo.ZMedia(_nPn)
_7nL.Id = "96914d42-e389-4a4f-8e4a-ee909611f731"
_7nL.Name = _6tMT("\020\122\035\005\057\106\043")
_7nL.Description = ""
_7nL.AltText = ""
_7nL.Resources = {
	{
		Type = "jpg", 
		Filename = "zone 15.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_nPn.Id="fd973eca-e770-42fe-8da6-1d255433813e"
_nPn.Name="Navarrenx"
_nPn.Description=[[Avec cette cartouche  vous aurez la possibilite de trouver 4 caches  liees a la Wherigo ainsi que la cache Mystery de Peyo GC28F00, tout cela sur un parcours de 3000 metres qui vous fera decouvrir la ville fortifiee de Navarrenx .Pour cette cache vous aurez imperativement  besoin d'une boussole et d'une lampe de poche et d'un crayon
Bonne promenade !!
]]
_nPn.Visible=true
_nPn.Activity="TourGuide"
_nPn.StartingLocationDescription=[[]]
_nPn.StartingLocation = ZonePoint(43.3238905210811,-0.758247719947485,0)
_nPn.Version="1.0"
_nPn.Company=""
_nPn.Author="Ossau 64"
_nPn.BuilderVersion="URWIGO 1.2.3718.30064"
_nPn.CreateDate="10/31/2010 17:36:05"
_nPn.PublishDate="1/1/0001 12:00:00 AM"
_nPn.UpdateDate="12/30/2010 10:31:09"
_nPn.LastPlayedDate="1/1/0001 12:00:00 AM"
_nPn.TargetDevice="PocketPC"
_nPn.TargetDeviceVersion="0"
_nPn.StateId="1"
_nPn.CountryId="2"
_nPn.Complete=false
_nPn.UseLogging=true

_nPn.Media=_v0j

_nPn.Icon=_WOV


-- Zones --
_BLD = Wherigo.Zone(_nPn)
_BLD.Id = "da36c8d7-cbc9-4242-9004-b2e0b037ef02"
_BLD.Name = _6tMT("\020\122\035\005\057\009")
_BLD.Description = ""
_BLD.Visible = false
_BLD.Media = _g6F
_BLD.Commands = {}
_BLD.DistanceRange = Distance(-1, "feet")
_BLD.ShowObjects = "OnEnter"
_BLD.ProximityRange = Distance(20, "meters")
_BLD.AllowSetPositionTo = false
_BLD.Active = false
_BLD.Points = {
	ZonePoint(43.3238014645936, -0.759573061342236, 0), 
	ZonePoint(43.3238404900676, -0.759640116567608, 0), 
	ZonePoint(43.323895125689, -0.759527463788983, 0), 
	ZonePoint(43.3237975620448, -0.759444315309521, 0), 
	ZonePoint(43.3237448776118, -0.759642798776623, 0), 
	ZonePoint(43.3238424413406, -0.759637434358593, 0)
}
_BLD.OriginalPoint = ZonePoint(43.3238203268912, -0.759577531690594, 0)
_BLD.DistanceRangeUOM = "Feet"
_BLD.ProximityRangeUOM = "Meters"
_BLD.OutOfRangeName = ""
_BLD.InRangeName = ""
_zH78P = Wherigo.Zone(_nPn)
_zH78P.Id = "bd70615a-b0c7-4246-8153-1bb298a2d59a"
_zH78P.Name = _6tMT("\064\026\126\089\122\035\057\109\032\057\017\054\005\068\026\021\126\005\033\057")
_zH78P.Description = ""
_zH78P.Visible = false
_zH78P.Media = _l6Lh7
_zH78P.Commands = {}
_zH78P.DistanceRange = Distance(-1, "feet")
_zH78P.ShowObjects = "OnEnter"
_zH78P.ProximityRange = Distance(20, "meters")
_zH78P.AllowSetPositionTo = false
_zH78P.Active = false
_zH78P.Points = {
	ZonePoint(43.32374, -0.75902, 0), 
	ZonePoint(43.3237917087999, -0.758916734952919, 0), 
	ZonePoint(43.3236707296519, -0.758814811010353, 0), 
	ZonePoint(43.3235965810227, -0.758948921461098, 0)
}
_zH78P.OriginalPoint = ZonePoint(43.3236997548686, -0.758925116856092, 0)
_zH78P.DistanceRangeUOM = "Feet"
_zH78P.ProximityRangeUOM = "Meters"
_zH78P.OutOfRangeName = ""
_zH78P.InRangeName = ""
_NgJc = Wherigo.Zone(_nPn)
_NgJc.Id = "e75c9423-d5eb-4bc9-a071-e0af04a2fac6"
_NgJc.Name = _6tMT("\020\122\035\005\057\106")
_NgJc.Description = ""
_NgJc.Visible = false
_NgJc.Media = _g6F
_NgJc.Commands = {}
_NgJc.DistanceRange = Distance(-1, "feet")
_NgJc.ShowObjects = "OnEnter"
_NgJc.ProximityRange = Distance(20, "meters")
_NgJc.AllowSetPositionTo = false
_NgJc.Active = false
_NgJc.Points = {
	ZonePoint(43.3242782920494, -0.759340845403678, 0), 
	ZonePoint(43.3243192684748, -0.759448133764273, 0), 
	ZonePoint(43.3241582895018, -0.759433381614691, 0), 
	ZonePoint(43.3242168273595, -0.759191982803351, 0), 
	ZonePoint(43.3242821945673, -0.759244285879142, 0), 
	ZonePoint(43.3243407323057, -0.759319387731558, 0), 
	ZonePoint(43.3243290247625, -0.759448133764273, 0)
}
_NgJc.OriginalPoint = ZonePoint(43.324274947003, -0.759346592994424, 0)
_NgJc.DistanceRangeUOM = "Feet"
_NgJc.ProximityRangeUOM = "Meters"
_NgJc.OutOfRangeName = ""
_NgJc.InRangeName = ""
_BY5T = Wherigo.Zone(_nPn)
_BY5T.Id = "5281d772-5f2f-42a7-8ded-bdd22030ed90"
_BY5T.Name = _6tMT("\020\122\035\005\057\043")
_BY5T.Description = ""
_BY5T.Visible = false
_BY5T.Media = _g6F
_BY5T.Commands = {}
_BY5T.DistanceRange = Distance(-1, "feet")
_BY5T.ShowObjects = "OnEnter"
_BY5T.ProximityRange = Distance(19, "meters")
_BY5T.AllowSetPositionTo = false
_BY5T.Active = false
_BY5T.Points = {
	ZonePoint(43.3222065862695, -0.758550379133218, 0), 
	ZonePoint(43.3221626814287, -0.758703265047067, 0), 
	ZonePoint(43.3222748826254, -0.758746180391305, 0), 
	ZonePoint(43.3223100064357, -0.758606705522531, 0), 
	ZonePoint(43.3222953715172, -0.758528921461099, 0), 
	ZonePoint(43.3222504910785, -0.758459184026712, 0), 
	ZonePoint(43.3221743893893, -0.758445772981637, 0), 
	ZonePoint(43.3221412168283, -0.75850746378898, 0), 
	ZonePoint(43.322117800892, -0.758593294477456, 0), 
	ZonePoint(43.3221587787746, -0.758697900629037, 0)
}
_BY5T.OriginalPoint = ZonePoint(43.3222092205239, -0.758583906745904, 0)
_BY5T.DistanceRangeUOM = "Feet"
_BY5T.ProximityRangeUOM = "Meters"
_BY5T.OutOfRangeName = ""
_BY5T.InRangeName = ""
_Mm3y = Wherigo.Zone(_nPn)
_Mm3y.Id = "9e35ef5b-5a1d-4b1e-a248-8db24dcd13ea"
_Mm3y.Name = _6tMT("\020\122\035\005\057\087")
_Mm3y.Description = ""
_Mm3y.Visible = false
_Mm3y.Media = _g6F
_Mm3y.Commands = {}
_Mm3y.DistanceRange = Distance(-1, "feet")
_Mm3y.ShowObjects = "OnEnter"
_Mm3y.ProximityRange = Distance(20, "meters")
_Mm3y.AllowSetPositionTo = false
_Mm3y.Active = false
_Mm3y.Points = {
	ZonePoint(43.32311, -0.75915, 0), 
	ZonePoint(43.3232065891017, -0.759191574239728, 0), 
	ZonePoint(43.3232202481542, -0.759089650297162, 0), 
	ZonePoint(43.3231285373143, -0.75902259507179, 0), 
	ZonePoint(43.3230860966127, -0.759089650297162, 0), 
	ZonePoint(43.3230412167582, -0.759108425760266, 0), 
	ZonePoint(43.3230997556924, -0.759239854001996, 0), 
	ZonePoint(43.3232051256316, -0.759196938657758, 0)
}
_Mm3y.OriginalPoint = ZonePoint(43.3231371961581, -0.759136086040733, 0)
_Mm3y.DistanceRangeUOM = "Feet"
_Mm3y.ProximityRangeUOM = "Meters"
_Mm3y.OutOfRangeName = ""
_Mm3y.InRangeName = ""
_m_r = Wherigo.Zone(_nPn)
_m_r.Id = "c2cfe8c7-f112-4c30-8359-beb308a5f997"
_m_r.Name = _6tMT("\020\122\035\005\057\030")
_m_r.Description = ""
_m_r.Visible = false
_m_r.Media = _g6F
_m_r.Commands = {}
_m_r.DistanceRange = Distance(-1, "feet")
_m_r.ShowObjects = "OnEnter"
_m_r.ProximityRange = Distance(19, "meters")
_m_r.AllowSetPositionTo = false
_m_r.Active = false
_m_r.Points = {
	ZonePoint(43.3229, -0.75807, 0), 
	ZonePoint(43.3229063417353, -0.758196063823706, 0), 
	ZonePoint(43.3228190208599, -0.758141078538901, 0), 
	ZonePoint(43.322817069554, -0.75803110796929, 0), 
	ZonePoint(43.3229024391291, -0.757981487102515, 0), 
	ZonePoint(43.3229707347027, -0.758048542327887, 0), 
	ZonePoint(43.32299219901, -0.758147784061438, 0), 
	ZonePoint(43.3229063417353, -0.758198746032721, 0)
}
_m_r.OriginalPoint = ZonePoint(43.3229017683408, -0.758101851232057, 0)
_m_r.DistanceRangeUOM = "Feet"
_m_r.ProximityRangeUOM = "Meters"
_m_r.OutOfRangeName = ""
_m_r.InRangeName = ""
_CcS4 = Wherigo.Zone(_nPn)
_CcS4.Id = "9134f59d-1638-4a33-9aee-8fd0f8548c32"
_CcS4.Name = _6tMT("\020\122\035\005\057\048")
_CcS4.Description = ""
_CcS4.Visible = true
_CcS4.Media = _Eyz
_CcS4.Commands = {}
_CcS4.DistanceRange = Distance(-1, "feet")
_CcS4.ShowObjects = "OnEnter"
_CcS4.ProximityRange = Distance(60, "meters")
_CcS4.AllowSetPositionTo = false
_CcS4.Active = false
_CcS4.Points = {
	ZonePoint(43.32109, -0.75839, 0), 
	ZonePoint(43.3211475651344, -0.758463760747914, 0), 
	ZonePoint(43.3211865923132, -0.758361836805348, 0), 
	ZonePoint(43.3211143920128, -0.758289417161946, 0)
}
_CcS4.OriginalPoint = ZonePoint(43.3211346373651, -0.758376253678802, 0)
_CcS4.DistanceRangeUOM = "Feet"
_CcS4.ProximityRangeUOM = "Meters"
_CcS4.OutOfRangeName = ""
_CcS4.InRangeName = ""
_ItA = Wherigo.Zone(_nPn)
_ItA.Id = "204daf84-ff2c-46e7-8579-7cec3ec0e213"
_ItA.Name = _6tMT("\020\122\035\005\057\019")
_ItA.Description = ""
_ItA.Visible = true
_ItA.Media = _F2d7
_ItA.Commands = {}
_ItA.DistanceRange = Distance(-1, "feet")
_ItA.ShowObjects = "OnEnter"
_ItA.ProximityRange = Distance(60, "meters")
_ItA.AllowSetPositionTo = false
_ItA.Active = false
_ItA.Points = {
	ZonePoint(43.32126, -0.75876, 0), 
	ZonePoint(43.3213331758042, -0.75876134110451, 0), 
	ZonePoint(43.3213273217431, -0.758710379133227, 0), 
	ZonePoint(43.3212414621156, -0.758696968088153, 0)
}
_ItA.OriginalPoint = ZonePoint(43.3212904899157, -0.758732172081473, 0)
_ItA.DistanceRangeUOM = "Feet"
_ItA.ProximityRangeUOM = "Meters"
_ItA.OutOfRangeName = ""
_ItA.InRangeName = ""
_LXp = Wherigo.Zone(_nPn)
_LXp.Id = "8a550910-c397-41e0-aacd-db0197e01da7"
_LXp.Name = _6tMT("\020\122\035\005\057\091")
_LXp.Description = ""
_LXp.Visible = true
_LXp.Media = _Ntc1
_LXp.Commands = {}
_LXp.DistanceRange = Distance(-1, "feet")
_LXp.ShowObjects = "OnEnter"
_LXp.ProximityRange = Distance(60, "meters")
_LXp.AllowSetPositionTo = false
_LXp.Active = false
_LXp.Points = {
	ZonePoint(43.3205746353365, -0.759329387731547, 0), 
	ZonePoint(43.3205141425894, -0.759431311674112, 0), 
	ZonePoint(43.3205961004904, -0.759439358301157, 0), 
	ZonePoint(43.3206370793994, -0.759350845403666, 0)
}
_LXp.OriginalPoint = ZonePoint(43.3205804894539, -0.759387725777621, 0)
_LXp.DistanceRangeUOM = "Feet"
_LXp.ProximityRangeUOM = "Meters"
_LXp.OutOfRangeName = ""
_LXp.InRangeName = ""
_3du = Wherigo.Zone(_nPn)
_3du.Id = "2ecfb7d4-f7b3-4e08-bd58-c67186d16e5c"
_3du.Name = _6tMT("\127\026\017\054\005\057\106")
_3du.Description = ""
_3du.Visible = false
_3du.Media = _Abj
_3du.Commands = {}
_3du.DistanceRange = Distance(-1, "feet")
_3du.ShowObjects = "OnEnter"
_3du.ProximityRange = Distance(60, "meters")
_3du.AllowSetPositionTo = false
_3du.Active = false
_3du.Points = {
	ZonePoint(43.3206253744136, -0.759311457672109, 0), 
	ZonePoint(43.3206204959726, -0.759253790178289, 0), 
	ZonePoint(43.3205756142966, -0.75924306134223, 0), 
	ZonePoint(43.3205463436205, -0.759312798776617, 0)
}
_3du.OriginalPoint = ZonePoint(43.3205919570758, -0.759280276992311, 0)
_3du.DistanceRangeUOM = "Feet"
_3du.ProximityRangeUOM = "Meters"
_3du.OutOfRangeName = ""
_3du.InRangeName = ""
_pJOI = Wherigo.Zone(_nPn)
_pJOI.Id = "68c19e28-b6ba-4b5e-b709-aecd90deee68"
_pJOI.Name = _6tMT("\020\122\035\005\057\073")
_pJOI.Description = ""
_pJOI.Visible = true
_pJOI.Media = _ZQz
_pJOI.Commands = {}
_pJOI.DistanceRange = Distance(-1, "feet")
_pJOI.ShowObjects = "OnEnter"
_pJOI.ProximityRange = Distance(60, "meters")
_pJOI.AllowSetPositionTo = false
_pJOI.Active = false
_pJOI.Points = {
	ZonePoint(43.3205721977463, -0.760360612268449, 0), 
	ZonePoint(43.320593662901, -0.760422303075792, 0), 
	ZonePoint(43.3205370729313, -0.760433031911851, 0), 
	ZonePoint(43.3205273160346, -0.760293557043077, 0), 
	ZonePoint(43.3205956142783, -0.760309650297166, 0)
}
_pJOI.OriginalPoint = ZonePoint(43.3205651727783, -0.760363830919267, 0)
_pJOI.DistanceRangeUOM = "Feet"
_pJOI.ProximityRangeUOM = "Meters"
_pJOI.OutOfRangeName = ""
_pJOI.InRangeName = ""
_cE8 = Wherigo.Zone(_nPn)
_cE8.Id = "70e490bf-b81b-4589-be3d-3ce078aa698a"
_cE8.Name = _6tMT("\020\122\035\005\057\106\097")
_cE8.Description = ""
_cE8.Visible = true
_cE8.Media = _zIh
_cE8.Commands = {}
_cE8.DistanceRange = Distance(-1, "feet")
_cE8.ShowObjects = "OnEnter"
_cE8.ProximityRange = Distance(60, "meters")
_cE8.AllowSetPositionTo = false
_cE8.Active = false
_cE8.Points = {
	ZonePoint(43.32149, -0.76044, 0), 
	ZonePoint(43.3215378080211, -0.760489620866773, 0), 
	ZonePoint(43.3214909756743, -0.760548629465101, 0), 
	ZonePoint(43.32143243519, -0.760497667493818, 0)
}
_cE8.OriginalPoint = ZonePoint(43.3214878047213, -0.760493979456423, 0)
_cE8.DistanceRangeUOM = "Feet"
_cE8.ProximityRangeUOM = "Meters"
_cE8.OutOfRangeName = ""
_cE8.InRangeName = ""
_oTfZm = Wherigo.Zone(_nPn)
_oTfZm.Id = "42a811af-6d21-425e-aaa7-aa48749aa239"
_oTfZm.Name = _6tMT("\020\122\035\005\057\106\009")
_oTfZm.Description = ""
_oTfZm.Visible = true
_oTfZm.Media = _uc5c
_oTfZm.Commands = {}
_oTfZm.DistanceRange = Distance(-1, "feet")
_oTfZm.ShowObjects = "OnEnter"
_oTfZm.ProximityRange = Distance(60, "meters")
_oTfZm.AllowSetPositionTo = false
_oTfZm.Active = false
_oTfZm.Points = {
	ZonePoint(43.32237, -0.76266, 0), 
	ZonePoint(43.3223631703786, -0.762701574239739, 0), 
	ZonePoint(43.3223104847016, -0.762645247850426, 0), 
	ZonePoint(43.3223436571702, -0.762602332506188, 0)
}
_oTfZm.OriginalPoint = ZonePoint(43.3223468280626, -0.762652288649088, 0)
_oTfZm.DistanceRangeUOM = "Feet"
_oTfZm.ProximityRangeUOM = "Meters"
_oTfZm.OutOfRangeName = ""
_oTfZm.InRangeName = ""
_PtmE = Wherigo.Zone(_nPn)
_PtmE.Id = "c1e9b8de-e5ab-4842-b085-351fe0f8909b"
_PtmE.Name = _6tMT("\020\122\035\005\057\106\106")
_PtmE.Description = ""
_PtmE.Visible = true
_PtmE.Media = _IKha
_PtmE.Commands = {}
_PtmE.DistanceRange = Distance(-1, "feet")
_PtmE.ShowObjects = "OnEnter"
_PtmE.ProximityRange = Distance(60, "meters")
_PtmE.AllowSetPositionTo = false
_PtmE.Active = false
_PtmE.Points = {
	ZonePoint(43.3222087809653, -0.762859883432394, 0), 
	ZonePoint(43.3222478074624, -0.762833061342245, 0), 
	ZonePoint(43.3222341481913, -0.762757959489828, 0), 
	ZonePoint(43.3221795110761, -0.762816968088156, 0)
}
_PtmE.OriginalPoint = ZonePoint(43.3222175619238, -0.762816968088156, 0)
_PtmE.DistanceRangeUOM = "Feet"
_PtmE.ProximityRangeUOM = "Meters"
_PtmE.OutOfRangeName = ""
_PtmE.InRangeName = ""
_nsFoa = Wherigo.Zone(_nPn)
_nsFoa.Id = "db4906a3-82d8-484e-bbaf-cf2f1078c12e"
_nsFoa.Name = _6tMT("\064\026\126\089\122\035\057\109\032\057\089\005\033\068\126\078\005\032\033\057")
_nsFoa.Description = ""
_nsFoa.Visible = false
_nsFoa.Media = _6ABJQ
_nsFoa.Commands = {}
_nsFoa.DistanceRange = Distance(-1, "feet")
_nsFoa.ShowObjects = "OnEnter"
_nsFoa.ProximityRange = Distance(10, "meters")
_nsFoa.AllowSetPositionTo = false
_nsFoa.Active = false
_nsFoa.Points = {
	ZonePoint(43.3231503139369, -0.758832441512731, 0), 
	ZonePoint(43.3232127553525, -0.758891450111059, 0), 
	ZonePoint(43.3232361708668, -0.758784161750463, 0), 
	ZonePoint(43.3231151906124, -0.758644686881689, 0), 
	ZonePoint(43.3230488464997, -0.758794890586523, 0), 
	ZonePoint(43.3231425087554, -0.758939729873327, 0)
}
_nsFoa.OriginalPoint = ZonePoint(43.3231509643373, -0.758814560119299, 0)
_nsFoa.DistanceRangeUOM = "Feet"
_nsFoa.ProximityRangeUOM = "Meters"
_nsFoa.OutOfRangeName = ""
_nsFoa.InRangeName = ""
_s8AB = Wherigo.Zone(_nPn)
_s8AB.Id = "a5800dc3-0928-426b-915b-d6a758a53076"
_s8AB.Name = _6tMT("\013\005\001\026\033\078")
_s8AB.Description = ""
_s8AB.Visible = true
_s8AB.Media = _dFr7
_s8AB.Commands = {}
_s8AB.DistanceRange = Distance(-1, "feet")
_s8AB.ShowObjects = "OnEnter"
_s8AB.ProximityRange = Distance(60, "meters")
_s8AB.AllowSetPositionTo = false
_s8AB.Active = false
_s8AB.Points = {
	ZonePoint(43.32374, -0.75902, 0), 
	ZonePoint(43.3237741473257, -0.758914052743904, 0), 
	ZonePoint(43.323664875816, -0.758855044145577, 0), 
	ZonePoint(43.3236219476692, -0.758943557043068, 0)
}
_s8AB.OriginalPoint = ZonePoint(43.3237002427027, -0.758933163483137, 0)
_s8AB.DistanceRangeUOM = "Feet"
_s8AB.ProximityRangeUOM = "Meters"
_s8AB.OutOfRangeName = ""
_s8AB.InRangeName = ""
_YdF9 = Wherigo.Zone(_nPn)
_YdF9.Id = "a1865e51-6681-41e4-846a-895a3a95c8e1"
_YdF9.Name = _6tMT("\020\122\035\005\057\106\087")
_YdF9.Description = ""
_YdF9.Visible = true
_YdF9.Media = _TTBvW
_YdF9.Commands = {}
_YdF9.DistanceRange = Distance(-1, "feet")
_YdF9.ShowObjects = "OnEnter"
_YdF9.ProximityRange = Distance(60, "meters")
_YdF9.AllowSetPositionTo = false
_YdF9.Active = false
_YdF9.Points = {
	ZonePoint(43.32301, -0.762619, 0), 
	ZonePoint(43.3230343912419, -0.762665938657754, 0), 
	ZonePoint(43.3229758522448, -0.762663256448739, 0), 
	ZonePoint(43.3229621931374, -0.762580107969277, 0)
}
_YdF9.OriginalPoint = ZonePoint(43.322995609156, -0.762632075768942, 0)
_YdF9.DistanceRangeUOM = "Feet"
_YdF9.ProximityRangeUOM = "Meters"
_YdF9.OutOfRangeName = ""
_YdF9.InRangeName = ""
_Nfp_ = Wherigo.Zone(_nPn)
_Nfp_.Id = "6717871b-4ed1-4bf6-a20a-a2bf24eafd71"
_Nfp_.Name = _6tMT("\127\026\017\054\005\057\009")
_Nfp_.Description = ""
_Nfp_.Visible = true
_Nfp_.Media = _55oat
_Nfp_.Commands = {}
_Nfp_.DistanceRange = Distance(-1, "feet")
_Nfp_.ShowObjects = "OnEnter"
_Nfp_.ProximityRange = Distance(60, "meters")
_Nfp_.AllowSetPositionTo = false
_Nfp_.Active = false
_Nfp_.Points = {
	ZonePoint(43.32307, -0.76258, 0), 
	ZonePoint(43.3230534139663, -0.76260816319466, 0), 
	ZonePoint(43.3230241444839, -0.762562565641407, 0), 
	ZonePoint(43.3230475600709, -0.762525014715199, 0)
}
_Nfp_.OriginalPoint = ZonePoint(43.3230487796303, -0.762568935887816, 0)
_Nfp_.DistanceRangeUOM = "Feet"
_Nfp_.ProximityRangeUOM = "Meters"
_Nfp_.OutOfRangeName = ""
_Nfp_.InRangeName = ""
_8Kt = Wherigo.Zone(_nPn)
_8Kt.Id = "33ffc496-60f8-4e6d-a44b-ac300f74d245"
_8Kt.Name = _6tMT("\017\026\017\054\005\057\001\005\018\122")
_8Kt.Description = ""
_8Kt.Visible = true
_8Kt.Media = _55oat
_8Kt.Commands = {}
_8Kt.DistanceRange = Distance(-1, "feet")
_8Kt.ShowObjects = "OnEnter"
_8Kt.ProximityRange = Distance(60, "meters")
_8Kt.AllowSetPositionTo = false
_8Kt.Active = false
_8Kt.Points = {
	ZonePoint(43.32373, -0.76024, 0), 
	ZonePoint(43.3237251218083, -0.760319125165936, 0), 
	ZonePoint(43.3236587783616, -0.760249387731549, 0), 
	ZonePoint(43.3236841449821, -0.760150145997998, 0), 
	ZonePoint(43.3237407320205, -0.760152828207012, 0), 
	ZonePoint(43.323737805106, -0.760195743551251, 0)
}
_8Kt.OriginalPoint = ZonePoint(43.3237127637131, -0.760217871775624, 0)
_8Kt.DistanceRangeUOM = "Feet"
_8Kt.ProximityRangeUOM = "Meters"
_8Kt.OutOfRangeName = ""
_8Kt.InRangeName = ""
_uGzp = Wherigo.Zone(_nPn)
_uGzp.Id = "c7072df9-d572-48e5-8bb4-b8c46842decb"
_uGzp.Name = _6tMT("\127\026\017\054\005\057\087")
_uGzp.Description = ""
_uGzp.Visible = false
_uGzp.Media = _55oat
_uGzp.Commands = {}
_uGzp.DistanceRange = Distance(-1, "feet")
_uGzp.ShowObjects = "OnEnter"
_uGzp.ProximityRange = Distance(60, "meters")
_uGzp.AllowSetPositionTo = false
_uGzp.Active = false
_uGzp.Points = {
	ZonePoint(43.32268, -0.75911, 0), 
	ZonePoint(43.3226126797557, -0.759073790178304, 0), 
	ZonePoint(43.3226556086158, -0.759022828207021, 0), 
	ZonePoint(43.3227219531579, -0.759046968088155, 0)
}
_uGzp.OriginalPoint = ZonePoint(43.3226675603823, -0.75906339661837, 0)
_uGzp.DistanceRangeUOM = "Feet"
_uGzp.ProximityRangeUOM = "Meters"
_uGzp.OutOfRangeName = ""
_uGzp.InRangeName = ""
_3PKz = Wherigo.Zone(_nPn)
_3PKz.Id = "bedb0501-85b4-4588-b6db-c7b8a2446327"
_3PKz.Name = _6tMT("\127\026\017\054\005\057\030")
_3PKz.Description = ""
_3PKz.Visible = false
_3PKz.Media = _55oat
_3PKz.Commands = {}
_3PKz.DistanceRange = Distance(-1, "feet")
_3PKz.ShowObjects = "OnEnter"
_3PKz.ProximityRange = Distance(60, "meters")
_3PKz.AllowSetPositionTo = false
_3PKz.Active = false
_3PKz.Points = {
	ZonePoint(43.3246, -0.76016, 0), 
	ZonePoint(43.3245619506389, -0.760196209821693, 0), 
	ZonePoint(43.3245385356356, -0.760131836805336, 0), 
	ZonePoint(43.3245970731269, -0.760075510416023, 0)
}
_3PKz.OriginalPoint = ZonePoint(43.3245743898503, -0.760140889260763, 0)
_3PKz.DistanceRangeUOM = "Feet"
_3PKz.ProximityRangeUOM = "Meters"
_3PKz.OutOfRangeName = ""
_3PKz.InRangeName = ""
_9eAI = Wherigo.Zone(_nPn)
_9eAI.Id = "94dd3471-f602-4312-b137-3af1afedf39b"
_9eAI.Name = _6tMT("\020\122\035\005\057\106\043")
_9eAI.Description = ""
_9eAI.Visible = false
_9eAI.Media = _hGK
_9eAI.Commands = {}
_9eAI.DistanceRange = Distance(-1, "feet")
_9eAI.ShowObjects = "OnEnter"
_9eAI.ProximityRange = Distance(60, "meters")
_9eAI.AllowSetPositionTo = false
_9eAI.Active = false
_9eAI.Points = {
	ZonePoint(43.3244287806444, -0.760098658895496, 0), 
	ZonePoint(43.3244795132318, -0.760146938657764, 0), 
	ZonePoint(43.3244970745022, -0.760074519014362, 0), 
	ZonePoint(43.32445804945, -0.760028921461109, 0)
}
_9eAI.OriginalPoint = ZonePoint(43.3244658544571, -0.760087259507183, 0)
_9eAI.DistanceRangeUOM = "Feet"
_9eAI.ProximityRangeUOM = "Meters"
_9eAI.OutOfRangeName = ""
_9eAI.InRangeName = ""
_UIHp5 = Wherigo.Zone(_nPn)
_UIHp5.Id = "7b81a810-c79e-4b65-82a8-38a7d7a4e043"
_UIHp5.Name = _6tMT("\020\122\035\005\057\106\030")
_UIHp5.Description = ""
_UIHp5.Visible = true
_UIHp5.Media = _RYMl0
_UIHp5.Commands = {}
_UIHp5.DistanceRange = Distance(-1, "feet")
_UIHp5.ShowObjects = "OnEnter"
_UIHp5.ProximityRange = Distance(60, "meters")
_UIHp5.AllowSetPositionTo = false
_UIHp5.Active = false
_UIHp5.Points = {
	ZonePoint(43.322949280231, -0.759175043568616, 0), 
	ZonePoint(43.3229726958468, -0.759097259507184, 0), 
	ZonePoint(43.3228400072377, -0.759027522072797, 0), 
	ZonePoint(43.3227931758947, -0.759099941716199, 0)
}
_UIHp5.OriginalPoint = ZonePoint(43.3228887898026, -0.759099941716199, 0)
_UIHp5.DistanceRangeUOM = "Feet"
_UIHp5.ProximityRangeUOM = "Meters"
_UIHp5.OutOfRangeName = ""
_UIHp5.InRangeName = ""

-- Characters --
_ctpgb = Wherigo.ZCharacter{
	Cartridge = _nPn, 
	Container = _s8AB
}
_ctpgb.Id = "b56b3d67-7b8e-4466-8c8c-91be1c33b607"
_ctpgb.Name = _6tMT("\092\026\033\021\005\033\057\026\068\005\017\057\021\005\057\068\026\021\005\078")
_ctpgb.Description = ""
_ctpgb.Visible = true
_ctpgb.Media = _WOV
_ctpgb.Commands = {
	Parler = Wherigo.ZCommand{
		Text = _6tMT("\092\026\033\021\005\033"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}
}
_ctpgb.Commands.Parler.Custom = true
_ctpgb.Commands.Parler.Id = "24c5e4b2-0023-4c97-95cc-aa6620827517"
_ctpgb.Commands.Parler.WorksWithAll = true
_ctpgb.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ctpgb.Gender = "Male"
_ctpgb.Type = "NPC"

-- Items --
_9ET = Wherigo.ZItem{
	Cartridge = _nPn, 
	Container = _NgJc
}
_9ET.Id = "251fd66c-de1b-4ee0-88cb-8222b5b5243c"
_9ET.Name = _6tMT("\017\122\062\062\033\005")
_9ET.Description = ""
_9ET.Visible = true
_9ET.Media = _V1zKe
_9ET.Icon = _V1zKe
_9ET.Commands = {
	prendre = Wherigo.ZCommand{
		Text = _6tMT("\001\033\005\035\109\033\005\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}, 
	laisser  = Wherigo.ZCommand{
		Text = _6tMT("\021\026\126\089\089\005\033\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}
}
_9ET.Commands.prendre.Custom = true
_9ET.Commands.prendre.Id = "5c207f95-3372-433c-a168-627bfe58856a"
_9ET.Commands.prendre.WorksWithAll = true
_9ET.Commands.laisser .Custom = true
_9ET.Commands.laisser .Id = "a0335f8e-1ae6-493b-b26f-d8d8a5dd4bb0"
_9ET.Commands.laisser .WorksWithAll = true
_9ET.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_9ET.Locked = false
_9ET.Opened = false
_SlO = Wherigo.ZItem{
	Cartridge = _nPn, 
	Container = _BY5T
}
_SlO.Id = "97f5c0b5-d847-418d-8a75-76a992de88d8"
_SlO.Name = _6tMT("\115\122\032\017\021\126\005\033")
_SlO.Description = ""
_SlO.Visible = true
_SlO.Media = _fZK9g
_SlO.Commands = {
	acheter  = Wherigo.ZCommand{
		Text = _6tMT("\026\017\054\005\078\005\033\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}, 
	laisser  = Wherigo.ZCommand{
		Text = _6tMT("\021\026\126\089\089\005\033\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}
}
_SlO.Commands.acheter .Custom = true
_SlO.Commands.acheter .Id = "d6a67546-69b3-4e51-90c1-08f2c8a779d9"
_SlO.Commands.acheter .WorksWithAll = true
_SlO.Commands.laisser .Custom = true
_SlO.Commands.laisser .Id = "a6cf4a23-657b-4444-9adf-9723d07dc093"
_SlO.Commands.laisser .WorksWithAll = true
_SlO.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SlO.Locked = false
_SlO.Opened = false
_05SZK = Wherigo.ZItem{
	Cartridge = _nPn, 
	Container = _Mm3y
}
_05SZK.Id = "22ea2578-e917-41be-8aaf-55de8d934c8a"
_05SZK.Name = _6tMT("\026\033\103\032\033\005")
_05SZK.Description = ""
_05SZK.Visible = true
_05SZK.Media = _CHL
_05SZK.Commands = {
	acheter  = Wherigo.ZCommand{
		Text = _6tMT("\026\017\054\005\078\005\033\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}, 
	laisser  = Wherigo.ZCommand{
		Text = _6tMT("\021\026\126\089\089\005\033\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}
}
_05SZK.Commands.acheter .Custom = true
_05SZK.Commands.acheter .Id = "8f5ba906-c332-41ca-b4fa-dbe0b7c58383"
_05SZK.Commands.acheter .WorksWithAll = true
_05SZK.Commands.laisser .Custom = true
_05SZK.Commands.laisser .Id = "86ce6d2a-0c4b-4b3f-b822-8a2a3f4e0585"
_05SZK.Commands.laisser .WorksWithAll = true
_05SZK.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_05SZK.Locked = false
_05SZK.Opened = false
_oPiaw = Wherigo.ZItem{
	Cartridge = _nPn, 
	Container = _BLD
}
_oPiaw.Id = "ca55a958-0a06-4658-9634-321380918a92"
_oPiaw.Name = _6tMT("\017\054\005\068\026\021")
_oPiaw.Description = ""
_oPiaw.Visible = true
_oPiaw.Media = _E87
_oPiaw.Icon = _E87
_oPiaw.Commands = {
	acheter  = Wherigo.ZCommand{
		Text = _6tMT("\026\017\054\005\078\005\033\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _6tMT("\122\032\126\057\122\032\126\057")
	}, 
	laisser  = Wherigo.ZCommand{
		Text = _6tMT("\021\026\126\089\089\005\033\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}
}
_oPiaw.Commands.acheter .Custom = true
_oPiaw.Commands.acheter .Id = "68d52594-5617-48d8-aca9-f8c797f853ee"
_oPiaw.Commands.acheter .WorksWithAll = true
_oPiaw.Commands.laisser .Custom = true
_oPiaw.Commands.laisser .Id = "7f7b00f4-114f-4781-8462-63b2d46f55be"
_oPiaw.Commands.laisser .WorksWithAll = true
_oPiaw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_oPiaw.Locked = false
_oPiaw.Opened = false
_IGq = Wherigo.ZItem{
	Cartridge = _nPn, 
	Container = _m_r
}
_IGq.Id = "29a01cad-df17-44a8-a443-213dea0f4b47"
_IGq.Name = _6tMT("\005\001\005\005")
_IGq.Description = ""
_IGq.Visible = true
_IGq.Media = _bMCxO
_IGq.Icon = _bMCxO
_IGq.Commands = {
	acheter  = Wherigo.ZCommand{
		Text = _6tMT("\026\017\054\005\078\005\033"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}, 
	laisser  = Wherigo.ZCommand{
		Text = _6tMT("\021\026\126\089\089\005\033"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _6tMT("\042\122\078\054\126\035\096\057\026\068\026\126\021\026\115\021\005")
	}
}
_IGq.Commands.acheter .Custom = true
_IGq.Commands.acheter .Id = "7d598f06-e9dd-42a8-9833-93db8f626f55"
_IGq.Commands.acheter .WorksWithAll = true
_IGq.Commands.laisser .Custom = true
_IGq.Commands.laisser .Id = "6ea604b5-d89c-45c5-8602-5cb1fd8f2787"
_IGq.Commands.laisser .WorksWithAll = true
_IGq.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_IGq.Locked = false
_IGq.Opened = false
_zvAQs = Wherigo.ZItem(_nPn)
_zvAQs.Id = "93dcf6dc-e077-441d-9d44-7ec6881b37fb"
_zvAQs.Name = _6tMT("\017\054\005\068\026\021\126\005\033")
_zvAQs.Description = ""
_zvAQs.Visible = true
_zvAQs.Media = _Xeipu
_zvAQs.Icon = _Xeipu
_zvAQs.Commands = {}
_zvAQs.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_zvAQs.Locked = false
_zvAQs.Opened = false
_jiJ = Wherigo.ZItem(_nPn)
_jiJ.Id = "8bec2538-490c-48be-9fba-0573c230fdc6"
_jiJ.Name = _6tMT("\017\026\017\054\005\057\106")
_jiJ.Description = ""
_jiJ.Visible = true
_jiJ.Media = _ZBFHP
_jiJ.Commands = {}
_jiJ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jiJ.Locked = false
_jiJ.Opened = false
_SgQg = Wherigo.ZItem(_nPn)
_SgQg.Id = "6d389a3b-a5da-4352-9f15-6800a7bfbca1"
_SgQg.Name = _6tMT("\017\026\017\054\005\057\009")
_SgQg.Description = ""
_SgQg.Visible = true
_SgQg.Media = _vvFDN
_SgQg.Commands = {}
_SgQg.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SgQg.Locked = false
_SgQg.Opened = false
_4X3 = Wherigo.ZItem(_nPn)
_4X3.Id = "611ec963-c5b2-43e1-8cdb-ccd9ab31146b"
_4X3.Name = _6tMT("\017\026\017\054\005\057\087")
_4X3.Description = ""
_4X3.Visible = true
_4X3.Media = _UFT
_4X3.Commands = {}
_4X3.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_4X3.Locked = false
_4X3.Opened = false
_11SPn = Wherigo.ZItem(_nPn)
_11SPn.Id = "be4dc2ea-8f0a-4304-8087-8b4e137de3ec"
_11SPn.Name = _6tMT("\017\026\017\054\005\057\030")
_11SPn.Description = ""
_11SPn.Visible = true
_11SPn.Media = _xc8
_11SPn.Commands = {}
_11SPn.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_11SPn.Locked = false
_11SPn.Opened = false
_yloVY = Wherigo.ZItem(_nPn)
_yloVY.Id = "9878bce6-2919-4f92-903b-774ba4bc6c08"
_yloVY.Name = _6tMT("\005\035\078\033\005\005\057\017\026\017\054\005\057\106")
_yloVY.Description = ""
_yloVY.Visible = true
_yloVY.Media = _Abj
_yloVY.Commands = {}
_yloVY.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_yloVY.Locked = false
_yloVY.Opened = false
_Bnc3x = Wherigo.ZItem(_nPn)
_Bnc3x.Id = "625bcf7b-ba5d-4868-b9ca-4aca81fb655b"
_Bnc3x.Name = _6tMT("\017\026\017\054\005\057\001\005\018\122")
_Bnc3x.Description = ""
_Bnc3x.Visible = true
_Bnc3x.Media = _LDM
_Bnc3x.Commands = {}
_Bnc3x.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Bnc3x.Locked = false
_Bnc3x.Opened = false

-- Tasks --
_9yWUJ = Wherigo.ZTask(_nPn)
_9yWUJ.Id = "490f45ac-5ca2-4936-9a98-12df9fa049e7"
_9yWUJ.Name = _6tMT("\031\033\122\032\068\005\033\057\021\026\057\103\026\126\089\122\035\057\109\032\057\089\005\033\068\126\078\005\032\033\057")
_9yWUJ.Description = _6tMT("\031\122\032\078\057\109\057\026\115\122\033\109\057\015\035\115\089\001\101\126\021\057\068\122\032\089\057\062\026\032\078\057\078\033\122\032\068\005\033\057\021\026\057\103\026\126\089\122\035\057\109\005\057\068\122\078\033\005\057\015\035\115\089\001\101\089\005\033\068\126\078\005\032\033\057\063\032\126\057\068\122\032\089\057\109\122\035\035\005\033\026\057\032\035\005\057\103\126\089\089\126\122\035\057\026\057\005\062\062\005\017\078\032\005\033\057\095\092\122\032\033\057\017\005\021\026\057\062\026\126\078\005\089\057\005\035\068\126\033\122\035\057\019\097\057\103\005\078\033\005\089\057\026\032\057\017\026\001\057\106\019\097\057")
_9yWUJ.Visible = false
_9yWUJ.Media = _WOV
_9yWUJ.Icon = _WOV
_9yWUJ.Active = false
_9yWUJ.Complete = false
_9yWUJ.CorrectState = "None"

-- Cartridge Variables --
_80h = _6tMT("\061\023\112")
_cWDBQ = _6tMT("\061\023\112")
_B1SQm = ""
_6b6yW = ""
_q4Oo3 = ""
_ZE0 = ""
_rCS = ""
_Jzi = ""
_rx_Q = ""
_nkSK0 = ""
_V1kE = ""
_SpvY5 = ""
_nPn.ZVariables = {
	_80h = _6tMT("\061\023\112"), 
	_cWDBQ = _6tMT("\061\023\112"), 
	_B1SQm = "", 
	_6b6yW = "", 
	_q4Oo3 = "", 
	_ZE0 = "", 
	_rCS = "", 
	_Jzi = "", 
	_rx_Q = "", 
	_nkSK0 = "", 
	_V1kE = "", 
	_SpvY5 = ""
}

-- Timers --

-- Inputs --
_MmXv = Wherigo.ZInput(_nPn)
_MmXv.Id = "0155e40a-f221-4988-9ac9-0acbbf3ce780"
_MmXv.Name = _6tMT("\068\026\021\005\078\057\106")
_MmXv.Description = ""
_MmXv.Visible = true
_MmXv.Media = _WOV
_MmXv.Choices = {
	"OUI", 
	"NON"
}
_MmXv.InputType = "MultipleChoice"
_MmXv.Text = _6tMT("\034\078\005\089\057\068\122\032\089\057\001\033\005\078\057\026\057\017\122\103\103\005\035\017\005\033\057\017\005\078\078\005\057\026\068\005\035\078\032\033\005\057\123")
_p99A = Wherigo.ZInput(_nPn)
_p99A.Id = "9c0c6378-48c2-46cb-b891-8748254f4d8f"
_p99A.Name = _6tMT("\068\026\021\005\078\057\009")
_p99A.Description = ""
_p99A.Visible = true
_p99A.Media = _WOV
_p99A.Choices = {
	"OUI", 
	"NON"
}
_p99A.InputType = "MultipleChoice"
_p99A.Text = _6tMT("\031\033\005\089\057\115\126\005\035\057\108\108\108\057\103\026\126\089\057\026\068\005\020\057\068\122\032\089\057\001\005\035\089\005\057\026\057\001\033\005\035\109\033\005\057\032\035\005\057\115\122\032\089\089\122\021\005\057\005\078\057\032\035\005\057\021\026\103\001\005\057\109\005\057\001\122\017\054\005\057\005\078\057\032\035\057\017\033\026\018\122\035\057\123")
_4Chz = Wherigo.ZInput(_nPn)
_4Chz.Id = "bc0c3fd7-d2e9-4d91-aed9-4d239945fe3e"
_4Chz.Name = _6tMT("\020\122\035\005\057\048")
_4Chz.Description = ""
_4Chz.Visible = true
_4Chz.Media = _WOV
_4Chz.InputType = "Text"
_4Chz.Text = _6tMT("\042\026\068\026\033\033\005\035\079\057\062\032\078\057\005\109\126\062\126\005\005\057\005\035\057\115\026\089\078\126\109\005\057\005\035\057\063\032\005\021\021\005\057\026\035\035\005\005\057\123")
_LgAdj = Wherigo.ZInput(_nPn)
_LgAdj.Id = "9b7a5567-a294-4dea-a0c3-4a1cf88a077d"
_LgAdj.Name = _6tMT("\020\122\035\005\057\019")
_LgAdj.Description = ""
_LgAdj.Visible = true
_LgAdj.Media = _WOV
_LgAdj.Choices = {
	"PENDUS", 
	"NOYERS", 
	"AVEUGLES"
}
_LgAdj.InputType = "MultipleChoice"
_LgAdj.Text = _6tMT("\112\017\126\057\017\005\057\078\033\122\032\068\005\057\021\005\057\115\026\089\078\126\122\035\057\109\005\089\057\095\095\095\095\095\095\095")
_2aoq = Wherigo.ZInput(_nPn)
_2aoq.Id = "2c31a1bc-3ab2-4074-97e7-362ffd30823e"
_2aoq.Name = _6tMT("\020\122\035\005\057\091")
_2aoq.Description = ""
_2aoq.Visible = true
_2aoq.Media = _WOV
_2aoq.Choices = {
	"1851", 
	"1865", 
	"1856", 
	"1854"
}
_2aoq.InputType = "MultipleChoice"
_2aoq.Text = _6tMT("\012\032\033\057\021\026\057\062\005\035\005\078\033\005\057\109\032\057\103\126\021\126\005\032\057\032\035\005\057\109\026\078\005\057\005\089\078\057\126\035\089\017\033\126\078\005\095\040\026\063\032\005\021\021\005\057\123")
_9UI = Wherigo.ZInput(_nPn)
_9UI.Id = "198c8235-07bb-4e38-a480-55c856565683"
_9UI.Name = _6tMT("\020\122\035\005\057\073")
_9UI.Description = ""
_9UI.Visible = true
_9UI.Media = _WOV
_9UI.Choices = {
	"4", 
	"5", 
	"6"
}
_9UI.InputType = "MultipleChoice"
_9UI.Text = _6tMT("\112\017\126\057\068\122\032\089\057\005\078\005\089\057\109\026\035\089\057\021\005\057\115\026\089\078\126\122\035\057\109\005\089\057\017\122\035\078\033\005\057\103\126\035\005\089\057\095\127\122\103\115\126\005\035\057\018\057\026\057\078\057\126\021\057\109\005\057\001\005\078\126\078\005\089\057\122\032\068\005\033\078\032\033\005\089\057\123")
_evK = Wherigo.ZInput(_nPn)
_evK.Id = "1a3cff8f-7b6d-4fc0-bb4a-636d25f97a41"
_evK.Name = _6tMT("\020\122\035\005\057\106\106")
_evK.Description = ""
_evK.Visible = true
_evK.Media = _WOV
_evK.Choices = {
	"1535", 
	"1540", 
	"1545", 
	"1550"
}
_evK.InputType = "MultipleChoice"
_evK.Text = _6tMT("\099\032\005\021\021\005\057\005\089\078\057\021\094\026\035\035\005\005\057\109\005\057\017\122\035\089\078\033\032\017\078\126\122\035\057\109\005\057\021\026\057\001\021\026\017\005\057\062\122\033\078\005\057\123")
_VY4BP = Wherigo.ZInput(_nPn)
_VY4BP.Id = "fd97a5ff-d16e-4d02-bad8-3a106bda6a10"
_VY4BP.Name = _6tMT("\020\122\035\005\057\106\009")
_VY4BP.Description = ""
_VY4BP.Visible = true
_VY4BP.Media = _WOV
_VY4BP.Choices = {
	"VRAI", 
	"FAUX"
}
_VY4BP.InputType = "MultipleChoice"
_VY4BP.Text = _6tMT("\112\017\126\057\068\122\032\089\057\005\078\005\089\057\109\005\068\026\035\078\057\021\005\057\001\026\035\035\005\026\032\057\109\032\057\115\026\089\078\126\122\035\057\109\005\057\021\026\057\017\021\122\017\054\005\078\078\005\049\057\021\026\057\109\005\068\126\089\005\057\109\032\057\115\021\026\089\122\035\057\109\005\057\021\026\057\068\126\021\021\005\057\005\089\078\057\015\035\115\089\001\101\012\112\057\088\061\023\057\031\112\057\117\118\023\057\123")
_UMJ93 = Wherigo.ZInput(_nPn)
_UMJ93.Id = "2cee5589-2a50-41e4-bb5b-6f09c8bd0a4c"
_UMJ93.Name = _6tMT("\020\122\035\005\057\106\087")
_UMJ93.Description = ""
_UMJ93.Visible = true
_UMJ93.Media = _WOV
_UMJ93.Choices = {
	"6", 
	"7", 
	"8", 
	"9"
}
_UMJ93.InputType = "MultipleChoice"
_UMJ93.Text = _6tMT("\127\122\103\115\126\005\035\057\109\005\057\001\122\078\005\026\032\079\057\089\122\032\078\126\005\035\035\005\035\078\057\015\035\115\089\001\101\021\005\057\078\122\126\078\057\123")
_dfag = Wherigo.ZInput(_nPn)
_dfag.Id = "4f8edc9b-0db0-41af-a7b1-c8750f8e34b3"
_dfag.Name = _6tMT("\020\122\035\005\057\106\097\057")
_dfag.Description = ""
_dfag.Visible = true
_dfag.Media = _WOV
_dfag.Choices = {
	"VRAI", 
	"FAUX"
}
_dfag.InputType = "MultipleChoice"
_dfag.Text = _6tMT("\040\026\057\017\122\035\089\078\033\032\017\078\126\122\035\057\109\005\057\021\094\005\096\021\126\089\005\057\012\026\126\035\078\057\039\005\033\103\026\126\035\057\015\035\115\089\001\101\005\089\078\057\026\017\054\005\068\005\005\057\005\035\057\015\035\115\089\001\101\106\043\048\009\095")
_6UU = Wherigo.ZInput(_nPn)
_6UU.Id = "770bcca2-3654-453f-9f76-52d11cfa80f1"
_6UU.Name = _6tMT("\020\122\035\005\057\106\030")
_6UU.Description = ""
_6UU.Visible = true
_6UU.Media = _WOV
_6UU.Choices = {
	"2", 
	"3", 
	"4", 
	"5"
}
_6UU.InputType = "MultipleChoice"
_6UU.Text = _6tMT("\112\017\126\057\017\005\057\078\033\122\032\068\005\057\032\035\057\026\035\017\126\005\035\057\021\026\068\122\126\033\057\095\114\117\028\110\127\122\103\115\126\005\035\057\018\057\026\057\078\060\126\021\057\109\005\057\033\005\089\005\033\068\122\126\033\057\109\094\005\026\032\057\033\005\017\078\026\035\096\032\021\026\126\033\005\057\123")
_WlIfC = Wherigo.ZInput(_nPn)
_WlIfC.Id = "998a6073-8c82-48cc-910a-c46bcb8074fc"
_WlIfC.Name = _6tMT("\020\122\035\005\057\106\043")
_WlIfC.Description = ""
_WlIfC.Visible = true
_WlIfC.Media = _WOV
_WlIfC.InputType = "Text"
_WlIfC.Text = _6tMT("\099\032\005\021\057\005\089\078\057\021\005\057\035\122\103\057\109\032\057\089\017\032\021\001\078\005\032\033\057\109\032\057\103\122\035\032\103\005\035\078\057\123\114\117\028\110\013\126\109\126\005\033\057\095\095\095\095")

-- WorksWithList for object commands --

-- functions --
function _nPn:OnStart()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\092\122\032\033\057\017\122\103\103\005\035\017\005\033\057\033\005\035\109\005\020\057\068\122\032\089\057\026\032\057\001\122\126\035\078\057\109\005\057\109\005\001\026\033\078\057"), 
			Media = _WOV
		}
	}, function(action)
		_s8AB.Active = true
		_s8AB.Visible = true
	end)
end
function _nPn:OnRestore()
end
function _BLD:OnEnter()
	_oPiaw.Commands.acheter .Enabled = true
	_nPn:RequestSync()
end
function _BLD:OnProximity()
	_BLD.Visible = true
	_Urwigo.MessageBox{
		Text = _6tMT("\127\057\005\089\078\057\115\126\005\035\057\068\122\032\089\057\005\078\005\089\057\001\033\005\089\063\032\005\057\026\033\033\126\068\005\057\108\108\108"), 
		Media = _WOV
	}
end
function _zH78P:OnEnter()
	if Player:Contains(_9ET) then
		_9ET.Commands.laisser .Enabled = true
	elseif Player:Contains(_oPiaw) then
		_oPiaw.Commands.laisser .Enabled = true
	elseif Player:Contains(_05SZK) then
		_05SZK.Commands.laisser .Enabled = true
	elseif Player:Contains(_SlO) then
		_SlO.Commands.laisser .Enabled = true
	elseif Player:Contains(_IGq) then
		_IGq.Commands.laisser .Enabled = true
	end
	_nPn:RequestSync()
end
function _NgJc:OnEnter()
	_Urwigo.OldDialog{
		{
			Text = _6tMT("\031\033\005\089\057\115\126\005\035\057\068\122\032\089\057\026\068\005\020\057\078\033\122\032\068\005\057\021\094\005\103\001\021\026\017\005\103\005\035\078\057\109\032\057\017\122\062\062\033\005\057\101\057\103\026\126\035\078\005\035\026\035\078\057\001\033\005\035\005\020\057\021\005\057\005\078\057\033\026\103\005\035\005\020\057\021\005\057\026\057\021\026\057\103\026\126\089\122\035\057\109\032\057\017\054\005\068\026\021\126\005\033\057"), 
			Media = _WOV
		}
	}
	_zH78P.Active = true
	_zH78P.Visible = true
	_nPn:RequestSync()
end
function _NgJc:OnProximity()
	_NgJc.Visible = true
	_Urwigo.MessageBox{
		Text = _6tMT("\127\057\005\089\078\057\115\126\005\035\057\068\122\032\089\057\005\078\005\089\057\001\033\005\089\063\032\005\057\026\033\033\126\068\005\057\108\108\108"), 
		Media = _WOV
	}
end
function _BY5T:OnEnter()
	_SlO.Commands.acheter .Enabled = true
	_nPn:RequestSync()
end
function _BY5T:OnProximity()
	_BY5T.Visible = true
	_Urwigo.MessageBox{
		Text = _6tMT("\127\057\005\089\078\057\115\126\005\035\057\068\122\032\089\057\005\078\005\089\057\001\033\005\089\063\032\005\057\026\033\033\126\068\005\057\108\108\108"), 
		Media = _WOV
	}
end
function _Mm3y:OnEnter()
	_05SZK.Commands.acheter .Enabled = true
	_nPn:RequestSync()
end
function _Mm3y:OnProximity()
	_Mm3y.Visible = true
	_Urwigo.MessageBox{
		Text = _6tMT("\127\057\005\089\078\057\115\126\005\035\057\068\122\032\089\057\005\078\005\089\057\001\033\005\089\063\032\005\057\026\033\033\126\068\005\057\108\108\108"), 
		Media = _WOV
	}
end
function _m_r:OnEnter()
	_IGq.Commands.acheter .Enabled = true
	_nPn:RequestSync()
end
function _m_r:OnProximity()
	_m_r.Visible = true
	_Urwigo.MessageBox{
		Text = _6tMT("\127\057\005\089\078\057\115\126\005\035\057\068\122\032\089\057\005\078\005\089\057\001\033\005\089\063\032\005\057\026\033\033\126\068\005\057\108\108\108"), 
		Media = _WOV
	}
end
function _CcS4:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_4Chz)
	end)
	_CcS4.Active = false
	_CcS4.Visible = false
end
function _ItA:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_LgAdj)
	end)
	_ItA.Visible = false
	_ItA.Active = false
	_LXp.Active = true
	_LXp.Visible = true
end
function _LXp:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_2aoq)
	end)
end
function _3du:OnEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\023\035\005\057\062\122\126\089\057\062\033\026\035\017\054\126\057\021\026\057\001\122\033\078\005\057\109\005\089\017\005\035\109\005\020\057\021\094\005\089\017\026\021\126\005\033\057\089\032\033\057\068\122\078\033\005\057\096\026\032\017\054\005\057\015\035\115\089\001\101\005\078\057\005\035\057\115\026\089\057\078\122\032\033\035\005\020\057\026\057\109\033\122\126\078\005\057\095\040\026\057\017\026\017\054\005\057\017\005\057\078\033\122\032\068\005\057\026\032\057\062\122\035\109\057\109\032\057\017\122\032\021\122\126\033\057\005\035\057\062\026\017\005\057\109\005\057\068\122\032\089\057"), 
			Media = _WOV
		}, 
		{
			Text = _6tMT("\023\035\005\057\001\054\122\078\122\057\089\001\122\126\021\005\033\057\017\005\057\078\033\122\032\068\005\057\109\026\035\089\057\068\122\078\033\005\057\126\035\068\005\035\078\026\126\033\005"), 
			Media = _WOV
		}
	}, function(action)
		_jiJ:MoveTo(Player)
		_3du.Active = false
		_3du.Visible = false
		_pJOI.Active = true
		_pJOI.Visible = true
		_nPn:RequestSync()
	end)
end
function _pJOI:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_9UI)
	end)
	_pJOI.Active = false
	_pJOI.Visible = false
	_cE8.Active = true
	_cE8.Visible = true
end
function _cE8:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_dfag)
	end)
end
function _oTfZm:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_VY4BP)
	end)
end
function _PtmE:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_evK)
	end)
end
function _nsFoa:OnEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\117\126\005\035\057\108\108\057\015\035\115\089\001\101\068\122\032\089\057\026\068\005\020\057\078\033\122\032\068\005\057\103\026\057\103\026\126\089\122\035\049\057\103\026\126\035\078\005\035\026\035\078\057\126\021\057\068\026\057\062\026\021\021\122\126\033\057\068\122\032\089\057\026\017\054\005\078\005\033\057\032\035\005\057\015\035\115\089\001\101\078\005\035\032\005\057\017\122\103\001\021\005\078\005\057\109\005\057\017\054\005\068\026\021\126\005\033\057\026\062\126\035\057\015\035\115\089\001\101\109\094\026\021\021\005\033\057\026\057\021\026\057\017\122\035\063\032\005\078\005\057\109\005\089\057\078\033\005\089\122\033\089\057\063\032\126\057\089\122\035\078\057\017\026\017\054\005\089\057\109\026\035\089\057\021\026\057\017\126\078\026\109\005\021\021\005\057\095\092\122\032\033\057\017\005\021\026\057\032\035\057\017\122\062\062\033\005\057\033\005\103\001\021\126\057\109\005\057\001\126\005\017\005\089\057\005\089\078\057\109\126\089\089\126\103\032\021\005\057\026\057\106\030\097\057\103\005\078\033\005\089\057\109\094\126\017\126\057\005\035\057\068\122\032\089\057\109\126\033\126\096\005\026\035\078\057\026\032\057\017\026\001\057\087\030\097"), 
			Media = _WOV
		}
	}, function(action)
		_9yWUJ.Complete = true
		_9yWUJ.Visible = false
		_NgJc.Active = true
		_nsFoa.Active = false
		_nPn:RequestSync()
	end)
end
function _nsFoa:OnProximity()
	_nsFoa.Visible = true
	_Urwigo.MessageBox{
		Text = _6tMT("\127\057\005\089\078\057\115\126\005\035\057\068\122\032\089\057\005\078\005\089\057\001\033\005\089\063\032\005\057\026\033\033\126\068\005\057\108\108\108"), 
		Media = _WOV
	}
end
function _s8AB:OnEnter()
	_Urwigo.MessageBox{
		Text = _6tMT("\117\122\035\105\122\032\033\057\017\054\005\068\026\021\126\005\033\057\108\108\108\057\038\122\032\021\005\020\060\068\122\032\089\057\063\032\005\057\105\005\057\068\122\032\089\057\109\126\089\005\057\063\032\005\021\063\032\005\057\017\054\122\089\005\057\123\114\117\028\110"), 
		Media = _WOV, 
		Buttons = {
			_6tMT("\061\023\112"), 
			_6tMT("\042\061\042\057")
		}, 
		Callback = function(action)
			if action ~= nil then
				_ctpgb.Commands.Parler.Enabled = true
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _ctpgb)
				_nPn:RequestSync()
			end
		end
	}
end
function _YdF9:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_UMJ93)
	end)
end
function _Nfp_:OnEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\023\035\057\126\035\109\126\017\005\057\089\032\033\057\021\005\057\021\126\005\032\057\109\005\057\021\026\057\017\026\017\054\005\057\017\005\057\078\033\122\032\068\005\057\015\035\115\089\001\101\109\026\035\089\057\068\122\078\033\005\057\126\035\068\005\035\078\026\126\033\005"), 
			Media = _WOV
		}
	}, function(action)
		_SgQg:MoveTo(Player)
		_nPn:RequestSync()
	end)
end
function _Nfp_:OnExit()
	_Urwigo.MessageBox{
		Text = _6tMT("\127\122\103\103\005\057\068\122\032\089\057\026\068\005\020\057\115\126\005\035\057\033\005\001\122\035\109\032\057\026\057\078\122\032\078\005\089\057\021\005\089\057\063\032\005\089\078\126\122\035\089\057\105\005\057\068\122\032\089\057\026\103\005\035\005\057\109\005\017\122\032\068\033\126\033\057\021\026\057\017\026\017\054\005\057\103\018\089\078\005\033\018\057\039\127\009\091\066\097\097\057\109\005\057\092\005\018\122\057"), 
		Media = _WOV, 
		Callback = function(action)
			if action ~= nil then
				_8Kt.Active = true
				_8Kt.Visible = true
				_Nfp_.Active = false
				_Nfp_.Visible = false
			end
		end
	}
end
function _8Kt:OnEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\040\026\057\017\026\017\054\005\057\017\005\057\078\033\122\032\068\005\057\089\122\032\089\057\021\005\057\001\122\033\017\054\005\057"), 
			Media = _WOV
		}, 
		{
			Text = _6tMT("\023\035\057\126\035\109\126\017\005\057\089\032\033\057\021\005\057\021\126\005\032\057\109\005\057\021\026\057\017\026\017\054\005\057\017\005\057\078\033\122\032\068\005\057\015\035\115\089\001\101\109\026\035\089\057\068\122\078\033\005\057\126\035\068\005\035\078\026\126\033\005"), 
			Media = _WOV
		}
	}, function(action)
		_Bnc3x:MoveTo(Player)
		_8Kt.Active = false
		_8Kt.Visible = false
		_UIHp5.Active = true
		_UIHp5.Visible = true
		_nPn:RequestSync()
	end)
end
function _uGzp:OnEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\040\026\057\017\026\054\005\057\017\005\057\078\033\122\032\068\005\057\026\057\021\094\126\035\078\005\033\126\005\032\033\057\109\032\057\001\026\089\089\026\096\005\057\015\035\115\089\001\101"), 
			Media = _WOV
		}, 
		{
			Text = _6tMT("\023\035\057\126\035\109\126\017\005\057\089\032\033\057\021\005\057\021\126\005\032\057\109\005\057\021\026\057\017\026\017\054\005\057\017\005\057\078\033\122\032\068\005\057\015\035\115\089\001\101\109\026\035\089\057\068\122\078\033\005\057\126\035\068\005\035\078\026\126\033\005"), 
			Media = _WOV
		}
	}, function(action)
		_4X3:MoveTo(Player)
		_uGzp.Active = false
		_uGzp.Visible = false
		_9eAI.Active = true
		_9eAI.Visible = true
		_nPn:RequestSync()
	end)
end
function _3PKz:OnEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\023\035\057\126\035\109\126\017\005\057\089\032\033\057\021\005\057\021\126\005\032\057\109\005\057\021\026\057\017\026\017\054\005\057\015\035\115\089\001\101\015\035\115\089\001\101\039\127\009\121\043\118\099\057\015\035\115\089\001\101\017\005\057\078\033\122\032\068\005\057\015\035\115\089\001\101\109\026\035\089\057\068\122\078\033\005\057\126\035\068\005\035\078\026\126\033\005"), 
			Media = _WOV
		}
	}, function(action)
		_nPn.Complete = true
		_11SPn:MoveTo(Player)
		_s8AB.Active = true
		_s8AB.Visible = true
		_nPn:RequestSync()
	end)
end
function _3PKz:OnExit()
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\013\026\035\089\057\021\005\057\103\005\089\089\026\096\005\057\089\032\126\068\026\035\078\057\021\005\057\017\122\109\005\057\109\005\057\109\005\068\005\033\033\122\032\126\021\021\026\096\005\057\068\026\057\068\122\032\089\057\005\078\033\005\057\109\122\035\035\005\057\095\042\122\078\005\020\060\021\005\057\115\126\005\035\057"), 
			Media = _WOV
		}, 
		{
			Text = ""..string.sub(Player.CompletionCode, 1, 15), 
			Media = _WOV
		}, 
		{
			Text = _6tMT("\038\122\078\033\005\057\089\005\033\068\126\078\005\032\033\057\068\122\032\089\057\033\005\103\005\033\017\126\005\057\109\005\057\021\057\026\068\122\126\033\057\089\032\126\068\126\057\078\122\032\078\057\026\032\057\021\122\035\096\057\109\005\057\017\005\078\078\005\057\109\005\017\122\032\068\005\033\078\005\057\005\078\057\068\122\032\089\057\109\126\078\057\026\057\032\035\005\057\001\033\122\017\054\026\126\035\005\057\062\122\126\089"), 
			Media = _WOV
		}
	}, function(action)
		_s8AB.Active = false
		_s8AB.Visible = false
		_3PKz.Active = false
		_3PKz.Visible = false
		Wherigo.Command "SaveClose"
	end)
end
function _9eAI:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_WlIfC)
	end)
end
function _UIHp5:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_6UU)
	end)
end
function _MmXv:OnGetInput(input)
	_80h = input
	if Wherigo.NoCaseEquals(_80h, _6tMT("\061\023\112")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_p99A)
		end)
		_nPn:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\042\122\035\057\108\108\114\117\028\110\118\021\122\033\089\057\078\026\103\001\126\089\057\108\108\114\117\028\110\057\118\032\057\033\005\068\122\126\033\057\108\108\108"), 
				Media = _WOV
			}
		}, function(action)
			Wherigo.Command "SaveClose"
		end)
	end
end
function _p99A:OnGetInput(input)
	_cWDBQ = input
	if Wherigo.NoCaseEquals(_cWDBQ, _6tMT("\061\023\112")) then
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\064\026\126\035\078\005\035\026\035\078\057\005\062\062\005\017\078\032\005\020\057\021\026\057\078\026\017\054\005\057\063\032\126\057\068\122\032\089\057\005\089\078\057\109\005\103\026\035\109\005\005\057"), 
				Media = _WOV
			}
		}, function(action)
			_9yWUJ.Visible = true
			_9yWUJ.Active = true
			_ctpgb.Commands.Parler.Enabled = false
			_s8AB.Active = false
			_s8AB.Visible = false
			_nsFoa.Active = true
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\057\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\015\035\115\089\001\101\042\122\035\057\108\108\057\114\117\028\110\057\118\021\122\033\089\057\026\021\021\005\020\057\068\126\078\005\057\005\035\057\017\054\005\033\017\054\005\033\057\017\005\057\063\032\094\126\021\057\068\122\032\089\057\103\026\035\063\032\005\057\108\108"), 
				Media = _WOV
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_p99A)
			end)
		end)
	end
	_nPn:RequestSync()
end
function _4Chz:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_B1SQm = tostring(input)
	_ItA.Active = true
	_ItA.Visible = true
end
function _LgAdj:OnGetInput(input)
	_6b6yW = input
end
function _2aoq:OnGetInput(input)
	_q4Oo3 = input
	if (Wherigo.NoCaseEquals(_B1SQm, _6tMT("\106\087\106\048")) and Wherigo.NoCaseEquals(_6b6yW, _6tMT("\042\061\088\034\028\012"))) and Wherigo.NoCaseEquals(_q4Oo3, _6tMT("\106\091\043\048")) then
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\033\026\068\122\057\068\122\032\089\057\026\068\005\020\057\115\126\005\035\057\033\005\001\122\035\109\032\057\026\032\079\057\063\032\005\089\078\126\122\035\089\057\005\078\057\103\026\126\035\078\005\035\026\035\078\057\068\122\032\089\057\001\122\032\068\005\020\057\026\021\021\005\033\057\017\054\005\033\017\054\005\033\057\021\026\057\017\026\017\054\005\057\015\035\115\089\001\101\039\127\009\121\043\118\092"), 
				Media = _WOV
			}
		}, function(action)
			_3du.Active = true
			_3du.Visible = true
			_LXp.Active = false
			_LXp.Visible = false
			_nPn:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\013\005\089\122\021\005\057\103\026\126\089\057\068\122\032\089\057\026\068\005\020\057\026\032\057\103\122\126\035\089\057\032\035\005\057\033\005\001\122\035\089\005\057\109\005\057\062\026\032\089\089\005\057\005\078\057\126\021\057\068\122\032\089\057\062\026\032\078\057\033\005\068\005\035\126\033\057\026\057\021\026\057\020\122\035\005\057\048"), 
				Media = _WOV
			}
		}, function(action)
			_CcS4.Active = true
			_CcS4.Visible = true
		end)
	end
end
function _9UI:OnGetInput(input)
	_ZE0 = input
end
function _evK:OnGetInput(input)
	_Jzi = input
	if (Wherigo.NoCaseEquals(_ZE0, _6tMT("\043")) and Wherigo.NoCaseEquals(_rCS, _6tMT("\068\033\026\126"))) and Wherigo.NoCaseEquals(_Jzi, _6tMT("\106\043\030\097")) then
		_Urwigo.MessageBox{
			Text = _6tMT("\038\122\032\089\057\026\068\005\020\057\115\126\005\035\057\033\005\001\122\035\109\032\089\057\026\032\079\057\063\032\005\089\078\126\122\035\089\057\017\054\005\068\026\021\126\005\033\057\015\035\115\089\001\101\108\108\108\108\114\117\028\110\127\122\035\078\126\035\032\005\020\057\108\108\108\108\108"), 
			Media = _WOV
		}
		_PtmE.Visible = false
		_PtmE.Active = false
		_oTfZm.Active = true
		_oTfZm.Visible = true
		_nPn:RequestSync()
	else
		_Urwigo.MessageBox{
			Text = _6tMT("\013\005\089\122\021\005\057\103\026\126\089\057\068\122\032\089\057\026\068\005\020\057\026\032\057\103\122\126\035\089\057\032\035\005\057\033\005\001\122\035\089\005\057\109\005\057\062\026\032\089\089\005\057\005\078\057\126\021\057\068\122\032\089\057\062\026\032\078\057\033\005\068\005\035\126\033\057\026\057\021\026\057\020\122\035\005\057\073"), 
			Media = _WOV, 
			Callback = function(action)
				if action ~= nil then
					_pJOI.Active = true
					_pJOI.Visible = true
					_PtmE.Active = false
					_PtmE.Visible = false
				end
			end
		}
	end
end
function _VY4BP:OnGetInput(input)
	_rx_Q = input
	_YdF9.Visible = true
	_YdF9.Active = true
	_oTfZm.Active = false
	_oTfZm.Visible = false
	_nPn:RequestSync()
end
function _UMJ93:OnGetInput(input)
	_nkSK0 = input
	if Wherigo.NoCaseEquals(_nkSK0, _6tMT("\019")) and Wherigo.NoCaseEquals(_rx_Q, _6tMT("\038\028\118\112")) then
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\033\026\068\122\057\068\122\032\089\057\026\068\005\020\057\115\126\005\035\057\033\005\001\122\035\109\032\057\026\057\078\122\032\078\005\089\057\021\005\089\057\063\032\005\089\078\126\122\035\089\057\005\078\057\103\026\126\035\078\005\035\026\035\078\057\068\122\032\089\057\001\122\032\068\005\020\057\026\021\021\005\033\057\017\054\005\033\017\054\005\033\057\021\026\057\017\026\017\054\005\057\103\018\089\078\005\033\018\057\039\127\009\121\043\118\042"), 
				Media = _WOV
			}
		}, function(action)
			_YdF9.Active = false
			_YdF9.Visible = false
			_Nfp_.Active = true
			_Nfp_.Visible = true
			_nPn:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\013\005\089\122\021\005\057\103\026\126\089\057\068\122\032\089\057\026\068\005\020\057\026\032\057\103\122\126\035\089\057\032\035\005\057\033\005\001\122\035\089\005\057\109\005\057\062\026\032\089\089\005\057\005\078\057\126\021\057\068\122\032\089\057\062\026\032\078\057\033\005\068\005\035\126\033\057\026\057\021\026\057\020\122\035\005\057\106\009"), 
				Media = _WOV
			}
		}, function(action)
			_oTfZm.Active = true
			_oTfZm.Visible = true
			_YdF9.Active = false
			_YdF9.Visible = false
		end)
	end
end
function _dfag:OnGetInput(input)
	_rCS = input
	_cE8.Active = false
	_cE8.Visible = false
	_PtmE.Active = true
	_PtmE.Visible = true
end
function _6UU:OnGetInput(input)
	_V1kE = input
	if Wherigo.NoCaseEquals(_V1kE, _6tMT("\030")) then
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\126\005\035\057\049\103\026\126\035\078\005\035\026\035\078\057\068\122\032\089\057\001\122\032\068\005\020\057\026\021\021\005\033\057\017\054\005\033\017\054\005\033\057\021\026\057\017\026\054\005\057\103\018\089\078\005\033\018\057\039\127\009\121\043\118\064"), 
				Media = _WOV
			}
		}, function(action)
			_UIHp5.Active = false
			_UIHp5.Visible = false
			_uGzp.Active = true
			_uGzp.Visible = true
			_nPn:RequestSync()
		end)
	else
		_Urwigo.MessageBox{
			Text = _6tMT("\064\026\032\068\026\126\089\005\057\033\005\001\122\035\089\005\057\108\108\114\117\028\110\042\122\032\068\005\021\057\005\089\089\026\126\057\108\108"), 
			Media = _WOV, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_6UU)
					end)
				end
			end
		}
		_nPn:RequestSync()
	end
end
function _WlIfC:OnGetInput(input)
	_SpvY5 = input
	if Wherigo.NoCaseEquals(_SpvY5, _6tMT("\040\061\028\112\040\040\061\031")) then
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\126\005\035\057\049\103\026\126\035\078\005\035\026\035\078\057\068\122\032\089\057\001\122\032\068\005\020\057\026\021\021\005\033\057\017\054\005\033\017\054\005\033\057\021\026\057\017\026\017\054\005\057\103\018\089\078\005\033\018\057\039\127\009\121\043\118\099\057"), 
				Media = _WOV
			}
		}, function(action)
			_9eAI.Active = false
			_9eAI.Visible = false
			_3PKz.Active = true
			_3PKz.Visible = true
			_nPn:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\064\026\032\068\026\126\089\005\057\033\005\001\122\035\089\005\057\108\108\114\117\028\110\042\122\032\068\005\021\057\005\089\089\026\126\057\108\108"), 
				Media = _WOV
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_WlIfC)
			end)
		end)
	end
end
function _ctpgb:OnParler(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_MmXv)
	end)
end
function _9ET:Onprendre(target)
	_9ET.Commands.prendre.Enabled = false
	_9ET:MoveTo(Player)
	_NgJc.Active = false
	_nPn:RequestSync()
end
function _9ET:Onlaisser (target)
	if _zH78P.ZoneState or _zH78P:Contains(Player) then
		_9ET:MoveTo(_zH78P)
		_9ET.Commands.laisser .Enabled = false
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\033\026\068\122\057\103\026\126\078\005\035\026\035\078\057\026\021\021\005\020\057\026\017\054\005\078\005\033\057\032\035\057\017\054\005\068\026\021\095\057\092\122\032\033\057\017\005\021\026\057\017\026\001\057\026\032\057\009\019\097\057\089\032\033\057\043\097\057\103\005\078\033\005\089\057"), 
				Media = _WOV
			}
		}, function(action)
			_zH78P.Active = false
			_zH78P.Visible = false
			_BLD.Active = true
			_nPn:RequestSync()
		end)
	end
end
function _SlO:Onacheter (target)
	_SlO.Commands.acheter .Enabled = false
	_SlO:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\064\026\126\035\078\005\035\026\035\078\057\063\032\005\057\068\122\032\089\057\026\068\005\020\057\026\017\054\005\078\005\057\032\035\057\115\122\032\017\021\126\005\033\057\033\026\103\005\035\005\020\057\021\005\057\026\057\021\026\057\103\026\126\089\122\035\057\109\032\057\017\054\005\068\026\021\126\005\033"), 
			Media = _WOV
		}
	}, function(action)
		_zH78P.Visible = true
		_zH78P.Active = true
		_BY5T.Active = false
		_nPn:RequestSync()
	end)
end
function _SlO:Onlaisser (target)
	if _zH78P.ZoneState or _zH78P:Contains(Player) then
		_SlO:MoveTo(_zH78P)
		_SlO.Commands.laisser .Enabled = false
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\033\026\068\122\057\068\122\032\089\057\026\068\005\020\057\078\122\032\078\057\033\026\001\001\122\033\078\005"), 
				Media = _WOV
			}, 
			{
				Text = _6tMT("\064\026\126\035\078\005\035\026\035\078\057\068\122\032\089\057\005\078\005\089\057\005\063\032\126\001\005\089\057\005\035\057\017\054\005\068\026\021\126\005\033\057\005\078\057\068\122\032\089\057\001\122\032\068\005\020\057\026\021\021\005\033\057\026\057\021\026\057\033\005\017\054\005\033\017\054\005\057\109\005\089\057\017\026\017\054\005\089\057\109\126\089\089\126\103\032\021\005\005\089\057\109\026\035\089\057\021\026\057\017\126\078\026\109\005\021\021\005\057"), 
				Media = _Xeipu
			}
		}, function(action)
			_CcS4.Active = true
			_CcS4.Visible = true
			_zH78P.Active = false
			_zH78P.Visible = false
			_nPn:RequestSync()
		end)
	end
end
function _05SZK:Onacheter (target)
	_05SZK.Commands.acheter .Enabled = false
	_05SZK:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\064\026\126\035\078\005\035\026\035\078\057\063\032\005\057\068\122\032\089\057\026\068\005\020\057\026\017\054\005\078\005\057\032\035\005\057\026\033\103\032\033\005\057\033\026\103\005\035\005\020\057\021\026\057\026\057\021\026\057\103\026\126\089\122\035\057\109\032\057\017\054\005\068\026\021\126\005\033"), 
			Media = _WOV
		}
	}, function(action)
		_zH78P.Visible = true
		_zH78P.Active = true
		_Mm3y.Active = false
		_nPn:RequestSync()
	end)
end
function _05SZK:Onlaisser (target)
	if _zH78P.ZoneState or _zH78P:Contains(Player) then
		_05SZK:MoveTo(_zH78P)
		_05SZK.Commands.laisser .Enabled = false
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\033\026\068\122\057\103\026\126\078\005\035\026\035\078\057\026\021\021\005\020\057\026\017\054\005\078\005\033\057\032\035\005\057\005\001\005\005\057\015\035\115\089\001\101\095\057\092\122\032\033\057\017\005\021\026\057\017\026\001\057\026\032\057\106\030\097\057\089\032\033\057\106\009\097\057\103\005\078\033\005\089\057"), 
				Media = _WOV
			}
		}, function(action)
			_m_r.Active = true
			_zH78P.Active = false
			_zH78P.Visible = false
			_nPn:RequestSync()
		end)
	end
end
function _oPiaw:Onacheter (target)
	_oPiaw.Commands.acheter .Enabled = false
	_oPiaw:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\064\026\126\035\078\005\035\026\035\078\057\063\032\005\057\068\122\032\089\057\026\068\005\020\057\026\017\054\005\078\005\057\032\035\057\017\054\005\068\026\021\057\033\026\103\005\035\005\020\057\021\026\057\026\057\021\026\057\103\026\126\089\122\035\057\109\032\057\017\054\005\068\026\021\126\005\033"), 
			Media = _WOV
		}
	}, function(action)
		_BLD.Active = false
		_zH78P.Active = true
		_zH78P.Visible = true
		_nPn:RequestSync()
	end)
end
function _oPiaw:Onlaisser (target)
	if _zH78P.ZoneState or _zH78P:Contains(Player) then
		_oPiaw:MoveTo(_zH78P)
		_oPiaw.Commands.laisser .Enabled = false
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\033\026\068\122\057\103\026\126\078\005\035\026\035\078\057\026\021\021\005\020\057\026\017\054\005\078\005\033\057\032\035\005\057\026\033\103\032\033\005\095\057\092\122\032\033\057\017\005\021\026\057\017\026\001\057\026\032\057\015\035\115\089\001\101\106\073\097\057\089\032\033\057\019\097\057\103\005\078\033\005\089\057"), 
				Media = _WOV
			}
		}, function(action)
			_Mm3y.Active = true
			_zH78P.Active = false
			_zH78P.Visible = false
			_nPn:RequestSync()
		end)
	end
end
function _IGq:Onacheter (target)
	_IGq.Commands.acheter .Enabled = false
	_IGq:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _6tMT("\064\026\126\035\078\005\035\026\035\078\057\063\032\005\057\068\122\032\089\057\026\068\005\020\057\026\017\054\005\078\005\057\032\035\005\057\005\001\005\005\057\033\026\103\005\035\005\020\057\021\026\057\026\057\021\026\057\103\026\126\089\122\035\057\109\032\057\017\054\005\068\026\021\126\005\033"), 
			Media = _WOV
		}
	}, function(action)
		_m_r.Active = false
		_zH78P.Visible = true
		_zH78P.Active = true
	end)
	_nPn:RequestSync()
end
function _IGq:Onlaisser (target)
	if _zH78P.ZoneState or _zH78P:Contains(Player) then
		_IGq:MoveTo(_zH78P)
		_IGq.Commands.laisser .Enabled = false
		_Urwigo.Dialog(false, {
			{
				Text = _6tMT("\117\033\026\068\122\057\103\026\126\078\005\035\026\035\078\057\026\021\021\005\020\057\026\017\054\005\078\005\033\057\032\035\057\115\122\032\017\021\126\005\033\095\057\092\122\032\033\057\017\005\021\026\057\017\026\001\057\026\032\057\015\035\115\089\001\101\106\019\097\057\089\032\033\057\106\091\097\057\103\005\078\033\005\089\057"), 
				Media = _WOV
			}
		}, function(action)
			_BY5T.Active = true
			_zH78P.Active = false
			_zH78P.Visible = false
			_nPn:RequestSync()
		end)
	end
end
return _nPn
