require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _XGWDb(str)
	local res = ""
    local dtable = "\027\001\111\117\099\069\012\082\026\072\033\078\122\073\105\007\098\077\084\063\103\104\125\040\000\049\085\089\080\094\060\059\036\055\124\034\088\021\079\096\123\087\119\068\100\029\114\050\039\022\043\031\002\113\109\013\011\028\083\066\076\108\052\097\004\092\006\090\081\048\045\102\017\010\019\035\051\005\091\062\023\070\093\075\024\095\015\071\042\041\086\126\053\067\115\106\003\032\056\054\112\058\047\014\120\020\018\037\030\065\116\057\110\118\038\046\101\061\107\008\025\044\064\121\009\074\016"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

objExcavationinSellersville = Wherigo.ZCartridge()

-- Media --
objBatteries = Wherigo.ZMedia(objExcavationinSellersville)
objBatteries.Id = "52ae3316-6a9f-4b08-9881-4d910c2fe0f6"
objBatteries.Name = "Batteries"
objBatteries.Description = ""
objBatteries.AltText = ""
objBatteries.Resources = {
	{
		Type = "jpg", 
		Filename = "itemBatteries.jpg", 
		Directives = {}
	}
}
objBatteriesShock = Wherigo.ZMedia(objExcavationinSellersville)
objBatteriesShock.Id = "127f19ba-7750-4acf-904e-9ae9191a53da"
objBatteriesShock.Name = "Batteries-Shock"
objBatteriesShock.Description = ""
objBatteriesShock.AltText = ""
objBatteriesShock.Resources = {
	{
		Type = "jpg", 
		Filename = "itemBatteriesShock.jpg", 
		Directives = {}
	}
}
objBook = Wherigo.ZMedia(objExcavationinSellersville)
objBook.Id = "d4f48709-b77d-4547-b398-d8055f91feff"
objBook.Name = "Book"
objBook.Description = ""
objBook.AltText = ""
objBook.Resources = {
	{
		Type = "jpg", 
		Filename = "itemBookTranslate.jpg", 
		Directives = {}
	}
}
objCaveClosed = Wherigo.ZMedia(objExcavationinSellersville)
objCaveClosed.Id = "db97140b-3c5f-473a-ada7-a2fc4f9fd36a"
objCaveClosed.Name = "Cave Closed"
objCaveClosed.Description = ""
objCaveClosed.AltText = ""
objCaveClosed.Resources = {
	{
		Type = "jpg", 
		Filename = "itemRockCaveClosed.jpg", 
		Directives = {}
	}
}
objCaveOpen = Wherigo.ZMedia(objExcavationinSellersville)
objCaveOpen.Id = "a2e59245-c62d-4308-83b5-de0b7b6c5e59"
objCaveOpen.Name = "Cave Open"
objCaveOpen.Description = ""
objCaveOpen.AltText = ""
objCaveOpen.Resources = {
	{
		Type = "jpg", 
		Filename = "itemRockCaveOpen.jpg", 
		Directives = {}
	}
}
objClayPotEmpty = Wherigo.ZMedia(objExcavationinSellersville)
objClayPotEmpty.Id = "6521569d-32b8-493d-ba25-bc99c82c0b61"
objClayPotEmpty.Name = "Clay Pot Empty"
objClayPotEmpty.Description = ""
objClayPotEmpty.AltText = ""
objClayPotEmpty.Resources = {
	{
		Type = "jpg", 
		Filename = "itemClayPotEmpty.jpg", 
		Directives = {}
	}
}
objClayPotFull = Wherigo.ZMedia(objExcavationinSellersville)
objClayPotFull.Id = "630735d8-83b5-4ed4-b2da-255f1481e381"
objClayPotFull.Name = "Clay Pot Full"
objClayPotFull.Description = ""
objClayPotFull.AltText = ""
objClayPotFull.Resources = {
	{
		Type = "jpg", 
		Filename = "itemClayPotFull.jpg", 
		Directives = {}
	}
}
objClayPotPour = Wherigo.ZMedia(objExcavationinSellersville)
objClayPotPour.Id = "9cffce37-ef93-487f-b712-4bcefe1a376f"
objClayPotPour.Name = "Clay Pot Pour"
objClayPotPour.Description = ""
objClayPotPour.AltText = ""
objClayPotPour.Resources = {
	{
		Type = "jpg", 
		Filename = "itemClayPotPour.jpg", 
		Directives = {}
	}
}
objClumpofDirt = Wherigo.ZMedia(objExcavationinSellersville)
objClumpofDirt.Id = "d37ad493-42d0-47e6-826a-1420fd3ecd83"
objClumpofDirt.Name = "Clump of Dirt"
objClumpofDirt.Description = ""
objClumpofDirt.AltText = ""
objClumpofDirt.Resources = {
	{
		Type = "jpg", 
		Filename = "itemClumpDirt.jpg", 
		Directives = {}
	}
}
objExcavationSite = Wherigo.ZMedia(objExcavationinSellersville)
objExcavationSite.Id = "85d750be-2798-4aea-9137-3dd0232bc17c"
objExcavationSite.Name = "Excavation Site"
objExcavationSite.Description = ""
objExcavationSite.AltText = ""
objExcavationSite.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneExcavation.jpg", 
		Directives = {}
	}
}
objFlashlightOff = Wherigo.ZMedia(objExcavationinSellersville)
objFlashlightOff.Id = "fe898b4d-7621-4f6b-b6c4-bb57defee70a"
objFlashlightOff.Name = "Flashlight Off"
objFlashlightOff.Description = ""
objFlashlightOff.AltText = ""
objFlashlightOff.Resources = {
	{
		Type = "jpg", 
		Filename = "itemFlashlightOff.jpg", 
		Directives = {}
	}
}
objFlashlightOn = Wherigo.ZMedia(objExcavationinSellersville)
objFlashlightOn.Id = "94db22f4-3dc8-4f4e-b6b8-41b9f3525245"
objFlashlightOn.Name = "Flashlight On"
objFlashlightOn.Description = ""
objFlashlightOn.AltText = ""
objFlashlightOn.Resources = {
	{
		Type = "jpg", 
		Filename = "itemFlashlightOn.jpg", 
		Directives = {}
	}
}
objInsideCaveDark = Wherigo.ZMedia(objExcavationinSellersville)
objInsideCaveDark.Id = "0af0f84e-7e9a-47f1-bca0-7b13c3f71cae"
objInsideCaveDark.Name = "Inside Cave-Dark"
objInsideCaveDark.Description = ""
objInsideCaveDark.AltText = ""
objInsideCaveDark.Resources = {
	{
		Type = "jpg", 
		Filename = "placeCaveDark.jpg", 
		Directives = {}
	}
}
objInsideCaveLightHandleDown = Wherigo.ZMedia(objExcavationinSellersville)
objInsideCaveLightHandleDown.Id = "46784034-4a28-4949-bbfc-50f7d85b5ccb"
objInsideCaveLightHandleDown.Name = "Inside Cave-Light-Handle Down"
objInsideCaveLightHandleDown.Description = ""
objInsideCaveLightHandleDown.AltText = ""
objInsideCaveLightHandleDown.Resources = {
	{
		Type = "jpg", 
		Filename = "placeCaveLight_HandleDown.jpg", 
		Directives = {}
	}
}
objInsideCaveLightHandleUp = Wherigo.ZMedia(objExcavationinSellersville)
objInsideCaveLightHandleUp.Id = "e81dfff8-c94c-4882-b993-55d92d6863cf"
objInsideCaveLightHandleUp.Name = "Inside Cave-Light-Handle Up"
objInsideCaveLightHandleUp.Description = ""
objInsideCaveLightHandleUp.AltText = ""
objInsideCaveLightHandleUp.Resources = {
	{
		Type = "jpg", 
		Filename = "placeCaveLight_HandleUp.jpg", 
		Directives = {}
	}
}
objJeep = Wherigo.ZMedia(objExcavationinSellersville)
objJeep.Id = "c3bdde3a-5aa0-464e-b63b-7c677ded0b87"
objJeep.Name = "Jeep"
objJeep.Description = ""
objJeep.AltText = ""
objJeep.Resources = {
	{
		Type = "jpg", 
		Filename = "itemJeep.jpg", 
		Directives = {}
	}
}
objKey = Wherigo.ZMedia(objExcavationinSellersville)
objKey.Id = "2e35dd99-bf81-42e0-871c-451dd8f25953"
objKey.Name = "Key"
objKey.Description = ""
objKey.AltText = ""
objKey.Resources = {
	{
		Type = "jpg", 
		Filename = "itemKey.jpg", 
		Directives = {}
	}
}
objMapPiece1 = Wherigo.ZMedia(objExcavationinSellersville)
objMapPiece1.Id = "27421960-1109-45b7-a8e5-9f1327237731"
objMapPiece1.Name = "Map Piece 1"
objMapPiece1.Description = ""
objMapPiece1.AltText = ""
objMapPiece1.Resources = {
	{
		Type = "jpg", 
		Filename = "itemMapPiece1.jpg", 
		Directives = {}
	}
}
objMapPiece2 = Wherigo.ZMedia(objExcavationinSellersville)
objMapPiece2.Id = "7d2d4615-3a29-40f8-858f-8cc38930b0f6"
objMapPiece2.Name = "Map Piece 2"
objMapPiece2.Description = ""
objMapPiece2.AltText = ""
objMapPiece2.Resources = {
	{
		Type = "jpg", 
		Filename = "itemMapPiece2.jpg", 
		Directives = {}
	}
}
objMapPiece3 = Wherigo.ZMedia(objExcavationinSellersville)
objMapPiece3.Id = "64bdda6d-ec9e-49f0-b0e5-adc9c05b7760"
objMapPiece3.Name = "Map Piece 3"
objMapPiece3.Description = ""
objMapPiece3.AltText = ""
objMapPiece3.Resources = {
	{
		Type = "jpg", 
		Filename = "itemMapPiece3.jpg", 
		Directives = {}
	}
}
objMapWhole = Wherigo.ZMedia(objExcavationinSellersville)
objMapWhole.Id = "11438a06-b108-4557-966c-4dec9d774d6e"
objMapWhole.Name = "Map Whole"
objMapWhole.Description = ""
objMapWhole.AltText = ""
objMapWhole.Resources = {
	{
		Type = "jpg", 
		Filename = "itemMapWhole.jpg", 
		Directives = {}
	}
}
objMystery = Wherigo.ZMedia(objExcavationinSellersville)
objMystery.Id = "948a055c-d06e-4f87-a722-d2b721aef602"
objMystery.Name = "Mystery"
objMystery.Description = ""
objMystery.AltText = ""
objMystery.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneMystery.jpg", 
		Directives = {}
	}
}
objNotch = Wherigo.ZMedia(objExcavationinSellersville)
objNotch.Id = "ed6f0ada-c4a4-4ddc-96e2-741edfbdccfa"
objNotch.Name = "Notch"
objNotch.Description = ""
objNotch.AltText = ""
objNotch.Resources = {
	{
		Type = "jpg", 
		Filename = "itemRockCaveNotch.jpg", 
		Directives = {}
	}
}
objParkingLot = Wherigo.ZMedia(objExcavationinSellersville)
objParkingLot.Id = "ebb46baf-df77-4b9b-b90a-f581e53797ac"
objParkingLot.Name = "Parking Lot"
objParkingLot.Description = ""
objParkingLot.AltText = ""
objParkingLot.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneParking.jpg", 
		Directives = {}
	}
}
objPhoneBook = Wherigo.ZMedia(objExcavationinSellersville)
objPhoneBook.Id = "456b04f4-75b7-470b-bcc5-27c44f6fd64f"
objPhoneBook.Name = "Phone Book"
objPhoneBook.Description = ""
objPhoneBook.AltText = ""
objPhoneBook.Resources = {
	{
		Type = "jpg", 
		Filename = "itemPhoneBook.jpg", 
		Directives = {}
	}
}
objPipe = Wherigo.ZMedia(objExcavationinSellersville)
objPipe.Id = "e49db222-56b2-41b4-93f7-a292ff8e6090"
objPipe.Name = "Pipe"
objPipe.Description = ""
objPipe.AltText = ""
objPipe.Resources = {
	{
		Type = "jpg", 
		Filename = "itemPipe.jpg", 
		Directives = {}
	}
}
objPond = Wherigo.ZMedia(objExcavationinSellersville)
objPond.Id = "514f52fb-f41f-4d8e-8186-7847abd1bda1"
objPond.Name = "Pond"
objPond.Description = ""
objPond.AltText = ""
objPond.Resources = {
	{
		Type = "jpg", 
		Filename = "zonePond.jpg", 
		Directives = {}
	}
}
objSave = Wherigo.ZMedia(objExcavationinSellersville)
objSave.Id = "ba247f43-46cf-426a-a5a2-67cb1832b7a5"
objSave.Name = "Save"
objSave.Description = ""
objSave.AltText = ""
objSave.Resources = {
	{
		Type = "jpg", 
		Filename = "itemSave.jpg", 
		Directives = {}
	}
}
objScroll = Wherigo.ZMedia(objExcavationinSellersville)
objScroll.Id = "2c404de0-5844-43be-9c0e-bfd37a2f98e3"
objScroll.Name = "Scroll"
objScroll.Description = ""
objScroll.AltText = ""
objScroll.Resources = {
	{
		Type = "jpg", 
		Filename = "itemScroll.jpg", 
		Directives = {}
	}
}
objShovel = Wherigo.ZMedia(objExcavationinSellersville)
objShovel.Id = "1c68dc22-192c-4834-b14f-aba452d47ef3"
objShovel.Name = "Shovel"
objShovel.Description = ""
objShovel.AltText = ""
objShovel.Resources = {
	{
		Type = "jpg", 
		Filename = "itemShovel.jpg", 
		Directives = {}
	}
}
objSplashTitle = Wherigo.ZMedia(objExcavationinSellersville)
objSplashTitle.Id = "400a0002-9d76-4747-ad86-2bd1cabcdea5"
objSplashTitle.Name = "Splash Title"
objSplashTitle.Description = ""
objSplashTitle.AltText = ""
objSplashTitle.Resources = {
	{
		Type = "jpg", 
		Filename = "splashTitle.jpg", 
		Directives = {}
	}
}
objTitle = Wherigo.ZMedia(objExcavationinSellersville)
objTitle.Id = "6866f8cf-3529-46c8-a49e-a18de1cbcd90"
objTitle.Name = "Title"
objTitle.Description = ""
objTitle.AltText = ""
objTitle.Resources = {
	{
		Type = "jpg", 
		Filename = "cartTitle.jpg", 
		Directives = {}
	}
}
objTreasureChestClosed = Wherigo.ZMedia(objExcavationinSellersville)
objTreasureChestClosed.Id = "c0fcbf4b-4dc6-4f2a-848e-0f552a52fe30"
objTreasureChestClosed.Name = "Treasure Chest Closed"
objTreasureChestClosed.Description = ""
objTreasureChestClosed.AltText = ""
objTreasureChestClosed.Resources = {
	{
		Type = "jpg", 
		Filename = "itemTreasureChestClosed.jpg", 
		Directives = {}
	}
}
objTreasureChestOpen = Wherigo.ZMedia(objExcavationinSellersville)
objTreasureChestOpen.Id = "d6fc38c8-44ad-4c17-ae18-85f7ee3aa4c4"
objTreasureChestOpen.Name = "Treasure Chest Open"
objTreasureChestOpen.Description = ""
objTreasureChestOpen.AltText = ""
objTreasureChestOpen.Resources = {
	{
		Type = "jpg", 
		Filename = "itemTreasureChestOpen.jpg", 
		Directives = {}
	}
}
objTreasureMap = Wherigo.ZMedia(objExcavationinSellersville)
objTreasureMap.Id = "3727bc5d-2f0e-41e8-b509-76142e3931e7"
objTreasureMap.Name = "Treasure Map"
objTreasureMap.Description = ""
objTreasureMap.AltText = ""
objTreasureMap.Resources = {
	{
		Type = "jpg", 
		Filename = "taskTreasureMap.jpg", 
		Directives = {}
	}
}
objiconBatteries = Wherigo.ZMedia(objExcavationinSellersville)
objiconBatteries.Id = "9fd0302a-8050-4c98-a991-1e267f6b2e10"
objiconBatteries.Name = "icon Batteries"
objiconBatteries.Description = ""
objiconBatteries.AltText = ""
objiconBatteries.Resources = {
	{
		Type = "jpg", 
		Filename = "iconBatteries.jpg", 
		Directives = {}
	}
}
objiconBookTranslate = Wherigo.ZMedia(objExcavationinSellersville)
objiconBookTranslate.Id = "09b05c6d-43f0-48f5-afc3-d234f8f07e29"
objiconBookTranslate.Name = "icon Book Translate"
objiconBookTranslate.Description = ""
objiconBookTranslate.AltText = ""
objiconBookTranslate.Resources = {
	{
		Type = "jpg", 
		Filename = "iconBookTranslate.jpg", 
		Directives = {}
	}
}
objiconClayPotEmpty = Wherigo.ZMedia(objExcavationinSellersville)
objiconClayPotEmpty.Id = "923623be-b6d5-4cc9-ab50-8fe0290c8816"
objiconClayPotEmpty.Name = "icon Clay Pot Empty"
objiconClayPotEmpty.Description = ""
objiconClayPotEmpty.AltText = ""
objiconClayPotEmpty.Resources = {
	{
		Type = "jpg", 
		Filename = "iconClayPotEmpty.jpg", 
		Directives = {}
	}
}
objiconClayPotFull = Wherigo.ZMedia(objExcavationinSellersville)
objiconClayPotFull.Id = "c7b6f5b7-9b6a-4da4-bfe6-0582322d8dc3"
objiconClayPotFull.Name = "icon Clay Pot Full"
objiconClayPotFull.Description = ""
objiconClayPotFull.AltText = ""
objiconClayPotFull.Resources = {
	{
		Type = "jpg", 
		Filename = "iconClayPotFull.jpg", 
		Directives = {}
	}
}
objiconClumpofDirt = Wherigo.ZMedia(objExcavationinSellersville)
objiconClumpofDirt.Id = "1c8573e7-5c13-4510-a2ac-db37e2cf666d"
objiconClumpofDirt.Name = "icon Clump of Dirt"
objiconClumpofDirt.Description = ""
objiconClumpofDirt.AltText = ""
objiconClumpofDirt.Resources = {
	{
		Type = "jpg", 
		Filename = "iconClumpDirt.jpg", 
		Directives = {}
	}
}
objiconExcavationZone = Wherigo.ZMedia(objExcavationinSellersville)
objiconExcavationZone.Id = "a5b14736-e597-4a8f-8ede-0b99c31a1f13"
objiconExcavationZone.Name = "icon Excavation Zone"
objiconExcavationZone.Description = ""
objiconExcavationZone.AltText = ""
objiconExcavationZone.Resources = {
	{
		Type = "jpg", 
		Filename = "iconExcavation.jpg", 
		Directives = {}
	}
}
objiconFlashlightOff = Wherigo.ZMedia(objExcavationinSellersville)
objiconFlashlightOff.Id = "871d9746-c918-4a2c-88ac-ae4217059ab2"
objiconFlashlightOff.Name = "icon Flashlight Off"
objiconFlashlightOff.Description = ""
objiconFlashlightOff.AltText = ""
objiconFlashlightOff.Resources = {
	{
		Type = "jpg", 
		Filename = "iconFlashlightOff.jpg", 
		Directives = {}
	}
}
objiconFlashlightOn = Wherigo.ZMedia(objExcavationinSellersville)
objiconFlashlightOn.Id = "dcef2c54-f1cd-4eec-9ba8-189ee4c81a5f"
objiconFlashlightOn.Name = "icon Flashlight On"
objiconFlashlightOn.Description = ""
objiconFlashlightOn.AltText = ""
objiconFlashlightOn.Resources = {
	{
		Type = "jpg", 
		Filename = "iconFlashlightOn.jpg", 
		Directives = {}
	}
}
objiconTitle = Wherigo.ZMedia(objExcavationinSellersville)
objiconTitle.Id = "e641df34-26e8-46f5-b7f6-480cc57512e5"
objiconTitle.Name = "icon Title"
objiconTitle.Description = ""
objiconTitle.AltText = ""
objiconTitle.Resources = {
	{
		Type = "jpg", 
		Filename = "iconTitle.jpg", 
		Directives = {}
	}
}
objiconJeep = Wherigo.ZMedia(objExcavationinSellersville)
objiconJeep.Id = "97d61fae-4c0e-49ea-b9c3-9ec775360c6c"
objiconJeep.Name = "icon Jeep"
objiconJeep.Description = ""
objiconJeep.AltText = ""
objiconJeep.Resources = {
	{
		Type = "jpg", 
		Filename = "iconJeep.jpg", 
		Directives = {}
	}
}
objiconKey = Wherigo.ZMedia(objExcavationinSellersville)
objiconKey.Id = "eb63618e-acf9-4491-8fc1-5b36fd6ca6eb"
objiconKey.Name = "icon Key"
objiconKey.Description = ""
objiconKey.AltText = ""
objiconKey.Resources = {
	{
		Type = "jpg", 
		Filename = "iconKey.jpg", 
		Directives = {}
	}
}
objiconMapWhole = Wherigo.ZMedia(objExcavationinSellersville)
objiconMapWhole.Id = "7c6df9d7-4d74-4132-80e9-9c7fb82c70ef"
objiconMapWhole.Name = "icon Map Whole"
objiconMapWhole.Description = ""
objiconMapWhole.AltText = ""
objiconMapWhole.Resources = {
	{
		Type = "jpg", 
		Filename = "iconMapWhole.jpg", 
		Directives = {}
	}
}
objiconPeacePipe = Wherigo.ZMedia(objExcavationinSellersville)
objiconPeacePipe.Id = "91403d3b-e885-481d-acd5-85051f177c18"
objiconPeacePipe.Name = "icon Peace Pipe"
objiconPeacePipe.Description = ""
objiconPeacePipe.AltText = ""
objiconPeacePipe.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPipe.jpg", 
		Directives = {}
	}
}
objiconPhoneBook = Wherigo.ZMedia(objExcavationinSellersville)
objiconPhoneBook.Id = "4b0248fe-02f5-4ec3-9cba-846b51566812"
objiconPhoneBook.Name = "icon Phone Book"
objiconPhoneBook.Description = ""
objiconPhoneBook.AltText = ""
objiconPhoneBook.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPhoneBook.jpg", 
		Directives = {}
	}
}
objiconMapPiece1 = Wherigo.ZMedia(objExcavationinSellersville)
objiconMapPiece1.Id = "7ba53527-5724-45fd-943d-6d824757ceb5"
objiconMapPiece1.Name = "icon Map Piece 1"
objiconMapPiece1.Description = ""
objiconMapPiece1.AltText = ""
objiconMapPiece1.Resources = {
	{
		Type = "jpg", 
		Filename = "iconMapPiece1.jpg", 
		Directives = {}
	}
}
objiconMapPiece2 = Wherigo.ZMedia(objExcavationinSellersville)
objiconMapPiece2.Id = "dbef492b-fd38-4d99-8688-efe6ec646639"
objiconMapPiece2.Name = "icon Map Piece 2"
objiconMapPiece2.Description = ""
objiconMapPiece2.AltText = ""
objiconMapPiece2.Resources = {
	{
		Type = "jpg", 
		Filename = "iconMapPiece2.jpg", 
		Directives = {}
	}
}
objiconMapPiece3 = Wherigo.ZMedia(objExcavationinSellersville)
objiconMapPiece3.Id = "2cdbe545-bdfb-4823-8657-55afe14a952b"
objiconMapPiece3.Name = "icon Map Piece 3"
objiconMapPiece3.Description = ""
objiconMapPiece3.AltText = ""
objiconMapPiece3.Resources = {
	{
		Type = "jpg", 
		Filename = "iconMapPiece3.jpg", 
		Directives = {}
	}
}
objiconRockCaveClosed = Wherigo.ZMedia(objExcavationinSellersville)
objiconRockCaveClosed.Id = "897104b0-ad9b-4e4b-82c1-845b7b7c4bce"
objiconRockCaveClosed.Name = "icon Rock Cave Closed"
objiconRockCaveClosed.Description = ""
objiconRockCaveClosed.AltText = ""
objiconRockCaveClosed.Resources = {
	{
		Type = "jpg", 
		Filename = "iconRockCaveClosed.jpg", 
		Directives = {}
	}
}
objiconRockCaveOpen = Wherigo.ZMedia(objExcavationinSellersville)
objiconRockCaveOpen.Id = "34de23a9-2bbc-44ca-b3fa-c6265f9dbd02"
objiconRockCaveOpen.Name = "icon Rock Cave Open"
objiconRockCaveOpen.Description = ""
objiconRockCaveOpen.AltText = ""
objiconRockCaveOpen.Resources = {
	{
		Type = "jpg", 
		Filename = "iconRockCaveOpen.jpg", 
		Directives = {}
	}
}
objiconSave = Wherigo.ZMedia(objExcavationinSellersville)
objiconSave.Id = "85fae170-2904-4cf9-aaca-9b7ede0d2e03"
objiconSave.Name = "icon Save"
objiconSave.Description = ""
objiconSave.AltText = ""
objiconSave.Resources = {
	{
		Type = "jpg", 
		Filename = "iconSave.jpg", 
		Directives = {}
	}
}
objiconScroll = Wherigo.ZMedia(objExcavationinSellersville)
objiconScroll.Id = "3af14e2b-1e7c-44ed-acda-04fcb7a8e5a9"
objiconScroll.Name = "icon Scroll"
objiconScroll.Description = ""
objiconScroll.AltText = ""
objiconScroll.Resources = {
	{
		Type = "jpg", 
		Filename = "iconScroll.jpg", 
		Directives = {}
	}
}
objiconShovel = Wherigo.ZMedia(objExcavationinSellersville)
objiconShovel.Id = "fb933d5a-9cfc-455c-b3b2-0429036ff8fa"
objiconShovel.Name = "icon Shovel"
objiconShovel.Description = ""
objiconShovel.AltText = ""
objiconShovel.Resources = {
	{
		Type = "jpg", 
		Filename = "iconShovel.jpg", 
		Directives = {}
	}
}
objiconTreasureChestClosed = Wherigo.ZMedia(objExcavationinSellersville)
objiconTreasureChestClosed.Id = "87ccf44e-5e56-4e2b-9977-5ad07adf9706"
objiconTreasureChestClosed.Name = "icon Treasure Chest Closed"
objiconTreasureChestClosed.Description = ""
objiconTreasureChestClosed.AltText = ""
objiconTreasureChestClosed.Resources = {
	{
		Type = "jpg", 
		Filename = "iconTreasureChestClosed.jpg", 
		Directives = {}
	}
}
objiconTreasureChestOpen = Wherigo.ZMedia(objExcavationinSellersville)
objiconTreasureChestOpen.Id = "1bcfa908-3be4-42aa-9c8f-a784b128ee9d"
objiconTreasureChestOpen.Name = "icon Treasure Chest Open"
objiconTreasureChestOpen.Description = ""
objiconTreasureChestOpen.AltText = ""
objiconTreasureChestOpen.Resources = {
	{
		Type = "jpg", 
		Filename = "iconTreasureChestOpen.jpg", 
		Directives = {}
	}
}
objiconMysteryZone = Wherigo.ZMedia(objExcavationinSellersville)
objiconMysteryZone.Id = "2d0d439a-e9ff-4b76-b0d2-02181c35a9fe"
objiconMysteryZone.Name = "icon Mystery Zone"
objiconMysteryZone.Description = ""
objiconMysteryZone.AltText = ""
objiconMysteryZone.Resources = {
	{
		Type = "jpg", 
		Filename = "iconMystery.jpg", 
		Directives = {}
	}
}
objiconParkingLot = Wherigo.ZMedia(objExcavationinSellersville)
objiconParkingLot.Id = "a8767675-f05d-450e-80cf-98e05e674ce8"
objiconParkingLot.Name = "icon Parking Lot"
objiconParkingLot.Description = ""
objiconParkingLot.AltText = ""
objiconParkingLot.Resources = {
	{
		Type = "jpg", 
		Filename = "iconParking.jpg", 
		Directives = {}
	}
}
objiconPondZone = Wherigo.ZMedia(objExcavationinSellersville)
objiconPondZone.Id = "be54a77b-37a3-47ab-a428-e2c14c96fd25"
objiconPondZone.Name = "icon Pond Zone"
objiconPondZone.Description = ""
objiconPondZone.AltText = ""
objiconPondZone.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPond.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
objExcavationinSellersville.Id="786d8ad6-a068-420a-bcf8-4adce22c01dc"
objExcavationinSellersville.Name="Excavation in Sellersville"
objExcavationinSellersville.Description=[[]]
objExcavationinSellersville.Visible=true
objExcavationinSellersville.Activity="Geocache"
objExcavationinSellersville.StartingLocationDescription=[[]]
objExcavationinSellersville.StartingLocation = ZonePoint(40.3626057355301,-75.3390723466873,0)
objExcavationinSellersville.Version="1.7"
objExcavationinSellersville.Company=""
objExcavationinSellersville.Author="ggggeo2"
objExcavationinSellersville.BuilderVersion="URWIGO 1.14.4469.18959"
objExcavationinSellersville.CreateDate="01/22/2012 04:57:46"
objExcavationinSellersville.PublishDate="1/1/0001 12:00:00 AM"
objExcavationinSellersville.UpdateDate="04/01/2012 00:04:14"
objExcavationinSellersville.LastPlayedDate="1/1/0001 12:00:00 AM"
objExcavationinSellersville.TargetDevice="PocketPC"
objExcavationinSellersville.TargetDeviceVersion="0"
objExcavationinSellersville.StateId="1"
objExcavationinSellersville.CountryId="2"
objExcavationinSellersville.Complete=false
objExcavationinSellersville.UseLogging=true

objExcavationinSellersville.Media=objTitle

objExcavationinSellersville.Icon=objiconTitle


-- Zones --
objExcavationZone1 = Wherigo.Zone(objExcavationinSellersville)
objExcavationZone1.Id = "58393b75-2728-4972-b9be-8d79939c2018"
objExcavationZone1.Name = "Excavation Zone 1"
objExcavationZone1.Description = "The first of three excavation sites you would like to check out."
objExcavationZone1.Visible = false
objExcavationZone1.Media = objExcavationSite
objExcavationZone1.Icon = objiconExcavationZone
objExcavationZone1.Commands = {}
objExcavationZone1.DistanceRange = Distance(-1, "feet")
objExcavationZone1.ShowObjects = "OnEnter"
objExcavationZone1.ProximityRange = Distance(0, "feet")
objExcavationZone1.AllowSetPositionTo = false
objExcavationZone1.Active = false
objExcavationZone1.Points = {
	ZonePoint(40.362922514338, -75.338584184647, 0), 
	ZonePoint(40.363024700733, -75.338761210442, 0), 
	ZonePoint(40.362769234456, -75.338989198208, 0), 
	ZonePoint(40.362683397569, -75.338814854622, 0)
}
objExcavationZone1.OriginalPoint = ZonePoint(40.362810109125, -75.338814854622, 0)
objExcavationZone1.DistanceRangeUOM = "Feet"
objExcavationZone1.ProximityRangeUOM = "Feet"
objExcavationZone1.OutOfRangeName = ""
objExcavationZone1.InRangeName = ""
objExcavationZone2 = Wherigo.Zone(objExcavationinSellersville)
objExcavationZone2.Id = "48b94f3c-e4d1-41ba-a164-b2fff8d5f10f"
objExcavationZone2.Name = "Excavation Zone 2"
objExcavationZone2.Description = "The second of three excavation sites you would like to check out."
objExcavationZone2.Visible = false
objExcavationZone2.Media = objExcavationSite
objExcavationZone2.Icon = objiconExcavationZone
objExcavationZone2.Commands = {}
objExcavationZone2.DistanceRange = Distance(-1, "feet")
objExcavationZone2.ShowObjects = "OnEnter"
objExcavationZone2.ProximityRange = Distance(0, "feet")
objExcavationZone2.AllowSetPositionTo = false
objExcavationZone2.Active = false
objExcavationZone2.Points = {
	ZonePoint(40.363421182478, -75.339080393314, 0), 
	ZonePoint(40.363292428352, -75.339184999466, 0), 
	ZonePoint(40.363065575247, -75.338734388351, 0), 
	ZonePoint(40.363188198642, -75.338624417782, 0)
}
objExcavationZone2.OriginalPoint = ZonePoint(40.363251553976, -75.338884592056, 0)
objExcavationZone2.DistanceRangeUOM = "Feet"
objExcavationZone2.ProximityRangeUOM = "Feet"
objExcavationZone2.OutOfRangeName = ""
objExcavationZone2.InRangeName = ""
objExcavationZone3 = Wherigo.Zone(objExcavationinSellersville)
objExcavationZone3.Id = "d949daa7-e5bc-413c-9871-ee06f5b3dcdd"
objExcavationZone3.Name = "Excavation Zone 3"
objExcavationZone3.Description = "The third of three excavation sites you would like to check out."
objExcavationZone3.Visible = false
objExcavationZone3.Media = objExcavationSite
objExcavationZone3.Icon = objiconExcavationZone
objExcavationZone3.Commands = {}
objExcavationZone3.DistanceRange = Distance(-1, "feet")
objExcavationZone3.ShowObjects = "OnEnter"
objExcavationZone3.ProximityRange = Distance(0, "feet")
objExcavationZone3.AllowSetPositionTo = false
objExcavationZone3.Active = false
objExcavationZone3.Points = {
	ZonePoint(40.36300835092, -75.339455902576, 0), 
	ZonePoint(40.363257685134, -75.339225232601, 0), 
	ZonePoint(40.363349652439, -75.339394211769, 0), 
	ZonePoint(40.36308805622, -75.339630246162, 0)
}
objExcavationZone3.OriginalPoint = ZonePoint(40.363206592132, -75.339415669441, 0)
objExcavationZone3.DistanceRangeUOM = "Feet"
objExcavationZone3.ProximityRangeUOM = "Feet"
objExcavationZone3.OutOfRangeName = ""
objExcavationZone3.InRangeName = ""
objExcavationZone4 = Wherigo.Zone(objExcavationinSellersville)
objExcavationZone4.Id = "54482418-fda5-4953-9870-d4a08b2d8360"
objExcavationZone4.Name = "Excavation Zone 4"
objExcavationZone4.Description = "This is the first of two new excavation zones you would like to check out."
objExcavationZone4.Visible = false
objExcavationZone4.Media = objExcavationSite
objExcavationZone4.Icon = objiconExcavationZone
objExcavationZone4.Commands = {}
objExcavationZone4.DistanceRange = Distance(-1, "feet")
objExcavationZone4.ShowObjects = "OnEnter"
objExcavationZone4.ProximityRange = Distance(0, "feet")
objExcavationZone4.AllowSetPositionTo = false
objExcavationZone4.Active = false
objExcavationZone4.Points = {
	ZonePoint(40.363645990678, -75.341387093067, 0), 
	ZonePoint(40.363531542961, -75.341655313969, 0), 
	ZonePoint(40.363390526756, -75.341574847698, 0), 
	ZonePoint(40.363502931001, -75.341293215752, 0)
}
objExcavationZone4.OriginalPoint = ZonePoint(40.363500887289, -75.341448783874, 0)
objExcavationZone4.DistanceRangeUOM = "Feet"
objExcavationZone4.ProximityRangeUOM = "Feet"
objExcavationZone4.OutOfRangeName = ""
objExcavationZone4.InRangeName = ""
objExcavationZone5 = Wherigo.Zone(objExcavationinSellersville)
objExcavationZone5.Id = "824fb072-a627-4c95-8dfb-bbf1bf228e72"
objExcavationZone5.Name = "Excavation Zone 5"
objExcavationZone5.Description = "This is the second of two new excavation zones you would like to check out."
objExcavationZone5.Visible = false
objExcavationZone5.Media = objExcavationSite
objExcavationZone5.Icon = objiconExcavationZone
objExcavationZone5.Commands = {}
objExcavationZone5.DistanceRange = Distance(-1, "feet")
objExcavationZone5.ShowObjects = "OnEnter"
objExcavationZone5.ProximityRange = Distance(0, "feet")
objExcavationZone5.AllowSetPositionTo = false
objExcavationZone5.Active = false
objExcavationZone5.Points = {
	ZonePoint(40.36291638315, -75.341915488243, 0), 
	ZonePoint(40.36275697205, -75.342076420784, 0), 
	ZonePoint(40.362589385616, -75.341824293137, 0), 
	ZonePoint(40.362746753377, -75.341655313969, 0)
}
objExcavationZone5.OriginalPoint = ZonePoint(40.362746753377, -75.341875255108, 0)
objExcavationZone5.DistanceRangeUOM = "Feet"
objExcavationZone5.ProximityRangeUOM = "Feet"
objExcavationZone5.OutOfRangeName = ""
objExcavationZone5.InRangeName = ""
objExcavationZone6 = Wherigo.Zone(objExcavationinSellersville)
objExcavationZone6.Id = "73315cea-d4a1-478e-ab77-3b4a5a7a786a"
objExcavationZone6.Name = "Excavation Zone 6"
objExcavationZone6.Description = "Yet another excavation zone you would like to check out. How many sites can there be?"
objExcavationZone6.Visible = false
objExcavationZone6.Media = objExcavationSite
objExcavationZone6.Icon = objiconExcavationZone
objExcavationZone6.Commands = {}
objExcavationZone6.DistanceRange = Distance(-1, "feet")
objExcavationZone6.ShowObjects = "OnEnter"
objExcavationZone6.ProximityRange = Distance(0, "feet")
objExcavationZone6.AllowSetPositionTo = false
objExcavationZone6.Active = false
objExcavationZone6.Points = {
	ZonePoint(40.362928645526, -75.343412160873, 0), 
	ZonePoint(40.363043094268, -75.34361332655, 0), 
	ZonePoint(40.362861202427, -75.343835949898, 0), 
	ZonePoint(40.362744709642, -75.343637466431, 0)
}
objExcavationZone6.OriginalPoint = ZonePoint(40.362881639737, -75.343632102013, 0)
objExcavationZone6.DistanceRangeUOM = "Feet"
objExcavationZone6.ProximityRangeUOM = "Feet"
objExcavationZone6.OutOfRangeName = ""
objExcavationZone6.InRangeName = ""
objMysteryZone = Wherigo.Zone(objExcavationinSellersville)
objMysteryZone.Id = "d07b9af7-8cc6-483c-a662-07d1421f8693"
objMysteryZone.Name = "Mystery Zone"
objMysteryZone.Description = "You sense something mysterious and strange emanating from here..."
objMysteryZone.Visible = false
objMysteryZone.Media = objMystery
objMysteryZone.Icon = objiconMysteryZone
objMysteryZone.Commands = {}
objMysteryZone.DistanceRange = Distance(-1, "feet")
objMysteryZone.ShowObjects = "OnEnter"
objMysteryZone.ProximityRange = Distance(0, "feet")
objMysteryZone.AllowSetPositionTo = false
objMysteryZone.Active = false
objMysteryZone.Points = {
	ZonePoint(40.361966666667, -75.342733333333, 0), 
	ZonePoint(40.361783333333, -75.342766666667, 0), 
	ZonePoint(40.36175, -75.342433333333, 0), 
	ZonePoint(40.361933333333, -75.3424, 0)
}
objMysteryZone.OriginalPoint = ZonePoint(40.361845460318, -75.342580676079, 0)
objMysteryZone.DistanceRangeUOM = "Feet"
objMysteryZone.ProximityRangeUOM = "Feet"
objMysteryZone.OutOfRangeName = ""
objMysteryZone.InRangeName = ""
objParkingLot1 = Wherigo.Zone(objExcavationinSellersville)
objParkingLot1.Id = "7a76d877-d3d7-43e1-9dfb-d23c0d89f570"
objParkingLot1.Name = "Parking Lot"
objParkingLot1.Description = "It is a parking lot. You know, for cars and stuff?"
objParkingLot1.Visible = true
objParkingLot1.Media = objParkingLot
objParkingLot1.Icon = objiconParkingLot
objParkingLot1.Commands = {}
objParkingLot1.DistanceRange = Distance(-1, "feet")
objParkingLot1.ShowObjects = "OnEnter"
objParkingLot1.ProximityRange = Distance(0, "feet")
objParkingLot1.AllowSetPositionTo = false
objParkingLot1.Active = true
objParkingLot1.Points = {
	ZonePoint(40.363075793872, -75.339863598347, 0), 
	ZonePoint(40.362924558068, -75.339984297752, 0), 
	ZonePoint(40.362411580042, -75.338981151581, 0), 
	ZonePoint(40.362558729516, -75.338860452175, 0)
}
objParkingLot1.OriginalPoint = ZonePoint(40.362523985919, -75.339018702507, 0)
objParkingLot1.DistanceRangeUOM = "Feet"
objParkingLot1.ProximityRangeUOM = "Feet"
objParkingLot1.OutOfRangeName = ""
objParkingLot1.InRangeName = ""
objPond1 = Wherigo.Zone(objExcavationinSellersville)
objPond1.Id = "0f8794c8-d303-4cad-bd35-aa50b0837987"
objPond1.Name = "Pond"
objPond1.Description = "There is a nice little pond here. Why not have a seat and relax for a bit?"
objPond1.Visible = false
objPond1.Media = objPond
objPond1.Icon = objiconPondZone
objPond1.Commands = {}
objPond1.DistanceRange = Distance(-1, "feet")
objPond1.ShowObjects = "OnEnter"
objPond1.ProximityRange = Distance(0, "feet")
objPond1.AllowSetPositionTo = false
objPond1.Active = false
objPond1.Points = {
	ZonePoint(40.363970939389, -75.339032113552, 0), 
	ZonePoint(40.364310192346, -75.339767038822, 0), 
	ZonePoint(40.363594897884, -75.340027213097, 0), 
	ZonePoint(40.363672558871, -75.339096486568, 0)
}
objPond1.OriginalPoint = ZonePoint(40.363885104033, -75.339603424072, 0)
objPond1.DistanceRangeUOM = "Feet"
objPond1.ProximityRangeUOM = "Feet"
objPond1.OutOfRangeName = ""
objPond1.InRangeName = ""
objRockyOutcropping = Wherigo.Zone(objExcavationinSellersville)
objRockyOutcropping.Id = "d0569427-c9a7-42f9-b0c6-f2ca3c392e01"
objRockyOutcropping.Name = "Rocky Outcropping"
objRockyOutcropping.Description = "This area is very rocky. A large outcropping here might warrant further investigation..."
objRockyOutcropping.Visible = false
objRockyOutcropping.Media = objCaveClosed
objRockyOutcropping.Icon = objiconRockCaveClosed
objRockyOutcropping.Commands = {}
objRockyOutcropping.DistanceRange = Distance(-1, "feet")
objRockyOutcropping.ShowObjects = "OnEnter"
objRockyOutcropping.ProximityRange = Distance(0, "feet")
objRockyOutcropping.AllowSetPositionTo = false
objRockyOutcropping.Active = false
objRockyOutcropping.Points = {
	ZonePoint(40.362270561494, -75.342470705509, 0), 
	ZonePoint(40.362499461016, -75.3427952528, 0), 
	ZonePoint(40.362311436465, -75.342996418476, 0), 
	ZonePoint(40.362092755078, -75.342674553394, 0)
}
objRockyOutcropping.OriginalPoint = ZonePoint(40.362258298997, -75.342757701874, 0)
objRockyOutcropping.DistanceRangeUOM = "Feet"
objRockyOutcropping.ProximityRangeUOM = "Feet"
objRockyOutcropping.OutOfRangeName = ""
objRockyOutcropping.InRangeName = ""

-- Characters --

-- Items --
objBatteries1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objParkingLot1
}
objBatteries1.Id = "cc10679a-ce21-4131-bdb8-41ea9262c07d"
objBatteries1.Name = "Batteries"
objBatteries1.Description = "A fresh set of batteries"
objBatteries1.Visible = false
objBatteries1.Media = objBatteries
objBatteries1.Icon = objiconBatteries
objBatteries1.Commands = {
	cmdReplaceBatteries = Wherigo.ZCommand{
		Text = "Replace Batteries", 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = "That would work...if you had more batteries."
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objBatteries1.Commands.cmdReplaceBatteries.Custom = true
objBatteries1.Commands.cmdReplaceBatteries.Id = "61ef6399-1d4c-4d58-ad88-10203d178af1"
objBatteries1.Commands.cmdReplaceBatteries.WorksWithAll = false
objBatteries1.Commands.cmdReplaceBatteries.WorksWithListIds = {
	"9fa0fb1d-52b2-4377-8fc0-a768b03df22a"
}
objBatteries1.Commands.cmdTake.Custom = true
objBatteries1.Commands.cmdTake.Id = "99a92774-b213-4e7e-b65d-2fa6273130c8"
objBatteries1.Commands.cmdTake.WorksWithAll = true
objBatteries1.ObjectLocation = ZonePoint(40.362523985919, -75.339018702507, 0)
objBatteries1.Locked = false
objBatteries1.Opened = false
objClayPot = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objExcavationZone3
}
objClayPot.Id = "9d96ed8d-1697-488e-a4dc-1fcf3c2c5193"
objClayPot.Name = "Clay Pot"
objClayPot.Description = "An old clay pot"
objClayPot.Visible = false
objClayPot.Media = objClayPotEmpty
objClayPot.Icon = objiconClayPotEmpty
objClayPot.Commands = {
	cmdFillPotWithWater = Wherigo.ZCommand{
		Text = "Fill Pot With Water", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objClayPot.Commands.cmdFillPotWithWater.Custom = true
objClayPot.Commands.cmdFillPotWithWater.Id = "659468f6-b4b8-415e-9671-e1e1f2f7e7c6"
objClayPot.Commands.cmdFillPotWithWater.WorksWithAll = true
objClayPot.Commands.cmdTake.Custom = true
objClayPot.Commands.cmdTake.Id = "d8baaa89-af48-4bc6-a7db-41262ed16005"
objClayPot.Commands.cmdTake.WorksWithAll = true
objClayPot.ObjectLocation = ZonePoint(40.363206592132, -75.339415669441, 0)
objClayPot.Locked = false
objClayPot.Opened = false
objClayPotwithWater = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objPond1
}
objClayPotwithWater.Id = "996a1e79-4ad5-46fb-9367-f64fde026fb5"
objClayPotwithWater.Name = "Clay Pot with Water"
objClayPotwithWater.Description = "An old clay pot full of water"
objClayPotwithWater.Visible = false
objClayPotwithWater.Media = objClayPotFull
objClayPotwithWater.Icon = objiconClayPotFull
objClayPotwithWater.Commands = {
	cmdPourWaterOn = Wherigo.ZCommand{
		Text = "Pour Water On...", 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = "You can't pour water on that!"
	}
}
objClayPotwithWater.Commands.cmdPourWaterOn.Custom = true
objClayPotwithWater.Commands.cmdPourWaterOn.Id = "97f2a789-e4d8-4be8-9fb3-d3829455f703"
objClayPotwithWater.Commands.cmdPourWaterOn.WorksWithAll = false
objClayPotwithWater.Commands.cmdPourWaterOn.WorksWithListIds = {
	"00a1643a-cdce-415f-8433-8ebca795f3a2", 
	"0bf56de3-a7b1-468e-86c5-c556007b9cd4", 
	"cd80cb67-1050-4464-a55d-88b0fa296ca6", 
	"bb9bc3ba-ae5d-4f29-a8fb-32bec534fcbb", 
	"cc10679a-ce21-4131-bdb8-41ea9262c07d"
}
objClayPotwithWater.ObjectLocation = ZonePoint(40.363885104033, -75.339603424072, 0)
objClayPotwithWater.Locked = false
objClayPotwithWater.Opened = false
objClumpofDirt1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objExcavationZone5
}
objClumpofDirt1.Id = "bb9bc3ba-ae5d-4f29-a8fb-32bec534fcbb"
objClumpofDirt1.Name = "Clump of Dirt"
objClumpofDirt1.Description = "A big clump of dirt"
objClumpofDirt1.Visible = false
objClumpofDirt1.Media = objClumpofDirt
objClumpofDirt1.Icon = objiconClumpofDirt
objClumpofDirt1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objClumpofDirt1.Commands.cmdTake.Custom = true
objClumpofDirt1.Commands.cmdTake.Id = "a928f35c-1d40-4ca5-a023-f4c6d17b331f"
objClumpofDirt1.Commands.cmdTake.WorksWithAll = true
objClumpofDirt1.ObjectLocation = ZonePoint(40.362746753377, -75.341875255108, 0)
objClumpofDirt1.Locked = false
objClumpofDirt1.Opened = false
objFlashlight = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objParkingLot1
}
objFlashlight.Id = "9fa0fb1d-52b2-4377-8fc0-a768b03df22a"
objFlashlight.Name = "Flashlight"
objFlashlight.Description = "Your heavy-duty flashlight. It can help you see in dark places."
objFlashlight.Visible = false
objFlashlight.Media = objFlashlightOff
objFlashlight.Icon = objiconFlashlightOff
objFlashlight.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTurnOff = Wherigo.ZCommand{
		Text = "Turn Off", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTurnOn = Wherigo.ZCommand{
		Text = "Turn On", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objFlashlight.Commands.cmdTake.Custom = true
objFlashlight.Commands.cmdTake.Id = "a317b82a-f6b7-46ba-8618-4410db1e7534"
objFlashlight.Commands.cmdTake.WorksWithAll = true
objFlashlight.Commands.cmdTurnOff.Custom = true
objFlashlight.Commands.cmdTurnOff.Id = "c63b3d97-450d-42e4-be2e-52ce1c7e85e0"
objFlashlight.Commands.cmdTurnOff.WorksWithAll = true
objFlashlight.Commands.cmdTurnOn.Custom = true
objFlashlight.Commands.cmdTurnOn.Id = "e0801e0a-7a7f-493a-97bf-c035d55b10f3"
objFlashlight.Commands.cmdTurnOn.WorksWithAll = true
objFlashlight.ObjectLocation = ZonePoint(40.362523985919, -75.339018702507, 0)
objFlashlight.Locked = false
objFlashlight.Opened = false
objJeep1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objParkingLot1
}
objJeep1.Id = "cd80cb67-1050-4464-a55d-88b0fa296ca6"
objJeep1.Name = "Jeep"
objJeep1.Description = "Your trusty steed"
objJeep1.Visible = true
objJeep1.Media = objJeep
objJeep1.Icon = objiconJeep
objJeep1.Commands = {
	cmdSearch = Wherigo.ZCommand{
		Text = "Search", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdSearchGlovebox = Wherigo.ZCommand{
		Text = "Search Glovebox", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objJeep1.Commands.cmdSearch.Custom = true
objJeep1.Commands.cmdSearch.Id = "25a2231c-12d0-485d-b7b8-4138e6452137"
objJeep1.Commands.cmdSearch.WorksWithAll = true
objJeep1.Commands.cmdSearchGlovebox.Custom = true
objJeep1.Commands.cmdSearchGlovebox.Id = "b07be556-46b3-4329-b9b6-2288be65adc3"
objJeep1.Commands.cmdSearchGlovebox.WorksWithAll = true
objJeep1.Commands.cmdTake.Custom = true
objJeep1.Commands.cmdTake.Id = "879f6637-4817-4a67-a9a0-5bc3c6db9d21"
objJeep1.Commands.cmdTake.WorksWithAll = true
objJeep1.ObjectLocation = ZonePoint(40.362523985919, -75.339018702507, 0)
objJeep1.Locked = false
objJeep1.Opened = false
objKey1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objExcavationZone5
}
objKey1.Id = "00a1643a-cdce-415f-8433-8ebca795f3a2"
objKey1.Name = "Key"
objKey1.Description = "A shiny metal key"
objKey1.Visible = false
objKey1.Media = objKey
objKey1.Icon = objiconKey
objKey1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdUnlockTreasureChest = Wherigo.ZCommand{
		Text = "Unlock Treasure Chest", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "It doesn't unlock"
	}
}
objKey1.Commands.cmdTake.Custom = true
objKey1.Commands.cmdTake.Id = "20b031a5-08f9-489a-921b-c7a7941c52cf"
objKey1.Commands.cmdTake.WorksWithAll = true
objKey1.Commands.cmdUnlockTreasureChest.Custom = true
objKey1.Commands.cmdUnlockTreasureChest.Id = "69d99fae-c7ef-411c-9102-99c0de6a18cd"
objKey1.Commands.cmdUnlockTreasureChest.WorksWithAll = true
objKey1.ObjectLocation = ZonePoint(40.362746753377, -75.341875255108, 0)
objKey1.Locked = false
objKey1.Opened = false
objLanguagesBook = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objParkingLot1
}
objLanguagesBook.Id = "36b72b0d-e4a3-4a84-b352-a131eaf4a437"
objLanguagesBook.Name = "Languages Book"
objLanguagesBook.Description = "Your book on Native American Languages"
objLanguagesBook.Visible = false
objLanguagesBook.Media = objBook
objLanguagesBook.Icon = objiconBookTranslate
objLanguagesBook.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objLanguagesBook.Commands.cmdTake.Custom = true
objLanguagesBook.Commands.cmdTake.Id = "3c651169-8f49-4fb2-af92-e8f77656577d"
objLanguagesBook.Commands.cmdTake.WorksWithAll = true
objLanguagesBook.ObjectLocation = ZonePoint(40.362523985919, -75.339018702507, 0)
objLanguagesBook.Locked = true
objLanguagesBook.Opened = false
objMap = Wherigo.ZItem(objExcavationinSellersville)
objMap.Id = "9693f576-33fb-4823-9db6-d4e947fc2154"
objMap.Name = "Map"
objMap.Description = "A whole map assembled from the three pieces of clay tablet you found"
objMap.Visible = false
objMap.Media = objMapWhole
objMap.Icon = objiconMapWhole
objMap.Commands = {
	cmdRead = Wherigo.ZCommand{
		Text = "Read", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdReadTranslation = Wherigo.ZCommand{
		Text = "Read Translation", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTranslate = Wherigo.ZCommand{
		Text = "Translate", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objMap.Commands.cmdRead.Custom = true
objMap.Commands.cmdRead.Id = "dc6df48e-417a-44a4-bcf8-c390aee69327"
objMap.Commands.cmdRead.WorksWithAll = true
objMap.Commands.cmdReadTranslation.Custom = true
objMap.Commands.cmdReadTranslation.Id = "1deee3be-bfa3-4765-bb95-8ff37d0418db"
objMap.Commands.cmdReadTranslation.WorksWithAll = true
objMap.Commands.cmdTranslate.Custom = true
objMap.Commands.cmdTranslate.Id = "3f728a67-77b6-4130-a320-ce18d0fce522"
objMap.Commands.cmdTranslate.WorksWithAll = true
objMap.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objMap.Locked = false
objMap.Opened = false
objPeacePipe = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objExcavationZone1
}
objPeacePipe.Id = "ae4267b8-3b4b-49be-aa92-42324515e15d"
objPeacePipe.Name = "Peace Pipe"
objPeacePipe.Description = "An old clay peace pipe"
objPeacePipe.Visible = false
objPeacePipe.Media = objPipe
objPeacePipe.Icon = objiconPeacePipe
objPeacePipe.Commands = {
	cmdInsertinnotch = Wherigo.ZCommand{
		Text = "Insert in notch", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objPeacePipe.Commands.cmdInsertinnotch.Custom = true
objPeacePipe.Commands.cmdInsertinnotch.Id = "f3bd24c3-b078-47fb-aeaf-392c99b0a23b"
objPeacePipe.Commands.cmdInsertinnotch.WorksWithAll = true
objPeacePipe.Commands.cmdTake.Custom = true
objPeacePipe.Commands.cmdTake.Id = "66abacce-25ca-435c-8142-712d27019fe0"
objPeacePipe.Commands.cmdTake.WorksWithAll = true
objPeacePipe.ObjectLocation = ZonePoint(40.362810109125, -75.338814854622, 0)
objPeacePipe.Locked = false
objPeacePipe.Opened = false
objPhoneBook1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objParkingLot1
}
objPhoneBook1.Id = "563a5e3f-53b1-4f01-8776-6ab49d223234"
objPhoneBook1.Name = "Phone Book"
objPhoneBook1.Description = "Your personal phone book; you should check here if you get stuck or have problems with the game"
objPhoneBook1.Visible = false
objPhoneBook1.Media = objPhoneBook
objPhoneBook1.Icon = objiconPhoneBook
objPhoneBook1.Commands = {
	cmdRead = Wherigo.ZCommand{
		Text = "Read", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objPhoneBook1.Commands.cmdRead.Custom = true
objPhoneBook1.Commands.cmdRead.Id = "a192c1aa-7dea-447d-91da-1fa358723db2"
objPhoneBook1.Commands.cmdRead.WorksWithAll = true
objPhoneBook1.Commands.cmdTake.Custom = true
objPhoneBook1.Commands.cmdTake.Id = "0e5cc4e1-877f-41c7-901d-d50d95e542ad"
objPhoneBook1.Commands.cmdTake.WorksWithAll = true
objPhoneBook1.ObjectLocation = ZonePoint(40.362523985919, -75.339018702507, 0)
objPhoneBook1.Locked = false
objPhoneBook1.Opened = false
objPieceofMap1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objExcavationZone2
}
objPieceofMap1.Id = "09cd8190-4885-41e8-915d-f12fa174f19e"
objPieceofMap1.Name = "Piece of Map (1)"
objPieceofMap1.Description = "An old clay tablet...it looks like a part of a map"
objPieceofMap1.Visible = false
objPieceofMap1.Media = objMapPiece1
objPieceofMap1.Icon = objiconMapPiece1
objPieceofMap1.Commands = {
	cmdRead = Wherigo.ZCommand{
		Text = "Read", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdReadTranslation = Wherigo.ZCommand{
		Text = "Read Translation", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTranslate = Wherigo.ZCommand{
		Text = "Translate", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objPieceofMap1.Commands.cmdRead.Custom = true
objPieceofMap1.Commands.cmdRead.Id = "1da13bb7-a7d0-49d3-9df2-496b497f8b34"
objPieceofMap1.Commands.cmdRead.WorksWithAll = true
objPieceofMap1.Commands.cmdReadTranslation.Custom = true
objPieceofMap1.Commands.cmdReadTranslation.Id = "ad9bc566-7278-4596-a199-07fb6dd5ea25"
objPieceofMap1.Commands.cmdReadTranslation.WorksWithAll = true
objPieceofMap1.Commands.cmdTake.Custom = true
objPieceofMap1.Commands.cmdTake.Id = "5a6dd553-d685-475c-8821-f90474fb9768"
objPieceofMap1.Commands.cmdTake.WorksWithAll = true
objPieceofMap1.Commands.cmdTranslate.Custom = true
objPieceofMap1.Commands.cmdTranslate.Id = "f04e5e3c-5118-4640-94a7-e2cc8a7a08fa"
objPieceofMap1.Commands.cmdTranslate.WorksWithAll = true
objPieceofMap1.ObjectLocation = ZonePoint(40.363251553976, -75.338884592056, 0)
objPieceofMap1.Locked = false
objPieceofMap1.Opened = false
objPieceofMap2 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objExcavationZone4
}
objPieceofMap2.Id = "fee0daf9-38c5-40fa-8a98-c147d95ac6c3"
objPieceofMap2.Name = "Piece of Map (2)"
objPieceofMap2.Description = "Another old clay tablet...it looks like a part of the same map"
objPieceofMap2.Visible = false
objPieceofMap2.Media = objMapPiece2
objPieceofMap2.Icon = objiconMapPiece2
objPieceofMap2.Commands = {
	cmdRead = Wherigo.ZCommand{
		Text = "Read", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdReadTranslation = Wherigo.ZCommand{
		Text = "Read Translation", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTranslate = Wherigo.ZCommand{
		Text = "Translate", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objPieceofMap2.Commands.cmdRead.Custom = true
objPieceofMap2.Commands.cmdRead.Id = "3f3e825b-c303-4720-99c2-96e2cd403ad3"
objPieceofMap2.Commands.cmdRead.WorksWithAll = true
objPieceofMap2.Commands.cmdReadTranslation.Custom = true
objPieceofMap2.Commands.cmdReadTranslation.Id = "f49071b1-09a3-440e-bdf1-4e8a13b3adab"
objPieceofMap2.Commands.cmdReadTranslation.WorksWithAll = true
objPieceofMap2.Commands.cmdTake.Custom = true
objPieceofMap2.Commands.cmdTake.Id = "bf6cc831-846f-4587-af92-5aef774d2914"
objPieceofMap2.Commands.cmdTake.WorksWithAll = true
objPieceofMap2.Commands.cmdTranslate.Custom = true
objPieceofMap2.Commands.cmdTranslate.Id = "46950804-034b-43ea-9132-634a33dad1f9"
objPieceofMap2.Commands.cmdTranslate.WorksWithAll = true
objPieceofMap2.ObjectLocation = ZonePoint(40.363500887289, -75.341448783874, 0)
objPieceofMap2.Locked = false
objPieceofMap2.Opened = false
objPieceofMap3 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objExcavationZone6
}
objPieceofMap3.Id = "8b155946-e3a9-4e91-99df-e26967e8611d"
objPieceofMap3.Name = "Piece of Map (3)"
objPieceofMap3.Description = "Yet another old clay tablet...it looks like the final piece of the map"
objPieceofMap3.Visible = false
objPieceofMap3.Media = objMapPiece3
objPieceofMap3.Icon = objiconMapPiece3
objPieceofMap3.Commands = {
	cmdRead = Wherigo.ZCommand{
		Text = "Read", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdReadTranslation = Wherigo.ZCommand{
		Text = "Read Translation", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdReassembleMap = Wherigo.ZCommand{
		Text = "Reassemble Map", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTranslate = Wherigo.ZCommand{
		Text = "Translate", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objPieceofMap3.Commands.cmdRead.Custom = true
objPieceofMap3.Commands.cmdRead.Id = "08851cca-c145-4726-8ea6-a5d5f812b236"
objPieceofMap3.Commands.cmdRead.WorksWithAll = true
objPieceofMap3.Commands.cmdReadTranslation.Custom = true
objPieceofMap3.Commands.cmdReadTranslation.Id = "a20f8fc7-7860-4547-a48e-26cdff8b529d"
objPieceofMap3.Commands.cmdReadTranslation.WorksWithAll = true
objPieceofMap3.Commands.cmdReassembleMap.Custom = true
objPieceofMap3.Commands.cmdReassembleMap.Id = "6b4668b1-8987-4dca-857a-5559864e98e0"
objPieceofMap3.Commands.cmdReassembleMap.WorksWithAll = true
objPieceofMap3.Commands.cmdTake.Custom = true
objPieceofMap3.Commands.cmdTake.Id = "c017dc04-ea37-4869-867d-aeffcb9ba8aa"
objPieceofMap3.Commands.cmdTake.WorksWithAll = true
objPieceofMap3.Commands.cmdTranslate.Custom = true
objPieceofMap3.Commands.cmdTranslate.Id = "c0e34786-0174-4c12-a459-1ff6aa79e892"
objPieceofMap3.Commands.cmdTranslate.WorksWithAll = true
objPieceofMap3.ObjectLocation = ZonePoint(40.362881639737, -75.343632102013, 0)
objPieceofMap3.Locked = false
objPieceofMap3.Opened = false
objRockCave = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objRockyOutcropping
}
objRockCave.Id = "c8f7bc1c-f5e2-491a-b6a2-c9f13218d63f"
objRockCave.Name = "Rock Cave"
objRockCave.Description = "A rock cave that was opened when you opened it with the peace pipe"
objRockCave.Visible = false
objRockCave.Media = objCaveOpen
objRockCave.Icon = objiconRockCaveOpen
objRockCave.Commands = {
	cmdLookInside = Wherigo.ZCommand{
		Text = "Look Inside", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objRockCave.Commands.cmdLookInside.Custom = true
objRockCave.Commands.cmdLookInside.Id = "a32383c8-b5e2-4ac2-b543-5ec0af0ab0de"
objRockCave.Commands.cmdLookInside.WorksWithAll = true
objRockCave.ObjectLocation = ZonePoint(40.362258298997, -75.342757701874, 0)
objRockCave.Locked = true
objRockCave.Opened = false
objRockyOutcropping1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objRockyOutcropping
}
objRockyOutcropping1.Id = "4e5586c5-2fed-4b10-a16d-67fe5187e3f9"
objRockyOutcropping1.Name = "Rocky Outcropping"
objRockyOutcropping1.Description = "A rocky outcropping is here"
objRockyOutcropping1.Visible = true
objRockyOutcropping1.Media = objCaveClosed
objRockyOutcropping1.Icon = objiconRockCaveClosed
objRockyOutcropping1.Commands = {
	cmdInspect = Wherigo.ZCommand{
		Text = "Inspect", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdInspectNotch = Wherigo.ZCommand{
		Text = "Inspect Notch", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objRockyOutcropping1.Commands.cmdInspect.Custom = true
objRockyOutcropping1.Commands.cmdInspect.Id = "0837145d-393a-4ef5-accd-f4a7f157ae06"
objRockyOutcropping1.Commands.cmdInspect.WorksWithAll = true
objRockyOutcropping1.Commands.cmdInspectNotch.Custom = true
objRockyOutcropping1.Commands.cmdInspectNotch.Id = "843af8be-fc0d-492c-8b63-efbee8163458"
objRockyOutcropping1.Commands.cmdInspectNotch.WorksWithAll = true
objRockyOutcropping1.ObjectLocation = ZonePoint(40.362258298997, -75.342757701874, 0)
objRockyOutcropping1.Locked = false
objRockyOutcropping1.Opened = false
objSaveGame = Wherigo.ZItem(objExcavationinSellersville)
objSaveGame.Id = "f8df8f2f-31b3-4596-839b-615396952069"
objSaveGame.Name = "Save Game"
objSaveGame.Description = "Use this item to save your game without having to exit the cartridge and re-enter. It has no other purpose for the game."
objSaveGame.Visible = true
objSaveGame.Media = objSave
objSaveGame.Icon = objiconSave
objSaveGame.Commands = {
	cmdSave = Wherigo.ZCommand{
		Text = "Save", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objSaveGame.Commands.cmdSave.Custom = true
objSaveGame.Commands.cmdSave.Id = "c334b26e-adc0-45a8-8427-00edfb13179d"
objSaveGame.Commands.cmdSave.WorksWithAll = true
objSaveGame.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objSaveGame.Locked = false
objSaveGame.Opened = false
objScroll1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objMysteryZone
}
objScroll1.Id = "eaecc7ef-f01c-48b4-93a6-7101c5537f20"
objScroll1.Name = "Scroll"
objScroll1.Description = "A paper scroll in an ancient language"
objScroll1.Visible = false
objScroll1.Media = objScroll
objScroll1.Icon = objiconScroll
objScroll1.Commands = {
	cmdRead = Wherigo.ZCommand{
		Text = "Read", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdReadHint = Wherigo.ZCommand{
		Text = "Read Hint", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdReadTranslation = Wherigo.ZCommand{
		Text = "Read Translation", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTranslate = Wherigo.ZCommand{
		Text = "Translate", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objScroll1.Commands.cmdRead.Custom = true
objScroll1.Commands.cmdRead.Id = "76be4c1e-bb8c-4636-b054-8e4e8c325292"
objScroll1.Commands.cmdRead.WorksWithAll = true
objScroll1.Commands.cmdReadHint.Custom = true
objScroll1.Commands.cmdReadHint.Id = "504b80c4-4f15-434b-b1c0-1238f5f13ab5"
objScroll1.Commands.cmdReadHint.WorksWithAll = true
objScroll1.Commands.cmdReadTranslation.Custom = true
objScroll1.Commands.cmdReadTranslation.Id = "1d445408-a605-4bee-bf49-e94d51df0236"
objScroll1.Commands.cmdReadTranslation.WorksWithAll = true
objScroll1.Commands.cmdTake.Custom = true
objScroll1.Commands.cmdTake.Id = "4489caac-30ea-4124-af7d-626f08976421"
objScroll1.Commands.cmdTake.WorksWithAll = true
objScroll1.Commands.cmdTranslate.Custom = true
objScroll1.Commands.cmdTranslate.Id = "1f6ca401-217b-42d7-a621-df72ec2648a7"
objScroll1.Commands.cmdTranslate.WorksWithAll = true
objScroll1.ObjectLocation = ZonePoint(40.361569244402, -75.342399438795, 0)
objScroll1.Locked = false
objScroll1.Opened = false
objShovel1 = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objParkingLot1
}
objShovel1.Id = "78f786c2-b1ac-43e0-817e-500875142374"
objShovel1.Name = "Shovel"
objShovel1.Description = "Your trusty shovel"
objShovel1.Visible = false
objShovel1.Media = objShovel
objShovel1.Icon = objiconShovel
objShovel1.Commands = {
	cmdDig = Wherigo.ZCommand{
		Text = "Dig", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objShovel1.Commands.cmdDig.Custom = true
objShovel1.Commands.cmdDig.Id = "9ffa3e17-9c3c-400e-9286-457cbb6a9e0c"
objShovel1.Commands.cmdDig.WorksWithAll = true
objShovel1.Commands.cmdTake.Custom = true
objShovel1.Commands.cmdTake.Id = "3483f688-b6a6-42fd-8b2b-2871269391f9"
objShovel1.Commands.cmdTake.WorksWithAll = true
objShovel1.ObjectLocation = ZonePoint(40.362523985919, -75.339018702507, 0)
objShovel1.Locked = false
objShovel1.Opened = false
objTreasureChest = Wherigo.ZItem{
	Cartridge = objExcavationinSellersville, 
	Container = objMysteryZone
}
objTreasureChest.Id = "0bf56de3-a7b1-468e-86c5-c556007b9cd4"
objTreasureChest.Name = "Treasure Chest"
objTreasureChest.Description = "A treasure chest with the lid closed and locked"
objTreasureChest.Visible = false
objTreasureChest.Media = objTreasureChestClosed
objTreasureChest.Icon = objiconTreasureChestClosed
objTreasureChest.Commands = {
	cmdLookInside = Wherigo.ZCommand{
		Text = "Look Inside", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdOpen = Wherigo.ZCommand{
		Text = "Open", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objTreasureChest.Commands.cmdLookInside.Custom = true
objTreasureChest.Commands.cmdLookInside.Id = "7ef00096-d822-4802-9de9-946e2431df20"
objTreasureChest.Commands.cmdLookInside.WorksWithAll = true
objTreasureChest.Commands.cmdOpen.Custom = true
objTreasureChest.Commands.cmdOpen.Id = "ed825180-c478-4cc5-8e19-48370c419a6e"
objTreasureChest.Commands.cmdOpen.WorksWithAll = true
objTreasureChest.Commands.cmdTake.Custom = true
objTreasureChest.Commands.cmdTake.Id = "80a6ac5f-f946-4f36-9eb4-75bc85586e47"
objTreasureChest.Commands.cmdTake.WorksWithAll = true
objTreasureChest.ObjectLocation = ZonePoint(40.361569244402, -75.342399438795, 0)
objTreasureChest.Locked = false
objTreasureChest.Opened = false

-- Tasks --
objExcavateZone6 = Wherigo.ZTask(objExcavationinSellersville)
objExcavateZone6.Id = "9f8107a8-0e12-439b-990b-e232c2f47ec7"
objExcavateZone6.Name = "Excavate Zone 6"
objExcavateZone6.Description = "You see several another Excavation Zones. Hopefully by this point you know what you should do there..."
objExcavateZone6.Visible = false
objExcavateZone6.Media = objTreasureMap
objExcavateZone6.Active = false
objExcavateZone6.Complete = false
objExcavateZone6.CorrectState = "None"
objExcavateZones13 = Wherigo.ZTask(objExcavationinSellersville)
objExcavateZones13.Id = "10727d7b-86d9-446a-abbd-149171a99985"
objExcavateZones13.Name = "Excavate Zones 1-3"
objExcavateZones13.Description = "You see several Excavation Zones and have your trusty shovel. You should probably check all of them out."
objExcavateZones13.Visible = false
objExcavateZones13.Media = objTreasureMap
objExcavateZones13.Active = false
objExcavateZones13.Complete = false
objExcavateZones13.CorrectState = "None"
objExcavateZones45 = Wherigo.ZTask(objExcavationinSellersville)
objExcavateZones45.Id = "04a08b8a-8b7b-49a9-9d7f-50d7ec75226c"
objExcavateZones45.Name = "Excavate Zones 4-5"
objExcavateZones45.Description = "You see several new Excavation Zones. You should probably check these out, too."
objExcavateZones45.Visible = false
objExcavateZones45.Media = objTreasureMap
objExcavateZones45.Active = false
objExcavateZones45.Complete = false
objExcavateZones45.CorrectState = "None"
objFindAllMapPieces = Wherigo.ZTask(objExcavationinSellersville)
objFindAllMapPieces.Id = "3c04d12d-0003-4997-858b-0e37e62352cb"
objFindAllMapPieces.Name = "Find All Map Pieces"
objFindAllMapPieces.Description = "You have one piece of what seems to be an ancient map, how many more could there be? Find them all and see what secrets lie ahead..."
objFindAllMapPieces.Visible = false
objFindAllMapPieces.Media = objMapPiece1
objFindAllMapPieces.Active = false
objFindAllMapPieces.Complete = false
objFindAllMapPieces.CorrectState = "None"
objSolveTheMystery = Wherigo.ZTask(objExcavationinSellersville)
objSolveTheMystery.Id = "ddec94a1-2ddf-4c74-9052-a2553531cf91"
objSolveTheMystery.Name = "Solve The Mystery"
objSolveTheMystery.Description = "So now you know the \"Secret,\" but what is the \"Mystery\"? You have a feeling it is somewhere to the south of the \"Secret\" but you will not know for sure until you solve it."
objSolveTheMystery.Visible = false
objSolveTheMystery.Media = objTreasureMap
objSolveTheMystery.Active = false
objSolveTheMystery.Complete = false
objSolveTheMystery.CorrectState = "None"
objUncoverTheSecret = Wherigo.ZTask(objExcavationinSellersville)
objUncoverTheSecret.Id = "0bf8ff0c-9878-46cc-b04a-5578652874d3"
objUncoverTheSecret.Name = "Uncover The Secret"
objUncoverTheSecret.Description = "What could the \"Secret before Mystery\" be? Better hurry over to the rocky outcropping you see in the distance and try to figure it out."
objUncoverTheSecret.Visible = false
objUncoverTheSecret.Media = objTreasureMap
objUncoverTheSecret.Active = false
objUncoverTheSecret.Complete = false
objUncoverTheSecret.CorrectState = "None"

-- Cartridge Variables --
objbolBatteriesDead = false
objbolFlashlightOn = false
objbolHandleDown = false
objbolOKToTakeBook = false
objbolReadTranslation1 = false
objbolReadTranslation2 = false
objbolReadTranslation3 = false
objbolTreasureChestLocked = true
objnumDigAttempts1 = 1
objnumDigAttempts2 = 0
objnumDigAttempts3 = 2
objnumDigAttempts4 = 1
objnumDigAttempts5 = 1
objnumDigAttempts6 = 0
objnumOpenAttempts = 0
objstrCompleteTaslExZone13 = ""
objstrCompleteTaslExZone45 = ""
objstrCompleteTaslExZone6 = ""
objstrPlayerName = "Player"
currentZone = "objExcavationZone1"
currentCharacter = "dummy"
currentItem = "objBatteries1"
currentTask = "objExcavateZone6"
currentInput = "objPlayerName"
currentTimer = "objFlashlightLife"
objExcavationinSellersville.ZVariables = {
	objbolBatteriesDead = false, 
	objbolFlashlightOn = false, 
	objbolHandleDown = false, 
	objbolOKToTakeBook = false, 
	objbolReadTranslation1 = false, 
	objbolReadTranslation2 = false, 
	objbolReadTranslation3 = false, 
	objbolTreasureChestLocked = true, 
	objnumDigAttempts1 = 1, 
	objnumDigAttempts2 = 0, 
	objnumDigAttempts3 = 2, 
	objnumDigAttempts4 = 1, 
	objnumDigAttempts5 = 1, 
	objnumDigAttempts6 = 0, 
	objnumOpenAttempts = 0, 
	objstrCompleteTaslExZone13 = "", 
	objstrCompleteTaslExZone45 = "", 
	objstrCompleteTaslExZone6 = "", 
	objstrPlayerName = "Player", 
	currentZone = "objExcavationZone1", 
	currentCharacter = "dummy", 
	currentItem = "objBatteries1", 
	currentTask = "objExcavateZone6", 
	currentInput = "objPlayerName", 
	currentTimer = "objFlashlightLife"
}

-- Timers --
objFlashlightLife = Wherigo.ZTimer(objExcavationinSellersville)
objFlashlightLife.Id = "79582373-d4fe-4604-96fd-f788f8e7d007"
objFlashlightLife.Name = "Flashlight Life"
objFlashlightLife.Description = ""
objFlashlightLife.Visible = true
objFlashlightLife.Duration = 150
objFlashlightLife.Type = "Countdown"

-- Inputs --
objPlayerName = Wherigo.ZInput(objExcavationinSellersville)
objPlayerName.Id = "519e8cd9-71d5-4386-8070-fb2505aadff8"
objPlayerName.Name = "Player Name"
objPlayerName.Description = ""
objPlayerName.Visible = true
objPlayerName.InputType = "Text"
objPlayerName.Text = "Hello, Player. What is your name?"

-- WorksWithList for object commands --
objBatteries1.Commands.cmdReplaceBatteries.WorksWithList = {
	objFlashlight
}
objClayPotwithWater.Commands.cmdPourWaterOn.WorksWithList = {
	objKey1, 
	objTreasureChest, 
	objJeep1, 
	objClumpofDirt1, 
	objBatteries1
}

-- functions --
function objExcavationinSellersville:OnStart()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objPlayerName)
	end)
	objSaveGame:MoveTo(Player)
	objnumDigAttempts1 = math.random(1, 2)
	objnumDigAttempts2 = math.random(0, 2)
	objnumDigAttempts3 = math.random(1, 2)
	objnumDigAttempts4 = math.random(0, 2)
	objnumDigAttempts5 = math.random(1, 2)
	objnumDigAttempts6 = math.random(0, 2)
end
function objExcavationinSellersville:OnRestore()
end
function objMysteryZone:OnEnter()
	currentZone = "objMysteryZone"
	if objnumOpenAttempts > 0 then
		objKey1.Commands.cmdUnlockTreasureChest.Enabled = true
	end
end
function objMysteryZone:OnExit()
	currentZone = "objMysteryZone"
	objKey1.Commands.cmdUnlockTreasureChest.Enabled = false
end
function objParkingLot1:OnExit()
	currentZone = "objParkingLot1"
	if objShovel1.Commands.cmdDig.Enabled == false then
		objShovel1.Commands.cmdDig.Enabled = true
	end
end
function objPond1:OnEnter()
	currentZone = "objPond1"
	objClayPot.Commands.cmdFillPotWithWater.Enabled = true
end
function objPond1:OnExit()
	currentZone = "objPond1"
	objClayPot.Commands.cmdFillPotWithWater.Enabled = false
end
function objExcavateZone6:OnSetComplete()
	_Urwigo.OldDialog{
		{
			Text = "Congratulations, you have completed the task 'Excavate Zone 6'", 
			Media = objTreasureMap
		}
	}
end
function objExcavateZones13:OnSetComplete()
	_Urwigo.OldDialog{
		{
			Text = "Congratulations, you have completed the task 'Excavate Zones 1-3'", 
			Media = objTreasureMap
		}
	}
end
function objExcavateZones45:OnSetComplete()
	_Urwigo.OldDialog{
		{
			Text = "Congratulations, you have completed the task 'Excavate Zones 4-5'", 
			Media = objTreasureMap
		}
	}
end
function objPlayerName:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if input ~= "" then
		objstrPlayerName = input
	end
	_Urwigo.OldDialog{
		{
			Text = ("Hello, "..objstrPlayerName)..", welcome to Excavation in Sellersville!", 
			Media = objTitle
		}, 
		{
			Text = [[You may have to go to some zones more than once, but most of the time you will only need to visit zones one time...unless you missed something, or take a wrong turn along the way.
---
If you get stuck and really need help, check out your jeep. There is probably something in there that will put you in contact with assistance. ]], 
			Media = objSplashTitle
		}, 
		{
			Text = [[To get started, why not check out your trusty jeep? There just might be something in there that you can use...
---
Have fun!]], 
			Media = objJeep
		}, 
		{
			Text = [[Author's note: Parts of this game are complex and cause issues with some Wherigo players (some Garmin and iOS devices.) In your inventory you have a 'Save Game' item that you can use to save your game while playing without have to exit.
---
It has no other purpose for playing the game, I promise.]], 
			Media = objSave
		}
	}
end
function objFlashlightLife:OnTick()
	objbolBatteriesDead = true
	_Urwigo.OldDialog{
		{
			Text = "Uh oh, your flashlight just went off. You realize you probably should not have left it on for so long; the batteries have gone dead!", 
			Media = objFlashlightOff
		}
	}
	objbolFlashlightOn = false
	objFlashlight.Commands.cmdTurnOn.Enabled = true
	objFlashlight.Commands.cmdTurnOff.Enabled = false
	objFlashlight.Media = objFlashlightOff
	objFlashlight.Icon = objiconFlashlightOff
	objFlashlight.Description = "Your heavy-duty flashlight; it is off because the batteries died"
	objBatteries1.Commands.cmdReplaceBatteries.Enabled = true
end
function objBatteries1:OncmdReplaceBatteries(target)
	_Urwigo.OldDialog{
		{
			Text = [[You replace the batteries in your flashlight. You should be able to turn it on again now.
---
You might want to watch how much you use it this time.]], 
			Media = objBatteries
		}
	}
	objbolBatteriesDead = false
	objBatteries1.Commands.cmdReplaceBatteries.Enabled = false
end
function objBatteries1:OncmdTake(target)
	_Urwigo.OldDialog{
		{
			Text = "You take the Batteries.", 
			Media = objBatteries
		}
	}
	objBatteries1:MoveTo(Player)
	objBatteries1.Commands.cmdReplaceBatteries.Enabled = true
	objBatteries1.Commands.cmdTake.Enabled = false
end
function objClayPot:OncmdFillPotWithWater(target)
	_Urwigo.OldDialog{
		{
			Text = "You dip the old, clay pot into the clear, blue pond until it fills with water, then carefully lift it back out.", 
			Media = objClayPotFull
		}
	}
	objClayPotwithWater.Visible = true
	objClayPot.Visible = false
	objClayPotwithWater.Commands.cmdPourWaterOn.Enabled = true
end
function objClayPot:OncmdTake(target)
	_Urwigo.Dialog(false, {
		{
			Text = "You take the old clay pot", 
			Media = objClayPotEmpty
		}
	}, function(action)
		objCheckCloseZones123()
	end)
	objClayPotwithWater:MoveTo(Player)
	objClayPot:MoveTo(Player)
	objClayPot.Commands.cmdTake.Enabled = false
	objExcavationZone3.Active = false
	objExcavationZone3.Visible = false
end
function objClayPotwithWater:OncmdPourWaterOn(target)
	objClayPot.Visible = true
	objClayPotwithWater.Visible = false
	objClayPotwithWater.Commands.cmdPourWaterOn.Enabled = false
	if target == objJeep1 then
		_Urwigo.OldDialog{
			{
				Text = "You pour the water over your dirty jeep, and it sparkles in the sun! But nothing else happens. Your clay pot is now empty.", 
				Media = objJeep
			}
		}
	elseif target == objBatteries1 then
		_Urwigo.OldDialog{
			{
				Text = "ZZZZZT! The water shorts the batteries and gives you a shock, causing you to drop the now-discharged batteries. You will have to find more somewhere. Also, your clay pot is now empty.", 
				Media = objBatteriesShock
			}
		}
		objBatteries1:MoveTo(objParkingLot1)
		objBatteries1.Visible = false
		objBatteries1.Commands.cmdTake.Enabled = true
	elseif target == objClumpofDirt1 then
		_Urwigo.OldDialog{
			{
				Text = "The dirt washes away revealing a shiny metal key! Your clay pot is now empty.", 
				Media = objKey
			}
		}
		objKey1.Visible = true
		objClumpofDirt1.Visible = false
	else
		_Urwigo.OldDialog{
			{
				Text = "You pour the water out on that...it looks a little cleaner. Your clay pot is now empty.", 
				Media = objClayPotPour
			}
		}
	end
end
function objClumpofDirt1:OncmdTake(target)
	_Urwigo.Dialog(false, {
		{
			Text = "You take the big clump of dirt", 
			Media = objClumpofDirt
		}
	}, function(action)
		objCheckCloseZones45()
	end)
	objKey1.Commands.cmdTake.Enabled = false
	objKey1:MoveTo(Player)
	objClumpofDirt1.Commands.cmdTake.Enabled = false
	objClumpofDirt1:MoveTo(Player)
	objExcavationZone5.Active = false
	objExcavationZone5.Visible = false
end
function objFlashlight:OncmdTake(target)
	_Urwigo.OldDialog{
		{
			Text = "You take the Flashlight.", 
			Media = objFlashlightOff
		}
	}
	objFlashlight.Commands.cmdTurnOn.Enabled = true
	objFlashlight.Commands.cmdTake.Enabled = false
	objFlashlight:MoveTo(Player)
end
function objFlashlight:OncmdTurnOff(target)
	objbolFlashlightOn = false
	objFlashlight.Commands.cmdTurnOn.Enabled = true
	objFlashlight.Commands.cmdTurnOff.Enabled = false
	objFlashlight.Description = "Your heavy-duty flashlight, It can help you see in dark places. It is turned OFF now."
	objFlashlight.Media = objFlashlightOff
	objFlashlight.Icon = objiconFlashlightOff
	objFlashlightLife:Stop()
end
function objFlashlight:OncmdTurnOn(target)
	if objbolBatteriesDead == true then
		_Urwigo.OldDialog{
			{
				Text = "You click the button a few times, but nothing happens. The batteries are probably dead. Perhaps you have some more in your jeep...", 
				Media = objFlashlightOff
			}
		}
		objJeep1.Commands.cmdSearchGlovebox.Enabled = true
	else
		objbolFlashlightOn = true
		objFlashlight.Commands.cmdTurnOn.Enabled = false
		objFlashlight.Commands.cmdTurnOff.Enabled = true
		objFlashlight.Description = "Your heavy-duty flashlight, It can help you see in dark places. It is turned ON now."
		objFlashlight.Media = objFlashlightOn
		objFlashlight.Icon = objiconFlashlightOn
		objFlashlightLife:Start()
	end
end
function objJeep1:OncmdSearch(target)
	_Urwigo.OldDialog{
		{
			Text = "You see your trusty shovel, a flashlight, your notebook of contacts, and your book of Native American Languages here.", 
			Media = objJeep
		}
	}
	objJeep1.Commands.cmdSearch.Enabled = false
	objLanguagesBook.Visible = true
	objShovel1.Visible = true
	objFlashlight.Visible = true
	objPhoneBook1.Visible = true
end
function objJeep1:OncmdSearchGlovebox(target)
	if (objbolBatteriesDead == true) and (not Player:Contains(objBatteries1)) then
		_Urwigo.OldDialog{
			{
				Text = "You rustle around for a few minutes in the glove box and you find....batteries!!!", 
				Media = objBatteries
			}
		}
		objBatteries1.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = [[You rustle around for a few minutes in the glove box and you find....batteries!!!
---
At the moment, though, you don't need any batteries, so you decide to leave them there. (How many batteries do you have in here, anyway???)]], 
				Media = objBatteries
			}
		}
	end
end
function objJeep1:OncmdTake(target)
	_Urwigo.OldDialog{
		{
			Text = "This park does not allow off-roading...why not leave the jeep here?", 
			Media = objJeep
		}
	}
	objJeep1.Commands.cmdTake.Enabled = false
end
function objKey1:OncmdTake(target)
	_Urwigo.Dialog(false, {
		{
			Text = "You take the shiny metal key", 
			Media = objKey
		}
	}, function(action)
		objCheckCloseZones45()
	end)
	objKey1:MoveTo(Player)
	objKey1.Commands.cmdTake.Enabled = false
	objExcavationZone5.Active = false
	objExcavationZone5.Visible = false
end
function objKey1:OncmdUnlockTreasureChest(target)
	if objbolTreasureChestLocked == true then
		_Urwigo.OldDialog{
			{
				Text = "You take a look at the shiny, metal key, and then at the lock in the treasure chest.", 
				Media = objKey
			}, 
			{
				Text = "The key and lock seem to be about the same size, so you gently insert the key into the lock, and turn it gently until you hear an audible \"click.\" Nothing else happens.", 
				Media = objTreasureChestClosed
			}
		}
		objbolTreasureChestLocked = false
		objTreasureChest.Description = "A treasure chest with the lid closed but not locked"
	else
		_Urwigo.OldDialog{
			{
				Text = "It's already unlocked!", 
				Media = objKey
			}
		}
	end
end
function objLanguagesBook:OncmdTake(target)
	if objbolOKToTakeBook == true then
		_Urwigo.OldDialog{
			{
				Text = "You take the Book on Native American Languages", 
				Media = objBook
			}
		}
		objLanguagesBook:MoveTo(Player)
		objPieceofMap1.Commands.cmdTranslate.Enabled = true
		objLanguagesBook.Commands.cmdTake.Enabled = false
	else
		_Urwigo.OldDialog{
			{
				Text = "You see no reason to take that now.", 
				Media = objBook
			}
		}
	end
end
function objMap:OncmdRead(target)
	_Urwigo.OldDialog{
		{
			Text = "You read the newly assembled map. You recognize words, phrases,and locations from the map pieces, but now that they are put together, several new words and locations have materialized that you don't recognize from your translation of the map pieces.", 
			Media = objMapWhole
		}
	}
	objMap.Commands.cmdRead.Enabled = false
	objMap.Commands.cmdTranslate.Enabled = true
end
function objMap:OncmdReadTranslation(target)
	_Urwigo.OldDialog{
		{
			Text = [[You pour over the clay tablet map, picking out words and locations. You now see one more area that literally translates to "Mystery after Secret." What on earth could that mean?
---
You mark the zone on your map and decide to find out for yourself.]], 
			Media = objMapWhole
		}
	}
	objMysteryZone.Active = true
	objMysteryZone.Visible = true
end
function objMap:OncmdTranslate(target)
	_Urwigo.OldDialog{
		{
			Text = "You work for what seems like hours, but finally you finish translating the entire map and all of its notes and locations.", 
			Media = objMapWhole
		}
	}
	objMap.Commands.cmdReadTranslation.Enabled = true
	objMap.Commands.cmdTranslate.Enabled = false
end
function objPeacePipe:OncmdInsertinnotch(target)
	_Urwigo.OldDialog{
		{
			Text = "You take a close look at the peace pipe...this might just be long enough to fit into the small notch!", 
			Media = objPipe
		}, 
		{
			Text = "You insert the peace pipe into the small notch in the stone face. Just as you think it can't go any further, you hear a soft \"click\"...", 
			Media = objCaveClosed
		}, 
		{
			Text = [[You jump back as you hear a loud rumbling, then creaking and grinding. A previously hidden door slides open in the rough rock face, revealing a dark cave.
---
You attempt to retrieve the peace pipe only to find it is now stuck inside the notch.]], 
			Media = objCaveOpen
		}, 
		{
			Text = "Congratulations, you have completed the task 'Uncover The Secret.'", 
			Media = objCaveOpen
		}
	}
	objRockyOutcropping1.Visible = false
	objRockCave.Visible = true
	objPeacePipe.Commands.cmdInsertinnotch.Enabled = false
	objPeacePipe.Visible = false
	objUncoverTheSecret.Complete = true
	objSolveTheMystery.Active = true
	objSolveTheMystery.Visible = true
end
function objPeacePipe:OncmdTake(target)
	_Urwigo.Dialog(false, {
		{
			Text = "You take the old clay peace pipe.", 
			Media = objPipe
		}
	}, function(action)
		objCheckCloseZones123()
	end)
	objExcavationZone1.Active = false
	objExcavationZone1.Visible = false
	objPeacePipe:MoveTo(Player)
	objPeacePipe.Commands.cmdTake.Enabled = false
end
function objPhoneBook1:OncmdRead(target)
	_Urwigo.OldDialog{
		{
			Text = [[This is your person phone book where you keep all the names of your friends and enemies. However, you only see one entry.
---
You cannot recall if this entry is of the former or the latter...]], 
			Media = objPhoneBook
		}, 
		{
			Text = [[Name:             Phone
George (ggggeo2): (215) 436-9876
---
You have scribbled a note next to this entry. This is the CO for this cache, and you should text or call him if you get stuck or something goes wrong with the Whereigo cartridge.]]
		}
	}
end
function objPhoneBook1:OncmdTake(target)
	_Urwigo.OldDialog{
		{
			Text = "You take the Phone Book.", 
			Media = objPhoneBook
		}
	}
	objPhoneBook1.Commands.cmdRead.Enabled = true
	objPhoneBook1:MoveTo(Player)
	objPhoneBook1.Commands.cmdTake.Enabled = false
end
function objPieceofMap1:OncmdRead(target)
	_Urwigo.OldDialog{
		{
			Text = "You try to read the ancient text...but you cannot. If only you had some sort of translation guide...", 
			Media = objMapPiece1
		}
	}
	objbolOKToTakeBook = true
end
function objPieceofMap1:OncmdReadTranslation(target)
	_Urwigo.OldDialog{
		{
			Text = [[You take a closer look at the translated piece of map. You now see two more areas that might be ripe for excavation!
---
You mark the zones on your map and decide to see if they pan out.]], 
			Media = objMapPiece1
		}
	}
	if objbolReadTranslation1 == false then
		objbolReadTranslation1 = true
		objExcavationZone4.Active = true
		objExcavationZone4.Visible = true
		objExcavationZone5.Active = true
		objExcavationZone5.Visible = true
		objExcavateZones45.Active = true
		objExcavateZones45.Visible = true
		objFindAllMapPieces.Active = true
		objFindAllMapPieces.Visible = true
	end
end
function objPieceofMap1:OncmdTake(target)
	_Urwigo.Dialog(false, {
		{
			Text = "You take the old clay tablet that appears to be a piece of a map", 
			Media = objMapPiece1
		}
	}, function(action)
		objCheckCloseZones123()
	end)
	objExcavationZone2.Active = false
	objExcavationZone2.Visible = false
	objPieceofMap1.Commands.cmdRead.Enabled = true
	objPieceofMap1.Commands.cmdTake.Enabled = false
	objPieceofMap1:MoveTo(Player)
end
function objPieceofMap1:OncmdTranslate(target)
	_Urwigo.OldDialog{
		{
			Text = [[You reference your Native American Languages book and then the map, back and forth for a while until finally...
---
You translate this piece of the map!]], 
			Media = objBook
		}
	}
	objPieceofMap1.Commands.cmdTranslate.Enabled = false
	objPieceofMap1.Commands.cmdRead.Enabled = false
	objPieceofMap1.Commands.cmdReadTranslation.Enabled = true
end
function objPieceofMap2:OncmdRead(target)
	_Urwigo.OldDialog{
		{
			Text = "You try to read the ancient text...but you cannot. Where did that Native American Languages book get to?", 
			Media = objMapPiece2
		}
	}
	objPieceofMap2.Commands.cmdTranslate.Enabled = true
	objPieceofMap2.Commands.cmdRead.Enabled = false
end
function objPieceofMap2:OncmdReadTranslation(target)
	_Urwigo.OldDialog{
		{
			Text = [[You take a closer look at the translated piece of map. You see another area that might be ripe for excavation!
---
You mark the zone on your map and decide to see if it pans out.]], 
			Media = objMapPiece2
		}
	}
	if objbolReadTranslation2 == false then
		objbolReadTranslation2 = true
		objExcavationZone6.Active = true
		objExcavationZone6.Visible = true
		objExcavateZone6.Active = true
		objExcavateZone6.Visible = true
	end
end
function objPieceofMap2:OncmdTake(target)
	_Urwigo.Dialog(false, {
		{
			Text = "You take the map piece", 
			Media = objMapPiece2
		}
	}, function(action)
		objCheckCloseZones45()
	end)
	objPieceofMap2.Commands.cmdRead.Enabled = true
	objExcavationZone4.Active = false
	objExcavationZone4.Visible = false
	objPieceofMap2:MoveTo(Player)
	objPieceofMap2.Commands.cmdTake.Enabled = false
end
function objPieceofMap2:OncmdTranslate(target)
	_Urwigo.OldDialog{
		{
			Text = [[You reference your Native American Languages book and then the map, back and forth for a while until finally...
---
You translate this piece of the map!]], 
			Media = objBook
		}
	}
	objPieceofMap2.Commands.cmdTranslate.Enabled = false
	objPieceofMap2.Commands.cmdReadTranslation.Enabled = true
end
function objPieceofMap3:OncmdRead(target)
	_Urwigo.OldDialog{
		{
			Text = "You try to read the ancient text...but you cannot. You are pretty sure you know what to do this time, though...", 
			Media = objMapPiece3
		}
	}
	objPieceofMap3.Commands.cmdTranslate.Enabled = true
	objPieceofMap3.Commands.cmdRead.Enabled = false
end
function objPieceofMap3:OncmdReadTranslation(target)
	_Urwigo.OldDialog{
		{
			Text = [[You take a closer look at the translated piece of map. You see yet another area that has potential! You struggled a little with the translation here, but your best guess is "Secret before Mystery"...
---
You mark the zone on your map and decide to see what lies ahead.]], 
			Media = objMapPiece3
		}
	}
	if objbolReadTranslation3 == false then
		objbolReadTranslation3 = true
		objRockyOutcropping.Active = true
		objRockyOutcropping.Visible = true
		objUncoverTheSecret.Active = true
		objUncoverTheSecret.Visible = true
		objPieceofMap3.Commands.cmdReassembleMap.Enabled = true
	end
end
function objPieceofMap3:OncmdReassembleMap(target)
	_Urwigo.MessageBox{
		Text = "You now have all three pieces of the map. Are you sure you want to reassemble them into one whole tablet again? Who knows what you might find?", 
		Media = objMapPiece3, 
		Buttons = {
			"Yes, I'm ready!", 
			"No, too scary!"
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					_Urwigo.OldDialog{
						{
							Text = [[You combine the three pieces of clay tablet you have collected. As you ponder over it, the significance is all starting to come together...but some things still just do not make sense. Several words were broken across tablets and now have formed new words.
---
You feel certain that you will need to study this new, whole map more closely...]], 
							Media = objMapWhole
						}
					}
					objPieceofMap1.Visible = false
					objPieceofMap2.Visible = false
					objPieceofMap3.Visible = false
					objMap:MoveTo(Player)
					objMap.Visible = true
				else
					_Urwigo.OldDialog{
						{
							Text = "You decide *not* to assemble the map. This whole mess was too scary, after all. Why not call it a day, head back to your jeep, and go home?", 
							Media = objParkingLot
						}
					}
				end
			end
		end
	}
end
function objPieceofMap3:OncmdTake(target)
	_Urwigo.Dialog(false, {
		{
			Text = "You take the piece of map", 
			Media = objMapPiece3
		}
	}, function(action)
		objCheckCloseZone6()
	end)
	objPieceofMap3:MoveTo(Player)
	objExcavationZone6.Active = false
	objExcavationZone6.Visible = false
	objFindAllMapPieces.Complete = true
	objPieceofMap3.Commands.cmdRead.Enabled = true
	objPieceofMap3.Commands.cmdTake.Enabled = false
end
function objPieceofMap3:OncmdTranslate(target)
	objPieceofMap3.Commands.cmdReadTranslation.Enabled = true
	_Urwigo.OldDialog{
		{
			Text = [[You reference your Native American Languages book and then the map, back and forth for a while until finally...
---
You translate this piece of the map!]], 
			Media = objBook
		}
	}
	objPieceofMap3.Commands.cmdTranslate.Enabled = false
end
function objRockCave:OncmdLookInside(target)
	if objbolFlashlightOn == true then
		if objbolHandleDown == true then
			_Urwigo.MessageBox{
				Text = "You shine your flashlight into the cave. The cave is pretty empty except for the old wooden handle on the wall to your left which you have pulled down.", 
				Media = objInsideCaveLightHandleDown, 
				Buttons = {
					"Lift Handle", 
					"Do Nothing"
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_Urwigo.OldDialog{
								{
									Text = "You carefully lift the creaky, old handle up back to the position in which you found it. Somewhere to the south you hear a deep rumble...", 
									Media = objInsideCaveLightHandleUp
								}
							}
							objTreasureChest.Visible = false
							objbolHandleDown = false
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = "You shine your flashlight into the cave. The cave is pretty empty except for a wooden handle on the wall to your left. It looks very old.", 
				Media = objInsideCaveLightHandleUp, 
				Buttons = {
					"Pull Handle", 
					"Do Nothing"
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_Urwigo.OldDialog{
								{
									Text = "You carefully pull the creaky, old handle up down. It slowly grinds into place. Somewhere to the south you hear a deep rumble...", 
									Media = objInsideCaveLightHandleDown
								}
							}
							objTreasureChest.Visible = true
							objbolHandleDown = true
						end
					end
				end
			}
		end
	else
		_Urwigo.OldDialog{
			{
				Text = "You take a look inside, but you only see darkness. And some shadows. Darkness and shadows...spooky!", 
				Media = objInsideCaveDark
			}
		}
	end
end
function objRockyOutcropping1:OncmdInspect(target)
	_Urwigo.OldDialog{
		{
			Text = [[You take a close look at the rocky outcropping here, but see nothing.
---
You begin to walk away, but as you do, a small notch in the rough surface of the stone catches your eye.]], 
			Media = objCaveClosed
		}
	}
	objRockyOutcropping1.Commands.cmdInspect.Enabled = false
	objRockyOutcropping1.Commands.cmdInspectNotch.Enabled = true
end
function objRockyOutcropping1:OncmdInspectNotch(target)
	_Urwigo.OldDialog{
		{
			Text = "You take a close look at the small notch on the rocky outcropping. You stick your finger in to it, but it is deeper than it looks, and nothing happens.", 
			Media = objNotch
		}
	}
	objPeacePipe.Commands.cmdInsertinnotch.Enabled = true
end
function objSaveGame:OncmdSave(target)
	objExcavationinSellersville:RequestSync()
	_Urwigo.OldDialog{
		{
			Text = "You have saved your game", 
			Media = objSave
		}
	}
end
function objScroll1:OncmdRead(target)
	_Urwigo.OldDialog{
		{
			Text = "You see more of the same ancient text you have seen all along your adventure. By this point you are certain what you will need to do next.", 
			Media = objScroll
		}
	}
	objScroll1.Commands.cmdRead.Enabled = false
	objScroll1.Commands.cmdTranslate.Enabled = true
end
function objScroll1:OncmdReadHint(target)
	_Urwigo.OldDialog{
		{
			Text = [[You check the Scroll for a hint. Someone has written at the bottom of the paper:
---
Through a narrow pass you can LOG your find]], 
			Media = objScroll
		}
	}
end
function objScroll1:OncmdReadTranslation(target)
	objExcavationinSellersville.Complete = true
	_Urwigo.OldDialog{
		{
			Text = "You read the final translation of the scroll you found in the treasure chest. This is what it says:", 
			Media = objScroll
		}, 
		{
			Text = (("Congratulations, "..objstrPlayerName)..[[! You have completed the Wherigo portion of Excavation in Sellersville!

Now, all that is left is for you to find the geocache very close to where you are probably now standing. The final coordinates are:
N 40 21.698  W 075 20.561

You can get a hint by selecting the scroll and clicking 'Read Hint'

Your Whereigo Completion Code is: ]])..string.sub(Player.CompletionCode, 1, 15)
		}, 
		{
			Text = [[Thanks for playing this cartridge. Please provide feedback or bug reports to ggggeo@gmail.com. I hope you had fun!
  Thanks,
  ggggeo2 (George)]], 
			Media = objScroll
		}
	}
	objScroll1.Commands.cmdReadHint.Enabled = true
	objExcavationinSellersville:RequestSync()
end
function objScroll1:OncmdTake(target)
	_Urwigo.OldDialog{
		{
			Text = "You take the Scroll.", 
			Media = objScroll
		}
	}
	objScroll1.Commands.cmdTake.Enabled = false
	objScroll1.Commands.cmdRead.Enabled = true
	objScroll1:MoveTo(Player)
end
function objScroll1:OncmdTranslate(target)
	_Urwigo.OldDialog{
		{
			Text = "With all of your translating experience today, you make quick work of translating the scroll you have just found.", 
			Media = objScroll
		}
	}
	objScroll1.Commands.cmdTranslate.Enabled = false
	objScroll1.Commands.cmdReadTranslation.Enabled = true
end
function objShovel1:OncmdDig(target)
	if objExcavationZone1:Contains(Player) then
		if objnumDigAttempts1 > 0 then
			_Urwigo.OldDialog{
				{
					Text = "You dig for a while, but nothing turns up. Maybe you should try digging somewhere else in this zone...", 
					Media = objShovel
				}
			}
			objnumDigAttempts1 = objnumDigAttempts1 + -1
		else
			if objPeacePipe.Visible == false then
				objPeacePipe.Visible = true
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, and you find...an old clay peace pipe!", 
						Media = objPipe
					}
				}
			else
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, but you do not find anything else. You are pretty certain you have fully excavated this zone.", 
						Media = objShovel
					}
				}
			end
		end
	elseif objExcavationZone2:Contains(Player) then
		if objnumDigAttempts2 > 0 then
			_Urwigo.OldDialog{
				{
					Text = "You dig for a while, but nothing turns up. Maybe you should try digging somewhere else in this zone...", 
					Media = objShovel
				}
			}
			objnumDigAttempts2 = objnumDigAttempts2 + -1
		else
			if objPieceofMap1.Visible == false then
				objPieceofMap1.Visible = true
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, and you find...an old clay tablet...it looks like a part of a map!", 
						Media = objMapPiece1
					}
				}
			else
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, but you do not find anything else. You are pretty certain you have fully excavated this zone.", 
						Media = objShovel
					}
				}
			end
		end
	elseif objExcavationZone3:Contains(Player) then
		if objnumDigAttempts3 > 0 then
			_Urwigo.OldDialog{
				{
					Text = "You dig for a while, but nothing turns up. Maybe you should try digging somewhere else in this zone...", 
					Media = objShovel
				}
			}
			objnumDigAttempts3 = objnumDigAttempts3 + -1
		else
			if objClayPot.Visible == false then
				objClayPot.Visible = true
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, and you find...an old clay pot!", 
						Media = objClayPotEmpty
					}
				}
			else
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, but you do not find anything else. You are pretty certain you have fully excavated this zone.", 
						Media = objShovel
					}
				}
			end
		end
	elseif objExcavationZone4:Contains(Player) then
		if objnumDigAttempts4 > 0 then
			_Urwigo.OldDialog{
				{
					Text = "You dig for a while, but nothing turns up. Maybe you should try digging somewhere else in this zone...", 
					Media = objShovel
				}
			}
			objnumDigAttempts4 = objnumDigAttempts4 + -1
		else
			if objPieceofMap2.Visible == false then
				objPieceofMap2.Visible = true
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, and you find...another old clay tablet...it looks like a part of the same map!", 
						Media = objMapPiece2
					}
				}
			else
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, but you do not find anything else. You are pretty certain you have fully excavated this zone.", 
						Media = objShovel
					}
				}
			end
		end
	elseif objExcavationZone5:Contains(Player) then
		if objnumDigAttempts5 > 0 then
			_Urwigo.OldDialog{
				{
					Text = "You dig for a while, but nothing turns up. Maybe you should try digging somewhere else in this zone...", 
					Media = objShovel
				}
			}
			objnumDigAttempts5 = objnumDigAttempts5 + -1
		else
			if objClumpofDirt1.Visible == false then
				objClumpofDirt1.Visible = true
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, and you find...a big clump of dirt! Wait, what?", 
						Media = objClumpofDirt
					}
				}
			else
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, but you do not find anything else. You are pretty certain you have fully excavated this zone.", 
						Media = objShovel
					}
				}
			end
		end
	elseif objExcavationZone6:Contains(Player) then
		if objnumDigAttempts6 > 0 then
			_Urwigo.OldDialog{
				{
					Text = "You dig for a while, but nothing turns up. Maybe you should try digging somewhere else in this zone...", 
					Media = objShovel
				}
			}
			objnumDigAttempts6 = objnumDigAttempts6 + -1
		else
			if objPieceofMap3.Visible == false then
				objPieceofMap3.Visible = true
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, and you find...yet another old clay tablet...it looks like the final piece of the map!", 
						Media = objMapPiece3
					}
				}
			else
				_Urwigo.OldDialog{
					{
						Text = "You dig and dig and dig, but you do not find anything else. You are pretty certain you have fully excavated this zone.", 
						Media = objShovel
					}
				}
			end
		end
	elseif objParkingLot1:Contains(Player) then
		_Urwigo.OldDialog{
			{
				Text = "You dig and dig and dig, and you find...the sound of metal on asphalt is really annoying! You can't dig up the parking lot!", 
				Media = objParkingLot
			}
		}
	elseif objPond1:Contains(Player) then
		_Urwigo.OldDialog{
			{
				Text = "You dig and dig and dig, and you find...mud. Lots and lots of mud. If you keep digging, you might end up in the pond!", 
				Media = objPond
			}
		}
	elseif objRockyOutcropping:Contains(Player) then
		_Urwigo.OldDialog{
			{
				Text = "You cannot dig here; it is too rocky. You might break your shovel!", 
				Media = objShovel
			}
		}
	elseif objMysteryZone:Contains(Player) then
		_Urwigo.OldDialog{
			{
				Text = "You get out your shovel to dig, but then have second thoughts. After all, what makes this zone so mysterious, and what might be beneath here? For your safety, you decide it is too risky and put the shovel away.", 
				Media = objMystery
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = "You dig and dig and dig, and you find...nothing! Maybe you should try again inside an excavation site.", 
				Media = objShovel
			}
		}
	end
end
function objShovel1:OncmdTake(target)
	_Urwigo.OldDialog{
		{
			Text = "As you reach for your trusty shovel, you remember three excavation sites you wanted to check out today. In the distance, you see a pond that might warrant further investigation. You mark everything down on your map and make a mental note to check them out, and then, you take the Shovel.", 
			Media = objShovel
		}
	}
	objShovel1.Commands.cmdTake.Enabled = false
	objShovel1:MoveTo(Player)
	objExcavateZones13.Active = true
	objExcavateZones13.Visible = true
	objExcavationZone1.Active = true
	objExcavationZone1.Visible = true
	objExcavationZone2.Active = true
	objExcavationZone2.Visible = true
	objExcavationZone3.Active = true
	objExcavationZone3.Visible = true
	objPond1.Active = true
	objPond1.Visible = true
end
function objTreasureChest:OncmdLookInside(target)
	_Urwigo.OldDialog{
		{
			Text = "You peek inside the seemingly empty treasure chest. Nothing! After all that time and effort, the \"treasure\" chest is empty! ", 
			Media = objTreasureChestOpen
		}, 
		{
			Text = "Or is it? Just as you are about to slam the lid closed in frustration, you see a piece of paper lying flat against the bottom of the chest, so much so that you almost missed it!", 
			Media = objScroll
		}, 
		{
			Text = "Congratulations, you have completed the task 'Solve The Mystery.'", 
			Media = objScroll
		}
	}
	objScroll1.Visible = true
	objSolveTheMystery.Complete = true
end
function objTreasureChest:OncmdOpen(target)
	if objbolTreasureChestLocked == true then
		if objnumOpenAttempts > 0 then
			_Urwigo.OldDialog{
				{
					Text = "You try to open the treasure chest again...but it is still locked. A key might help. Maybe you should have a seat by the pond and consider where you might acquire a key.", 
					Media = objTreasureChestClosed
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = "You try to open the treasure chest...but it is locked.", 
					Media = objTreasureChestClosed
				}
			}
			objKey1.Commands.cmdUnlockTreasureChest.Enabled = true
		end
		objnumOpenAttempts = objnumOpenAttempts + 1
	else
		_Urwigo.OldDialog{
			{
				Text = "This is the moment you have been waiting for since you got out of your jeep!", 
				Media = objTreasureChestClosed
			}, 
			{
				Text = "You grab the metal latch of the treasure chest, and begin to lift up. Nothing happens.", 
				Media = objTreasureChestClosed
			}, 
			{
				Text = "You apply a little more pressure, and all of a sudden, something gives and the heavy lid of the treasure chest swings open!", 
				Media = objTreasureChestClosed
			}, 
			{
				Text = "Now, the treasure chest is standing open before you. As you peer inside, it looks empty! After all of that work...nothing! What is going on here?", 
				Media = objTreasureChestOpen
			}
		}
		objTreasureChest.Commands.cmdLookInside.Enabled = true
		objTreasureChest.Commands.cmdOpen.Enabled = false
		objTreasureChest.Media = objTreasureChestOpen
		objTreasureChest.Icon = objiconTreasureChestOpen
		objTreasureChest.Description = "A treasure chest with the lid now open"
	end
end
function objTreasureChest:OncmdTake(target)
	_Urwigo.OldDialog{
		{
			Text = "You try to lift the treasure chest, but it is really heavy. Where would you put it, anyway? You decide to leave it here.", 
			Media = objTreasureChestClosed
		}
	}
	objTreasureChest.Commands.cmdTake.Enabled = false
end

-- Urwigo functions --
function objCheckCloseZones123()
	if (((objPeacePipe.Visible == true) and (objPieceofMap1.Visible == true)) and ((objClayPot.Visible == true) or (objClayPotwithWater.Visible == true))) and (objExcavateZones13.Complete == false) then
		objExcavateZones13.Complete = true
	end
end
function objCheckCloseZones45()
	if ((objPieceofMap2.Visible == true) and ((objClumpofDirt1.Visible == true) or (objKey1.Visible == true))) and (objExcavateZones45.Complete == false) then
		objExcavateZones45.Complete = true
	end
end
function objCheckCloseZone6()
	objExcavateZone6.Complete = true
end

-- Begin user functions --
-- End user functions --
return objExcavationinSellersville
