require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _jkD(str)
	local res = ""
    local dtable = "\087\043\090\055\111\084\033\006\017\004\005\105\011\029\094\053\071\024\025\124\037\070\101\096\109\052\116\051\012\098\065\108\020\048\083\073\097\062\068\110\121\120\126\100\079\067\009\114\104\057\093\039\059\002\047\032\119\016\049\066\000\058\030\019\014\041\112\081\091\113\092\036\035\085\031\103\054\076\088\074\007\027\021\018\042\008\015\115\010\022\050\078\072\061\001\075\125\060\123\056\013\038\003\063\107\064\095\040\023\122\106\082\034\046\080\099\089\118\069\044\086\045\102\117\077\028\026"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_LpBl7 = Wherigo.ZCartridge()

-- Media --
_Y7IFQ = Wherigo.ZMedia(_LpBl7)
_Y7IFQ.Id = "dae3c73d-5994-4a8b-a670-6986743833ce"
_Y7IFQ.Name = _jkD("\035\012\025\005\040\056\035\037\041\088\056\060\032\124\023")
_Y7IFQ.Description = ""
_Y7IFQ.AltText = ""
_Y7IFQ.Resources = {
	{
		Type = "jpg", 
		Filename = "Blue250x265.jpg", 
		Directives = {}
	}
}
_wm2 = Wherigo.ZMedia(_LpBl7)
_wm2.Id = "3903a0ea-a2d3-4efd-b8c0-edce240091fd"
_wm2.Name = _jkD("\115\037\027\049\056\059")
_wm2.Description = ""
_wm2.AltText = ""
_wm2.Resources = {
	{
		Type = "jpg", 
		Filename = "Path1250x188.jpg", 
		Directives = {}
	}
}
_kgJH = Wherigo.ZMedia(_LpBl7)
_kgJH.Id = "33d0bdef-d3ef-45f2-904e-ad9f38536733"
_kgJH.Name = _jkD("\074\067\056\006\049\048\005\124\076\049\056\027\049\023\056\001\005\005\044\088\056\108\003\005\040\023\056\091\066")
_kgJH.Description = ""
_kgJH.AltText = ""
_kgJH.Resources = {
	{
		Type = "jpg", 
		Filename = "UpThroughtheWoods230x307.jpg", 
		Directives = {}
	}
}
_8psyx = Wherigo.ZMedia(_LpBl7)
_8psyx.Id = "79f8137f-d7b8-42e2-9f49-1435f7e30212"
_8psyx.Name = _jkD("\001\012\040\044\041\056\125\012\032\032")
_8psyx.Description = ""
_8psyx.AltText = ""
_8psyx.Resources = {
	{
		Type = "jpg", 
		Filename = "WindyMill230x307.jpg", 
		Directives = {}
	}
}
_13bi = Wherigo.ZMedia(_LpBl7)
_13bi.Id = "1a349479-6860-4478-a693-aaeb0428800b"
_13bi.Name = _jkD("\115\037\027\049\056\091")
_13bi.Description = ""
_13bi.AltText = ""
_13bi.Resources = {
	{
		Type = "jpg", 
		Filename = "Path2230x307.jpg", 
		Directives = {}
	}
}
_MKat = Wherigo.ZMedia(_LpBl7)
_MKat.Id = "7edf2536-0035-4c41-98c7-e7c7e28a59f3"
_MKat.Name = _jkD("\115\037\027\049\056\028")
_MKat.Description = ""
_MKat.AltText = ""
_MKat.Resources = {
	{
		Type = "jpg", 
		Filename = "Path3230x307.jpg", 
		Directives = {}
	}
}
_h1DvJ = Wherigo.ZMedia(_LpBl7)
_h1DvJ.Id = "9848bd85-801b-49cc-860a-cf150575496d"
_h1DvJ.Name = _jkD("\035\012\025\005\040\056\035\037\041\088\056\112\023\044")
_h1DvJ.Description = ""
_h1DvJ.AltText = ""
_h1DvJ.Resources = {
	{
		Type = "jpg", 
		Filename = "Red250x254.jpg", 
		Directives = {}
	}
}
_Fpm = Wherigo.ZMedia(_LpBl7)
_Fpm.Id = "9c28cfa3-2030-495e-b416-c26d2ba8ae65"
_Fpm.Name = _jkD("\115\037\027\049\056\026")
_Fpm.Description = ""
_Fpm.AltText = ""
_Fpm.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_0221230x307.jpg", 
		Directives = {}
	}
}
_nJT_e = Wherigo.ZMedia(_LpBl7)
_nJT_e.Id = "8f897ba3-1505-4478-af10-21102c06ac70"
_nJT_e.Name = _jkD("\115\037\027\049\056\016")
_nJT_e.Description = ""
_nJT_e.AltText = ""
_nJT_e.Resources = {
	{
		Type = "jpg", 
		Filename = "Path5_2.jpg", 
		Directives = {}
	}
}
_tPsm5 = Wherigo.ZMedia(_LpBl7)
_tPsm5.Id = "71901ae1-b4ea-4709-9897-ef9d8e64062f"
_tPsm5.Name = _jkD("\035\012\025\005\040\056\035\037\041\088\056\017\048\023\023\040")
_tPsm5.Description = ""
_tPsm5.AltText = ""
_tPsm5.Resources = {
	{
		Type = "jpg", 
		Filename = "Green250x254.jpg", 
		Directives = {}
	}
}
_Yx9e = Wherigo.ZMedia(_LpBl7)
_Yx9e.Id = "97b4b638-289b-462b-a132-41a60b1e8d20"
_Yx9e.Name = _jkD("\115\037\027\049\056\004")
_Yx9e.Description = ""
_Yx9e.AltText = ""
_Yx9e.Resources = {
	{
		Type = "jpg", 
		Filename = "File230x307.jpg", 
		Directives = {}
	}
}
_wjGX = Wherigo.ZMedia(_LpBl7)
_wjGX.Id = "8f13eb81-7938-456e-916b-682cd2224684"
_wjGX.Name = _jkD("\035\012\025\005\040\056\035\037\041\088\056\117\023\032\032\005\057")
_wjGX.Description = ""
_wjGX.AltText = ""
_wjGX.Resources = {
	{
		Type = "jpg", 
		Filename = "yellow250x250.jpg", 
		Directives = {}
	}
}
_HOc = Wherigo.ZMedia(_LpBl7)
_HOc.Id = "899a9d45-a642-4ee2-9504-3bd822308f08"
_HOc.Name = _jkD("\060\048\012\116\105")
_HOc.Description = ""
_HOc.AltText = ""
_HOc.Resources = {
	{
		Type = "jpg", 
		Filename = "Brick250x188.jpg", 
		Directives = {}
	}
}
_fmy = Wherigo.ZMedia(_LpBl7)
_fmy.Id = "8689423c-46a6-420d-af06-cf90e7a5aed7"
_fmy.Name = _jkD("\035\012\025\005\040\056\035\037\041\088")
_fmy.Description = ""
_fmy.AltText = ""
_fmy.Resources = {
	{
		Type = "jpg", 
		Filename = "SimonSays.jpg", 
		Directives = {}
	}
}
_Ucmz = Wherigo.ZMedia(_LpBl7)
_Ucmz.Id = "57151ebc-fd15-48d7-a5d8-4622c1d7c17b"
_Ucmz.Name = _jkD("\115\037\027\049\056\100")
_Ucmz.Description = ""
_Ucmz.AltText = ""
_Ucmz.Resources = {
	{
		Type = "jpg", 
		Filename = "Path8_1.jpg", 
		Directives = {}
	}
}
_rjce = Wherigo.ZMedia(_LpBl7)
_rjce.Id = "e991c02d-f495-456a-aa8b-47e7f412c643"
_rjce.Name = _jkD("\046\037\116\049\023\056\035\067\005\012\032\023\048")
_rjce.Description = ""
_rjce.AltText = ""
_rjce.Resources = {
	{
		Type = "jpg", 
		Filename = "Spoiler1230x307.jpg", 
		Directives = {}
	}
}
_s7Th = Wherigo.ZMedia(_LpBl7)
_s7Th.Id = "409ec9d9-f403-4dad-aa97-2b2b559d0782"
_s7Th.Name = _jkD("\035\012\025\005\040\056\035\037\041\088\056\001\005\048\105")
_s7Th.Description = ""
_s7Th.AltText = ""
_s7Th.Resources = {
	{
		Type = "jpg", 
		Filename = "SimonWork250x252.jpg", 
		Directives = {}
	}
}
_Lbg = Wherigo.ZMedia(_LpBl7)
_Lbg.Id = "8f8fde35-30cf-48fe-8d9a-286f7df83321"
_Lbg.Name = _jkD("\046\037\048")
_Lbg.Description = ""
_Lbg.AltText = ""
_Lbg.Resources = {
	{
		Type = "jpg", 
		Filename = "BTFCar.jpg", 
		Directives = {}
	}
}
_EXjf = Wherigo.ZMedia(_LpBl7)
_EXjf.Id = "4062901d-6201-45fe-ae39-f41e2b549c14"
_EXjf.Name = _jkD("\036\116\005\040")
_EXjf.Description = ""
_EXjf.AltText = ""
_EXjf.Resources = {
	{
		Type = "jpg", 
		Filename = "Icon.jpg", 
		Directives = {}
	}
}
_lbbe8 = Wherigo.ZMedia(_LpBl7)
_lbbe8.Id = "ce83f080-582b-44a0-b4ce-c4f01049dab3"
_lbbe8.Name = _jkD("\092\005\056\001\037\041\056\045\124\027")
_lbbe8.Description = ""
_lbbe8.AltText = ""
_lbbe8.Resources = {
	{
		Type = "jpg", 
		Filename = "no-way-out300x125.jpg", 
		Directives = {}
	}
}
_ZhqPC = Wherigo.ZMedia(_LpBl7)
_ZhqPC.Id = "cc169607-096a-42c0-ba5c-c02af710d5c3"
_ZhqPC.Name = _jkD("\001\012\040\044\041\056\125\012\032\032\023\048")
_ZhqPC.Description = ""
_ZhqPC.AltText = ""
_ZhqPC.Resources = {
	{
		Type = "jpg", 
		Filename = "WindyMiller300x233.jpg", 
		Directives = {}
	}
}
_uy9Q7 = Wherigo.ZMedia(_LpBl7)
_uy9Q7.Id = "e42a1d9a-2775-4a1e-b301-9e1f9caeb9ef"
_uy9Q7.Name = _jkD("\115\012\076\056\012\040\056\125\124\044")
_uy9Q7.Description = ""
_uy9Q7.AltText = ""
_uy9Q7.Resources = {
	{
		Type = "jpg", 
		Filename = "PiginMud300x267.jpg", 
		Directives = {}
	}
}
_sHn3 = Wherigo.ZMedia(_LpBl7)
_sHn3.Id = "58208e0d-35c5-4336-be8e-66b13dc79d9f"
_sHn3.Name = _jkD("\017\037\027\023\057\037\041")
_sHn3.Description = ""
_sHn3.AltText = ""
_sHn3.Resources = {
	{
		Type = "jpg", 
		Filename = "Gateway_Supermarket_Logos300x165.jpg", 
		Directives = {}
	}
}
_ALBp = Wherigo.ZMedia(_LpBl7)
_ALBp.Id = "382f9bf4-1f42-418f-ad97-8a218ae0d05f"
_ALBp.Name = _jkD("\115\037\048\105\012\040\076")
_ALBp.Description = ""
_ALBp.AltText = ""
_ALBp.Resources = {
	{
		Type = "jpg", 
		Filename = "Parking270x334.jpg", 
		Directives = {}
	}
}
_Z62L8 = Wherigo.ZMedia(_LpBl7)
_Z62L8.Id = "5220e259-5c3b-4c68-81d2-4d4d1d9d0fe0"
_Z62L8.Name = _jkD("\006\048\023\037\088\124\048\023\056\060\005\042")
_Z62L8.Description = ""
_Z62L8.AltText = ""
_Z62L8.Resources = {
	{
		Type = "jpg", 
		Filename = "treasurebox300x294.jpg", 
		Directives = {}
	}
}
_nxqe = Wherigo.ZMedia(_LpBl7)
_nxqe.Id = "03adda9e-d4f2-4b54-815d-e855c913f4c9"
_nxqe.Name = _jkD("\039\023\111\037\056\121\124")
_nxqe.Description = ""
_nxqe.AltText = ""
_nxqe.Resources = {
	{
		Type = "jpg", 
		Filename = "DejaVu220x325.jpg", 
		Directives = {}
	}
}
_qYl = Wherigo.ZMedia(_LpBl7)
_qYl.Id = "a835f3da-dfdf-4542-bc70-e3b91de847cb"
_qYl.Name = _jkD("\036\040\027\005\056\027\049\023\056\039\023\067\027\049")
_qYl.Description = ""
_qYl.AltText = ""
_qYl.Resources = {
	{
		Type = "jpg", 
		Filename = "IntotheDepth220x323.jpg", 
		Directives = {}
	}
}
_dPmr = Wherigo.ZMedia(_LpBl7)
_dPmr.Id = "c81ac059-44e0-44c3-ab60-4a01ab371c9a"
_dPmr.Name = _jkD("\074\040\032\005\116\105")
_dPmr.Description = ""
_dPmr.AltText = ""
_dPmr.Resources = {
	{
		Type = "jpg", 
		Filename = "Unlock230x230.jpg", 
		Directives = {}
	}
}
_iSJt = Wherigo.ZMedia(_LpBl7)
_iSJt.Id = "efe980ca-9f47-4eee-8583-88c8c31a1a27"
_iSJt.Name = _jkD("\035\012\025\005\040\056\121\012\023\057")
_iSJt.Description = ""
_iSJt.AltText = ""
_iSJt.Resources = {
	{
		Type = "jpg", 
		Filename = "SimonView.jpg", 
		Directives = {}
	}
}
_JDuJM = Wherigo.ZMedia(_LpBl7)
_JDuJM.Id = "fb61b732-c968-4027-a491-f353df9bd6e6"
_JDuJM.Name = _jkD("\035\027\005\067\057\037\027\116\049")
_JDuJM.Description = ""
_JDuJM.AltText = ""
_JDuJM.Resources = {
	{
		Type = "jpg", 
		Filename = "StopWatch.jpg", 
		Directives = {}
	}
}
_FJZs = Wherigo.ZMedia(_LpBl7)
_FJZs.Id = "50c7210d-d1be-44aa-92d5-a8cda0e8cad9"
_FJZs.Name = _jkD("\036\040\056\006\049\023\056\031\048\025\041\056\092\005\057")
_FJZs.Description = ""
_FJZs.AltText = ""
_FJZs.Resources = {
	{
		Type = "jpg", 
		Filename = "InTheArmyNow200x259.jpg", 
		Directives = {}
	}
}
_Z35Y = Wherigo.ZMedia(_LpBl7)
_Z35Y.Id = "c157a721-754d-4a2f-8e89-fd0716e39982"
_Z35Y.Name = _jkD("\031\044\118\023\040\027\124\048\023")
_Z35Y.Description = ""
_Z35Y.AltText = ""
_Z35Y.Resources = {
	{
		Type = "jpg", 
		Filename = "Adventure.jpg", 
		Directives = {}
	}
}
_LA3 = Wherigo.ZMedia(_LpBl7)
_LA3.Id = "d5608660-804d-443e-8bfb-1336bcba635a"
_LA3.Name = _jkD("\115\037\027\049\056\050")
_LA3.Description = ""
_LA3.AltText = ""
_LA3.Resources = {
	{
		Type = "jpg", 
		Filename = "Path9.jpg", 
		Directives = {}
	}
}
_bTcm = Wherigo.ZMedia(_LpBl7)
_bTcm.Id = "2a58904e-b5c0-47e1-9955-c050a1cbb7c9"
_bTcm.Name = _jkD("\093\005\124\088\023")
_bTcm.Description = ""
_bTcm.AltText = ""
_bTcm.Resources = {
	{
		Type = "jpg", 
		Filename = "House.jpg", 
		Directives = {}
	}
}
_VykM = Wherigo.ZMedia(_LpBl7)
_VykM.Id = "7ba47185-48cf-4c92-9a35-56bfcc855ebf"
_VykM.Name = _jkD("\092\037\025\023")
_VykM.Description = ""
_VykM.AltText = ""
_VykM.Resources = {
	{
		Type = "jpg", 
		Filename = "WoodyWoodpecker.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_LpBl7.Id="2e28c371-be81-47e3-9829-ce098b1a9d81"
_LpBl7.Name="Simon Says"
_LpBl7.Description=[[Simon Says - The Wherigo in Ladock Woods]]
_LpBl7.Visible=true
_LpBl7.Activity="Geocache"
_LpBl7.StartingLocationDescription=[[]]
_LpBl7.StartingLocation = ZonePoint(50.3261333333333,-4.97408333333333,0)
_LpBl7.Version="V2.6"
_LpBl7.Company=""
_LpBl7.Author="Mountainbiker36"
_LpBl7.BuilderVersion="URWIGO 1.14.4469.18959"
_LpBl7.CreateDate="05/07/2012 21:57:05"
_LpBl7.PublishDate="1/1/0001 12:00:00 AM"
_LpBl7.UpdateDate="11/20/2012 17:30:19"
_LpBl7.LastPlayedDate="1/1/0001 12:00:00 AM"
_LpBl7.TargetDevice="PocketPC"
_LpBl7.TargetDeviceVersion="0"
_LpBl7.StateId="1"
_LpBl7.CountryId="2"
_LpBl7.Complete=false
_LpBl7.UseLogging=true

_LpBl7.Media=_fmy

_LpBl7.Icon=_EXjf


-- Zones --
_hvITy = Wherigo.Zone(_LpBl7)
_hvITy.Id = "1c3d1921-6623-45ee-b6e7-90e95d266d4b"
_hvITy.Name = _jkD("\092\005\056\001\037\041\056\045\124\027")
_hvITy.Description = ""
_hvITy.Visible = false
_hvITy.Media = _lbbe8
_hvITy.Commands = {}
_hvITy.DistanceRange = Distance(-1, "feet")
_hvITy.ShowObjects = "OnProximity"
_hvITy.ProximityRange = Distance(25, "feet")
_hvITy.AllowSetPositionTo = false
_hvITy.Active = false
_hvITy.Points = {
	ZonePoint(50.3274175797671, -4.97700096197127, 0), 
	ZonePoint(50.3273867579778, -4.97682221593857, 0), 
	ZonePoint(50.3273012557418, -4.97685229365038, 0), 
	ZonePoint(50.3273251713144, -4.97701887731546, 0)
}
_hvITy.OriginalPoint = ZonePoint(50.3273576912003, -4.97692358721892, 0)
_hvITy.DistanceRangeUOM = "Feet"
_hvITy.ProximityRangeUOM = "Feet"
_hvITy.OutOfRangeName = ""
_hvITy.InRangeName = ""
_5ZO = Wherigo.Zone(_LpBl7)
_5ZO.Id = "8dcd80ba-7beb-4038-852d-f6bba3202f9b"
_5ZO.Name = _jkD("\001\012\040\044\041\056\125\012\032\032\088")
_5ZO.Description = ""
_5ZO.Visible = false
_5ZO.Media = _ZhqPC
_5ZO.Commands = {}
_5ZO.DistanceRange = Distance(-1, "feet")
_5ZO.ShowObjects = "OnProximity"
_5ZO.ProximityRange = Distance(25, "feet")
_5ZO.AllowSetPositionTo = false
_5ZO.Active = false
_5ZO.Points = {
	ZonePoint(50.3285355017591, -4.98297643353135, 0), 
	ZonePoint(50.3284476034829, -4.98304894560181, 0), 
	ZonePoint(50.3284681508859, -4.98312136524521, 0), 
	ZonePoint(50.3285560491241, -4.98305114682512, 0)
}
_5ZO.OriginalPoint = ZonePoint(50.328501826313, -4.98304947280087, 0)
_5ZO.DistanceRangeUOM = "Feet"
_5ZO.ProximityRangeUOM = "Feet"
_5ZO.OutOfRangeName = ""
_5ZO.InRangeName = ""
_LR_4 = Wherigo.Zone(_LpBl7)
_LR_4.Id = "b1c2fe4f-a105-45eb-a138-c44ce90883a7"
_LR_4.Name = _jkD("\017\037\027\023\057\037\041")
_LR_4.Description = ""
_LR_4.Visible = false
_LR_4.Media = _sHn3
_LR_4.Commands = {}
_LR_4.DistanceRange = Distance(-1, "feet")
_LR_4.ShowObjects = "OnProximity"
_LR_4.ProximityRange = Distance(25, "feet")
_LR_4.AllowSetPositionTo = false
_LR_4.Active = false
_LR_4.Points = {
	ZonePoint(50.3321666666667, -4.98728333333333, 0), 
	ZonePoint(50.3321166666667, -4.9873, 0), 
	ZonePoint(50.3321166666667, -4.98748333333333, 0), 
	ZonePoint(50.3321666666667, -4.98748333333333, 0)
}
_LR_4.OriginalPoint = ZonePoint(50.3321416666667, -4.9873875, 0)
_LR_4.DistanceRangeUOM = "Feet"
_LR_4.ProximityRangeUOM = "Feet"
_LR_4.OutOfRangeName = ""
_LR_4.InRangeName = ""
_oYs = Wherigo.Zone(_LpBl7)
_oYs.Id = "7050ca1d-810d-4c4a-a555-fbb69258c2fd"
_oYs.Name = _jkD("\036\040\027\005\056\027\049\023\056\039\023\067\027\049\088")
_oYs.Description = ""
_oYs.Visible = false
_oYs.Media = _qYl
_oYs.Commands = {}
_oYs.DistanceRange = Distance(-1, "feet")
_oYs.ShowObjects = "OnProximity"
_oYs.ProximityRange = Distance(25, "feet")
_oYs.AllowSetPositionTo = false
_oYs.Active = false
_oYs.Points = {
	ZonePoint(50.3314381230032, -4.98059617096578, 0), 
	ZonePoint(50.3313649544879, -4.98074330390295, 0), 
	ZonePoint(50.3312757477218, -4.98052920816735, 0), 
	ZonePoint(50.3313870394246, -4.98043533085183, 0)
}
_oYs.OriginalPoint = ZonePoint(50.3313664661594, -4.98057600347198, 0)
_oYs.DistanceRangeUOM = "Feet"
_oYs.ProximityRangeUOM = "Feet"
_oYs.OutOfRangeName = ""
_oYs.InRangeName = ""
_CIrS = Wherigo.Zone(_LpBl7)
_CIrS.Id = "b16c5c43-2f94-4b79-bd14-d0c21d0b12d0"
_CIrS.Name = _jkD("\078\012\105\023\056\037\056\115\012\076\056\012\040\056\125\124\044")
_CIrS.Description = ""
_CIrS.Visible = false
_CIrS.Media = _uy9Q7
_CIrS.Commands = {}
_CIrS.DistanceRange = Distance(-1, "feet")
_CIrS.ShowObjects = "OnProximity"
_CIrS.ProximityRange = Distance(25, "feet")
_CIrS.AllowSetPositionTo = false
_CIrS.Active = false
_CIrS.Points = {
	ZonePoint(50.3321292934875, -4.97310881431895, 0), 
	ZonePoint(50.3321464149972, -4.97290496643382, 0), 
	ZonePoint(50.3323193419005, -4.97296129282313, 0), 
	ZonePoint(50.332303932598, -4.97316514070826, 0)
}
_CIrS.OriginalPoint = ZonePoint(50.3322247457458, -4.97303505357104, 0)
_CIrS.DistanceRangeUOM = "Feet"
_CIrS.ProximityRangeUOM = "Feet"
_CIrS.OutOfRangeName = ""
_CIrS.InRangeName = ""
_11Bij = Wherigo.Zone(_LpBl7)
_11Bij.Id = "7aeda9db-ad0b-4d26-921d-bf743897bdb3"
_11Bij.Name = _jkD("\001\049\023\048\023\056\057\023\052\048\023\056\017\005\012\040\076\120\056\057\023\056\044\005\040\052\027\056\040\023\023\044\056\112\005\037\044\088")
_11Bij.Description = ""
_11Bij.Visible = false
_11Bij.Media = _Lbg
_11Bij.Commands = {}
_11Bij.DistanceRange = Distance(-1, "feet")
_11Bij.ShowObjects = "OnProximity"
_11Bij.ProximityRange = Distance(25, "feet")
_11Bij.AllowSetPositionTo = false
_11Bij.Active = false
_11Bij.Points = {
	ZonePoint(50.332116720304, -4.96878410102522, 0), 
	ZonePoint(50.332025976175, -4.96855611325896, 0), 
	ZonePoint(50.3319318075559, -4.96863389732039, 0), 
	ZonePoint(50.3320379612586, -4.96885920287764, 0)
}
_11Bij.OriginalPoint = ZonePoint(50.3320281163234, -4.96870832862055, 0)
_11Bij.DistanceRangeUOM = "Feet"
_11Bij.ProximityRangeUOM = "Feet"
_11Bij.OutOfRangeName = ""
_11Bij.InRangeName = ""
_fv99l = Wherigo.Zone(_LpBl7)
_fv99l.Id = "c024d8fc-4e52-4aec-b894-fd4404f4aaa9"
_fv99l.Name = _jkD("\125\060\052\088\056\031\044\118\023\040\027\124\048\023\056\003\005\040\023")
_fv99l.Description = ""
_fv99l.Visible = false
_fv99l.Media = _Z35Y
_fv99l.Commands = {}
_fv99l.DistanceRange = Distance(-1, "feet")
_fv99l.ShowObjects = "OnProximity"
_fv99l.ProximityRange = Distance(25, "feet")
_fv99l.AllowSetPositionTo = false
_fv99l.Active = false
_fv99l.Points = {
	ZonePoint(50.3291473759134, -4.96446034027736, 0), 
	ZonePoint(50.3290029685571, -4.96464731779099, 0), 
	ZonePoint(50.3291368693425, -4.96472413988113, 0), 
	ZonePoint(50.3291813323748, -4.96448495171865, 0)
}
_fv99l.OriginalPoint = ZonePoint(50.329117136547, -4.96457918741703, 0)
_fv99l.DistanceRangeUOM = "Feet"
_fv99l.ProximityRangeUOM = "Feet"
_fv99l.OutOfRangeName = ""
_fv99l.InRangeName = ""
_rjG = Wherigo.Zone(_LpBl7)
_rjG.Id = "c65b3f23-a243-4155-966c-5a21b7929e93"
_rjG.Name = _jkD("\093\037\118\023\056\036\056\040\005\027\056\088\023\023\040\056\027\049\012\088\056\046\032\124\023\056\060\023\123\005\048\023\104")
_rjG.Description = ""
_rjG.Visible = false
_rjG.Media = _nxqe
_rjG.Commands = {}
_rjG.DistanceRange = Distance(-1, "feet")
_rjG.ShowObjects = "OnProximity"
_rjG.ProximityRange = Distance(25, "feet")
_rjG.AllowSetPositionTo = false
_rjG.Active = false
_rjG.Points = {
	ZonePoint(50.3266940642289, -4.96738544212974, 0), 
	ZonePoint(50.3266414382556, -4.96741015542352, 0), 
	ZonePoint(50.3266352166247, -4.96733879017825, 0), 
	ZonePoint(50.3266848747273, -4.96730660367007, 0)
}
_rjG.OriginalPoint = ZonePoint(50.3266638984591, -4.9673602478504, 0)
_rjG.DistanceRangeUOM = "Feet"
_rjG.ProximityRangeUOM = "Feet"
_rjG.OutOfRangeName = ""
_rjG.InRangeName = ""
_rWWrY = Wherigo.Zone(_LpBl7)
_rWWrY.Id = "ec7742c2-8926-4864-9c7b-8ebae10fd880"
_rWWrY.Name = _jkD("\092\005\057\114\114\114\114\114\001\049\023\048\023\056\012\088\056\027\049\037\027\056\046\037\116\049\023\104\007")
_rWWrY.Description = ""
_rWWrY.Visible = false
_rWWrY.Media = _Z62L8
_rWWrY.Commands = {}
_rWWrY.DistanceRange = Distance(-1, "feet")
_rWWrY.ShowObjects = "OnProximity"
_rWWrY.ProximityRange = Distance(25, "feet")
_rWWrY.AllowSetPositionTo = false
_rWWrY.Active = false
_rWWrY.Points = {
	ZonePoint(50.3240902423796, -4.96906014599801, 0), 
	ZonePoint(50.3241125041069, -4.96918889203073, 0), 
	ZonePoint(50.3240337317944, -4.96923180737497, 0), 
	ZonePoint(50.3240029078104, -4.96911379017831, 0)
}
_rWWrY.OriginalPoint = ZonePoint(50.3240598465228, -4.9691486588955, 0)
_rWWrY.DistanceRangeUOM = "Feet"
_rWWrY.ProximityRangeUOM = "Feet"
_rWWrY.OutOfRangeName = ""
_rWWrY.InRangeName = ""
_Uj4l = Wherigo.Zone(_LpBl7)
_Uj4l.Id = "fb258aa9-9a8e-44be-9f77-85e7fe24573a"
_Uj4l.Name = _jkD("\115\048\023\056\003\005\040\023\056\035\027\037\048\027")
_Uj4l.Description = ""
_Uj4l.Visible = false
_Uj4l.Media = _ALBp
_Uj4l.Commands = {}
_Uj4l.DistanceRange = Distance(-1, "feet")
_Uj4l.ShowObjects = "OnProximity"
_Uj4l.ProximityRange = Distance(20, "feet")
_Uj4l.AllowSetPositionTo = false
_Uj4l.Active = false
_Uj4l.Points = {
	ZonePoint(50.3260314241622, -4.97381359378494, 0), 
	ZonePoint(50.3262591689617, -4.97399866620697, 0), 
	ZonePoint(50.3260999189535, -4.97453779021896, 0), 
	ZonePoint(50.3258755981442, -4.97441172639526, 0)
}
_Uj4l.OriginalPoint = ZonePoint(50.3260665275554, -4.97419044415153, 0)
_Uj4l.DistanceRangeUOM = "Feet"
_Uj4l.ProximityRangeUOM = "Feet"
_Uj4l.OutOfRangeName = ""
_Uj4l.InRangeName = ""
_fSju2 = Wherigo.Zone(_LpBl7)
_fSju2.Id = "1f8a9126-7e91-46eb-b524-cc65cb07786c"
_fSju2.Name = _jkD("\117\005\124\048\056\012\040\056\027\049\023\056\031\048\025\041\056\092\005\057\007")
_fSju2.Description = ""
_fSju2.Visible = false
_fSju2.Media = _FJZs
_fSju2.Commands = {}
_fSju2.DistanceRange = Distance(-1, "feet")
_fSju2.ShowObjects = "OnProximity"
_fSju2.ProximityRange = Distance(30, "feet")
_fSju2.AllowSetPositionTo = false
_fSju2.Active = false
_fSju2.Points = {
	ZonePoint(50.3292256838458, -4.9641247132937, 0), 
	ZonePoint(50.3291081053667, -4.96411398445764, 0), 
	ZonePoint(50.329152340447, -4.96435154480935, 0)
}
_fSju2.OriginalPoint = ZonePoint(50.3291620432198, -4.96419674752023, 0)
_fSju2.DistanceRangeUOM = "Feet"
_fSju2.ProximityRangeUOM = "Feet"
_fSju2.OutOfRangeName = ""
_fSju2.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
_N4JN = _jkD("\107\049\118\036\006\041")
_QXEpT = _jkD("\044\124\025\025\041")
_St9 = _jkD("\044\124\025\025\041")
_XSlW = _jkD("\044\124\025\025\041")
_AhFf = _jkD("\107\067\050\077")
_OZO = _jkD("\107\057\045\070\100")
_LpBl7.ZVariables = {
	_N4JN = _jkD("\107\049\118\036\006\041"), 
	_QXEpT = _jkD("\044\124\025\025\041"), 
	_St9 = _jkD("\044\124\025\025\041"), 
	_XSlW = _jkD("\044\124\025\025\041"), 
	_AhFf = _jkD("\107\067\050\077"), 
	_OZO = _jkD("\107\057\045\070\100")
}

-- Timers --
_wOq8 = Wherigo.ZTimer(_LpBl7)
_wOq8.Id = "9aee8598-c299-4080-962b-73d33e4dbf99"
_wOq8.Name = _jkD("\035\027\048\023\037\025\056\046\048\005\088\088\012\040\076\056\006\012\025\023\048")
_wOq8.Description = ""
_wOq8.Visible = true
_wOq8.Duration = 50
_wOq8.Type = "Countdown"

-- Inputs --
_p96 = Wherigo.ZInput(_LpBl7)
_p96.Id = "f032bb3d-05bc-46cc-8343-d8151c154fe7"
_p96.Name = _jkD("\068\124\023\088\027\012\005\040\056\059")
_p96.Description = ""
_p96.Visible = true
_p96.InputType = "Text"
_p96.Text = _jkD("\093\005\057\056\125\037\040\041\056\093\005\048\012\110\005\040\027\037\032\056\035\032\037\027\088\056\037\048\023\056\027\049\023\048\023\056\005\040\056\027\049\023\056\022\023\040\116\012\040\076\104\056\108\119\040\027\023\048\056\118\037\032\124\023\056\037\088\056\040\124\025\030\023\048\066\098\060\112\038")
_Gg_ = Wherigo.ZInput(_LpBl7)
_Gg_.Id = "6fd9ea1e-8b9e-48f6-a4c0-ac0b6c614d54"
_Gg_.Name = _jkD("\068\124\023\088\027\012\005\040\056\091")
_Gg_.Description = ""
_Gg_.Visible = true
_Gg_.InputType = "Text"
_Gg_.Text = _jkD("\093\005\057\056\125\037\040\041\056\001\012\040\044\041\056\125\012\032\032\088\056\116\037\040\056\117\005\124\056\035\023\023\056\012\040\056\027\049\023\056\022\037\048\056\039\012\088\027\037\040\116\023\056\123\048\005\025\056\027\049\012\088\056\067\005\012\040\027\056\005\040\056\027\049\023\056\006\048\037\012\032\104\056\108\119\040\027\023\048\056\121\037\032\124\023\056\037\088\056\040\124\025\030\023\048\066\098\060\112\038")
_IMTBJ = Wherigo.ZInput(_LpBl7)
_IMTBJ.Id = "f0f585a0-01c9-4dac-9dac-2bd88e2bb931"
_IMTBJ.Name = _jkD("\068\124\023\088\027\012\005\040\056\028")
_IMTBJ.Description = ""
_IMTBJ.Visible = true
_IMTBJ.InputType = "Text"
_IMTBJ.Text = _jkD("\093\005\057\056\125\037\040\041\056\093\005\048\012\110\005\040\027\037\032\056\060\037\048\088\056\005\040\056\030\005\027\049\056\035\023\027\088\056\005\123\056\076\037\027\023\088\104\056\108\119\040\027\023\048\056\121\037\032\124\023\056\037\088\056\040\124\025\030\023\048\066")
_st_ = Wherigo.ZInput(_LpBl7)
_st_.Id = "b04a4388-9c23-489b-85e2-6314e697b594"
_st_.Name = _jkD("\068\124\023\088\027\012\005\040\056\026")
_st_.Description = ""
_st_.Visible = true
_st_.InputType = "Text"
_st_.Text = _jkD("\022\048\005\025\056\027\049\023\056\001\005\005\044\023\040\056\060\037\048\048\012\023\048\056\049\023\048\023\056\041\005\124\056\116\037\040\056\088\023\023\056\037\056\049\005\124\088\023\056\012\040\056\027\049\023\056\044\012\088\027\037\040\116\023\114\093\005\057\056\025\037\040\041\056\057\012\040\044\005\057\088\056\037\040\044\056\044\005\005\048\088\056\044\005\023\088\056\027\049\023\056\093\005\124\088\023\056\049\037\118\023\056\005\040\056\027\049\023\056\123\048\005\040\027\056\037\040\044\056\088\012\044\023\104\056\108\119\040\027\023\048\056\118\037\032\124\023\056\037\088\056\040\124\025\030\023\048\066")
_IvoGy = Wherigo.ZInput(_LpBl7)
_IvoGy.Id = "8e9ca854-f428-42f0-bf57-b122c7aa0c0f"
_IvoGy.Name = _jkD("\068\124\023\088\027\012\005\040\056\016")
_IvoGy.Description = ""
_IvoGy.Visible = true
_IvoGy.InputType = "Text"
_IvoGy.Text = _jkD("\093\005\057\056\125\037\040\041\056\060\005\032\027\088\056\037\027\027\037\116\049\056\027\049\023\056\006\005\067\056\025\023\027\037\032\056\060\048\037\116\105\023\027\056\027\005\056\027\049\023\056\076\037\027\023\104\056\108\119\040\027\023\048\056\121\037\032\124\023\056\037\088\056\092\124\025\030\023\048\066")
_uGS4 = Wherigo.ZInput(_LpBl7)
_uGS4.Id = "9c946340-34e6-42f3-82a3-863a4dee3db5"
_uGS4.Name = _jkD("\068\124\023\088\027\012\005\040\056\077")
_uGS4.Description = ""
_uGS4.Visible = true
_uGS4.Choices = {
	"7 Pieces?", 
	"8 Pieces?", 
	"9 Pieces?", 
	"10 Pieces?", 
	"11 Pieces?", 
	"12 Pieces?", 
	"13 Pieces?"
}
_uGS4.InputType = "MultipleChoice"
_uGS4.Text = _jkD("\093\005\057\056\125\037\040\041\056\067\012\023\116\023\088\056\005\123\056\057\005\005\044\056\012\088\056\027\049\023\056\076\037\027\023\056\025\037\044\023\056\124\067\056\005\123\123\104\098\060\112\038\108\125\124\032\027\012\067\032\023\056\046\049\005\012\116\023\066")
_M6yx = Wherigo.ZInput(_LpBl7)
_M6yx.Id = "00121caf-3446-483d-bffd-34bd99c8e175"
_M6yx.Name = _jkD("\068\124\023\088\027\012\005\040\056\004")
_M6yx.Description = ""
_M6yx.Visible = true
_M6yx.InputType = "Text"
_M6yx.Text = _jkD("\006\049\023\048\023\056\012\088\056\037\056\025\023\027\037\032\056\076\037\027\023\056\049\023\048\023\114\093\005\057\056\125\037\040\041\056\039\012\037\076\005\040\037\032\056\115\005\032\023\088\056\037\048\023\056\005\040\056\012\027\104\056\108\119\040\027\023\048\056\121\037\032\124\023\056\037\088\056\092\124\025\030\023\048\066")
_tz2KQ = Wherigo.ZInput(_LpBl7)
_tz2KQ.Id = "704ff88c-66ec-4cfa-a783-71c57b70d553"
_tz2KQ.Name = _jkD("\068\124\023\088\027\012\005\040\056\100")
_tz2KQ.Description = ""
_tz2KQ.Visible = true
_tz2KQ.InputType = "Text"
_tz2KQ.Text = _jkD("\031\027\056\027\049\012\088\056\067\005\012\040\027\056\005\040\056\027\049\023\056\006\048\037\012\032\056\041\005\124\056\057\012\032\032\056\092\005\027\012\116\023\056\088\005\025\023\056\030\048\012\116\105\088\056\057\012\027\049\056\049\005\032\023\088\056\012\040\056\027\049\023\025\056\037\027\056\076\048\005\124\040\044\056\032\023\118\023\032\114\022\012\040\044\056\037\056\123\124\032\032\056\030\048\012\116\105\056\057\012\027\049\056\028\056\048\005\057\088\056\005\123\056\049\005\032\023\088\114\093\005\057\056\025\037\040\041\056\049\005\032\023\088\056\025\037\105\023\056\124\067\056\027\049\023\056\028\056\048\005\057\088\104\056\108\119\040\027\023\048\056\121\037\032\124\023\056\037\088\056\040\124\025\030\023\048\066")
_FNJ5 = Wherigo.ZInput(_LpBl7)
_FNJ5.Id = "3621e065-70b3-40ca-be90-7b10ca439df2"
_FNJ5.Name = _jkD("\060\005\040\124\088\056\046\037\116\049\023\056\046\005\044\023\056\036\040\067\124\027")
_FNJ5.Description = ""
_FNJ5.Visible = true
_FNJ5.InputType = "Text"
_FNJ5.Text = _jkD("\115\032\023\037\088\023\056\023\040\027\023\048\056\027\049\023\056\016\056\039\012\076\012\027\056\046\005\044\023")

-- WorksWithList for object commands --

-- functions --
function _LpBl7:OnStart()
	if (_G[_jkD("\119\040\118")][_jkD("\039\023\118\012\116\023\036\039")] == _jkD("\039\023\088\105\027\005\067")) or (_G[_jkD("\119\040\118")][_jkD("\115\032\037\027\123\005\048\025")] == _jkD("\001\012\040\028\091")) then
		for k, v in pairs(_G[_jkD("\107\078\067\060\032\004")][_jkD("\031\032\032\003\045\030\111\023\116\027\088")]) do
			v[_jkD("\121\012\088\012\030\032\023")] = false
			v[_jkD("\031\116\027\012\118\023")] = false
		end
		_G[_jkD("\001\049\023\048\012\076\005")][_jkD("\046\005\025\025\037\040\044")](_jkD("\035\037\118\023\046\032\005\088\023"))
		return
	end
	_Urwigo.MessageBox{
		Text = _jkD("\115\032\023\037\088\023\056\115\037\048\105\056\037\027\056\078\037\044\005\116\105\056\001\005\005\044\088\056\027\005\056\035\027\037\048\027\056\006\049\023\056\035\012\025\005\040\056\035\037\041\088\056\046\037\048\027\048\012\044\076\023\114"), 
		Buttons = {
			_jkD("\046\032\012\116\105\056\027\005\056\115\048\023\056\003\005\040\023")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Uj4l.Active = true
				_Uj4l.Visible = true
			end
		end
	}
end
function _LpBl7:OnEnd()
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
function _LpBl7:OnRestore()
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
function _LpBl7:OnSync()
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
function _hvITy:OnExit()
	_N4JN = _jkD("\107\049\118\036\006\041")
	_LpBl7:RequestSync()
end
function _hvITy:OnProximity()
	_N4JN = _jkD("\107\049\118\036\006\041")
	_hvITy.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\059\056\122\056\092\005\056\001\037\041\056\045\124\027"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = "", 
					Media = _Y7IFQ, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_p96)
							end)
						end
					end
				}
			end
		end
	}
end
function _5ZO:OnExit()
	_N4JN = _jkD("\107\016\003\045")
	_LpBl7:RequestSync()
end
function _5ZO:OnProximity()
	_N4JN = _jkD("\107\016\003\045")
	_5ZO.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\091\056\122\056\001\012\040\044\041\056\125\012\032\032\088"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_Gg_)
				end)
			end
		end
	}
end
function _LR_4:OnExit()
	_N4JN = _jkD("\107\078\112\107\026")
	_LpBl7:RequestSync()
end
function _LR_4:OnProximity()
	_N4JN = _jkD("\107\078\112\107\026")
	_LR_4.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\028\056\122\056\017\037\027\023\057\037\041"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_IMTBJ)
				end)
			end
		end
	}
end
function _oYs:OnExit()
	_N4JN = _jkD("\107\005\117\088")
	_LpBl7:RequestSync()
end
function _oYs:OnProximity()
	_N4JN = _jkD("\107\005\117\088")
	_oYs.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\026\056\122\056\036\040\027\005\056\027\049\023\056\039\023\067\027\049\088"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = "", 
					Media = _h1DvJ, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_st_)
							end)
						end
					end
				}
			end
		end
	}
end
function _CIrS:OnExit()
	_N4JN = _jkD("\107\046\036\048\035")
	_LpBl7:RequestSync()
end
function _CIrS:OnProximity()
	_N4JN = _jkD("\107\046\036\048\035")
	_CIrS.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\016\056\122\056\078\012\105\023\056\037\056\115\012\076\056\012\040\056\125\124\044\114\056\036\025\056\076\124\023\088\088\012\040\076\056\041\005\124\048\056\123\023\023\027\056\025\012\076\049\027\056\030\023\056\037\056\027\037\044\056\025\124\044\044\041\056\030\041\056\040\005\057\056\078\045\078\114"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_IvoGy)
				end)
			end
		end
	}
end
function _11Bij:OnExit()
	_N4JN = _jkD("\107\059\059\060\012\111")
	_LpBl7:RequestSync()
end
function _11Bij:OnProximity()
	_N4JN = _jkD("\107\059\059\060\012\111")
	_11Bij.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\077\056\122\056\001\049\023\048\023\056\057\023\052\048\023\056\017\005\012\040\076\120\056\057\023\056\044\005\040\052\027\056\040\023\023\044\056\112\005\037\044\088\114"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _jkD("\001\005\005\044\041\056\001\005\005\044\067\023\116\105\023\048\056\031\088\105\088\104"), 
					Media = _VykM, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_uGS4)
							end)
						end
					end
				}
			end
		end
	}
end
function _fv99l:OnExit()
	_N4JN = _jkD("\107\123\118\050\050\032")
	_LpBl7:RequestSync()
end
function _fv99l:OnProximity()
	_N4JN = _jkD("\107\123\118\050\050\032")
	_fv99l.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\004\056\122\056\125\060\052\088\056\031\044\118\023\040\027\124\048\023\056\003\005\040\023"), 
		Callback = function(action)
			if action ~= nil then
				_wOq8:Start()
			end
		end
	}
end
function _rjG:OnExit()
	_N4JN = _jkD("\107\048\111\017")
	_LpBl7:RequestSync()
end
function _rjG:OnProximity()
	_N4JN = _jkD("\107\048\111\017")
	_rjG.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\050\056\122\056\093\037\118\023\056\036\056\040\005\027\056\088\023\023\040\056\027\049\012\088\056\116\032\124\023\056\060\023\123\005\048\023\104\056\006\049\012\088\056\012\088\056\027\049\023\056\115\023\040\124\032\027\012\025\037\027\023\056\003\005\040\023\114"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = "", 
					Media = _wjGX, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_tz2KQ)
							end)
						end
					end
				}
			end
		end
	}
end
function _rWWrY:OnExit()
	_N4JN = _jkD("\107\048\001\001\048\117")
	_LpBl7:RequestSync()
end
function _rWWrY:OnProximity()
	_N4JN = _jkD("\107\048\001\001\048\117")
	_rWWrY.Active = true
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\031\032\005\040\076\056\027\049\012\088\056\067\037\048\027\056\005\123\056\027\049\023\056\027\048\037\012\032\056\041\005\124\056\057\012\032\032\056\123\012\040\044\056\027\049\023\056\116\037\116\049\023\114\036\027\088\056\080\124\088\027\056\005\123\123\056\027\049\023\056\027\048\037\012\032\056\037\040\044\056\012\088\056\005\123\056\048\023\076\124\032\037\048\056\088\012\110\023\114\125\037\105\023\056\088\124\048\023\056\041\005\124\056\049\037\118\023\056\037\032\032\056\041\005\124\048\056\046\032\124\023\088\056\093\037\040\044\041\056\037\088\056\041\005\124\056\057\012\032\032\056\040\023\023\044\056\027\049\023\025\114\115\032\023\037\088\023\056\088\023\023\056\027\049\023\056\088\067\005\012\032\023\048\056\115\012\116\056\037\088\056\027\005\056\037\056\048\005\124\076\049\056\037\048\023\037\056\027\005\056\032\005\005\105\114\056\102\040\030\088\067\053\093\012\040\027\056\122\056\039\005\040\052\027\056\076\023\027\056\088\027\124\116\105\007"), 
		Media = _rjce, 
		Buttons = {
			_jkD("\046\032\012\116\105\056\001\049\023\040\056\022\005\124\040\044\056\046\037\116\049\023\056\027\005\056\074\088\023\056\046\032\124\023\088")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _jkD("\060\032\124\023\056\094\056\059\088\027\056\039\012\076\012\027\098\060\112\038\112\023\044\056\094\056\102\040\030\088\067\053\091\040\044\056\039\012\076\012\027\098\060\112\038\017\048\023\023\040\056\094\056\028\048\044\056\039\012\076\012\027\098\060\112\038\039\012\118\012\044\023\056\117\023\032\032\005\057\056\030\041\056\026\056\094\056\026\027\049\056\039\012\076\012\027"), 
					Media = _dPmr, 
					Buttons = {
						_jkD("\046\032\012\116\105\056\001\049\023\040\056\046\037\116\049\023\056\012\088\056\074\040\032\005\116\105\023\044")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _jkD("\092\005\057\056\041\005\124\056\049\037\118\023\056\074\040\032\005\116\105\023\044\056\027\049\023\056\116\037\116\049\023\056\041\005\124\056\116\037\040\056\023\040\027\023\048\056\027\049\023\056\116\005\044\023\056\123\005\048\056\027\049\023\056\035\012\025\005\040\056\035\037\041\088\056\060\005\040\124\088\056\046\037\116\049\023\056\017\046\028\096\077\080\050\114\006\049\023\056\046\005\044\023\056\012\088\056\012\040\056\027\049\023\056\116\037\116\049\023\056\067\005\027\056\045\040\056\037\056\032\037\025\012\040\037\027\023\044\056\046\037\048\044\114"), 
								Buttons = {
									_jkD("\046\032\012\116\105\056\027\005\056\036\040\067\124\027\056\046\005\044\023")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(_FNJ5)
										end)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _Uj4l:OnEnter()
	_N4JN = _jkD("\107\074\111\026\032")
	_Urwigo.MessageBox{
		Text = _jkD("\001\023\032\116\005\025\023\056\027\005\056\027\049\023\056\035\012\025\005\040\056\035\037\041\088\056\001\049\023\048\012\076\005\056\012\040\056\078\037\044\005\116\105\056\001\005\005\044\088\114\117\005\124\056\057\012\032\032\056\030\023\056\123\005\032\032\005\057\012\040\076\056\119\042\012\088\027\012\040\076\056\006\048\037\116\105\088\056\037\040\088\057\023\048\012\040\076\056\070\124\023\088\027\012\005\040\088\056\037\040\044\056\076\037\012\040\012\040\076\056\116\032\124\023\088\056\123\005\048\056\027\049\023\056\022\012\040\037\032\056\046\037\116\049\023\114\115\078\119\031\035\119\056\046\045\115\117\056\031\092\039\056\092\045\006\119\056\039\045\001\092\056\031\078\078\056\046\078\074\119\035\056\031\092\039\056\046\045\078\045\074\112\035\056\046\031\112\119\022\074\078\078\117\007\056\102\040\030\088\067\053\017\005\005\044\056\078\124\116\105\056\037\040\044\056\093\037\067\067\041\056\093\124\040\027\012\040\076\114\125\005\124\040\027\037\012\040\030\012\105\023\048\028\077"), 
		Media = _s7Th, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _jkD("\001\049\023\040\056\117\005\124\056\037\048\023\056\048\023\037\044\041\120\056\067\032\023\037\088\023\056\123\005\032\032\005\057\056\027\049\023\056\067\037\027\049\056\088\049\005\057\040\056\012\040\056\027\049\023\056\012\025\037\076\023\114"), 
					Media = _wm2, 
					Buttons = {
						_jkD("\046\032\012\116\105\056\123\005\048\056\003\005\040\023\056\059")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Uj4l.Active = false
							_hvITy.Active = true
							_hvITy.Visible = true
						end
					end
				}
			end
		end
	}
end
function _Uj4l:OnExit()
	_N4JN = _jkD("\107\074\111\026\032")
	_LpBl7:RequestSync()
end
function _fSju2:OnExit()
	_N4JN = _jkD("\107\123\035\111\124\091")
	_fSju2.Active = false
	_fSju2.Visible = false
	_fv99l.Active = true
	_fv99l.Visible = true
	_LpBl7:RequestSync()
end
function _fSju2:OnProximity()
	_N4JN = _jkD("\107\123\035\111\124\091")
	_wOq8:Stop()
end
function _p96:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 4 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\116\005\048\048\023\116\027\114\117\005\124\056\125\037\041\056\046\005\040\027\012\040\124\023\056\027\005\056\027\049\023\056\040\023\042\027\056\003\005\040\023\114\022\005\032\032\005\057\056\027\049\023\056\115\037\027\049\056\012\040\056\027\049\023\056\036\025\037\076\023\114\117\005\124\056\057\012\032\032\056\092\005\027\012\116\023\056\093\005\048\088\023\056\080\124\025\067\088\056\017\005\012\040\076\056\124\067\056\027\049\048\005\124\076\049\056\027\049\012\088\056\067\037\048\027\056\005\123\056\078\037\044\005\116\105\056\001\005\005\044\088\114\093\005\057\056\025\037\040\041\056\116\037\040\056\041\005\124\056\080\124\025\067\056\032\005\032\104"), 
			Media = _kgJH, 
			Buttons = {
				_jkD("\046\032\012\116\105\056\123\005\048\056\003\005\040\023\056\091")
			}, 
			Callback = function(action)
				if action ~= nil then
					_hvITy.Active = false
					_5ZO.Visible = true
					_5ZO.Active = true
				end
			end
		}
	elseif input ~= 4 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\040\005\027\056\116\005\048\048\023\116\027\114\115\032\023\037\088\023\056\006\048\041\056\031\076\037\012\040"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_p96)
					end)
				end
			end
		}
	end
end
function _Gg_:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 1 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\046\005\048\048\023\116\027\114\006\049\023\048\023\056\012\088\056\080\124\088\027\056\059\056\001\012\040\044\041\056\125\012\032\032\114\114\114\114\114\114\114\074\040\027\012\032\056\125\005\048\023\056\115\005\067\056\124\067\056\078\045\078"), 
			Media = _8psyx, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _jkD("\092\005\057\056\022\005\032\032\005\057\056\027\049\023\056\115\037\027\049\056\012\040\056\027\049\023\056\036\025\037\076\023\056\027\005\056\117\005\124\048\056\092\023\042\027\056\110\005\040\023\098\060\112\038"), 
						Media = _13bi, 
						Buttons = {
							_jkD("\046\032\012\116\105\056\123\005\048\056\003\005\040\023\056\028")
						}, 
						Callback = function(action)
							if action ~= nil then
								_5ZO.Active = false
								_LR_4.Visible = true
								_LR_4.Active = true
							end
						end
					}
				end
			end
		}
	elseif input ~= 1 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\092\005\027\056\046\005\048\048\023\116\027\114\115\032\023\037\088\023\056\006\048\041\056\031\076\037\012\040"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Gg_)
					end)
				end
			end
		}
	end
end
function _IMTBJ:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 10 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\046\005\048\048\023\116\027\114\117\005\124\056\125\037\041\056\046\005\040\027\012\040\124\023\056\027\005\056\027\049\023\056\040\023\042\027\056\003\005\040\023\114\022\005\032\032\005\057\056\027\049\023\056\115\037\027\049\056\035\049\005\057\040\056\012\040\056\027\049\023\056\012\025\037\076\023\056\108\060\023\049\012\040\044\056\037\088\056\041\005\124\056\032\005\005\105\056\037\027\056\027\049\023\056\017\037\027\023\088\066"), 
			Media = _MKat, 
			Buttons = {
				_jkD("\046\032\012\116\105\056\123\005\048\056\003\005\040\023\056\026")
			}, 
			Callback = function(action)
				if action ~= nil then
					_LR_4.Active = false
					_oYs.Active = true
					_oYs.Visible = true
				end
			end
		}
	elseif input ~= 10 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\040\005\027\056\046\005\048\048\023\116\027\120\115\032\023\037\088\023\056\006\048\041\056\031\076\037\012\040"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_IMTBJ)
					end)
				end
			end
		}
	end
end
function _st_:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 5 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\046\005\048\048\023\116\027\114\091\056\001\012\040\044\005\057\088\056\037\040\044\056\037\056\039\005\005\048\056\005\040\056\027\049\023\056\123\048\005\040\027\056\037\040\044\056\091\056\057\012\040\044\005\057\088\056\005\040\056\027\049\023\056\088\012\044\023\114"), 
			Media = _bTcm, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _jkD("\117\005\124\056\025\037\041\056\116\005\040\027\012\040\124\023\056\027\005\056\027\049\023\056\040\023\042\027\056\003\005\040\023\114\115\032\023\037\088\023\056\123\005\032\032\005\057\056\027\049\023\056\115\037\027\049\056\088\049\005\057\040\056\012\040\056\027\049\023\056\012\025\037\076\023\114\006\049\023\088\023\056\001\037\041\067\005\012\040\027\056\046\005\122\005\048\044\088\056\057\012\032\032\056\049\023\032\067\056\041\005\124\056\048\023\037\116\049\056\027\049\023\056\003\005\040\023\098\060\112\038\001\037\041\067\005\012\040\027\056\059\056\122\056\092\016\034\056\059\050\114\100\004\028\056\001\034\034\026\056\016\100\114\004\026\016\098\060\112\038\001\037\041\067\005\012\040\027\056\091\056\122\056\092\016\034\056\059\050\114\100\016\050\056\001\034\034\026\056\016\100\114\004\059\077\098\060\112\038\001\037\041\067\005\012\040\027\056\028\056\122\056\092\016\034\056\059\050\114\100\016\026\056\001\034\034\026\056\016\100\114\077\034\026\098\060\112\038\001\037\041\067\005\012\040\027\056\026\056\122\056\092\016\034\056\059\050\114\100\016\004\056\001\034\034\026\056\016\100\114\028\026\050"), 
						Media = _Fpm, 
						Buttons = {
							_jkD("\046\032\012\116\105\056\123\005\048\056\003\005\040\023\056\016")
						}, 
						Callback = function(action)
							if action ~= nil then
								_oYs.Active = false
								_CIrS.Active = true
								_CIrS.Visible = true
							end
						end
					}
				end
			end
		}
	elseif input ~= 5 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\040\005\027\056\046\005\048\048\023\116\027\114\115\032\023\037\088\023\056\006\048\041\056\031\076\037\012\040"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_st_)
					end)
				end
			end
		}
	end
end
function _IvoGy:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 3 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\116\005\048\048\023\116\027\114\117\005\124\056\025\037\041\056\116\005\040\027\012\040\124\023\056\027\005\056\027\049\023\056\040\023\042\027\056\003\005\040\023\114\031\088\056\041\005\124\056\032\005\005\105\056\124\067\056\027\049\023\056\027\048\037\012\032\056\123\048\005\025\056\027\049\023\056\076\037\027\023\120\056\027\037\105\023\056\027\049\023\056\118\023\048\041\056\123\012\048\088\027\056\032\023\123\027\056\049\037\040\044\056\027\048\037\012\032\056\027\049\023\040\056\123\005\032\032\005\057\056\027\049\023\088\023\056\057\037\041\067\005\012\040\027\088\056\027\005\056\027\049\023\056\040\023\042\027\056\110\005\040\023\114\098\060\112\038\001\037\041\067\005\012\040\027\056\059\056\122\056\092\016\034\056\059\050\114\050\091\004\056\001\034\034\026\056\016\100\114\028\077\050\098\060\112\038\001\037\041\067\005\012\040\027\056\091\056\122\056\092\016\034\056\059\050\114\100\050\016\056\001\034\034\026\056\016\100\114\059\100\028\098\060\112\038\001\037\041\067\005\012\040\027\056\028\056\122\056\092\016\034\056\059\050\114\050\034\028\056\001\034\034\026\056\016\100\114\059\016\034"), 
			Media = _LA3, 
			Buttons = {
				_jkD("\046\032\012\116\105\056\123\005\048\056\003\005\040\023\056\077")
			}, 
			Callback = function(action)
				if action ~= nil then
					_CIrS.Active = false
					_11Bij.Active = true
					_11Bij.Visible = true
				end
			end
		}
	elseif input ~= 3 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\040\005\027\056\046\005\048\048\023\116\027\114\115\032\023\037\088\023\056\027\048\041\056\037\076\037\012\040\114"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_IvoGy)
					end)
				end
			end
		}
	end
end
function _uGS4:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 55145 then
		_Urwigo.MessageBox{
			Text = _jkD("\001\005\005\044\041\056\001\005\005\044\067\023\116\105\023\048\056\035\037\041\088\056\117\023\067\007\056\117\005\124\056\025\037\041\056\116\005\040\027\012\040\124\023\056\027\005\056\027\049\023\056\040\023\042\027\056\110\005\040\023\056\030\041\056\123\005\032\032\005\057\012\040\076\056\027\049\023\056\027\048\037\012\032\114"), 
			Media = _nJT_e, 
			Callback = function(action)
				if action ~= nil then
					_11Bij.Active = false
					_fv99l.Active = true
					_fv99l.Visible = true
				end
			end
		}
	elseif input ~= _jkD("\059\034\056\115\012\023\116\023\088\104") then
		_Urwigo.MessageBox{
			Text = _jkD("\001\005\005\044\041\056\001\005\005\044\067\023\116\105\023\048\056\088\037\041\088\056\006\048\041\056\031\076\037\012\040\114"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_uGS4)
					end)
				end
			end
		}
	end
end
function _M6yx:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 6 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\116\005\048\048\023\116\027\114\092\005\057\056\046\048\005\088\088\056\030\037\116\105\056\005\118\023\048\056\027\049\023\056\088\027\048\023\037\025\056\037\040\044\056\060\037\116\105\027\048\037\116\105\056\088\032\012\076\049\027\032\041\056\027\005\056\027\049\023\056\088\067\032\012\027\056\012\040\056\027\049\023\056\027\048\037\012\032\056\027\049\012\088\056\027\012\025\023\056\027\037\105\012\040\076\056\027\049\023\056\032\023\123\027\056\049\037\040\044\056\027\048\037\012\032\056\049\023\037\044\012\040\076\056\124\067\056\027\049\023\040\056\027\037\105\012\040\076\056\027\049\023\056\123\012\048\088\027\056\032\023\123\027\056\076\005\012\040\076\056\124\067\056\037\076\037\012\040\114\022\005\032\032\005\057\056\027\049\023\056\027\048\037\012\032\056\027\005\056\027\049\023\056\040\023\042\027\056\003\005\040\023\114"), 
			Media = _Yx9e, 
			Buttons = {
				_jkD("\046\032\012\116\105\056\027\005\056\003\005\040\023\056\050")
			}, 
			Callback = function(action)
				if action ~= nil then
					_fSju2.Active = false
					_rjG.Active = true
					_rjG.Visible = true
				end
			end
		}
	elseif input ~= 6 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\040\005\027\056\046\005\048\048\023\116\027\114\115\032\023\037\088\023\056\006\048\041\056\031\076\037\012\040\114"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_M6yx)
					end)
				end
			end
		}
	end
end
function _tz2KQ:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 20 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\046\005\048\048\023\116\027\114\036\123\056\041\005\124\056\049\037\118\023\056\040\005\027\056\088\023\023\040\056\027\049\012\088\056\116\032\124\023\056\030\023\123\005\048\023\056\027\049\023\040\056\012\027\088\056\123\005\048\056\027\049\023\056\059\088\027\056\088\027\037\076\023\056\005\123\056\037\056\025\124\032\027\012\056\116\037\116\049\023\056\122\056\035\027\114\017\005\049\012\044\088\056\060\048\005\056\108\017\046\059\017\091\077\003\066\056\057\049\012\116\049\056\041\005\124\056\025\037\041\056\057\037\040\027\056\027\005\056\116\005\025\023\056\030\037\116\105\056\037\040\044\056\027\048\041\114"), 
			Media = _HOc, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _jkD("\117\005\124\056\025\037\041\056\040\005\057\056\115\048\005\116\023\023\044\056\027\005\056\027\049\023\056\022\012\040\037\032\056\003\005\040\023\120\056\006\049\023\056\116\037\116\049\023\056\017\003\007\056\022\005\032\032\005\057\056\027\049\023\056\067\037\027\049\056\012\040\056\027\049\023\056\012\025\037\076\023\114\046\048\005\088\088\056\035\027\048\037\012\076\049\027\056\005\118\023\048\056\027\049\023\040\056\116\005\040\027\012\040\124\023\056\124\067\056\027\049\023\056\027\048\037\116\105\056\027\005\056\027\049\023\056\046\037\116\049\023\056\003\005\040\023\114"), 
						Media = _Ucmz, 
						Buttons = {
							_jkD("\046\032\012\116\105\056\123\005\048\056\046\037\116\049\023\056\003\005\040\023")
						}, 
						Callback = function(action)
							if action ~= nil then
								_rjG.Active = false
								_rWWrY.Visible = true
								_rWWrY.Active = true
							end
						end
					}
				end
			end
		}
	elseif input ~= 20 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\040\005\027\056\116\005\048\048\023\116\027\114\115\032\023\037\088\023\056\027\048\041\056\037\076\037\012\040"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_tz2KQ)
					end)
				end
			end
		}
	end
end
function _FNJ5:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 12454 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\056\012\088\056\027\049\023\056\046\005\048\048\023\116\027\056\046\005\044\023\114\006\049\023\056\046\005\122\005\048\044\088\056\123\005\048\056\027\049\023\056\035\012\025\005\040\056\035\037\041\088\056\060\005\040\124\088\056\037\048\023\056\092\016\034\056\059\050\114\028\077\091\056\001\034\034\026\056\016\100\114\034\004\050\114\056\102\040\030\088\067\053\093\012\040\027\056\122\056\060\037\088\023\056\005\123\056\078\037\048\076\023\056\115\005\088\027"), 
			Media = _iSJt, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _jkD("\006\049\037\040\105\088\056\123\005\048\056\006\037\105\012\040\076\056\067\037\048\027\056\012\040\056\027\049\012\088\056\001\049\023\048\012\076\005\056\037\040\044\056\115\032\037\041\012\040\076\056\035\012\025\005\040\056\035\037\041\088\114\036\056\049\005\067\023\056\041\005\124\056\049\037\044\056\037\040\056\023\040\111\005\041\037\030\032\023\056\108\056\037\040\044\056\012\056\076\124\023\088\088\120\056\088\032\012\076\049\027\032\041\056\025\124\044\044\041\056\037\040\044\056\057\023\027\056\066\056\001\037\032\105\056\012\040\056\078\037\044\005\116\105\056\001\005\005\044\088\114\115\032\023\037\088\023\056\048\023\049\012\044\023\056\027\049\023\056\116\037\116\049\023\056\006\048\023\023\056\006\048\124\040\105\056\037\088\056\041\005\124\056\123\005\124\040\044\056\012\027\056\025\037\105\012\040\076\056\012\027\056\032\005\005\105\056\037\088\056\040\037\027\124\048\037\032\056\037\088\056\067\005\088\088\012\030\032\023\114\031\123\027\023\048\056\123\012\040\044\012\040\076\056\027\049\023\056\030\005\040\124\088\056\041\005\124\056\025\037\041\056\116\005\040\027\012\040\124\023\056\030\037\116\105\056\027\005\056\027\049\023\056\116\037\048\067\037\048\105\056\030\041\056\123\005\032\032\005\057\012\040\076\056\102\040\030\088\067\053\027\049\012\088\056\006\048\037\012\032\056\037\040\044\056\027\124\048\040\012\040\076\056\048\012\076\049\027\056\037\027\056\027\049\023\056\027\005\067\114\093\037\067\067\041\056\093\124\040\027\012\040\076\056\037\040\044\056\030\023\088\027\056\057\012\088\049\023\088\056\125\005\124\040\027\037\012\040\030\012\105\023\048\056\028\077"), 
						Buttons = {
							_jkD("\046\032\012\116\105\056\123\005\048\056\116\005\025\067\032\023\027\012\005\040\056\116\005\044\023")
						}, 
						Callback = function(action)
							if action ~= nil then
								_LpBl7.Complete = true
								_Urwigo.MessageBox{
									Text = (_jkD("\117\005\124\048\056\046\005\025\067\032\023\027\012\027\012\005\040\056\046\005\044\023\056\012\088")..string.sub(Player.CompletionCode, 1, 15)).._jkD("\115\032\023\037\088\023\056\124\088\023\056\027\049\012\088\056\027\005\056\074\040\032\005\116\105\056\027\049\023\056\001\049\023\048\012\076\005"), 
									Buttons = {
										_jkD("\046\032\012\116\105\056\027\005\056\035\037\118\023\056\037\040\044\056\046\005\025\067\032\023\027\023\056\046\037\048\027\048\012\044\076\023")
									}, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "SaveClose"
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif input ~= 12454 then
		_Urwigo.MessageBox{
			Text = _jkD("\006\049\037\027\088\056\040\005\027\056\027\049\023\056\116\005\048\048\023\116\027\056\116\005\044\023\114\115\032\023\037\088\023\056\006\048\041\056\031\076\037\012\040"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_FNJ5)
					end)
				end
			end
		}
	end
end
function _wOq8:OnStart()
	_fSju2.Active = true
	_fSju2.Visible = true
	_fv99l.Active = false
	_fv99l.Visible = false
	_Urwigo.MessageBox{
		Text = _jkD("\006\049\023\056\046\032\005\116\105\056\012\088\056\006\012\116\105\012\040\076\114\114\114\114\114\114\117\005\124\056\093\037\118\023\056\016\034\056\035\023\116\005\040\044\088\056\027\005\056\046\048\005\088\088\056\027\049\023\056\088\027\048\023\037\025\056\027\005\056\027\049\023\056\040\023\042\027\056\003\005\040\023\007\056\068\124\012\116\105\032\041\056\092\005\057\007"), 
		Media = _JDuJM, 
		Buttons = {
			_jkD("\117\005\124\048\056\012\040\056\027\049\023\056\031\048\025\041\056\092\005\057")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _fSju2)
			end
		end
	}
end
function _wOq8:OnStop()
	_fSju2.Active = true
	_fSju2.Visible = true
	_fv99l.Active = false
	_fv99l.Visible = false
	_LpBl7:RequestSync()
	_Urwigo.MessageBox{
		Text = _jkD("\117\005\124\056\125\037\044\023\056\012\027\056\005\040\056\006\012\025\023\007\056\001\023\032\116\005\025\023\056\027\005\056\003\005\040\023\056\100\056\122\056\117\005\124\048\056\012\040\056\027\049\023\056\031\048\025\041\056\092\005\057\114"), 
		Media = _FJZs, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = "", 
					Media = _tPsm5, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_M6yx)
							end)
						end
					end
				}
			end
		end
	}
end
function _wOq8:OnTick()
	_fSju2.Active = false
	_fSju2.Visible = false
	_Urwigo.MessageBox{
		Text = _jkD("\006\012\025\023\048\056\049\037\088\056\048\124\040\056\005\124\027\114\115\032\023\037\088\023\056\006\048\041\056\031\076\037\012\040\114"), 
		Buttons = {
			_jkD("\060\037\116\105\056\027\005\056\031\044\118\023\040\027\124\048\023\056\003\005\040\023")
		}, 
		Callback = function(action)
			if action ~= nil then
				_fv99l.Visible = true
				_fv99l.Active = true
			end
		end
	}
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _LpBl7
