require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _CyO(str)
	local res = ""
    local dtable = "\089\112\061\115\037\094\105\044\038\101\045\051\013\058\041\123\010\003\070\073\065\063\071\081\011\068\119\012\088\006\078\048\111\072\057\019\109\066\091\092\097\098\055\117\090\056\034\126\039\017\103\067\064\020\004\000\099\076\050\060\008\079\032\093\052\001\049\121\107\096\082\047\023\043\113\042\104\102\009\007\024\069\083\059\030\110\031\095\118\054\108\026\014\021\035\087\018\029\062\086\100\074\027\124\122\036\120\015\053\005\002\116\114\028\016\022\040\106\075\025\033\084\077\085\125\080\046"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_XA1jk = Wherigo.ZCartridge()

-- Media --
_xqR0F = Wherigo.ZMedia(_XA1jk)
_xqR0F.Id = "0ce8be2a-4f27-409e-901c-b96aff93afe0"
_xqR0F.Name = _CyO("\026\113\044\007\089\010\086\069\033\086\007\086\051\007\086")
_xqR0F.Description = ""
_xqR0F.AltText = ""
_xqR0F.Resources = {
	{
		Type = "jpg", 
		Filename = "missdruif.jpg", 
		Directives = {}
	}
}
_0cPB = Wherigo.ZMedia(_XA1jk)
_0cPB.Id = "0373eea4-656b-4dd1-9721-149b8f507a2c"
_0cPB.Name = _CyO("\026\041\086\077\007\010\044\107")
_0cPB.Description = ""
_0cPB.AltText = ""
_0cPB.Resources = {
	{
		Type = "jpg", 
		Filename = "gebroerders.jpg", 
		Directives = {}
	}
}
_shmaY = Wherigo.ZMedia(_XA1jk)
_shmaY.Id = "c9d98f76-99f3-4ae2-a28b-8610728f3483"
_shmaY.Name = _CyO("\102\044\004\112\044\004")
_shmaY.Description = ""
_shmaY.AltText = ""
_shmaY.Resources = {
	{
		Type = "jpg", 
		Filename = "justus.jpg", 
		Directives = {}
	}
}
_Iin = Wherigo.ZMedia(_XA1jk)
_Iin.Id = "23f43501-4c47-4650-8c5e-f616fe6b4cf9"
_Iin.Name = _CyO("\029\023\122")
_Iin.Description = ""
_Iin.AltText = ""
_Iin.Resources = {
	{
		Type = "png", 
		Filename = "logonakedsmall.png", 
		Directives = {}
	}
}
_xG36 = Wherigo.ZMedia(_XA1jk)
_xG36.Id = "6b69c18c-d8eb-4387-acfe-7bf966d1bb55"
_xG36.Name = _CyO("\062\089\010\113\007\118\004\010")
_xG36.Description = ""
_xG36.AltText = ""
_xG36.Resources = {
	{
		Type = "jpg", 
		Filename = "OverijseLOGO.jpg", 
		Directives = {}
	}
}
_Oxrf4 = Wherigo.ZMedia(_XA1jk)
_Oxrf4.Id = "3da9044d-840b-4a70-8ac5-08a7210fd76b"
_Oxrf4.Name = _CyO("\026\113\044\007\078\037\041\086")
_Oxrf4.Description = ""
_Oxrf4.AltText = ""
_Oxrf4.Resources = {
	{
		Type = "jpg", 
		Filename = "druifgoed.jpg", 
		Directives = {}
	}
}
_gPWg0 = Wherigo.ZMedia(_XA1jk)
_gPWg0.Id = "5fa7761a-f33e-4bf9-b0b1-14ffafc1c6f0"
_gPWg0.Name = _CyO("\078\033\044\112")
_gPWg0.Description = ""
_gPWg0.AltText = ""
_gPWg0.Resources = {
	{
		Type = "jpg", 
		Filename = "druifslecht.jpg", 
		Directives = {}
	}
}
_VPhe = Wherigo.ZMedia(_XA1jk)
_VPhe.Id = "8b66e1de-a877-4cf0-aa2d-3e1c160f9df7"
_VPhe.Name = _CyO("\069\091\010\007\086")
_VPhe.Description = ""
_VPhe.AltText = ""
_VPhe.Resources = {
	{
		Type = "jpg", 
		Filename = "druifkleincopy.jpg", 
		Directives = {}
	}
}
_nzkrC = Wherigo.ZMedia(_XA1jk)
_nzkrC.Id = "9fb8c7d3-7d29-4df2-ac06-95fd2b1ee8d3"
_nzkrC.Name = _CyO("\051\113\033\033\112")
_nzkrC.Description = ""
_nzkrC.AltText = ""
_nzkrC.Resources = {
	{
		Type = "jpg", 
		Filename = "druifgrootcopy.jpg", 
		Directives = {}
	}
}
_0zrb9 = Wherigo.ZMedia(_XA1jk)
_0zrb9.Id = "7016e525-961b-4476-a6ef-18ed58926154"
_0zrb9.Name = _CyO("\112\113\033\004")
_0zrb9.Description = ""
_0zrb9.AltText = ""
_0zrb9.Resources = {
	{
		Type = "jpg", 
		Filename = "druiventros.jpg", 
		Directives = {}
	}
}
__VZ = Wherigo.ZMedia(_XA1jk)
__VZ.Id = "87da71d3-2a58-4745-a772-0d459f7a324f"
__VZ.Name = _CyO("\083\010\113\113\010")
__VZ.Description = ""
__VZ.AltText = ""
__VZ.Resources = {
	{
		Type = "jpg", 
		Filename = "serre.jpg", 
		Directives = {}
	}
}
_L3M = Wherigo.ZMedia(_XA1jk)
_L3M.Id = "1d51420d-fe91-490c-bd5a-01a22640d733"
_L3M.Name = _CyO("\096\041\112\010\113")
_L3M.Description = ""
_L3M.AltText = ""
_L3M.Resources = {
	{
		Type = "jpg", 
		Filename = "water.jpg", 
		Directives = {}
	}
}
_JJ0lD = Wherigo.ZMedia(_XA1jk)
_JJ0lD.Id = "f855d419-aa54-4275-ace1-91f6d815db84"
_JJ0lD.Name = _CyO("\051\007\010\112\010\113")
_JJ0lD.Description = ""
_JJ0lD.AltText = ""
_JJ0lD.Resources = {
	{
		Type = "jpg", 
		Filename = "gieter.jpg", 
		Directives = {}
	}
}
_61QY = Wherigo.ZMedia(_XA1jk)
_61QY.Id = "395507dd-ddf9-49cc-8f09-04008c60dfea"
_61QY.Name = _CyO("\113\010\051\010\086\112\033\086")
_61QY.Description = ""
_61QY.AltText = ""
_61QY.Resources = {
	{
		Type = "jpg", 
		Filename = "regenton.jpg", 
		Directives = {}
	}
}
_gvMs = Wherigo.ZMedia(_XA1jk)
_gvMs.Id = "eb5b85ac-94f2-484d-b4ae-e4e1c74f2223"
_gvMs.Name = _CyO("\042\010\113\010\051\010\086\007\086\051")
_gvMs.Description = ""
_gvMs.AltText = ""
_gvMs.Resources = {
	{
		Type = "jpg", 
		Filename = "beregening.jpg", 
		Directives = {}
	}
}
_VOmG = Wherigo.ZMedia(_XA1jk)
_VOmG.Id = "3996e913-4724-4687-a94c-c904308e6006"
_VOmG.Name = _CyO("\004\112\033\002\089\010\113\078")
_VOmG.Description = ""
_VOmG.AltText = ""
_VOmG.Resources = {
	{
		Type = "jpg", 
		Filename = "mastik.jpg", 
		Directives = {}
	}
}
_RMU = Wherigo.ZMedia(_XA1jk)
_RMU.Id = "9c676807-43f4-49e4-947b-6bd483917da5"
_RMU.Name = _CyO("\037\010\004\112")
_RMU.Description = ""
_RMU.AltText = ""
_RMU.Resources = {
	{
		Type = "jpg", 
		Filename = "mest.jpg", 
		Directives = {}
	}
}
_yWw = Wherigo.ZMedia(_XA1jk)
_yWw.Id = "626b9c28-0be8-4e35-99d5-e77a4a5a2d45"
_yWw.Name = _CyO("\051\091\041\004")
_yWw.Description = ""
_yWw.AltText = ""
_yWw.Resources = {
	{
		Type = "jpg", 
		Filename = "glas.jpg", 
		Directives = {}
	}
}
_rkY = Wherigo.ZMedia(_XA1jk)
_rkY.Id = "e5a81379-c1e8-4248-a3b8-e7886efb0710"
_rkY.Name = _CyO("\034\010\086\113\007")
_rkY.Description = ""
_rkY.AltText = ""
_rkY.Resources = {
	{
		Type = "jpg", 
		Filename = "Henri.jpg", 
		Directives = {}
	}
}
_tmPA = Wherigo.ZMedia(_XA1jk)
_tmPA.Id = "76d14ab4-6f9c-428d-9d9e-1cac7e49ef9c"
_tmPA.Name = _CyO("\126\077\007\091\007\002")
_tmPA.Description = ""
_tmPA.AltText = ""
_tmPA.Resources = {
	{
		Type = "jpg", 
		Filename = "Philip.jpg", 
		Directives = {}
	}
}
_Ya8jT = Wherigo.ZMedia(_XA1jk)
_Ya8jT.Id = "bf852adb-3d2d-4b9b-813a-85120af03f9d"
_Ya8jT.Name = _CyO("\100\007\057\112\033\113")
_Ya8jT.Description = ""
_Ya8jT.AltText = ""
_Ya8jT.Resources = {
	{
		Type = "jpg", 
		Filename = "Victor.jpg", 
		Directives = {}
	}
}
_I36y = Wherigo.ZMedia(_XA1jk)
_I36y.Id = "f75f80c1-8073-498e-a63b-255c81b8f9cc"
_I36y.Name = _CyO("\051\010\091\044\007\101")
_I36y.Description = ""
_I36y.AltText = ""
_I36y.Resources = {
	{
		Type = "fdl", 
		Filename = "geluid.fdl", 
		Directives = {}
	}, 
	{
		Type = "mp3", 
		Filename = "Calling_-Glen_Cav-8168_hifi.mp3", 
		Directives = {}
	}
}
_wt9Q = Wherigo.ZMedia(_XA1jk)
_wt9Q.Id = "86aa54f3-0347-4e87-83da-1974ee3a0887"
_wt9Q.Name = _CyO("\058\033\051\033\063\026\071\124\121\019")
_wt9Q.Description = ""
_wt9Q.AltText = ""
_wt9Q.Resources = {
	{
		Type = "jpg", 
		Filename = "logo_Druifbaseline.jpg", 
		Directives = {}
	}
}
_E38 = Wherigo.ZMedia(_XA1jk)
_E38.Id = "33a35953-8989-4752-a3f1-a228858462b2"
_E38.Name = _CyO("\020\057\033\086\063\026\113\044\007\078")
_E38.Description = ""
_E38.AltText = ""
_E38.Resources = {
	{
		Type = "jpg", 
		Filename = "icoon_Druif.jpg", 
		Directives = {}
	}
}
_beP = Wherigo.ZMedia(_XA1jk)
_beP.Id = "cbd44f62-cfc4-47b9-a796-30e4ccfd271b"
_beP.Name = _CyO("\091\041\112\007\118\086\004\010\063\057\007\118\078\010\113\004")
_beP.Description = ""
_beP.AltText = ""
_beP.Resources = {
	{
		Type = "jpg", 
		Filename = "latijnsecijfers.jpg", 
		Directives = {}
	}
}
_QyNQ = Wherigo.ZMedia(_XA1jk)
_QyNQ.Id = "d761b8d6-ff1d-4962-8d69-d5caf2947ec9"
_QyNQ.Name = _CyO("\071\033\068\041\091")
_QyNQ.Description = ""
_QyNQ.AltText = ""
_QyNQ.Resources = {
	{
		Type = "jpg", 
		Filename = "Royal.jpg", 
		Directives = {}
	}
}
_cAOc = Wherigo.ZMedia(_XA1jk)
_cAOc.Id = "d3e5a52b-6b31-444e-9a06-d9565cd64e53"
_cAOc.Name = _CyO("\052\041\086\033\086\063\034\041\091\091")
_cAOc.Description = ""
_cAOc.AltText = ""
_cAOc.Resources = {
	{
		Type = "jpg", 
		Filename = "canonhall.jpg", 
		Directives = {}
	}
}
_1lKi0 = Wherigo.ZMedia(_XA1jk)
_1lKi0.Id = "22444a19-0cf9-4c6f-9538-26a4a1792bdb"
_1lKi0.Name = _CyO("\058\010\033\002\033\091\101\063\020\020\020")
_1lKi0.Description = ""
_1lKi0.AltText = ""
_1lKi0.Resources = {
	{
		Type = "jpg", 
		Filename = "leopold.jpg", 
		Directives = {}
	}
}
_lsE = Wherigo.ZMedia(_XA1jk)
_lsE.Id = "5be9ca5d-7d2f-493b-b257-0e774c341643"
_lsE.Name = _CyO("\004\057\077\041\041\113")
_lsE.Description = ""
_lsE.AltText = ""
_lsE.Resources = {
	{
		Type = "jpg", 
		Filename = "schaar.jpg", 
		Directives = {}
	}
}
_5X0n = Wherigo.ZMedia(_XA1jk)
_5X0n.Id = "ccec1e7d-a058-4973-b816-d4dc9d39e0b1"
_5X0n.Name = _CyO("\007\057\033\033\086\063\004\057\077\041\041\113")
_5X0n.Description = ""
_5X0n.AltText = ""
_5X0n.Resources = {
	{
		Type = "jpg", 
		Filename = "icoon_schaar.jpg", 
		Directives = {}
	}
}
_AZu = Wherigo.ZMedia(_XA1jk)
_AZu.Id = "ccc4b497-3cf5-4a12-a7a4-9295f20e0cb3"
_AZu.Name = _CyO("\057\033\091\091\041\051\010")
_AZu.Description = ""
_AZu.AltText = ""
_AZu.Resources = {
	{
		Type = "jpg", 
		Filename = "collage.jpg", 
		Directives = {}
	}
}
_l8Uwy = Wherigo.ZMedia(_XA1jk)
_l8Uwy.Id = "7009f291-924f-47b3-bf3f-133818e6af52"
_l8Uwy.Name = _CyO("\077\033\042\042\068\112\010\091\010\113")
_l8Uwy.Description = _CyO("\102\010\063\042\010\077\041\041\091\101\010\063\067\063\004\112\010\113\063\010\086\063\101\010\063\010\113\069\010\086\086\007\086\051\063\041\091\004\063\077\033\042\042\068\112\010\091\010\113\127")
_l8Uwy.AltText = ""
_l8Uwy.Resources = {
	{
		Type = "jpg", 
		Filename = "eenster.jpg", 
		Directives = {}
	}
}
_u23q = Wherigo.ZMedia(_XA1jk)
_u23q.Id = "1e93a5ed-8ed1-47d0-a1cd-60949078750f"
_u23q.Name = _CyO("\069\027\041\091\007\112\010\007\112\004\112\010\091\010\113")
_u23q.Description = _CyO("\102\010\063\042\010\077\041\041\091\101\010\063\065\063\004\112\010\113\113\010\086\063\010\086\063\101\010\063\010\113\069\010\086\086\007\086\051\063\041\091\004\063\044\007\112\105\033\086\101\010\113\091\007\118\069\010\063\112\033\002\112\010\091\010\113\127")
_u23q.AltText = ""
_u23q.Resources = {
	{
		Type = "jpg", 
		Filename = "tweesterren.jpg", 
		Directives = {}
	}
}
_9YuHi = Wherigo.ZMedia(_XA1jk)
_9YuHi.Id = "b29f6dd2-f3e2-4f50-895a-e370258da2e5"
_9YuHi.Name = _CyO("\122\033\002\112\010\091\010\113")
_9YuHi.Description = _CyO("\102\010\063\042\010\077\041\041\091\101\010\063\012\063\004\112\010\113\113\010\086\063\010\086\063\101\010\063\010\113\069\010\086\086\007\086\051\063\041\091\004\063\122\033\002\004\112\010\091\010\113\127")
_9YuHi.AltText = ""
_9YuHi.Resources = {
	{
		Type = "jpg", 
		Filename = "driesterren.jpg", 
		Directives = {}
	}
}
_Fv5Z = Wherigo.ZMedia(_XA1jk)
_Fv5Z.Id = "7efbe919-0be7-4e1e-a6d3-c403d8567a8e"
_Fv5Z.Name = _CyO("\124\007\112\105\033\086\101\010\113\091\007\118\069\010\063\112\033\002\112\010\091\010\113")
_Fv5Z.Description = ""
_Fv5Z.AltText = ""
_Fv5Z.Resources = {
	{
		Type = "jpg", 
		Filename = "viersterren.jpg", 
		Directives = {}
	}
}
_UKr = Wherigo.ZMedia(_XA1jk)
_UKr.Id = "5cea5d20-f86b-4e99-b203-6cc8f8a8d661"
_UKr.Name = _CyO("\042\010\051\007\118\086")
_UKr.Description = ""
_UKr.AltText = ""
_UKr.Resources = {
	{
		Type = "jpg", 
		Filename = "begijn.jpg", 
		Directives = {}
	}
}
_5AzJ = Wherigo.ZMedia(_XA1jk)
_5AzJ.Id = "bbccd985-94ce-460c-80ae-bb55e2db02ab"
_5AzJ.Name = _CyO("\091\010\078\078\010")
_5AzJ.Description = ""
_5AzJ.AltText = ""
_5AzJ.Resources = {
	{
		Type = "jpg", 
		Filename = "leffevieillecuvee1-2.jpg", 
		Directives = {}
	}
}
_nf7 = Wherigo.ZMedia(_XA1jk)
_nf7.Id = "e3fe5f30-46fb-4269-a9d3-251a3ae4e2a2"
_nf7.Name = _CyO("\089\033\091\091\010\063\004\010\113\113\010")
_nf7.Description = ""
_nf7.AltText = ""
_nf7.Resources = {
	{
		Type = "jpg", 
		Filename = "volleserre.jpg", 
		Directives = {}
	}
}
_ZfZmP = Wherigo.ZMedia(_XA1jk)
_ZfZmP.Id = "2e0f0e7f-3160-4c6c-be6c-5eefe1a0a948"
_ZfZmP.Name = _CyO("\105\044\007\101\010\113\078\091\041\086\069")
_ZfZmP.Description = ""
_ZfZmP.AltText = ""
_ZfZmP.Resources = {
	{
		Type = "jpg", 
		Filename = "zuiderflank.jpg", 
		Directives = {}
	}
}
_rubM = Wherigo.ZMedia(_XA1jk)
_rubM.Id = "1ac6baca-e62d-4f44-aa72-a7d103fd8eac"
_rubM.Name = _CyO("\101\010\086\063\042\091\041\086\069")
_rubM.Description = ""
_rubM.AltText = ""
_rubM.Resources = {
	{
		Type = "jpg", 
		Filename = "blank.jpg", 
		Directives = {}
	}
}
_gDCf = Wherigo.ZMedia(_XA1jk)
_gDCf.Id = "8113bb86-bcfd-45d0-946d-ae38a4e85378"
_gDCf.Name = _CyO("\069\041\002\010\091")
_gDCf.Description = ""
_gDCf.AltText = ""
_gDCf.Resources = {
	{
		Type = "jpg", 
		Filename = "begijhofkapel.jpg", 
		Directives = {}
	}
}
_6DB5 = Wherigo.ZMedia(_XA1jk)
_6DB5.Id = "cfb8d066-19fa-4e20-b82a-56b73a52aab9"
_6DB5.Name = _CyO("\042\113\033\086")
_6DB5.Description = ""
_6DB5.AltText = ""
_6DB5.Resources = {
	{
		Type = "JPG", 
		Filename = "begijnhofbron.JPG", 
		Directives = {}
	}
}
_nje = Wherigo.ZMedia(_XA1jk)
_nje.Id = "540dc451-d350-4f5d-a09a-13b2759b0d9a"
_nje.Name = _CyO("\083\033\091\077\010\007\101\010")
_nje.Description = ""
_nje.AltText = ""
_nje.Resources = {
	{
		Type = "jpg", 
		Filename = "solheide.jpg", 
		Directives = {}
	}
}
_K6Btf = Wherigo.ZMedia(_XA1jk)
_K6Btf.Id = "ba9f2592-ced0-4485-be6d-7ac888bf85cc"
_K6Btf.Name = _CyO("\119\041\113\101\041\041\086")
_K6Btf.Description = ""
_K6Btf.AltText = ""
_K6Btf.Resources = {
	{
		Type = "jpg", 
		Filename = "kardaan.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_XA1jk.Id="c946110b-9c1d-4c32-8d51-a0a9f051d474"
_XA1jk.Name="Het raadsel van Druifman"
_XA1jk.Description=[[Je doel is duidelijk: teel je eigen tafeldruiven. 
Veel succes !]]
_XA1jk.Visible=true
_XA1jk.Activity="Fiction"
_XA1jk.StartingLocationDescription=[[DRU!F]]
_XA1jk.StartingLocation = ZonePoint(50.7723884855864,4.53714604949948,0)
_XA1jk.Version="1"
_XA1jk.Company="Gemeente Overijse"
_XA1jk.Author="Xtreme Geoteam vzw"
_XA1jk.BuilderVersion="URWIGO 1.14.4469.18959"
_XA1jk.CreateDate="03/26/2012 19:49:23"
_XA1jk.PublishDate="1/1/0001 12:00:00 AM"
_XA1jk.UpdateDate="03/12/2013 21:22:39"
_XA1jk.LastPlayedDate="1/1/0001 12:00:00 AM"
_XA1jk.TargetDevice="PocketPC"
_XA1jk.TargetDeviceVersion="0"
_XA1jk.StateId="1"
_XA1jk.CountryId="2"
_XA1jk.Complete=false
_XA1jk.UseLogging=true

_XA1jk.Media=_Oxrf4

_XA1jk.Icon=_E38


-- Zones --
_33DS = Wherigo.Zone(_XA1jk)
_33DS.Id = "0d055ea3-2ada-4295-8a64-472dce5362ba"
_33DS.Name = _CyO("\026\071\124\020\019")
_33DS.Description = ""
_33DS.Visible = false
_33DS.Media = _wt9Q
_33DS.Icon = _E38
_33DS.Commands = {}
_33DS.DistanceRange = Distance(-1, "feet")
_33DS.ShowObjects = "OnEnter"
_33DS.ProximityRange = Distance(60, "meters")
_33DS.AllowSetPositionTo = false
_33DS.Active = false
_33DS.Points = {
	ZonePoint(50.7724707529688, 4.53701998567578, 0), 
	ZonePoint(50.7725275767464, 4.53739415383336, 0), 
	ZonePoint(50.7723999351793, 4.53744980967042, 0), 
	ZonePoint(50.7723405668898, 4.53707295930383, 0)
}
_33DS.OriginalPoint = ZonePoint(50.7724347079461, 4.53723422712085, 0)
_33DS.DistanceRangeUOM = "Feet"
_33DS.ProximityRangeUOM = "Meters"
_33DS.OutOfRangeName = ""
_33DS.InRangeName = ""
_QtR = Wherigo.Zone(_XA1jk)
_QtR.Id = "3a42a15f-d692-4c50-972b-0e290d2f3ca8"
_QtR.Name = _CyO("\102\044\004\112\044\004\063\058\007\002\004\007\044\004\002\091\010\007\086")
_QtR.Description = _CyO("\083\112\041\002\063\086\041\041\113\063\077\010\112\063\042\033\113\004\112\042\010\010\091\101\063\089\041\086\063\102\044\004\112\044\004\063\058\007\002\004\007\044\004")
_QtR.Visible = false
_QtR.Media = _shmaY
_QtR.Icon = _E38
_QtR.Commands = {}
_QtR.DistanceRange = Distance(-1, "feet")
_QtR.ShowObjects = "OnEnter"
_QtR.ProximityRange = Distance(60, "meters")
_QtR.AllowSetPositionTo = false
_QtR.Active = false
_QtR.Points = {
	ZonePoint(50.7730415319573, 4.53730027651784, 0), 
	ZonePoint(50.7731348235516, 4.5378514704704, 0), 
	ZonePoint(50.77292364504, 4.5379600999355, 0), 
	ZonePoint(50.7727837069468, 4.53741292929647, 0)
}
_QtR.OriginalPoint = ZonePoint(50.7729709268739, 4.53763119405505, 0)
_QtR.DistanceRangeUOM = "Feet"
_QtR.ProximityRangeUOM = "Meters"
_QtR.OutOfRangeName = ""
_QtR.InRangeName = ""
_HTS = Wherigo.Zone(_XA1jk)
_HTS.Id = "f965ce8d-3652-49c2-8fc4-7e1cc58ac9bd"
_HTS.Name = _CyO("\052\033\086\007\086\069\107\077\044\068\004")
_HTS.Description = _CyO("\042\010\112\010\113\063\051\010\069\010\086\101\063\041\091\004\063\077\010\112\063\051\010\037\010\010\086\112\010\077\044\007\004")
_HTS.Visible = false
_HTS.Media = _xG36
_HTS.Icon = _E38
_HTS.Commands = {}
_HTS.DistanceRange = Distance(-1, "feet")
_HTS.ShowObjects = "OnEnter"
_HTS.ProximityRange = Distance(60, "meters")
_HTS.AllowSetPositionTo = false
_HTS.Active = false
_HTS.Points = {
	ZonePoint(50.7731806211754, 4.53751619434354, 0), 
	ZonePoint(50.7733002036481, 4.53743170475957, 0), 
	ZonePoint(50.7733447289587, 4.53760940110681, 0), 
	ZonePoint(50.7732090326416, 4.53765902197358, 0)
}
_HTS.OriginalPoint = ZonePoint(50.773258646606, 4.53755408054587, 0)
_HTS.DistanceRangeUOM = "Feet"
_HTS.ProximityRangeUOM = "Meters"
_HTS.OutOfRangeName = ""
_HTS.InRangeName = ""
_2IA9u = Wherigo.Zone(_XA1jk)
_2IA9u.Id = "a74b7dc2-ed9f-4c3b-b2e8-918cf3e91b1b"
_2IA9u.Name = _CyO("\083\033\091\077\010\007\101\010")
_2IA9u.Description = ""
_2IA9u.Visible = false
_2IA9u.Media = _nje
_2IA9u.Commands = {}
_2IA9u.DistanceRange = Distance(-1, "feet")
_2IA9u.ShowObjects = "OnEnter"
_2IA9u.ProximityRange = Distance(60, "meters")
_2IA9u.AllowSetPositionTo = false
_2IA9u.Active = false
_2IA9u.Points = {
	ZonePoint(50.7732518618343, 4.53635479784009, 0), 
	ZonePoint(50.7732705200841, 4.53646342730519, 0), 
	ZonePoint(50.7731407602833, 4.53665118193624, 0), 
	ZonePoint(50.7730958107258, 4.53645269846913, 0)
}
_2IA9u.OriginalPoint = ZonePoint(50.7731897382319, 4.53648052638766, 0)
_2IA9u.DistanceRangeUOM = "Feet"
_2IA9u.ProximityRangeUOM = "Meters"
_2IA9u.OutOfRangeName = ""
_2IA9u.InRangeName = ""
_rVPcT = Wherigo.Zone(_XA1jk)
_rVPcT.Id = "fe2a5b5e-867d-4159-8714-49adc5cd96e6"
_rVPcT.Name = _CyO("\069\041\002\010\091")
_rVPcT.Description = ""
_rVPcT.Visible = false
_rVPcT.Commands = {}
_rVPcT.DistanceRange = Distance(-1, "feet")
_rVPcT.ShowObjects = "OnEnter"
_rVPcT.ProximityRange = Distance(60, "meters")
_rVPcT.AllowSetPositionTo = false
_rVPcT.Active = false
_rVPcT.Points = {
	ZonePoint(50.7739617181864, 4.5357982394695, 0), 
	ZonePoint(50.7739015037885, 4.53564669466016, 0), 
	ZonePoint(50.7738345045787, 4.53571911430356, 0), 
	ZonePoint(50.7738870862452, 4.53585456585881, 0)
}
_rVPcT.OriginalPoint = ZonePoint(50.7738962031997, 4.53575465357301, 0)
_rVPcT.DistanceRangeUOM = "Feet"
_rVPcT.ProximityRangeUOM = "Meters"
_rVPcT.OutOfRangeName = ""
_rVPcT.InRangeName = ""
_7VDf = Wherigo.Zone(_XA1jk)
_7VDf.Id = "a7be7bb9-c75e-4e43-bc66-f27d40862a79"
_7VDf.Name = _CyO("\004\010\113\113\010\004")
_7VDf.Description = ""
_7VDf.Visible = false
_7VDf.Media = _nje
_7VDf.Icon = _E38
_7VDf.Commands = {}
_7VDf.DistanceRange = Distance(-1, "feet")
_7VDf.ShowObjects = "OnEnter"
_7VDf.ProximityRange = Distance(60, "meters")
_7VDf.AllowSetPositionTo = false
_7VDf.Active = false
_7VDf.Points = {
	ZonePoint(50.7746957339448, 4.5345825282335, 0), 
	ZonePoint(50.774809376025, 4.53478637611863, 0), 
	ZonePoint(50.7746821647233, 4.5349607197046, 0), 
	ZonePoint(50.7745702184912, 4.53472468531129, 0)
}
_7VDf.OriginalPoint = ZonePoint(50.7746893732961, 4.53476357734201, 0)
_7VDf.DistanceRangeUOM = "Feet"
_7VDf.ProximityRangeUOM = "Meters"
_7VDf.OutOfRangeName = ""
_7VDf.InRangeName = ""
_2a88I = Wherigo.Zone(_XA1jk)
_2a88I.Id = "aa634328-76fd-4303-a8d3-e17c8a2c8891"
_2a88I.Name = _CyO("\102\044\004\112\044\004\063\058\007\002\004\007\044\004\077\044\007\004")
_2a88I.Description = _CyO("\101\010\063\041\057\041\101\010\037\007\010\063\089\033\033\113\063\037\044\105\007\010\069\008\063\027\033\033\113\101\063\010\086\063\101\041\086\004")
_2a88I.Visible = false
_2a88I.Media = _shmaY
_2a88I.Icon = _E38
_2a88I.Commands = {}
_2a88I.DistanceRange = Distance(-1, "feet")
_2a88I.ShowObjects = "OnEnter"
_2a88I.ProximityRange = Distance(60, "meters")
_2a88I.AllowSetPositionTo = false
_2a88I.Active = false
_2a88I.Points = {
	ZonePoint(50.7739290667274, 4.53741359984872, 0), 
	ZonePoint(50.7739799521092, 4.53761878883836, 0), 
	ZonePoint(50.7738586751915, 4.53767913854119, 0), 
	ZonePoint(50.7738103339548, 4.53747394955155, 0)
}
_2a88I.OriginalPoint = ZonePoint(50.7738945069957, 4.53754636919496, 0)
_2a88I.DistanceRangeUOM = "Feet"
_2a88I.ProximityRangeUOM = "Meters"
_2a88I.OutOfRangeName = ""
_2a88I.InRangeName = ""
_aVc = Wherigo.Zone(_XA1jk)
_aVc.Id = "fe05ad1d-488a-4a9f-a973-e278c36daa49"
_aVc.Name = _CyO("\089\010\004\112\007\086\051")
_aVc.Description = ""
_aVc.Visible = false
_aVc.Media = _K6Btf
_aVc.Commands = {}
_aVc.DistanceRange = Distance(-1, "feet")
_aVc.ShowObjects = "OnEnter"
_aVc.ProximityRange = Distance(60, "meters")
_aVc.AllowSetPositionTo = false
_aVc.Active = false
_aVc.Points = {
	ZonePoint(50.7734816970306, 4.53890289640424, 0), 
	ZonePoint(50.7735164690467, 4.53916843509671, 0), 
	ZonePoint(50.7733120770694, 4.53931863880155, 0), 
	ZonePoint(50.7732620390634, 4.53903432464597, 0)
}
_aVc.OriginalPoint = ZonePoint(50.7733930705525, 4.53910607373712, 0)
_aVc.DistanceRangeUOM = "Feet"
_aVc.ProximityRangeUOM = "Meters"
_aVc.OutOfRangeName = ""
_aVc.InRangeName = ""
_MXlwz = Wherigo.Zone(_XA1jk)
_MXlwz.Id = "247e73d5-cc9d-49ee-9464-81f74c786641"
_MXlwz.Name = _CyO("\038\113\033\044\027\010\113\007\118")
_MXlwz.Description = ""
_MXlwz.Visible = false
_MXlwz.Media = _5AzJ
_MXlwz.Commands = {}
_MXlwz.DistanceRange = Distance(-1, "feet")
_MXlwz.ShowObjects = "OnEnter"
_MXlwz.ProximityRange = Distance(60, "meters")
_MXlwz.AllowSetPositionTo = false
_MXlwz.Active = false
_MXlwz.Points = {
	ZonePoint(50.7726306226761, 4.5401119021177, 0), 
	ZonePoint(50.7721429547565, 4.54002741253373, 0), 
	ZonePoint(50.7722939203254, 4.54056385433671, 0), 
	ZonePoint(50.7725101903756, 4.5405973819494, 0)
}
_MXlwz.OriginalPoint = ZonePoint(50.7723944220334, 4.54032513773439, 0)
_MXlwz.DistanceRangeUOM = "Feet"
_MXlwz.ProximityRangeUOM = "Meters"
_MXlwz.OutOfRangeName = ""
_MXlwz.InRangeName = ""
_lnkk = Wherigo.Zone(_XA1jk)
_lnkk.Id = "cb51d26b-68d6-42a6-a418-31d5c3831b5b"
_lnkk.Name = _CyO("\020\102\004\010\027\010\051")
_lnkk.Description = ""
_lnkk.Visible = false
_lnkk.Commands = {}
_lnkk.DistanceRange = Distance(-1, "feet")
_lnkk.ShowObjects = "OnEnter"
_lnkk.ProximityRange = Distance(60, "meters")
_lnkk.AllowSetPositionTo = false
_lnkk.Active = false
_lnkk.Points = {
	ZonePoint(50.7720721364706, 4.53967939591405, 0), 
	ZonePoint(50.7719076001589, 4.53978400206563, 0), 
	ZonePoint(50.7720161602646, 4.54052160954473, 0), 
	ZonePoint(50.7721615309484, 4.54038943278124, 0)
}
_lnkk.OriginalPoint = ZonePoint(50.7720393569606, 4.54009361007641, 0)
_lnkk.DistanceRangeUOM = "Feet"
_lnkk.ProximityRangeUOM = "Meters"
_lnkk.OutOfRangeName = ""
_lnkk.InRangeName = ""
_hwY6m = Wherigo.Zone(_XA1jk)
_hwY6m.Id = "935f25e2-3081-4d4b-a958-f6879cfe9945"
_hwY6m.Name = _CyO("\038\010\051\007\118\086\077\033\078")
_hwY6m.Description = ""
_hwY6m.Visible = false
_hwY6m.Media = _UKr
_hwY6m.Commands = {}
_hwY6m.DistanceRange = Distance(-1, "feet")
_hwY6m.ShowObjects = "OnEnter"
_hwY6m.ProximityRange = Distance(60, "meters")
_hwY6m.AllowSetPositionTo = false
_hwY6m.Active = false
_hwY6m.Points = {
	ZonePoint(50.7704844217227, 4.53635479784009, 0), 
	ZonePoint(50.7702384568181, 4.53649159049985, 0), 
	ZonePoint(50.7703495652628, 4.53690465068814, 0), 
	ZonePoint(50.7705370071552, 4.53671555495259, 0)
}
_hwY6m.OriginalPoint = ZonePoint(50.7704023627397, 4.53661664849517, 0)
_hwY6m.DistanceRangeUOM = "Feet"
_hwY6m.ProximityRangeUOM = "Meters"
_hwY6m.OutOfRangeName = ""
_hwY6m.InRangeName = ""
_Ufh71 = Wherigo.Zone(_XA1jk)
_Ufh71.Id = "aa836b97-4f7d-42a2-ae85-af839d3ee2dd"
_Ufh71.Name = _CyO("\038\113\033\086")
_Ufh71.Description = ""
_Ufh71.Visible = false
_Ufh71.Media = _6DB5
_Ufh71.Commands = {}
_Ufh71.DistanceRange = Distance(-1, "feet")
_Ufh71.ShowObjects = "OnEnter"
_Ufh71.ProximityRange = Distance(60, "meters")
_Ufh71.AllowSetPositionTo = false
_Ufh71.Active = false
_Ufh71.Points = {
	ZonePoint(50.7698728996912, 4.53625555610654, 0), 
	ZonePoint(50.7696727326293, 4.536338704586, 0), 
	ZonePoint(50.7696829106362, 4.53669275617597, 0), 
	ZonePoint(50.7699068262269, 4.53667934513089, 0)
}
_Ufh71.OriginalPoint = ZonePoint(50.7697838422959, 4.53649159049985, 0)
_Ufh71.DistanceRangeUOM = "Feet"
_Ufh71.ProximityRangeUOM = "Meters"
_Ufh71.OutOfRangeName = ""
_Ufh71.InRangeName = ""
_GRSV = Wherigo.Zone(_XA1jk)
_GRSV.Id = "24a32317-709b-4780-8282-506f4b985670"
_GRSV.Name = _CyO("\038\010\051\007\118\086\077\033\078\069\041\002\010\091")
_GRSV.Description = ""
_GRSV.Visible = false
_GRSV.Media = _gDCf
_GRSV.Commands = {}
_GRSV.DistanceRange = Distance(-1, "feet")
_GRSV.ShowObjects = "OnEnter"
_GRSV.ProximityRange = Distance(60, "meters")
_GRSV.AllowSetPositionTo = false
_GRSV.Active = false
_GRSV.Points = {
	ZonePoint(50.7701756931526, 4.53554342961309, 0), 
	ZonePoint(50.7699585641465, 4.53558098053929, 0), 
	ZonePoint(50.7699958832662, 4.53608523583409, 0), 
	ZonePoint(50.7702333678754, 4.53604768490789, 0)
}
_GRSV.OriginalPoint = ZonePoint(50.7700908771102, 4.53581433272359, 0)
_GRSV.DistanceRangeUOM = "Feet"
_GRSV.ProximityRangeUOM = "Meters"
_GRSV.OutOfRangeName = ""
_GRSV.InRangeName = ""
_suA = Wherigo.Zone(_XA1jk)
_suA.Id = "86d4c8a3-8361-4903-8380-d9df4ddfe3c0"
_suA.Name = _CyO("\026\010\086\063\038\091\041\086\069")
_suA.Description = ""
_suA.Visible = false
_suA.Media = _rubM
_suA.Commands = {}
_suA.DistanceRange = Distance(-1, "feet")
_suA.ShowObjects = "OnEnter"
_suA.ProximityRange = Distance(60, "meters")
_suA.AllowSetPositionTo = false
_suA.Active = false
_suA.Points = {
	ZonePoint(50.7694106481901, 4.53600208735463, 0), 
	ZonePoint(50.7694513604323, 4.53633468127248, 0), 
	ZonePoint(50.7693054747335, 4.53646879172322, 0), 
	ZonePoint(50.7692647623644, 4.53607718920705, 0)
}
_suA.OriginalPoint = ZonePoint(50.7693580614301, 4.53622068738934, 0)
_suA.DistanceRangeUOM = "Feet"
_suA.ProximityRangeUOM = "Meters"
_suA.OutOfRangeName = ""
_suA.InRangeName = ""
_raQ = Wherigo.Zone(_XA1jk)
_raQ.Id = "12f5e0b1-873e-4b57-8077-cf28e2111149"
_raQ.Name = _CyO("\045\044\007\101\010\113\078\091\041\086\069")
_raQ.Description = ""
_raQ.Visible = false
_raQ.Media = _ZfZmP
_raQ.Commands = {}
_raQ.DistanceRange = Distance(-1, "feet")
_raQ.ShowObjects = "OnEnter"
_raQ.ProximityRange = Distance(60, "meters")
_raQ.AllowSetPositionTo = false
_raQ.Active = false
_raQ.Points = {
	ZonePoint(50.7664623091264, 4.53718762373921, 0), 
	ZonePoint(50.7663130211936, 4.53662972426412, 0), 
	ZonePoint(50.7659873004139, 4.53688721632955, 0), 
	ZonePoint(50.7660958742591, 4.53733782744405, 0)
}
_raQ.OriginalPoint = ZonePoint(50.7662146262482, 4.53701059794423, 0)
_raQ.DistanceRangeUOM = "Feet"
_raQ.ProximityRangeUOM = "Meters"
_raQ.OutOfRangeName = ""
_raQ.InRangeName = ""
_ERugV = Wherigo.Zone(_XA1jk)
_ERugV.Id = "df2636cc-e3f4-4851-9fdb-77a35b3152a2"
_ERugV.Name = _CyO("\023\010\042\113\033\010\101\010\113\004\063\026\041\086\077\007\010\044\107\004\112\113\041\041\112")
_ERugV.Description = ""
_ERugV.Visible = false
_ERugV.Media = _0cPB
_ERugV.Commands = {}
_ERugV.DistanceRange = Distance(-1, "feet")
_ERugV.ShowObjects = "OnEnter"
_ERugV.ProximityRange = Distance(60, "meters")
_ERugV.AllowSetPositionTo = false
_ERugV.Active = false
_ERugV.Points = {
	ZonePoint(50.7716582502124, 4.53546832776067, 0), 
	ZonePoint(50.7709017109477, 4.5360315916538, 0), 
	ZonePoint(50.7709152812665, 4.53651975369451, 0), 
	ZonePoint(50.7718244836579, 4.53581165051457, 0), 
	ZonePoint(50.7716989604987, 4.53543614125249, 0)
}
_ERugV.OriginalPoint = ZonePoint(50.7713997373166, 4.53585349297521, 0)
_ERugV.DistanceRangeUOM = "Feet"
_ERugV.ProximityRangeUOM = "Meters"
_ERugV.OutOfRangeName = ""
_ERugV.InRangeName = ""
_s6XT = Wherigo.Zone(_XA1jk)
_s6XT.Id = "ea7419ec-040e-40b4-8e6f-d423f99f6ae9"
_s6XT.Name = _CyO("\019")
_s6XT.Description = ""
_s6XT.Visible = false
_s6XT.Commands = {}
_s6XT.DistanceRange = Distance(-1, "feet")
_s6XT.ShowObjects = "OnEnter"
_s6XT.ProximityRange = Distance(60, "meters")
_s6XT.AllowSetPositionTo = false
_s6XT.Active = false
_s6XT.Points = {
	ZonePoint(50.7692206572579, 4.53682954883573, 0), 
	ZonePoint(50.7692100550627, 4.53704948997495, 0), 
	ZonePoint(50.7693406739412, 4.5370588777065, 0), 
	ZonePoint(50.7693618782701, 4.53686575865743, 0)
}
_s6XT.OriginalPoint = ZonePoint(50.769283316133, 4.53695091879365, 0)
_s6XT.DistanceRangeUOM = "Feet"
_s6XT.ProximityRangeUOM = "Meters"
_s6XT.OutOfRangeName = ""
_s6XT.InRangeName = ""
_jcvz = Wherigo.Zone(_XA1jk)
_jcvz.Id = "743501c9-d4e8-4408-8995-e7c361f2552e"
_jcvz.Name = _CyO("\021")
_jcvz.Description = ""
_jcvz.Visible = false
_jcvz.Commands = {}
_jcvz.DistanceRange = Distance(-1, "feet")
_jcvz.ShowObjects = "OnEnter"
_jcvz.ProximityRange = Distance(60, "meters")
_jcvz.AllowSetPositionTo = false
_jcvz.Active = false
_jcvz.Points = {
	ZonePoint(50.768994193844, 4.53637357330319, 0), 
	ZonePoint(50.7688550921774, 4.53647147393224, 0), 
	ZonePoint(50.7689602666464, 4.53665252304074, 0), 
	ZonePoint(50.7690476291306, 4.53650366044042, 0)
}
_jcvz.OriginalPoint = ZonePoint(50.7689642954496, 4.53650030767915, 0)
_jcvz.DistanceRangeUOM = "Feet"
_jcvz.ProximityRangeUOM = "Meters"
_jcvz.OutOfRangeName = ""
_jcvz.InRangeName = ""
_P7a = Wherigo.Zone(_XA1jk)
_P7a.Id = "463aa504-e9bb-448b-9c83-ea5af35bc8e3"
_P7a.Name = _CyO("\038")
_P7a.Description = ""
_P7a.Visible = false
_P7a.Commands = {}
_P7a.DistanceRange = Distance(-1, "feet")
_P7a.ShowObjects = "OnEnter"
_P7a.ProximityRange = Distance(60, "meters")
_P7a.AllowSetPositionTo = false
_P7a.Active = false
_P7a.Points = {
	ZonePoint(50.7695472036963, 4.53701059794423, 0), 
	ZonePoint(50.7696409263439, 4.53694555437562, 0), 
	ZonePoint(50.769596821592, 4.53677657520768, 0), 
	ZonePoint(50.7695103083038, 4.53683558380601, 0)
}
_P7a.OriginalPoint = ZonePoint(50.769573814984, 4.53689207783339, 0)
_P7a.DistanceRangeUOM = "Feet"
_P7a.ProximityRangeUOM = "Meters"
_P7a.OutOfRangeName = ""
_P7a.InRangeName = ""
_lPQRV = Wherigo.Zone(_XA1jk)
_lPQRV.Id = "53b8216b-1410-4585-b201-3d08cdae00dd"
_lPQRV.Name = _CyO("\052")
_lPQRV.Description = ""
_lPQRV.Visible = false
_lPQRV.Commands = {}
_lPQRV.DistanceRange = Distance(-1, "feet")
_lPQRV.ShowObjects = "OnEnter"
_lPQRV.ProximityRange = Distance(60, "meters")
_lPQRV.AllowSetPositionTo = false
_lPQRV.Active = false
_lPQRV.Points = {
	ZonePoint(50.7690518700237, 4.53710983967778, 0), 
	ZonePoint(50.7689110721661, 4.53694622492787, 0), 
	ZonePoint(50.7688635739982, 4.53719567036626, 0), 
	ZonePoint(50.7689835915974, 4.53735459125039, 0)
}
_lPQRV.OriginalPoint = ZonePoint(50.7689525269464, 4.53715158155558, 0)
_lPQRV.DistanceRangeUOM = "Feet"
_lPQRV.ProximityRangeUOM = "Meters"
_lPQRV.OutOfRangeName = ""
_lPQRV.InRangeName = ""
_62V = Wherigo.Zone(_XA1jk)
_62V.Id = "dea6df53-f4af-47af-a935-b0c910fac85c"
_62V.Name = _CyO("\026")
_62V.Description = ""
_62V.Visible = false
_62V.Commands = {}
_62V.DistanceRange = Distance(-1, "feet")
_62V.ShowObjects = "OnEnter"
_62V.ProximityRange = Distance(60, "meters")
_62V.AllowSetPositionTo = false
_62V.Active = false
_62V.Points = {
	ZonePoint(50.7693767212947, 4.5371849415302, 0), 
	ZonePoint(50.7695281198762, 4.53717488324639, 0), 
	ZonePoint(50.7694466954899, 4.53698981082437, 0)
}
_62V.OriginalPoint = ZonePoint(50.7694505122203, 4.53711654520032, 0)
_62V.DistanceRangeUOM = "Feet"
_62V.ProximityRangeUOM = "Meters"
_62V.OutOfRangeName = ""
_62V.InRangeName = ""
_2wi8T = Wherigo.Zone(_XA1jk)
_2wi8T.Id = "83052b1c-4a1f-4d2d-ad5f-7aff7118d697"
_2wi8T.Name = _CyO("\082")
_2wi8T.Description = ""
_2wi8T.Visible = false
_2wi8T.Commands = {}
_2wi8T.DistanceRange = Distance(-1, "feet")
_2wi8T.ShowObjects = "OnEnter"
_2wi8T.ProximityRange = Distance(60, "meters")
_2wi8T.AllowSetPositionTo = false
_2wi8T.Active = false
_2wi8T.Points = {
	ZonePoint(50.7691909711052, 4.53675847029683, 0), 
	ZonePoint(50.7691349914514, 4.53653316473958, 0), 
	ZonePoint(50.7693241345579, 4.53645403957364, 0), 
	ZonePoint(50.7693563651456, 4.53663777089116, 0)
}
_2wi8T.OriginalPoint = ZonePoint(50.769251615565, 4.5365958613753, 0)
_2wi8T.DistanceRangeUOM = "Feet"
_2wi8T.ProximityRangeUOM = "Meters"
_2wi8T.OutOfRangeName = ""
_2wi8T.InRangeName = ""
_A_w = Wherigo.Zone(_XA1jk)
_A_w.Id = "23d25cb8-bd62-4f45-833f-354dd59d8eb4"
_A_w.Name = _CyO("\023\091\041\004")
_A_w.Description = ""
_A_w.Visible = false
_A_w.Media = _yWw
_A_w.Commands = {}
_A_w.DistanceRange = Distance(-1, "feet")
_A_w.ShowObjects = "OnEnter"
_A_w.ProximityRange = Distance(60, "meters")
_A_w.AllowSetPositionTo = false
_A_w.Active = false
_A_w.Points = {
	ZonePoint(50.7750408997073, 4.53527051484582, 0), 
	ZonePoint(50.7749365869815, 4.53546765720841, 0), 
	ZonePoint(50.7748424509072, 4.53527856147286, 0), 
	ZonePoint(50.7749857751251, 4.53517529642579, 0)
}
_A_w.OriginalPoint = ZonePoint(50.7749514281803, 4.53529800748822, 0)
_A_w.DistanceRangeUOM = "Feet"
_A_w.ProximityRangeUOM = "Meters"
_A_w.OutOfRangeName = ""
_A_w.InRangeName = ""
_HRU9 = Wherigo.Zone(_XA1jk)
_HRU9.Id = "0227ba64-3c89-416a-a83a-91efff381baa"
_HRU9.Name = _CyO("\123\010\112\041\041\091")
_HRU9.Description = ""
_HRU9.Visible = false
_HRU9.Commands = {}
_HRU9.DistanceRange = Distance(-1, "feet")
_HRU9.ShowObjects = "OnEnter"
_HRU9.ProximityRange = Distance(60, "meters")
_HRU9.AllowSetPositionTo = false
_HRU9.Active = false
_HRU9.Points = {
	ZonePoint(50.774286535362, 4.53550721979138, 0), 
	ZonePoint(50.7741678034968, 4.53562791919705, 0), 
	ZonePoint(50.7742297137213, 4.5358344492912, 0), 
	ZonePoint(50.7743560781716, 4.53569765663144, 0)
}
_HRU9.OriginalPoint = ZonePoint(50.7742600326879, 4.53566681122777, 0)
_HRU9.DistanceRangeUOM = "Feet"
_HRU9.ProximityRangeUOM = "Meters"
_HRU9.OutOfRangeName = ""
_HRU9.InRangeName = ""
_M_9 = Wherigo.Zone(_XA1jk)
_M_9.Id = "862edca9-d9c0-4711-b619-a060a08d2bf7"
_M_9.Name = _CyO("\083\112\033\002\089\010\113\078")
_M_9.Description = ""
_M_9.Visible = false
_M_9.Media = _VOmG
_M_9.Commands = {}
_M_9.DistanceRange = Distance(-1, "feet")
_M_9.ShowObjects = "OnEnter"
_M_9.ProximityRange = Distance(60, "meters")
_M_9.AllowSetPositionTo = false
_M_9.Active = false
_M_9.Points = {
	ZonePoint(50.7743993303548, 4.53576739406583, 0), 
	ZonePoint(50.7742560043398, 4.53589077568051, 0), 
	ZonePoint(50.774345053099, 4.53613888001439, 0), 
	ZonePoint(50.774485834601, 4.53600745177266, 0)
}
_M_9.OriginalPoint = ZonePoint(50.7743715555986, 4.53595112538335, 0)
_M_9.DistanceRangeUOM = "Feet"
_M_9.ProximityRangeUOM = "Meters"
_M_9.OutOfRangeName = ""
_M_9.InRangeName = ""
_jJv_5 = Wherigo.Zone(_XA1jk)
_jJv_5.Id = "f40d88a0-c2b2-4813-8b39-e156371695ef"
_jJv_5.Name = _CyO("\118\010\063\010\007\051\010\086\063\004\010\113\113\010")
_jJv_5.Description = _CyO("\100\007\086\101\063\010\010\113\004\112\063\101\010\063\012\063\042\113\033\010\113\004\063\105\033\101\041\112\063\118\010\063\041\091\091\010\063\086\033\101\007\051\010\063\042\033\044\027\037\041\112\010\113\007\041\091\010\086\063\077\010\042\112\127\063\102\010\063\089\007\086\101\112\063\101\010\063\042\113\033\010\113\004\063\033\002\063\101\010\063\077\033\010\069\010\086\063\089\041\086\063\101\010\063\033\044\101\010\063\004\010\113\113\010\004\127\063\060\038\071\099\119\033\037\063\002\041\004\063\101\041\041\113\086\041\063\086\041\041\113\063\077\007\010\113\063\033\037\063\118\010\063\010\007\051\010\086\063\004\010\113\113\010\063\112\010\063\042\033\044\027\010\086\127")
_jJv_5.Visible = false
_jJv_5.Media = _Oxrf4
_jJv_5.Commands = {}
_jJv_5.DistanceRange = Distance(-1, "feet")
_jJv_5.ShowObjects = "OnEnter"
_jJv_5.ProximityRange = Distance(60, "meters")
_jJv_5.AllowSetPositionTo = false
_jJv_5.Active = false
_jJv_5.Points = {
	ZonePoint(50.7741258232296, 4.53597593581674, 0), 
	ZonePoint(50.7743005287406, 4.53640508925912, 0), 
	ZonePoint(50.7741699237114, 4.53652578866479, 0), 
	ZonePoint(50.7740155718431, 4.53609931743142, 0)
}
_jJv_5.OriginalPoint = ZonePoint(50.7741529618812, 4.53625153279302, 0)
_jJv_5.DistanceRangeUOM = "Feet"
_jJv_5.ProximityRangeUOM = "Meters"
_jJv_5.OutOfRangeName = ""
_jJv_5.InRangeName = ""
_ZbNvM = Wherigo.Zone(_XA1jk)
_ZbNvM.Id = "7203e050-1324-4b2c-8dae-aba163c021ed"
_ZbNvM.Name = _CyO("\027\041\112\010\113\113\010\004\010\113\089\033\007\113")
_ZbNvM.Description = ""
_ZbNvM.Visible = false
_ZbNvM.Media = _61QY
_ZbNvM.Commands = {}
_ZbNvM.DistanceRange = Distance(-1, "feet")
_ZbNvM.ShowObjects = "OnEnter"
_ZbNvM.ProximityRange = Distance(60, "meters")
_ZbNvM.AllowSetPositionTo = false
_ZbNvM.Active = false
_ZbNvM.Points = {
	ZonePoint(50.770340447595, 4.53643962270019, 0), 
	ZonePoint(50.7703955776521, 4.5368292135596, 0), 
	ZonePoint(50.7701532169545, 4.53699785745141, 0), 
	ZonePoint(50.7700743381365, 4.53663441812989, 0)
}
_ZbNvM.OriginalPoint = ZonePoint(50.7702408950845, 4.53672527796027, 0)
_ZbNvM.DistanceRangeUOM = "Feet"
_ZbNvM.ProximityRangeUOM = "Meters"
_ZbNvM.OutOfRangeName = ""
_ZbNvM.InRangeName = ""
_Ckd4 = Wherigo.Zone(_XA1jk)
_Ckd4.Id = "1ce585b2-e8e9-4da1-94c4-24d8e23ba78f"
_Ckd4.Name = _CyO("\038\010\051\007\118\086\112\118\010\004\042\041\101")
_Ckd4.Description = ""
_Ckd4.Visible = true
_Ckd4.Media = _UKr
_Ckd4.Commands = {}
_Ckd4.DistanceRange = Distance(-1, "feet")
_Ckd4.ShowObjects = "OnEnter"
_Ckd4.ProximityRange = Distance(60, "meters")
_Ckd4.AllowSetPositionTo = false
_Ckd4.Active = false
_Ckd4.Points = {
	ZonePoint(50.7707926181635, 4.53755424818394, 0), 
	ZonePoint(50.7705687068128, 4.53769372305271, 0), 
	ZonePoint(50.7706908404097, 4.53837232193348, 0), 
	ZonePoint(50.770948676956, 4.53811751207706, 0)
}
_Ckd4.OriginalPoint = ZonePoint(50.7707502105855, 4.5379344513118, 0)
_Ckd4.DistanceRangeUOM = "Feet"
_Ckd4.ProximityRangeUOM = "Meters"
_Ckd4.OutOfRangeName = ""
_Ckd4.InRangeName = ""
_agN = Wherigo.Zone(_XA1jk)
_agN.Id = "02f367d7-d7d1-4176-8466-ed934f14f0ca"
_agN.Name = _CyO("\123\041\113\007\010\086\101\041\091")
_agN.Description = ""
_agN.Visible = false
_agN.Commands = {}
_agN.DistanceRange = Distance(-1, "feet")
_agN.ShowObjects = "OnEnter"
_agN.ProximityRange = Distance(60, "meters")
_agN.AllowSetPositionTo = false
_agN.Active = false
_agN.Points = {
	ZonePoint(50.7713995110215, 4.53788459300995, 0), 
	ZonePoint(50.7710755219391, 4.53810721635818, 0), 
	ZonePoint(50.7712197058393, 4.53867584466934, 0), 
	ZonePoint(50.7715589603219, 4.53854709863663, 0)
}
_agN.OriginalPoint = ZonePoint(50.7713134247804, 4.53830368816853, 0)
_agN.DistanceRangeUOM = "Feet"
_agN.ProximityRangeUOM = "Meters"
_agN.OutOfRangeName = ""
_agN.InRangeName = ""

-- Characters --

-- Items --
_2PK = Wherigo.ZItem(_XA1jk)
_2PK.Id = "9f7787b5-9c0b-464a-be71-891a03f0b6dd"
_2PK.Name = _CyO("\051\010\091\101")
_2PK.Description = ""
_2PK.Visible = true
_2PK.Commands = {}
_2PK.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_2PK.Locked = false
_2PK.Opened = false
_pE7S = Wherigo.ZItem(_XA1jk)
_pE7S.Id = "a834c975-0a46-4773-b1d8-9e79542ab4e0"
_pE7S.Name = _CyO("\051\091\041\004")
_pE7S.Description = ""
_pE7S.Visible = true
_pE7S.Media = _yWw
_pE7S.Commands = {}
_pE7S.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_pE7S.Locked = false
_pE7S.Opened = false
_jk97 = Wherigo.ZItem(_XA1jk)
_jk97.Id = "345af43a-2839-4e1f-a5b7-26862e4aec96"
_jk97.Name = _CyO("\037\010\112\041\041\091")
_jk97.Description = ""
_jk97.Visible = true
_jk97.Commands = {}
_jk97.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jk97.Locked = false
_jk97.Opened = false
_lFxp = Wherigo.ZItem(_XA1jk)
_lFxp.Id = "e06330ec-5b80-4ae7-8e0f-d89faa6d71c2"
_lFxp.Name = _CyO("\004\112\033\002\089\010\113\078")
_lFxp.Description = ""
_lFxp.Visible = true
_lFxp.Media = _VOmG
_lFxp.Icon = _VOmG
_lFxp.Commands = {}
_lFxp.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_lFxp.Locked = false
_lFxp.Opened = false
_5hX = Wherigo.ZItem(_XA1jk)
_5hX.Id = "1fa11637-b19c-4c0c-ac55-4477276e710f"
_5hX.Name = _CyO("\004\010\113\113\010")
_5hX.Description = ""
_5hX.Visible = true
_5hX.Media = __VZ
_5hX.Commands = {}
_5hX.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_5hX.Locked = false
_5hX.Opened = false
_VWeG = Wherigo.ZItem(_XA1jk)
_VWeG.Id = "8f2b92fc-0211-497d-b8b5-a514cc75fd8b"
_VWeG.Name = _CyO("\027\041\112\010\113")
_VWeG.Description = ""
_VWeG.Visible = true
_VWeG.Media = _L3M
_VWeG.Icon = _L3M
_VWeG.Commands = {}
_VWeG.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_VWeG.Locked = false
_VWeG.Opened = false
_eWM4u = Wherigo.ZItem{
	Cartridge = _XA1jk, 
	Container = _aVc
}
_eWM4u.Id = "60d2ab04-a2dc-485a-adb9-a5e4b3c74732"
_eWM4u.Name = _CyO("\037\010\004\112")
_eWM4u.Description = ""
_eWM4u.Visible = true
_eWM4u.Media = _RMU
_eWM4u.Icon = _RMU
_eWM4u.Commands = {
	_s5Ww = Wherigo.ZCommand{
		Text = _CyO("\038\010\037\010\004\112\063\101\010\063\051\113\033\086\101"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CyO("\031\033\112\077\007\086\051\063\041\089\041\007\091\041\042\091\010")
	}
}
_eWM4u.Commands._s5Ww.Custom = true
_eWM4u.Commands._s5Ww.Id = "419492dc-b046-4f44-968e-e7f5afcdc3c9"
_eWM4u.Commands._s5Ww.WorksWithAll = true
_eWM4u.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_eWM4u.Locked = false
_eWM4u.Opened = false
_s5t_ = Wherigo.ZItem(_XA1jk)
_s5t_.Id = "2bff2157-0827-497e-9083-61b2f8d97d5a"
_s5t_.Name = _CyO("\051\007\010\112\010\113")
_s5t_.Description = ""
_s5t_.Visible = true
_s5t_.Media = _JJ0lD
_s5t_.Commands = {}
_s5t_.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_s5t_.Locked = false
_s5t_.Opened = false
_CPG = Wherigo.ZItem(_XA1jk)
_CPG.Id = "8fea9f7f-f2b6-48c3-bc6e-a52c1a813ca0"
_CPG.Name = _CyO("\071\010\051\010\086\112\033\086")
_CPG.Description = ""
_CPG.Visible = true
_CPG.Media = _61QY
_CPG.Commands = {}
_CPG.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_CPG.Locked = false
_CPG.Opened = false
_3y7V = Wherigo.ZItem(_XA1jk)
_3y7V.Id = "2a9d5606-e8c5-4e8f-ab44-0a58426607aa"
_3y7V.Name = _CyO("\038\010\113\010\051\010\086\007\086\051")
_3y7V.Description = ""
_3y7V.Visible = true
_3y7V.Media = _gvMs
_3y7V.Icon = _gvMs
_3y7V.Commands = {}
_3y7V.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_3y7V.Locked = false
_3y7V.Opened = false
_Tjdb1 = Wherigo.ZItem(_XA1jk)
_Tjdb1.Id = "74e11354-fe5c-41c5-a9f7-a7c6738fe431"
_Tjdb1.Name = _CyO("\069\033\091\010\086")
_Tjdb1.Description = ""
_Tjdb1.Visible = true
_Tjdb1.Commands = {}
_Tjdb1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Tjdb1.Locked = false
_Tjdb1.Opened = false
_k0pN3 = Wherigo.ZItem(_XA1jk)
_k0pN3.Id = "eec1e552-92d5-4614-8b40-e8ada5374472"
_k0pN3.Name = _CyO("\058\010\086\007\086\051")
_k0pN3.Description = ""
_k0pN3.Visible = true
_k0pN3.Commands = {}
_k0pN3.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_k0pN3.Locked = false
_k0pN3.Opened = false
_rOss = Wherigo.ZItem{
	Cartridge = _XA1jk, 
	Container = _2a88I
}
_rOss.Id = "578eca5d-8746-4035-9c51-9ab183031823"
_rOss.Name = _CyO("\058\010\033\002\033\091\101\063\020\020\020")
_rOss.Description = _CyO("\026\010\063\042\010\004\004\010\086\063\105\007\118\086\063\042\044\007\112\010\086\051\010\027\033\033\086\063\101\007\069\063\117\112\033\112\063\065\063\057\037\063\101\007\041\037\010\112\010\113\015\127\063\045\010\063\042\010\089\041\112\112\010\086\063\004\091\010\057\077\112\004\063\010\010\086\063\033\078\063\112\027\010\010\063\002\007\112\112\010\086\063\010\086\063\101\010\063\004\037\041\041\069\063\007\004\063\105\010\010\113\063\089\010\113\078\007\118\086\101\127\063\034\010\112\063\007\004\063\010\010\086\063\105\010\010\113\063\051\010\091\007\010\078\101\010\063\101\113\044\007\078\127")
_rOss.Visible = true
_rOss.Media = _1lKi0
_rOss.Icon = _E38
_rOss.Commands = {
	_UaL = Wherigo.ZCommand{
		Text = _CyO("\020\069\063\027\007\091\063\058\010\033\002\033\091\101\063\020\020\020"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CyO("\031\033\112\077\007\086\051\063\041\089\041\007\091\041\042\091\010")
	}
}
_rOss.Commands._UaL.Custom = true
_rOss.Commands._UaL.Id = "a4f14837-cdba-45d0-86d8-b4a86b16aef0"
_rOss.Commands._UaL.WorksWithAll = true
_rOss.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_rOss.Locked = false
_rOss.Opened = false
_aZYBs = Wherigo.ZItem(_XA1jk)
_aZYBs.Id = "14f21d77-371a-4d63-b9bc-59e1b09f6866"
_aZYBs.Name = _CyO("\051\113\033\086\101")
_aZYBs.Description = ""
_aZYBs.Visible = true
_aZYBs.Commands = {}
_aZYBs.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_aZYBs.Locked = false
_aZYBs.Opened = false
_J8Z = Wherigo.ZItem{
	Cartridge = _XA1jk, 
	Container = _2a88I
}
_J8Z.Id = "4fe55fb7-a79a-405a-b76a-916e0f217d07"
_J8Z.Name = _CyO("\071\033\068\041\091")
_J8Z.Description = _CyO("\026\010\063\071\033\068\041\091\063\077\010\010\078\112\063\089\041\041\069\063\105\027\041\041\113\063\051\010\089\091\010\044\051\010\091\101\010\063\112\113\033\004\004\010\086\063\089\041\086\063\042\033\089\010\086\063\101\010\063\059\063\069\051\127\063\026\010\063\042\010\004\004\010\086\063\069\044\086\086\010\086\063\112\033\112\063\059\065\063\037\037\063\101\007\069\063\105\007\118\086\127\063\045\010\063\077\010\042\042\010\086\063\010\010\086\063\089\041\004\112\008\063\069\113\033\069\041\086\112\063\089\113\044\057\077\112\089\091\010\010\004\063\127\063\034\010\112\063\007\004\063\101\010\063\037\010\010\004\112\063\051\010\112\010\010\091\101\010\063\100\091\041\041\037\004\011\038\113\041\042\041\086\112\004\010\063\112\041\078\010\091\101\113\044\007\078\127")
_J8Z.Visible = true
_J8Z.Media = _QyNQ
_J8Z.Icon = _E38
_J8Z.Commands = {
	_127LE = Wherigo.ZCommand{
		Text = _CyO("\020\069\063\027\007\091\063\071\033\068\041\091"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CyO("\031\033\112\077\007\086\051\063\041\089\041\007\091\041\042\091\010")
	}
}
_J8Z.Commands._127LE.Custom = true
_J8Z.Commands._127LE.Id = "9e706239-fd30-458a-842b-903c88435185"
_J8Z.Commands._127LE.WorksWithAll = true
_J8Z.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_J8Z.Locked = false
_J8Z.Opened = false
_38F = Wherigo.ZItem{
	Cartridge = _XA1jk, 
	Container = _2a88I
}
_38F.Id = "84fef334-bebf-4d2c-b4da-abb025fde572"
_38F.Name = _CyO("\052\041\086\033\086\063\034\041\091\091")
_38F.Description = _CyO("\026\010\063\042\010\004\004\010\086\063\105\007\118\086\063\101\007\069\063\010\086\063\113\033\086\101\011\033\089\041\041\091\063\010\086\063\037\010\112\063\010\010\086\063\044\007\112\051\010\004\002\113\033\069\010\086\063\037\044\004\069\041\041\112\004\037\041\041\069\127\063\026\010\063\112\010\010\091\112\063\089\041\086\063\101\010\105\010\063\089\041\113\007\010\112\010\007\112\063\089\113\041\041\051\112\063\077\010\010\091\063\027\041\112\063\089\010\113\027\041\113\037\007\086\051\127")
_38F.Visible = true
_38F.Media = _cAOc
_38F.Icon = _E38
_38F.Commands = {
	_uOQh = Wherigo.ZCommand{
		Text = _CyO("\020\069\063\027\007\091\063\052\041\086\033\086\063\034\041\091\091"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CyO("\031\033\112\077\007\086\051\063\041\089\041\007\091\041\042\091\010")
	}
}
_38F.Commands._uOQh.Custom = true
_38F.Commands._uOQh.Id = "452a3ef3-5341-4121-9eae-1b9b6bee2055"
_38F.Commands._uOQh.WorksWithAll = true
_38F.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_38F.Locked = false
_38F.Opened = false
_kbor = Wherigo.ZItem(_XA1jk)
_kbor.Id = "137976f0-9287-4f07-8626-3d6b4f25d280"
_kbor.Name = _CyO("\086\007\010\044\027\010\063\101\113\044\007\089\010\086\004\033\033\113\112")
_kbor.Description = ""
_kbor.Visible = true
_kbor.Media = _wt9Q
_kbor.Icon = _E38
_kbor.Commands = {}
_kbor.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_kbor.Locked = false
_kbor.Opened = false
_O6kf = Wherigo.ZItem(_XA1jk)
_O6kf.Id = "68426fd7-d9ee-4c7a-b689-509a469cedcb"
_O6kf.Name = _CyO("\004\057\077\041\041\113")
_O6kf.Description = ""
_O6kf.Visible = true
_O6kf.Media = _lsE
_O6kf.Icon = _5X0n
_O6kf.Commands = {}
_O6kf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_O6kf.Locked = false
_O6kf.Opened = false
_vqKHU = Wherigo.ZItem(_XA1jk)
_vqKHU.Id = "02bb9ce5-1f25-4cb3-9da8-675a91ea199d"
_vqKHU.Name = _CyO("\052\033\091\091\041\051\010")
_vqKHU.Description = ""
_vqKHU.Visible = true
_vqKHU.Media = _AZu
_vqKHU.Commands = {}
_vqKHU.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_vqKHU.Locked = false
_vqKHU.Opened = false
_bB7c = Wherigo.ZItem(_XA1jk)
_bB7c.Id = "c7c6c842-6892-47c4-bf2c-7a764322a9eb"
_bB7c.Name = _CyO("\069\027\041\091\007\112\010\007\112\004\112\010\091\010\113")
_bB7c.Description = _CyO("\102\010\063\042\010\077\041\041\091\101\010\063\059\063\004\112\010\113\113\010\086\063\010\086\063\101\010\063\010\113\069\010\086\086\007\086\051\063\041\091\004\063\069\027\041\091\007\112\010\007\112\004\112\010\091\010\113\127")
_bB7c.Visible = true
_bB7c.Media = _u23q
_bB7c.Commands = {}
_bB7c.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_bB7c.Locked = false
_bB7c.Opened = false
_vcYdA = Wherigo.ZItem(_XA1jk)
_vcYdA.Id = "14670283-e0e2-4826-b90c-d9a9bb882d32"
_vcYdA.Name = _CyO("\077\033\042\042\068\112\010\091\010\113")
_vcYdA.Description = _CyO("\102\010\063\042\010\077\041\041\091\101\010\063\067\063\004\112\010\113\063\010\086\063\101\010\063\010\113\069\010\086\086\007\086\051\063\041\091\004\063\077\033\042\042\068\112\010\091\010\113\127")
_vcYdA.Visible = true
_vcYdA.Media = _l8Uwy
_vcYdA.Commands = {}
_vcYdA.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_vcYdA.Locked = false
_vcYdA.Opened = false
_FhIwi = Wherigo.ZItem(_XA1jk)
_FhIwi.Id = "17edb454-8173-4e11-a704-f499415f23b0"
_FhIwi.Name = _CyO("\122\033\002\112\010\091\010\113")
_FhIwi.Description = _CyO("\102\010\063\042\010\077\041\041\091\101\010\063\012\063\004\112\010\113\113\010\086\063\010\086\063\101\010\063\010\113\069\010\086\086\007\086\051\063\041\091\004\063\112\033\002\112\010\091\010\113\127")
_FhIwi.Visible = true
_FhIwi.Media = _9YuHi
_FhIwi.Commands = {}
_FhIwi.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FhIwi.Locked = false
_FhIwi.Opened = false
_XiguQ = Wherigo.ZItem(_XA1jk)
_XiguQ.Id = "07692ade-5baa-41e8-b7e8-54bb882a600a"
_XiguQ.Name = _CyO("\124\007\112\105\033\086\101\010\113\091\007\118\069\010\063\112\033\002\112\010\091\010\113")
_XiguQ.Description = _CyO("\102\010\063\042\010\077\041\041\091\101\010\063\065\063\004\112\010\113\113\010\086\063\010\086\063\101\010\063\010\113\069\010\086\086\007\086\051\063\041\091\004\063\044\007\112\105\033\086\101\010\113\091\007\118\069\010\063\112\033\002\112\010\091\010\113\127")
_XiguQ.Visible = true
_XiguQ.Media = _Fv5Z
_XiguQ.Commands = {}
_XiguQ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_XiguQ.Locked = false
_XiguQ.Opened = false

-- Tasks --
_d6R = Wherigo.ZTask(_XA1jk)
_d6R.Id = "ec0dfd9b-e3de-4f81-952e-eba0f0639b8e"
_d6R.Name = _CyO("\119\033\033\002\063\051\113\033\086\101\063\010\086\063\042\033\044\027\063\010\010\086\063\004\010\113\113\010")
_d6R.Description = ""
_d6R.Visible = true
_d6R.Media = __VZ
_d6R.Icon = __VZ
_d6R.Active = false
_d6R.Complete = false
_d6R.CorrectState = "None"
_3j_sz = Wherigo.ZTask(_XA1jk)
_3j_sz.Id = "319f6571-597d-4bf1-88c9-9e70877fbed2"
_3j_sz.Name = _CyO("\126\091\041\086\112\063\118\010\063\101\113\044\007\089\010\086\113\041\086\069\010\086")
_3j_sz.Description = ""
_3j_sz.Visible = true
_3j_sz.Media = _0zrb9
_3j_sz.Active = false
_3j_sz.Complete = false
_3j_sz.CorrectState = "None"
_4snVf = Wherigo.ZTask(_XA1jk)
_4snVf.Id = "98d5d88b-2f55-4bfd-99e6-1fe139bc1c10"
_4snVf.Name = _CyO("\042\010\037\010\004\112\063\101\010\063\051\113\033\086\101")
_4snVf.Description = ""
_4snVf.Visible = true
_4snVf.Media = _RMU
_4snVf.Active = false
_4snVf.Complete = false
_4snVf.CorrectState = "None"
_Z0Bok = Wherigo.ZTask(_XA1jk)
_Z0Bok.Id = "eb994678-1633-4568-92b1-cd0c9f64affc"
_Z0Bok.Name = _CyO("\089\010\113\105\033\113\051\063\101\010\063\051\113\033\010\007")
_Z0Bok.Description = ""
_Z0Bok.Visible = true
_Z0Bok.Media = _0zrb9
_Z0Bok.Icon = _E38
_Z0Bok.Active = false
_Z0Bok.Complete = false
_Z0Bok.CorrectState = "None"
_AdIwn = Wherigo.ZTask(_XA1jk)
_AdIwn.Id = "d5fd0d0a-41ca-44d1-b542-e202f14ebc87"
_AdIwn.Name = _CyO("\062\033\051\004\112\063\118\010\063\101\113\044\007\089\010\086\063")
_AdIwn.Description = ""
_AdIwn.Visible = true
_AdIwn.Media = _0zrb9
_AdIwn.Icon = _E38
_AdIwn.Active = false
_AdIwn.Complete = false
_AdIwn.CorrectState = "None"
_YzOr = Wherigo.ZTask(_XA1jk)
_YzOr.Id = "a96de071-75e6-47d9-acae-c72de2bf1ff4"
_YzOr.Name = _CyO("\119\086\007\002\063\101\010\063\069\091\010\007\086\010\063\101\113\044\007\089\010\086\063\010\113\044\007\112")
_YzOr.Description = ""
_YzOr.Visible = true
_YzOr.Media = _lsE
_YzOr.Active = false
_YzOr.Complete = false
_YzOr.CorrectState = "None"

-- Cartridge Variables --
_n4ha = _CyO("\067\109\065\043")
_kOeh = 0
_Uopj = 0
_LZth = _CyO("\051\010\042\113\033\010\101\010\113\004\063\026\041\086\077\007\010\044\107")
_BdmFN = _CyO("\071\033\068\041\091")
_F7z = ""
_ahL8 = 0
_309uY = 0
_kdDQZ = 0
_n1_ = _CyO("\088\012\012\026\083")
_fHy6k = _CyO("\101\044\037\037\068")
_MxlPS = _CyO("\088\059\126\119")
_NxNO = _CyO("\088\101\090\071")
_jGM = _CyO("\088\032\044\051\113\088")
_ZZasg = _CyO("\088\023\090\058\037")
_XA1jk.ZVariables = {
	_n4ha = _CyO("\067\109\065\043"), 
	_kOeh = 0, 
	_Uopj = 0, 
	_LZth = _CyO("\051\010\042\113\033\010\101\010\113\004\063\026\041\086\077\007\010\044\107"), 
	_BdmFN = _CyO("\071\033\068\041\091"), 
	_F7z = "", 
	_ahL8 = 0, 
	_309uY = 0, 
	_kdDQZ = 0, 
	_n1_ = _CyO("\088\012\012\026\083"), 
	_fHy6k = _CyO("\101\044\037\037\068"), 
	_MxlPS = _CyO("\088\059\126\119"), 
	_NxNO = _CyO("\088\101\090\071"), 
	_jGM = _CyO("\088\032\044\051\113\088"), 
	_ZZasg = _CyO("\088\023\090\058\037")
}

-- Timers --
_G6Lm = Wherigo.ZTimer(_XA1jk)
_G6Lm.Id = "d1ec7ee1-48ce-4703-a2e2-bd6b5b707dcb"
_G6Lm.Name = _CyO("\096\041\112\010\113\063\077\041\091\010\086")
_G6Lm.Description = ""
_G6Lm.Visible = true
_G6Lm.Duration = 100
_G6Lm.Type = "Countdown"
_1lw = Wherigo.ZTimer(_XA1jk)
_1lw.Id = "43cbc77c-5946-4baf-a7da-b756d6849c85"
_1lw.Name = _CyO("\069\086\007\002")
_1lw.Description = ""
_1lw.Visible = true
_1lw.Duration = 180
_1lw.Type = "Countdown"

-- Inputs --
_0ugr_ = Wherigo.ZInput(_XA1jk)
_0ugr_.Id = "72b7050d-2db2-4f1d-83c0-a3c08ac2cc13"
_0ugr_.Name = _CyO("\023\010\042\033\033\113\112\010\118\041\041\113")
_0ugr_.Description = ""
_0ugr_.Visible = true
_0ugr_.Media = _beP
_0ugr_.Choices = {
	"1865", 
	"1547", 
	"1976"
}
_0ugr_.InputType = "MultipleChoice"
_0ugr_.Text = _CyO("\096\010\010\112\063\118\007\118\063\007\086\063\027\010\091\069\063\118\041\041\113\063\007\069\063\077\007\010\113\063\027\010\113\101\063\051\010\042\033\113\010\086\022")
_jieF = Wherigo.ZInput(_XA1jk)
_jieF.Id = "774cbb01-20a7-4392-8fe0-a4f13cf351e6"
_jieF.Name = _CyO("\052\041\086\033\086\063\034\041\091\091")
_jieF.Description = ""
_jieF.Visible = true
_jieF.Media = _cAOc
_jieF.Choices = {
	"gebroeders Danhieux", 
	"gebroeders Lipsius", 
	"gebroeders Sohie"
}
_jieF.InputType = "MultipleChoice"
_jieF.Text = _CyO("\096\007\010\063\105\007\118\086\063\101\010\063\051\113\033\086\101\091\010\051\051\010\113\004\063\089\041\086\063\101\010\063\101\113\044\007\089\010\086\112\010\010\091\112\063\007\086\063\062\089\010\113\007\118\004\010\022")
_fdl_ = Wherigo.ZInput(_XA1jk)
_fdl_.Id = "1c035e1a-61bc-4576-a77c-596960221978"
_fdl_.Name = _CyO("\071\033\068\041\091")
_fdl_.Description = ""
_fdl_.Visible = true
_fdl_.Media = _QyNQ
_fdl_.Choices = {
	"Muscat", 
	"Canon Hall", 
	"Royal"
}
_fdl_.InputType = "MultipleChoice"
_fdl_.Text = _CyO("\096\010\091\069\010\063\105\007\118\086\063\042\091\041\044\027\010\063\101\113\044\007\089\010\086\022")
_uxh = Wherigo.ZInput(_XA1jk)
_uxh.Id = "fe903916-f0a7-40ab-ad75-53a5e89a8831"
_uxh.Name = _CyO("\058\010\033\002\033\091\101\063\020\020\020")
_uxh.Description = ""
_uxh.Visible = true
_uxh.Media = _1lKi0
_uxh.Icon = _E38
_uxh.Choices = {
	"restaurant", 
	"druiventelers", 
	"hobbyclub"
}
_uxh.InputType = "MultipleChoice"
_uxh.Text = _CyO("\096\041\112\063\007\004\063\101\010\063\083\112\010\113\113\010\101\113\044\007\078\022")

-- WorksWithList for object commands --

-- functions --
function _XA1jk:OnStart()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\096\010\091\069\033\037\063\007\086\063\026\071\124\121\019\008\063\077\044\007\004\063\089\041\086\063\101\010\063\112\041\078\010\091\101\113\044\007\078\127\063"), 
			Media = _wt9Q
		}, 
		{
			Text = _CyO("\020\069\063\042\010\086\063\026\113\044\007\078\037\041\086\127\063\060\038\071\099\100\033\091\051\063\101\010\063\041\041\086\027\007\118\105\007\086\051\010\086\063\010\086\063\033\086\112\113\041\078\010\091\063\041\091\091\010\063\113\041\041\101\004\010\091\004\063\033\037\063\118\010\063\010\007\051\010\086\063\004\037\041\069\010\091\007\118\069\010\063\112\041\078\010\091\101\113\044\007\089\010\086\063\112\010\063\112\010\091\010\086\127"), 
			Media = _Oxrf4
		}, 
		{
			Text = _CyO("\102\010\063\010\010\113\004\112\010\063\112\041\041\069\063\007\004\063\010\010\086\063\004\112\044\069\063\051\113\033\086\101\063\112\010\063\069\033\002\010\086\063\010\086\063\010\113\063\010\010\086\063\004\010\113\113\010\063\033\002\063\112\010\063\042\033\044\027\010\086\127"), 
			Media = _Oxrf4
		}, 
		{
			Text = _CyO("\083\112\041\002\063\086\041\041\113\063\042\044\007\112\010\086\008\063\051\041\063\101\033\033\113\063\101\010\063\002\033\033\113\112\063\091\007\086\069\004\041\078\063\086\041\041\113\063\077\010\112\063\102\044\004\112\044\004\063\058\007\002\004\007\044\004\002\091\010\007\086\127"), 
			Media = _Oxrf4
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _QtR)
	end)
	_QtR.Visible = true
	_QtR.Active = true
	_d6R.Active = true
	_d6R.Visible = true
	Wherigo.PlayAudio(_I36y)
end
function _XA1jk:OnEnd()
	_XA1jk:RequestSync()
end
function _XA1jk:OnRestore()
	_XA1jk:RequestSync()
end
function _33DS:OnEnter()
	_n1_ = _CyO("\088\012\012\026\083")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\096\010\091\069\033\037\063\112\010\113\044\051\127\063\058\041\112\010\086\063\027\010\063\010\089\010\086\063\069\007\118\069\010\086\063\027\041\112\063\101\010\063\010\107\002\010\113\112\010\086\063\089\041\086\063\118\010\063\112\010\010\091\112\063\089\007\086\101\010\086\127"), 
			Media = _Oxrf4
		}
	}, function(action)
		_Urwigo.Dialog(false, {
			{
				Text = _CyO("\082\010\113\004\112\063\010\086\063\089\033\033\113\041\091\063\002\113\033\078\007\057\007\041\112\121\063\060\038\071\099\102\010\063\112\010\010\091\101\010\063\118\010\063\010\007\051\010\086\063\112\041\078\010\091\101\113\044\007\089\010\086\127"), 
				Media = _0cPB
			}, 
			{
				Text = (_CyO("\102\010\063\042\010\077\041\041\091\101\010\063\089\033\033\113\063\101\007\089\010\113\004\063\041\041\086\042\033\101\063").._Uopj).._CyO("\063\033\002\063\012\127"), 
				Media = _0cPB
			}, 
			{
				Text = (_CyO("\102\010\063\042\010\077\041\041\091\101\010\063\089\033\033\113\063\033\002\042\113\010\086\051\004\112\063").._ahL8).._CyO("\063\033\002\063\012\127"), 
				Media = _0cPB
			}, 
			{
				Text = (_CyO("\102\010\063\042\010\077\041\041\091\101\010\063\089\033\033\113\063\069\027\041\091\007\112\010\007\112\063").._309uY).._CyO("\063\033\002\063\090\127"), 
				Media = _0cPB
			}, 
			{
				Text = (_CyO("\102\010\063\042\010\077\041\041\091\101\010\063\009\086\042\004\002\084").._kdDQZ).._CyO("\063\042\033\086\044\004\002\044\086\112\117\010\086\015\127"), 
				Media = _0cPB
			}
		}, function(action)
			if (((_Uopj + _ahL8) + _309uY) + _kdDQZ) < 6 then
				_Urwigo.MessageBox{
					Text = _CyO("\031\041\063\027\007\118\004\063\042\010\113\041\041\101\063\051\010\089\010\086\063\027\010\063\118\010\063\101\010\063\112\007\112\010\091\063\089\041\086\063\127\127\127"), 
					Media = _0cPB, 
					Buttons = {
						_CyO("\007\069\063\042\010\086\063\042\010\086\007\010\044\027\101")
					}, 
					Callback = function(action)
						if action ~= nil then
							_vcYdA:MoveTo(Player)
							Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _vcYdA)
						end
					end
				}
			elseif (((_Uopj + _ahL8) + _309uY) + _kdDQZ) == 6 then
				_Urwigo.MessageBox{
					Text = _CyO("\031\041\063\027\007\118\004\063\042\010\113\041\041\101\063\051\010\089\010\086\063\027\010\063\118\010\063\101\010\063\112\007\112\010\091\063\089\041\086\063\127\127\127"), 
					Media = _0cPB, 
					Buttons = {
						_CyO("\007\069\063\042\010\086\063\042\010\086\007\010\044\027\101")
					}, 
					Callback = function(action)
						if action ~= nil then
							_bB7c:MoveTo(Player)
							Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _bB7c)
						end
					end
				}
			elseif (((_Uopj + _ahL8) + _309uY) + _kdDQZ) > 6 then
				_Urwigo.MessageBox{
					Text = _CyO("\031\041\063\027\007\118\004\063\042\010\113\041\041\101\063\051\010\089\010\086\063\027\010\063\118\010\063\101\010\063\112\007\112\010\091\063\089\041\086\063\127\127\127"), 
					Media = _0cPB, 
					Buttons = {
						_CyO("\007\069\063\042\010\086\063\042\010\086\007\010\044\027\101")
					}, 
					Callback = function(action)
						if action ~= nil then
							_FhIwi:MoveTo(Player)
							Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _FhIwi)
						end
					end
				}
			elseif (((_Uopj + _ahL8) + _309uY) + _kdDQZ) == 13 then
				_Urwigo.MessageBox{
					Text = _CyO("\031\041\063\027\007\118\004\063\042\010\113\041\041\101\063\051\010\089\010\086\063\027\010\063\118\010\063\101\010\063\112\007\112\010\091\063\089\041\086\063\127\127\127"), 
					Media = _0cPB, 
					Buttons = {
						_CyO("\007\069\063\042\010\086\063\042\010\086\007\010\044\027\101")
					}, 
					Callback = function(action)
						if action ~= nil then
							_XiguQ:MoveTo(Player)
							Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _XiguQ)
						end
					end
				}
			end
		end)
	end)
	_XA1jk:RequestSync()
end
function _33DS:OnExit()
	_n1_ = _CyO("\088\012\012\026\083")
	_Urwigo.GlobalZoneExit()
end
function _QtR:OnEnter()
	_n1_ = _CyO("\088\024\112\071")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\096\010\091\069\033\037\063\033\002\063\037\007\118\086\063\002\091\010\007\086\121\063\020\069\063\042\010\086\063\102\044\004\112\044\004\127"), 
			Media = _shmaY
		}, 
		{
			Text = _CyO("\058\010\010\004\063\101\007\112\063\002\091\041\041\112\118\010\063\041\041\086\101\041\057\077\112\007\051\127\063\096\041\086\112\063\101\007\112\063\077\010\042\063\118\010\063\086\033\101\007\051\063\042\007\118\063\077\010\112\063\033\002\091\033\004\004\010\086\063\089\041\086\063\037\007\118\086\063\089\113\041\041\051\127"), 
			Media = _beP
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_0ugr_)
		end)
	end)
end
function _QtR:OnExit()
	_n1_ = _CyO("\088\024\112\071")
	_Urwigo.GlobalZoneExit()
end
function _HTS:OnEnter()
	_n1_ = _CyO("\088\034\122\083")
	_Urwigo.GlobalZoneEnter()
	if Player:Contains(_2PK) then
		_Urwigo.MessageBox{
			Text = _CyO("\096\010\091\069\033\037\063\007\086\063\077\010\112\063\052\033\086\007\086\069\107\077\044\068\004\121\063\096\010\063\037\010\113\069\010\086\063\101\041\112\063\118\010\063\089\033\091\101\033\010\086\101\010\063\078\007\086\041\086\057\007\010\091\010\063\101\113\041\041\051\069\113\041\057\077\112\063\077\010\042\112\063\010\086\063\077\033\002\010\086\063\101\041\112\063\118\010\063\101\007\112\063\027\007\091\063\007\086\089\010\004\112\010\113\010\086\063\007\086\063\101\010\063\101\113\044\007\089\010\086\112\010\010\091\112\127\063\023\041\063\086\041\041\113\063\083\033\091\077\010\007\101\010\063\010\086\063\105\033\010\069\063\010\113\063\051\113\033\086\101\063\010\086\063\004\010\113\113\010\004\127\060\038\071\099"), 
			Media = _xG36, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _2IA9u)
				end
			end
		}
	else
		_k0pN3:MoveTo(Player)
		_Urwigo.MessageBox{
			Text = _CyO("\096\010\091\069\033\037\063\007\086\063\077\010\112\063\052\033\086\007\086\069\107\077\044\068\004\121\063\096\010\063\027\007\091\091\010\086\063\118\010\063\051\113\041\041\051\063\077\010\091\002\010\086\063\037\010\112\063\010\010\086\063\091\010\086\007\086\051\127\063\045\033\063\069\041\086\063\118\010\063\077\010\091\002\010\086\063\042\007\118\063\101\010\063\044\007\112\042\033\044\027\063\089\041\086\063\101\010\063\101\113\044\007\089\010\086\112\010\010\091\112\127"), 
			Media = _xG36, 
			Buttons = {
				_CyO("\041\041\086\089\041\041\113\101\063\091\010\086\007\086\051")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.Dialog(false, {
						{
							Text = _CyO("\023\041\063\101\033\033\113\063\086\041\041\113\063\083\033\091\077\010\007\101\010"), 
							Media = _xG36
						}
					}, function(action)
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _2IA9u)
					end)
				end
			end
		}
	end
	_2IA9u.Active = true
	_2IA9u.Visible = true
	_HTS.Visible = false
	_HTS.Active = false
end
function _HTS:OnExit()
	_n1_ = _CyO("\088\034\122\083")
	_Urwigo.GlobalZoneExit()
end
function _2IA9u:OnEnter()
	_n1_ = _CyO("\088\059\020\021\035\044")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\023\033\010\101\063\042\010\051\033\086\086\010\086\121\063\026\033\010\063\105\033\063\089\033\033\113\112\121"), 
			Media = _xqR0F
		}, 
		{
			Text = _CyO("\023\041\063\089\091\044\051\063\086\041\041\113\063\042\033\089\010\086\127\063\038\007\118\063\101\010\063\004\010\113\113\010\004\063\027\041\057\077\112\010\086\063\101\010\063\051\113\033\086\101\091\010\051\051\010\113\004\063\089\041\086\063\101\010\063\062\089\010\113\007\118\004\010\063\101\113\044\007\089\010\086\112\010\010\091\112\063\118\010\063\033\002\127"), 
			Media = _xqR0F
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _7VDf)
	end)
	_rVPcT.Active = true
	_HTS.Active = false
	_7VDf.Active = true
	_7VDf.Visible = true
	_2IA9u.Active = false
	_2IA9u.Visible = false
end
function _2IA9u:OnExit()
	_n1_ = _CyO("\088\059\020\021\035\044")
	_Urwigo.GlobalZoneExit()
end
function _rVPcT:OnEnter()
	_n1_ = _CyO("\088\113\100\126\057\122")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = _CyO("\102\010\063\042\010\086\112\063\042\007\118\086\041\063\042\033\089\010\086\127\063\026\041\041\113\063\037\041\051\063\118\010\063\113\010\057\077\112\004\063\101\010\063\033\002\113\007\112\063\033\002\004\112\041\002\002\010\086\127\063\096\010\010\004\063\086\007\010\112\063\042\041\086\051\008\063\101\007\112\063\007\004\063\033\002\010\086\042\041\041\113\063\101\033\037\010\007\086\127"), 
		Media = _Oxrf4, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _7VDf)
				_rVPcT.Active = false
			end
		end
	}
end
function _rVPcT:OnExit()
	_n1_ = _CyO("\088\113\100\126\057\122")
	_Urwigo.GlobalZoneExit()
end
function _7VDf:OnEnter()
	_n1_ = _CyO("\088\043\100\026\078")
	_Urwigo.GlobalZoneEnter()
	_aZYBs:MoveTo(Player)
	if Player:Contains(_k0pN3) then
		_Urwigo.MessageBox{
			Text = _CyO("\096\010\091\069\033\037\063\041\041\086\063\101\010\063\010\010\113\004\112\010\063\004\010\113\113\010\004\063\033\002\063\044\027\063\112\033\057\077\112\127\063\060\038\071\099\096\007\118\063\105\007\118\086\063\101\010\063\051\010\042\113\033\010\101\010\113\004\063\026\041\086\077\007\010\044\107\014\063\034\010\086\113\007\008\063\126\077\007\091\007\002\063\010\086\063\100\007\057\112\033\113\127\063\060\038\071\099\096\010\063\077\010\042\042\010\086\063\089\010\113\086\033\037\010\086\063\101\041\112\063\118\010\063\010\010\086\063\091\010\086\007\086\051\063\077\010\042\112\063\033\037\063\112\010\063\007\086\089\010\004\112\010\113\010\086\063\007\086\063\101\010\063\101\113\044\007\089\010\086\112\010\010\091\112\127\063\020\086\063\113\044\007\091\063\089\033\033\113\063\101\007\112\063\051\010\091\101\063\042\007\010\101\010\086\063\027\010\063\118\010\063\010\010\086\063\004\112\044\069\063\051\113\033\086\101\127"), 
			Media = _0cPB, 
			Buttons = {
				_CyO("\119\033\033\002\063\051\113\033\086\101")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.Dialog(false, {
						{
							Text = _CyO("\020\086\063\067\046\043\046\063\042\033\044\027\101\010\086\063\027\007\118\063\033\086\105\010\063\010\010\113\004\112\010\063\004\010\113\113\010\004\063\007\086\063\062\089\010\113\007\118\004\010\127\063\031\044\063\027\007\091\091\010\086\063\027\007\118\063\118\010\063\077\010\091\002\010\086\063\042\007\118\063\077\010\112\063\042\033\044\027\010\086\063\089\041\086\063\118\010\063\010\007\051\010\086\063\004\010\113\113\010\127"), 
							Media = _0cPB
						}, 
						{
							Text = _CyO("\082\091\069\063\089\041\086\063\033\086\004\063\105\041\091\063\105\007\057\077\063\089\010\113\042\010\113\051\010\086\063\041\041\086\063\067\063\089\041\086\063\101\010\063\004\010\113\113\010\004\127\063\119\033\037\063\033\086\004\063\041\091\091\010\063\101\113\007\010\063\105\033\010\069\010\086\063\010\086\063\118\010\063\069\113\007\118\051\112\063\118\010\063\042\033\044\027\037\041\112\010\113\007\041\091\010\086\063\089\033\033\113\063\118\010\063\010\010\113\004\112\010\063\004\010\113\113\010\127"), 
							Media = _0cPB
						}
					}, function(action)
						_7VDf.Active = false
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
					end)
					_k0pN3:MoveTo(nil)
				end
			end
		}
	elseif Player:Contains(_2PK) then
		_Urwigo.MessageBox{
			Text = _CyO("\096\010\091\069\033\037\063\041\041\086\063\101\010\063\010\010\113\004\112\010\063\004\010\113\113\010\004\063\033\002\063\044\027\063\112\033\057\077\112\127\063\060\038\071\099\096\007\118\063\105\007\118\086\063\101\010\063\051\010\042\113\033\010\101\010\113\004\063\026\041\086\077\007\010\044\107\014\063\034\010\086\113\007\008\063\126\077\007\091\007\002\063\010\086\063\100\007\057\112\033\113\127\063\060\038\071\099\096\010\063\077\010\042\042\010\086\063\089\010\113\086\033\037\010\086\063\101\041\112\063\118\010\063\077\010\010\091\063\027\041\112\063\051\010\091\101\063\077\010\042\112\063\033\037\063\112\010\063\007\086\089\010\004\112\010\113\010\086\063\007\086\063\101\010\063\101\113\044\007\089\010\086\112\010\010\091\112\127\063\020\086\063\113\044\007\091\063\089\033\033\113\063\101\007\112\063\051\010\091\101\063\042\007\010\101\010\086\063\027\010\063\118\010\063\010\010\086\063\004\112\044\069\063\051\113\033\086\101\127"), 
			Media = _0cPB, 
			Buttons = {
				_CyO("\119\033\033\002\063\051\113\033\086\101")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.Dialog(false, {
						{
							Text = _CyO("\020\086\063\067\046\043\046\063\042\033\044\027\101\010\086\063\027\007\118\063\033\086\105\010\063\010\010\113\004\112\010\063\004\010\113\113\010\004\063\007\086\063\062\089\010\113\007\118\004\010\127\063\031\044\063\027\007\091\091\010\086\063\027\007\118\063\118\010\063\077\010\091\002\010\086\063\042\007\118\063\077\010\112\063\042\033\044\027\010\086\063\089\041\086\063\118\010\063\010\007\051\010\086\063\004\010\113\113\010\127"), 
							Media = _0cPB
						}, 
						{
							Text = _CyO("\082\091\069\063\089\041\086\063\033\086\004\063\105\041\091\063\105\007\057\077\063\089\010\113\042\010\113\051\010\086\063\041\041\086\063\067\063\089\041\086\063\101\010\063\004\010\113\113\010\004\127\063\119\033\037\063\033\086\004\063\041\091\091\010\063\101\113\007\010\063\105\033\010\069\010\086\063\010\086\063\118\010\063\069\113\007\118\051\112\063\118\010\063\042\033\044\027\037\041\112\010\113\007\041\091\010\086\063\089\033\033\113\063\118\010\063\010\010\113\004\112\010\063\004\010\113\113\010\127"), 
							Media = _0cPB
						}
					}, function(action)
						_7VDf.Active = false
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
					end)
					_2PK:MoveTo(nil)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _CyO("\096\010\091\069\033\037\063\041\041\086\063\101\010\063\010\010\113\004\112\010\063\004\010\113\113\010\004\063\033\002\063\044\027\063\112\033\057\077\112\127\063\060\038\071\099\096\007\118\063\105\007\118\086\063\101\010\063\051\010\042\113\033\010\101\010\113\004\063\026\041\086\077\007\010\044\107\014\063\034\010\086\113\007\008\063\126\077\007\091\007\002\063\010\086\063\100\007\057\112\033\113\127\063\060\038\071\099\096\010\063\077\010\042\042\010\086\063\089\010\113\086\033\037\010\086\063\101\041\112\063\118\010\063\051\010\010\086\063\051\010\091\101\063\077\010\042\112\063\033\037\063\112\010\063\007\086\089\010\004\112\010\113\010\086\063\007\086\063\101\010\063\101\113\044\007\089\010\086\112\010\010\091\112\127\063\102\010\063\069\041\086\063\010\010\086\063\004\112\044\069\063\089\041\086\063\033\086\105\010\063\051\113\033\086\101\063\051\010\042\113\044\007\069\010\086\127\063\020\086\063\113\044\007\091\063\089\113\041\051\010\086\063\027\010\063\101\041\112\063\118\010\063\010\113\063\010\010\086\063\004\010\113\113\010\063\033\002\063\042\033\044\027\112\063\010\086\063\010\113\063\101\113\044\007\089\010\086\063\089\010\113\042\033\044\027\112\127"), 
			Media = _0cPB, 
			Buttons = {
				_CyO("\119\033\033\002\063\051\113\033\086\101")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.Dialog(false, {
						{
							Text = _CyO("\020\086\063\067\046\043\046\063\042\033\044\027\101\010\086\063\027\007\118\063\033\086\105\010\063\010\010\113\004\112\010\063\004\010\113\113\010\004\063\007\086\063\062\089\010\113\007\118\004\010\127\063\031\044\063\027\007\091\091\010\086\063\027\007\118\063\118\010\063\077\010\091\002\010\086\063\042\007\118\063\077\010\112\063\042\033\044\027\010\086\063\089\041\086\063\118\010\063\010\007\051\010\086\063\004\010\113\113\010\127"), 
							Media = _0cPB
						}, 
						{
							Text = _CyO("\082\091\069\063\089\041\086\063\033\086\004\063\105\041\091\063\105\007\057\077\063\089\010\113\042\010\113\051\010\086\063\041\041\086\063\067\063\089\041\086\063\101\010\063\004\010\113\113\010\004\127\063\119\033\037\063\033\086\004\063\041\091\091\010\063\101\113\007\010\063\105\033\010\069\010\086\063\010\086\063\118\010\063\069\113\007\118\051\112\063\118\010\063\042\033\044\027\037\041\112\010\113\007\041\091\010\086\063\089\033\033\113\063\118\010\063\010\010\113\004\112\010\063\004\010\113\113\010\127"), 
							Media = _0cPB
						}
					}, function(action)
						_7VDf.Active = false
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
					end)
				end
			end
		}
	end
	_pE7S:MoveTo(_A_w)
	_jk97:MoveTo(_HRU9)
	_lFxp:MoveTo(_M_9)
	_A_w.Active = true
	_HRU9.Active = true
	_M_9.Active = true
	_rVPcT.Active = false
	_rVPcT.Visible = false
	_7VDf.Visible = false
	_jJv_5.Active = true
	_jJv_5.Visible = true
end
function _7VDf:OnExit()
	_n1_ = _CyO("\088\043\100\026\078")
	_Urwigo.GlobalZoneExit()
end
function _2a88I:OnEnter()
	_n1_ = _CyO("\088\059\041\046\046\020")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\096\010\091\069\033\037\063\007\086\063\037\007\118\086\063\077\044\007\004\121\063\031\044\063\118\010\063\010\010\086\063\010\007\051\010\086\063\004\010\113\113\010\063\042\010\105\007\112\008\063\007\004\063\077\010\112\063\112\007\118\101\063\033\037\063\112\010\063\007\086\089\010\004\112\010\113\010\086\063\007\086\063\101\113\044\007\089\010\086\113\041\086\069\010\086\127"), 
			Media = _shmaY
		}, 
		{
			Text = _CyO("\020\069\063\077\010\042\063\101\113\007\010\063\004\033\033\113\112\010\086\063\007\086\063\101\010\063\041\041\086\042\007\010\101\007\086\051\127\063\026\010\105\010\063\069\041\086\063\118\010\063\089\010\113\101\007\010\086\010\086\063\101\033\033\113\063\089\113\041\051\010\086\063\118\044\007\004\112\063\112\010\063\042\010\041\086\112\027\033\033\113\101\010\086\127\063"), 
			Media = _shmaY
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _rOss)
	end)
end
function _2a88I:OnExit()
	_n1_ = _CyO("\088\059\041\046\046\020")
	_Urwigo.GlobalZoneExit()
	Wherigo.PlayAudio(_I36y)
	_2a88I.Active = false
	if _Uopj == 0 then
		_Urwigo.MessageBox{
			Text = _CyO("\062\010\007\008\063\118\010\063\077\010\042\112\063\051\010\010\086\063\010\086\069\010\091\010\063\089\113\041\041\051\063\118\044\007\004\112\063\042\010\041\086\112\027\033\033\113\101\127\060\038\071\099\020\069\063\077\010\091\002\063\118\010\063\089\010\113\101\010\113\063\037\010\112\063\010\010\086\063\086\007\010\044\027\010\063\101\113\044\007\089\010\086\004\033\033\113\112\063\101\007\010\063\118\007\118\063\037\041\051\063\044\007\112\002\113\033\042\010\113\010\086\127\063"), 
			Media = _gPWg0, 
			Callback = function(action)
				if action ~= nil then
					_kbor:MoveTo(Player)
					_3j_sz.Complete = true
					_Urwigo.Dialog(false, {
						{
							Text = _CyO("\021\041\113\105\010\091\063\086\007\010\112\063\033\037\063\101\033\033\113\063\037\007\118\086\063\112\044\007\086\063\041\078\063\112\010\063\101\041\091\010\086\127\063\026\010\105\010\063\042\113\010\086\051\112\063\118\010\063\086\041\041\113\063\101\010\063\119\041\113\101\041\041\086\127"), 
							Media = _shmaY
						}, 
						{
							Text = _CyO("\026\010\063\119\041\113\101\041\041\086\063\007\004\063\010\010\086\063\033\089\010\113\042\091\007\118\078\004\010\091\063\089\041\086\063\101\010\063\033\044\101\010\063\089\010\004\112\007\086\051\004\027\041\091\091\010\086\127\063\083\007\086\101\004\063\033\044\101\004\077\010\113\063\007\004\063\101\007\112\063\101\010\063\042\010\004\112\063\042\010\037\010\004\112\010\063\051\113\033\086\101\127"), 
							Media = _shmaY
						}, 
						{
							Text = _CyO("\034\041\041\004\112\063\118\010\063\037\010\112\063\086\041\041\113\063\042\010\086\010\101\010\086\063\027\041\086\112\063\033\086\101\010\113\041\041\086\063\101\010\063\089\010\004\112\007\086\051\063\091\007\051\112\063\101\010\063\086\033\101\007\051\010\063\042\010\004\037\010\004\112\007\086\051\063\089\033\033\113\063\118\010\063\004\010\113\113\010\063\069\091\041\041\113\127"), 
							Media = _shmaY
						}
					}, function(action)
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _aVc)
					end)
				end
			end
		}
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CyO("\021\041\113\105\010\091\063\086\007\010\112\063\033\037\063\101\033\033\113\063\037\007\118\086\063\112\044\007\086\063\041\078\063\112\010\063\101\041\091\010\086\127\063\026\010\105\010\063\042\113\010\086\051\112\063\118\010\063\086\041\041\113\063\101\010\063\119\041\113\101\041\041\086\127"), 
				Media = _shmaY
			}, 
			{
				Text = _CyO("\026\010\063\119\041\113\101\041\041\086\063\007\004\063\010\010\086\063\033\089\010\113\042\091\007\118\078\004\010\091\063\089\041\086\063\101\010\063\033\044\101\010\063\089\010\004\112\007\086\051\004\027\041\091\091\010\086\127\063\083\007\086\101\004\063\033\044\101\004\077\010\113\063\007\004\063\101\007\112\063\101\010\063\042\010\004\112\063\042\010\037\010\004\112\010\063\051\113\033\086\101\127"), 
				Media = _shmaY
			}, 
			{
				Text = _CyO("\034\041\041\004\112\063\118\010\063\037\010\112\063\086\041\041\113\063\042\010\086\010\101\010\086\063\027\041\086\112\063\033\086\101\010\113\041\041\086\063\101\010\063\089\010\004\112\007\086\051\063\091\007\051\112\063\101\010\063\086\033\101\007\051\010\063\042\010\004\037\010\004\112\007\086\051\063\089\033\033\113\063\118\010\063\004\010\113\113\010\063\069\091\041\041\113\127"), 
				Media = _shmaY
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _aVc)
		end)
	end
end
function _aVc:OnEnter()
	_n1_ = _CyO("\088\041\100\057")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = _CyO("\034\007\010\113\063\091\007\051\112\063\101\010\063\042\010\037\010\004\112\007\086\051\063\089\033\033\113\063\118\010\063\051\113\033\086\101\063\069\091\041\041\113\127\063"), 
		Media = _Ya8jT, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _eWM4u)
			end
		end
	}
	_MXlwz.Active = true
	_MXlwz.Visible = true
	_aVc.Visible = false
end
function _aVc:OnExit()
	_n1_ = _CyO("\088\041\100\057")
	_Urwigo.GlobalZoneExit()
end
function _MXlwz:OnEnter()
	_n1_ = _CyO("\088\123\029\091\027\105")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\062\089\010\113\007\118\004\010\063\077\010\010\078\112\063\086\007\010\112\063\041\091\091\010\010\086\063\102\044\004\112\044\004\063\058\007\002\004\007\044\004\063\010\086\063\112\041\078\010\091\101\113\044\007\089\010\086\127\063\034\010\112\063\033\089\010\113\042\010\069\010\086\101\010\063\042\007\010\113\063\058\010\078\078\010\063\069\010\086\112\063\033\033\069\063\077\007\010\113\063\077\041\041\113\063\033\033\113\004\002\113\033\086\051\127"), 
			Media = _xqR0F
		}, 
		{
			Text = _CyO("\020\086\063\077\010\112\063\051\010\042\033\044\027\063\086\041\041\004\112\063\118\010\063\027\010\113\101\063\089\041\086\063\067\035\109\059\063\112\033\112\063\067\035\043\035\063\058\010\078\078\010\063\051\010\042\113\033\044\027\010\086\063\101\033\033\113\063\021\091\042\010\113\112\063\058\033\033\112\089\033\010\112\127\063\062\002\063\077\010\112\063\042\007\086\086\010\086\002\091\010\007\086\063\069\041\086\063\118\010\063\086\033\051\063\010\010\086\063\033\044\101\010\063\042\113\033\044\027\069\010\112\010\091\063\105\007\010\086\127"), 
			Media = _xqR0F
		}, 
		{
			Text = _CyO("\096\041\086\101\010\091\063\086\044\063\089\010\113\101\010\113\063\091\041\086\051\004\063\101\010\063\020\102\004\010\027\010\051\063\086\041\041\113\063\077\010\112\063\038\010\051\007\118\086\077\033\078\002\091\010\007\086\127"), 
			Media = _xqR0F
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _Ckd4)
	end)
	_lnkk.Active = true
	_Ckd4.Active = true
	_Ckd4.Visible = true
	_MXlwz.Active = false
	_MXlwz.Visible = false
end
function _MXlwz:OnExit()
	_n1_ = _CyO("\088\123\029\091\027\105")
	_Urwigo.GlobalZoneExit()
end
function _lnkk:OnEnter()
	_n1_ = _CyO("\088\091\086\069\069")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\026\010\063\020\102\004\010\063\007\004\063\077\010\010\091\063\042\010\091\041\086\051\113\007\118\069\063\089\033\033\113\063\101\010\063\101\113\044\007\089\010\086\112\010\010\091\112\127\063\096\041\086\112\063\101\007\112\063\113\007\089\007\010\113\112\118\010\063\051\041\078\063\089\033\113\037\063\041\041\086\063\101\007\112\063\101\041\091\063\037\010\112\063\101\010\105\010\063\007\101\010\041\091\010\063\077\010\091\091\007\086\051\010\086\127\063"), 
			Media = _tmPA
		}, 
		{
			Text = _CyO("\026\010\063\041\091\051\010\037\010\086\010\063\041\041\086\027\010\105\007\051\077\010\007\101\063\089\041\086\063\051\113\033\086\101\011\063\010\086\063\042\113\033\086\027\041\112\010\113\063\007\004\063\010\089\010\086\010\010\086\004\063\086\033\033\101\105\041\069\010\091\007\118\069\063\033\037\063\112\041\078\010\091\101\113\044\007\089\010\086\063\112\010\063\089\010\113\042\033\044\027\010\086\127"), 
			Media = _tmPA
		}
	}, function(action)
		_agN.Active = true
		_Ckd4.Active = true
		_Ckd4.Visible = true
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _Ckd4)
	end)
	_lnkk.Active = false
	_lnkk.Visible = false
end
function _lnkk:OnExit()
	_n1_ = _CyO("\088\091\086\069\069")
	_Urwigo.GlobalZoneExit()
end
function _hwY6m:OnEnter()
	_n1_ = _CyO("\088\077\027\001\090\037")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\023\033\010\101\063\105\033\127\063\026\010\063\042\091\033\010\007\063\007\004\063\051\010\004\112\041\113\112\127\063\060\038\071\099\102\010\063\037\033\010\112\063\041\091\091\010\063\089\113\044\057\077\112\112\041\069\069\010\086\063\049\033\002\063\067\063\105\010\112\112\010\086\049\063\010\086\063\101\010\063\113\041\086\069\010\086\063\089\033\091\101\033\010\086\101\010\063\027\041\112\010\113\063\051\010\089\010\086\127"), 
			Media = _rkY
		}, 
		{
			Text = _CyO("\058\041\112\010\086\063\027\010\063\010\089\010\086\063\069\007\118\069\010\086\063\033\078\063\118\010\063\004\086\010\091\063\069\041\086\063\027\010\113\069\010\086\127\063\122\010\113\027\007\118\091\063\027\007\118\063\118\010\063\101\113\044\007\089\010\091\041\041\113\004\063\089\010\113\105\033\113\051\010\086\008\063\077\041\041\091\063\118\007\118\063\027\041\112\010\113\063\042\007\118\063\101\010\063\042\113\033\086\127\063"), 
			Media = _rkY
		}, 
		{
			Text = _CyO("\058\033\033\002\063\004\086\010\091\063\086\041\041\113\063\101\010\063\042\113\033\086\063\010\086\063\069\033\037\063\010\089\010\086\063\004\086\010\091\063\112\010\113\044\051\063\086\041\041\113\063\077\007\010\113\127\063\021\041\086\063\101\010\063\077\041\086\101\063\089\041\086\063\101\010\105\010\063\069\091\010\007\086\010\063\112\010\004\112\008\063\069\007\118\069\010\086\063\027\010\063\033\078\063\118\010\063\004\086\010\091\063\051\010\086\033\010\051\063\069\041\086\063\027\010\113\069\010\086\127"), 
			Media = _rkY
		}
	}, function(action)
		_Ufh71.Active = true
		_Ufh71.Visible = true
		_Urwigo.MessageBox{
			Text = _CyO("\038\010\086\063\118\010\063\069\091\041\041\113\022\063\058\033\033\002\063\007\086\063\067\032\032\063\004\010\057\033\086\101\010\086\063\105\033\063\089\010\010\091\063\041\091\004\063\037\033\051\010\091\007\118\069\063\033\089\010\113\063\010\086\063\027\010\010\113\063\089\041\086\063\101\010\063\042\113\033\086\063\086\041\041\113\063\077\007\010\113\063\010\086\063\089\010\113\051\010\010\112\063\086\007\010\112\063\027\041\112\010\113\063\037\010\010\063\112\010\063\042\113\010\086\051\010\086\121"), 
			Media = _rkY, 
			Buttons = {
				_CyO("\083\122\021\071\122")
			}, 
			Callback = function(action)
				if action ~= nil then
					_G6Lm:Start()
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _Ufh71)
					_hwY6m.Active = false
					_hwY6m.Visible = false
				end
			end
		}
	end)
end
function _hwY6m:OnExit()
	_n1_ = _CyO("\088\077\027\001\090\037")
	_Urwigo.GlobalZoneExit()
end
function _Ufh71:OnEnter()
	_n1_ = _CyO("\088\124\078\077\043\067")
	_Urwigo.GlobalZoneEnter()
	_ZbNvM.Active = true
	_ZbNvM.Visible = true
	_VWeG:MoveTo(Player)
	_Urwigo.MessageBox{
		Text = _CyO("\023\033\010\101\063\105\033\121\063\034\007\010\113\063\077\010\042\063\118\010\063\010\010\086\063\010\037\037\010\113\063\027\041\112\010\113\127"), 
		Media = _xqR0F, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _ZbNvM)
			end
		end
	}
end
function _Ufh71:OnExit()
	_n1_ = _CyO("\088\124\078\077\043\067")
	_Urwigo.GlobalZoneExit()
end
function _GRSV:OnEnter()
	_n1_ = _CyO("\088\023\071\083\100")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\102\010\063\077\010\042\112\063\041\091\063\037\033\033\007\063\027\010\113\069\063\089\010\113\113\007\057\077\112\127\063\021\091\091\010\063\089\113\044\057\077\112\112\041\069\069\010\086\063\033\086\112\027\007\069\069\010\091\010\086\063\037\033\033\007\010\063\112\113\033\004\004\010\086\127\063\083\112\113\041\069\004\063\037\033\010\112\063\118\010\063\101\010\105\010\063\044\007\112\069\033\113\113\010\091\010\086\063\033\078\063\051\113\010\086\010\007\113\010\086\127\063\026\007\112\063\007\004\063\101\010\063\069\091\010\007\086\010\063\101\113\044\007\078\118\010\004\063\044\007\112\063\101\010\063\112\113\033\004\004\010\086\063\069\086\007\002\002\010\086\127\063\102\010\063\069\113\007\118\051\112\063\089\041\086\063\037\007\118\063\010\010\086\063\004\057\077\041\041\113\127"), 
			Media = _Ya8jT
		}, 
		{
			Text = _CyO("\023\041\063\089\010\113\101\010\113\063\086\041\041\113\063\004\002\010\010\091\112\044\007\086\063\026\010\086\063\038\091\041\086\069\063\101\041\041\113\063\105\041\091\063\037\007\118\086\063\042\113\033\010\113\063\118\010\063\091\010\113\010\086\063\069\086\007\002\002\010\086\127"), 
			Media = _Ya8jT
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _suA)
	end)
	_O6kf:MoveTo(Player)
	_suA.Active = true
	_suA.Visible = true
end
function _GRSV:OnExit()
	_n1_ = _CyO("\088\023\071\083\100")
	_Urwigo.GlobalZoneExit()
	_Urwigo.MessageBox{
		Text = _CyO("\083\112\041\002\063\101\010\063\069\041\004\004\010\007\027\010\051\063\086\041\041\113\063\042\033\089\010\086\063\033\002\127")
	}
	_GRSV.Active = false
	_GRSV.Visible = false
end
function _suA:OnEnter()
	_n1_ = _CyO("\088\004\044\021")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.Dialog(false, {
		{
			Text = _CyO("\020\069\063\042\010\086\063\042\010\086\007\010\044\027\101\063\077\033\010\063\089\091\033\112\063\118\010\063\101\010\063\069\091\010\007\086\010\063\101\113\044\007\078\118\010\004\063\044\007\112\063\101\010\063\112\113\033\004\004\010\086\063\069\041\086\063\069\086\007\002\002\010\086\127"), 
			Media = _tmPA
		}, 
		{
			Text = _CyO("\026\041\041\113\033\037\063\077\010\042\042\010\086\063\027\010\063\089\033\033\113\063\118\033\044\063\010\010\086\063\002\113\033\010\078\033\002\004\112\010\091\091\007\086\051\063\051\010\037\041\041\069\112\127\063\026\010\063\004\002\010\010\091\112\044\007\086\063\004\112\010\091\112\063\010\010\086\063\112\113\033\004\063\089\033\033\113\063\010\086\063\044\007\112\063\101\010\105\010\063\112\113\033\004\063\037\033\010\112\063\118\010\063\105\010\004\063\069\091\010\007\086\010\063\101\113\044\007\089\010\086\063\069\086\007\002\002\010\086\127"), 
			Media = _tmPA
		}, 
		{
			Text = _CyO("\026\010\105\010\063\069\091\010\007\086\010\063\101\113\044\007\078\118\010\004\063\037\033\010\112\063\118\010\063\105\033\010\069\010\086\127\063\102\010\063\069\113\007\118\051\112\063\010\010\086\063\078\033\112\033\057\033\091\091\041\051\010\127\063\026\010\063\078\033\112\033\049\004\063\112\033\086\010\086\063\027\041\041\113\063\118\010\063\101\010\063\101\113\044\007\078\118\010\004\063\069\041\086\063\089\007\086\101\010\086\127\063\102\010\063\069\113\007\118\051\063\077\007\010\113\089\033\033\113\063\012\063\037\007\086\044\112\010\086\063\101\010\063\112\007\118\101\127"), 
			Media = _tmPA
		}
	}, function(action)
		_Urwigo.MessageBox{
			Text = _CyO("\038\010\086\063\118\010\063\069\091\041\041\113\022"), 
			Media = _tmPA, 
			Buttons = {
				_CyO("\083\122\021\071\122")
			}, 
			Callback = function(action)
				if action ~= nil then
					_1lw:Start()
					_vqKHU:MoveTo(Player)
					_jcvz.Active = true
					_P7a.Active = true
					_lPQRV.Active = true
					_62V.Active = true
					_2wi8T.Active = true
					_s6XT.Active = true
					_suA.Active = false
					_suA.Visible = false
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _vqKHU)
				end
			end
		}
	end)
end
function _suA:OnExit()
	_n1_ = _CyO("\088\004\044\021")
	_Urwigo.GlobalZoneExit()
end
function _raQ:OnEnter()
	_n1_ = _CyO("\088\113\041\024")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = _CyO("\026\041\086\069\063\118\010\063\033\037\063\033\086\004\063\112\010\063\069\033\037\010\086\063\077\010\091\002\010\086\127\063\020\086\063\113\044\007\091\063\105\044\091\091\010\086\063\027\007\118\063\044\027\063\101\113\044\007\089\010\086\063\089\010\113\101\010\113\063\089\010\113\105\033\113\051\010\086\063\112\033\112\063\101\010\063\033\033\051\004\112\127\063\102\007\118\063\037\041\051\063\086\044\063\010\089\010\086\063\113\044\004\112\010\086\063\010\086\063\051\010\086\007\010\112\010\086\127\060\038\071\099\096\041\086\101\010\091\063\113\044\004\112\007\051\063\086\041\041\113\063\077\010\112\063\057\010\086\112\113\044\037\063\010\086\063\086\041\041\113\063\033\086\105\010\063\004\112\113\041\041\112\127"), 
		Media = _0cPB, 
		Buttons = {
			_CyO("\037\010\112\063\002\091\010\105\007\010\113")
		}, 
		Callback = function(action)
			if action ~= nil then
				_raQ.Active = false
				_raQ.Visible = false
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _ERugV)
			end
		end
	}
	_ERugV.Active = true
	_ERugV.Visible = true
	_kdDQZ = _kdDQZ + 1
end
function _raQ:OnExit()
	_n1_ = _CyO("\088\113\041\024")
	_Urwigo.GlobalZoneExit()
end
function _ERugV:OnEnter()
	_n1_ = _CyO("\088\082\071\044\051\100")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = _CyO("\034\007\010\113\063\007\086\063\077\010\112\063\057\010\086\112\113\044\037\063\089\041\086\063\062\089\010\113\007\118\004\010\063\089\007\010\113\010\086\063\027\010\063\007\086\063\041\044\051\044\004\112\044\004\063\101\010\063\101\113\044\007\089\010\086\078\010\010\004\112\010\086\063\112\010\113\063\010\113\010\063\089\041\086\063\101\010\063\112\041\078\010\091\101\113\044\007\078\127\063\026\041\086\063\089\010\113\069\007\010\105\010\086\063\105\010\063\033\033\069\063\010\010\086\063\101\113\044\007\089\010\086\069\033\086\007\086\051\007\086\127\063"), 
		Media = _xqR0F, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _CyO("\102\010\063\101\113\044\007\089\010\086\063\105\007\118\086\063\069\091\041\041\113\063\033\037\063\112\010\063\033\033\051\004\112\010\086\127\063\023\041\063\101\033\033\113\063\101\010\063\004\112\041\112\007\033\086\004\004\112\113\041\041\112\063\112\010\113\044\051\063\086\041\041\113\063\026\071\124\121\019\127\063\026\041\041\113\063\007\004\063\077\010\112\063\112\007\118\101\063\033\037\063\118\010\063\112\010\063\010\089\041\091\044\010\113\010\086\127"), 
					Media = _nf7, 
					Buttons = {
						_CyO("\119\033\037\063\027\010\063\051\041\041\086\063\033\033\051\004\112\010\086")
					}, 
					Callback = function(action)
						if action ~= nil then
							_ERugV.Active = false
							_ERugV.Visible = false
							_AdIwn.Complete = true
							Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _33DS)
						end
					end
				}
			end
		end
	}
	_33DS.Active = true
	_33DS.Visible = true
end
function _ERugV:OnExit()
	_n1_ = _CyO("\088\082\071\044\051\100")
	_Urwigo.GlobalZoneExit()
end
function _s6XT:OnEnter()
	_n1_ = _CyO("\088\004\090\029\122")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _VPhe, 
		Buttons = {
			_CyO("\069\086\007\002")
		}, 
		Callback = function(action)
			if action ~= nil then
				_309uY = _309uY + 1
				_s6XT.Active = false
			end
		end
	}
end
function _s6XT:OnExit()
	_n1_ = _CyO("\088\004\090\029\122")
	_Urwigo.GlobalZoneExit()
end
function _jcvz:OnEnter()
	_n1_ = _CyO("\088\118\057\089\105")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _VPhe, 
		Buttons = {
			_CyO("\069\086\007\002")
		}, 
		Callback = function(action)
			if action ~= nil then
				_309uY = _309uY + 1
				_jcvz.Active = false
			end
		end
	}
end
function _jcvz:OnExit()
	_n1_ = _CyO("\088\118\057\089\105")
	_Urwigo.GlobalZoneExit()
end
function _P7a:OnEnter()
	_n1_ = _CyO("\088\126\043\041")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _VPhe, 
		Buttons = {
			_CyO("\069\086\007\002")
		}, 
		Callback = function(action)
			if action ~= nil then
				_309uY = _309uY + 1
				_P7a.Active = false
			end
		end
	}
end
function _P7a:OnExit()
	_n1_ = _CyO("\088\126\043\041")
	_Urwigo.GlobalZoneExit()
end
function _lPQRV:OnEnter()
	_n1_ = _CyO("\088\091\126\024\071\100")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _VPhe, 
		Buttons = {
			_CyO("\069\086\007\002")
		}, 
		Callback = function(action)
			if action ~= nil then
				_309uY = _309uY + 1
				_lPQRV.Active = false
			end
		end
	}
end
function _lPQRV:OnExit()
	_n1_ = _CyO("\088\091\126\024\071\100")
	_Urwigo.GlobalZoneExit()
end
function _62V:OnEnter()
	_n1_ = _CyO("\088\090\059\100")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _VPhe, 
		Buttons = {
			_CyO("\069\086\007\002")
		}, 
		Callback = function(action)
			if action ~= nil then
				_309uY = _309uY + 1
				_62V.Active = false
			end
		end
	}
end
function _62V:OnExit()
	_n1_ = _CyO("\088\090\059\100")
	_Urwigo.GlobalZoneExit()
end
function _2wi8T:OnEnter()
	_n1_ = _CyO("\088\059\027\007\046\122")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _VPhe, 
		Buttons = {
			_CyO("\069\086\007\002")
		}, 
		Callback = function(action)
			if action ~= nil then
				_309uY = _309uY + 1
				_2wi8T.Active = false
			end
		end
	}
end
function _2wi8T:OnExit()
	_n1_ = _CyO("\088\059\027\007\046\122")
	_Urwigo.GlobalZoneExit()
end
function _A_w:OnEnter()
	_n1_ = _CyO("\088\021\088\027")
	_Urwigo.GlobalZoneEnter()
	if _kOeh == 3 then
		_Urwigo.MessageBox{
			Text = _CyO("\020\069\063\042\010\086\063\034\010\086\113\007\063\010\086\063\051\010\010\078\063\118\010\063\051\091\041\004\127\063\102\010\063\077\010\042\112\063\086\044\063\041\091\091\010\063\037\041\112\010\113\007\041\091\010\086\127\060\038\071\099\023\041\063\086\041\041\113\063\101\010\063\002\091\041\041\112\004\063\051\041\041\112\063\027\041\041\113\063\118\010\063\118\010\063\004\010\113\113\010\063\069\041\086\063\042\033\044\027\010\086\127"), 
			Media = _rkY, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _CyO("\126\113\033\078\007\057\007\041\112\127\063\020\069\063\042\010\086\063\034\010\086\113\007\063\010\086\063\118\010\063\077\010\042\112\063\037\010\063\051\010\089\033\086\101\010\086\127\063\020\069\063\051\010\010\078\063\118\010\063\051\091\041\004\127\060\038\071\099\045\033\010\069\063\010\010\113\004\112\063\086\041\041\113\063\037\007\118\086\063\041\086\101\010\113\010\063\042\113\033\010\113\004\063\089\033\033\113\063\118\010\063\086\041\041\113\063\101\010\063\002\091\041\041\112\004\063\051\041\041\112\063\027\041\041\113\063\118\010\063\118\010\063\004\010\113\113\010\063\069\041\086\063\042\033\044\027\010\086\127"), 
			Media = _rkY, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
				end
			end
		}
	end
	_pE7S:MoveTo(Player)
	_kOeh = _kOeh + 1
	_A_w.Active = false
end
function _A_w:OnExit()
	_n1_ = _CyO("\088\021\088\027")
	_Urwigo.GlobalZoneExit()
end
function _HRU9:OnEnter()
	_n1_ = _CyO("\088\034\071\124\035")
	_Urwigo.GlobalZoneEnter()
	if _kOeh == 3 then
		_Urwigo.MessageBox{
			Text = _CyO("\020\069\063\042\010\086\063\126\077\007\091\007\002\063\010\086\063\051\010\010\078\063\118\010\063\037\010\112\041\041\091\127\063\102\010\063\077\010\042\112\063\086\044\063\041\091\091\010\063\037\041\112\010\113\007\041\091\010\086\127\060\038\071\099\023\041\063\086\041\041\113\063\101\010\063\002\091\041\041\112\004\063\051\041\041\112\063\027\041\041\113\063\118\010\063\118\010\063\004\010\113\113\010\063\069\041\086\063\042\033\044\027\010\086\127"), 
			Media = _tmPA, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _CyO("\126\113\033\078\007\057\007\041\112\008\063\118\010\063\077\010\042\112\063\037\010\063\051\010\089\033\086\101\010\086\127\063\020\069\063\042\010\086\063\126\077\007\091\007\002\063\010\086\063\007\069\063\051\010\010\078\063\118\010\063\037\010\112\041\041\091\127\063\045\033\010\069\063\010\010\113\004\112\063\037\007\118\086\063\041\086\101\010\113\010\063\042\113\033\010\113\004\063\089\033\033\113\063\118\010\063\086\041\041\113\063\101\010\063\002\091\041\041\112\004\063\051\041\041\112\063\027\041\041\113\063\118\010\063\118\010\063\004\010\113\113\010\063\069\041\086\063\042\033\044\027\010\086\127"), 
			Media = _tmPA, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
				end
			end
		}
	end
	_jk97:MoveTo(Player)
	_kOeh = _kOeh + 1
	_HRU9.Active = false
end
function _HRU9:OnExit()
	_n1_ = _CyO("\088\034\071\124\035")
	_Urwigo.GlobalZoneExit()
end
function _M_9:OnEnter()
	_n1_ = _CyO("\088\123\088\035")
	_Urwigo.GlobalZoneEnter()
	if _kOeh == 3 then
		_Urwigo.MessageBox{
			Text = _CyO("\020\069\063\042\010\086\063\100\007\057\112\033\113\063\010\086\063\051\010\010\078\063\118\010\063\004\112\033\002\089\010\113\078\127\063\102\010\063\077\010\042\112\063\086\044\063\041\091\091\010\063\037\041\112\010\113\007\041\091\010\086\127\060\038\071\099\023\041\063\086\041\041\113\063\101\010\063\002\091\041\041\112\004\063\051\041\041\112\063\027\041\041\113\063\118\010\063\118\010\063\004\010\113\113\010\063\069\041\086\063\042\033\044\027\010\086\127"), 
			Media = _Ya8jT, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _CyO("\023\010\089\033\086\101\010\086\121\063\020\069\063\042\010\086\063\100\007\057\112\033\113\127\063\020\069\063\051\010\010\078\063\118\010\063\004\112\033\002\089\010\113\078\127\063\045\033\010\069\063\010\010\113\004\112\063\086\041\041\113\063\037\007\118\086\063\041\086\101\010\113\010\063\042\113\033\010\113\004\063\089\033\033\113\063\118\010\063\086\041\041\113\063\086\041\041\113\063\101\010\063\002\091\041\041\112\004\063\051\041\041\112\063\027\041\041\113\063\118\010\063\118\010\063\004\010\113\113\010\063\069\041\086\063\042\033\044\027\010\086\127"), 
			Media = _Ya8jT, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _jJv_5)
				end
			end
		}
	end
	_lFxp:MoveTo(Player)
	_kOeh = _kOeh + 1
	_M_9.Active = false
end
function _M_9:OnExit()
	_n1_ = _CyO("\088\123\088\035")
	_Urwigo.GlobalZoneExit()
end
function _jJv_5:OnEnter()
	_n1_ = _CyO("\088\118\102\089\088\109")
	_Urwigo.GlobalZoneEnter()
	if _kOeh == 3 then
		_Urwigo.Dialog(false, {
			{
				Text = _CyO("\126\113\007\037\041\121\063\102\010\063\077\010\042\112\063\101\010\063\086\033\101\007\051\010\063\037\041\112\010\113\007\041\091\010\086\063\089\010\113\105\041\037\010\091\101\127\063\058\041\112\010\086\063\027\010\063\004\041\037\010\086\063\118\010\063\004\010\113\113\010\063\042\033\044\027\010\086\127"), 
				Media = _0cPB
			}, 
			{
				Text = _CyO("\126\113\033\078\007\057\007\041\112\063\037\010\112\063\118\010\063\010\007\051\010\086\063\004\010\113\113\010\063\121\063\060\038\071\099\083\112\041\002\063\086\044\063\091\007\086\069\004\063\101\010\063\123\033\091\091\010\086\004\112\113\041\041\112\063\044\007\112\063\010\086\063\004\091\041\063\101\041\086\063\113\010\057\077\112\004\063\041\078\063\101\010\063\126\127\020\127\122\041\068\037\041\086\004\004\112\113\041\041\112\063\041\078\063\112\033\112\063\041\041\086\063\077\010\112\063\102\044\004\112\044\004\063\058\007\002\004\007\044\004\077\044\007\004\127"), 
				Media = __VZ
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _2a88I)
		end)
		_5hX:MoveTo(Player)
		_pE7S:MoveTo(nil)
		_jk97:MoveTo(nil)
		_lFxp:MoveTo(nil)
		_d6R.Complete = true
		_3j_sz.Visible = true
		_2a88I.Active = true
		_2a88I.Visible = true
		_jJv_5.Active = false
	elseif _kOeh == 2 then
		_Urwigo.MessageBox{
			Text = _CyO("\102\010\063\077\010\042\112\063\086\033\051\063\067\063\042\033\044\027\037\041\112\010\113\007\041\041\091\063\112\010\063\069\033\113\112\127\063\023\041\063\089\091\044\051\063\010\089\010\086\063\112\010\113\044\051\063\010\086\063\105\033\010\069\063\113\033\086\101\063\101\010\063\004\010\113\113\010\004\127"), 
			Media = _0cPB, 
			Callback = function(action)
				if action ~= nil then
					_A_w.Visible = true
					_HRU9.Visible = true
					_M_9.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _kOeh == 1 then
		_Urwigo.MessageBox{
			Text = _CyO("\102\010\063\077\010\042\112\063\086\033\051\063\112\027\010\010\063\089\041\086\063\101\010\063\101\113\007\010\063\042\033\044\027\037\041\112\010\113\007\041\091\010\086\063\112\010\063\069\033\113\112\127\063\023\041\063\089\091\044\051\063\112\010\113\044\051\063\010\086\063\105\033\010\069\063\113\033\086\101\063\101\010\063\004\010\113\113\010\004\127"), 
			Media = _0cPB, 
			Callback = function(action)
				if action ~= nil then
					_A_w.Visible = true
					_HRU9.Visible = true
					_M_9.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _CyO("\102\010\063\077\010\042\112\063\086\033\051\063\051\010\010\086\063\010\086\069\010\091\063\042\033\044\027\037\041\112\010\113\007\041\041\091\127\063\023\041\063\101\041\101\010\091\007\118\069\063\112\010\113\044\051\063\010\086\063\105\033\010\069\063\113\033\086\101\063\101\010\063\004\010\113\113\010\004\127"), 
			Media = _0cPB, 
			Callback = function(action)
				if action ~= nil then
					_A_w.Visible = true
					_HRU9.Visible = true
					_M_9.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _jJv_5:OnExit()
	_n1_ = _CyO("\088\118\102\089\088\109")
	_Urwigo.GlobalZoneExit()
end
function _ZbNvM:OnEnter()
	_n1_ = _CyO("\088\045\042\031\089\123")
	_Urwigo.GlobalZoneEnter()
	if Player:Contains(_VWeG) then
		_Urwigo.MessageBox{
			Text = _CyO("\051\033\010\101\063\105\033\063\121\063\077\041\041\091\063\086\033\051\063\037\010\010\113\063\027\041\112\010\113\121"), 
			Media = _Oxrf4, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _Ufh71)
				end
			end
		}
		_ahL8 = _ahL8 + 1
		_VWeG:MoveTo(_Ufh71)
	else
		_Urwigo.MessageBox{
			Text = _CyO("\102\010\063\077\010\042\112\063\086\033\051\063\051\010\010\086\063\027\041\112\010\113\063\042\007\118\127\063\023\041\063\010\113\063\089\091\044\051\063\077\041\091\010\086\063\042\007\118\063\101\010\063\042\113\033\086\127"), 
			Media = _gPWg0, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _Ufh71)
				end
			end
		}
	end
end
function _ZbNvM:OnExit()
	_n1_ = _CyO("\088\045\042\031\089\123")
	_Urwigo.GlobalZoneExit()
end
function _Ckd4:OnEnter()
	_n1_ = _CyO("\088\052\069\101\065")
	_Urwigo.GlobalZoneEnter()
	_hwY6m.Active = true
	_hwY6m.Visible = true
	_Urwigo.MessageBox{
		Text = _CyO("\126\113\007\037\041\121\063\026\033\010\063\105\033\063\089\010\113\101\010\113\127"), 
		Media = _Oxrf4, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _hwY6m)
			end
		end
	}
	_Ckd4.Active = false
	_Ckd4.Visible = false
end
function _Ckd4:OnExit()
	_n1_ = _CyO("\088\052\069\101\065")
	_Urwigo.GlobalZoneExit()
end
function _agN:OnEnter()
	_n1_ = _CyO("\088\041\051\031")
	_Urwigo.GlobalZoneEnter()
	_Urwigo.MessageBox{
		Text = _CyO("\004\112\010\010\069\063\077\007\010\113\063\101\010\063\004\112\113\041\041\112\063\033\089\010\113\063\010\086\063\089\033\091\051\063\118\010\063\113\033\044\112\010\063\091\041\086\051\004\063\101\010\063\089\007\118\089\010\113\063\010\086\063\041\057\077\112\010\113\063\077\010\112\063\038\010\051\007\118\086\112\118\010\004\042\041\101\127")
	}
end
function _agN:OnExit()
	_n1_ = _CyO("\088\041\051\031")
	_Urwigo.GlobalZoneExit()
end
function _d6R:OnSetComplete()
	_3j_sz.Active = true
	_3j_sz.Visible = true
end
function _3j_sz:OnSetComplete()
	_4snVf.Active = true
	_4snVf.Visible = true
end
function _4snVf:OnSetComplete()
	_Z0Bok.Active = true
	_Z0Bok.Visible = true
end
function _Z0Bok:OnSetComplete()
	_AdIwn.Active = true
	_AdIwn.Visible = true
end
function _0ugr_:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_n4ha = input
	if Wherigo.NoCaseEquals(_n4ha, _CyO("\067\109\065\043")) then
		_2PK:MoveTo(Player)
		_Urwigo.MessageBox{
			Text = _CyO("\034\010\091\010\037\041\041\091\063\057\033\113\113\010\057\112\127\063\020\069\063\042\010\091\033\033\086\063\118\010\063\069\010\086\086\007\004\063\037\010\112\063\010\010\086\063\078\007\086\041\086\057\007\010\091\010\063\042\007\118\101\113\041\051\010\127\063\026\010\105\010\063\105\041\091\063\118\010\063\091\041\112\010\113\063\086\033\101\007\051\063\077\010\042\042\010\086\127\063\023\041\063\101\041\101\010\091\007\118\069\063\101\033\033\113\063\086\041\041\113\063\083\033\091\077\010\007\101\010\127"), 
			Media = _shmaY, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _2IA9u)
				end
			end
		}
		_2IA9u.Active = true
		_2IA9u.Visible = true
		_QtR.Visible = false
		_QtR.Active = false
		_HTS.Active = true
	else
		_Urwigo.MessageBox{
			Text = _CyO("\031\007\010\112\063\118\044\007\004\112\008\063\077\010\112\063\027\041\004\063\067\109\065\043\127\063\020\069\063\069\041\086\063\118\010\063\086\007\010\112\063\042\010\091\033\086\010\086\127\063\023\041\063\101\033\033\113\063\086\041\041\113\063\077\010\112\063\052\033\086\007\086\069\107\077\044\007\004\127"), 
			Media = _shmaY, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _HTS)
				end
			end
		}
		_HTS.Active = true
		_HTS.Visible = true
		_QtR.Visible = false
		_QtR.Active = false
	end
end
function _jieF:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_LZth = input
	if _Urwigo.Hash(string.lower(input)) == 55676 then
		_Urwigo.MessageBox{
			Text = _CyO("\102\044\007\004\112\008\063\118\010\063\069\113\007\118\051\112\063\101\010\063\101\113\044\007\089\010\086\004\033\033\113\112\063\052\041\086\033\086\063\034\041\091\091\127"), 
			Media = _Oxrf4, 
			Callback = function(action)
				if action ~= nil then
					_38F:MoveTo(Player)
					_aVc.Active = true
					_aVc.Visible = true
					_2a88I.Visible = false
					_Urwigo.MessageBox{
						Text = _CyO("\023\041\063\101\033\033\113\063\101\010\063\101\044\042\042\010\091\010\063\101\010\044\113\063\010\086\063\101\041\041\091\063\041\078\063\101\033\033\113\063\037\007\118\086\063\112\044\007\086\127"), 
						Media = _shmaY, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _aVc)
							end
						end
					}
				end
			end
		}
		_38F.Commands._uOQh.Enabled = false
		_Uopj = _Uopj + 1
		_3j_sz.Complete = true
	else
		_38F:MoveTo(nil)
		_Urwigo.MessageBox{
			Text = _CyO("\019\033\044\112\008\063\077\010\112\063\057\033\113\113\010\057\112\010\063\041\086\112\027\033\033\113\101\063\007\004\063\051\010\042\113\033\010\113\101\010\113\004\063\026\041\086\077\007\010\044\107\127"), 
			Media = _gPWg0, 
			Callback = function(action)
				if action ~= nil then
					_aVc.Active = true
					_aVc.Visible = true
					_2a88I.Visible = false
					_Urwigo.MessageBox{
						Text = _CyO("\023\041\063\101\033\033\113\063\101\010\063\101\044\042\042\010\091\010\063\101\010\044\113\063\010\086\063\101\041\041\091\063\041\078\063\101\033\033\113\063\037\007\118\086\063\112\044\007\086\127"), 
						Media = _shmaY, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _aVc)
							end
						end
					}
				end
			end
		}
	end
end
function _fdl_:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_BdmFN = input
	if _Urwigo.Hash(string.lower(input)) == 20065 then
		_Urwigo.MessageBox{
			Text = _CyO("\102\044\007\004\112\008\063\118\010\063\069\113\007\118\051\112\063\101\010\063\101\113\044\007\089\010\086\004\033\033\113\112\063\071\033\068\041\091\127"), 
			Media = _Oxrf4, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _38F)
				end
			end
		}
		_J8Z.Commands._127LE.Enabled = false
		_J8Z:MoveTo(Player)
		_Uopj = _Uopj + 1
		_3j_sz.Complete = true
	else
		_Urwigo.MessageBox{
			Text = _CyO("\019\033\044\112\008\063\077\010\112\063\057\033\113\113\010\057\112\010\063\041\086\112\027\033\033\113\101\063\007\004\063\071\033\068\041\091\127"), 
			Media = _gPWg0, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _38F)
				end
			end
		}
		_J8Z:MoveTo(nil)
	end
end
function _uxh:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_F7z = input
	if _Urwigo.Hash(string.lower(input)) == 60274 then
		_Urwigo.MessageBox{
			Text = _CyO("\102\044\007\004\112\008\063\118\010\063\069\113\007\118\051\112\063\101\010\063\101\113\044\007\089\010\086\004\033\033\113\112\063\058\010\033\002\033\091\101\063\020\020\020\127"), 
			Media = _Oxrf4, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _J8Z)
				end
			end
		}
		_rOss.Commands._UaL.Enabled = false
		_rOss:MoveTo(Player)
		_Uopj = _Uopj + 1
		_3j_sz.Complete = true
	else
		_Urwigo.MessageBox{
			Text = _CyO("\019\033\044\112\008\063\077\010\112\063\057\033\113\113\010\057\112\010\063\041\086\112\027\033\033\113\101\063\007\004\063\101\113\044\007\089\010\086\112\010\091\010\113\004\127"), 
			Media = _gPWg0, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _J8Z)
				end
			end
		}
		_rOss:MoveTo(nil)
	end
end
function _G6Lm:OnTick()
	Wherigo.PlayAudio(_I36y)
	_Urwigo.MessageBox{
		Text = (_CyO("\126\113\033\078\007\057\007\041\112\008\063\118\010\063\077\041\041\091\101\010\060\038\071\099").._ahL8).._CyO("\063\010\037\037\010\113\117\004\015\063\027\041\112\010\113\063\033\002\127"), 
		Media = _Oxrf4, 
		Callback = function(action)
			if action ~= nil then
				if _ahL8 < 2 then
					_Urwigo.MessageBox{
						Text = _CyO("\102\010\063\069\113\007\118\051\112\063\089\041\086\063\037\007\118\063\010\010\086\063\051\007\010\112\010\113\127"), 
						Media = _rkY, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _CyO("\023\041\063\086\044\063\086\041\041\113\063\101\010\063\042\010\051\007\118\086\077\033\078\069\041\002\010\091\127"), 
									Media = _rkY, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _GRSV)
										end
									end
								}
							end
						end
					}
					_s5t_:MoveTo(Player)
				elseif _ahL8 == 2 then
					_Urwigo.MessageBox{
						Text = _CyO("\102\010\063\069\113\007\118\051\112\063\089\041\086\063\037\007\118\063\010\010\086\063\113\010\051\010\086\112\033\086\127"), 
						Media = _rkY, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _CyO("\023\041\063\086\044\063\086\041\041\113\063\101\010\063\042\010\051\007\118\086\077\033\078\069\041\002\010\091\127"), 
									Media = _rkY, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _GRSV)
										end
									end
								}
							end
						end
					}
					_CPG:MoveTo(Player)
				elseif _ahL8 > 2 then
					_Urwigo.MessageBox{
						Text = _CyO("\102\010\063\069\113\007\118\051\112\063\089\041\086\063\037\007\118\063\010\010\086\063\042\010\113\010\051\010\086\007\086\051\004\068\004\112\010\010\037\063\089\033\033\113\063\007\086\063\118\010\063\004\010\113\113\010\127"), 
						Media = _rkY, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _CyO("\023\041\063\086\044\063\086\041\041\113\063\101\010\063\042\010\051\007\118\086\077\033\078\069\041\002\010\091\127"), 
									Media = _rkY, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _GRSV)
										end
									end
								}
							end
						end
					}
					_3y7V:MoveTo(Player)
				end
			end
		end
	}
	_Ufh71.Active = false
	_Ufh71.Visible = false
	_ZbNvM.Active = false
	_ZbNvM.Visible = false
	_GRSV.Active = true
	_GRSV.Visible = true
	_VWeG:MoveTo(nil)
end
function _1lw:OnTick()
	_jcvz.Active = false
	_P7a.Active = false
	_lPQRV.Active = false
	_62V.Active = false
	_2wi8T.Active = false
	_s6XT.Active = false
	_Urwigo.Dialog(false, {
		{
			Text = (_CyO("\102\010\063\112\007\118\101\063\007\004\063\033\002\127\063\102\010\063\069\086\007\002\112\010\063").._309uY).._CyO("\063\069\091\010\007\086\010\063\101\113\044\007\089\010\086\063\027\010\051\127"), 
			Media = _tmPA
		}, 
		{
			Text = _CyO("\123\007\118\086\063\042\113\033\010\113\063\077\010\010\078\112\063\101\113\007\086\051\010\086\101\063\077\044\091\002\063\086\033\101\007\051\063\033\002\063\101\010\063\004\010\113\113\010\004\063\042\033\089\010\086\063\033\002\063\101\010\105\010\063\105\044\007\101\010\113\078\091\041\086\069\127\063\023\041\063\077\010\037\063\004\086\010\091\063\077\010\091\002\010\086\127\063\100\033\091\051\063\101\010\063\027\010\051\063\086\041\041\113\063\042\033\089\010\086\127"), 
			Media = _tmPA, 
			Buttons = {
				_CyO("\089\010\113\101\010\113\063\101\033\033\113"), 
				_CyO("\069\033\113\112\010\063\113\033\044\112\010")
			}
		}
	}, function(action)
		_raQ.Visible = true
		_Z0Bok.Complete = true
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _raQ)
		_raQ.Active = true
	end)
end
function _eWM4u:On_s5Ww(target)
	_4snVf.Complete = true
	_eWM4u:MoveTo(nil)
	_Urwigo.MessageBox{
		Text = _CyO("\083\112\041\002\063\089\010\113\101\010\113\063\091\041\086\051\004\063\101\010\063\042\113\033\044\027\010\113\007\118\063\086\041\041\113\063\101\010\063\020\118\004\010\127"), 
		Media = _Oxrf4, 
		Callback = function(action)
			if action ~= nil then
				_aVc.Active = false
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _MXlwz)
			end
		end
	}
end
function _rOss:On_UaL(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_uxh)
	end)
end
function _J8Z:On_127LE(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_fdl_)
	end)
end
function _38F:On_uOQh(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_jieF)
	end)
end
function _Urwigo.GlobalZoneEnter()
	Wherigo.PlayAudio(_I36y)
end
function _Urwigo.GlobalZoneExit()
	_XA1jk:RequestSync()
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _XA1jk
