require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartPlayAnywhereDemo = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartPlayAnywhereDemo.MsgBoxCBFuncs = {}

-- Cartridge Info --
cartPlayAnywhereDemo.Id="7f7db1c6-815a-4376-bce4-0fe2e6366013"
cartPlayAnywhereDemo.Name="PlayAnywhereDemo"
cartPlayAnywhereDemo.Description=[[]]
cartPlayAnywhereDemo.Visible=true
cartPlayAnywhereDemo.Activity="TourGuide"
cartPlayAnywhereDemo.StartingLocationDescription=[[]]
cartPlayAnywhereDemo.StartingLocation = Wherigo.INVALID_ZONEPOINT
cartPlayAnywhereDemo.Version=""
cartPlayAnywhereDemo.Company=""
cartPlayAnywhereDemo.Author="Ranger Fox"
cartPlayAnywhereDemo.BuilderVersion="2.0.5129.5086"
cartPlayAnywhereDemo.CreateDate="5/13/2019 6:58:44 PM"
cartPlayAnywhereDemo.PublishDate="1/1/0001 12:00:00 AM"
cartPlayAnywhereDemo.UpdateDate="5/13/2019 8:03:31 PM"
cartPlayAnywhereDemo.LastPlayedDate="1/1/0001 12:00:00 AM"
cartPlayAnywhereDemo.TargetDevice="PocketPC"
cartPlayAnywhereDemo.TargetDeviceVersion="0"
cartPlayAnywhereDemo.StateId="1"
cartPlayAnywhereDemo.CountryId="2"
cartPlayAnywhereDemo.Complete=false
cartPlayAnywhereDemo.UseLogging=false

-- Zones --
zoneNorthGoal = Wherigo.Zone(cartPlayAnywhereDemo)
zoneNorthGoal.Id="e301df5d-41a2-4c96-97f9-957de43c9a78"
zoneNorthGoal.Name="North Goal"
zoneNorthGoal.Description=[[]]
zoneNorthGoal.Visible=true
zoneNorthGoal.DistanceRange = Distance(-1, "feet")
zoneNorthGoal.ShowObjects="OnEnter"
zoneNorthGoal.ProximityRange = Distance(200, "feet")
zoneNorthGoal.AllowSetPositionTo=false
zoneNorthGoal.Active=true
zoneNorthGoal.Points = {
  ZonePoint(51.43012,-0.42641,0),
  ZonePoint(51.43012,-0.42629,0),
  ZonePoint(51.43004,-0.42629,0),
  ZonePoint(51.43004,-0.42641,0)
}
zoneNorthGoal.OriginalPoint = ZonePoint(51.430079,-0.426349,0)
zoneNorthGoal.DistanceRangeUOM = "Feet"
zoneNorthGoal.ProximityRangeUOM = "Feet"
zoneNorthGoal.OutOfRangeName = ""
zoneNorthGoal.InRangeName = ""

zoneSouthGoal = Wherigo.Zone(cartPlayAnywhereDemo)
zoneSouthGoal.Id="b199f821-dee2-4f16-8eb8-2d4739f3090d"
zoneSouthGoal.Name="South Goal"
zoneSouthGoal.Description=[[]]
zoneSouthGoal.Visible=true
zoneSouthGoal.DistanceRange = Distance(-1, "feet")
zoneSouthGoal.ShowObjects="OnEnter"
zoneSouthGoal.ProximityRange = Distance(200, "feet")
zoneSouthGoal.AllowSetPositionTo=false
zoneSouthGoal.Active=true
zoneSouthGoal.Points = {
  ZonePoint(51.42932,-0.42666,0),
  ZonePoint(51.42932,-0.42654,0),
  ZonePoint(51.42924,-0.42654,0),
  ZonePoint(51.42924,-0.42666,0)
}
zoneSouthGoal.OriginalPoint = ZonePoint(51.429279,-0.4266,0)
zoneSouthGoal.DistanceRangeUOM = "Feet"
zoneSouthGoal.ProximityRangeUOM = "Feet"
zoneSouthGoal.OutOfRangeName = ""
zoneSouthGoal.InRangeName = ""

zoneGeocache = Wherigo.Zone(cartPlayAnywhereDemo)
zoneGeocache.Id="8258d29d-f9a0-4428-ac6e-2b77b8a0c5db"
zoneGeocache.Name="Geocache"
zoneGeocache.Description=[[]]
zoneGeocache.Visible=true
zoneGeocache.DistanceRange = Distance(-1, "feet")
zoneGeocache.ShowObjects="OnEnter"
zoneGeocache.ProximityRange = Distance(200, "feet")
zoneGeocache.AllowSetPositionTo=false
zoneGeocache.Active=false
zoneGeocache.Points = {
  ZonePoint(-0.95237,-90.96235,0),
  ZonePoint(-0.95237,-90.96228,0),
  ZonePoint(-0.95229,-90.96228,0),
  ZonePoint(-0.95229,-90.96235,0)
}
zoneGeocache.OriginalPoint = ZonePoint(51.429533,-0.425929,0)
zoneGeocache.DistanceRangeUOM = "Feet"
zoneGeocache.ProximityRangeUOM = "Feet"
zoneGeocache.OutOfRangeName = ""
zoneGeocache.InRangeName = ""

-- Characters --

-- Items --
zitemUtils = Wherigo.ZItem(cartPlayAnywhereDemo)
zitemUtils.Id="b778118c-db9c-41ad-85b4-9504a1f41f76"
zitemUtils.Name="Utils"
zitemUtils.Description=[[When you want to set the cartridge's center, use this item.]]
zitemUtils.Visible=true
zitemUtils.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemUtils.Locked = false
zitemUtils.Opened = false
zitemUtils.Commands = {
  SetCenter = Wherigo.ZCommand{Text="Set Center", CmdWith=false, Enabled=true},
}
zitemUtils.Commands.SetCenter.Custom = true
zitemUtils.Commands.SetCenter.Id="8e640115-ef45-4ba6-9b05-7b370612b8a1"
zitemUtils.Commands.SetCenter.WorksWithAll = true

-- Tasks --

-- Cartridge Variables --
DoPlayAnywhere = false
cartPlayAnywhereDemo.ZVariables = {DoPlayAnywhere = false}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.DoPlayAnywhere = {}
buildervar.DoPlayAnywhere.Id ="07d6b5c1-6717-492d-adf6-0b6ad7f6bf38"
buildervar.DoPlayAnywhere.Name = "DoPlayAnywhere"
buildervar.DoPlayAnywhere.Type = "Flag"
buildervar.DoPlayAnywhere.Data=[[False]]
buildervar.DoPlayAnywhere.Description=[[]]


-- ZTimers --
ztimerPlayAnywhereTimer = Wherigo.ZTimer(cartPlayAnywhereDemo)
ztimerPlayAnywhereTimer.Id="407095a2-727b-434c-977a-9d9528a96b2e"
ztimerPlayAnywhereTimer.Name="PlayAnywhereTimer"
ztimerPlayAnywhereTimer.Description=[[Needed for the emulator.]]
ztimerPlayAnywhereTimer.Visible=true
ztimerPlayAnywhereTimer.Duration=2
ztimerPlayAnywhereTimer.Type="Countdown"

-- Inputs --

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --

function cartPlayAnywhereDemo:OnStart()
-- #GroupDescription=Script --
-- #Comment=Script Comment --

--A timer is used because the emulator takes one second to set Player.ObjectLocation.  Usually, real apps will not have that issue.
ztimerPlayAnywhereTimer:Start()
zitemUtils:MoveTo(Player)

end

function ztimerPlayAnywhereTimer:OnTick()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
MakeCartridgePlayAnywhere()
end


function zitemUtils:OnSetCenter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
MakeCartridgePlayAnywhere()
end


function MakeCartridgePlayAnywhere()

  local zcart = cartPlayAnywhereDemo

  local newCentroid = Player.ObjectLocation
  local oldCentroid = ZonePoint(51.429678,-0.426465,0) --This was the original starting location for this cartridge

  if zcart.StartingLocation ~= Wherigo.INVALID_ZONEPOINT then
    oldCentroid = zcart.StartingLocation
  end

  zcart.StartingLocation = newCentroid

  print("Player Location: " .. Player.ObjectLocation.latitude .. ", " .. Player.ObjectLocation.longitude)

  MoveZonesRelativeToCentroid(zcart, newCentroid, oldCentroid)

end

function MoveZonesRelativeToCentroid(zcart, newCentroid, oldCentroid)

 local allZones = zcart:GetAllOfType('Zone')
 local previousStates = {}
 for _,zone in ipairs(allZones) do
  if zone ~= nil then
	MoveZoneRelativeToCentroid(zone, newCentroid, oldCentroid)
  end
 end

end


function MoveZoneRelativeToCentroid(zone, newCentroid, oldCentroid)

  --Determine the offset from the old centroid
  local dist,bearing = Wherigo.VectorToPoint(oldCentroid, zone.OriginalPoint)

  --Get coordinates based off the the offset to the new centroid
  local newZoneCenter = Wherigo.TranslatePoint(newCentroid, dist, bearing)

  --print("Old centroid for " .. zone.Name .. ": " .. oldCentroid.latitude .. ", " .. oldCentroid.longitude)
  --print("Dist " .. dist("km") .. ", bearing " .. bearing)
  --print("New center: " .. newZoneCenter.latitude .. ", " .. newZoneCenter.longitude)

  CenterZoneOnPoint(zone, 10, newZoneCenter)

end


--Moves the zone to a ZonePoint.  This is used to prime all zones
function CenterZoneOnPoint(zZone, radius, point)
  local dist = Wherigo.Distance(radius, "m")
  local newZp = Wherigo.TranslatePoint(point, dist, 0)   -- new center point for the new zone
  zZone.OriginalPoint = point
  local pts = {
    Wherigo.TranslatePoint(newZp, dist, 45),
    Wherigo.TranslatePoint(newZp, dist, 135),
    Wherigo.TranslatePoint(newZp, dist, 225),
    Wherigo.TranslatePoint(newZp, dist, 315),
  }

  local wasActive = zZone.Active
  zZone.Active = true --to process the zone update
  zZone.OriginalPoint = newZp
  zZone.Points = pts
  zZone.Active = wasActive
end 
-- #End Author Functions# --
-- Nothing after this line --
return cartPlayAnywhereDemo
