require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _KfU(str)
	local res = ""
    local dtable = "\053\072\025\058\083\017\014\098\036\105\011\021\110\019\109\000\035\059\008\106\037\118\057\087\077\049\076\016\089\069\116\114\064\043\003\092\022\097\124\085\091\004\041\084\120\044\095\099\061\034\030\113\023\026\056\006\094\054\104\067\046\071\018\038\088\123\060\065\020\119\052\024\042\075\063\027\082\107\013\009\090\080\047\073\005\117\015\066\040\033\007\101\112\093\111\125\102\051\079\048\001\068\096\012\100\028\002\078\032\070\010\045\115\121\081\103\108\029\039\126\055\074\062\031\086\122\050"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

objCOBombis = Wherigo.ZCartridge()

-- Media --
objPlateaudechenove = Wherigo.ZMedia(objCOBombis)
objPlateaudechenove.Id = "9d786ffa-0157-46b6-9e1b-713816d1b780"
objPlateaudechenove.Name = _KfU("\082\117\038\031\092\038\086\109\105\092\109\048\059\092\013\095\022\092")
objPlateaudechenove.Description = ""
objPlateaudechenove.AltText = ""
objPlateaudechenove.Resources = {
	{
		Type = "jpg", 
		Filename = "plateau1.jpg", 
		Directives = {}
	}
}
objb1 = Wherigo.ZMedia(objCOBombis)
objb1.Id = "e37029e6-8136-4436-bf52-6c37d0fd4b48"
objb1.Name = _KfU("\008\026")
objb1.Description = ""
objb1.AltText = ""
objb1.Resources = {
	{
		Type = "JPG", 
		Filename = "b1.JPG", 
		Directives = {}
	}
}
objb2 = Wherigo.ZMedia(objCOBombis)
objb2.Id = "09c6172f-df6c-4309-8d22-ad5d1e89db9b"
objb2.Name = _KfU("\008\127")
objb2.Description = ""
objb2.AltText = ""
objb2.Resources = {
	{
		Type = "JPG", 
		Filename = "b2.JPG", 
		Directives = {}
	}
}
objb3 = Wherigo.ZMedia(objCOBombis)
objb3.Id = "92e715cd-8ddc-4661-bda5-269c2b573d5c"
objb3.Name = _KfU("\008\098")
objb3.Description = ""
objb3.AltText = ""
objb3.Resources = {
	{
		Type = "JPG", 
		Filename = "b3.JPG", 
		Directives = {}
	}
}
objb4 = Wherigo.ZMedia(objCOBombis)
objb4.Id = "a857a01f-2f4a-48a7-80bd-cd0bf285d4f6"
objb4.Name = _KfU("\008\071")
objb4.Description = ""
objb4.AltText = ""
objb4.Resources = {
	{
		Type = "JPG", 
		Filename = "b4.JPG", 
		Directives = {}
	}
}
objb5 = Wherigo.ZMedia(objCOBombis)
objb5.Id = "c0f3b77d-bbc4-4409-b385-e78e003a5447"
objb5.Name = _KfU("\008\001")
objb5.Description = ""
objb5.AltText = ""
objb5.Resources = {
	{
		Type = "JPG", 
		Filename = "b5.JPG", 
		Directives = {}
	}
}
-- Cartridge Info --
objCOBombis.Id="e433bc5d-f1b6-4436-b049-acdee48c407b"
objCOBombis.Name="CO Bombis"
objCOBombis.Description=[[Petite course d'orientation sur le plateau de chenove]]
objCOBombis.Visible=true
objCOBombis.Activity="Geocache"
objCOBombis.StartingLocationDescription=[[Depart sur le parcours de sante du plateau]]
objCOBombis.StartingLocation = ZonePoint(47.2944811299813,4.99357983469963,0)
objCOBombis.Version="1.3"
objCOBombis.Company=""
objCOBombis.Author="Titan21"
objCOBombis.BuilderVersion="URWIGO 1.14.4469.18959"
objCOBombis.CreateDate="09/15/2012 12:03:03"
objCOBombis.PublishDate="1/1/0001 12:00:00 AM"
objCOBombis.UpdateDate="09/21/2012 18:47:05"
objCOBombis.LastPlayedDate="1/1/0001 12:00:00 AM"
objCOBombis.TargetDevice="PocketPC"
objCOBombis.TargetDeviceVersion="0"
objCOBombis.StateId="1"
objCOBombis.CountryId="2"
objCOBombis.Complete=false
objCOBombis.UseLogging=true

objCOBombis.Media=objPlateaudechenove


-- Zones --
objBalise1 = Wherigo.Zone(objCOBombis)
objBalise1.Id = "557ae1ae-dd2e-4513-a4f2-f62a829ddbc5"
objBalise1.Name = _KfU("\088\038\117\010\113\092\109\026")
objBalise1.Description = _KfU("\010\013\031\092\032\113\092\048\031\010\095\013\109\105\092\109\048\059\092\015\010\013\113")
objBalise1.Visible = true
objBalise1.Media = objb1
objBalise1.Commands = {}
objBalise1.DistanceRange = Distance(-1, "feet")
objBalise1.ShowObjects = "OnEnter"
objBalise1.ProximityRange = Distance(60, "meters")
objBalise1.AllowSetPositionTo = false
objBalise1.Active = false
objBalise1.Points = {
	ZonePoint(47.2958090154014, 4.99340884387493, 0), 
	ZonePoint(47.2959038362367, 4.99315671622753, 0), 
	ZonePoint(47.2961533783957, 4.99326668679714, 0), 
	ZonePoint(47.2960581923502, 4.99350272119045, 0)
}
objBalise1.OriginalPoint = ZonePoint(47.295981105596, 4.99333374202251, 0)
objBalise1.DistanceRangeUOM = "Feet"
objBalise1.ProximityRangeUOM = "Meters"
objBalise1.OutOfRangeName = ""
objBalise1.InRangeName = ""
objBalise2 = Wherigo.Zone(objCOBombis)
objBalise2.Id = "beacbd24-04e2-4a7c-856a-d69fca956d29"
objBalise2.Name = _KfU("\088\038\117\010\113\092\109\127")
objBalise2.Description = _KfU("\060\032\095\010\113\092\015\092\013\031\109\105\092\109\113\092\013\031\010\092\032\113\109\089\038\032\008\032\092\109\038\109\117\119\095\086\092\113\031\043")
objBalise2.Visible = true
objBalise2.Media = objb2
objBalise2.Commands = {}
objBalise2.DistanceRange = Distance(-1, "feet")
objBalise2.ShowObjects = "OnEnter"
objBalise2.ProximityRange = Distance(60, "meters")
objBalise2.AllowSetPositionTo = false
objBalise2.Active = false
objBalise2.Points = {
	ZonePoint(47.2995272271416, 4.99257870018482, 0), 
	ZonePoint(47.2991670858045, 4.99265380203724, 0), 
	ZonePoint(47.299156796016, 4.99292470514774, 0), 
	ZonePoint(47.2994732060974, 4.99291397631168, 0)
}
objBalise2.OriginalPoint = ZonePoint(47.2993310787649, 4.99276779592037, 0)
objBalise2.DistanceRangeUOM = "Feet"
objBalise2.ProximityRangeUOM = "Meters"
objBalise2.OutOfRangeName = ""
objBalise2.InRangeName = ""
objBalise3 = Wherigo.Zone(objCOBombis)
objBalise3.Id = "65070fdd-bf5f-4637-9518-0beefa9aeae4"
objBalise3.Name = _KfU("\088\038\117\010\113\092\109\098")
objBalise3.Description = _KfU("\122\095\013\048\031\010\095\013\109\105\092\109\113\092\013\031\010\092\032\109\089\109\068\032\008\032\092\043")
objBalise3.Visible = true
objBalise3.Media = objb3
objBalise3.Commands = {}
objBalise3.DistanceRange = Distance(-1, "feet")
objBalise3.ShowObjects = "OnEnter"
objBalise3.ProximityRange = Distance(60, "meters")
objBalise3.AllowSetPositionTo = false
objBalise3.Active = false
objBalise3.Points = {
	ZonePoint(47.2968205046695, 4.99408341944218, 0), 
	ZonePoint(47.2971059694534, 4.99421484768391, 0), 
	ZonePoint(47.2970211510578, 4.99443747103214, 0), 
	ZonePoint(47.2967896339278, 4.99438114464283, 0)
}
objBalise3.OriginalPoint = ZonePoint(47.2969343147771, 4.99427922070026, 0)
objBalise3.DistanceRangeUOM = "Feet"
objBalise3.ProximityRangeUOM = "Meters"
objBalise3.OutOfRangeName = ""
objBalise3.InRangeName = ""
objBalise4 = Wherigo.Zone(objCOBombis)
objBalise4.Id = "ca15f8c2-cdea-4dbe-873e-c2748f71b726"
objBalise4.Name = _KfU("\088\038\117\010\113\092\109\071")
objBalise4.Description = _KfU("\122\095\013\048\031\010\095\013\109\105\092\109\113\092\013\031\010\092\032\109\092\031\109\105\092\109\048\117\095\031\086\032\092\109\089\038\032\008\032\092\043")
objBalise4.Visible = true
objBalise4.Media = objb4
objBalise4.Commands = {}
objBalise4.DistanceRange = Distance(-1, "feet")
objBalise4.ShowObjects = "OnEnter"
objBalise4.ProximityRange = Distance(60, "meters")
objBalise4.AllowSetPositionTo = false
objBalise4.Active = false
objBalise4.Points = {
	ZonePoint(47.2975756897925, 4.99476872384548, 0), 
	ZonePoint(47.2975676065716, 4.99500475823879, 0), 
	ZonePoint(47.2973179207444, 4.99495916068554, 0), 
	ZonePoint(47.2973567229752, 4.9947539716959, 0)
}
objBalise4.OriginalPoint = ZonePoint(47.2974544850209, 4.99487165361643, 0)
objBalise4.DistanceRangeUOM = "Feet"
objBalise4.ProximityRangeUOM = "Meters"
objBalise4.OutOfRangeName = ""
objBalise4.InRangeName = ""
objBalise5 = Wherigo.Zone(objCOBombis)
objBalise5.Id = "6476a95c-9059-4f76-baa2-e94cad8f9d1c"
objBalise5.Name = _KfU("\088\038\117\010\113\092\109\001")
objBalise5.Description = _KfU("\060\038\048\059\092\109\089\038\032\008\032\092\043")
objBalise5.Visible = true
objBalise5.Media = objb5
objBalise5.Commands = {}
objBalise5.DistanceRange = Distance(-1, "feet")
objBalise5.ShowObjects = "OnEnter"
objBalise5.ProximityRange = Distance(60, "meters")
objBalise5.AllowSetPositionTo = false
objBalise5.Active = false
objBalise5.Points = {
	ZonePoint(47.297798142331, 4.99457158148289, 0), 
	ZonePoint(47.2980334002073, 4.99445892870426, 0), 
	ZonePoint(47.2981535006511, 4.99471373856068, 0), 
	ZonePoint(47.2978885458717, 4.99480225145817, 0)
}
objBalise5.OriginalPoint = ZonePoint(47.2979683972653, 4.9946366250515, 0)
objBalise5.DistanceRangeUOM = "Feet"
objBalise5.ProximityRangeUOM = "Meters"
objBalise5.OutOfRangeName = ""
objBalise5.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --
objQuete = Wherigo.ZTask(objCOBombis)
objQuete.Id = "c15c7df1-c241-45af-8c0b-53ed919cb1ca"
objQuete.Name = _KfU("\115\086\092\031\092")
objQuete.Description = _KfU("\077\092\031\032\095\086\022\092\032\109\117\092\113\109\048\095\105\092\113\109\105\092\109\048\095\086\032\113\092\109\105\119\095\032\010\092\013\031\038\031\010\095\013\109\113\086\032\109\048\092\109\113\010\031\092\109\032\092\015\038\032\052\086\038\008\117\092\061\109\084\117\113\109\022\095\086\113\109\015\092\013\092\032\095\013\031\109\038\109\117\038\109\048\038\048\059\092\109\090")
objQuete.Visible = true
objQuete.Active = false
objQuete.Complete = false
objQuete.CorrectState = "None"

-- Cartridge Variables --
objRep_codes = ""
currentZone = _KfU("\095\008\020\088\038\117\010\113\092\026")
currentCharacter = _KfU("\105\086\015\015\114")
currentItem = _KfU("\105\086\015\015\114")
currentTask = _KfU("\095\008\020\115\086\092\031\092")
currentInput = _KfU("\095\008\020\088\038\117\010\113\092\026\047\026")
currentTimer = _KfU("\095\008\020\060\059\032\095\013\095")
objCOBombis.ZVariables = {
	objRep_codes = "", 
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\026"), 
	currentCharacter = _KfU("\105\086\015\015\114"), 
	currentItem = _KfU("\105\086\015\015\114"), 
	currentTask = _KfU("\095\008\020\115\086\092\031\092"), 
	currentInput = _KfU("\095\008\020\088\038\117\010\113\092\026\047\026"), 
	currentTimer = _KfU("\095\008\020\060\059\032\095\013\095")
}

-- Timers --
objChrono = Wherigo.ZTimer(objCOBombis)
objChrono.Id = "a12bb7b3-2ca3-49f9-8ec9-30b1a35bd157"
objChrono.Name = _KfU("\060\059\032\095\013\095")
objChrono.Description = ""
objChrono.Visible = true
objChrono.Duration = 0
objChrono.Type = "Interval"

-- Inputs --
objBalise1_1 = Wherigo.ZInput(objCOBombis)
objBalise1_1.Id = "1022f373-b800-4c64-88e1-a3fc3b5aab9c"
objBalise1_1.Name = _KfU("\088\038\117\010\113\092\109\026")
objBalise1_1.Description = ""
objBalise1_1.Visible = true
objBalise1_1.InputType = "Text"
objBalise1_1.Text = _KfU("\060\095\105\092\109\075")
objbalise2 = Wherigo.ZInput(objCOBombis)
objbalise2.Id = "73d04e95-ae5c-4421-804d-8ed34c136a7d"
objbalise2.Name = _KfU("\008\038\117\010\113\092\109\127")
objbalise2.Description = _KfU("\010\013\031\092\032\113\092\048\031\010\095\013\109\105\092\109\105\092\086\045\109\048\059\092\015\010\013\113")
objbalise2.Visible = true
objbalise2.InputType = "Text"
objbalise2.Text = _KfU("\060\095\105\092\109\075")
objBalise4_1 = Wherigo.ZInput(objCOBombis)
objBalise4_1.Id = "27374974-fdc9-48dc-8ed8-64654b92a8fb"
objBalise4_1.Name = _KfU("\088\038\117\010\113\092\109\071")
objBalise4_1.Description = ""
objBalise4_1.Visible = true
objBalise4_1.InputType = "Text"
objBalise4_1.Text = _KfU("\060\095\105\092\109\075")
objBalise3_1 = Wherigo.ZInput(objCOBombis)
objBalise3_1.Id = "ecf0eb7a-e88c-47df-a69e-6a9a177c251d"
objBalise3_1.Name = _KfU("\088\038\117\010\113\092\109\098")
objBalise3_1.Description = ""
objBalise3_1.Visible = true
objBalise3_1.InputType = "Text"
objBalise3_1.Text = _KfU("\060\095\105\092\109\075")
objBalise5_1 = Wherigo.ZInput(objCOBombis)
objBalise5_1.Id = "8db64476-c6fd-4561-80d3-b8ad7819d650"
objBalise5_1.Name = _KfU("\088\038\117\010\113\092\109\001")
objBalise5_1.Description = ""
objBalise5_1.Visible = true
objBalise5_1.InputType = "Text"
objBalise5_1.Text = _KfU("\060\095\105\092\109\105\038\013\113\109\117\038\109\048\038\048\059\092\109\075")

-- WorksWithList for object commands --

-- functions --
function objCOBombis:OnStart()
	if (_G[_KfU("\030\013\022")][_KfU("\082\117\038\031\097\095\032\015")] == _KfU("\024\010\013\098\127")) or (_G[_KfU("\030\013\022")][_KfU("\102\092\022\010\048\092\084\102")] == _KfU("\102\092\113\078\031\095\093")) then
		for k, v in pairs(_G[_KfU("\095\008\020\060\099\088\095\015\008\010\113")][_KfU("\068\117\117\081\099\008\020\092\048\031\113")]) do
			v[_KfU("\125\010\113\010\008\117\092")] = false
			v[_KfU("\068\048\031\010\022\092")] = false
		end
		_G[_KfU("\024\059\092\032\010\116\095")][_KfU("\060\095\015\015\038\013\105")](_KfU("\005\038\022\092\060\117\095\113\092"))
		return
	end
	objBalise1.Active = true
	objQuete.Active = true
end
function objCOBombis:OnRestore()
end
function objBalise1:OnEnter()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\026")
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objBalise1_1)
	end)
end
function objBalise1:OnExit()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\026")
	objCOBombis:RequestSync()
end
function objBalise2:OnEnter()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\127")
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objbalise2)
	end)
end
function objBalise2:OnExit()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\127")
	objCOBombis:RequestSync()
end
function objBalise3:OnEnter()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\098")
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objBalise3_1)
	end)
end
function objBalise3:OnExit()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\098")
	objCOBombis:RequestSync()
end
function objBalise4:OnEnter()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\071")
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objBalise4_1)
	end)
end
function objBalise4:OnExit()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\071")
	objCOBombis:RequestSync()
end
function objBalise5:OnEnter()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\001")
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objBalise5_1)
	end)
end
function objBalise5:OnExit()
	currentZone = _KfU("\095\008\020\088\038\117\010\113\092\001")
	Wherigo.Command "SaveClose"
end
function objBalise1_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objRep_codes = input
	if Wherigo.NoCaseEquals(objRep_codes, _KfU("\068\074\071\121")) then
		objBalise2.Active = true
		_Urwigo.MessageBox{
			Text = _KfU("\088\032\038\022\095\109\112\109\030\013\109\032\095\086\031\092\109\093\095\086\032\109\117\038\109\008\038\117\010\113\092\109\127\109\090")
		}
	else
		_Urwigo.MessageBox{
			Text = _KfU("\060\092\109\013\119\092\113\031\109\093\038\113\109\117\038\109\008\095\013\013\092\109\032\092\093\095\013\113\092\109\112\109\005\095\032\031\092\126\109\092\031\109\032\092\022\092\013\092\126\109\105\038\013\113\109\117\038\109\126\095\013\092\061")
		}
	end
end
function objbalise2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objRep_codes = input
	if Wherigo.NoCaseEquals(objRep_codes, _KfU("\062\029\023\127")) then
		objBalise3.Active = true
		_Urwigo.MessageBox{
			Text = _KfU("\088\032\038\022\095\109\112\109\030\013\109\032\095\086\031\092\109\093\095\086\032\109\117\038\109\008\038\117\010\113\092\109\098\109\090")
		}
	else
		_Urwigo.MessageBox{
			Text = _KfU("\060\092\109\013\119\092\113\031\109\093\038\113\109\117\038\109\008\095\013\013\092\109\032\092\093\095\013\113\092\109\112\109\005\095\032\031\092\126\109\092\031\109\032\092\022\092\013\092\126\109\105\038\013\113\109\117\038\109\126\095\013\092\061")
		}
	end
end
function objBalise4_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objRep_codes = input
	if Wherigo.NoCaseEquals(objRep_codes, _KfU("\005\125\127\026")) then
		objBalise5.Active = true
		_Urwigo.MessageBox{
			Text = _KfU("\088\032\038\022\095\109\112\109\030\013\109\032\095\086\031\092\109\093\095\086\032\109\117\038\109\048\038\048\059\092\109\090")
		}
	else
		_Urwigo.MessageBox{
			Text = _KfU("\060\092\109\013\119\092\113\031\109\093\038\113\109\117\038\109\008\095\013\013\092\109\032\092\093\095\013\113\092\109\112\109\005\095\032\031\092\126\109\092\031\109\032\092\022\092\013\092\126\109\105\038\013\113\109\117\038\109\126\095\013\092\061")
		}
	end
end
function objBalise3_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objRep_codes = input
	if Wherigo.NoCaseEquals(objRep_codes, _KfU("\025\084\121\058")) then
		objBalise4.Active = true
		_Urwigo.MessageBox{
			Text = _KfU("\088\032\038\022\095\109\112\109\030\013\109\032\095\086\031\092\109\093\095\086\032\109\117\038\109\008\038\117\010\113\092\109\071\109\090")
		}
	else
		_Urwigo.MessageBox{
			Text = _KfU("\060\092\109\013\119\092\113\031\109\093\038\113\109\117\038\109\008\095\013\013\092\109\032\092\093\095\013\113\092\109\112\109\005\095\032\031\092\126\109\092\031\109\032\092\022\092\013\092\126\109\105\038\013\113\109\117\038\109\126\095\013\092\061")
		}
	end
end
function objBalise5_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objRep_codes = input
	if Wherigo.NoCaseEquals(objRep_codes, _KfU("\002\102\026\098")) then
		_Urwigo.MessageBox{
			Text = _KfU("\088\032\038\022\095\109\112\109\084\117\109\032\092\113\031\092\109\093\117\086\113\109\052\086\119\038\109\117\095\116\116\092\032\109\090")
		}
	else
		_Urwigo.MessageBox{
			Text = _KfU("\060\092\109\013\119\092\113\031\109\093\038\113\109\117\038\109\008\095\013\013\092\109\032\092\093\095\013\113\092\109\112\109\005\095\032\031\092\126\109\092\031\109\032\092\022\092\013\092\126\109\105\038\013\113\109\117\038\109\126\095\013\092\061")
		}
	end
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return objCOBombis
