require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _OM3wC(str)
	local res = ""
    local dtable = "\097\057\071\115\053\090\110\041\028\113\103\013\126\008\108\032\060\124\015\011\058\100\079\086\084\010\120\019\116\034\043\001\102\055\039\075\074\059\040\080\095\089\111\022\067\081\031\021\048\018\078\000\037\091\106\085\054\072\099\062\017\096\036\003\029\073\026\098\125\122\109\104\042\076\047\014\038\077\061\033\050\044\064\107\002\025\024\004\027\065\087\093\045\101\012\066\070\035\121\119\083\016\030\006\094\007\009\049\023\063\105\068\092\082\118\123\088\114\112\046\052\051\020\069\056\117\005"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_REJ = Wherigo.ZCartridge()

-- Media --
_aRb = Wherigo.ZMedia(_REJ)
_aRb.Id = "5cd6ca0e-89cc-41fc-8c74-79cf4bab1e1f"
_aRb.Name = _OM3wC("\078\043\007\004\029\094\118\041\040\072\001\004\094\041\003\126\007")
_aRb.Description = ""
_aRb.AltText = ""
_aRb.Resources = {
	{
		Type = "jpg", 
		Filename = "Monster_Phase_Gun.jpg", 
		Directives = {}
	}
}
_EpBr = Wherigo.ZMedia(_REJ)
_EpBr.Id = "10903c20-c030-4e57-9fed-2428a356abeb"
_EpBr.Name = _OM3wC("\119\084\094\041\071\094\029\094\118")
_EpBr.Description = ""
_EpBr.AltText = ""
_EpBr.Resources = {
	{
		Type = "jpg", 
		Filename = "pke_meter.jpg", 
		Directives = {}
	}
}
__CX8d = Wherigo.ZMedia(_REJ)
__CX8d.Id = "aa212dd4-9da5-4de8-8355-9d53caede3cc"
__CX8d.Name = _OM3wC("\115\001\007\041\072\094\015\004\111\007\011")
__CX8d.Description = ""
__CX8d.AltText = ""
__CX8d.Resources = {
	{
		Type = "jpg", 
		Filename = "van_helsing.jpg", 
		Directives = {}
	}
}
_HA3B = Wherigo.ZMedia(_REJ)
_HA3B.Id = "368968a5-efee-4344-bb3d-14257f439f11"
_HA3B.Name = _OM3wC("\004\015\111\071\094\118")
_HA3B.Description = ""
_HA3B.AltText = ""
_HA3B.Resources = {
	{
		Type = "jpg", 
		Filename = "slimerghost.jpg", 
		Directives = {}
	}
}
_syL = Wherigo.ZMedia(_REJ)
_syL.Id = "6805ea2b-ada2-4b88-bc23-7d2694a12d4b"
_syL.Name = _OM3wC("\071\043\007\004\029\094\118\041\001\071\071\043")
_syL.Description = ""
_syL.AltText = ""
_syL.Resources = {
	{
		Type = "jpg", 
		Filename = "ammo.jpg", 
		Directives = {}
	}
}
_XGKZ = Wherigo.ZMedia(_REJ)
_XGKZ.Id = "581c1649-46a4-4e7d-a74b-2356f176ea9d"
_XGKZ.Name = _OM3wC("\029\001\004\084")
_XGKZ.Description = ""
_XGKZ.AltText = ""
_XGKZ.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
_wwP = Wherigo.ZMedia(_REJ)
_wwP.Id = "83f492d7-1acf-4213-a4cd-9c1f1cb5dedd"
_wwP.Name = _OM3wC("\004\029\001\084\094")
_wwP.Description = ""
_wwP.AltText = ""
_wwP.Resources = {
	{
		Type = "jpg", 
		Filename = "stake.jpg", 
		Directives = {}
	}
}
_wCoVv = Wherigo.ZMedia(_REJ)
_wCoVv.Id = "d3c2e216-acd0-41fc-b7d5-31313d58bee3"
_wCoVv.Name = _OM3wC("\033\111\118\094")
_wCoVv.Description = ""
_wCoVv.AltText = ""
_wCoVv.Resources = {
	{
		Type = "jpg", 
		Filename = "fire_bottle.jpg", 
		Directives = {}
	}
}
_lnduW = Wherigo.ZMedia(_REJ)
_lnduW.Id = "18c6480b-7eba-4392-8934-4fc88b5be15f"
_lnduW.Name = _OM3wC("\004\111\015\115\094\118\041\068\126\015\015\094\029")
_lnduW.Description = ""
_lnduW.AltText = ""
_lnduW.Resources = {
	{
		Type = "jpg", 
		Filename = "Silver_Bullet.jpg", 
		Directives = {}
	}
}
_17t = Wherigo.ZMedia(_REJ)
_17t.Id = "4967a432-1cb7-44dc-846d-9395fbe7f36a"
_17t.Name = _OM3wC("\072\043\015\099\041\004\099\071\068\043\015")
_17t.Description = ""
_17t.AltText = ""
_17t.Resources = {
	{
		Type = "jpg", 
		Filename = "holy_symbol.jpg", 
		Directives = {}
	}
}
_KrN = Wherigo.ZMedia(_REJ)
_KrN.Id = "8a4809cf-b5b0-4e3d-b5d1-e5e2ea9b3ae4"
_KrN.Name = _OM3wC("\011\001\118\015\111\059")
_KrN.Description = ""
_KrN.AltText = ""
_KrN.Resources = {
	{
		Type = "jpg", 
		Filename = "garlic.jpg", 
		Directives = {}
	}
}
_RcM = Wherigo.ZMedia(_REJ)
_RcM.Id = "64d63630-b18a-4f4d-ac89-f227e4017c28"
_RcM.Name = _OM3wC("\011\126\007\041\004\072\043\029")
_RcM.Description = ""
_RcM.AltText = ""
_RcM.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_blast.jpg", 
		Directives = {}
	}
}
_GV9 = Wherigo.ZMedia(_REJ)
_GV9.Id = "2214e2cf-4033-458a-8677-23c30c010295"
_GV9.Name = _OM3wC("\011\094\043\059\001\059\072\094")
_GV9.Description = ""
_GV9.AltText = ""
_GV9.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache.jpg", 
		Directives = {}
	}
}
_N8MOX = Wherigo.ZMedia(_REJ)
_N8MOX.Id = "0573cad6-3a06-4517-b817-e3763eb7ffa2"
_N8MOX.Name = _OM3wC("\115\001\007\041\072\094\015\004\111\007\011\041\111\059\043\007")
_N8MOX.Description = ""
_N8MOX.AltText = ""
_N8MOX.Resources = {
	{
		Type = "jpg", 
		Filename = "van_helsing_icon.jpg", 
		Directives = {}
	}
}
_KLk = Wherigo.ZMedia(_REJ)
_KLk.Id = "bd97ac83-7b4b-40c4-bd55-bc3b14d97568"
_KLk.Name = _OM3wC("\119\084\094\041\071\094\029\094\118\041\111\059\043\007")
_KLk.Description = ""
_KLk.AltText = ""
_KLk.Resources = {
	{
		Type = "jpg", 
		Filename = "pke_meter_icon.jpg", 
		Directives = {}
	}
}
_f7pfp = Wherigo.ZMedia(_REJ)
_f7pfp.Id = "a81bb5c0-095d-4688-8915-d4de59a0af1f"
_f7pfp.Name = _OM3wC("\004\015\111\071\094\118\041\111\059\043\007")
_f7pfp.Description = ""
_f7pfp.AltText = ""
_f7pfp.Resources = {
	{
		Type = "jpg", 
		Filename = "slimer_icon.jpg", 
		Directives = {}
	}
}
_Zt9 = Wherigo.ZMedia(_REJ)
_Zt9.Id = "2323d2d4-6541-4b1e-92dd-d460a64913f4"
_Zt9.Name = _OM3wC("\071\043\007\004\029\094\118\041\119\072\001\004\094\041\011\126\007\041\111\059\043\007")
_Zt9.Description = ""
_Zt9.AltText = ""
_Zt9.Resources = {
	{
		Type = "jpg", 
		Filename = "Monster_Phase_Gun_icon.jpg", 
		Directives = {}
	}
}
_rVUf = Wherigo.ZMedia(_REJ)
_rVUf.Id = "e6b65007-2b00-40ef-9350-72302dbd5eb5"
_rVUf.Name = _OM3wC("\001\071\071\043\041\111\059\043\007")
_rVUf.Description = ""
_rVUf.AltText = ""
_rVUf.Resources = {
	{
		Type = "jpg", 
		Filename = "ammo_icon.jpg", 
		Directives = {}
	}
}
_G_t2i = Wherigo.ZMedia(_REJ)
_G_t2i.Id = "0cf6df15-791f-4a9d-b1e2-45a2a66aab2d"
_G_t2i.Name = _OM3wC("\011\094\043\059\001\059\072\094\041\111\059\043\007")
_G_t2i.Description = ""
_G_t2i.AltText = ""
_G_t2i.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache_icon.jpg", 
		Directives = {}
	}
}
_L9G = Wherigo.ZMedia(_REJ)
_L9G.Id = "66bb47d2-820b-4c41-a7ee-cab1c40531ff"
_L9G.Name = _OM3wC("\100\072\094\118\111\011\043\041\111\059\043\007")
_L9G.Description = ""
_L9G.AltText = ""
_L9G.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_icon.jpg", 
		Directives = {}
	}
}
_gTiz = Wherigo.ZMedia(_REJ)
_gTiz.Id = "f928dc76-7198-48c9-9b52-8634b7f3f630"
_gTiz.Name = _OM3wC("\022\118\001\059\126\015\001\041\071\094\004\004\001\011\094")
_gTiz.Description = ""
_gTiz.AltText = ""
_gTiz.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_message.jpg", 
		Directives = {}
	}
}
_vS4Zm = Wherigo.ZMedia(_REJ)
_vS4Zm.Id = "7be8cfe7-8de8-4228-90dc-a17d11adf6b3"
_vS4Zm.Name = _OM3wC("\033\118\001\007\084\094\007\004\029\094\111\007\041\071\094\004\004\001\011\094")
_vS4Zm.Description = ""
_vS4Zm.AltText = ""
_vS4Zm.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_message.jpg", 
		Directives = {}
	}
}
_5MYIr = Wherigo.ZMedia(_REJ)
_5MYIr.Id = "8e7121cc-be24-4a43-933e-a4a9e140e7b2"
_5MYIr.Name = _OM3wC("\100\043\015\033\071\001\007\041\071\094\004\004\001\011\094")
_5MYIr.Description = ""
_5MYIr.AltText = ""
_5MYIr.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_message.jpg", 
		Directives = {}
	}
}
_Xxy = Wherigo.ZMedia(_REJ)
_Xxy.Id = "5fb7131a-f5a2-4ed5-8178-95bf6e6c2f8d"
_Xxy.Name = _OM3wC("\100\043\043\022\004\041\068\099\041\029\072\094\041\015\001\084\094")
_Xxy.Description = ""
_Xxy.AltText = ""
_Xxy.Resources = {
	{
		Type = "jpg", 
		Filename = "woods_by_the_lake.jpg", 
		Directives = {}
	}
}
_nH6qg = Wherigo.ZMedia(_REJ)
_nH6qg.Id = "d1f91b1e-0675-48de-bbd8-ef69e0c36d54"
_nH6qg.Name = _OM3wC("\100\001\029\094\118\041\029\043\100\094\118")
_nH6qg.Description = ""
_nH6qg.AltText = ""
_nH6qg.Resources = {
	{
		Type = "jpg", 
		Filename = "water_tower.jpg", 
		Directives = {}
	}
}
_VcG = Wherigo.ZMedia(_REJ)
_VcG.Id = "fb9e1dc9-ca86-4b80-b782-d26acf1ec4fb"
_VcG.Name = _OM3wC("\022\001\118\084\041\100\043\043\022\004")
_VcG.Description = ""
_VcG.AltText = ""
_VcG.Resources = {
	{
		Type = "jpg", 
		Filename = "dark_woods.jpg", 
		Directives = {}
	}
}
_0TEi = Wherigo.ZMedia(_REJ)
_0TEi.Id = "44cf82dc-2fb5-464d-8ec2-902760a2d185"
_0TEi.Name = _OM3wC("\029\072\094\001\029\118\094")
_0TEi.Description = ""
_0TEi.AltText = ""
_0TEi.Resources = {
	{
		Type = "jpg", 
		Filename = "theatre.jpg", 
		Directives = {}
	}
}
_R6op = Wherigo.ZMedia(_REJ)
_R6op.Id = "5c49b9af-e3ba-41c0-98cc-02f8c3b79b88"
_R6op.Name = _OM3wC("\059\043\007\004\094\004\004\111\043\007\041\004\029\001\007\022")
_R6op.Description = ""
_R6op.AltText = ""
_R6op.Resources = {
	{
		Type = "jpg", 
		Filename = "consecion_stand.jpg", 
		Directives = {}
	}
}
_464c = Wherigo.ZMedia(_REJ)
_464c.Id = "1082ff34-c709-42d3-b715-9bc10c17d662"
_464c.Name = _OM3wC("\004\029\001\118\029\111\007\011\041\001\118\094\001")
_464c.Description = ""
_464c.AltText = ""
_464c.Resources = {
	{
		Type = "jpg", 
		Filename = "starting_area.jpg", 
		Directives = {}
	}
}
_xGs2 = Wherigo.ZMedia(_REJ)
_xGs2.Id = "c0f43892-2f6f-4ed8-b71d-f91644190c35"
_xGs2.Name = _OM3wC("\100\043\043\022\004\041\068\099\041\029\072\094\041\015\001\084\094\041\111\059\043\007")
_xGs2.Description = ""
_xGs2.AltText = ""
_xGs2.Resources = {
	{
		Type = "jpg", 
		Filename = "woods_by_the_lake_icon.jpg", 
		Directives = {}
	}
}
_YLh = Wherigo.ZMedia(_REJ)
_YLh.Id = "d8ca23ff-c327-4bc2-a7c7-1520c411a431"
_YLh.Name = _OM3wC("\100\001\029\094\118\041\029\043\100\094\118\041\111\059\043\007")
_YLh.Description = ""
_YLh.AltText = ""
_YLh.Resources = {
	{
		Type = "jpg", 
		Filename = "water_tower_icon.jpg", 
		Directives = {}
	}
}
_4moiN = Wherigo.ZMedia(_REJ)
_4moiN.Id = "cea23d42-76bc-4811-a27b-8533beefee0b"
_4moiN.Name = _OM3wC("\059\043\007\004\094\059\111\043\007\041\004\029\001\007\022\041\111\059\043\007")
_4moiN.Description = ""
_4moiN.AltText = ""
_4moiN.Resources = {
	{
		Type = "jpg", 
		Filename = "consecion_stand_icon.jpg", 
		Directives = {}
	}
}
_82s = Wherigo.ZMedia(_REJ)
_82s.Id = "46dc2f0f-4cdb-449e-a94d-cbec177da631"
_82s.Name = _OM3wC("\004\029\001\118\029\111\007\011\041\001\118\094\001\041\111\059\043\007")
_82s.Description = ""
_82s.AltText = ""
_82s.Resources = {
	{
		Type = "jpg", 
		Filename = "starting_area_icon.jpg", 
		Directives = {}
	}
}
_TkhPm = Wherigo.ZMedia(_REJ)
_TkhPm.Id = "585e741f-6d2e-4337-ad04-1f95bf55d54f"
_TkhPm.Name = _OM3wC("\022\001\118\084\041\100\043\043\022\004\041\111\059\043\007")
_TkhPm.Description = ""
_TkhPm.AltText = ""
_TkhPm.Resources = {
	{
		Type = "jpg", 
		Filename = "dark_woods_icon.jpg", 
		Directives = {}
	}
}
_sJiZ = Wherigo.ZMedia(_REJ)
_sJiZ.Id = "6264b192-c0dc-44b1-940b-ca85486cdcf9"
_sJiZ.Name = _OM3wC("\029\072\094\001\029\118\094\041\111\059\043\007")
_sJiZ.Description = ""
_sJiZ.AltText = ""
_sJiZ.Resources = {
	{
		Type = "jpg", 
		Filename = "theatre_icon.jpg", 
		Directives = {}
	}
}
_sO3OT = Wherigo.ZMedia(_REJ)
_sO3OT.Id = "c5198122-67eb-472e-a89b-8f369bee01ee"
_sO3OT.Name = _OM3wC("\071\126\071\071\099\041\111\059\043\007")
_sO3OT.Description = ""
_sO3OT.AltText = ""
_sO3OT.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_icon.jpg", 
		Directives = {}
	}
}
_DlDRx = Wherigo.ZMedia(_REJ)
_DlDRx.Id = "5dd8a79a-8d78-4927-86d3-b1bbadfc6532"
_DlDRx.Name = _OM3wC("\033\118\001\007\084\094\007\004\029\094\111\007\041\111\059\043\007")
_DlDRx.Description = ""
_DlDRx.AltText = ""
_DlDRx.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_icon.jpg", 
		Directives = {}
	}
}
_VpjC = Wherigo.ZMedia(_REJ)
_VpjC.Id = "3f230b53-2e31-4270-8160-463732c18e28"
_VpjC.Name = _OM3wC("\100\043\015\033\071\001\007\041\111\059\043\007")
_VpjC.Description = ""
_VpjC.AltText = ""
_VpjC.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_icon.jpg", 
		Directives = {}
	}
}
_LlObN = Wherigo.ZMedia(_REJ)
_LlObN.Id = "3301b825-b614-4d56-a83d-413f4cfca9b9"
_LlObN.Name = _OM3wC("\022\118\001\059\126\015\001\041\111\059\043\007")
_LlObN.Description = ""
_LlObN.AltText = ""
_LlObN.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_icon.jpg", 
		Directives = {}
	}
}
_uDp = Wherigo.ZMedia(_REJ)
_uDp.Id = "d4e7800f-0bc7-4a8e-9fc8-86664e5ad668"
_uDp.Name = _OM3wC("\119\126\071\119\084\111\007")
_uDp.Description = ""
_uDp.AltText = ""
_uDp.Resources = {
	{
		Type = "jpg", 
		Filename = "pumpkin.jpg", 
		Directives = {}
	}
}
_fpVoC = Wherigo.ZMedia(_REJ)
_fpVoC.Id = "a963e02d-abfa-4871-bbb3-04f148368d75"
_fpVoC.Name = _OM3wC("\100\043\015\033\071\001\007\041\001\029\029\001\059\084\004")
_fpVoC.Description = ""
_fpVoC.AltText = ""
_fpVoC.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_attacks.jpg", 
		Directives = {}
	}
}
_ULI = Wherigo.ZMedia(_REJ)
_ULI.Id = "ea1255c4-471c-47a8-bafe-a0407a1d6f8f"
_ULI.Name = _OM3wC("\071\126\071\071\099\041\001\029\029\001\059\084\004")
_ULI.Description = ""
_ULI.AltText = ""
_ULI.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_attacks.jpg", 
		Directives = {}
	}
}
_F5tD = Wherigo.ZMedia(_REJ)
_F5tD.Id = "3effde39-c216-4473-b99f-cba6ac5ee5b6"
_F5tD.Name = _OM3wC("\112\118\001\059\126\015\001\041\001\029\029\001\059\084\004")
_F5tD.Description = ""
_F5tD.AltText = ""
_F5tD.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_attacks.jpg", 
		Directives = {}
	}
}
_ZavJ = Wherigo.ZMedia(_REJ)
_ZavJ.Id = "b4187aa3-77f6-4534-bb22-dad5c7464ce7"
_ZavJ.Name = _OM3wC("\033\118\001\007\084\094\007\004\029\094\111\007\041\001\029\029\001\059\084\004")
_ZavJ.Description = ""
_ZavJ.AltText = ""
_ZavJ.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_attacks.jpg", 
		Directives = {}
	}
}
_zdiH = Wherigo.ZMedia(_REJ)
_zdiH.Id = "ff35516e-dfdc-4671-86d0-0a69add0216c"
_zdiH.Name = _OM3wC("\022\118\001\059\126\015\001\041\004\043\126\007\022\108")
_zdiH.Description = ""
_zdiH.AltText = ""
_zdiH.Resources = {
	{
		Type = "mp3", 
		Filename = "I_Am_Dracula.mp3", 
		Directives = {}
	}
}
_9l9QD = Wherigo.ZMedia(_REJ)
_9l9QD.Id = "1efb197a-8a19-438d-8e06-e8d7202b34b6"
_9l9QD.Name = _OM3wC("\022\118\001\059\126\015\001\041\004\043\126\007\022\081")
_9l9QD.Description = ""
_9l9QD.AltText = ""
_9l9QD.Resources = {
	{
		Type = "mp3", 
		Filename = "dracula_sound.mp3", 
		Directives = {}
	}
}
_kD5x = Wherigo.ZMedia(_REJ)
_kD5x.Id = "cd21d617-15e2-4084-b34c-7b27da1093d5"
_kD5x.Name = _OM3wC("\071\043\007\004\029\094\118\041\022\094\004\029\118\126\059\029\111\043\007\081")
_kD5x.Description = ""
_kD5x.AltText = ""
_kD5x.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_desctruction2.jpg", 
		Directives = {}
	}
}
_TD7ta = Wherigo.ZMedia(_REJ)
_TD7ta.Id = "0a7bde23-7ab0-4fb8-94fd-505f24bc5a6a"
_TD7ta.Name = _OM3wC("\071\043\007\004\029\094\118\041\022\094\004\029\118\126\059\029\111\043\007\108")
_TD7ta.Description = ""
_TD7ta.AltText = ""
_TD7ta.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_destruction.jpg", 
		Directives = {}
	}
}
_MgqS = Wherigo.ZMedia(_REJ)
_MgqS.Id = "b4bd6609-7642-4863-9cfc-418f809b8e6e"
_MgqS.Name = _OM3wC("\071\111\004\004\094\022\041\004\072\043\029")
_MgqS.Description = ""
_MgqS.AltText = ""
_MgqS.Resources = {
	{
		Type = "jpg", 
		Filename = "missed_shot.jpg", 
		Directives = {}
	}
}
_kxYk0 = Wherigo.ZMedia(_REJ)
_kxYk0.Id = "8bb72bb4-6d30-49e3-831b-683a2cf94ec4"
_kxYk0.Name = _OM3wC("\100\043\015\033\071\001\007\041\004\043\126\007\022")
_kxYk0.Description = ""
_kxYk0.AltText = ""
_kxYk0.Resources = {
	{
		Type = "mp3", 
		Filename = "Werewolf_sound.mp3", 
		Directives = {}
	}
}
_4Ccho = Wherigo.ZMedia(_REJ)
_4Ccho.Id = "8a3e5b48-19b2-4f73-8462-37e4fd45ab03"
_4Ccho.Name = _OM3wC("\071\126\071\071\099\041\004\043\126\007\022")
_4Ccho.Description = ""
_4Ccho.AltText = ""
_4Ccho.Resources = {
	{
		Type = "mp3", 
		Filename = "mummy_sound.mp3", 
		Directives = {}
	}
}
_FhX = Wherigo.ZMedia(_REJ)
_FhX.Id = "c09867f5-51a3-4a94-89c9-d19bfe7d3e3e"
_FhX.Name = _OM3wC("\071\043\007\004\029\094\118\041\119\072\001\004\094\041\011\126\007\041\004\043\126\007\022")
_FhX.Description = ""
_FhX.AltText = ""
_FhX.Resources = {
	{
		Type = "mp3", 
		Filename = "monster_phase_gun_sound.mp3", 
		Directives = {}
	}
}
_eZvAA = Wherigo.ZMedia(_REJ)
_eZvAA.Id = "a1116e31-38cf-475b-849b-2c8b6dd61175"
_eZvAA.Name = _OM3wC("\001\071\071\043\041\015\043\001\022\041\004\043\126\007\022")
_eZvAA.Description = ""
_eZvAA.AltText = ""
_eZvAA.Resources = {
	{
		Type = "mp3", 
		Filename = "Ammo_load.mp3", 
		Directives = {}
	}
}
_TgI = Wherigo.ZMedia(_REJ)
_TgI.Id = "20a67f82-54b8-4813-8b78-e8ca3ea0d0c4"
_TgI.Name = _OM3wC("\033\118\001\007\084\094\007\004\029\094\111\007\041\004\043\126\007\022")
_TgI.Description = ""
_TgI.AltText = ""
_TgI.Resources = {
	{
		Type = "mp3", 
		Filename = "frankenstein_sound.mp3", 
		Directives = {}
	}
}
_pwVB = Wherigo.ZMedia(_REJ)
_pwVB.Id = "97837a10-754e-4856-baaa-5047ee611c28"
_pwVB.Name = _OM3wC("\115\001\007\041\072\094\015\004\111\007\011\041\004\043\126\007\022")
_pwVB.Description = ""
_pwVB.AltText = ""
_pwVB.Resources = {
	{
		Type = "mp3", 
		Filename = "van_helsing_sound.mp3", 
		Directives = {}
	}
}
_qqg = Wherigo.ZMedia(_REJ)
_qqg.Id = "3d869aef-dea3-4749-86b2-a49148181fc7"
_qqg.Name = _OM3wC("\119\084\094\041\071\094\029\094\118\041\004\094\001\118\059\072\111\007\011\041\004\043\126\007\022")
_qqg.Description = ""
_qqg.AltText = ""
_qqg.Resources = {
	{
		Type = "mp3", 
		Filename = "pke_meter_sound.mp3", 
		Directives = {}
	}
}
_L3t = Wherigo.ZMedia(_REJ)
_L3t.Id = "f040a128-e44f-472c-986c-19b677590de2"
_L3t.Name = _OM3wC("\119\084\094\041\071\094\029\094\118\041\033\043\126\007\022\041\071\043\007\004\029\094\118\041\004\043\126\007\022")
_L3t.Description = ""
_L3t.AltText = ""
_L3t.Resources = {
	{
		Type = "mp3", 
		Filename = "monster_found_siren.mp3", 
		Directives = {}
	}
}
_qLBu = Wherigo.ZMedia(_REJ)
_qLBu.Id = "d292bfe9-8034-42c3-966e-6bcadfe44057"
_qLBu.Name = _OM3wC("\004\015\111\071\094\118\041\004\043\126\007\022")
_qLBu.Description = ""
_qLBu.AltText = ""
_qLBu.Resources = {
	{
		Type = "mp3", 
		Filename = "slimer.mp3", 
		Directives = {}
	}
}
_FmAlo = Wherigo.ZMedia(_REJ)
_FmAlo.Id = "d3e597fe-ec95-4f33-a223-2a6506d2a6da"
_FmAlo.Name = _OM3wC("\100\072\094\118\111\011\043\041\059\001\118\029\041\022\094\029\001\111\015")
_FmAlo.Description = ""
_FmAlo.AltText = ""
_FmAlo.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_cart_detail.jpg", 
		Directives = {}
	}
}
_Hr7rB = Wherigo.ZMedia(_REJ)
_Hr7rB.Id = "c588c89f-1abd-450a-97cb-a5ce7fc6bf24"
_Hr7rB.Name = _OM3wC("\119\015\001\099\094\118\041\059\043\071\119\015\094\029\111\043\007\041\059\043\022\094")
_Hr7rB.Description = ""
_Hr7rB.AltText = ""
_Hr7rB.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo.jpg", 
		Directives = {}
	}
}
_PRM = Wherigo.ZMedia(_REJ)
_PRM.Id = "17723aca-7cda-4aec-b72f-a9cc160a1cc6"
_PRM.Name = _OM3wC("\094\027\119\015\043\004\111\043\007\041\004\043\126\007\022")
_PRM.Description = ""
_PRM.AltText = ""
_PRM.Resources = {
	{
		Type = "mp3", 
		Filename = "explosion.mp3", 
		Directives = {}
	}
}
_PGSM = Wherigo.ZMedia(_REJ)
_PGSM.Id = "e19023c6-e095-4871-86b5-80eec14f84f9"
_PGSM.Name = _OM3wC("\071\126\071\071\099\041\071\094\004\004\001\011\094")
_PGSM.Description = ""
_PGSM.AltText = ""
_PGSM.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_message.jpg", 
		Directives = {}
	}
}
_9az = Wherigo.ZMedia(_REJ)
_9az.Id = "b0f38456-a0b8-48b1-81fd-ff40d77ca5eb"
_9az.Name = _OM3wC("\119\043\118\029\001\015")
_9az.Description = ""
_9az.AltText = ""
_9az.Resources = {
	{
		Type = "jpg", 
		Filename = "portal.jpg", 
		Directives = {}
	}
}
_mdW = Wherigo.ZMedia(_REJ)
_mdW.Id = "c3bf7db8-fb31-4643-ae73-251ae276bce7"
_mdW.Name = _OM3wC("\100\111\007\022\041\004\043\126\007\022")
_mdW.Description = ""
_mdW.AltText = ""
_mdW.Resources = {
	{
		Type = "mp3", 
		Filename = "wind_sound.mp3", 
		Directives = {}
	}
}
_f10 = Wherigo.ZMedia(_REJ)
_f10.Id = "c321eb8a-e50d-4fce-b229-bee93247c5c0"
_f10.Name = _OM3wC("\071\043\007\004\029\094\118\041\059\043\071\119\094\007\022\111\126\071\041\111\059\043\007")
_f10.Description = ""
_f10.AltText = ""
_f10.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_compendium_icon.jpg", 
		Directives = {}
	}
}
_5Mw_d = Wherigo.ZMedia(_REJ)
_5Mw_d.Id = "67ab1948-88a8-4c46-9487-3030ebd9a98a"
_5Mw_d.Name = _OM3wC("\071\043\007\004\029\094\118\041\059\043\071\119\094\007\022\111\126\071")
_5Mw_d.Description = ""
_5Mw_d.AltText = ""
_5Mw_d.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_compendium.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_REJ.Id="06a6a668-7a51-47d7-b9f3-84cbb4bf8e4c"
_REJ.Name="Monsters"
_REJ.Description=[[]]
_REJ.Visible=true
_REJ.Activity="Fiction"
_REJ.StartingLocationDescription=[[]]
_REJ.StartingLocation = ZonePoint(38.5811400005998,-90.416929994231,0)
_REJ.Version=""
_REJ.Company=""
_REJ.Author="Forest-Ghost"
_REJ.BuilderVersion="URWIGO 1.21.5528.18461"
_REJ.CreateDate="08/05/2015 23:30:59"
_REJ.PublishDate="1/1/0001 12:00:00 AM"
_REJ.UpdateDate="11/16/2015 23:46:38"
_REJ.LastPlayedDate="1/1/0001 12:00:00 AM"
_REJ.TargetDevice="PocketPC"
_REJ.TargetDeviceVersion="0"
_REJ.StateId="1"
_REJ.CountryId="2"
_REJ.Complete=false
_REJ.UseLogging=true

_REJ.Media=_FmAlo

_REJ.Icon=_L9G


-- Zones --
_b6V = Wherigo.Zone(_REJ)
_b6V.Id = "51f3a146-b636-4410-99b0-16324fa539de"
_b6V.Name = _OM3wC("\101\029\001\118\029\016\090\118\094\001")
_b6V.Description = ""
_b6V.Visible = true
_b6V.Media = _464c
_b6V.Icon = _82s
_b6V.Commands = {}
_b6V.DistanceRange = Distance(-1, "feet")
_b6V.ShowObjects = "OnProximity"
_b6V.ProximityRange = Distance(10, "meters")
_b6V.AllowSetPositionTo = false
_b6V.Active = false
_b6V.Points = {
	ZonePoint(38.5814148495078, -90.4172691551543, 0), 
	ZonePoint(38.5813844610801, -90.4174227404989, 0), 
	ZonePoint(38.5812830237943, -90.4173845045812, 0), 
	ZonePoint(38.5813191926847, -90.4172349714287, 0)
}
_b6V.OriginalPoint = ZonePoint(38.5813503817667, -90.4173278429158, 0)
_b6V.DistanceRangeUOM = "Feet"
_b6V.ProximityRangeUOM = "Meters"
_b6V.OutOfRangeName = ""
_b6V.InRangeName = ""
__P0 = Wherigo.Zone(_REJ)
__P0.Id = "9c18f366-7a0b-49d8-b5b5-f5dc2b2cc949"
__P0.Name = _OM3wC("\045\043\007\059\094\004\004\111\043\007\016\101\029\001\007\022")
__P0.Description = ""
__P0.Visible = true
__P0.Media = _R6op
__P0.Icon = _4moiN
__P0.Commands = {}
__P0.DistanceRange = Distance(-1, "feet")
__P0.ShowObjects = "OnProximity"
__P0.ProximityRange = Distance(10, "meters")
__P0.AllowSetPositionTo = false
__P0.Active = false
__P0.Points = {
	ZonePoint(38.5818596271223, -90.418916716481, 0), 
	ZonePoint(38.5819513590431, -90.4189079993016, 0), 
	ZonePoint(38.581945068858, -90.4187168919094, 0), 
	ZonePoint(38.5818522885635, -90.4187195741184, 0)
}
__P0.OriginalPoint = ZonePoint(38.5819020858967, -90.4188152954526, 0)
__P0.DistanceRangeUOM = "Feet"
__P0.ProximityRangeUOM = "Meters"
__P0.OutOfRangeName = ""
__P0.InRangeName = ""
_kR_Le = Wherigo.Zone(_REJ)
_kR_Le.Id = "5015627b-2996-474d-a93c-89467a818e34"
_kR_Le.Name = _OM3wC("\025\072\094\001\029\118\094")
_kR_Le.Description = ""
_kR_Le.Visible = true
_kR_Le.Media = _0TEi
_kR_Le.Icon = _sJiZ
_kR_Le.Commands = {}
_kR_Le.DistanceRange = Distance(-1, "feet")
_kR_Le.ShowObjects = "OnProximity"
_kR_Le.ProximityRange = Distance(10, "meters")
_kR_Le.AllowSetPositionTo = false
_kR_Le.Active = false
_kR_Le.Points = {
	ZonePoint(38.5810848808548, -90.4199560724743, 0), 
	ZonePoint(38.5811236707855, -90.4198575012929, 0), 
	ZonePoint(38.5810361313177, -90.4197495423801, 0), 
	ZonePoint(38.5809863333691, -90.4198494546659, 0)
}
_kR_Le.OriginalPoint = ZonePoint(38.5810577540818, -90.4198531427033, 0)
_kR_Le.DistanceRangeUOM = "Feet"
_kR_Le.ProximityRangeUOM = "Meters"
_kR_Le.OutOfRangeName = ""
_kR_Le.InRangeName = ""
_TVHlb = Wherigo.Zone(_REJ)
_TVHlb.Id = "cb469478-672d-498b-b871-74d131c8ecc6"
_TVHlb.Name = _OM3wC("\091\043\043\022\004\016\007\094\001\118\016\029\072\094\016\074\001\084\094")
_TVHlb.Description = ""
_TVHlb.Visible = true
_TVHlb.Media = _Xxy
_TVHlb.Icon = _xGs2
_TVHlb.Commands = {}
_TVHlb.DistanceRange = Distance(-1, "feet")
_TVHlb.ShowObjects = "OnProximity"
_TVHlb.ProximityRange = Distance(10, "meters")
_TVHlb.AllowSetPositionTo = false
_TVHlb.Active = false
_TVHlb.Points = {
	ZonePoint(38.5797817366856, -90.4195879392869, 0), 
	ZonePoint(38.579877140641, -90.4196047030933, 0), 
	ZonePoint(38.5798912939642, -90.4194424294479, 0), 
	ZonePoint(38.5797964142255, -90.4194236539848, 0)
}
_TVHlb.OriginalPoint = ZonePoint(38.5798366463791, -90.4195146814532, 0)
_TVHlb.DistanceRangeUOM = "Feet"
_TVHlb.ProximityRangeUOM = "Meters"
_TVHlb.OutOfRangeName = ""
_TVHlb.InRangeName = ""
_cQW = Wherigo.Zone(_REJ)
_cQW.Id = "ae8fb32c-a8e8-4af3-9c8c-5bdf6e662b26"
_cQW.Name = _OM3wC("\112\001\118\084\016\091\043\043\022\004")
_cQW.Description = ""
_cQW.Visible = true
_cQW.Media = _VcG
_cQW.Icon = _TkhPm
_cQW.Commands = {}
_cQW.DistanceRange = Distance(-1, "feet")
_cQW.ShowObjects = "OnProximity"
_cQW.ProximityRange = Distance(10, "meters")
_cQW.AllowSetPositionTo = false
_cQW.Active = false
_cQW.Points = {
	ZonePoint(38.581603524855, -90.422174961712, 0), 
	ZonePoint(38.5816018170768, -90.4220188124543, 0), 
	ZonePoint(38.5814760658447, -90.422017298367, 0), 
	ZonePoint(38.5814790905533, -90.4221793629421, 0)
}
_cQW.OriginalPoint = ZonePoint(38.5815401245824, -90.4220976088689, 0)
_cQW.DistanceRangeUOM = "Feet"
_cQW.ProximityRangeUOM = "Meters"
_cQW.OutOfRangeName = ""
_cQW.InRangeName = ""
_2BD = Wherigo.Zone(_REJ)
_2BD.Id = "3378bf01-5a8e-4436-a240-ea87b3aa7fda"
_2BD.Name = _OM3wC("\091\001\029\094\118\016\025\043\100\094\118")
_2BD.Description = ""
_2BD.Visible = true
_2BD.Media = _nH6qg
_2BD.Icon = _YLh
_2BD.Commands = {}
_2BD.DistanceRange = Distance(-1, "feet")
_2BD.ShowObjects = "OnProximity"
_2BD.ProximityRange = Distance(10, "meters")
_2BD.AllowSetPositionTo = false
_2BD.Active = false
_2BD.Points = {
	ZonePoint(38.5822434621266, -90.4209448283068, 0), 
	ZonePoint(38.5821590691071, -90.4209387933364, 0), 
	ZonePoint(38.5821674559954, -90.4207691436163, 0), 
	ZonePoint(38.5822502764656, -90.4207758491389, 0)
}
_2BD.OriginalPoint = ZonePoint(38.5822050659237, -90.4208571535996, 0)
_2BD.DistanceRangeUOM = "Feet"
_2BD.ProximityRangeUOM = "Meters"
_2BD.OutOfRangeName = ""
_2BD.InRangeName = ""
_Vfq = Wherigo.Zone(_REJ)
_Vfq.Id = "f13e5bd6-ec33-4250-a667-ace2bacd9108"
_Vfq.Name = _OM3wC("\003\094\043\059\001\059\072\094")
_Vfq.Description = _OM3wC("\025\072\094\016\003\094\043\059\001\059\072\094\016\111\004\016\015\043\059\001\029\094\022\021\016\051\016\122\125\016\122\121\120\057\125\049\016\077\007\068\004\119\038\091\016\002\049\016\081\121\120\002\121\034")
_Vfq.Visible = true
_Vfq.Media = _GV9
_Vfq.Icon = _G_t2i
_Vfq.Commands = {}
_Vfq.DistanceRange = Distance(-1, "feet")
_Vfq.ShowObjects = "OnProximity"
_Vfq.ProximityRange = Distance(10, "meters")
_Vfq.AllowSetPositionTo = false
_Vfq.Active = false
_Vfq.Points = {
	ZonePoint(38.5780546778957, -90.4158577840615, 0), 
	ZonePoint(38.5779531995231, -90.415859106103, 0), 
	ZonePoint(38.5779558205794, -90.4157149373684, 0), 
	ZonePoint(38.5780575174861, -90.4157142668162, 0)
}
_Vfq.OriginalPoint = ZonePoint(38.5780053038711, -90.4157865235873, 0)
_Vfq.DistanceRangeUOM = "Feet"
_Vfq.ProximityRangeUOM = "Meters"
_Vfq.OutOfRangeName = ""
_Vfq.InRangeName = ""

-- Characters --
_LyRR = Wherigo.ZCharacter{
	Cartridge = _REJ, 
	Container = _cQW
}
_LyRR.Id = "b67a2658-66aa-4065-a8c9-7ddc77404286"
_LyRR.Name = _OM3wC("\091\043\015\033\071\001\007")
_LyRR.Description = ""
_LyRR.Visible = true
_LyRR.Media = _5MYIr
_LyRR.Icon = _VpjC
_LyRR.Commands = {}
_LyRR.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_LyRR.Gender = "Male"
_LyRR.Type = "NPC"
_OaV = Wherigo.ZCharacter{
	Cartridge = _REJ, 
	Container = _2BD
}
_OaV.Id = "f8f60ed9-bac9-4a1c-85ec-2d5012357c20"
_OaV.Name = _OM3wC("\097\118\001\007\084\094\007\004\029\094\111\007")
_OaV.Description = ""
_OaV.Visible = true
_OaV.Media = _vS4Zm
_OaV.Icon = _DlDRx
_OaV.Commands = {}
_OaV.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OaV.Gender = "Male"
_OaV.Type = "NPC"
_p4f = Wherigo.ZCharacter{
	Cartridge = _REJ, 
	Container = _b6V
}
_p4f.Id = "bba8eb92-929e-4a57-9691-da602cc3409b"
_p4f.Name = _OM3wC("\024\001\007\016\058\094\015\004\111\007\011")
_p4f.Description = ""
_p4f.Visible = true
_p4f.Media = __CX8d
_p4f.Icon = _N8MOX
_p4f.Commands = {
	_EWp = Wherigo.ZCommand{
		Text = _OM3wC("\025\001\015\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}, 
	_iek = Wherigo.ZCommand{
		Text = _OM3wC("\025\001\015\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}
}
_p4f.Commands._EWp.Custom = true
_p4f.Commands._EWp.Id = "8ed1475d-e397-4c04-ba58-c85236e561d0"
_p4f.Commands._EWp.WorksWithAll = true
_p4f.Commands._iek.Custom = true
_p4f.Commands._iek.Id = "dbe6dddf-4c11-4d1c-ba74-dd1456010cd9"
_p4f.Commands._iek.WorksWithAll = true
_p4f.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_p4f.Gender = "Male"
_p4f.Type = "NPC"
_9gvjU = Wherigo.ZCharacter{
	Cartridge = _REJ, 
	Container = _kR_Le
}
_9gvjU.Id = "77e68fc6-b176-429c-a849-3925bed6d812"
_9gvjU.Name = _OM3wC("\112\118\001\059\126\015\001")
_9gvjU.Description = ""
_9gvjU.Visible = true
_9gvjU.Media = _gTiz
_9gvjU.Icon = _LlObN
_9gvjU.Commands = {}
_9gvjU.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_9gvjU.Gender = "Male"
_9gvjU.Type = "NPC"
_IlSl = Wherigo.ZCharacter{
	Cartridge = _REJ, 
	Container = __P0
}
_IlSl.Id = "b23e26be-8813-439b-966b-9a92e739b36e"
_IlSl.Name = _OM3wC("\101\015\111\071\094\118")
_IlSl.Description = ""
_IlSl.Visible = true
_IlSl.Media = _HA3B
_IlSl.Icon = _f7pfp
_IlSl.Commands = {
	_Az_ = Wherigo.ZCommand{
		Text = _OM3wC("\025\001\015\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}
}
_IlSl.Commands._Az_.Custom = true
_IlSl.Commands._Az_.Id = "95ebe51f-3723-466e-87cc-6941adacd705"
_IlSl.Commands._Az_.WorksWithAll = true
_IlSl.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_IlSl.Gender = "Male"
_IlSl.Type = "NPC"
_cbB4l = Wherigo.ZCharacter{
	Cartridge = _REJ, 
	Container = _TVHlb
}
_cbB4l.Id = "675be38c-e0cd-4756-9492-e1106fe59588"
_cbB4l.Name = _OM3wC("\078\126\071\071\099")
_cbB4l.Description = ""
_cbB4l.Visible = true
_cbB4l.Media = _PGSM
_cbB4l.Icon = _sO3OT
_cbB4l.Commands = {}
_cbB4l.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_cbB4l.Gender = "Male"
_cbB4l.Type = "NPC"

-- Items --
_0XX = Wherigo.ZItem(_REJ)
_0XX.Id = "bd75a70b-968b-48ee-bc9b-2f88f593931e"
_0XX.Name = _OM3wC("\078\043\007\004\029\094\118\016\040\072\001\004\094\016\003\126\007")
_0XX.Description = ""
_0XX.Visible = true
_0XX.Media = _aRb
_0XX.Icon = _Zt9
_0XX.Commands = {
	_VxQom = Wherigo.ZCommand{
		Text = _OM3wC("\097\111\118\094\016\003\126\007"), 
		CmdWith = true, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\042\043\126\016\033\111\118\094\016\043\033\033\016\001\016\004\072\043\029\016\068\126\029\016\007\043\029\072\111\007\011\016\072\001\119\119\094\007\004\120")
	}
}
_0XX.Commands._VxQom.Custom = true
_0XX.Commands._VxQom.Id = "0f0c7bad-7a85-4d87-ac02-e551282fe2e1"
_0XX.Commands._VxQom.WorksWithAll = false
_0XX.Commands._VxQom.WorksWithListIds = {
	"b67a2658-66aa-4065-a8c9-7ddc77404286", 
	"f8f60ed9-bac9-4a1c-85ec-2d5012357c20", 
	"b23e26be-8813-439b-966b-9a92e739b36e", 
	"77e68fc6-b176-429c-a849-3925bed6d812", 
	"675be38c-e0cd-4756-9492-e1106fe59588"
}
_0XX.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_0XX.Locked = false
_0XX.Opened = false
_bgMN = Wherigo.ZItem(_REJ)
_bgMN.Id = "0abcaaf0-a616-4309-8d88-1156f77f10e3"
_bgMN.Name = _OM3wC("\040\120\016\036\120\016\124\120\016\078\094\029\094\118")
_bgMN.Description = ""
_bgMN.Visible = true
_bgMN.Media = _EpBr
_bgMN.Icon = _KLk
_bgMN.Commands = {
	_vIJ = Wherigo.ZCommand{
		Text = _OM3wC("\025\126\118\007\016\023\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}
}
_bgMN.Commands._vIJ.Custom = true
_bgMN.Commands._vIJ.Id = "e69589f3-a1f2-4a5e-a8e9-66e7e8424b2c"
_bgMN.Commands._vIJ.WorksWithAll = true
_bgMN.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_bgMN.Locked = false
_bgMN.Opened = false
_DJz = Wherigo.ZItem(_REJ)
_DJz.Id = "010002c9-256d-43aa-b78a-b65bafb839aa"
_DJz.Name = _OM3wC("\090\071\071\126\007\111\029\111\043\007")
_DJz.Description = ""
_DJz.Visible = true
_DJz.Media = _syL
_DJz.Icon = _rVUf
_DJz.Commands = {
	_YP3 = Wherigo.ZCommand{
		Text = _OM3wC("\074\043\001\022\016\090\071\071\126\007\111\029\111\043\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}
}
_DJz.Commands._YP3.Custom = true
_DJz.Commands._YP3.Id = "fa6672fa-1365-4986-9631-22550a69aca9"
_DJz.Commands._YP3.WorksWithAll = true
_DJz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_DJz.Locked = false
_DJz.Opened = false
_emcS = Wherigo.ZItem(_REJ)
_emcS.Id = "d4ed30c3-1be6-44ad-96a0-d6fac1a10cce"
_emcS.Name = _OM3wC("\059\072\094\001\029")
_emcS.Description = ""
_emcS.Visible = true
_emcS.Commands = {
	__R0 = Wherigo.ZCommand{
		Text = _OM3wC("\029\126\118\007\016\043\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}
}
_emcS.Commands.__R0.Custom = true
_emcS.Commands.__R0.Id = "7b2fe875-c9fd-48ec-ad54-a63bdfdb560e"
_emcS.Commands.__R0.WorksWithAll = true
_emcS.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_emcS.Locked = false
_emcS.Opened = false
_ID_ = Wherigo.ZItem(_REJ)
_ID_.Id = "16f9bee3-26a8-4c90-83bf-a2cf32330e16"
_ID_.Name = _OM3wC("\003\094\043\059\001\059\072\094")
_ID_.Description = _OM3wC("\025\072\094\016\011\094\043\059\001\059\072\094\016\111\004\016\015\043\059\001\029\094\022\016\001\029\016\051\016\122\125\016\122\121\120\057\125\049\016\077\007\068\004\119\038\091\016\002\049\016\081\121\120\002\121\034\120")
_ID_.Visible = true
_ID_.Media = _GV9
_ID_.Icon = _G_t2i
_ID_.Commands = {
	_49F = Wherigo.ZCommand{
		Text = _OM3wC("\058\111\007\029"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}
}
_ID_.Commands._49F.Custom = true
_ID_.Commands._49F.Id = "6caa0ade-4a1b-4b85-a949-3fdd069a42a5"
_ID_.Commands._49F.WorksWithAll = true
_ID_.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ID_.Locked = false
_ID_.Opened = false
_euYx = Wherigo.ZItem(_REJ)
_euYx.Id = "2d7a4f77-21d3-45e5-b76b-d5404064ce34"
_euYx.Name = _OM3wC("\040\015\001\099\094\118\016\045\043\071\119\015\094\029\111\043\007\016\045\043\022\094")
_euYx.Description = ""
_euYx.Visible = true
_euYx.Media = _Hr7rB
_euYx.Commands = {}
_euYx.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_euYx.Locked = false
_euYx.Opened = false
_RD3T = Wherigo.ZItem{
	Cartridge = _REJ, 
	Container = Player
}
_RD3T.Id = "68a3fe92-6e13-49e2-84fe-b1b2bc05dc32"
_RD3T.Name = _OM3wC("\078\043\007\004\029\094\118\016\045\043\071\119\094\007\022\111\126\071")
_RD3T.Description = _OM3wC("\090\016\068\043\043\084\016\001\068\043\126\029\016\071\043\007\004\029\094\118\004\120")
_RD3T.Visible = true
_RD3T.Media = _5Mw_d
_RD3T.Icon = _f10
_RD3T.Commands = {
	_TKT_b = Wherigo.ZCommand{
		Text = _OM3wC("\124\027\001\071\111\007\094"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _OM3wC("\051\043\029\072\111\007\011\016\001\115\001\111\015\001\068\015\094")
	}
}
_RD3T.Commands._TKT_b.Custom = true
_RD3T.Commands._TKT_b.Id = "a403e22a-5837-4a52-85ff-7559da5aa222"
_RD3T.Commands._TKT_b.WorksWithAll = true
_RD3T.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_RD3T.Locked = false
_RD3T.Opened = false

-- Tasks --
_4Mbj6 = Wherigo.ZTask(_REJ)
_4Mbj6.Id = "dc803374-fb88-4506-8654-f5a0d4731fba"
_4Mbj6.Name = _OM3wC("\097\111\007\022\016\029\072\094\016\078\043\007\004\029\094\118\004")
_4Mbj6.Description = _OM3wC("\025\126\118\007\016\043\007\016\099\043\126\118\016\040\120\036\120\124\016\071\094\029\094\118\016\043\007\016\039\015\043\059\001\029\094\022\016\111\007\016\099\043\126\118\016\111\007\115\094\007\029\043\118\099\008\016\001\007\022\016\033\043\015\015\043\100\016\029\072\094\016\119\001\029\072\016\029\043\016\029\072\094\016\051\023\114\025\058\091\124\101\025\016\029\043\016\033\111\007\022\016\029\072\094\016\071\043\007\004\029\094\118\004\120")
_4Mbj6.Visible = true
_4Mbj6.Media = _XGKZ
_4Mbj6.Active = false
_4Mbj6.Complete = false
_4Mbj6.CorrectState = "None"
_h7O0Y = Wherigo.ZTask(_REJ)
_h7O0Y.Id = "b2a4f90c-8bb0-4b83-8c64-4e0ee51ba36b"
_h7O0Y.Name = _OM3wC("\101\119\094\001\084\016\029\043\016\024\001\007\016\058\094\015\004\111\007\011")
_h7O0Y.Description = _OM3wC("\101\119\094\001\084\016\029\043\016\024\001\007\016\058\094\015\004\111\007\011\016\111\007\016\029\072\094\016\004\029\001\118\029\111\007\011\016\001\118\094\001\120\016")
_h7O0Y.Visible = true
_h7O0Y.Media = _XGKZ
_h7O0Y.Active = false
_h7O0Y.Complete = false
_h7O0Y.CorrectState = "None"
_KdL = Wherigo.ZTask(_REJ)
_KdL.Id = "2518a914-0834-460b-91ae-a685d5b66307"
_KdL.Name = _OM3wC("\025\001\084\094\016\022\043\100\007\016\029\072\094\016\078\043\007\004\029\094\118\004")
_KdL.Description = _OM3wC("\097\118\001\007\084\094\007\004\029\094\111\007\082\016\091\043\015\033\071\001\007\082\016\001\007\022\016\029\072\094\016\078\126\071\071\099\016\001\118\094\016\007\094\001\118\068\099\120\016\056\004\094\016\029\072\094\016\059\043\118\118\094\059\029\016\001\071\071\126\007\111\029\111\043\007\016\029\043\016\029\001\084\094\016\029\072\094\071\016\043\126\029\120\016\058\111\007\029\021\016\094\001\059\072\016\071\043\007\004\029\094\118\016\100\111\015\015\016\043\007\015\099\016\068\094\016\094\033\033\094\059\029\094\022\016\068\099\016\001\016\059\094\118\029\001\111\007\016\029\099\119\094\016\043\033\016\001\071\071\126\007\111\029\111\043\007\120\016\078\001\084\094\016\004\126\118\094\016\099\043\126\016\015\043\001\022\016\029\072\094\016\059\043\118\118\094\059\029\016\001\071\071\043\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120")
_KdL.Visible = true
_KdL.Media = _XGKZ
_KdL.Active = false
_KdL.Complete = false
_KdL.CorrectState = "None"
_5FUv = Wherigo.ZTask(_REJ)
_5FUv.Id = "80af8025-1b4c-49c5-8f75-acaf6a6831ce"
_5FUv.Name = _OM3wC("\025\001\084\094\016\022\043\100\007\016\112\118\001\059\126\015\001")
_5FUv.Description = _OM3wC("\112\118\001\059\126\015\001\016\072\001\004\016\001\119\119\094\001\118\094\022\016\111\007\016\029\072\094\016\029\072\094\001\029\118\094\120\016\025\001\084\094\016\072\111\071\016\022\043\100\007\120\016\058\111\007\029\021\016\112\118\001\059\126\015\001\016\071\001\099\016\118\094\010\126\111\118\094\016\071\043\118\094\016\029\072\001\007\016\043\007\094\016\004\072\043\029\016\029\043\016\068\094\016\022\094\004\029\118\043\099\094\022\120")
_5FUv.Visible = true
_5FUv.Media = _XGKZ
_5FUv.Active = false
_5FUv.Complete = false
_5FUv.CorrectState = "None"
_hPF = Wherigo.ZTask(_REJ)
_hPF.Id = "8a67bd1b-5fcf-44e6-bac1-3d1990019489"
_hPF.Name = _OM3wC("\097\111\007\022\016\029\072\094\016\003\094\043\059\001\059\072\094")
_hPF.Description = _OM3wC("\025\072\094\016\011\094\043\059\001\059\072\094\016\111\004\016\015\043\059\001\029\094\022\016\001\029\016\051\016\122\125\016\122\121\120\057\125\049\016\091\016\002\049\016\081\121\120\002\121\034\120\016\101\094\001\118\059\072\016\029\072\094\016\072\043\007\094\099\004\126\059\084\015\094\016\029\118\094\094\016\111\007\016\029\072\094\016\011\118\043\115\094\120\016\042\043\126\016\001\118\094\016\015\043\043\084\111\007\011\016\033\043\118\016\001\007\016\094\027\029\118\001\093\015\001\118\011\094\016\068\111\004\043\007\016\029\126\068\094\016\001\029\016\029\072\094\016\068\001\004\094\016\043\033\016\001\016\029\072\118\094\094\016\029\118\126\007\084\016\029\118\094\094\120")
_hPF.Visible = true
_hPF.Media = _XGKZ
_hPF.Active = false
_hPF.Complete = false
_hPF.CorrectState = "None"

-- Cartridge Variables --
_1Dr0 = 1
_LJBg = 1
_r7w = 1
_om3T = ""
_5ysP = 1
_hQn = 1
_Q1V = 1
_HLew1 = 1
_pxpOD = 1
_uQI2F = 1
_lzo = 1
_lIYj = 1
_UysVr = 1
_uzVK = ""
_x6EeP = ""
_Z2YCh = 1
_VIOv = 1
_7zHJQ = false
_F_8 = false
_mv_qX = false
_NWr = false
_k8BT9 = false
_zNbH = _OM3wC("\041\068\057\024")
_OiM = _OM3wC("\041\074\099\114\114")
_wctR = _OM3wC("\041\049\117\117")
_0eS3N = _OM3wC("\041\121\078\068\055\057")
_Yluf = _OM3wC("\041\091\027\090")
__0ZM = _OM3wC("\022\126\071\071\099")
_REJ.ZVariables = {
	_1Dr0 = 1, 
	_LJBg = 1, 
	_r7w = 1, 
	_om3T = "", 
	_5ysP = 1, 
	_hQn = 1, 
	_Q1V = 1, 
	_HLew1 = 1, 
	_pxpOD = 1, 
	_uQI2F = 1, 
	_lzo = 1, 
	_lIYj = 1, 
	_UysVr = 1, 
	_uzVK = "", 
	_x6EeP = "", 
	_Z2YCh = 1, 
	_VIOv = 1, 
	_7zHJQ = false, 
	_F_8 = false, 
	_mv_qX = false, 
	_NWr = false, 
	_k8BT9 = false, 
	_zNbH = _OM3wC("\041\068\057\024"), 
	_OiM = _OM3wC("\041\074\099\114\114"), 
	_wctR = _OM3wC("\041\049\117\117"), 
	_0eS3N = _OM3wC("\041\121\078\068\055\057"), 
	_Yluf = _OM3wC("\041\091\027\090"), 
	__0ZM = _OM3wC("\022\126\071\071\099")
}

-- Timers --

-- Inputs --
_WxA = Wherigo.ZInput(_REJ)
_WxA.Id = "865bb726-1afe-4d16-ba4d-c3e2e85f3194"
_WxA.Name = _OM3wC("\001\071\071\126\007\111\029\111\043\007")
_WxA.Description = ""
_WxA.Visible = true
_WxA.Media = _syL
_WxA.Choices = {
	"Silver Bullet", 
	"Stake", 
	"Flame", 
	"Garlic", 
	"Holy Symbol", 
	"Nothing"
}
_WxA.InputType = "MultipleChoice"
_WxA.Text = _OM3wC("\091\072\111\059\072\016\001\071\071\043\016\100\043\126\015\022\016\099\043\126\016\015\111\084\094\016\029\043\016\015\043\001\022\110")
_R30 = Wherigo.ZInput(_REJ)
_R30.Id = "2fa08dc4-7302-4f78-9cd8-164a0a39731c"
_R30.Name = _OM3wC("\004\015\111\071\094\118\041\029\001\015\084")
_R30.Description = ""
_R30.Visible = true
_R30.Media = _HA3B
_R30.Choices = {
	"How are you?", 
	"Nothing"
}
_R30.InputType = "MultipleChoice"
_R30.Text = _OM3wC("\091\072\001\029\016\100\043\126\015\022\016\099\043\126\016\015\111\084\094\016\029\043\016\029\001\015\084\016\001\068\043\126\029\110")
_PJnx = Wherigo.ZInput(_REJ)
_PJnx.Id = "7b1fd46b-40d6-4fc4-9afd-d20fa703e90b"
_PJnx.Name = _OM3wC("\078\043\007\004\029\094\118\041\045\043\071\119\094\007\022\111\126\071")
_PJnx.Description = ""
_PJnx.Visible = true
_PJnx.Media = _5Mw_d
_PJnx.Choices = {
	"Close Book", 
	"Chapter 1: Werewolves", 
	"Chapter 2: Vampires", 
	"Chapter 3: Frankenstein", 
	"Chapter 4: Mummies"
}
_PJnx.InputType = "MultipleChoice"
_PJnx.Text = _OM3wC("\091\072\111\059\072\016\059\072\001\119\029\094\118\016\100\043\126\015\022\016\099\043\126\016\015\111\084\094\016\029\043\016\029\126\118\007\016\029\043\110")

-- WorksWithList for object commands --
_0XX.Commands._VxQom.WorksWithList = {
	_LyRR, 
	_OaV, 
	_IlSl, 
	_9gvjU, 
	_cbB4l
}

-- functions --
function _REJ:OnStart()
	local _Urwigo_Date = os.date "*t"
	if (_G[_OM3wC("\124\007\115")][_OM3wC("\040\015\001\029\033\043\118\071")] == _OM3wC("\091\111\007\122\081")) or (_G[_OM3wC("\124\007\115")][_OM3wC("\112\094\115\111\059\094\066\112")] == _OM3wC("\112\094\004\084\029\043\119")) then
		for k, v in pairs(_G[_OM3wC("\041\114\124\037")][_OM3wC("\090\015\015\006\023\068\055\094\059\029\004")]) do
			v[_OM3wC("\024\111\004\111\068\015\094")] = false
			v[_OM3wC("\090\059\029\111\115\094")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_OM3wC("\042\043\126\016\059\001\007\007\043\029\016\119\015\001\099\016\029\072\111\004\016\100\072\094\118\111\011\043\016\043\007\016\029\072\094\016\094\071\126\015\001\029\043\118\120")), 
			Callback = function(action)
				if action ~= nil then
					_G[_OM3wC("\091\072\094\118\111\011\043")][_OM3wC("\045\043\071\071\001\007\022")](_OM3wC("\101\001\115\094\045\015\043\004\094"))
				end
			end
		}
		return
	end
	_p4f.Commands._iek.Enabled = false
	_x6EeP = _OM3wC("\001\007\016\094\071\119\099\016\118\043\126\007\022\016")
	_VIOv = 1
	if (_Urwigo_Date.hour >= 15) and (_Urwigo_Date.hour <= 23) then
		_b6V.Active = true
		_Urwigo.MessageBox{
			Text = _OM3wC("\078\043\007\004\029\094\118\016\001\118\094\016\015\043\043\004\094\016\111\007\016\036\111\118\084\100\043\043\022\016\040\001\118\084\120\016\045\001\007\016\099\043\126\016\072\094\015\119\016\029\072\094\016\071\043\007\004\029\094\118\016\072\126\007\029\094\118\016\024\001\007\016\058\094\015\004\111\007\011\016\029\001\084\094\016\029\072\094\071\016\022\043\100\007\110\016\040\118\043\059\094\094\022\016\029\043\016\029\072\094\016\004\029\001\118\029\111\007\011\016\001\118\094\001\016\029\043\016\004\119\094\001\084\016\029\043\016\024\001\007\016\058\094\015\004\111\007\011\120"), 
			Media = _FmAlo, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\042\043\126\016\033\111\007\022\016\001\016\068\043\043\084\016\043\007\016\071\043\007\004\029\094\118\004\016\111\007\016\099\043\126\118\016\068\001\059\084\119\001\059\084\120\016\025\072\111\004\016\071\001\099\016\068\094\016\072\094\015\119\033\126\015\016\015\001\029\094\118\016\043\007\120"), 
						Media = _5Mw_d, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _OM3wC("\101\119\094\001\084\016\029\043\016\024\001\007\016\058\094\015\004\111\007\011\016\111\007\016\029\072\094\016\004\029\001\118\029\111\007\011\016\001\118\094\001\120\016"), 
									Media = _XGKZ, 
									Callback = function(action)
										if action ~= nil then
											_h7O0Y.Active = true
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_REJ:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _OM3wC("\025\072\111\004\016\111\004\016\001\016\007\111\011\072\029\016\029\111\071\094\016\100\072\094\118\111\011\043\120\016\042\043\126\016\100\111\015\015\016\007\094\094\022\016\029\043\016\059\043\071\094\016\068\001\059\084\016\068\094\029\100\094\094\007\016\029\072\094\016\072\043\126\118\004\016\043\033\016\121\021\049\049\016\001\007\022\016\108\108\021\049\049\016\119\071\120\016"), 
			Media = _Hr7rB
		}
		_RD3T:MoveTo(nil)
		_b6V.Active = false
	end
end
function _REJ:OnRestore()
end
function _b6V:OnProximity()
	_zNbH = _OM3wC("\041\068\057\024")
	if _1Dr0 == 1 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\004\094\094\016\024\001\007\016\058\094\015\004\111\007\011\016\004\029\001\007\022\111\007\011\016\007\094\001\118\068\099\120\016\101\119\094\001\084\016\029\043\016\072\111\071\016\100\072\094\007\016\099\043\126\016\011\094\029\016\001\016\059\072\001\007\059\094\120"), 
			Media = _464c, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _1Dr0 == 2 then
	end
end
function _b6V:OnSetActive()
	_zNbH = _OM3wC("\041\068\057\024")
	_Urwigo.GlobalZoneActiveChanged()
end
function __P0:OnProximity()
	_zNbH = _OM3wC("\041\041\040\049")
	if _r7w == 1 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\090\004\016\099\043\126\016\094\007\029\094\118\016\029\072\094\016\001\118\094\001\082\016\099\043\126\016\004\094\094\016\001\016\015\001\118\011\094\016\011\118\094\094\007\016\004\015\111\071\099\016\059\118\094\001\029\126\118\094\016\004\100\001\015\015\043\100\111\007\011\016\011\043\068\004\016\043\033\016\059\001\007\022\099\016\033\118\043\071\016\029\072\094\016\059\043\007\059\094\004\004\111\043\007\016\004\029\001\007\022\120"), 
			Media = _R6op, 
			Callback = function(action)
				if action ~= nil then
					_r7w = 2
					Wherigo.PlayAudio(_qLBu)
					_Urwigo.MessageBox{
						Text = _OM3wC("\066\029\035\004\016\101\015\111\071\094\118\016\033\118\043\071\016\029\072\094\016\003\072\043\004\029\068\126\004\029\094\118\004\080\080"), 
						Media = _HA3B, 
						Buttons = {
							_OM3wC("\101\015\111\071\094\118\080")
						}, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _OM3wC("\058\111\016\029\072\094\118\094\080\016\066\016\072\094\001\118\022\016\099\043\126\016\007\094\094\022\016\004\043\071\094\016\001\071\071\043\016\029\043\016\029\001\084\094\016\022\043\100\007\016\029\072\094\016\094\115\111\015\016\071\043\007\004\029\094\118\004\120"), 
									Media = _HA3B, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											_Urwigo.MessageBox{
												Text = _OM3wC("\078\043\007\004\029\094\118\004\016\001\118\094\016\033\111\007\111\059\084\099\016\001\007\022\016\059\001\007\016\043\007\015\099\016\068\094\016\022\001\071\001\011\094\022\016\100\111\029\072\016\001\016\059\094\118\029\001\111\007\016\084\111\007\022\016\043\033\016\001\071\071\043\120\016\097\043\118\016\094\027\001\071\119\015\094\082\016\111\033\016\099\043\126\016\100\001\007\029\016\029\043\016\029\001\084\094\016\022\043\100\007\016\001\016\100\111\029\059\072\016\099\043\126\016\072\001\115\094\016\029\043\016\029\072\118\043\100\016\100\001\029\094\118\016\043\007\016\072\094\118\120"), 
												Media = _HA3B, 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _OM3wC("\066\016\100\111\015\015\016\004\126\119\119\015\099\016\099\043\126\016\100\111\029\072\016\029\072\094\016\004\029\001\007\022\001\118\022\016\071\043\007\004\029\094\118\016\001\071\071\126\007\111\029\111\043\007\016\119\001\059\084\120\016\066\029\016\100\111\015\015\016\068\094\016\126\119\016\029\043\016\099\043\126\016\029\043\016\015\043\001\022\016\029\072\094\016\059\043\118\118\094\059\029\016\001\071\071\126\007\111\029\111\043\007\016\111\007\029\043\016\029\072\094\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
															Media = _HA3B, 
															Callback = function(action)
																if action ~= nil then
																	Wherigo.PlayAudio(_eZvAA)
																	_Urwigo.MessageBox{
																		Text = _OM3wC("\078\043\007\004\029\094\118\016\090\071\071\043\016\040\001\059\084"), 
																		Media = _syL, 
																		Buttons = {
																			_OM3wC("\051\111\059\094\080")
																		}, 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _OM3wC("\097\118\001\007\084\094\007\004\029\094\111\007\082\016\091\043\015\033\071\001\007\082\016\001\007\022\016\029\072\094\016\078\126\071\071\099\016\001\118\094\016\007\094\001\118\068\099\120\016\091\094\016\007\094\094\022\016\029\043\016\029\001\084\094\016\029\072\094\071\016\043\126\029\120\016\058\111\007\029\021\016\094\001\059\072\016\071\043\007\004\029\094\118\016\100\111\015\015\016\043\007\015\099\016\068\094\016\094\033\033\094\059\029\094\022\016\068\099\016\001\016\059\094\118\029\001\111\007\016\029\099\119\094\016\043\033\016\001\071\071\126\007\111\029\111\043\007\120\016\078\001\084\094\016\004\126\118\094\016\099\043\126\016\015\043\001\022\016\029\072\094\016\059\043\118\118\094\059\029\016\001\071\071\043\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
																					Media = _XGKZ, 
																					Callback = function(action)
																						if action ~= nil then
																							_DJz:MoveTo(Player)
																							_cQW.Active = true
																							_cQW.Visible = true
																							_TVHlb.Visible = true
																							_2BD.Active = true
																							_TVHlb.Active = true
																							_2BD.Visible = true
																							_KdL.Active = true
																							_BotfC()
																							_r7w = 3
																							Wherigo.Command "StopSound"
																							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																							_REJ:RequestSync()
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _r7w == 2 then
	elseif _r7w == 3 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\090\004\016\099\043\126\016\094\007\029\094\118\016\029\072\094\016\001\118\094\001\082\016\099\043\126\016\004\094\094\016\001\016\015\001\118\011\094\016\011\118\094\094\007\016\004\015\111\071\099\016\059\118\094\001\029\126\118\094\016\004\100\001\015\015\043\100\111\007\011\016\011\043\068\004\016\043\033\016\059\001\007\022\099\016\033\118\043\071\016\029\072\094\016\059\043\007\059\094\004\004\111\043\007\016\004\029\001\007\022\120"), 
			Media = _R6op, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function __P0:OnSetActive()
	_zNbH = _OM3wC("\041\041\040\049")
	_Urwigo.GlobalZoneActiveChanged()
end
function _kR_Le:OnProximity()
	_zNbH = _OM3wC("\041\084\114\041\074\094")
	if _LJBg == 1 then
		_foJfC()
	elseif _lIYj == 2 then
		Wherigo.PlayAudio(_zdiH)
		_Urwigo.MessageBox{
			Text = _OM3wC("\090\004\016\099\043\126\016\094\007\029\094\118\016\029\072\094\016\029\072\094\001\029\118\094\016\001\016\059\043\015\022\007\094\004\004\016\004\126\118\118\043\126\007\022\004\016\029\072\094\016\001\118\094\001\120\016\042\043\126\016\004\094\007\004\094\016\112\118\001\059\126\015\001\016\111\004\016\007\094\001\118\068\099\120"), 
			Media = _gTiz, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\112\118\001\059\126\015\001\016\071\043\115\094\004\016\029\043\016\001\029\029\001\059\084\016\099\043\126\080"), 
						Media = _F5tD, 
						Buttons = {
							_OM3wC("\042\111\084\094\004\080")
						}, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _OM3wC("\025\072\111\004\016\043\007\094\016\111\004\016\001\015\015\016\126\119\016\029\043\016\099\043\126\120\016\042\043\126\016\071\111\011\072\029\016\072\001\115\094\016\029\043\016\033\111\118\094\016\071\126\015\029\111\119\015\094\016\004\072\043\029\004\016\029\043\016\029\001\084\094\016\072\111\071\016\022\043\100\007\120\016\003\043\043\022\016\015\126\059\084\080"), 
									Media = __CX8d, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											Wherigo.Command "StopSound"
											_REJ:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _lIYj == 3 then
	end
end
function _kR_Le:OnSetActive()
	_zNbH = _OM3wC("\041\084\114\041\074\094")
	_Urwigo.GlobalZoneActiveChanged()
end
function _TVHlb:OnProximity()
	_zNbH = _OM3wC("\041\025\024\058\015\068")
	if _LJBg == 1 then
		_foJfC()
	elseif _uQI2F == 2 then
		__P0.Active = false
		Wherigo.PlayAudio(_4Ccho)
		_Urwigo.MessageBox{
			Text = _OM3wC("\091\111\029\072\111\007\016\029\072\094\016\100\043\043\022\004\016\099\043\126\016\072\094\001\118\016\001\016\118\126\004\029\015\111\007\011\016\007\094\001\118\068\099\016\001\007\022\016\001\016\059\118\094\001\029\126\118\094\016\001\119\119\094\001\118\004\016\068\094\033\043\118\094\016\099\043\126\021\016\029\072\094\016\071\126\071\071\099\080"), 
			Media = _PGSM, 
			Buttons = {
				_OM3wC("\066\029\035\004\016\029\072\094\016\078\126\071\071\099\080\080\080")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\025\072\094\016\071\126\071\071\099\016\071\043\115\094\004\016\029\043\100\001\118\022\004\016\099\043\126\016\029\043\016\001\029\029\001\059\084\080"), 
						Media = _ULI, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _OM3wC("\042\043\126\016\007\094\094\022\016\029\043\016\029\001\084\094\016\022\043\100\007\016\029\072\094\016\078\126\071\071\099\080\016\023\007\015\099\016\001\016\059\094\118\029\001\111\007\016\029\099\119\094\016\043\033\016\001\071\071\043\016\100\111\015\015\016\001\033\033\094\059\029\016\072\111\071\120\016\078\001\084\094\016\004\126\118\094\016\099\043\126\016\015\043\001\022\016\029\072\094\016\059\043\118\118\094\059\029\016\001\071\071\043\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\016\068\094\033\043\118\094\016\033\111\118\111\007\011\016\001\029\016\072\111\071\080"), 
									Media = __CX8d, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_REJ:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _uQI2F == 3 then
	end
end
function _TVHlb:OnSetActive()
	_zNbH = _OM3wC("\041\025\024\058\015\068")
	_Urwigo.GlobalZoneActiveChanged()
end
function _cQW:OnProximity()
	_zNbH = _OM3wC("\041\059\046\091")
	if _LJBg == 1 then
		_foJfC()
	elseif _UysVr == 2 then
		Wherigo.PlayAudio(_kxYk0)
		__P0.Active = false
		_Urwigo.MessageBox{
			Text = _OM3wC("\090\004\016\099\043\126\016\094\007\029\094\118\016\111\007\029\043\016\029\072\094\016\022\001\118\084\016\100\043\043\022\004\016\099\043\126\016\004\094\007\004\094\016\022\001\007\011\094\118\016\007\094\001\118\068\099\120\016\025\072\094\016\091\043\015\033\071\001\007\016\001\119\119\094\001\118\004\080"), 
			Media = _5MYIr, 
			Buttons = {
				_OM3wC("\023\072\016\051\043\080\080\080")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\025\072\094\016\100\043\015\033\071\001\007\016\001\029\029\001\059\084\004\080\016\112\043\016\004\043\071\094\029\072\111\007\011\016\068\094\033\043\118\094\016\111\029\035\004\016\029\043\043\016\015\001\029\094\080"), 
						Media = _fpVoC, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _OM3wC("\042\043\126\016\007\094\094\022\016\029\043\016\029\001\084\094\016\072\111\071\016\022\043\100\007\080\016\023\007\015\099\016\001\016\059\094\118\029\001\111\007\016\029\099\119\094\016\043\033\016\001\071\071\043\016\100\111\015\015\016\001\033\033\094\059\029\016\091\043\015\033\071\001\007\120\016\078\001\084\094\016\004\126\118\094\016\099\043\126\016\015\043\001\022\016\029\072\094\016\059\043\118\118\094\059\029\016\001\071\071\043\016\111\007\029\043\016\099\043\126\118\016\011\126\007\016\068\094\033\043\118\094\016\033\111\118\111\007\011\016\001\029\016\072\111\071\080"), 
									Media = __CX8d, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_REJ:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _UysVr == 3 then
	end
end
function _cQW:OnSetActive()
	_zNbH = _OM3wC("\041\059\046\091")
	_Urwigo.GlobalZoneActiveChanged()
end
function _2BD:OnProximity()
	_zNbH = _OM3wC("\041\081\096\112")
	if _LJBg == 1 then
		_foJfC()
	elseif _lzo == 2 then
		__P0.Active = false
		Wherigo.PlayAudio(_TgI)
		_Urwigo.MessageBox{
			Text = _OM3wC("\101\029\001\007\022\111\007\011\016\007\094\001\118\016\029\072\094\016\068\001\004\094\016\043\033\016\029\072\094\016\029\043\100\094\118\016\099\043\126\016\004\094\094\016\097\118\001\007\084\094\007\004\029\094\111\007\080"), 
			Media = _vS4Zm, 
			Buttons = {
				_OM3wC("\042\111\084\094\004\080")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\097\118\001\007\084\094\007\004\029\094\111\007\016\071\043\115\094\004\016\029\043\016\001\029\029\001\059\084\016\099\043\126\080\080\080"), 
						Media = _ZavJ, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _OM3wC("\042\043\126\016\007\094\094\022\016\029\043\016\029\001\084\094\016\022\043\100\007\016\097\118\001\007\084\094\007\004\029\094\111\007\080\016\023\007\015\099\016\001\016\059\094\118\029\001\111\007\016\029\099\119\094\016\043\033\016\001\071\071\043\016\100\111\015\015\016\001\033\033\094\059\029\016\072\111\071\120\016\078\001\084\094\016\004\126\118\094\016\099\043\126\016\015\043\001\022\016\029\072\094\016\059\043\118\118\094\059\029\016\001\071\071\043\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\016\068\094\033\043\118\094\016\033\111\118\111\007\011\016\001\029\016\072\111\071\080"), 
									Media = __CX8d, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_REJ:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _lzo == 3 then
	end
end
function _2BD:OnSetActive()
	_zNbH = _OM3wC("\041\081\096\112")
	_Urwigo.GlobalZoneActiveChanged()
end
function _Vfq:OnProximity()
	_zNbH = _OM3wC("\041\024\033\010")
	if _7zHJQ ~= true then
		_7zHJQ = true
		_REJ.Complete = true
		_Urwigo.MessageBox{
			Text = _OM3wC("\101\094\001\118\059\072\016\033\043\118\016\001\016\072\043\007\094\099\004\126\059\084\015\094\016\029\118\094\094\016\111\007\016\029\072\094\016\011\118\043\115\094\120\016\025\072\094\016\059\001\059\072\094\016\111\004\016\001\007\016\094\027\029\118\001\093\015\001\118\011\094\016\068\111\004\043\007\016\029\126\068\094\016\015\043\059\001\029\094\022\016\001\029\021\016\051\016\122\125\016\122\121\120\057\125\049\016\077\007\068\004\119\038\091\016\002\049\016\081\121\120\002\121\034\120"), 
			Media = _GV9, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_OM3wC("\025\072\111\004\016\100\072\094\118\111\011\043\016\111\004\016\007\043\100\016\059\043\071\119\015\094\029\094\120\016\042\043\126\118\016\119\015\001\099\094\118\016\059\043\071\119\015\094\029\111\043\007\016\059\043\022\094\016\111\004\021\016")..string.sub(Player.CompletionCode, 1, 15)).._OM3wC("\016\025\072\111\004\016\059\043\022\094\016\111\004\016\126\004\094\022\016\029\043\016\015\043\011\016\099\043\126\118\016\011\001\071\094\016\043\007\016\100\072\094\118\111\011\043\120\059\043\071\120\016\066\029\016\111\004\016\001\015\004\043\016\001\115\001\111\015\001\068\015\094\016\111\007\016\099\043\126\118\016\111\007\115\094\007\029\043\118\099\120\016"), 
						Media = _Hr7rB, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _OM3wC("\025\072\111\004\016\091\072\094\118\111\011\043\016\100\001\004\016\059\118\094\001\029\094\022\016\068\099\016\097\043\118\094\004\029\093\003\072\043\004\029\016\033\043\118\016\029\072\094\016\003\118\094\001\029\016\058\001\015\015\043\100\094\094\007\016\096\001\004\072\016\066\066\066\120\016\025\072\001\007\084\004\016\033\043\118\016\119\015\001\099\111\007\011\016\021\093\112"), 
									Media = _uDp, 
									Callback = function(action)
										if action ~= nil then
											_hPF.Complete = true
											_euYx:MoveTo(Player)
											_euYx.Description = string.sub(Player.CompletionCode, 1, 15)
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_REJ:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	end
end
function _Vfq:OnSetActive()
	_zNbH = _OM3wC("\041\024\033\010")
	_Urwigo.GlobalZoneActiveChanged()
end
function _WxA:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_om3T = input
	if Wherigo.NoCaseEquals(_om3T, _OM3wC("\101\111\015\115\094\118\016\096\126\015\015\094\029")) then
		_x6EeP = _OM3wC("\004\111\015\115\094\118\016\068\126\015\015\094\029")
		Wherigo.PlayAudio(_eZvAA)
		_hQn = 2
		_Q1V = 1
		_HLew1 = 1
		_5ysP = 1
		_pxpOD = 1
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\015\043\001\022\016\029\072\094\016\004\111\015\115\094\118\016\068\126\015\015\094\029\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
			Media = _lnduW, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_REJ:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_om3T, _OM3wC("\101\029\001\084\094")) then
		_x6EeP = _OM3wC("\004\029\001\084\094")
		Wherigo.PlayAudio(_eZvAA)
		_Q1V = 2
		_HLew1 = 1
		_hQn = 1
		_5ysP = 1
		_pxpOD = 1
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\015\043\001\022\016\029\072\094\016\004\029\001\084\094\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
			Media = _wwP, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_REJ:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_om3T, _OM3wC("\097\015\001\071\094")) then
		_x6EeP = _OM3wC("\033\015\001\071\094")
		Wherigo.PlayAudio(_eZvAA)
		_HLew1 = 2
		_5ysP = 1
		_hQn = 1
		_Q1V = 1
		_pxpOD = 1
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\015\043\001\022\016\029\072\094\016\033\015\001\071\094\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
			Media = _wCoVv, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_REJ:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_om3T, _OM3wC("\003\001\118\015\111\059")) then
		_x6EeP = _OM3wC("\011\001\118\015\111\059")
		Wherigo.PlayAudio(_eZvAA)
		_pxpOD = 2
		_5ysP = 1
		_Q1V = 1
		_5ysP = 1
		_HLew1 = 1
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\015\043\001\022\016\029\072\094\016\011\001\118\015\111\059\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
			Media = _KrN, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_REJ:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_om3T, _OM3wC("\058\043\015\099\016\101\099\071\068\043\015")) then
		_x6EeP = _OM3wC("\072\043\015\099\016\004\099\071\068\043\015")
		Wherigo.PlayAudio(_eZvAA)
		_5ysP = 2
		_hQn = 1
		_Q1V = 1
		_HLew1 = 1
		_pxpOD = 1
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\015\043\001\022\016\029\072\094\016\072\043\015\099\016\004\099\071\068\043\015\016\111\007\029\043\016\099\043\126\118\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
			Media = _17t, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_REJ:RequestSync()
				end
			end
		}
	else
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end
end
function _R30:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_uzVK = input
	if Wherigo.NoCaseEquals(_uzVK, _OM3wC("\058\043\100\016\001\118\094\016\099\043\126\110")) then
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\100\001\007\029\016\029\043\016\084\007\043\100\016\072\043\100\016\066\016\001\071\016\022\043\111\007\011\110\110\110\016\058\071\071\082\016\007\043\016\043\007\094\016\072\001\004\016\001\004\084\094\022\016\071\094\016\029\072\001\029\016\068\094\033\043\118\094\120"), 
			Media = _HA3B, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					_Urwigo.MessageBox{
						Text = _OM3wC("\091\094\015\015\016\004\111\007\059\094\016\099\043\126\016\001\004\084\094\022\016\066\016\072\001\115\094\016\007\043\029\016\068\094\094\007\016\022\043\111\007\011\016\004\043\016\100\094\015\015\120\016\042\043\126\016\004\094\094\016\066\016\072\001\115\094\016\068\094\094\007\016\004\029\126\059\084\016\094\001\029\111\007\011\016\059\001\007\022\099\016\001\007\022\016\004\100\094\094\029\004\016\001\015\015\016\022\001\099\016\068\126\029\016\100\072\001\029\016\066\016\118\094\001\015\015\099\016\007\094\094\022\016\111\004\016\004\043\071\094\029\072\111\007\011\016\004\001\115\043\118\099\120\016\066\033\016\099\043\126\016\059\001\007\016\033\111\007\022\016\071\094\016\004\043\071\094\016\004\001\115\043\118\099\016\033\043\043\022\016\111\029\016\100\043\126\015\022\016\071\001\084\094\016\071\094\016\118\094\001\015\015\099\016\072\001\119\119\099\120"), 
						Media = _HA3B, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_REJ:RequestSync()
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = (_OM3wC("\003\043\043\022\016\029\001\015\084\016")..Player.Name).._OM3wC("\120\016\045\043\071\094\016\068\001\059\084\016\111\033\016\099\043\126\016\007\094\094\022\016\001\007\099\029\072\111\007\011\016\094\015\004\094\120"), 
			Media = _HA3B, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					_REJ:RequestSync()
				end
			end
		}
	end
end
function _PJnx:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 50403 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\042\043\126\016\059\015\043\004\094\016\029\072\094\016\068\043\043\084\120"), 
			Media = _5Mw_d, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 46520 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\124\115\094\007\016\001\016\071\001\007\016\100\072\043\016\111\004\016\119\126\118\094\016\111\007\016\072\094\001\118\029\016\001\007\022\016\004\001\099\004\016\072\111\004\016\119\118\001\099\094\118\004\016\068\099\016\007\111\011\072\029\082\016\071\001\099\016\068\094\059\043\071\094\016\001\016\100\043\015\033\016\100\072\094\007\016\029\072\094\016\100\043\015\033\016\068\001\007\094\016\068\015\043\043\071\004\016\001\007\022\016\029\072\094\016\001\126\029\126\071\007\016\071\043\043\007\016\111\004\016\068\118\111\011\072\029\120"), 
			Media = _fpVoC, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\066\029\016\111\004\016\004\001\111\022\016\029\072\001\029\016\001\016\100\094\118\094\100\043\015\033\016\059\001\007\016\043\007\015\099\016\068\094\016\084\111\015\015\094\022\016\068\099\016\001\016\004\111\015\115\094\118\016\100\094\001\119\043\007\016\043\118\016\068\099\016\004\043\071\094\043\007\094\016\100\072\043\016\029\118\126\015\099\016\015\043\115\094\004\016\029\072\094\071\120"), 
						Media = _fpVoC, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_PJnx)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 36791 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\024\001\071\119\111\118\094\004\016\119\043\004\094\004\016\004\126\119\094\118\016\072\126\071\001\007\016\004\029\118\094\007\011\029\072\016\001\007\022\016\001\118\094\016\059\126\118\004\094\022\016\029\043\016\100\001\015\084\016\029\072\094\016\094\001\118\029\072\016\033\043\118\016\001\015\015\016\094\029\094\118\007\111\029\099\120\016\090\007\099\043\007\094\016\068\111\029\029\094\007\016\068\099\016\001\016\115\001\071\119\111\118\094\016\100\111\015\015\016\001\015\004\043\016\029\126\118\007\016\111\007\029\043\016\001\007\016\126\007\093\022\094\001\022\016\071\043\007\004\029\094\118\120"), 
			Media = _F5tD, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\024\001\071\119\111\118\094\004\016\001\118\094\016\001\015\071\043\004\029\016\111\007\115\111\007\059\111\068\015\094\082\016\068\126\029\016\029\072\094\118\094\016\001\118\094\016\001\016\033\094\100\016\100\001\099\004\016\029\043\016\022\001\071\001\011\094\016\029\072\094\071\021\016\011\001\118\015\111\059\082\016\072\043\015\099\016\004\099\071\068\043\015\004\082\016\004\126\007\015\111\011\072\029\082\016\001\007\022\016\001\016\004\029\001\084\094\016\029\072\118\043\126\011\072\016\029\072\094\016\072\094\001\118\029\120"), 
						Media = _F5tD, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_PJnx)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 4006 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\097\118\001\007\084\094\007\004\029\094\111\007\016\111\004\016\043\007\094\016\043\033\016\029\072\094\016\071\043\004\029\016\119\043\100\094\118\033\126\015\016\071\043\007\004\029\094\118\004\016\043\033\016\001\015\015\120\016\058\111\004\016\068\043\022\099\016\111\004\016\071\001\022\094\016\043\126\029\016\043\033\016\119\001\118\029\004\016\029\001\084\094\007\016\033\118\043\071\016\059\043\118\119\004\094\004\082\016\004\094\100\007\016\029\043\011\094\029\072\094\118\082\016\001\007\022\016\033\111\007\001\015\015\099\016\068\118\043\126\011\072\029\016\068\001\059\084\016\029\043\016\015\111\033\094\016\068\099\016\094\015\094\059\029\118\111\059\111\029\099\120"), 
			Media = _ZavJ, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\097\118\001\007\084\094\007\004\029\094\111\007\016\111\004\016\094\027\029\118\094\071\094\015\099\016\022\001\007\011\094\118\043\126\004\120\016\078\043\007\004\029\094\118\016\094\027\119\094\118\029\004\016\059\015\001\111\071\016\029\072\001\029\016\043\007\015\099\016\033\015\001\071\094\004\016\059\001\007\016\059\043\071\119\015\094\029\094\015\099\016\022\094\004\029\118\043\099\111\007\011\016\072\111\004\016\068\043\022\099\120\016"), 
						Media = _ZavJ, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_PJnx)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 52543 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\078\126\071\071\111\094\004\016\001\118\094\016\029\072\094\016\118\094\093\001\007\111\071\001\029\094\022\016\059\043\118\119\004\094\004\016\043\033\016\001\007\059\111\094\007\029\016\124\011\099\119\029\111\001\007\016\119\118\111\094\004\029\004\120\016\090\016\071\126\071\071\099\016\100\111\015\015\016\001\118\111\004\094\016\100\072\094\007\016\072\111\004\016\001\007\059\111\094\007\029\016\118\094\004\029\111\007\011\016\119\015\001\059\094\016\072\001\004\016\068\094\094\007\016\022\111\004\029\126\118\068\094\022\120"), 
			Media = _ULI, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\025\072\094\118\094\016\001\118\094\016\004\094\115\094\118\001\015\016\071\094\029\072\043\022\004\016\033\043\118\016\022\094\004\029\118\043\099\111\007\011\016\001\016\071\126\071\071\099\120\016\114\094\071\043\115\111\007\011\016\072\111\004\016\068\001\007\022\001\011\094\004\016\059\001\007\016\072\126\118\029\016\072\111\071\120\016\090\007\016\001\007\059\111\094\007\029\016\072\043\015\099\016\004\099\071\068\043\015\082\016\029\072\094\016\090\007\084\072\082\016\072\001\004\016\029\072\094\016\119\043\100\094\118\016\029\043\016\059\043\007\029\118\043\015\016\072\111\071\016\001\007\022\016\004\094\007\022\016\072\111\071\016\068\001\059\084\016\029\043\016\072\111\004\016\011\118\001\115\094\120"), 
						Media = _ULI, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_PJnx)
								end)
							end
						end
					}
				end
			end
		}
	end
end
function _p4f:On_EWp(target)
	Wherigo.PlayAudio(_pwVB)
	_1Dr0 = 2
	_h7O0Y.Complete = true
	_Urwigo.MessageBox{
		Text = (_OM3wC("\058\094\015\015\043\016\029\072\094\118\094\016")..Player.Name).._OM3wC("\082\016\066\016\001\071\016\024\001\007\016\058\094\015\004\111\007\011\082\016\015\094\011\094\007\022\001\118\099\016\071\043\007\004\029\094\118\016\072\126\007\029\094\118\120\016\090\016\029\094\118\118\111\068\015\094\016\022\111\004\001\004\029\094\118\016\072\001\004\016\043\059\059\126\118\118\094\022\120\120\120"), 
		Media = __CX8d, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
				Wherigo.PlayAudio(_mdW)
				_Urwigo.MessageBox{
					Text = _OM3wC("\078\043\007\004\029\094\118\004\016\072\001\115\094\016\094\004\059\001\119\094\022\016\029\072\094\016\126\007\022\094\118\100\043\118\015\022\016\029\072\118\043\126\011\072\016\001\016\119\043\118\029\001\015\016\001\007\022\016\001\118\094\016\015\043\043\004\094\016\111\007\016\036\111\118\084\100\043\043\022\016\040\001\118\084\080\080\080"), 
					Media = _9az, 
					Buttons = {
						_OM3wC("\042\111\084\094\004\080")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _OM3wC("\112\118\001\059\126\015\001\082\016\097\118\001\007\084\094\007\004\029\094\111\007\082\016\091\043\015\033\071\001\007\082\016\001\007\022\016\029\072\094\016\078\126\071\071\099\016\072\001\115\094\016\001\015\015\016\094\004\059\001\119\094\022\120\016\091\094\016\007\094\094\022\016\029\043\016\022\043\016\004\043\071\094\029\072\111\007\011\016\068\094\033\043\118\094\016\004\043\071\094\043\007\094\016\011\094\029\004\016\072\126\118\029\080"), 
								Media = _FmAlo, 
								Buttons = {
									_OM3wC("\074\094\029\004\016\011\094\029\016\094\071\080"), 
									_OM3wC("\051\043\029\016\078\094\080")
								}, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.Command "StopSound"
										if action == "Button1" then
											_Urwigo.MessageBox{
												Text = _OM3wC("\025\001\084\094\016\029\072\111\004\016\040\120\036\120\124\120\016\078\094\029\094\118\120\016\066\029\016\100\111\015\015\016\071\094\001\004\126\118\094\016\029\072\094\016\001\071\043\126\007\029\016\043\033\016\040\004\099\059\072\043\093\036\111\007\094\029\111\059\016\039\078\043\007\004\029\094\118\008\016\124\007\094\118\011\099\016\111\007\016\029\072\094\016\001\118\094\001\016\004\043\016\100\094\016\059\001\007\016\033\111\007\022\016\043\126\029\016\100\072\094\118\094\016\029\072\094\016\071\043\007\004\029\094\118\004\016\001\118\094\016\072\111\022\111\007\011\120"), 
												Media = __CX8d, 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = "", 
															Media = _EpBr, 
															Buttons = {
																_OM3wC("\025\072\001\007\084\016\099\043\126\080")
															}, 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _OM3wC("\025\072\094\016\040\120\036\120\124\120\016\071\094\029\094\118\016\111\004\016\115\094\118\099\016\004\094\007\004\111\029\111\115\094\016\004\043\016\111\033\016\029\072\094\118\094\016\001\118\094\016\001\007\099\016\071\043\007\004\029\094\118\004\016\007\094\001\118\068\099\016\111\029\016\004\072\043\126\015\022\016\119\111\059\084\016\029\072\094\071\016\126\119\120\016\025\072\094\016\071\094\029\094\118\016\111\004\016\007\043\100\016\015\043\059\001\029\094\022\016\111\007\016\099\043\126\118\016\111\029\094\071\004\016\029\001\068\120\016\078\001\084\094\016\004\126\118\094\016\029\043\016\029\126\118\007\016\111\029\016\043\007\016\068\094\033\043\118\094\016\099\043\126\016\004\029\001\118\029\120"), 
																		Media = _EpBr, 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _OM3wC("\023\007\059\094\016\099\043\126\016\072\001\115\094\016\029\126\118\007\094\022\016\029\072\094\016\040\120\036\120\124\016\071\094\029\094\118\016\043\007\016\033\043\015\015\043\100\016\029\072\094\016\119\001\029\072\016\029\043\016\029\072\094\016\051\043\118\029\072\016\091\094\004\029\120\016\042\043\126\016\100\043\007\035\029\016\068\094\016\001\068\015\094\016\029\043\016\004\094\094\016\029\072\094\016\071\043\007\004\029\094\118\004\016\068\126\029\016\099\043\126\118\016\040\120\036\120\124\016\071\094\029\094\118\016\004\072\043\126\015\022\016\119\111\059\084\016\029\072\094\071\016\126\119\120"), 
																					Media = _EpBr, 
																					Callback = function(action)
																						if action ~= nil then
																							_Urwigo.MessageBox{
																								Text = _OM3wC("\025\126\118\007\016\043\007\016\099\043\126\118\016\040\120\036\120\124\016\071\094\029\094\118\016\043\007\016\039\015\043\059\001\029\094\022\016\111\007\016\099\043\126\118\016\111\007\115\094\007\029\043\118\099\008\016\001\007\022\016\033\043\015\015\043\100\016\029\072\094\016\119\001\029\072\016\029\043\016\029\072\094\016\007\043\118\029\072\016\100\094\004\029\016\029\043\016\033\111\007\022\016\029\072\094\016\071\043\007\004\029\094\118\004\120"), 
																								Media = _XGKZ, 
																								Callback = function(action)
																									if action ~= nil then
																										_bgMN:MoveTo(Player)
																										_1Dr0 = 1
																										_4Mbj6.Active = true
																										_p4f.Commands._EWp.Enabled = false
																										_p4f.Commands._iek.Enabled = true
																										Wherigo.Command "StopSound"
																										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																										_REJ:RequestSync()
																									end
																								end
																							}
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										elseif action == "Button2" then
											_Urwigo.MessageBox{
												Text = _OM3wC("\066\033\016\099\043\126\016\059\072\001\007\011\094\016\099\043\126\118\016\071\111\007\022\016\099\043\126\016\084\007\043\100\016\100\072\094\118\094\016\029\043\016\033\111\007\022\016\071\094\120"), 
												Media = __CX8d, 
												Callback = function(action)
													if action ~= nil then
														_1Dr0 = 1
														Wherigo.Command "StopSound"
														_REJ:RequestSync()
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _p4f:On_iek(target)
	Wherigo.PlayAudio(_pwVB)
	_Urwigo.MessageBox{
		Text = (_OM3wC("\058\111\016")..Player.Name).._OM3wC("\016\099\043\126\016\001\118\094\016\022\043\111\007\011\016\011\043\043\022\120\016\023\007\059\094\016\099\043\126\016\072\001\115\094\016\029\126\118\007\094\022\016\029\072\094\016\040\120\036\120\124\120\016\078\094\029\094\118\016\043\007\016\033\043\015\015\043\100\016\029\072\094\016\119\001\029\072\016\029\043\016\029\072\094\016\051\043\118\029\072\091\094\004\029\082"), 
		Media = __CX8d, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _OM3wC("\066\033\016\099\043\126\016\011\094\029\016\004\029\126\059\084\082\016\059\072\094\059\084\016\029\072\094\016\029\001\004\084\004\016\071\094\007\126\120\016\042\043\126\016\100\111\015\015\016\033\111\007\022\016\072\111\007\029\004\016\029\072\094\118\094\016\001\068\043\126\029\016\100\072\001\029\016\029\043\016\022\043\016\007\094\027\029\120"), 
					Media = __CX8d, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.Command "StopSound"
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					end
				}
			end
		end
	}
end
function _IlSl:On_Az_(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_R30)
	end)
end
function _0XX:On_VxQom(target)
	if target == _LyRR then
		Wherigo.PlayAudio(_FhX)
		_nt7z()
		_Urwigo.MessageBox{
			Text = (((_OM3wC("\042\043\126\016\033\111\118\094\016\043\033\033\016\029\072\094\016").._x6EeP).._OM3wC("\016\001\029\016")).._LyRR.Name).._OM3wC("\120"), 
			Media = _RcM, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if _hQn == 2 then
						Wherigo.Command "StopSound"
						_Urwigo.MessageBox{
							Text = _OM3wC("\042\043\126\016\072\111\029\016\100\043\015\033\071\001\007\080"), 
							Media = _5MYIr, 
							Callback = function(action)
								if action ~= nil then
									_hQn = 1
									_x6EeP = _OM3wC("\094\071\119\029\099\016\118\043\126\007\022\016")
									_Z2YCh = _Z2YCh + 1
									Wherigo.PlayAudio(_PRM)
									_Urwigo.MessageBox{
										Text = _OM3wC("\025\072\094\016\004\111\015\115\094\118\016\068\126\015\015\094\029\016\004\029\118\111\084\094\004\016\029\118\126\094\016\001\007\022\016\029\072\094\016\091\043\015\033\071\001\007\016\022\111\004\001\119\119\094\001\118\004\016\111\007\029\043\016\001\016\059\015\043\126\022\016\043\033\016\022\126\004\029\120"), 
										Media = _kD5x, 
										Callback = function(action)
											if action ~= nil then
												if _Z2YCh == 4 then
													_KdL.Complete = true
													_Urwigo.MessageBox{
														Text = _OM3wC("\091\043\100\082\016\099\043\126\016\011\043\029\016\001\015\015\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\080\016\090\016\007\094\100\016\071\043\007\004\029\094\118\016\072\001\004\016\001\119\119\094\001\118\094\022\016\029\072\043\126\011\072\120\016\112\118\001\059\126\015\001\016\111\004\016\043\115\094\118\016\111\007\016\029\072\094\016\029\072\094\001\029\118\094\080"), 
														Media = __CX8d, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _OM3wC("\091\001\029\059\072\043\126\029\082\016\099\043\126\016\071\001\099\016\072\001\115\094\016\029\043\016\126\004\094\016\094\027\029\118\001\016\071\094\001\004\126\118\094\004\016\029\043\016\022\094\033\094\001\029\016\072\111\071\120\016\025\118\099\016\100\072\111\059\072\094\115\094\118\016\001\071\071\043\016\099\043\126\016\029\072\111\007\084\016\071\111\011\072\029\016\100\043\118\084\016\043\007\016\072\111\071\120"), 
																	Media = __CX8d, 
																	Buttons = {
																		_OM3wC("\090\071\071\043\110\016\066\016\011\043\029\016\029\072\111\004")
																	}, 
																	Callback = function(action)
																		if action ~= nil then
																			_Z2YCh = 0
																			_2BD.Active = false
																			_TVHlb.Active = false
																			_cQW.Active = false
																			_kR_Le.Active = true
																			_kR_Le.Visible = true
																			_lIYj = 2
																			_5FUv.Active = true
																			Wherigo.Command "StopSound"
																			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																			_REJ:RequestSync()
																		end
																	end
																}
															end
														end
													}
												else
													_Urwigo.MessageBox{
														Text = _OM3wC("\003\043\043\022\016\055\043\068\016\084\111\022\080\016\042\043\126\016\011\043\029\016\029\072\094\016\091\043\015\033\071\001\007\120\016\074\094\029\004\016\011\043\016\011\094\029\016\029\072\094\016\118\094\004\029\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\016\007\043\100\080"), 
														Media = __CX8d, 
														Callback = function(action)
															if action ~= nil then
																Wherigo.Command "StopSound"
																_cQW.Active = false
																_rTdD()
																Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																_REJ:RequestSync()
															end
														end
													}
												end
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_OM3wC("\051\043\029\072\111\007\011\016\072\001\119\119\094\007\004\082\016\029\072\094\016").._x6EeP).._OM3wC("\016\022\043\094\004\016\007\043\029\016\001\033\033\094\059\029\016\029\072\094\016\091\043\015\033\071\001\007\120\016"), 
							Media = _MgqS, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_x6EeP = _OM3wC("\094\071\119\029\099\016\118\043\126\007\022\016")
									_oSxh()
									_rTdD()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_REJ:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _OaV then
		Wherigo.PlayAudio(_FhX)
		_nt7z()
		_Urwigo.MessageBox{
			Text = (((_OM3wC("\042\043\126\016\033\111\118\094\016\043\033\033\016\029\072\094\016").._x6EeP).._OM3wC("\016\001\029\016")).._OaV.Name).._OM3wC("\120"), 
			Media = _RcM, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if _HLew1 == 2 then
						Wherigo.Command "StopSound"
						_Urwigo.MessageBox{
							Text = _OM3wC("\042\043\126\016\072\111\029\016\097\118\001\007\084\094\007\004\029\094\111\007\080"), 
							Media = _vS4Zm, 
							Callback = function(action)
								if action ~= nil then
									_HLew1 = 1
									_x6EeP = _OM3wC("\094\071\119\099\016\118\043\126\007\022\016")
									_Z2YCh = _Z2YCh + 1
									Wherigo.PlayAudio(_PRM)
									_Urwigo.MessageBox{
										Text = _OM3wC("\090\016\068\126\118\004\029\016\043\033\016\033\015\001\071\094\016\004\072\043\043\029\004\016\126\119\016\111\007\016\029\072\094\016\001\111\118\016\001\007\022\016\099\043\126\016\004\094\094\016\097\118\001\007\084\094\007\004\029\094\111\007\016\033\001\015\015\016\029\043\016\029\072\094\016\011\118\043\126\007\022\120"), 
										Media = _TD7ta, 
										Callback = function(action)
											if action ~= nil then
												if _Z2YCh == 4 then
													_KdL.Complete = true
													_Urwigo.MessageBox{
														Text = _OM3wC("\091\043\100\082\016\099\043\126\016\011\043\029\016\001\015\015\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\080\016\090\016\007\094\100\016\071\043\007\004\029\094\118\016\072\001\004\016\001\119\119\094\001\118\094\022\016\029\072\043\126\011\072\120\016\112\118\001\059\126\015\001\016\111\004\016\043\115\094\118\016\111\007\016\029\072\094\016\029\072\094\001\029\118\094\080"), 
														Media = __CX8d, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _OM3wC("\091\001\029\059\072\043\126\029\082\016\099\043\126\016\071\001\099\016\072\001\115\094\016\029\043\016\126\004\094\016\094\027\029\118\001\016\071\094\001\004\126\118\094\004\016\029\043\016\022\094\033\094\001\029\016\072\111\071\120\016\025\118\099\016\100\072\111\059\072\094\115\094\118\016\001\071\071\043\016\099\043\126\016\029\072\111\007\084\016\071\111\011\072\029\016\100\043\118\084\016\043\007\016\072\111\071\120"), 
																	Media = __CX8d, 
																	Buttons = {
																		_OM3wC("\090\071\071\043\110\016\066\016\011\043\029\016\029\072\111\004")
																	}, 
																	Callback = function(action)
																		if action ~= nil then
																			_Z2YCh = 0
																			_2BD.Active = false
																			_TVHlb.Active = false
																			_cQW.Active = false
																			_kR_Le.Active = true
																			_kR_Le.Visible = true
																			_lIYj = 2
																			_5FUv.Active = true
																			Wherigo.Command "StopSound"
																			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																			_REJ:RequestSync()
																		end
																	end
																}
															end
														end
													}
												else
													_Urwigo.MessageBox{
														Text = _OM3wC("\003\043\043\022\016\055\043\068\016\084\111\022\080\016\042\043\126\016\011\043\029\016\097\118\001\007\084\094\007\004\029\094\111\007\080\016\074\094\029\004\016\011\043\016\011\094\029\016\029\072\094\016\118\094\004\029\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\016\007\043\100\080"), 
														Media = __CX8d, 
														Callback = function(action)
															if action ~= nil then
																Wherigo.Command "StopSound"
																_2BD.Active = false
																_rTdD()
																Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																_REJ:RequestSync()
															end
														end
													}
												end
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_OM3wC("\051\043\029\072\111\007\011\016\072\001\119\119\094\007\004\082\016\029\072\094\016").._x6EeP).._OM3wC("\016\022\043\094\004\016\007\043\029\016\001\033\033\094\059\029\016\033\118\001\007\084\094\007\004\029\094\111\007\120\016"), 
							Media = _MgqS, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_x6EeP = _OM3wC("\094\071\119\029\099\016\118\043\126\007\022\016")
									_oSxh()
									_rTdD()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_REJ:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _9gvjU then
		Wherigo.PlayAudio(_FhX)
		_nt7z()
		_Urwigo.MessageBox{
			Text = (((_OM3wC("\042\043\126\016\033\111\118\094\016\043\033\033\016\029\072\094\016").._x6EeP).._OM3wC("\016\001\029\016")).._9gvjU.Name).._OM3wC("\120"), 
			Media = _RcM, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if ((_Q1V == 2) or (_pxpOD == 2)) or (_5ysP == 2) then
						Wherigo.PlayAudio(_9l9QD)
						_VIOv = _VIOv + 1
						_oSxh()
						_x6EeP = _OM3wC("\094\071\119\099\016\118\043\126\007\022\016")
						if _VIOv == 4 then
							_Urwigo.MessageBox{
								Text = _OM3wC("\042\043\126\016\011\043\029\016\072\111\071\080"), 
								Media = _gTiz, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(_PRM)
										_Urwigo.MessageBox{
											Text = _OM3wC("\112\118\001\059\126\015\001\016\033\111\007\001\015\015\099\016\033\001\015\015\004\016\029\043\016\029\072\094\016\011\118\043\126\007\022\016\001\007\022\016\001\016\119\111\015\015\001\118\016\043\033\016\004\071\043\084\094\016\004\072\043\043\029\004\016\126\119\016\033\118\043\071\016\100\072\094\118\094\016\072\094\016\004\029\043\043\022\120\016\042\043\126\016\022\094\033\094\001\029\094\022\016\112\118\001\059\126\015\001\080\080\080"), 
											Media = _TD7ta, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													Wherigo.PlayAudio(_mdW)
													_Urwigo.MessageBox{
														Text = _OM3wC("\042\043\126\016\072\094\001\118\016\001\016\011\118\094\001\029\016\072\043\100\015\111\007\011\016\100\111\007\022\016\001\007\022\016\001\016\119\043\118\029\001\015\016\043\119\094\007\004\016\126\119\016\111\007\016\029\072\094\016\001\111\118\120\016\025\072\094\016\071\043\007\004\029\094\118\004\016\033\015\099\016\029\072\118\043\126\011\072\016\029\072\094\016\119\043\118\029\001\015\016\001\007\022\016\068\001\059\084\016\111\007\029\043\016\029\072\094\016\126\007\022\094\118\100\043\118\015\022\120"), 
														Media = _9az, 
														Buttons = {
															_OM3wC("\024\111\059\029\043\118\099\080")
														}, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = (_OM3wC("\042\043\126\016\022\111\022\016\111\029\016")..Player.Name).._OM3wC("\080\016\042\043\126\016\033\111\007\001\015\015\099\016\022\094\033\094\001\029\094\022\016\001\015\015\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\080\016\066\016\022\111\022\007\035\029\016\029\072\111\007\084\016\111\029\016\100\001\004\016\119\043\004\004\111\068\015\094\120\016\090\004\016\001\016\004\119\094\059\111\001\015\016\118\094\100\001\118\022\016\066\016\015\094\033\029\016\099\043\126\016\004\043\071\094\029\072\111\007\011\016\068\094\072\111\007\022\016\029\072\094\016\059\094\071\094\029\094\118\099\016\039\094\007\029\094\118\016\033\118\043\071\016\029\072\094\016\004\029\118\094\094\029\008\120\016\025\072\094\016\059\043\043\118\022\111\007\001\029\094\004\016\001\118\094\016\111\007\016\099\043\126\118\016\111\007\115\094\007\029\043\118\099\120\016\025\072\001\007\084\004\016\001\011\001\111\007\080"), 
																	Media = __CX8d, 
																	Buttons = {
																		_OM3wC("\058\043\043\118\001\099\080\080\080")
																	}, 
																	Callback = function(action)
																		if action ~= nil then
																			_5FUv.Complete = true
																			_hPF.Active = true
																			_Vfq.Active = true
																			_kR_Le.Active = false
																			_ID_:MoveTo(Player)
																			_oSxh()
																			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																			_REJ:RequestSync()
																			Wherigo.Command "StopSound"
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						else
							_Urwigo.MessageBox{
								Text = _OM3wC("\042\043\126\016\072\111\029\016\112\118\001\059\126\015\001\080\016\058\094\016\072\111\004\004\094\004\016\001\029\016\099\043\126\016\068\126\029\016\111\004\016\007\043\029\016\022\094\001\022\016\099\094\029\120"), 
								Media = _gTiz, 
								Callback = function(action)
									if action ~= nil then
										_rTdD()
										Wherigo.Command "StopSound"
									end
								end
							}
						end
					else
						_Urwigo.MessageBox{
							Text = (_OM3wC("\051\043\029\072\111\007\011\016\072\001\119\119\094\007\004\082\016\029\072\094\016").._x6EeP).._OM3wC("\016\022\043\094\004\016\007\043\029\016\001\033\033\094\059\029\016\112\118\001\059\126\015\001\120\016"), 
							Media = _MgqS, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_x6EeP = _OM3wC("\094\071\119\029\099\016\118\043\126\007\022\016")
									_oSxh()
									_rTdD()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_REJ:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _cbB4l then
		Wherigo.PlayAudio(_FhX)
		_nt7z()
		_Urwigo.MessageBox{
			Text = (((_OM3wC("\042\043\126\016\033\111\118\094\016\043\033\033\016\029\072\094\016").._x6EeP).._OM3wC("\016\001\029\016\029\072\094\016")).._cbB4l.Name).._OM3wC("\120"), 
			Media = _RcM, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if _5ysP == 2 then
						_Urwigo.MessageBox{
							Text = _OM3wC("\042\043\126\016\072\111\029\016\029\072\094\016\078\126\071\071\099\080"), 
							Media = _PGSM, 
							Callback = function(action)
								if action ~= nil then
									_5ysP = 1
									_x6EeP = _OM3wC("\016\094\071\119\099\016\118\043\126\007\022\016")
									_Z2YCh = _Z2YCh + 1
									Wherigo.PlayAudio(_PRM)
									_Urwigo.MessageBox{
										Text = _OM3wC("\025\072\094\016\078\126\071\071\099\016\111\004\016\119\001\118\001\015\099\070\094\022\016\068\099\016\029\072\094\016\072\043\015\099\016\004\099\071\068\043\015\016\001\007\022\016\072\094\016\094\027\119\015\043\022\094\004\016\111\007\029\043\016\001\016\059\015\043\126\022\016\043\033\016\022\126\004\029\120"), 
										Media = _kD5x, 
										Callback = function(action)
											if action ~= nil then
												if _Z2YCh == 4 then
													_KdL.Complete = true
													_Urwigo.MessageBox{
														Text = _OM3wC("\091\043\100\082\016\099\043\126\016\011\043\029\016\001\015\015\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\080\016\090\016\007\094\100\016\071\043\007\004\029\094\118\016\072\001\004\016\001\119\119\094\001\118\094\022\016\029\072\043\126\011\072\120\016\112\118\001\059\126\015\001\016\111\004\016\043\115\094\118\016\111\007\016\029\072\094\016\029\072\094\001\029\118\094\080"), 
														Media = __CX8d, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _OM3wC("\091\001\029\059\072\043\126\029\082\016\099\043\126\016\071\001\099\016\072\001\115\094\016\029\043\016\126\004\094\016\094\027\029\118\001\016\071\094\001\004\126\118\094\004\016\029\043\016\022\094\033\094\001\029\016\072\111\071\120\016\025\118\099\016\100\072\111\059\072\094\115\094\118\016\001\071\071\043\016\099\043\126\016\029\072\111\007\084\016\071\111\011\072\029\016\100\043\118\084\016\043\007\016\072\111\071\120"), 
																	Media = __CX8d, 
																	Buttons = {
																		_OM3wC("\090\071\071\043\110\016\066\016\011\043\029\016\029\072\111\004")
																	}, 
																	Callback = function(action)
																		if action ~= nil then
																			_Z2YCh = 0
																			_2BD.Active = false
																			_TVHlb.Active = false
																			_cQW.Active = false
																			_kR_Le.Active = true
																			_kR_Le.Visible = true
																			_lIYj = 2
																			_5FUv.Active = true
																			Wherigo.Command "StopSound"
																			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																			_REJ:RequestSync()
																		end
																	end
																}
															end
														end
													}
												else
													_Urwigo.MessageBox{
														Text = _OM3wC("\003\043\043\022\016\055\043\068\016\084\111\022\080\016\042\043\126\016\011\043\029\016\029\072\094\016\078\126\071\071\099\080\016\074\094\029\004\016\011\043\016\011\094\029\016\029\072\094\016\118\094\004\029\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\016\007\043\100\080"), 
														Media = __CX8d, 
														Callback = function(action)
															if action ~= nil then
																Wherigo.Command "StopSound"
																_TVHlb.Active = false
																_rTdD()
																Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																_REJ:RequestSync()
															end
														end
													}
												end
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_OM3wC("\051\043\029\072\111\007\011\016\072\001\119\119\094\007\004\082\016\029\072\094\016").._x6EeP).._OM3wC("\016\022\043\094\004\016\007\043\029\016\001\033\033\094\059\029\016\029\072\094\016\078\126\071\071\099\120\016"), 
							Media = _MgqS, 
							Callback = function(action)
								if action ~= nil then
									_x6EeP = _OM3wC("\094\071\119\029\099\016\118\043\126\007\022\016")
									_oSxh()
									_rTdD()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_REJ:RequestSync()
									Wherigo.Command "StopSound"
								end
							end
						}
					end
				end
			end
		}
	elseif target == _IlSl then
		if _pxpOD == 2 then
			Wherigo.PlayAudio(_FhX)
			_Urwigo.MessageBox{
				Text = _OM3wC("\003\001\118\015\111\059\080\016\042\043\126\016\068\118\043\126\011\072\029\016\071\094\016\011\001\118\015\111\059\120\016\066\016\084\007\094\100\016\099\043\126\016\059\043\126\015\022\016\022\043\016\111\029\120\016\025\072\111\004\016\111\004\016\055\126\004\029\016\100\072\001\029\016\066\016\100\001\007\029\094\022\120\016\039\101\015\111\071\094\118\016\112\001\007\059\111\007\011\008\016\058\001\119\119\099\016\072\001\119\119\099\080\016\055\043\099\016\055\043\099\080\016\058\001\119\119\099\016\072\001\119\119\099\080\016\055\043\099\016\055\043\099\080\016\066\029\035\004\016\071\099\016\072\001\119\119\099\016\022\001\007\059\094\120\016\066\029\004\016\071\099\016\072\001\119\119\099\016\022\001\007\059\094\120\016\077\007\068\004\119\038\021\093\112"), 
				Media = _HA3B, 
				Callback = function(action)
					if action ~= nil then
						_x6EeP = _OM3wC("\094\071\119\099\016\118\043\126\007\022\016")
						_oSxh()
						_k8BT9 = true
						__P0.Active = false
						Wherigo.Command "StopSound"
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						_REJ:RequestSync()
					end
				end
			}
		else
			Wherigo.PlayAudio(_qLBu)
			_Urwigo.MessageBox{
				Text = _OM3wC("\023\126\059\072\080\016\112\043\007\035\029\016\004\072\043\043\029\016\071\094\120"), 
				Media = _HA3B, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
		end
	end
end
function _bgMN:On_vIJ(target)
	Wherigo.PlayAudio(_qqg)
	_Urwigo.MessageBox{
		Text = _OM3wC("\025\072\094\016\040\120\036\120\124\016\071\094\029\094\118\016\068\094\011\111\007\004\016\029\043\016\011\015\043\100\120\016\066\029\016\111\004\016\007\043\100\016\029\126\118\007\094\022\016\043\007\016\001\007\022\016\118\094\001\022\099\016\029\043\016\033\043\118\016\126\004\094\120"), 
		Media = _EpBr, 
		Buttons = {
			_OM3wC("\045\043\043\015\080")
		}, 
		Callback = function(action)
			if action ~= nil then
				_bgMN.Description = _OM3wC("\025\072\094\016\040\120\036\120\124\016\071\094\029\094\118\016\111\004\016\119\043\100\094\118\094\022\016\043\007\120")
				_bgMN.Commands._vIJ.Enabled = false
				_TVHlb.ProximityRange = Distance(182, "meters")
				_kR_Le.ProximityRange = Distance(182, "meters")
				_cQW.ProximityRange = Distance(182, "meters")
				_cQW.Active = true
				_kR_Le.Active = true
				_TVHlb.Active = true
				_TVHlb.Visible = false
				_kR_Le.Visible = false
				_cQW.Visible = false
				_9gvjU.Visible = false
				_OaV.Visible = false
				_cbB4l.Visible = false
				_LyRR.Visible = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				Wherigo.Command "StopSound"
				_REJ:RequestSync()
			end
		end
	}
end
function _DJz:On_YP3(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_WxA)
	end)
end
function _emcS:On__R0(target)
	_TVHlb.Visible = true
	__P0.Active = true
	_TVHlb.Active = true
	_cQW.Active = true
	_2BD.Active = true
	_DJz:MoveTo(Player)
	_ID_:MoveTo(Player)
	_euYx:MoveTo(Player)
	_Vfq.Active = true
	_0XX:MoveTo(Player)
	_bgMN:MoveTo(Player)
	_2BD.Visible = true
	_kR_Le.Visible = true
	_cQW.Visible = true
end
function _ID_:On_49F(target)
	_Urwigo.MessageBox{
		Text = _OM3wC("\025\072\094\016\011\094\043\059\001\059\072\094\016\111\004\016\015\043\059\001\029\094\022\016\001\029\016\051\016\122\125\016\122\121\120\057\125\049\016\091\016\002\049\016\081\121\120\002\121\034\120\016\101\094\001\118\059\072\016\029\072\094\016\072\043\007\094\099\004\126\059\084\015\094\016\029\118\094\094\016\111\007\016\029\072\094\016\011\118\043\115\094\120\016\042\043\126\016\001\118\094\016\015\043\043\084\111\007\011\016\033\043\118\016\001\007\016\094\027\029\118\001\093\015\001\118\011\094\016\068\111\004\043\007\016\029\126\068\094\016\001\029\016\029\072\094\016\068\001\004\094\016\043\033\016\029\072\094\016\029\072\118\094\094\016\029\118\126\007\084\016\029\118\094\094\120"), 
		Media = _GV9, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_REJ:RequestSync()
			end
		end
	}
end
function _RD3T:On_TKT_b(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_PJnx)
	end)
end
function _Urwigo.GlobalZoneActiveChanged()
	if _Z2YCh == 4 then
		_Urwigo.MessageBox{
			Text = _OM3wC("\091\043\100\082\016\099\043\126\016\011\043\029\016\001\015\015\016\043\033\016\029\072\094\016\071\043\007\004\029\094\118\004\080\016\066\029\016\015\043\043\084\004\016\015\111\084\094\016\029\072\094\118\094\016\111\004\016\043\007\094\016\015\001\004\029\016\071\043\007\004\029\094\118\016\029\072\043\126\011\072\120\016\112\118\001\059\126\015\001\016\072\001\004\016\001\119\119\094\001\118\094\022\016\001\007\022\016\072\094\016\111\004\016\043\115\094\118\016\043\007\016\029\072\094\016\071\001\111\007\016\004\029\001\011\094\120\016"), 
			Media = __CX8d, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _OM3wC("\042\043\126\016\071\001\099\016\072\001\115\094\016\029\043\016\126\004\094\016\094\027\029\118\001\016\071\094\001\004\126\118\094\004\016\029\043\016\022\094\033\094\001\029\016\072\111\071\120\016\025\118\099\016\100\072\111\059\072\094\115\094\118\016\001\071\071\043\016\099\043\126\016\029\072\111\007\084\016\071\111\011\072\029\016\100\043\118\084\016\043\007\016\072\111\071\120"), 
						Media = __CX8d, 
						Callback = function(action)
							if action ~= nil then
								_kR_Le.Active = true
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_REJ:RequestSync()
							end
						end
					}
				end
			end
		}
	end
end

-- Urwigo functions --
function _BotfC()
	_9gvjU.Visible = true
	_OaV.Visible = true
	_cbB4l.Visible = true
	_LyRR.Visible = true
end
function _foJfC()
	Wherigo.PlayAudio(_L3t)
	_Urwigo.MessageBox{
		Text = _OM3wC("\042\043\126\118\016\040\120\036\120\124\016\071\094\029\094\118\016\004\029\001\118\029\004\016\029\043\016\100\072\111\118\015\016\015\111\084\094\016\059\118\001\070\099\120\016\025\072\094\118\094\016\001\118\094\016\071\043\007\004\029\094\118\004\016\007\094\001\118\068\099\080"), 
		Media = _EpBr, 
		Callback = function(action)
			if action ~= nil then
				_4Mbj6.Complete = true
				Wherigo.Command "StopSound"
				_Urwigo.MessageBox{
					Text = _OM3wC("\024\094\118\099\016\007\111\059\094\080\016\042\043\126\016\072\001\115\094\016\033\043\126\007\022\016\029\072\094\016\071\043\007\004\029\094\118\004\120\016\066\029\016\015\043\043\084\004\016\015\111\084\094\016\097\118\001\007\084\094\007\004\029\094\111\007\082\016\091\043\015\033\071\001\007\016\001\007\022\016\029\072\094\016\078\126\071\071\099\016\001\118\094\016\001\015\015\016\007\094\001\118\068\099\120\016\042\043\126\016\100\111\015\015\016\007\094\094\022\016\001\016\100\094\001\119\043\007\016\029\043\016\033\111\011\072\029\016\029\072\094\071\120\016\025\001\084\094\016\029\072\111\004\016\071\043\007\004\029\094\118\016\119\072\001\004\094\016\011\126\007\120"), 
					Media = __CX8d, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.PlayAudio(_eZvAA)
							_Urwigo.MessageBox{
								Text = _OM3wC("\078\043\007\004\029\094\118\016\040\072\001\004\094\016\003\126\007"), 
								Media = _aRb, 
								Buttons = {
									_OM3wC("\025\072\001\007\084\016\099\043\126")
								}, 
								Callback = function(action)
									if action ~= nil then
										_0XX:MoveTo(Player)
										_Urwigo.MessageBox{
											Text = _OM3wC("\042\043\126\016\100\111\015\015\016\001\015\004\043\016\007\094\094\022\016\001\071\071\126\007\111\029\111\043\007\120\016\058\094\001\022\016\043\115\094\118\016\029\043\016\029\072\094\016\059\043\007\059\094\004\004\111\043\007\016\004\029\001\007\022\120\016\066\016\072\001\115\094\016\001\016\033\118\111\094\007\022\016\100\072\043\016\066\016\029\072\111\007\084\016\071\001\099\016\068\094\016\001\068\015\094\016\029\043\016\072\094\015\119\016\099\043\126\120"), 
											Media = __CX8d, 
											Callback = function(action)
												if action ~= nil then
													_cQW.ProximityRange = Distance(8, "meters")
													_TVHlb.ProximityRange = Distance(8, "meters")
													_2BD.ProximityRange = Distance(8, "meters")
													_kR_Le.ProximityRange = Distance(8, "meters")
													_2BD.Active = false
													_TVHlb.Active = false
													_cQW.Active = false
													_kR_Le.Active = false
													_b6V.Active = false
													__P0.Active = true
													_LJBg = 2
													_uQI2F = 2
													_lzo = 2
													_lIYj = 2
													_UysVr = 2
													Wherigo.Command "StopSound"
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													_REJ:RequestSync()
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _oSxh()
	_hQn = 1
	_pxpOD = 1
	_5ysP = 1
	_HLew1 = 1
	_Q1V = 1
end
function _nt7z()
	_UysVr = 3
	_lIYj = 3
	_lzo = 3
	_uQI2F = 3
	_REJ:RequestSync()
end
function _rTdD()
	_UysVr = 2
	_lIYj = 2
	_lzo = 2
	_uQI2F = 2
	_REJ:RequestSync()
end

-- Begin user functions --
-- End user functions --
return _REJ
