require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _0X4a(str)
	local res = ""
    local dtable = "\082\091\047\024\125\028\002\088\056\012\071\003\086\067\006\104\098\008\122\011\106\061\020\004\030\116\117\073\013\025\068\081\035\057\085\044\010\069\062\093\064\115\045\076\103\022\102\054\060\042\075\036\094\110\050\063\015\113\100\046\059\017\108\070\051\111\112\077\083\016\023\034\021\032\105\038\052\065\033\031\055\058\001\095\121\018\005\078\066\084\092\014\041\097\007\119\101\118\049\089\096\037\009\107\120\053\048\029\126\123\079\043\099\074\000\080\072\114\090\087\109\124\027\026\039\040\019"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

objCSIOGRA = Wherigo.ZCartridge()

-- Media --
objWaffe = Wherigo.ZMedia(objCSIOGRA)
objWaffe.Id = "8ae1ea6e-4e9f-410f-9ddc-52adfeda2547"
objWaffe.Name = _0X4a("\120\094\047\047\097")
objWaffe.Description = ""
objWaffe.AltText = ""
objWaffe.Resources = {
	{
		Type = "png", 
		Filename = "Waffe.png", 
		Directives = {}
	}
}
objStefanHaslinger = Wherigo.ZMedia(objCSIOGRA)
objStefanHaslinger.Id = "b2e39592-95a1-4b2e-8cf6-621a9c5e21ae"
objStefanHaslinger.Name = _0X4a("\069\026\097\047\094\054\074\117\094\042\063\075\054\045\097\118")
objStefanHaslinger.Description = ""
objStefanHaslinger.AltText = _0X4a("\089\075\063\059\074\054\075\113\016\026\074\059\094\074\008\031")
objStefanHaslinger.Resources = {
	{
		Type = "png", 
		Filename = "stefan1.png", 
		Directives = {}
	}
}
objTatort = Wherigo.ZMedia(objCSIOGRA)
objTatort.Id = "db8bc46d-ae27-448a-b0e2-05e25dde8307"
objTatort.Name = _0X4a("\090\094\026\066\118\026")
objTatort.Description = ""
objTatort.AltText = ""
objTatort.Resources = {
	{
		Type = "png", 
		Filename = "tatort.png", 
		Directives = {}
	}
}
objBuro = Wherigo.ZMedia(objCSIOGRA)
objBuro.Id = "2f8dc187-d083-405f-bbc6-3faa2198ed6c"
objBuro.Name = _0X4a("\089\027\118\066")
objBuro.Description = ""
objBuro.AltText = ""
objBuro.Resources = {
	{
		Type = "png", 
		Filename = "buro.png", 
		Directives = {}
	}
}
objLaborantin = Wherigo.ZMedia(objCSIOGRA)
objLaborantin.Id = "545d3086-3fba-4048-b233-86ccdcc5c5bd"
objLaborantin.Name = _0X4a("\044\094\017\066\118\094\054\026\075\054")
objLaborantin.Description = ""
objLaborantin.AltText = ""
objLaborantin.Resources = {
	{
		Type = "png", 
		Filename = "laborantin.png", 
		Directives = {}
	}
}
objAlex = Wherigo.ZMedia(objCSIOGRA)
objAlex.Id = "1701db2a-b2cc-4f7b-aaee-88b95eb3b717"
objAlex.Name = _0X4a("\078\063\097\105")
objAlex.Description = ""
objAlex.AltText = ""
objAlex.Resources = {
	{
		Type = "png", 
		Filename = "Laborant.png", 
		Directives = {}
	}
}
objKollege = Wherigo.ZMedia(objCSIOGRA)
objKollege.Id = "044bfefb-c651-4c27-95f2-c8400006acbc"
objKollege.Name = _0X4a("\051\066\063\063\097\045\097")
objKollege.Description = ""
objKollege.AltText = ""
objKollege.Resources = {
	{
		Type = "png", 
		Filename = "Kollege.png", 
		Directives = {}
	}
}
objKarte = Wherigo.ZMedia(objCSIOGRA)
objKarte.Id = "755693f6-5bd3-46fe-982f-9a41d83ae4ca"
objKarte.Name = _0X4a("\051\094\118\026\097")
objKarte.Description = ""
objKarte.AltText = ""
objKarte.Resources = {
	{
		Type = "png", 
		Filename = "Karte1.png", 
		Directives = {}
	}
}
objFreundin = Wherigo.ZMedia(objCSIOGRA)
objFreundin.Id = "708fc696-8ab6-4c10-90ac-9e61ed48aef2"
objFreundin.Name = _0X4a("\064\118\097\027\054\059\075\054")
objFreundin.Description = ""
objFreundin.AltText = ""
objFreundin.Resources = {
	{
		Type = "png", 
		Filename = "Freundin.png", 
		Directives = {}
	}
}
objLukasBaringer = Wherigo.ZMedia(objCSIOGRA)
objLukasBaringer.Id = "8c8fd0dc-4c6c-4d59-969b-46ba672bbfa1"
objLukasBaringer.Name = _0X4a("\044\027\104\094\042\074\089\094\118\075\054\045\097\118\074")
objLukasBaringer.Description = ""
objLukasBaringer.AltText = ""
objLukasBaringer.Resources = {
	{
		Type = "png", 
		Filename = "Bruder.png", 
		Directives = {}
	}
}
objHandy = Wherigo.ZMedia(objCSIOGRA)
objHandy.Id = "b0090208-845b-4a2e-b083-7988cb89ab35"
objHandy.Name = _0X4a("\117\094\054\059\085")
objHandy.Description = ""
objHandy.AltText = ""
objHandy.Resources = {
	{
		Type = "png", 
		Filename = "handy.png", 
		Directives = {}
	}
}
objKlingeln = Wherigo.ZMedia(objCSIOGRA)
objKlingeln.Id = "e05cea29-3239-4377-90a5-157da4ba6d84"
objKlingeln.Name = _0X4a("\051\063\075\054\045\097\063\054\074")
objKlingeln.Description = ""
objKlingeln.AltText = _0X4a("\051\094\054\054\074\063\097\075\059\097\118\074\054\075\113\016\026\074\094\054\045\097\019\097\075\045\026\074\096\097\118\059\097\054\074")
objKlingeln.Resources = {
	{
		Type = "mp3", 
		Filename = "TelefonKlingeln.mp3", 
		Directives = {}
	}
}
objfirma = Wherigo.ZMedia(objCSIOGRA)
objfirma.Id = "b921b7e8-5dcf-46de-8ebf-5284b698a817"
objfirma.Name = _0X4a("\047\075\118\121\094")
objfirma.Description = ""
objfirma.AltText = ""
objfirma.Resources = {
	{
		Type = "JPG", 
		Filename = "IMG_0473.JPG", 
		Directives = {}
	}
}
objPflaster = Wherigo.ZMedia(objCSIOGRA)
objPflaster.Id = "de7cb790-5134-41aa-99a7-e74c43729647"
objPflaster.Name = _0X4a("\116\047\063\094\042\026\097\118")
objPflaster.Description = ""
objPflaster.AltText = ""
objPflaster.Resources = {
	{
		Type = "jpg", 
		Filename = "pflaster-t14920_2.jpg", 
		Directives = {}
	}
}
objaufgabe = Wherigo.ZMedia(objCSIOGRA)
objaufgabe.Id = "bd1f6d1e-3aac-4a3d-8b4e-5e00f35ba22a"
objaufgabe.Name = _0X4a("\094\027\047\045\094\017\097")
objaufgabe.Description = ""
objaufgabe.AltText = ""
objaufgabe.Resources = {
	{
		Type = "png", 
		Filename = "aufgabe.png", 
		Directives = {}
	}
}
objPiktogramm = Wherigo.ZMedia(objCSIOGRA)
objPiktogramm.Id = "ee891aec-32f2-480d-996a-1c50aca904b5"
objPiktogramm.Name = _0X4a("\116\075\104\026\066\045\118\094\121\121")
objPiktogramm.Description = ""
objPiktogramm.AltText = ""
objPiktogramm.Resources = {
	{
		Type = "png", 
		Filename = "Pistole_CW.png", 
		Directives = {}
	}
}
-- Cartridge Info --
objCSIOGRA.Id="3f19d622-4e56-49bc-8ab2-6a58e16914d4"
objCSIOGRA.Name="CSI:OGRA"
objCSIOGRA.Description=[[Kannst du in der Rolle von Kommisar Lang den Mord an Bernard Kolm losen? ]]
objCSIOGRA.Visible=true
objCSIOGRA.Activity="Geocache"
objCSIOGRA.StartingLocationDescription=[[]]
objCSIOGRA.StartingLocation = ZonePoint(48.1483019182934,15.5512795480747,0)
objCSIOGRA.Version="1.0.2"
objCSIOGRA.Company=""
objCSIOGRA.Author="waelty"
objCSIOGRA.BuilderVersion="URWIGO 1.14.4469.18959"
objCSIOGRA.CreateDate="11/01/2011 12:31:34"
objCSIOGRA.PublishDate="1/1/0001 12:00:00 AM"
objCSIOGRA.UpdateDate="06/11/2012 20:14:47"
objCSIOGRA.LastPlayedDate="1/1/0001 12:00:00 AM"
objCSIOGRA.TargetDevice="PocketPC"
objCSIOGRA.TargetDeviceVersion="0"
objCSIOGRA.StateId="1"
objCSIOGRA.CountryId="2"
objCSIOGRA.Complete=false
objCSIOGRA.UseLogging=true

objCSIOGRA.Media=objTatort

objCSIOGRA.Icon=objPiktogramm


-- Zones --
objTatort1 = Wherigo.Zone(objCSIOGRA)
objTatort1.Id = "475edd27-5407-4935-8e8d-ccf50557ecc3"
objTatort1.Name = _0X4a("\090\094\026\066\118\026")
objTatort1.Description = ""
objTatort1.Visible = true
objTatort1.Media = objTatort
objTatort1.Commands = {}
objTatort1.DistanceRange = Distance(-1, "feet")
objTatort1.ShowObjects = "OnEnter"
objTatort1.ProximityRange = Distance(10, "meters")
objTatort1.AllowSetPositionTo = false
objTatort1.Active = true
objTatort1.Points = {
	ZonePoint(48.1483160112563, 15.5510083213449, 0), 
	ZonePoint(48.1484305443991, 15.5514213815331, 0), 
	ZonePoint(48.1483016945955, 15.5515501275659, 0), 
	ZonePoint(48.1481370527089, 15.55121216923, 0)
}
objTatort1.OriginalPoint = ZonePoint(48.14829632574, 15.5512979999185, 0)
objTatort1.DistanceRangeUOM = "Feet"
objTatort1.ProximityRangeUOM = "Meters"
objTatort1.OutOfRangeName = ""
objTatort1.InRangeName = ""
objLabor = Wherigo.Zone(objCSIOGRA)
objLabor.Id = "29fca8dc-d3fa-49c8-a32f-6b166404de05"
objLabor.Name = _0X4a("\044\094\017\066\118\074")
objLabor.Description = ""
objLabor.Visible = false
objLabor.Media = objBuro
objLabor.Commands = {}
objLabor.DistanceRange = Distance(-1, "feet")
objLabor.ShowObjects = "OnEnter"
objLabor.ProximityRange = Distance(200, "meters")
objLabor.AllowSetPositionTo = false
objLabor.Active = false
objLabor.Points = {
	ZonePoint(48.1469154202559, 15.5513922125101, 0), 
	ZonePoint(48.1468599416589, 15.5510609596968, 0), 
	ZonePoint(48.1468751535383, 15.5508571118116, 0), 
	ZonePoint(48.1470559061122, 15.5505888909101, 0), 
	ZonePoint(48.1472165248206, 15.5511716008186, 0), 
	ZonePoint(48.1469659773123, 15.5514492094517, 0)
}
objLabor.OriginalPoint = ZonePoint(48.146981487283, 15.5510866641998, 0)
objLabor.DistanceRangeUOM = "Feet"
objLabor.ProximityRangeUOM = "Meters"
objLabor.OutOfRangeName = ""
objLabor.InRangeName = ""
objArbeitsplatz = Wherigo.Zone(objCSIOGRA)
objArbeitsplatz.Id = "9e331726-8af7-4223-ad74-3f6973592fcb"
objArbeitsplatz.Name = _0X4a("\078\118\017\097\075\026\042\067\063\094\026\019")
objArbeitsplatz.Description = _0X4a("\117\075\097\118\074\094\118\017\097\075\026\097\026\097\074\059\094\042\074\111\067\047\097\118")
objArbeitsplatz.Visible = false
objArbeitsplatz.Media = objfirma
objArbeitsplatz.Commands = {}
objArbeitsplatz.DistanceRange = Distance(-1, "feet")
objArbeitsplatz.ShowObjects = "OnEnter"
objArbeitsplatz.ProximityRange = Distance(30, "meters")
objArbeitsplatz.AllowSetPositionTo = false
objArbeitsplatz.Active = false
objArbeitsplatz.Points = {
	ZonePoint(48.1485296422052, 15.5496165901423, 0), 
	ZonePoint(48.1486405957293, 15.5504105240107, 0), 
	ZonePoint(48.148160988451, 15.5506653338671, 0), 
	ZonePoint(48.1479283415149, 15.5499518662691, 0)
}
objArbeitsplatz.OriginalPoint = ZonePoint(48.1483148919751, 15.5501610785723, 0)
objArbeitsplatz.DistanceRangeUOM = "Feet"
objArbeitsplatz.ProximityRangeUOM = "Meters"
objArbeitsplatz.OutOfRangeName = ""
objArbeitsplatz.InRangeName = ""
objFlurgasse18 = Wherigo.Zone(objCSIOGRA)
objFlurgasse18.Id = "35a2f26e-0b4b-4844-bd6d-3200c9fa349d"
objFlurgasse18.Name = _0X4a("\064\063\027\118\045\094\042\042\097\074\099\009\074")
objFlurgasse18.Description = ""
objFlurgasse18.Visible = false
objFlurgasse18.Commands = {}
objFlurgasse18.DistanceRange = Distance(-1, "feet")
objFlurgasse18.ShowObjects = "OnEnter"
objFlurgasse18.ProximityRange = Distance(30, "meters")
objFlurgasse18.AllowSetPositionTo = false
objFlurgasse18.Active = true
objFlurgasse18.Points = {
	ZonePoint(48.1464644312146, 15.5491928011179, 0), 
	ZonePoint(48.146273833464, 15.5491619557142, 0), 
	ZonePoint(48.1464527985083, 15.5505352467299, 0), 
	ZonePoint(48.1466317629286, 15.5504038184881, 0), 
	ZonePoint(48.1465973123262, 15.5500759184361, 0)
}
objFlurgasse18.OriginalPoint = ZonePoint(48.1464840276883, 15.5498739480972, 0)
objFlurgasse18.DistanceRangeUOM = "Feet"
objFlurgasse18.ProximityRangeUOM = "Meters"
objFlurgasse18.OutOfRangeName = ""
objFlurgasse18.InRangeName = ""
objLukasBaringer1 = Wherigo.Zone(objCSIOGRA)
objLukasBaringer1.Id = "ca184779-5721-4b60-8f78-f1df9797bec8"
objLukasBaringer1.Name = _0X4a("\044\027\104\094\042\074\089\094\118\075\054\045\097\118\074")
objLukasBaringer1.Description = ""
objLukasBaringer1.Visible = false
objLukasBaringer1.Commands = {}
objLukasBaringer1.DistanceRange = Distance(-1, "feet")
objLukasBaringer1.ShowObjects = "OnEnter"
objLukasBaringer1.ProximityRange = Distance(30, "meters")
objLukasBaringer1.AllowSetPositionTo = false
objLukasBaringer1.Active = false
objLukasBaringer1.Points = {
	ZonePoint(48.1457011411286, 15.5502442270517, 0), 
	ZonePoint(48.1455257528228, 15.5502334982157, 0), 
	ZonePoint(48.1455830225396, 15.5508182197809, 0), 
	ZonePoint(48.1457440932754, 15.5508450418711, 0)
}
objLukasBaringer1.OriginalPoint = ZonePoint(48.1456385024416, 15.5505352467299, 0)
objLukasBaringer1.DistanceRangeUOM = "Feet"
objLukasBaringer1.ProximityRangeUOM = "Meters"
objLukasBaringer1.OutOfRangeName = ""
objLukasBaringer1.InRangeName = ""
objVersteck = Wherigo.Zone(objCSIOGRA)
objVersteck.Id = "451645c1-4cb8-4e8d-b125-b637b2cab700"
objVersteck.Name = _0X4a("\013\097\118\042\026\097\113\104\074")
objVersteck.Description = _0X4a("\117\075\097\118\074\016\094\026\074\044\027\104\094\042\074\089\094\118\075\054\045\097\118\074\059\094\042\074\011\097\063\059\074\098\097\118\042\026\097\113\104\026")
objVersteck.Visible = false
objVersteck.Commands = {}
objVersteck.DistanceRange = Distance(-1, "feet")
objVersteck.ShowObjects = "OnEnter"
objVersteck.ProximityRange = Distance(60, "meters")
objVersteck.AllowSetPositionTo = false
objVersteck.Active = false
objVersteck.Points = {
	ZonePoint(48.1342983972061, 15.5541453349877, 0), 
	ZonePoint(48.1344532381224, 15.5541788626003, 0), 
	ZonePoint(48.134467558646, 15.5539589214611, 0), 
	ZonePoint(48.1343207730899, 15.5539052772808, 0)
}
objVersteck.OriginalPoint = ZonePoint(48.1343849917661, 15.5540470990825, 0)
objVersteck.DistanceRangeUOM = "Feet"
objVersteck.ProximityRangeUOM = "Meters"
objVersteck.OutOfRangeName = ""
objVersteck.InRangeName = ""

-- Characters --
SpuSi = Wherigo.ZCharacter{
	Cartridge = objCSIOGRA, 
	Container = objTatort1
}
SpuSi.Id = "e4497e34-d013-4a87-bb6e-ef1a369357d6"
SpuSi.Name = _0X4a("\069\026\097\047\094\054\074\117\094\042\063\075\054\045\097\118")
SpuSi.Description = _0X4a("\069\067\027\118\097\054\042\075\113\016\097\118\027\054\045\042\043\014\016\097\047")
SpuSi.Visible = false
SpuSi.Media = objStefanHaslinger
SpuSi.Commands = {}
SpuSi.ObjectLocation = Wherigo.INVALID_ZONEPOINT
SpuSi.Gender = "Male"
SpuSi.Type = "NPC"
objJuliaHabe = Wherigo.ZCharacter{
	Cartridge = objCSIOGRA, 
	Container = objLabor
}
objJuliaHabe.Id = "c8748b86-7449-4cd6-8098-1e31c1aff77f"
objJuliaHabe.Name = _0X4a("\114\027\063\075\094\074\117\094\017\097")
objJuliaHabe.Description = _0X4a("\044\094\017\066\118\094\054\026\075\054\074")
objJuliaHabe.Visible = false
objJuliaHabe.Media = objLaborantin
objJuliaHabe.Commands = {}
objJuliaHabe.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objJuliaHabe.Gender = "Female"
objJuliaHabe.Type = "NPC"
objAlexanderHauschlid = Wherigo.ZCharacter{
	Cartridge = objCSIOGRA, 
	Container = objLabor
}
objAlexanderHauschlid.Id = "8e7392b0-c8dc-4aa8-b06c-48298f7e1b62"
objAlexanderHauschlid.Name = _0X4a("\078\063\097\105\094\054\059\097\118\074\117\094\027\042\113\016\063\075\059")
objAlexanderHauschlid.Description = _0X4a("\011\097\118\075\113\016\026\042\121\097\059\075\019\075\054\097\118")
objAlexanderHauschlid.Visible = false
objAlexanderHauschlid.Media = objAlex
objAlexanderHauschlid.Commands = {}
objAlexanderHauschlid.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objAlexanderHauschlid.Gender = "Male"
objAlexanderHauschlid.Type = "NPC"
objWolfgangRummer = Wherigo.ZCharacter{
	Cartridge = objCSIOGRA, 
	Container = objArbeitsplatz
}
objWolfgangRummer.Id = "560646dc-abb5-4333-9caf-a265835c3c5d"
objWolfgangRummer.Name = _0X4a("\120\066\063\047\045\094\054\045\074\001\027\121\121\097\118")
objWolfgangRummer.Description = _0X4a("\051\066\063\063\097\045\097\074\059\097\042\074\111\067\047\097\118\042")
objWolfgangRummer.Visible = false
objWolfgangRummer.Media = objKollege
objWolfgangRummer.Commands = {}
objWolfgangRummer.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objWolfgangRummer.Gender = "Male"
objWolfgangRummer.Type = "NPC"
objFranziskaHolzer = Wherigo.ZCharacter{
	Cartridge = objCSIOGRA, 
	Container = objFlurgasse18
}
objFranziskaHolzer.Id = "1f752bc1-bc53-4293-afbb-9b15c98d1922"
objFranziskaHolzer.Name = _0X4a("\064\118\094\054\019\075\042\104\094\074\117\066\063\019\097\118")
objFranziskaHolzer.Description = _0X4a("\064\118\097\027\054\059\075\054\074\059\097\042\074\111\067\047\097\118\042")
objFranziskaHolzer.Visible = false
objFranziskaHolzer.Media = objFreundin
objFranziskaHolzer.Commands = {}
objFranziskaHolzer.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objFranziskaHolzer.Gender = "Female"
objFranziskaHolzer.Type = "NPC"
objLukasBaringer2 = Wherigo.ZCharacter{
	Cartridge = objCSIOGRA, 
	Container = objLukasBaringer1
}
objLukasBaringer2.Id = "a243868d-c05b-4719-b8e2-998697035da2"
objLukasBaringer2.Name = _0X4a("\044\027\104\094\042\074\089\094\118\075\054\045\097\118\074")
objLukasBaringer2.Description = _0X4a("\089\118\027\059\097\118\074\059\097\042\074\111\067\047\097\118\042")
objLukasBaringer2.Visible = false
objLukasBaringer2.Media = objLukasBaringer
objLukasBaringer2.Commands = {}
objLukasBaringer2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objLukasBaringer2.Gender = "Male"
objLukasBaringer2.Type = "NPC"

-- Items --
objWaffe1 = Wherigo.ZItem{
	Cartridge = objCSIOGRA, 
	Container = objTatort1
}
objWaffe1.Id = "bad78f5d-f98f-4ac3-bbc1-cb92deff422f"
objWaffe1.Name = _0X4a("\120\094\047\047\097")
objWaffe1.Description = _0X4a("\090\094\026\096\094\047\047\097")
objWaffe1.Visible = false
objWaffe1.Media = objWaffe
objWaffe1.Commands = {}
objWaffe1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objWaffe1.Locked = false
objWaffe1.Opened = true
objPflaster1 = Wherigo.ZItem{
	Cartridge = objCSIOGRA, 
	Container = SpuSi
}
objPflaster1.Id = "289b5ea3-1546-4e6b-bb6e-553f85369991"
objPflaster1.Name = _0X4a("\116\047\063\094\042\026\097\118")
objPflaster1.Description = _0X4a("\038\075\054\074\116\047\063\094\042\026\097\118\060\074\013\066\121\074\090\094\097\026\097\118\074\056\056\056")
objPflaster1.Visible = false
objPflaster1.Media = objPflaster
objPflaster1.Icon = objPflaster
objPflaster1.Commands = {}
objPflaster1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objPflaster1.Locked = false
objPflaster1.Opened = false
objKarte1 = Wherigo.ZItem{
	Cartridge = objCSIOGRA, 
	Container = objWolfgangRummer
}
objKarte1.Id = "fa2a7de1-947e-4a57-8ee4-047ef9239a36"
objKarte1.Name = _0X4a("\051\094\118\026\097")
objKarte1.Description = ""
objKarte1.Visible = false
objKarte1.Media = objKarte
objKarte1.Icon = objKarte
objKarte1.Commands = {}
objKarte1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objKarte1.Locked = false
objKarte1.Opened = false
objUnlockcode = Wherigo.ZItem{
	Cartridge = objCSIOGRA, 
	Container = objVersteck
}
objUnlockcode.Id = "709a3aa9-35e2-4a60-9ce8-0562ecc5a140"
objUnlockcode.Name = _0X4a("\035\054\063\066\113\104\113\066\059\097\074")
objUnlockcode.Description = ""
objUnlockcode.Visible = false
objUnlockcode.Commands = {}
objUnlockcode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objUnlockcode.Locked = false
objUnlockcode.Opened = false

-- Tasks --
objTatortbesichtigung = Wherigo.ZTask(objCSIOGRA)
objTatortbesichtigung.Id = "6817b02e-2099-443c-a92c-ac240d1cf872"
objTatortbesichtigung.Name = _0X4a("\090\094\026\066\118\026\017\097\042\075\113\016\026\075\045\027\054\045")
objTatortbesichtigung.Description = _0X4a("\089\097\042\075\113\016\026\075\045\097\074\059\097\054\074\090\094\026\066\118\026\079")
objTatortbesichtigung.Visible = true
objTatortbesichtigung.Active = true
objTatortbesichtigung.Complete = false
objTatortbesichtigung.CorrectState = "None"
dna = Wherigo.ZTask(objCSIOGRA)
dna.Id = "ec68e0cd-ea47-434f-bfd9-9c7d8435be3f"
dna.Name = _0X4a("\031\088\078\043\090\097\042\026")
dna.Description = _0X4a("\089\118\075\054\045\074\059\094\042\074\116\047\063\094\042\026\097\118\074\075\054\042\074\044\094\017\066\118\074\027\054\059\074\042\067\118\097\113\016\097\074\121\075\026\074\059\097\121\074\011\097\118\075\113\016\026\042\121\097\059\075\019\075\054\097\118")
dna.Visible = false
dna.Active = true
dna.Complete = false
dna.CorrectState = "Correct"
objZeugenbefragung = Wherigo.ZTask(objCSIOGRA)
objZeugenbefragung.Id = "456ea671-bd09-417f-a2b2-3c584c7ff4fd"
objZeugenbefragung.Name = _0X4a("\119\097\027\045\097\054\017\097\047\118\094\045\027\054\045\074")
objZeugenbefragung.Description = _0X4a("\089\097\047\118\094\045\097\074\059\097\054\074\051\066\063\063\097\045\097\054\074\059\097\042\074\111\067\047\097\118\042\074\094\054\074\059\097\042\042\097\054\074\078\118\017\097\075\026\042\067\063\094\026\019")
objZeugenbefragung.Visible = false
objZeugenbefragung.Active = false
objZeugenbefragung.Complete = false
objZeugenbefragung.CorrectState = "None"
objWoistdieFlurgasse = Wherigo.ZTask(objCSIOGRA)
objWoistdieFlurgasse.Id = "8b0391fd-3b97-4539-9e6e-08c7e3752ed7"
objWoistdieFlurgasse.Name = _0X4a("\120\066\074\075\042\026\074\059\075\097\074\064\063\027\118\045\094\042\042\097")
objWoistdieFlurgasse.Description = _0X4a("\069\027\113\016\097\074\059\075\097\074\064\063\027\118\045\094\042\042\097\074\099\009\074\027\054\059\074\017\097\047\118\094\045\097\074\059\075\097\074\064\118\097\027\054\059\075\054\074\059\097\042\074\111\067\047\097\118\042")
objWoistdieFlurgasse.Visible = false
objWoistdieFlurgasse.Active = false
objWoistdieFlurgasse.Complete = false
objWoistdieFlurgasse.CorrectState = "None"
objVerdachtiger = Wherigo.ZTask(objCSIOGRA)
objVerdachtiger.Id = "96592985-e850-4b19-89ee-3a161bf4bf03"
objVerdachtiger.Name = _0X4a("\013\097\118\059\094\113\016\026\075\045\097\118")
objVerdachtiger.Description = _0X4a("\089\097\047\118\045\097\054\074\042\075\097\074\059\097\054\074\013\097\118\059\094\113\016\026\075\045\097\054\074\044\027\104\094\042\074\089\094\118\075\054\045\097\118\060\074")
objVerdachtiger.Visible = true
objVerdachtiger.Active = false
objVerdachtiger.Complete = false
objVerdachtiger.CorrectState = "None"
objMoneyMoneyMoney = Wherigo.ZTask(objCSIOGRA)
objMoneyMoneyMoney.Id = "a5323b39-b168-4713-b066-339689f35045"
objMoneyMoneyMoney.Name = _0X4a("\068\066\054\097\085\036\074\068\066\054\097\085\036\074\068\066\054\097\085\060\060\060")
objMoneyMoneyMoney.Description = _0X4a("\060\060\060\121\027\042\026\074\017\097\074\047\027\054\054\085\049\089\001\039\064\075\054\059\097\074\059\094\042\074\011\097\063\059\079")
objMoneyMoneyMoney.Visible = false
objMoneyMoneyMoney.Active = false
objMoneyMoneyMoney.Complete = false
objMoneyMoneyMoney.CorrectState = "None"
objFestnahme = Wherigo.ZTask(objCSIOGRA)
objFestnahme.Id = "2e729638-4b35-4874-8b04-a457fc38ea58"
objFestnahme.Name = _0X4a("\064\097\042\026\054\094\016\121\097")
objFestnahme.Description = _0X4a("\088\075\121\121\074\059\097\054\074\090\094\026\097\118\074\047\097\042\026\074\027\054\059\074\063\066\042\097\074\059\097\054\074\064\094\063\063\074\079")
objFestnahme.Visible = false
objFestnahme.Active = true
objFestnahme.Complete = false
objFestnahme.CorrectState = "None"

-- Cartridge Variables --
currentZone = _0X4a("\066\017\021\090\094\026\066\118\026\099")
currentCharacter = _0X4a("\069\067\027\069\075")
currentItem = _0X4a("\066\017\021\120\094\047\047\097\099")
currentTask = _0X4a("\066\017\021\090\094\026\066\118\026\017\097\042\075\113\016\026\075\045\027\054\045")
currentInput = _0X4a("\066\017\021\011\097\063\059")
currentTimer = _0X4a("\066\017\021\120\094\118\026\097\054")
objCSIOGRA.ZVariables = {
	currentZone = _0X4a("\066\017\021\090\094\026\066\118\026\099"), 
	currentCharacter = _0X4a("\069\067\027\069\075"), 
	currentItem = _0X4a("\066\017\021\120\094\047\047\097\099"), 
	currentTask = _0X4a("\066\017\021\090\094\026\066\118\026\017\097\042\075\113\016\026\075\045\027\054\045"), 
	currentInput = _0X4a("\066\017\021\011\097\063\059"), 
	currentTimer = _0X4a("\066\017\021\120\094\118\026\097\054")
}

-- Timers --
objWarten = Wherigo.ZTimer(objCSIOGRA)
objWarten.Id = "0ea84881-1d45-42c8-ab3b-1ee3ac36472b"
objWarten.Name = _0X4a("\120\094\118\026\097\054")
objWarten.Description = ""
objWarten.Visible = true
objWarten.Duration = 5
objWarten.Type = "Countdown"
objArbeit = Wherigo.ZTimer(objCSIOGRA)
objArbeit.Id = "f26c6573-ab99-48db-8ab6-3d3dcb3b92c4"
objArbeit.Name = _0X4a("\078\118\017\097\075\026")
objArbeit.Description = ""
objArbeit.Visible = true
objArbeit.Duration = 3
objArbeit.Type = "Countdown"
objAnruf = Wherigo.ZTimer(objCSIOGRA)
objAnruf.Id = "0801bacb-4d0a-4042-ba8f-27a970ebf90c"
objAnruf.Name = _0X4a("\078\054\118\027\047")
objAnruf.Description = ""
objAnruf.Visible = true
objAnruf.Duration = 20
objAnruf.Type = "Countdown"

-- Inputs --
objGeld = Wherigo.ZInput(objCSIOGRA)
objGeld.Id = "4640bfb2-fe17-40ad-82fd-0c5cd593e4ef"
objGeld.Name = _0X4a("\011\097\063\059")
objGeld.Description = ""
objGeld.Visible = false
objGeld.InputType = "Text"
objGeld.Text = _0X4a("\120\075\097\074\063\094\027\026\097\026\074\059\097\118\074\014\066\059\097\074\075\121\074\028\054\054\097\118\097\054\074\059\097\118\074\069\113\016\094\113\016\026\097\063\074\121\075\026\074\059\097\121\074\011\097\063\059\056")

-- WorksWithList for object commands --

-- functions --
function objCSIOGRA:OnStart()
end
function objCSIOGRA:OnRestore()
end
function objTatort1:OnEnter()
	currentZone = _0X4a("\066\017\021\090\094\026\066\118\026\099")
	_Urwigo.MessageBox{
		Text = _0X4a("\117\094\063\063\066\079\074\069\075\097\074\121\027\042\042\097\054\074\051\066\121\121\075\042\042\094\118\074\044\094\054\045\074\042\097\075\054\060\074\068\097\075\054\074\088\094\121\097\074\075\042\026\074\069\026\097\047\094\054\074\117\094\042\063\075\054\045\097\118\036\074\059\097\118\074\014\016\097\047\074\059\097\118\074\069\067\027\118\097\054\042\075\113\016\097\118\027\054\045\060\074\028\113\016\074\019\097\075\045\097\074\028\016\054\097\054\074\021\097\026\019\026\074\059\097\054\074\090\094\026\066\118\026\060\074"), 
		Media = objStefanHaslinger, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _0X4a("\117\075\097\118\074\096\027\118\059\097\074\059\075\097\074\044\097\075\113\016\097\036\074\089\097\118\054\016\094\118\059\074\051\066\063\121\036\074\097\075\054\074\090\075\042\113\016\063\097\118\074\045\097\047\027\054\059\097\054\060\074\038\118\074\096\027\118\059\097\074\097\118\042\113\016\066\042\042\097\054\060\074\120\075\118\074\016\094\017\097\054\074\097\075\054\074\116\047\063\094\042\026\097\118\074\045\097\047\027\054\059\097\054\060\074\089\118\075\054\045\097\054\074\069\075\097\074\059\094\042\074\094\121\074\089\097\042\026\097\054\074\075\054\042\074\044\094\017\066\118\079\074\031\075\097\074\044\097\075\113\016\097\074\075\042\026\074\042\113\016\066\054\074\017\097\075\121\074\011\097\118\075\113\016\026\042\121\097\059\075\019\075\054\097\118\036\074\042\113\016\094\027\054\074\069\075\097\074\017\097\075\074\075\016\121\074\094\027\113\016\074\045\063\097\075\113\016\074\098\066\118\017\097\075\060\074\120\075\097\059\097\118\042\097\016\054\074"), 
					Media = objStefanHaslinger, 
					Buttons = {
						_0X4a("\120\075\097\059\097\118\042\097\016\097\054")
					}, 
					Callback = function(action)
						if action ~= nil then
							objPflaster1:MoveTo(Player)
							objPflaster1.Visible = true
							_Urwigo.MessageBox{
								Text = _0X4a("\031\027\074\016\094\042\026\074\097\075\054\097\074\054\097\027\097\074\078\027\047\045\094\017\097\074\097\118\016\094\063\026\097\054\060\074"), 
								Media = objaufgabe, 
								Callback = function(action)
									if action ~= nil then
										objTatortbesichtigung.Complete = true
										dna.Visible = true
										objLabor.Active = true
										objLabor.Visible = true
										objFestnahme.Visible = true
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objLabor:OnEnter()
	currentZone = _0X4a("\066\017\021\044\094\017\066\118")
	_Urwigo.MessageBox{
		Text = _0X4a("\117\075\097\118\074\075\042\026\074\059\094\042\074\104\118\075\121\075\054\094\063\075\042\026\075\042\113\016\097\074\119\097\054\026\118\027\121\036\074\017\097\042\042\097\118\074\097\042\074\042\066\063\063\026\097\074\059\094\074\042\097\075\054\060\074\038\042\074\045\075\017\026\074\104\097\075\054\074\011\097\063\059\074\047\027\118\074\059\097\054\074\089\094\027\074\027\054\059\074\059\094\042\074\094\063\026\097\074\089\027\118\066\074\075\042\026\074\042\113\016\066\054\074\098\097\118\104\094\027\047\026\074\096\066\118\059\097\054\060\060\060"), 
		Media = objBuro, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _0X4a("\078\016\016\036\074\069\075\097\074\121\027\042\042\097\054\074\051\066\121\121\075\042\042\094\118\074\044\094\054\045\074\042\097\075\054\060\074\028\113\016\074\017\075\054\074\059\075\097\074\044\094\017\066\118\094\054\026\075\054\036\074\114\027\063\075\094\074\117\094\017\097\060\074"), 
					Media = objLaborantin, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.Dialog(false, {
								{
									Text = _0X4a("\069\075\097\074\016\094\017\097\054\074\097\075\054\074\116\047\063\094\042\026\097\118\074\047\027\118\074\121\075\113\016\060\074\044\094\042\042\097\054\074\069\075\097\074\121\075\113\016\074\118\094\026\097\054\036\074\075\113\016\074\042\066\063\063\074\097\075\054\097\054\074\031\088\078\043\090\097\042\026\074\121\094\113\016\097\054\060"), 
									Media = objLaborantin
								}, 
								{
									Text = _0X4a("\120\075\118\059\074\097\118\063\097\059\075\045\026\060\074\028\113\016\074\017\075\054\074\075\054\074\096\097\054\075\045\097\054\074\068\075\054\027\026\097\054\074\042\066\096\097\075\026\060\074\069\067\118\097\113\016\097\054\074\069\075\097\074\059\066\113\016\074\042\113\016\066\054\074\097\075\054\121\094\063\074\121\075\026\074\027\054\042\097\118\097\121\074\011\097\118\075\113\016\026\042\121\097\059\075\019\075\054\097\118\036\074\078\063\097\105\094\054\059\097\118\074\117\094\027\042\113\016\075\063\059\060\074\038\118\074\096\075\118\059\074\045\063\097\075\113\016\074\059\094\074\042\097\075\054\060\074"), 
									Media = objLaborantin
								}
							}, function(action)
								objPflaster1:MoveTo(objJuliaHabe)
								objPflaster1.Visible = true
								objWarten:Start()
							end)
						end
					end
				}
			end
		end
	}
end
function objArbeitsplatz:OnEnter()
	currentZone = _0X4a("\066\017\021\078\118\017\097\075\026\042\067\063\094\026\019")
	objArbeit:Start()
end
function objFlurgasse18:OnEnter()
	currentZone = _0X4a("\066\017\021\064\063\027\118\045\094\042\042\097\099\009")
	_Urwigo.Dialog(false, {
		{
			Text = _0X4a("\011\118\027\097\042\042\074\011\066\026\026\079\074\069\075\097\074\121\027\042\042\097\054\074\059\097\118\074\051\066\121\121\075\042\042\094\118\074\042\097\075\054\060\120\075\097\074\104\094\054\054\074\075\113\016\074\028\016\054\097\054\074\017\097\016\075\063\047\063\075\113\016\074\042\097\075\054\074\056"), 
			Media = objFreundin
		}, 
		{
			Text = _0X4a("\078\063\042\066\074\064\097\075\054\059\097\074\016\094\026\074\097\118\074\045\063\094\027\017\097\074\075\113\016\074\054\075\113\016\026\074\045\097\016\094\017\026\060\074\028\113\016\074\059\097\054\104\097\074\059\094\074\097\016\097\118\074\094\054\074\097\075\054\097\054\074\001\094\027\017\121\066\118\059\060\074"), 
			Media = objFreundin
		}, 
		{
			Text = _0X4a("\038\118\074\016\094\026\074\054\094\121\063\075\113\016\074\099\107\107\074\107\107\107\074\038\027\118\066\074\045\097\097\118\017\026\074\027\054\059\074\096\066\063\063\026\097\074\042\075\097\074\019\027\118\074\089\094\054\104\074\017\118\075\054\045\097\054\060\074\035\054\059\074\059\094\054\054\074\075\042\026\074\097\118\074\097\118\121\066\118\059\097\026\074\096\066\118\059\097\054\060\060\060"), 
			Media = objFreundin
		}, 
		{
			Text = _0X4a("\028\113\016\074\045\063\094\027\017\097\036\074\059\094\042\042\074\097\042\074\021\097\121\094\054\059\074\096\094\118\074\059\097\118\074\098\066\054\074\059\097\118\074\038\118\017\042\113\016\094\047\026\074\045\097\096\027\042\042\026\074\016\094\026\036\074\096\097\075\063\074\097\118\074\021\094\074\104\097\075\054\097\074\013\097\118\063\097\026\019\027\054\045\097\054\074\045\097\016\094\017\026\074\016\094\026\060\074\120\097\075\063\074\042\075\097\074\094\027\113\016\074\042\094\045\097\054\036\074\059\094\042\042\074\042\075\097\074\104\097\075\054\074\011\097\063\059\074\045\097\047\027\054\059\097\054\074\016\094\017\097\054\036\074\059\094\042\074\096\027\118\059\097\074\059\066\113\016\074\019\027\074\121\097\075\054\097\118\074\090\016\097\066\118\075\097\074\067\094\042\042\097\054\060\074"), 
			Media = objFreundin
		}, 
		{
			Text = _0X4a("\038\042\074\096\027\042\042\026\097\054\074\054\075\113\016\026\074\042\097\016\118\074\098\075\097\063\097\074\044\097\027\026\097\074\096\094\042\074\098\066\054\074\059\097\121\074\011\097\063\059\060\074\011\097\118\094\059\097\074\097\075\054\121\094\063\074\042\097\075\054\074\089\118\027\059\097\118\036\074\059\097\042\042\097\054\074\064\118\094\027\074\027\054\059\074\098\075\097\063\063\097\075\113\016\074\097\075\054\074\067\094\094\118\074\051\066\063\063\097\045\097\054\060\074"), 
			Media = objFreundin
		}, 
		{
			Text = _0X4a("\088\094\021\094\074\096\097\054\054\074\042\075\097\074\121\075\113\016\074\054\094\113\016\074\097\075\054\097\121\074\068\066\026\075\098\074\047\118\094\045\097\054\060\060\060\049\089\001\039\068\097\075\054\074\069\113\016\096\094\045\097\118\074\096\094\118\074\042\113\016\066\054\074\097\075\047\097\118\042\027\113\016\026\075\045\074\096\097\075\063\074\097\118\074\054\075\113\016\026\074\042\066\074\098\075\097\063\074\045\097\097\118\017\026\074\016\094\026\036\074\094\017\097\118\074\075\016\054\074\096\027\118\059\097\074\075\113\016\074\059\094\042\074\054\075\113\016\026\074\019\027\026\118\094\027\097\054\060\074\078\017\097\118\074\059\075\097\042\097\118\074\120\066\063\047\045\094\054\045\036\074\059\097\118\074\051\066\063\063\097\045\097\074\098\066\054\074\121\097\075\054\097\121\074\064\118\097\027\054\059\036\074\059\097\118\074\016\094\026\074\019\075\097\121\063\075\113\016\097\074\011\097\063\059\067\118\066\017\063\097\121\097\060\074\038\042\074\104\066\054\054\026\097\074\094\017\097\118\074\094\027\113\016\074\042\097\075\054\036\074\059\094\042\042\074\097\042\074\096\097\118\074\078\054\059\097\118\097\118\074\096\094\118\060\074\028\113\016\074\096\097\075\056\074\096\075\097\074\045\097\042\094\045\026\074\054\075\113\016\026\074\066\017\074\097\118\074\097\042\074\054\066\113\016\074\094\054\059\097\118\097\054\074\045\097\042\094\045\026\074\016\094\026\060\074"), 
			Media = objFreundin
		}, 
		{
			Text = _0X4a("\011\097\054\094\027\079\074\068\097\075\054\074\069\113\016\096\094\045\097\118\074\016\097\075\056\026\074\044\027\104\094\042\074\089\094\118\075\054\045\097\118\060\074\028\113\016\074\016\066\047\047\097\074\075\113\016\074\104\066\054\054\026\097\074\028\016\054\097\054\074\016\097\063\047\097\054\049\089\001\039\078\027\047\074\120\075\097\059\097\118\042\097\016\054\079"), 
			Media = objFreundin
		}
	}, function(action)
		_Urwigo.MessageBox{
			Text = _0X4a("\031\027\074\016\094\042\026\074\019\096\097\075\074\054\097\027\097\074\078\027\047\045\094\017\097\054\074\097\118\016\094\063\026\097\054\079"), 
			Media = objaufgabe, 
			Callback = function(action)
				if action ~= nil then
					objLukasBaringer1.Visible = true
					objLukasBaringer1.Active = true
					objVerdachtiger.Active = true
					objWoistdieFlurgasse.Complete = true
					objVerdachtiger.Visible = true
					objMoneyMoneyMoney.Active = true
					objMoneyMoneyMoney.Visible = true
					objAnruf:Start()
					objFlurgasse18.Active = false
				end
			end
		}
	end)
end
function objFlurgasse18:OnProximity()
	currentZone = _0X4a("\066\017\021\064\063\027\118\045\094\042\042\097\099\009")
	objFlurgasse18.Visible = true
end
function objLukasBaringer1:OnEnter()
	currentZone = _0X4a("\066\017\021\044\027\104\094\042\089\094\118\075\054\045\097\118\099")
	_Urwigo.MessageBox{
		Text = _0X4a("\011\118\027\097\042\042\074\011\066\026\026\079\074\038\042\074\045\097\016\026\074\096\094\016\118\042\113\016\097\075\054\063\075\113\016\074\027\121\074\121\097\075\054\097\054\074\089\118\027\059\097\118\060\074\069\113\016\118\097\113\104\063\075\113\016\036\074\054\075\113\016\026\074\096\094\016\118\056"), 
		Media = objLukasBaringer, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _0X4a("\068\097\075\054\097\074\064\075\054\045\097\118\094\017\059\118\027\113\104\097\056\079\074\114\094\074\075\113\016\074\096\094\118\074\094\016\016\074\045\097\042\026\097\118\054\074\075\121\074\116\094\118\104\074\021\066\045\045\097\054\060\074"), 
					Media = objLukasBaringer, 
					Buttons = {
						_0X4a("\028\113\016\074\016\094\017\097\074\054\075\113\016\026\042\074\098\066\054\074\116\094\118\104\074\045\097\042\094\045\026")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _0X4a("\114\094\074\059\094\042\074\016\094\017\097\074\075\113\016\074\075\054\074\059\097\118\074\119\097\075\026\027\054\045\074\045\097\063\097\042\097\054\060\074"), 
								Media = objLukasBaringer, 
								Buttons = {
									_0X4a("\028\054\074\059\097\118\074\119\097\075\026\027\054\045\074\042\026\097\016\026\074\094\027\113\016\074\054\075\113\016\026\042")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _0X4a("\088\094\045\027\026\036\074\063\097\027\045\054\097\054\074\075\042\026\074\019\096\097\113\104\063\066\042\060\074\028\014\117\074\117\078\089\038\074\028\117\088\074\038\001\068\111\001\031\038\090\079\079\074"), 
											Media = objLukasBaringer, 
											Buttons = {
												_0X4a("\120\094\118\027\121\074\056")
											}, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _0X4a("\028\113\016\074\096\094\016\118\074\042\066\074\097\075\047\097\118\042\027\113\016\026\075\045\074\096\097\075\063\074\097\118\074\075\121\121\097\118\074\059\097\118\074\104\063\097\075\054\097\036\074\017\118\094\098\097\074\089\118\027\059\097\118\074\096\094\118\074\027\054\059\074\094\063\042\074\097\118\074\021\097\026\019\026\074\054\066\113\016\074\121\097\016\118\074\045\097\097\118\017\026\074\016\094\026\074\094\063\042\074\075\113\016\036\074\075\042\026\074\121\075\118\074\059\097\118\074\051\118\094\045\097\054\074\045\097\067\063\094\026\019\026\074"), 
														Media = objLukasBaringer, 
														Buttons = {
															_0X4a("\120\066\074\016\094\017\097\054\074\042\075\097\074\059\094\042\074\011\097\063\059\074\098\097\118\042\026\097\113\104\026")
														}, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _0X4a("\078\054\074\059\097\118\074\116\075\097\063\094\113\016\074\075\054\074\059\097\118\074\078\027\060\074\089\097\075\074\059\075\097\042\097\054\074\051\066\066\118\059\075\054\094\026\097\054\082\049\089\001\039\088\074\077\009\056\074\107\009\060\107\048\055\074\038\074\107\099\106\056\074\065\065\060\055\077\065"), 
																	Media = objLukasBaringer, 
																	Callback = function(action)
																		if action ~= nil then
																			objFestnahme.Complete = true
																			objVerdachtiger.Complete = true
																			objVersteck.Active = true
																			objVersteck.Visible = true
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objVersteck:OnEnter()
	currentZone = _0X4a("\066\017\021\013\097\118\042\026\097\113\104")
	_Urwigo.MessageBox{
		Text = _0X4a("\117\075\097\118\074\121\027\042\042\074\075\118\045\097\054\059\096\066\074\059\094\042\074\011\097\063\059\074\042\097\075\054\060\074"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(objGeld)
				end)
			end
		end
	}
end
function objGeld:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.MessageBox{
			Text = _0X4a("\031\075\097\074\119\094\016\063\097\054\079\079\079"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objGeld)
					end)
				end
			end
		}
		return
	end
	if input == 8563 then
		_Urwigo.MessageBox{
			Text = _0X4a("\031\097\075\054\074\035\054\063\066\113\104\113\066\059\097\074\075\042\026\082")..string.sub(Player.CompletionCode, 1, 15), 
			Callback = function(action)
				if action ~= nil then
					objCSIOGRA.Complete = true
					objMoneyMoneyMoney.Complete = true
					objUnlockcode.Description = string.sub(Player.CompletionCode, 1, 15)
					objUnlockcode:MoveTo(Player)
					objUnlockcode.Visible = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _0X4a("\031\097\118\074\014\066\059\097\074\075\042\026\074\047\094\063\042\113\016\036\074\098\097\118\042\027\113\016\042\074\054\066\113\016\074\097\075\054\121\094\063\074"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objGeld)
					end)
				end
			end
		}
	end
end
function objWarten:OnTick()
	_Urwigo.MessageBox{
		Text = _0X4a("\011\118\027\097\042\042\074\011\066\026\026\036\074\051\066\121\121\075\042\042\094\118\074\044\094\054\045\036\074\075\113\016\074\017\075\054\074\059\097\118\074\011\097\118\075\113\016\026\042\121\097\059\075\019\075\054\097\118\060\074\028\113\016\074\096\097\118\059\097\074\042\075\097\074\021\097\026\019\026\074\027\097\017\097\118\074\059\075\097\074\044\097\075\113\016\097\074\075\054\047\066\118\121\075\097\118\097\054\060"), 
		Media = objAlex, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.Dialog(false, {
					{
						Text = _0X4a("\120\075\118\074\016\094\017\097\054\074\097\075\045\097\054\026\063\075\113\016\074\042\097\016\118\074\096\097\054\075\045\097\074\069\067\027\118\097\054\074\045\047\027\054\059\097\054\060\074\031\097\118\074\090\094\026\097\118\074\096\094\118\074\042\097\016\118\074\098\066\118\042\075\113\016\026\075\045\060\074\028\113\016\074\016\094\017\097\074\104\097\075\054\097\118\063\097\075\074\051\094\121\067\047\042\067\027\118\097\054\074\045\097\047\027\054\059\097\054\060\074\078\063\042\066\074\121\027\042\042\074\059\097\118\074\090\094\026\097\118\074\059\097\121\074\111\067\047\097\118\074\094\027\047\045\097\063\094\027\097\118\026\074\016\094\017\097\054\074\027\054\059\074\075\016\054\074\059\094\054\054\074\121\075\026\074\097\075\054\097\121\074\051\066\067\047\042\113\016\027\042\042\074\045\097\026\066\026\097\026\074\016\094\017\097\054\074"), 
						Media = objAlex
					}, 
					{
						Text = _0X4a("\031\094\042\074\116\047\063\094\042\026\097\118\074\121\027\042\042\074\098\066\121\074\090\094\026\097\118\036\074\066\059\097\118\074\097\075\054\097\118\074\027\054\017\097\026\097\075\063\075\045\026\097\054\074\116\097\118\042\066\054\074\042\026\094\121\121\097\054\060\074\059\097\054\054\074\059\075\097\074\044\097\075\113\016\097\074\096\097\075\042\026\074\104\097\075\054\097\074\013\097\118\063\097\026\019\027\054\045\097\054\074\094\027\047\060\074"), 
						Media = objAlex
					}
				}, function(action)
					_Urwigo.MessageBox{
						Text = _0X4a("\028\113\016\074\016\094\017\097\074\059\094\042\074\116\047\063\094\042\026\097\118\074\027\054\026\097\118\042\027\113\016\026\074\027\054\059\074\096\075\118\074\016\094\017\097\054\074\097\075\054\097\054\074\090\118\097\047\047\097\118\074\075\054\074\059\097\118\074\031\094\026\097\054\017\094\054\104\060\074\031\075\097\074\031\088\078\074\067\094\042\042\026\074\019\027\074\120\066\063\047\045\094\054\045\074\001\027\121\121\097\118\060\074\035\054\059\074\021\097\026\019\026\074\104\066\121\121\026\042\036\074\042\075\097\074\042\075\054\059\036\074\097\075\045\097\054\026\063\075\113\016\074\096\094\118\097\054\036\074\051\066\063\063\097\045\097\054\060\074\049\089\001\039\078\021\094\036\016\075\097\118\074\016\094\017\097\054\074\042\075\097\074\075\016\118\074\116\047\063\094\042\026\097\118\074\096\075\097\059\097\118\060\074"), 
						Media = objLaborantin, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _0X4a("\031\027\074\016\094\042\026\074\097\075\054\097\074\054\097\027\097\074\078\027\047\045\094\017\097\074\097\118\094\016\063\026\097\054\074"), 
									Media = objaufgabe, 
									Callback = function(action)
										if action ~= nil then
											objPflaster1:MoveTo(Player)
											objPflaster1.Visible = true
											objZeugenbefragung.Active = true
											objZeugenbefragung.Visible = true
											dna.Complete = true
											objArbeitsplatz.Visible = true
											objArbeitsplatz.Active = true
										end
									end
								}
							end
						end
					}
				end)
			end
		end
	}
end
function objArbeit:OnTick()
	_Urwigo.MessageBox{
		Text = _0X4a("\120\094\042\079\056\074\089\097\118\054\094\118\059\074\075\042\026\074\026\066\026\079\074\038\118\121\066\118\059\097\026\079\074\120\097\118\074\026\027\026\074\059\097\054\054\074\042\066\096\094\042"), 
		Media = objKollege, 
		Buttons = {
			_0X4a("\031\094\042\074\096\075\063\063\074\075\113\016\074\094\027\113\016\074\096\075\042\042\097\054\074")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.Dialog(false, {
					{
						Text = _0X4a("\078\063\042\066\074\075\113\016\074\016\094\017\074\094\017\042\066\063\027\026\074\104\097\075\054\097\074\078\016\054\027\054\045\036\074\096\097\118\074\059\097\054\074\089\097\118\054\016\094\118\059\074\027\121\045\097\017\118\094\113\016\026\074\016\094\017\097\054\074\104\066\054\054\026\060\074\120\097\045\097\054\074\059\097\121\074\116\047\063\094\042\026\097\118\082\074\076\054\017\042\067\061\028\113\016\074\096\097\118\059\042\074\096\094\016\118\097\042\113\016\097\075\054\063\075\113\016\074\045\097\042\026\097\118\054\074\017\097\075\121\074\069\067\094\026\019\075\097\118\097\054\074\098\097\118\063\066\118\097\054\074\016\094\017\097\054\036\074\059\094\074\017\075\054\074\075\113\016\074\042\113\016\097\075\054\017\094\118\074\094\121\074\090\094\026\066\118\026\074\098\066\118\017\097\075\045\097\104\066\121\121\097\054\060\074\069\113\016\094\027\054\042\074\059\094\074\016\094\017\074\075\113\016\074\097\075\054\097\074\013\097\118\063\097\026\019\027\054\045\074\094\121\074\064\027\056\060"), 
						Media = objKollege
					}, 
					{
						Text = _0X4a("\074\038\118\074\096\094\118\074\075\121\121\097\118\074\042\066\074\047\118\066\016\063\075\113\016\036\074\075\113\016\074\045\063\094\027\017\097\074\054\075\113\016\026\036\074\059\094\042\042\074\097\118\074\075\118\045\097\054\059\096\097\063\113\016\097\074\064\097\075\054\059\097\074\045\097\016\094\017\026\074\016\094\026\060\074\078\017\097\118\074\047\118\094\045\097\054\042\074\059\066\113\016\074\042\097\075\054\097\074\064\118\097\027\054\059\075\054\074\064\118\094\054\019\075\042\104\094\074\117\066\063\019\097\118\060\074\069\075\097\074\096\066\016\054\026\074\075\054\074\059\097\118\074\064\063\027\118\045\094\042\042\097\074\099\009\060\074"), 
						Media = objKollege
					}
				}, function(action)
					_Urwigo.MessageBox{
						Text = _0X4a("\031\027\074\016\094\042\026\074\097\075\054\097\074\054\097\027\097\074\078\027\047\045\094\017\097\074\097\118\016\094\063\026\097\054\074"), 
						Media = objaufgabe, 
						Callback = function(action)
							if action ~= nil then
								objWoistdieFlurgasse.Active = true
								objWoistdieFlurgasse.Visible = true
								objZeugenbefragung.Complete = true
							end
						end
					}
				end)
			end
		end
	}
end
function objAnruf:OnTick()
	Wherigo.PlayAudio(objKlingeln)
	_Urwigo.MessageBox{
		Text = _0X4a("\079\079\079\069\026\097\047\094\054\074\117\094\042\063\075\054\045\097\118\074\118\027\047\026\074\094\054\079\079\079"), 
		Media = objHandy, 
		Buttons = {
			_0X4a("\078\054\054\097\016\121\097\054"), 
			_0X4a("\078\017\063\097\016\054\097\054\074")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.OldDialog{
					{
						Text = _0X4a("\011\118\027\097\042\042\074\011\066\026\026\036\074\117\097\118\118\074\044\094\054\045\074\079\074\028\113\016\074\016\094\017\097\074\097\075\054\097\074\045\027\026\097\074\088\094\113\016\118\075\113\016\026\074\047\027\118\074\042\075\097\074\079\074\120\075\118\074\016\094\017\097\054\074\097\075\054\097\054\074\064\075\054\045\097\118\094\017\059\118\027\113\104\074\094\054\074\059\097\118\074\044\097\075\113\016\097\074\045\097\047\027\054\059\097\054\060\074\038\118\074\067\094\042\042\026\074\019\027\074\044\027\104\094\042\074\089\094\118\075\054\045\097\118\060\074\031\097\121\074\089\118\027\059\097\118\074\059\097\042\074\111\067\047\097\118\042\060\074"), 
						Media = objStefanHaslinger
					}, 
					{
						Text = _0X4a("\120\094\042\074\079\056\074\069\075\097\074\042\075\054\059\074\042\113\016\066\054\074\027\054\026\097\118\096\097\045\042\060\074\031\094\042\074\045\097\016\026\074\094\017\097\118\074\042\113\016\054\097\063\063\060\074\011\027\026\074\059\094\054\054\074\017\075\042\074\042\067\094\026\097\118\060\074"), 
						Media = objStefanHaslinger
					}
				}
			end
		end
	}
end
function SpuSi:OnClick()
	_Urwigo.MessageBox{
		Text = _0X4a("\117\094\063\063\066\079\074\069\075\097\074\121\027\042\042\097\054\074\051\066\121\121\075\042\094\118\074\044\094\054\045\074\042\097\075\054\060\074\068\097\075\054\074\088\094\121\097\074\075\042\026\074\069\026\097\047\094\054\074\117\094\042\063\075\054\045\097\118\036\074\059\097\118\074\014\016\097\047\074\059\097\118\074\069\067\027\118\097\054\042\075\113\016\097\118\027\054\045\060\074\028\113\016\074\019\097\075\045\097\074\075\016\054\097\054\074\021\097\026\019\026\074\059\097\054\074\090\094\026\066\118\026\060\074"), 
		Media = objStefanHaslinger, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _0X4a("\117\075\097\118\074\096\027\118\059\097\074\059\075\097\074\044\097\075\113\016\097\036\074\089\097\118\054\016\094\118\059\074\051\066\063\121\036\074\097\075\054\074\078\054\045\097\042\026\097\063\063\097\118\074\045\097\047\027\054\059\097\054\060\074\038\118\074\096\027\118\059\097\074\121\075\026\074\097\118\042\113\016\066\042\042\097\054\060\074\120\075\118\074\016\094\017\097\054\074\094\027\042\042\097\118\059\097\121\074\054\066\113\016\074\097\075\054\074\116\047\063\094\042\026\097\118\074\045\097\047\027\054\059\097\054\060\074\089\118\075\054\045\097\054\074\042\075\097\074\059\094\042\074\094\121\074\017\097\042\026\097\054\074\075\054\042\074\044\094\017\066\118\079\074\031\075\097\074\044\097\075\113\016\097\074\075\042\026\074\042\113\016\066\054\074\017\097\075\121\074\011\097\118\075\113\016\026\042\121\097\059\075\019\075\054\097\118\036\074\042\113\016\094\027\054\074\069\075\097\074\017\097\075\074\059\097\121\074\094\121\074\017\097\042\026\097\054\074\078\027\113\016\074\045\063\097\075\113\016\074\098\066\118\017\097\075\060\074\120\075\097\059\097\118\042\097\016\054\074"), 
					Callback = function(action)
						if action ~= nil then
							objPflaster1:MoveTo(Player)
							_Urwigo.MessageBox{
								Text = _0X4a("\069\075\097\074\016\094\017\097\054\074\097\075\054\097\074\088\097\027\097\074\078\027\047\045\094\017\097\074\097\118\016\094\063\026\097\054\074")
							}
						end
					end
				}
			end
		end
	}
end
function objKarte1:OnClick()
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objKarte1)
end

-- Urwigo functions --
function objName()
end

-- Begin user functions --
-- End user functions --
return objCSIOGRA
