require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _qo9(str)
	local res = ""
    local dtable = "\126\063\091\103\013\041\064\111\030\005\123\116\109\108\075\061\088\006\080\022\060\015\033\125\110\092\114\055\051\048\117\085\100\053\032\082\057\040\073\071\042\050\020\009\087\070\027\003\016\105\054\098\121\099\084\037\104\024\062\036\028\011\008\000\056\089\045\058\023\044\074\010\102\112\049\119\076\059\077\122\029\095\067\081\046\014\090\052\094\069\012\017\097\093\039\072\018\065\106\007\113\021\025\047\019\001\031\034\079\107\120\066\002\096\118\026\101\115\068\078\124\083\004\038\043\086\035"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_mnz = Wherigo.ZCartridge()

-- Media --
_KoSC3 = Wherigo.ZMedia(_mnz)
_KoSC3.Id = "ffb830b0-aa57-4994-b3cd-9f7cae794676"
_KoSC3.Name = _qo9("\033\008\013\117\054\117\110")
_KoSC3.Description = ""
_KoSC3.AltText = ""
_KoSC3.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek1.jpg", 
		Directives = {}
	}
}
_ThaP = Wherigo.ZMedia(_mnz)
_ThaP.Id = "880eef0a-0363-42a6-af13-ad8efa2f9ead"
_ThaP.Name = _qo9("\033\008\013\117\054\117\110\035\098")
_ThaP.Description = ""
_ThaP.AltText = ""
_ThaP.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-a.jpg", 
		Directives = {}
	}
}
_caBeS = Wherigo.ZMedia(_mnz)
_caBeS.Id = "d1a5fd46-e1ea-4b95-8215-beb9d2a2c36b"
_caBeS.Name = _qo9("\033\008\013\117\054\117\110\035\112")
_caBeS.Description = ""
_caBeS.AltText = ""
_caBeS.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-b.jpg", 
		Directives = {}
	}
}
_62xc = Wherigo.ZMedia(_mnz)
_62xc.Id = "503c69fa-ca62-4cb0-a2cf-d5833ead67e9"
_62xc.Name = _qo9("\033\008\013\117\054\117\110\035\083")
_62xc.Description = ""
_62xc.AltText = ""
_62xc.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-c.jpg", 
		Directives = {}
	}
}
_fUxag = Wherigo.ZMedia(_mnz)
_fUxag.Id = "b06f785e-610c-4160-aa0d-e643c8daaf62"
_fUxag.Name = _qo9("\033\008\013\117\054\117\110\035\119")
_fUxag.Description = ""
_fUxag.AltText = ""
_fUxag.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-d.jpg", 
		Directives = {}
	}
}
_4GG7I = Wherigo.ZMedia(_mnz)
_4GG7I.Id = "c2e2093e-17dc-41e5-8818-e7ec7897ef27"
_4GG7I.Name = _qo9("\033\008\013\117\054\117\110\035\090")
_4GG7I.Description = ""
_4GG7I.AltText = ""
_4GG7I.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-e.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_mnz.Id="df1c896a-1b96-4963-b6d7-5d76bfad6e2b"
_mnz.Name="Domecek jednim tahem"
_mnz.Description=[[]]
_mnz.Visible=true
_mnz.Activity="Geocache"
_mnz.StartingLocationDescription=[[]]
_mnz.StartingLocation = Wherigo.INVALID_ZONEPOINT
_mnz.Version="1.9"
_mnz.Company="URWIGO.CZ"
_mnz.Author="Maxinoha"
_mnz.BuilderVersion="URWIGO 1.21.5528.18461"
_mnz.CreateDate="06/02/2011 19:33:47"
_mnz.PublishDate="1/1/0001 12:00:00 AM"
_mnz.UpdateDate="01/14/2015 10:48:24"
_mnz.LastPlayedDate="1/1/0001 12:00:00 AM"
_mnz.TargetDevice="PocketPC"
_mnz.TargetDeviceVersion="0"
_mnz.StateId="1"
_mnz.CountryId="2"
_mnz.Complete=false
_mnz.UseLogging=true

_mnz.Media=_KoSC3


-- Zones --
zoneA = Wherigo.Zone(_mnz)
zoneA.Id = "93fafd2d-62fd-49e0-ab8e-adc700e07c42"
zoneA.Name = _qo9("\098")
zoneA.Description = _qo9("\077\117\115\093\035\033\008\014\025\050")
zoneA.Visible = true
zoneA.Media = _ThaP
zoneA.Commands = {}
zoneA.DistanceRange = Distance(-1, "feet")
zoneA.ShowObjects = "OnEnter"
zoneA.ProximityRange = Distance(60, "meters")
zoneA.AllowSetPositionTo = false
zoneA.Active = false
zoneA.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneA.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneA.DistanceRangeUOM = "Feet"
zoneA.ProximityRangeUOM = "Meters"
zoneA.OutOfRangeName = ""
zoneA.InRangeName = ""
zoneB = Wherigo.Zone(_mnz)
zoneB.Id = "12d401ff-6aec-4ca9-93ce-236506f91a16"
zoneB.Name = _qo9("\112")
zoneB.Description = _qo9("\019\027\093\115\093\035\033\008\014\025\050")
zoneB.Visible = true
zoneB.Media = _caBeS
zoneB.Commands = {}
zoneB.DistanceRange = Distance(-1, "feet")
zoneB.ShowObjects = "OnEnter"
zoneB.ProximityRange = Distance(60, "meters")
zoneB.AllowSetPositionTo = false
zoneB.Active = false
zoneB.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneB.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneB.DistanceRangeUOM = "Feet"
zoneB.ProximityRangeUOM = "Meters"
zoneB.OutOfRangeName = ""
zoneB.InRangeName = ""
zoneC = Wherigo.Zone(_mnz)
zoneC.Id = "e74266bc-bc8a-42b6-b589-d82d0afadb6d"
zoneC.Name = _qo9("\119")
zoneC.Description = _qo9("\019\027\093\115\093\035\057\008\027\025\050")
zoneC.Visible = true
zoneC.Media = _fUxag
zoneC.Commands = {}
zoneC.DistanceRange = Distance(-1, "feet")
zoneC.ShowObjects = "OnEnter"
zoneC.ProximityRange = Distance(60, "meters")
zoneC.AllowSetPositionTo = false
zoneC.Active = false
zoneC.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneC.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneC.DistanceRangeUOM = "Feet"
zoneC.ProximityRangeUOM = "Meters"
zoneC.OutOfRangeName = ""
zoneC.InRangeName = ""
zoneD = Wherigo.Zone(_mnz)
zoneD.Id = "76b40713-e9fa-479b-8e20-d6afbbd5a5eb"
zoneD.Name = _qo9("\090")
zoneD.Description = _qo9("\122\012\027\117\054\057\093")
zoneD.Visible = true
zoneD.Media = _4GG7I
zoneD.Commands = {}
zoneD.DistanceRange = Distance(-1, "feet")
zoneD.ShowObjects = "OnEnter"
zoneD.ProximityRange = Distance(60, "meters")
zoneD.AllowSetPositionTo = false
zoneD.Active = false
zoneD.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneD.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneD.DistanceRangeUOM = "Feet"
zoneD.ProximityRangeUOM = "Meters"
zoneD.OutOfRangeName = ""
zoneD.InRangeName = ""
zoneE = Wherigo.Zone(_mnz)
zoneE.Id = "26d89b4a-05bc-4e88-833f-f24c01c76fa4"
zoneE.Name = _qo9("\083")
zoneE.Description = _qo9("\077\117\115\093\035\057\008\027\025\050")
zoneE.Visible = true
zoneE.Media = _62xc
zoneE.Commands = {}
zoneE.DistanceRange = Distance(-1, "feet")
zoneE.ShowObjects = "OnEnter"
zoneE.ProximityRange = Distance(60, "meters")
zoneE.AllowSetPositionTo = false
zoneE.Active = false
zoneE.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneE.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneE.DistanceRangeUOM = "Feet"
zoneE.ProximityRangeUOM = "Meters"
zoneE.OutOfRangeName = ""
zoneE.InRangeName = ""
pomocnaA = Wherigo.Zone(_mnz)
pomocnaA.Id = "4b2b810c-d2d6-407b-88fb-08fca8f5de2b"
pomocnaA.Name = _qo9("\074\008\013\008\054\025\093\098")
pomocnaA.Description = ""
pomocnaA.Visible = false
pomocnaA.Commands = {}
pomocnaA.DistanceRange = Distance(-1, "feet")
pomocnaA.ShowObjects = "OnEnter"
pomocnaA.ProximityRange = Distance(60, "meters")
pomocnaA.AllowSetPositionTo = false
pomocnaA.Active = false
pomocnaA.Points = {
	ZonePoint(50.0883105759415, 14.4861529022455, 0), 
	ZonePoint(50.0885153651931, 14.486067071557, 0), 
	ZonePoint(50.0884637377332, 14.4863674789667, 0)
}
pomocnaA.OriginalPoint = ZonePoint(50.0884298929559, 14.4861958175897, 0)
pomocnaA.DistanceRangeUOM = "Feet"
pomocnaA.ProximityRangeUOM = "Meters"
pomocnaA.OutOfRangeName = ""
pomocnaA.InRangeName = ""
pomocnaB = Wherigo.Zone(_mnz)
pomocnaB.Id = "1bf43de1-9bdb-4780-9cf0-bad2eddfba0f"
pomocnaB.Name = _qo9("\083\098\083\096\090")
pomocnaB.Description = ""
pomocnaB.Visible = false
pomocnaB.Commands = {}
pomocnaB.DistanceRange = Distance(-1, "feet")
pomocnaB.ShowObjects = "OnEnter"
pomocnaB.ProximityRange = Distance(60, "meters")
pomocnaB.AllowSetPositionTo = false
pomocnaB.Active = false
pomocnaB.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
pomocnaB.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
pomocnaB.DistanceRangeUOM = "Feet"
pomocnaB.ProximityRangeUOM = "Meters"
pomocnaB.OutOfRangeName = ""
pomocnaB.InRangeName = ""

-- Characters --

-- Items --
_xK2N7 = Wherigo.ZItem{
	Cartridge = _mnz, 
	Container = Player
}
_xK2N7.Id = "08cb41f1-5974-41c0-9bf7-668bcfcb0f0a"
_xK2N7.Name = _qo9("\012\031\080\110\093")
_xK2N7.Description = ""
_xK2N7.Visible = true
_xK2N7.Media = _ThaP
_xK2N7.Commands = {
	_m12LA = Wherigo.ZCommand{
		Text = _qo9("\080\093\110\027\117\118\014\050\012\035\052\008\033\035\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _qo9("\120\050\054\035\110\035\033\050\118\074\008\080\050\054\050")
	}, 
	_qX4 = Wherigo.ZCommand{
		Text = _qo9("\080\093\110\027\117\118\014\050\012\035\052\008\033\035\112"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _qo9("\120\050\054\035\110\035\033\050\118\074\008\080\050\054\050")
	}, 
	_PtJy = Wherigo.ZCommand{
		Text = _qo9("\080\093\054\050\012\035\110\027\117\118\014\050\012"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _qo9("\120\050\054\035\110\035\033\050\118\074\008\080\050\054\050")
	}, 
	_4j9f3 = Wherigo.ZCommand{
		Text = _qo9("\080\093\054\050\012\035\110\027\117\118\014\050\012"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _qo9("\120\050\054\035\110\035\033\050\118\074\008\080\050\054\050")
	}, 
	_aoFj = Wherigo.ZCommand{
		Text = _qo9("\080\093\054\050\012\035\110\027\117\118\014\050\012"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _qo9("\120\050\054\035\110\035\033\050\118\074\008\080\050\054\050")
	}
}
_xK2N7.Commands._m12LA.Custom = true
_xK2N7.Commands._m12LA.Id = "97199a43-cfa4-45d3-ab16-50bec757b506"
_xK2N7.Commands._m12LA.WorksWithAll = true
_xK2N7.Commands._qX4.Custom = true
_xK2N7.Commands._qX4.Id = "6022e73f-f9ce-48ad-94f6-3e6e5cd411e2"
_xK2N7.Commands._qX4.WorksWithAll = true
_xK2N7.Commands._PtJy.Custom = true
_xK2N7.Commands._PtJy.Id = "4bda2e1c-a22c-4a42-af85-c6077ff6398e"
_xK2N7.Commands._PtJy.WorksWithAll = true
_xK2N7.Commands._4j9f3.Custom = true
_xK2N7.Commands._4j9f3.Id = "0b2c53d1-f7b1-4604-bf28-acd58903d1c9"
_xK2N7.Commands._4j9f3.WorksWithAll = true
_xK2N7.Commands._aoFj.Custom = true
_xK2N7.Commands._aoFj.Id = "c2f4348b-2387-4ee0-a5df-153fb3d07945"
_xK2N7.Commands._aoFj.WorksWithAll = true
_xK2N7.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_xK2N7.Locked = false
_xK2N7.Opened = false
_FqeF2 = Wherigo.ZItem{
	Cartridge = _mnz, 
	Container = Player
}
_FqeF2.Id = "42c3a3f2-71c8-451b-8445-bac0e2b1d9c7"
_FqeF2.Name = _qo9("\109\033\117\013\053\110\093\054\050\035\110\008\033")
_FqeF2.Description = ""
_FqeF2.Visible = false
_FqeF2.Commands = {}
_FqeF2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FqeF2.Locked = false
_FqeF2.Opened = false

-- Tasks --
__glm2 = Wherigo.ZTask(_mnz)
__glm2.Id = "73b9ef00-de98-4515-9b52-b782c508c3d4"
__glm2.Name = _qo9("\087\093\110\027\117\118\014\050\035\052\008\033\035\098")
__glm2.Description = ""
__glm2.Visible = true
__glm2.Active = true
__glm2.Complete = false
__glm2.CorrectState = "None"
_trVt = Wherigo.ZTask(_mnz)
_trVt.Id = "4c16555c-50a8-47af-b6d5-52270da375cb"
_trVt.Name = _qo9("\087\093\110\027\117\118\014\050\035\052\008\033\035\112")
_trVt.Description = ""
_trVt.Visible = true
_trVt.Active = false
_trVt.Complete = false
_trVt.CorrectState = "None"
_t3nwj = Wherigo.ZTask(_mnz)
_t3nwj.Id = "16004cab-461d-4a12-acba-57012da49575"
_t3nwj.Name = _qo9("\120\093\014\117\080\025\050\035\075\085\035\027\117\118\117\025\050")
_t3nwj.Description = ""
_t3nwj.Visible = true
_t3nwj.Active = false
_t3nwj.Complete = false
_t3nwj.CorrectState = "None"
_EB5Id = Wherigo.ZTask(_mnz)
_EB5Id.Id = "124103fa-5fa1-4182-8b53-cd322e3d6e50"
_EB5Id.Name = _qo9("\120\093\014\117\080\025\050\035\042\085\035\027\117\118\117\025\050")
_EB5Id.Description = ""
_EB5Id.Visible = true
_EB5Id.Active = false
_EB5Id.Complete = false
_EB5Id.CorrectState = "None"
_mMw = Wherigo.ZTask(_mnz)
_mMw.Id = "6179bcf1-be27-4589-9443-2c10d9dcd36d"
_mMw.Name = _qo9("\120\093\014\117\080\025\050\035\029\085\035\027\117\118\117\025\050")
_mMw.Description = ""
_mMw.Visible = true
_mMw.Active = false
_mMw.Complete = false
_mMw.CorrectState = "None"
_QL_T = Wherigo.ZTask(_mnz)
_QL_T.Id = "1416ea34-79ab-4ad4-84ea-c070d5623d07"
_QL_T.Name = _qo9("\120\093\099\050\012\035\054\093\054\057\117")
_QL_T.Description = ""
_QL_T.Visible = true
_QL_T.Active = false
_QL_T.Complete = false
_QL_T.CorrectState = "None"

-- Cartridge Variables --
pointALat = 0
pointALon = 0
_TUtD = false
_ObP = false
_Yhlj = false
_N8yvw = false
_e9w7 = false
_0LFdO = false
_VLDKh = false
_58qCX = false
_U8f = ""
_QUG = ""
_pOi = ""
_Wyy = ""
_odHL = false
_iwKRv = false
_cFzg = false
_sRM = ""
_U76WI = ""
gckod = _qo9("\040\083\029\040\042\066\119")
esouradnice = 0
nsouradnice = 0
nasobic = 0
_BgDj = false
radius = 0
_UFqTm = _qo9("\080\008\025\117\098")
_lqMLG = _qo9("\033\031\013\013\053")
_uoDW = _qo9("\082\111\015\042\120\028")
_I_beW = _qo9("\082\082\004\014\013\042")
_6sjW = _qo9("\033\031\013\013\053")
_NSp = _qo9("\033\031\013\013\053")
_mnz.ZVariables = {
	pointALat = 0, 
	pointALon = 0, 
	_TUtD = false, 
	_ObP = false, 
	_Yhlj = false, 
	_N8yvw = false, 
	_e9w7 = false, 
	_0LFdO = false, 
	_VLDKh = false, 
	_58qCX = false, 
	_U8f = "", 
	_QUG = "", 
	_pOi = "", 
	_Wyy = "", 
	_odHL = false, 
	_iwKRv = false, 
	_cFzg = false, 
	_sRM = "", 
	_U76WI = "", 
	gckod = _qo9("\040\083\029\040\042\066\119"), 
	esouradnice = 0, 
	nsouradnice = 0, 
	nasobic = 0, 
	_BgDj = false, 
	radius = 0, 
	_UFqTm = _qo9("\080\008\025\117\098"), 
	_lqMLG = _qo9("\033\031\013\013\053"), 
	_uoDW = _qo9("\082\111\015\042\120\028"), 
	_I_beW = _qo9("\082\082\004\014\013\042"), 
	_6sjW = _qo9("\033\031\013\013\053"), 
	_NSp = _qo9("\033\031\013\013\053")
}

-- Timers --

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function _mnz:OnStart()
	if (_G[_qo9("\090\025\115")][_qo9("\019\014\093\012\073\008\027\013")] == _qo9("\045\050\025\029\042")) or (_G[_qo9("\090\025\115")][_qo9("\119\117\115\050\054\117\039\119")] == _qo9("\119\117\118\110\012\008\074")) then
		for k, v in pairs(_G[_qo9("\082\013\025\080")][_qo9("\098\014\014\087\109\052\099\117\054\012\118")]) do
			v[_qo9("\126\050\118\050\052\014\117")] = false
			v[_qo9("\098\054\012\050\115\117")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_qo9("\122\050\004\025\093\014\035\040\019\122\035\025\117\025\050\035\110\035\033\050\118\074\008\080\050\054\050\085")), 
			Callback = function(action)
				if action ~= nil then
					_G[_qo9("\045\057\117\027\050\004\008")][_qo9("\083\008\013\013\093\025\033")](_qo9("\122\093\115\117\083\014\008\118\117"))
				end
			end
		}
		return
	end
	_Urwigo.Dialog(false, {
		{
			Text = _qo9("\071\050\118\012\117\035\080\025\093\118\035\110\014\093\118\050\054\110\008\031\035\118\110\008\014\025\050\035\031\014\008\057\031\035\025\093\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\085"), 
			Media = _KoSC3
		}, 
		{
			Text = _qo9("\055\093\110\117\035\013\025\117\035\012\093\012\008\035\013\053\118\014\117\025\110\093\035\008\118\014\008\115\050\014\093\035\067\035\110\008\014\050\110\035\027\117\118\117\025\050\035\115\031\052\117\054\035\117\111\050\118\012\031\099\117\002\021\112\036\059\071\117\033\025\008\070\035\033\115\117\070\035\025\117\052\008\035\118\025\093\033\035\115\050\054\117\002")
		}, 
		{
			Text = _qo9("\120\117\052\031\033\031\035\012\117\035\033\014\008\031\057\008\035\025\093\074\050\025\093\012\070\035\013\008\080\025\053\054\057\035\027\117\118\117\025\050\035\099\117\035\065\065\085\021\112\036\059\098\035\012\115\053\013\035\031\110\008\014\117\013\035\052\031\033\117\035\025\093\014\117\080\012\035\093\014\117\118\074\008\025\035\012\027\050\035\080\035\025\050\054\057\085"), 
			Buttons = {
				_qo9("\071\119\032\035\120\098\035\055\109")
			}
		}
	}, function(action)
		_Urwigo.Dialog(false, {
			{
				Text = _qo9("\120\053\025\050\035\013\031\080\117\118\035\080\093\054\050\012\035\118\035\115\053\080\025\093\054\117\025\050\013\035\027\008\057\008\115\053\054\057\035\052\008\033\031\035\033\008\013\117\054\110\031\085"), 
				Media = _KoSC3
			}, 
			{
				Text = _qo9("\120\093\099\033\050\035\118\050\035\033\008\118\012\093\012\117\054\025\117\035\115\117\014\110\117\035\074\027\008\118\012\027\093\025\118\012\115\050\085\021\112\036\059\083\050\013\035\115\117\012\118\050\070\035\012\050\013\035\014\117\074\117\070\035\093\014\117\035\013\050\025\050\013\093\014\025\117\035\034\030\111\034\030\035\013\117\012\027\031\085")
			}, 
			{
				Text = _qo9("\019\027\117\099\033\050\035\033\008\035\013\050\118\012\093\070\035\110\033\117\035\052\053\035\013\117\014\035\052\053\012\035\052\008\033\035\098\035\093\035\074\008\031\080\050\099\035\012\031\080\110\031\070\035\110\012\117\027\008\031\035\025\093\014\117\080\025\117\118\035\115\117\035\118\115\117\013\035\052\093\012\031\080\110\031\085"), 
				Media = _ThaP, 
				Buttons = {
					_qo9("\071\050\012\035\033\008\035\052\008\033\031\035\098")
				}
			}
		}, function(action)
			_FqeF2.Description = _qo9("\109\033\117\013\053\110\093\054\050\035\110\008\033\035\038\083\008\013\074\014\117\012\050\008\025\035\083\008\033\117\006\035\074\027\008\035\008\080\025\093\054\117\025\050\035\057\027\053\035\099\093\110\008\035\033\008\110\008\025\054\117\025\117\035\025\093\035\074\008\027\012\093\014\031\035\076\076\085\076\057\117\027\050\004\008\073\008\031\025\033\093\012\050\008\025\085\054\008\013\035\099\117\068\021\112\036\059")..string.sub(Player.CompletionCode, 1, 15)
		end)
	end)
end
function _mnz:OnRestore()
end
function zoneA:OnEnter()
	_UFqTm = _qo9("\080\008\025\117\098")
	_HHW()
end
function zoneB:OnEnter()
	_UFqTm = _qo9("\080\008\025\117\112")
	_HHW()
end
function zoneC:OnEnter()
	_UFqTm = _qo9("\080\008\025\117\083")
	_HHW()
end
function zoneD:OnEnter()
	_UFqTm = _qo9("\080\008\025\117\119")
	_HHW()
end
function zoneE:OnEnter()
	_UFqTm = _qo9("\080\008\025\117\090")
	_HHW()
end
function pomocnaA:OnEnter()
	_UFqTm = _qo9("\074\008\013\008\054\025\093\098")
	_xK2N7.Commands._qX4.Enabled = false
end
function pomocnaA:OnExit()
	_UFqTm = _qo9("\074\008\013\008\054\025\093\098")
	_xK2N7.Commands._qX4.Enabled = true
end
function pomocnaB:OnEnter()
	_UFqTm = _qo9("\074\008\013\008\054\025\093\112")
	if _BgDj == false then
		_BgDj = true
		_mnz.Complete = true
		_QL_T.Complete = true
		_Urwigo.MessageBox{
			Text = _qo9("\119\008\027\093\080\050\014\035\099\118\050\035\025\093\035\013\050\118\012\008\035\110\033\117\035\099\117\035\031\110\027\053\012\093\035\054\093\054\057\117\035\093\035\012\050\013\035\012\093\012\008\035\057\027\093\035\110\008\025\054\050\085\021\112\036\059\021\112\036\059\025\093\074\008\115\117\033\093\068\035\096\014\117\033\117\099\035\124\025\052\118\074\078\119\109\079\090\083\090\015\085"), 
			Callback = function(action)
				if action ~= nil then
					_mnz:RequestSync()
					_Urwigo.MessageBox{
						Text = _qo9("\096\027\093\035\031\014\008\080\117\025\093\085"), 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _qo9("\096\014\117\033\117\099\035\124\025\052\118\074\078\119\109\079\090\083\090\015\085"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _xK2N7:On_m12LA(target)
	CenterZoneOnPoint(pomocnaA, Player.ObjectLocation, 10)
	pomocnaA.Visible = false
	pointALat = Player.ObjectLocation.latitude
	pointALon = Player.ObjectLocation.longitude
	_xK2N7.Commands._m12LA.Enabled = false
	__glm2.Complete = true
	_trVt.Active = true
	_xK2N7.Media = _caBeS
	_Urwigo.Dialog(false, {
		{
			Text = _qo9("\112\008\033\035\098\035\052\053\014\035\025\093\110\027\117\118\014\117\025\085\021\112\036\059\120\053\025\050\035\074\027\117\099\033\050\035\025\093\035\013\050\118\012\008\035\110\033\117\035\054\057\054\117\118\035\025\093\110\027\117\118\014\050\012\035\052\008\033\035\112\035\093\035\008\074\117\012\035\074\008\031\080\050\099\035\012\031\080\110\031\085"), 
			Media = _caBeS
		}, 
		{
			Text = _qo9("\019\008\110\031\033\035\052\031\033\117\118\035\074\027\050\014\050\118\035\052\014\050\080\110\008\035\052\008\033\031\035\098\070\035\012\093\110\035\012\050\035\012\031\080\110\093\035\025\117\033\008\115\008\014\050\035\052\008\033\035\112\035\025\093\110\027\117\118\014\050\012\085"), 
			Buttons = {
				_qo9("\071\050\012\035\033\008\035\052\008\033\031\035\112")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _xK2N7:On_qX4(target)
	radius = _Urwigo.Floor(Wherigo.VectorToPoint(Player.ObjectLocation, pomocnaA.OriginalPoint):GetValue "m" / 4.8, 0)
	pomocnaA.Active = false
	_xK2N7.Commands._qX4.Enabled = false
	_xK2N7.Commands._PtJy.Enabled = true
	_trVt.Complete = true
	_xK2N7.Media = _KoSC3
	_t3nwj.Active = true
	BuildHouse(
	  Wherigo.ZonePoint(pointALat, pointALon, 0),
	  Player.ObjectLocation,
	  zoneA,
	  zoneB,
	  zoneC,
	  zoneD,
	  zoneE,
	  radius)
	_Urwigo.Dialog(false, {
		{
			Text = _qo9("\112\008\033\035\112\035\052\053\014\035\080\093\110\027\117\118\014\117\025\085\021\112\036\059\119\093\014\118\050\035\052\008\033\053\035\083\070\119\070\090\035\052\053\014\053\035\115\053\012\115\008\027\117\025\053\035\093\031\012\008\013\093\012\050\054\110\053\085")
		}, 
		{
			Text = _qo9("\120\053\025\050\035\099\050\080\035\013\031\080\117\118\035\080\093\054\050\012\035\118\035\110\027\117\118\014\117\025\050\013\035\075\085\035\027\117\118\117\025\050\085"), 
			Media = _KoSC3
		}, 
		{
			Text = _qo9("\019\027\117\118\031\025\035\118\117\035\033\008\035\052\008\033\031\035\115\117\035\110\012\117\027\117\013\035\054\057\054\117\118\035\080\093\054\050\012\035\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\035\093\035\008\074\117\012\035\074\008\031\080\050\099\035\012\031\080\110\031\085\021\112\036\059\055\115\031\099\035\074\008\057\053\052\035\074\027\050\035\115\053\012\115\093\027\117\025\050\035\052\008\033\031\035\118\117\035\033\008\035\027\117\118\117\025\050\035\120\090\074\008\054\050\012\093\085"), 
			Media = _KoSC3, 
			Buttons = {
				_qo9("\071\033\050\035\025\093\035\080\093\054\093\012\117\110")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _xK2N7:On_PtJy(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_xK2N7.Commands._PtJy.Enabled = false
		_odHL = true
		_pR5n()
		_Bay()
		_Urwigo.Dialog(false, {
			{
				Text = _qo9("\087\093\054\093\014\035\099\118\050\035\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\085\021\112\036\059\120\053\025\050\035\118\117\035\012\115\031\099\035\074\008\057\053\052\035\013\117\080\050\035\099\117\033\025\008\012\014\050\115\053\013\050\035\052\008\033\053\035\080\093\080\025\093\013\117\025\093\115\093\035\099\093\110\008\035\110\027\117\118\014\117\025\050\035\099\117\033\025\050\013\035\012\093\057\117\013\085")
			}, 
			{
				Text = _qo9("\098\110\012\031\093\014\025\117\035\013\093\118\035\025\093\110\027\117\118\014\117\025\008\068\035").._U8f, 
				Media = _KoSC3, 
				Buttons = {
					_qo9("\019\008\110\027\093\054\008\115\093\012")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _qo9("\120\117\118\012\008\099\050\118\035\025\093\035\080\093\033\025\117\013\035\052\008\033\117\085"), 
			Buttons = {
				_qo9("\071\033\050\035\025\093\035\074\008\054\093\012\117\054\025\050\035\052\008\033")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _xK2N7:On_4j9f3(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_xK2N7.Commands._4j9f3.Enabled = false
		_iwKRv = true
		_pR5n()
		_Bay()
		_Urwigo.Dialog(false, {
			{
				Text = _qo9("\087\093\054\093\014\035\099\118\050\035\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\085\021\112\036\059\120\053\025\050\035\118\117\035\012\115\031\099\035\074\008\057\053\052\035\013\117\080\050\035\099\117\033\025\008\012\014\050\115\053\013\050\035\052\008\033\053\035\080\093\080\025\093\013\117\025\093\115\093\035\099\093\110\008\035\110\027\117\118\014\117\025\050\035\099\117\033\025\050\013\035\012\093\057\117\013\085")
			}, 
			{
				Text = _qo9("\098\110\012\031\093\014\025\117\035\013\093\118\035\025\093\110\027\117\118\014\117\025\008\068\035").._QUG, 
				Media = _KoSC3, 
				Buttons = {
					_qo9("\019\008\110\027\093\054\008\115\093\012")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _qo9("\120\117\118\012\008\099\050\118\035\025\093\035\080\093\033\025\117\013\035\052\008\033\117\085"), 
			Buttons = {
				_qo9("\071\033\050\035\025\093\035\074\008\054\093\012\117\054\025\050\035\052\008\033")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _xK2N7:On_aoFj(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_xK2N7.Commands._aoFj.Enabled = false
		_cFzg = true
		_pR5n()
		_Bay()
		_Urwigo.Dialog(false, {
			{
				Text = _qo9("\087\093\054\093\014\035\099\118\050\035\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\085\021\112\036\059\120\053\025\050\035\118\117\035\012\115\031\099\035\074\008\057\053\052\035\013\117\080\050\035\099\117\033\025\008\012\014\050\115\053\013\050\035\052\008\033\053\035\080\093\080\025\093\013\117\025\093\115\093\035\099\093\110\008\035\110\027\117\118\014\117\025\050\035\099\117\033\025\050\013\035\012\093\057\117\013\085")
			}, 
			{
				Text = _qo9("\098\110\012\031\093\014\025\117\035\013\093\118\035\025\093\110\027\117\118\014\117\025\008\068\035").._pOi, 
				Media = _KoSC3, 
				Buttons = {
					_qo9("\019\008\110\027\093\054\008\115\093\012")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _qo9("\120\117\118\012\008\099\050\118\035\025\093\035\080\093\033\025\117\013\035\052\008\033\117\085"), 
			Buttons = {
				_qo9("\071\033\050\035\025\093\035\074\008\054\093\012\117\054\025\050\035\052\008\033")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end

-- Urwigo functions --
function _pR5n()
	if zoneA:Contains(Player) then
		_Wyy = _qo9("\098")
	elseif zoneB:Contains(Player) then
		_Wyy = _qo9("\112")
	elseif zoneE:Contains(Player) then
		_Wyy = _qo9("\083")
	elseif zoneC:Contains(Player) then
		_Wyy = _qo9("\119")
	elseif zoneD:Contains(Player) then
		_Wyy = _qo9("\090")
	end
end
function _Bay()
	if _odHL == true then
		_U8f = _U8f.._Wyy
		_t3nwj.Description = _U8f
	elseif _iwKRv == true then
		_QUG = _QUG.._Wyy
		_EB5Id.Description = _QUG
	elseif _cFzg == true then
		_pOi = _pOi.._Wyy
		_mMw.Description = _pOi
	end
end
function _KKI()
	_U76WI = _sRM.._Wyy
	if Wherigo.NoCaseEquals(_U76WI, _qo9("\098\112")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\112\098")) then
		if _TUtD == false then
			_TUtD = true
			_LKJ()
		else
			_hV9g()
		end
	elseif Wherigo.NoCaseEquals(_U76WI, _qo9("\098\119")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\119\098")) then
		if _ObP == false then
			_ObP = true
			_LKJ()
		else
			_hV9g()
		end
	elseif Wherigo.NoCaseEquals(_U76WI, _qo9("\098\083")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\083\098")) then
		if _Yhlj == false then
			_Yhlj = true
			_LKJ()
		else
			_hV9g()
		end
	elseif Wherigo.NoCaseEquals(_U76WI, _qo9("\112\083")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\083\112")) then
		if _N8yvw == false then
			_N8yvw = true
			_LKJ()
		else
			_hV9g()
		end
	elseif Wherigo.NoCaseEquals(_U76WI, _qo9("\112\119")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\119\112")) then
		if _e9w7 == false then
			_e9w7 = true
			_LKJ()
		else
			_hV9g()
		end
	elseif Wherigo.NoCaseEquals(_U76WI, _qo9("\083\119")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\119\083")) then
		if _0LFdO == false then
			_0LFdO = true
			_LKJ()
		else
			_hV9g()
		end
	elseif Wherigo.NoCaseEquals(_U76WI, _qo9("\083\090")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\090\083")) then
		if _VLDKh == false then
			_VLDKh = true
			_LKJ()
		else
			_hV9g()
		end
	elseif Wherigo.NoCaseEquals(_U76WI, _qo9("\119\090")) or Wherigo.NoCaseEquals(_U76WI, _qo9("\090\119")) then
		if _58qCX == false then
			_58qCX = true
			_LKJ()
		else
			_hV9g()
		end
	end
end
function _LKJ()
	if (((((((_TUtD == true) and (_ObP == true)) and (_Yhlj == true)) and (_N8yvw == true)) and (_e9w7 == true)) and (_0LFdO == true)) and (_VLDKh == true)) and (_58qCX == true) then
		_Adjh()
		if _odHL == true then
			_odHL = false
			_xK2N7.Commands._4j9f3.Enabled = true
			_t3nwj.Complete = true
			_EB5Id.Active = true
			_Urwigo.Dialog(false, {
				{
					Text = _qo9("\040\027\093\012\031\014\031\099\050\035\110\035\075\085\035\118\074\027\093\115\025\117\013\031\035\027\117\118\117\025\050\085")
				}, 
				{
					Text = _qo9("\120\053\025\050\035\118\117\035\013\031\080\117\118\035\074\031\118\012\050\012\035\033\008\035\025\093\014\117\080\117\025\050\035\033\027\031\057\117\057\008\035\027\117\118\117\025\050\085")
				}, 
				{
					Text = _qo9("\019\027\117\118\031\025\035\118\117\035\033\008\035\052\008\033\031\035\115\117\035\110\012\117\027\117\013\035\054\057\054\117\118\035\080\093\054\050\012\035\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\035\093\035\074\008\031\080\050\099\035\012\031\080\110\031\085"), 
					Media = _KoSC3, 
					Buttons = {
						_qo9("\071\033\050\035\025\093\035\080\093\054\093\012\117\110")
					}
				}
			}, function(action)
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end)
		elseif _iwKRv == true then
			if Wherigo.NoCaseEquals(_U8f, _QUG) then
				_hV9g()
			else
				_iwKRv = false
				_xK2N7.Commands._aoFj.Enabled = true
				_EB5Id.Complete = true
				_mMw.Active = true
				_Urwigo.Dialog(false, {
					{
						Text = _qo9("\040\027\093\012\031\014\031\099\050\035\110\035\042\085\035\118\074\027\093\115\025\117\013\031\035\027\117\118\117\025\050\085")
					}, 
					{
						Text = _qo9("\120\053\025\050\035\012\050\035\099\050\080\035\080\052\053\115\093\035\025\093\014\117\080\012\035\074\008\118\014\117\033\025\050\035\027\117\118\117\025\050\085")
					}, 
					{
						Text = _qo9("\019\027\117\118\031\025\035\118\117\035\033\008\035\052\008\033\031\035\115\117\035\110\012\117\027\117\013\035\054\057\054\117\118\035\080\093\054\050\012\035\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\035\093\035\074\008\031\080\050\099\035\012\031\080\110\031\085"), 
						Media = _KoSC3, 
						Buttons = {
							_qo9("\071\033\050\035\025\093\035\080\093\054\093\012\117\110")
						}
					}
				}, function(action)
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end)
			end
		elseif _cFzg == true then
			if Wherigo.NoCaseEquals(_pOi, _QUG) or Wherigo.NoCaseEquals(_pOi, _U8f) then
				_hV9g()
			else
				_cFzg = false
				_xK2N7:MoveTo(nil)
				_mMw.Complete = true
				zoneA.Active = false
				zoneB.Active = false
				zoneE.Active = false
				zoneC.Active = false
				zoneD.Active = false
				_Urwigo.Dialog(false, {
					{
						Text = _qo9("\040\027\093\012\031\014\031\099\050\035\110\035\029\085\035\118\074\027\093\115\025\117\013\031\035\027\117\118\117\025\050\085")
					}, 
					{
						Text = _qo9("\120\053\025\050\035\013\031\080\117\118\035\099\050\080\035\115\053\027\093\080\050\012\035\057\014\117\033\093\012\035\054\093\054\057\117\085"), 
						Buttons = {
							_qo9("\032\077\109\087\039\055\035\096\036\032")
						}
					}
				}, function(action)
					_mnz:RequestSync()
					_6vy1()
				end)
			end
		end
	else
		_C7HkO()
	end
end
function _hV9g()
	_Adjh()
	if _odHL == true then
		_t3nwj.Description = ""
		_U8f = ""
		_odHL = false
		_xK2N7.Commands._PtJy.Enabled = true
	elseif _iwKRv == true then
		_EB5Id.Description = ""
		_QUG = ""
		_iwKRv = false
		_xK2N7.Commands._4j9f3.Enabled = true
	elseif _cFzg == true then
		_mMw.Description = ""
		_pOi = ""
		_cFzg = false
		_xK2N7.Commands._aoFj.Enabled = true
	end
	_Urwigo.Dialog(false, {
		{
			Text = _qo9("\032\033\117\014\093\014\035\099\118\050\035\054\057\053\052\031\035\025\117\052\008\035\025\093\110\027\117\118\050\014\035\033\008\013\117\054\117\110\035\118\012\117\099\025\117\035\099\093\110\008\035\115\035\074\027\117\033\054\057\008\080\050\013\035\027\117\118\117\025\050\085\021\112\036\059\122\035\093\110\012\031\093\014\025\050\013\035\027\117\118\117\025\050\013\035\013\031\118\050\118\035\080\093\054\050\012\035\080\025\008\115\031\085")
		}, 
		{
			Text = _qo9("\019\027\117\118\031\025\035\118\117\035\033\008\035\052\008\033\031\035\115\117\035\110\012\117\027\117\013\035\054\057\054\117\118\035\080\093\054\050\012\035\110\027\117\118\014\050\012\035\033\008\013\117\054\117\110\035\099\117\033\025\050\013\035\012\093\057\117\013\035\093\035\074\008\031\080\050\099\035\012\031\080\110\031\085")
		}, 
		{
			Text = _qo9("\119\008\074\008\027\031\054\031\099\050\035\080\093\054\050\012\035\115\035\052\008\033\117\035\098\035\025\117\052\008\035\115\035\052\008\033\117\035\112\085"), 
			Buttons = {
				_qo9("\071\050\012\035\033\008\035\115\053\054\057\008\080\050\057\008\035\052\008\033\031")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _HHW()
	if ((_odHL == true) or (_iwKRv == true)) or (_cFzg == true) then
		_sRM = _Wyy
		_pR5n()
		if Wherigo.NoCaseEquals(_Wyy, _sRM) then
			_Urwigo.MessageBox{
				Text = _qo9("\126\012\093\012\050\014\035\099\118\050\035\118\117\035\033\008\035\052\008\033\031\035").._Wyy, 
				Buttons = {
					_qo9("\019\008\110\027\093\054\008\115\093\012")
				}, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
		else
			_Bay()
			_KKI()
		end
	else
	end
end
function _Adjh()
	_TUtD = false
	_ObP = false
	_Yhlj = false
	_N8yvw = false
	_e9w7 = false
	_0LFdO = false
	_VLDKh = false
	_58qCX = false
end
function _C7HkO()
	if _odHL == true then
		_Urwigo.MessageBox{
			Text = _qo9("\098\110\012\031\093\014\025\117\035\013\093\118\035\025\093\110\027\117\118\014\117\025\008\068\035").._U8f, 
			Media = _KoSC3, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _iwKRv == true then
		_Urwigo.MessageBox{
			Text = _qo9("\098\110\012\031\093\014\025\117\035\013\093\118\035\025\093\110\027\117\118\014\117\025\008\068\035").._QUG, 
			Media = _KoSC3, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _cFzg == true then
		_Urwigo.MessageBox{
			Text = _qo9("\098\110\012\031\093\014\025\117\035\013\093\118\035\025\093\110\027\117\118\014\117\025\008\068\035").._pOi, 
			Media = _KoSC3, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _6vy1()
	nasobic = string.sub(gckod, 3, 3)
	nasobic = tonumber(nasobic..(string.sub(gckod, 5, 5)))
	nsouradnice = 1.55934009375 * nasobic
	esouradnice = 452.525856 / nasobic
	pomocnaB.Visible = true
	CenterZoneOnPoint(pomocnaB, ZonePoint(nsouradnice,esouradnice,0), 7)
	_QL_T.Active = true
	_FqeF2.Visible = true
	_Urwigo.MessageBox{
		Text = _qo9("\112\053\014\093\035\008\033\110\027\053\012\093\035\080\008\025\093\035\083\098\083\096\090\085\035"), 
		Buttons = {
			_qo9("\120\098\126\039\040\109\126\098\055")
		}, 
		Callback = function(action)
			if action ~= nil then
				_mnz:RequestSync()
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, pomocnaB)
			end
		end
	}
end

-- Begin user functions --
function CenterZoneOnPoint(zZone, point, ZoneRadius)
  local dist = Wherigo.Distance(0, 'ft')
  local newZp = Wherigo.TranslatePoint(point, dist, 0)   -- new center point for the new zone    
  dist = Wherigo.Distance(ZoneRadius, 'm')
  local pts = {
    Wherigo.TranslatePoint(newZp, dist, 0),
    Wherigo.TranslatePoint(newZp, dist, 45),
    Wherigo.TranslatePoint(newZp, dist, 90),
    Wherigo.TranslatePoint(newZp, dist, 135),
    Wherigo.TranslatePoint(newZp, dist, 180),
    Wherigo.TranslatePoint(newZp, dist, 225),
    Wherigo.TranslatePoint(newZp, dist, 270),
    Wherigo.TranslatePoint(newZp, dist, 315),
  }

  zZone.Active = false
  zZone.OriginalPoint.latitude = newZp.latitude
  zZone.OriginalPoint.longitude = newZp.longitude

  zZone.Points = pts
  zZone.Active = true
end

function BuildHouse(pointA, pointB, zoneA, zoneB, zoneC, zoneD, zoneE, zoneRadius)
  print(pointA)
  print(pointB)
  CenterZoneOnPoint(zoneA, pointA, zoneRadius)
  CenterZoneOnPoint(zoneB, pointB, zoneRadius)
  local dist, bearing = Wherigo.VectorToPoint(pointA, pointB)
  local dist2 = Wherigo.Distance(dist.value * 0.7071, dist.units)
  local pointC = Wherigo.TranslatePoint(pointB, dist, bearing - 90)
  CenterZoneOnPoint(zoneC, pointC, zoneRadius)
  local pointD = Wherigo.TranslatePoint(pointC, dist2, bearing - 135)
  CenterZoneOnPoint(zoneD, pointD, zoneRadius)
  local pointE = Wherigo.TranslatePoint(pointC, dist, bearing - 180)
  CenterZoneOnPoint(zoneE, pointE, zoneRadius)
end
-- End user functions --
return _mnz
