require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_BZTb = Wherigo.ZCartridge()

-- String decode --
function _oP2wy(str)
	local res = ""
    local dtable = "\108\003\098\043\120\104\056\030\034\122\085\107\006\015\040\071\047\116\081\044\031\041\033\070\088\082\074\100\023\053\016\093\058\062\024\092\007\066\020\050\112\067\096\025\124\011\083\019\125\078\115\069\084\097\086\028\064\089\102\010\000\004\073\048\103\037\018\095\091\094\038\110\032\090\068\126\009\076\054\106\036\014\052\013\042\002\027\026\049\114\077\059\057\118\075\046\060\072\035\008\061\121\111\065\099\113\063\029\119\045\079\051\105\087\117\017\109\123\021\055\005\080\012\039\022\101\001"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_pOFH = Wherigo.ZMedia(_BZTb)
_pOFH.Id = "d5e4a1e8-5c4d-457f-8526-a89d9cbc3de4"
_pOFH.Name = _oP2wy("\003\115\010\010")
_pOFH.Description = _oP2wy("\104\073\051\103\115\072\028\073\018\103\073\054\001\126\090\018\073\051\103\117\126\103\072\126")
_pOFH.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_pOFH.Resources = {
	{
		Type = "wav", 
		Filename = "buzzthru.wav", 
		Directives = {}
	}
}
_EUKN = Wherigo.ZMedia(_BZTb)
_EUKN.Id = "d9dc4766-a64c-4ed7-b960-689cce57b250"
_EUKN.Name = _oP2wy("\104\041\041\001\054\115\051\126")
_EUKN.Description = _oP2wy("\026\113\065\006\018\073\054\072\051\109\126\090\073")
_EUKN.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_EUKN.Resources = {
	{
		Type = "wav", 
		Filename = "applausesmall.wav", 
		Directives = {}
	}
}
_8Sf = Wherigo.ZMedia(_BZTb)
_8Sf.Id = "5f6356a9-fbc0-4da5-85a2-251838268c76"
_8Sf.Name = _oP2wy("\114\113\105\012\113\115\041\073\024\090\103\072\018\073\047\113\065\072")
_8Sf.Description = _oP2wy("\114\113\105\012\113\115\041\073\024\090\103\072\018\073\047\113\065\072")
_8Sf.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\041\113\105\018\115\090\126\073\105\054\072\072\103\018\073\003\126\073\028\113\051\041\001\054\102\126\028\096")
_8Sf.Resources = {
	{
		Type = "jpg", 
		Filename = "Wickiupfrontsign1.jpg", 
		Directives = {}
	}
}
_T_WT = Wherigo.ZMedia(_BZTb)
_T_WT.Id = "68365e49-b8c8-4aa4-9ce8-033cabb61dbf"
_T_WT.Name = _oP2wy("\114\113\105\012\113\115\041\073\098\113\001\001")
_T_WT.Description = _oP2wy("\001\103\065\103")
_T_WT.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\041\113\105\018\115\090\126\073\105\054\072\072\103\018\073\003\126\073\028\113\051\041\001\054\102\126\028\096")
_T_WT.Resources = {
	{
		Type = "jpg", 
		Filename = "Wickiup.jpg", 
		Directives = {}
	}
}
_01X = Wherigo.ZMedia(_BZTb)
_01X.Id = "b43ab60c-f294-4779-8e2f-c83f6830626e"
_01X.Name = _oP2wy("\114\126\018\001\054\072\028\051")
_01X.Description = _oP2wy("\053\006\113\051\073\113\051\073\054\073\003\126\054\115\018\113\059\115\001\073\028\126\105\012\073\018\006\054\018\073\113\051\073\054\001\103\072\065\073\054\073\065\103\103\028\073\041\103\090\018\113\103\072\073\103\059\073\018\006\126\073\109\126\018\001\054\072\028\051\096")
_01X.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\041\113\105\018\115\090\126\073\105\054\072\072\103\018\073\003\126\073\028\113\051\041\001\054\102\126\028\096")
_01X.Resources = {
	{
		Type = "jpg", 
		Filename = "Wetlands.jpg", 
		Directives = {}
	}
}
_YjG = Wherigo.ZMedia(_BZTb)
_YjG.Id = "005a60fa-c44f-4128-b852-cb7b524d3716"
_YjG.Name = _oP2wy("\078\113\072\072\073\042\103\115\072\018\102\073\042\103\072\051\126\090\094\054\018\113\103\072")
_YjG.Description = _oP2wy("\078\113\072\072\073\042\103\115\072\018\102\073\042\103\072\051\126\090\094\054\018\113\103\072")
_YjG.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\041\113\105\018\115\090\126\073\105\054\072\072\103\018\073\003\126\073\028\113\051\041\001\054\102\126\028\096")
_YjG.Resources = {
	{
		Type = "jpg", 
		Filename = "LinnCountyConservation.jpg", 
		Directives = {}
	}
}
_dw_n_ = Wherigo.ZMedia(_BZTb)
_dw_n_.Id = "0ea8a7a7-6270-44f7-83cd-a95034bac490"
_dw_n_.Name = _oP2wy("\038\115\113\001\028\113\072\065")
_dw_n_.Description = _oP2wy("\038\115\113\001\028\113\072\065")
_dw_n_.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\041\113\105\018\115\090\126\073\105\054\072\072\103\018\073\003\126\073\028\113\051\041\001\054\102\126\028\096")
_dw_n_.Resources = {
	{
		Type = "jpg", 
		Filename = "WickiupBuilding.jpg", 
		Directives = {}
	}
}
_jHb = Wherigo.ZMedia(_BZTb)
_jHb.Id = "06d83b2a-4a03-4efb-92e2-7eedd6358740"
_jHb.Name = _oP2wy("\075\115\105\012")
_jHb.Description = _oP2wy("\042\054\072\073\003\126\073\059\103\115\072\028\073\126\094\126\090\102\109\006\126\090\126")
_jHb.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_jHb.Resources = {
	{
		Type = "wav", 
		Filename = "duck.wav", 
		Directives = {}
	}
}
_IqwO = Wherigo.ZMedia(_BZTb)
_IqwO.Id = "54c9160c-ae59-46ef-ac1b-cb62d6b3a9c6"
_IqwO.Name = _oP2wy("\114\113\072\028")
_IqwO.Description = _oP2wy("\091\102\073\105\054\072\073\113\018\073\003\001\103\109\023")
_IqwO.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_IqwO.Resources = {
	{
		Type = "wav", 
		Filename = "windy.wav", 
		Directives = {}
	}
}
_AHr8 = Wherigo.ZMedia(_BZTb)
_AHr8.Id = "ba54277e-2664-423b-9f52-83a65e25c26a"
_AHr8.Name = _oP2wy("\024\090\103\065")
_AHr8.Description = _oP2wy("\059\103\115\072\028\073\113\072\073\018\006\126\073\109\126\018\001\054\072\028\051")
_AHr8.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_AHr8.Resources = {
	{
		Type = "wav", 
		Filename = "frog.wav", 
		Directives = {}
	}
}
_5QEQf = Wherigo.ZMedia(_BZTb)
_5QEQf.Id = "ce2870ec-dbd0-4c17-a548-fb3c75aa7def"
_5QEQf.Name = _oP2wy("\024\103\090\126\051\018")
_5QEQf.Description = _oP2wy("\104\001\001\073\054\090\103\115\072\028\073\102\103\115\073")
_5QEQf.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_5QEQf.Resources = {
	{
		Type = "wav", 
		Filename = "forest.wav", 
		Directives = {}
	}
}
_cKDC = Wherigo.ZMedia(_BZTb)
_cKDC.Id = "acd4169b-fc69-4a50-9e7a-1acce196d63a"
_cKDC.Name = _oP2wy("\053\115\090\012\126\102\073")
_cKDC.Description = _oP2wy("\003\113\065\073\003\113\090\028\051")
_cKDC.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_cKDC.Resources = {
	{
		Type = "wav", 
		Filename = "turkey.wav", 
		Directives = {}
	}
}
_ybTQn = Wherigo.ZMedia(_BZTb)
_ybTQn.Id = "1d99ef21-5a9d-44bf-aacb-91829c3f227a"
_ybTQn.Name = _oP2wy("\047\041\054\090\090\103\109")
_ybTQn.Description = _oP2wy("\054\073\003\113\090\028")
_ybTQn.AltText = _oP2wy("\047\103\090\090\102\073\102\103\115\090\073\051\103\115\072\028\073\028\103\126\051\073\072\103\018\073\109\103\090\012")
_ybTQn.Resources = {
	{
		Type = "wav", 
		Filename = "sparrow.wav", 
		Directives = {}
	}
}
__8H8 = Wherigo.ZMedia(_BZTb)
__8H8.Id = "211c99bc-b4cf-4134-ad58-c13692ac6aac"
__8H8.Name = _oP2wy("\053\090\126\054\051\115\090\126\073\042\006\126\051\018")
__8H8.Description = _oP2wy("\024\113\072\054\001\073\001\103\105\054\018\113\103\072")
__8H8.AltText = _oP2wy("\047\103\090\090\102\073\113\059\073\102\103\115\073\105\054\072\072\103\018\073\051\126\126\073\018\006\126\073\041\113\105\018\115\090\126\073\102\103\115\073\105\054\072\072\103\018\073\051\126\126\073\018\006\126\073\059\113\072\054\001\073\042\054\105\006\126\073\001\103\105\054\018\113\103\072\096\073\042\103\072\018\054\105\018\073\018\006\126\073\114\006\126\090\113\065\103\073\103\109\072\126\090\096")
__8H8.Resources = {
	{
		Type = "jpg", 
		Filename = "treasure-chest.jpg", 
		Directives = {}
	}
}
_REnD9 = Wherigo.ZMedia(_BZTb)
_REnD9.Id = "b3fcb69a-e87f-4c30-bcd4-6f3e627ebc79"
_REnD9.Name = _oP2wy("\047\072\054\012\126\073\098\113\001\001")
_REnD9.Description = _oP2wy("\053\006\113\051\073\054\090\126\054\073\113\051\073\006\103\117\126\073\018\103\073\051\126\094\126\090\054\001\073\051\072\054\012\126\051\073\109\006\103\073\001\113\012\126\073\018\103\073\003\054\051\012\073\113\072\073\018\006\126\073\051\115\072\073\006\126\090\126\096\073\071\072\003\051\041\092")
_REnD9.AltText = ""
_REnD9.Resources = {
	{
		Type = "jpg", 
		Filename = "SnakeHill.jpg", 
		Directives = {}
	}
}
_mwOG = Wherigo.ZMedia(_BZTb)
_mwOG.Id = "a4ae4746-ece0-4d17-83eb-8413aa47f4d8"
_mwOG.Name = _oP2wy("\047\041\126\054\090\073\122\103\113\072\018")
_mwOG.Description = _oP2wy("\053\006\113\051\073\113\051\073\109\006\126\090\126\073\054\073\105\103\115\041\001\126\073\047\041\126\054\090\073\041\103\113\072\018\051\073\006\054\094\126\073\003\126\126\072\073\059\103\115\072\028\073\113\072\073\018\006\126\073\041\054\051\018\096\073")
_mwOG.AltText = ""
_mwOG.Resources = {
	{
		Type = "jpg", 
		Filename = "SpearPoint.jpg", 
		Directives = {}
	}
}
_V2y = Wherigo.ZMedia(_BZTb)
_V2y.Id = "83b6c6d7-ca10-4e6c-be8f-f2d830fc8afa"
_V2y.Name = _oP2wy("\098\113\001\001\051\113\028\126\073\042\054\117\041")
_V2y.Description = _oP2wy("\053\006\113\051\073\113\051\073\109\006\126\090\126\073\054\073\094\113\001\001\113\054\065\126\073\103\072\105\126\073\051\018\103\103\028\096")
_V2y.AltText = ""
_V2y.Resources = {
	{
		Type = "jpg", 
		Filename = "HillsideCamp.jpg", 
		Directives = {}
	}
}
_uiLiJ = Wherigo.ZMedia(_BZTb)
_uiLiJ.Id = "4ad60270-8ade-4b99-b205-f945c793f4cc"
_uiLiJ.Name = _oP2wy("\038\054\105\012\109\054\018\126\090\051")
_uiLiJ.Description = _oP2wy("\053\006\113\051\073\054\090\126\054\073\006\054\051\073\059\001\103\103\028\126\028\073\003\126\059\103\090\126")
_uiLiJ.AltText = ""
_uiLiJ.Resources = {
	{
		Type = "jpg", 
		Filename = "Backwaters.jpg", 
		Directives = {}
	}
}
_KZk = Wherigo.ZMedia(_BZTb)
_KZk.Id = "7f3caa49-b817-416a-9b0e-54221d126408"
_KZk.Name = _oP2wy("\111\051\041\090\126\102\073\098\054\105\012\073\053\103\109\126\090")
_KZk.Description = _oP2wy("\104\072\073\103\003\051\126\090\094\054\018\113\103\072\073\018\103\109\126\090")
_KZk.AltText = ""
_KZk.Resources = {
	{
		Type = "jpg", 
		Filename = "OspreyHacTower.jpg", 
		Directives = {}
	}
}
_N9z = Wherigo.ZMedia(_BZTb)
_N9z.Id = "158996ae-92b4-493e-af4a-05b7004e55bf"
_N9z.Name = _oP2wy("\042\103\072\018\054\105\018\073\113\072\059\103\090\117\054\018\113\072")
_N9z.Description = _oP2wy("\114\113\105\012\113\115\041\073\041\006\103\072\126\073\072\115\117\003\126\090")
_N9z.AltText = _oP2wy("\053\006\126\073\041\006\103\072\126\073\072\115\117\003\126\090\073\113\051\073\112\089\093\110\007\093\040\110\079\083\007\030")
_N9z.Resources = {
	{
		Type = "jpg", 
		Filename = "Contactinformation.jpg", 
		Directives = {}
	}
}
_HvAY0 = Wherigo.ZMedia(_BZTb)
_HvAY0.Id = "055c6ae1-2b4e-4e6d-80a3-fbd17afcc3bf"
_HvAY0.Name = _oP2wy("\111\003\051\126\090\094\054\018\113\103\072\073\075\126\105\012")
_HvAY0.Description = _oP2wy("\053\006\126\073\094\113\126\109\073\059\090\103\117\073\018\006\126\073\103\003\051\126\090\094\054\018\113\103\072\073\028\126\105\012")
_HvAY0.AltText = ""
_HvAY0.Resources = {
	{
		Type = "jpg", 
		Filename = "WickiupDock.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_BZTb.Id="57dc8069-caf8-4699-afa3-103c5f747899"
_BZTb.Name="Wickiup"
_BZTb.Description=[[Please head on over to the Wickiup Outdoor Learning Center. 

10260 Morris Hills RD
Toddville, IA 52341

Please observe park hours and note when the gates close. ]]
_BZTb.Visible=true
_BZTb.Activity="TourGuide"
_BZTb.StartingLocationDescription=[[Parking lot of Wickiup
]]
_BZTb.StartingLocation = ZonePoint(42.0826951281014,-91.7642819881439,0)
_BZTb.Version="1"
_BZTb.Company=""
_BZTb.Author="Bill Borowicz"
_BZTb.BuilderVersion="URWIGO 1.12.4281.38707"
_BZTb.CreateDate="11/27/2010 08:05:49"
_BZTb.PublishDate="1/1/0001 12:00:00 AM"
_BZTb.UpdateDate="12/12/2011 07:54:59"
_BZTb.LastPlayedDate="1/1/0001 12:00:00 AM"
_BZTb.TargetDevice="PocketPC"
_BZTb.TargetDeviceVersion="0"
_BZTb.StateId="1"
_BZTb.CountryId="2"
_BZTb.Complete=false
_BZTb.UseLogging=true

_BZTb.Media=_T_WT

_BZTb.Icon=_T_WT


-- Zones --
_aCNCS = Wherigo.Zone(_BZTb)
_aCNCS.Id = "382c55ad-86e9-43fd-b730-ad31f3d0d0ce"
_aCNCS.Name = _oP2wy("\038\115\113\001\028\113\072\065")
_aCNCS.Description = _oP2wy("\053\006\126\073\114\113\105\012\113\115\041\073\111\115\018\028\103\103\090\073\078\126\054\090\072\113\072\065\073\105\126\072\018\126\090\073\003\115\113\001\028\113\072\065\096\073\042\103\117\126\073\113\072\051\113\028\126\073\113\059\073\113\018\073\113\051\073\103\041\126\072\073\018\103\073\051\126\126\073\001\103\018\051\073\103\059\073\113\072\018\126\090\126\051\018\113\072\065\073\018\006\113\072\065\051\096\073")
_aCNCS.Visible = true
_aCNCS.Media = _dw_n_
_aCNCS.Commands = {}
_aCNCS.DistanceRange = Distance(-1, "feet")
_aCNCS.ShowObjects = "OnEnter"
_aCNCS.ProximityRange = Distance(60, "meters")
_aCNCS.AllowSetPositionTo = false
_aCNCS.Active = true
_aCNCS.Points = {
	ZonePoint(42.0825955941578, -91.7645421624183, 0), 
	ZonePoint(42.0826871653916, -91.7652422189712, 0), 
	ZonePoint(42.083419730505, -91.7648050189018, 0), 
	ZonePoint(42.0833878800237, -91.7644670605659, 0)
}
_aCNCS.OriginalPoint = ZonePoint(42.0830225925195, -91.7647641152143, 0)
_aCNCS.DistanceRangeUOM = "Feet"
_aCNCS.ProximityRangeUOM = "Meters"
_aCNCS.OutOfRangeName = ""
_aCNCS.InRangeName = ""
_gYml = Wherigo.Zone(_BZTb)
_gYml.Id = "bba8120a-6ae3-469e-a8db-39ef45b9ee8a"
_gYml.Name = _oP2wy("\114\126\018\001\054\072\028")
_gYml.Description = _oP2wy("\053\006\113\051\073\113\051\073\054\073\041\001\054\105\126\073\018\103\073\051\126\126\073\054\001\001\073\012\113\072\028\051\073\103\059\073\041\001\054\072\018\051\073\054\072\028\073\054\072\113\117\054\001\051\073\018\006\054\018\073\105\054\072\073\003\126\073\059\103\115\072\028\073\113\072\073\109\054\018\126\090\096")
_gYml.Visible = false
_gYml.Media = _01X
_gYml.Commands = {}
_gYml.DistanceRange = Distance(-1, "feet")
_gYml.ShowObjects = "OnEnter"
_gYml.ProximityRange = Distance(56, "meters")
_gYml.AllowSetPositionTo = false
_gYml.Active = false
_gYml.Points = {
	ZonePoint(42.0832843658493, -91.7641854286193, 0), 
	ZonePoint(42.0830614116693, -91.7639708518982, 0), 
	ZonePoint(42.0831967768006, -91.7631661891937, 0), 
	ZonePoint(42.0836028704617, -91.7633485794067, 0)
}
_gYml.OriginalPoint = ZonePoint(42.0832863561952, -91.7636677622795, 0)
_gYml.DistanceRangeUOM = "Feet"
_gYml.ProximityRangeUOM = "Meters"
_gYml.OutOfRangeName = ""
_gYml.InRangeName = ""
_3rv = Wherigo.Zone(_BZTb)
_3rv.Id = "4f416039-c4cb-46b1-a96a-9b29c5f7ed37"
_3rv.Name = _oP2wy("\111\003\051\126\090\094\054\018\113\103\072\073\075\126\105\012")
_3rv.Description = _oP2wy("\053\006\126\073\094\113\126\109\073\103\059\073\018\006\126\073\109\126\018\001\054\072\028\051\073\059\090\103\117\073\054\073\103\003\051\126\090\094\054\018\113\103\072\073\028\126\105\012\096")
_3rv.Visible = false
_3rv.Media = _HvAY0
_3rv.Commands = {}
_3rv.DistanceRange = Distance(-1, "feet")
_3rv.ShowObjects = "OnEnter"
_3rv.ProximityRange = Distance(100, "feet")
_3rv.AllowSetPositionTo = false
_3rv.Active = false
_3rv.Points = {
	ZonePoint(42.0837979537472, -91.7646883428096, 0), 
	ZonePoint(42.083634720835, -91.7646615207195, 0), 
	ZonePoint(42.0836367114828, -91.7644415795803, 0), 
	ZonePoint(42.0838059163176, -91.7644523084163, 0)
}
_3rv.OriginalPoint = ZonePoint(42.0837188255957, -91.7645609378814, 0)
_3rv.DistanceRangeUOM = "Feet"
_3rv.ProximityRangeUOM = "Feet"
_3rv.OutOfRangeName = ""
_3rv.InRangeName = ""
_3wz = Wherigo.Zone(_BZTb)
_3wz.Id = "aa8a9ac8-c8f7-45e5-af75-52f589d59ea9"
_3wz.Name = _oP2wy("\047\072\054\012\126\073\098\113\001\001")
_3wz.Description = _oP2wy("\038\126\073\105\054\090\126\059\115\001\073\072\103\018\073\018\103\073\051\018\115\117\003\001\126\073\115\041\103\072\073\054\073\051\072\054\012\126\073\006\126\090\126\096")
_3wz.Visible = false
_3wz.Media = _REnD9
_3wz.Commands = {}
_3wz.DistanceRange = Distance(-1, "feet")
_3wz.ShowObjects = "OnEnter"
_3wz.ProximityRange = Distance(60, "meters")
_3wz.AllowSetPositionTo = false
_3wz.Active = false
_3wz.Points = {
	ZonePoint(42.0854889821945, -91.7666383087634, 0), 
	ZonePoint(42.0855208316209, -91.7662762105464, 0), 
	ZonePoint(42.0857656735529, -91.7663352191447, 0), 
	ZonePoint(42.0857636829719, -91.7666704952716, 0)
}
_3wz.OriginalPoint = ZonePoint(42.0856347925851, -91.7664800584315, 0)
_3wz.DistanceRangeUOM = "Feet"
_3wz.ProximityRangeUOM = "Meters"
_3wz.OutOfRangeName = ""
_3wz.InRangeName = ""
_3hQd = Wherigo.Zone(_BZTb)
_3hQd.Id = "d8490adf-33f3-404d-b0b7-c7fbd9b226c5"
_3hQd.Name = _oP2wy("\047\041\126\054\090\073\122\103\113\072\018")
_3hQd.Description = _oP2wy("\078\103\103\012\073\054\090\103\115\072\028\073\059\103\090\073\054\090\018\113\059\054\105\018\051\020\073\102\103\115\073\117\054\102\073\028\113\051\105\103\094\126\090\073\117\103\090\126\096\073")
_3hQd.Visible = false
_3hQd.Media = _mwOG
_3hQd.Commands = {}
_3hQd.DistanceRange = Distance(-1, "feet")
_3hQd.ShowObjects = "OnEnter"
_3hQd.ProximityRange = Distance(60, "meters")
_3hQd.AllowSetPositionTo = false
_3hQd.Active = false
_3hQd.Points = {
	ZonePoint(42.0881782118174, -91.7678587138652, 0), 
	ZonePoint(42.088011009154, -91.7678399384021, 0), 
	ZonePoint(42.0880567908795, -91.7675583064555, 0), 
	ZonePoint(42.0882797275051, -91.7676334083079, 0)
}
_3hQd.OriginalPoint = ZonePoint(42.088131434839, -91.7677225917577, 0)
_3hQd.DistanceRangeUOM = "Feet"
_3hQd.ProximityRangeUOM = "Meters"
_3hQd.OutOfRangeName = ""
_3hQd.InRangeName = ""
_uxY = Wherigo.Zone(_BZTb)
_uxY.Id = "6ad73cb4-e542-437b-9a3e-fafc2dae06bd"
_uxY.Name = _oP2wy("\098\113\001\001\051\113\028\126\073\042\054\117\041")
_uxY.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\051\113\018\126\073\103\059\073\054\072\073\054\072\105\113\126\072\018\073\094\113\001\001\054\065\126\096")
_uxY.Visible = false
_uxY.Media = _V2y
_uxY.Commands = {}
_uxY.DistanceRange = Distance(-1, "feet")
_uxY.ShowObjects = "OnEnter"
_uxY.ProximityRange = Distance(60, "meters")
_uxY.AllowSetPositionTo = false
_uxY.Active = false
_uxY.Points = {
	ZonePoint(42.0899168943458, -91.7674335837363, 0), 
	ZonePoint(42.0898651426061, -91.767020523548, 0), 
	ZonePoint(42.090155747982, -91.7670580744742, 0), 
	ZonePoint(42.0901318626589, -91.7674067616462, 0)
}
_uxY.OriginalPoint = ZonePoint(42.0900174118982, -91.7672297358512, 0)
_uxY.DistanceRangeUOM = "Feet"
_uxY.ProximityRangeUOM = "Meters"
_uxY.OutOfRangeName = ""
_uxY.InRangeName = ""
_hkX8 = Wherigo.Zone(_BZTb)
_hkX8.Id = "2eb06433-6b7a-4769-bc67-af6c22143832"
_hkX8.Name = _oP2wy("\038\054\105\012\109\054\018\126\090\051")
_hkX8.Description = _oP2wy("\053\006\126\073\042\126\028\054\090\073\026\113\094\126\090\073\115\051\126\073\018\103\073\059\001\103\109\073\054\105\090\103\051\051\073\006\126\090\126\096")
_hkX8.Visible = false
_hkX8.Media = _uiLiJ
_hkX8.Commands = {}
_hkX8.DistanceRange = Distance(-1, "feet")
_hkX8.ShowObjects = "OnEnter"
_hkX8.ProximityRange = Distance(60, "meters")
_hkX8.AllowSetPositionTo = false
_hkX8.Active = false
_hkX8.Points = {
	ZonePoint(42.0855636292631, -91.7732942104338, 0), 
	ZonePoint(42.0853964197094, -91.7731118202208, 0), 
	ZonePoint(42.0854840057215, -91.772779226303, 0), 
	ZonePoint(42.0857109325539, -91.772966980934, 0)
}
_hkX8.OriginalPoint = ZonePoint(42.085538746812, -91.7730380594729, 0)
_hkX8.DistanceRangeUOM = "Feet"
_hkX8.ProximityRangeUOM = "Meters"
_hkX8.OutOfRangeName = ""
_hkX8.InRangeName = ""
_A34Gi = Wherigo.Zone(_BZTb)
_A34Gi.Id = "de4bba89-06ae-45bb-acec-00285b07e6ab"
_A34Gi.Name = _oP2wy("\111\051\041\090\126\102\073\098\054\105\012\073\053\103\109\126\090")
_A34Gi.Description = _oP2wy("\104\072\073\103\001\028\073\059\054\090\117\073\115\051\126\073\018\103\073\051\018\054\072\028\073\113\072\073\018\006\113\051\073\054\090\126\054\096")
_A34Gi.Visible = false
_A34Gi.Media = _KZk
_A34Gi.Commands = {}
_A34Gi.DistanceRange = Distance(-1, "feet")
_A34Gi.ShowObjects = "OnEnter"
_A34Gi.ProximityRange = Distance(60, "meters")
_A34Gi.AllowSetPositionTo = false
_A34Gi.Active = false
_A34Gi.Points = {
	ZonePoint(42.083050463009, -91.7665390670298, 0), 
	ZonePoint(42.0830405096774, -91.7668206989764, 0), 
	ZonePoint(42.0828613494417, -91.7667885124682, 0), 
	ZonePoint(42.0829310229268, -91.7664478719233, 0)
}
_A34Gi.OriginalPoint = ZonePoint(42.0829708362637, -91.7666490375994, 0)
_A34Gi.DistanceRangeUOM = "Feet"
_A34Gi.ProximityRangeUOM = "Meters"
_A34Gi.OutOfRangeName = ""
_A34Gi.InRangeName = ""
_l9WM = Wherigo.Zone(_BZTb)
_l9WM.Id = "75a4d5ff-40e2-4a9e-9485-17ffa0fcc06d"
_l9WM.Name = _oP2wy("\053\113\028\003\113\018\089")
_l9WM.Description = _oP2wy("\063\072\018\126\090\126\051\018\113\072\065\073\059\054\105\018\051\096\073")
_l9WM.Visible = false
_l9WM.Commands = {}
_l9WM.DistanceRange = Distance(-1, "feet")
_l9WM.ShowObjects = "OnEnter"
_l9WM.ProximityRange = Distance(60, "meters")
_l9WM.AllowSetPositionTo = false
_l9WM.Active = true
_l9WM.Points = {
	ZonePoint(42.0841816489698, -91.7727141827344, 0), 
	ZonePoint(42.0842692366589, -91.772467419505, 0), 
	ZonePoint(42.0839985106837, -91.7724030464886, 0), 
	ZonePoint(42.0839905481376, -91.7727034538983, 0)
}
_l9WM.OriginalPoint = ZonePoint(42.0841099861125, -91.7725720256566, 0)
_l9WM.DistanceRangeUOM = "Feet"
_l9WM.ProximityRangeUOM = "Meters"
_l9WM.OutOfRangeName = ""
_l9WM.InRangeName = ""
_9VRdD = Wherigo.Zone(_BZTb)
_9VRdD.Id = "037e9bb4-d911-4c1d-b7d4-cfbac03760d0"
_9VRdD.Name = _oP2wy("\053\113\028\003\113\018\040")
_9VRdD.Description = _oP2wy("\063\072\018\126\090\126\051\018\113\072\065\073\059\054\105\018\051")
_9VRdD.Visible = false
_9VRdD.Commands = {}
_9VRdD.DistanceRange = Distance(-1, "feet")
_9VRdD.ShowObjects = "OnEnter"
_9VRdD.ProximityRange = Distance(60, "meters")
_9VRdD.AllowSetPositionTo = false
_9VRdD.Active = true
_9VRdD.Points = {
	ZonePoint(42.0868828772856, -91.7715098708867, 0), 
	ZonePoint(42.0870182342636, -91.7711826413869, 0), 
	ZonePoint(42.0867634444182, -91.7709895223378, 0), 
	ZonePoint(42.0866081813543, -91.7713167518376, 0)
}
_9VRdD.OriginalPoint = ZonePoint(42.0868181843304, -91.7712496966123, 0)
_9VRdD.DistanceRangeUOM = "Feet"
_9VRdD.ProximityRangeUOM = "Meters"
_9VRdD.OutOfRangeName = ""
_9VRdD.InRangeName = ""

-- Characters --
__aAh2 = Wherigo.ZCharacter(_BZTb)
__aAh2.Id = "f2bec4aa-5d1e-4ce5-b503-de7410dc895a"
__aAh2.Name = _oP2wy("\026\054\072\065\126\090")
__aAh2.Description = _oP2wy("\053\006\113\051\073\113\051\073\026\054\072\065\126\090\073\114\113\105\073\095\113\115\041\096\073\053\006\126\102\073\012\072\103\109\073\126\094\126\090\102\018\006\113\072\065\073\018\006\126\090\126\073\113\051\073\018\103\073\012\072\103\109\073\054\003\103\115\018\073\114\113\105\012\113\115\041\096")
__aAh2.Visible = false
__aAh2.Commands = {
	_yyh = Wherigo.ZCommand{
		Text = _oP2wy("\053\054\001\012"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _oP2wy("\050\103\018\006\113\072\065\073\054\094\054\113\001\054\003\001\126")
	}
}
__aAh2.Commands._yyh.Custom = true
__aAh2.Commands._yyh.Id = "df2c6e3a-cdd9-46a3-b893-5072fee251f2"
__aAh2.Commands._yyh.WorksWithAll = true
__aAh2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
__aAh2.Gender = "Female"
__aAh2.Type = "NPC"

-- Items --
_KHR = Wherigo.ZItem(_BZTb)
_KHR.Id = "59e1e94f-0ce0-4741-9b70-5141bf2a2647"
_KHR.Name = _oP2wy("\050\054\018\115\090\126")
_KHR.Description = _oP2wy("\114\006\054\018\073\102\103\115\073\109\113\001\001\073\054\001\109\054\102\051\073\051\126\126\073\054\018\073\114\113\105\012\113\115\041\096\073\097\038\026\034\097\038\026\034\078\103\103\012\073\054\090\103\115\072\028\073\054\072\028\073\126\072\080\103\102\096")
_KHR.Visible = true
_KHR.Commands = {
	_zu_ = Wherigo.ZCommand{
		Text = _oP2wy("\078\103\103\012"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _oP2wy("\050\103\018\006\113\072\065\073\054\094\054\113\001\054\003\001\126")
	}
}
_KHR.Commands._zu_.Custom = true
_KHR.Commands._zu_.Id = "98848ff4-9276-4e81-a882-fc159baa13d6"
_KHR.Commands._zu_.WorksWithAll = true
_KHR.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KHR.Locked = false
_KHR.Opened = false
_EBwn0 = Wherigo.ZItem(_BZTb)
_EBwn0.Id = "802d2b2a-46a0-43cb-95bc-19319d049cd9"
_EBwn0.Name = _oP2wy("\053\090\126\054\051\115\090\126\073\042\006\126\051\018")
_EBwn0.Description = _oP2wy("\114\006\126\090\126\073\102\103\115\073\105\054\072\073\059\113\072\028\073\001\103\018\051\073\103\059\073\018\090\126\054\051\115\090\126\051\096")
_EBwn0.Visible = false
_EBwn0.Media = __8H8
_EBwn0.Commands = {}
_EBwn0.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EBwn0.Locked = false
_EBwn0.Opened = false
_5vd = Wherigo.ZItem(_BZTb)
_5vd.Id = "3e7280fe-f299-42da-ae48-903204b1db30"
_5vd.Name = _oP2wy("\042\103\072\018\054\105\018\073\113\072\059\103\090\117\054\018\113\103\072")
_5vd.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\041\006\103\072\126\073\072\115\117\003\126\090\073\018\103\073\018\006\126\073\038\115\113\001\028\113\072\065\073\113\059\073\102\103\115\073\072\126\126\028\073\054\051\051\113\051\018\054\072\105\126\096\073\097\038\026\034\097\038\026\034\075\103\073\072\103\018\073\001\103\103\051\126\073\018\006\113\051\073\072\115\117\003\126\090\073\112\089\093\110\007\093\040\110\079\083\007\030\096")
_5vd.Visible = true
_5vd.Media = _N9z
_5vd.Icon = _N9z
_5vd.Commands = {}
_5vd.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_5vd.Locked = false
_5vd.Opened = false

-- Tasks --
_rKR = Wherigo.ZTask(_BZTb)
_rKR.Id = "88929853-dc90-4c06-ad0c-d709134a6817"
_rKR.Name = _oP2wy("\016\103\073\018\103\073\018\006\126\073\038\115\113\001\028\113\072\065")
_rKR.Description = _oP2wy("\016\103\073\018\103\073\018\006\126\073\003\115\113\001\028\113\072\065\073\018\103\073\018\054\001\012\073\018\103\073\018\006\126\073\090\054\072\065\126\090\096")
_rKR.Visible = true
_rKR.Active = true
_rKR.Complete = false
_rKR.CorrectState = "None"
_hBkXG = Wherigo.ZTask(_BZTb)
_hBkXG.Id = "002495f5-8491-4d70-af7f-08d61df123d7"
_hBkXG.Name = _oP2wy("\016\103\073\018\103\073\018\006\126\073\114\126\018\001\054\072\028\051")
_hBkXG.Description = _oP2wy("\058\103\115\073\117\115\051\018\073\051\126\126\073\018\006\113\051\073\041\001\054\105\126\073\113\018\073\113\051\073\090\126\054\001\001\102\073\105\103\103\001\096\073")
_hBkXG.Visible = false
_hBkXG.Active = false
_hBkXG.Complete = false
_hBkXG.CorrectState = "None"
_JIEha = Wherigo.ZTask(_BZTb)
_JIEha.Id = "7bc8b393-183c-4b98-ae6d-21d703eac88c"
_JIEha.Name = _oP2wy("\016\103\073\018\103\073\047\072\054\012\126\073\098\113\001\001")
_JIEha.Description = _oP2wy("\053\006\113\051\073\113\051\073\054\073\117\115\051\018\073\051\126\126\073\041\001\054\105\126\096")
_JIEha.Visible = false
_JIEha.Active = false
_JIEha.Complete = false
_JIEha.CorrectState = "None"
_MAf = Wherigo.ZTask(_BZTb)
_MAf.Id = "942992e4-77d8-4328-b618-4352eaf6ec05"
_MAf.Name = _oP2wy("\016\103\073\018\103\073\047\041\126\054\090\073\122\103\113\072\018")
_MAf.Description = _oP2wy("\053\006\113\051\073\054\073\090\126\054\001\001\102\073\072\126\054\018\073\001\103\105\054\018\113\103\072")
_MAf.Visible = false
_MAf.Active = false
_MAf.Complete = false
_MAf.CorrectState = "None"
_KNWZ = Wherigo.ZTask(_BZTb)
_KNWZ.Id = "40e235ee-5ed5-4566-9343-aa29050975ce"
_KNWZ.Name = _oP2wy("\016\103\073\018\103\073\018\006\126\073\098\113\001\001\051\113\028\126\073\042\054\117\041")
_KNWZ.Description = _oP2wy("\011\041\073\018\006\126\073\006\113\001\001\073\109\126\073\065\103")
_KNWZ.Visible = false
_KNWZ.Active = false
_KNWZ.Complete = false
_KNWZ.CorrectState = "None"
_btWb = Wherigo.ZTask(_BZTb)
_btWb.Id = "a2b00b22-1bda-4be3-985d-8354e5cfbee4"
_btWb.Name = _oP2wy("\016\103\073\018\103\073\018\006\126\073\038\054\105\012\109\054\018\126\090\051")
_btWb.Description = _oP2wy("\063\051\073\113\018\073\065\126\018\018\113\072\065\073\054\073\001\113\018\018\001\126\073\051\106\115\113\051\006\102\073\054\090\103\115\072\028\073\006\126\090\126\107")
_btWb.Visible = false
_btWb.Active = false
_btWb.Complete = false
_btWb.CorrectState = "None"
_nGr = Wherigo.ZTask(_BZTb)
_nGr.Id = "b48cd1c3-46f2-4e36-847e-341ca1afb1cd"
_nGr.Name = _oP2wy("\016\103\073\018\103\073\018\006\126\073\111\051\041\090\126\102\073\098\054\105\012\073\053\103\109\126\090")
_nGr.Description = _oP2wy("\114\103\109\073\054\073\001\103\103\012\073\103\115\018\073\018\103\109\126\090")
_nGr.Visible = false
_nGr.Active = false
_nGr.Complete = false
_nGr.CorrectState = "None"

-- Cartridge Variables --
_hIN = ""
_zp2MZ = ""
_t78 = ""
_n4L = ""
_qDEO = ""
_4jfhz = ""
_BZTb.ZVariables = {
	_hIN = "", 
	_zp2MZ = "", 
	_t78 = "", 
	_n4L = "", 
	_qDEO = "", 
	_4jfhz = ""
}

-- Timers --

-- Inputs --
_rIdqk = Wherigo.ZInput(_BZTb)
_rIdqk.Id = "e746c8fd-c698-4bbe-922c-3dd418e9f671"
_rIdqk.Name = _oP2wy("\114\126\018\001\054\072\028\051\073\019\115\126\051\018\113\103\072")
_rIdqk.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\106\115\126\051\018\113\103\072\073\018\103\073\054\051\012\073\054\018\073\018\006\126\073\109\126\018\001\054\072\028\051\096")
_rIdqk.Visible = false
_rIdqk.Choices = {
	"Yes", 
	"No", 
	"Duh, I don't know"
}
_rIdqk.InputType = "MultipleChoice"
_rIdqk.Text = _oP2wy("\053\126\001\001\073\117\126\073\041\001\126\054\051\126\020\073\059\090\103\065\051\073\105\054\072\073\003\090\126\054\018\006\126\073\115\072\028\126\090\073\109\054\018\126\090\107\073")
_DDWa1 = Wherigo.ZInput(_BZTb)
_DDWa1.Id = "3a710c1f-75aa-401d-99cf-6598ca402a95"
_DDWa1.Name = _oP2wy("\047\072\054\012\126\073\098\113\001\001\073\019\115\126\051\018\113\103\072")
_DDWa1.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\106\115\126\051\018\113\103\072\073\018\103\073\054\051\012\073\054\018\073\047\072\054\012\126\073\098\113\001\001\073")
_DDWa1.Visible = false
_DDWa1.Choices = {
	"True", 
	"False"
}
_DDWa1.InputType = "MultipleChoice"
_DDWa1.Text = _oP2wy("\053\090\115\126\073\103\090\073\024\054\001\051\126\073\071\072\003\051\041\092\114\006\126\072\073\090\126\041\018\113\001\126\051\073\001\054\102\073\018\006\126\113\090\073\126\065\065\051\020\073\018\006\126\073\126\065\065\051\073\054\090\126\073\054\001\090\126\054\028\102\073\041\090\126\028\126\018\126\090\117\113\072\126\028\073\109\006\054\018\073\051\126\005\073\018\006\126\102\073\109\113\001\001\073\003\126\073\109\006\126\072\073\006\054\018\105\006\126\028\096")
_9ZIGO = Wherigo.ZInput(_BZTb)
_9ZIGO.Id = "d3e0ac4a-f10e-45e3-987e-c8eb6c270509"
_9ZIGO.Name = _oP2wy("\047\041\126\054\090\073\122\103\113\072\018\073\019\115\126\051\018\113\103\072")
_9ZIGO.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\106\115\126\051\018\113\103\072\073\018\103\073\054\051\012\073\054\018\073\018\006\126\073\047\041\126\054\090\073\122\103\113\072\018\096")
_9ZIGO.Visible = false
_9ZIGO.Choices = {
	"True", 
	"False"
}
_9ZIGO.InputType = "MultipleChoice"
_9ZIGO.Text = _oP2wy("\053\090\115\126\073\103\090\073\024\054\001\051\126\073\071\072\003\051\041\092\114\103\103\028\102\073\018\006\126\073\114\103\103\028\041\126\105\012\126\090\073\001\113\094\126\051\073\113\072\073\114\113\105\012\113\115\041\073\098\113\001\001\051\073\059\103\090\126\051\018\107")
_eJj = Wherigo.ZInput(_BZTb)
_eJj.Id = "0f4937c9-5d32-4d7c-b692-4fc56db9196e"
_eJj.Name = _oP2wy("\098\113\001\001\051\113\028\126\073\042\054\117\041\073\019\115\126\051\018\113\103\072")
_eJj.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\106\115\126\051\018\113\103\072\073\018\103\073\054\051\012\073\054\018\073\018\006\126\073\098\113\001\001\051\113\028\126\073\042\054\117\041\096")
_eJj.Visible = false
_eJj.Choices = {
	"True", 
	"False"
}
_eJj.InputType = "MultipleChoice"
_eJj.Text = _oP2wy("\053\090\115\126\073\103\090\073\024\054\001\051\126\073\071\072\003\051\041\092\104\073\109\113\105\012\113\115\041\073\113\051\073\054\073\071\072\003\051\041\092\050\054\018\113\094\126\073\104\117\126\090\113\105\054\072\073\006\103\117\126\096")
_UpZ1 = Wherigo.ZInput(_BZTb)
_UpZ1.Id = "8568120d-1b32-4f1e-b6f9-a415dd31e913"
_UpZ1.Name = _oP2wy("\038\054\105\012\109\054\018\126\090\051\073\019\115\126\051\018\113\103\072")
_UpZ1.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\106\115\126\051\018\113\103\072\073\018\103\073\054\051\012\073\054\018\073\018\006\126\073\038\054\105\012\109\054\018\126\090\051\096")
_UpZ1.Visible = false
_UpZ1.Choices = {
	"True", 
	"False"
}
_UpZ1.InputType = "MultipleChoice"
_UpZ1.Text = _oP2wy("\053\090\115\126\073\103\090\073\024\054\001\051\126\073\071\072\003\051\041\092\053\006\126\090\126\073\054\090\126\073\072\103\073\003\054\018\051\073\018\006\054\018\073\105\054\072\073\006\113\003\126\090\072\054\018\126\073\028\115\090\113\072\065\073\063\103\109\054\051\073\105\103\001\028\073\109\113\072\018\126\090\096")
_UVRu = Wherigo.ZInput(_BZTb)
_UVRu.Id = "3f34d029-cc6c-4045-8f09-6f89007d4ae8"
_UVRu.Name = _oP2wy("\111\051\041\090\126\102\073\098\054\105\012\073\053\103\109\126\090\073\019\115\126\051\018\113\103\072")
_UVRu.Description = _oP2wy("\053\006\113\051\073\113\051\073\018\006\126\073\106\115\126\051\018\113\103\072\073\018\103\073\054\051\012\073\054\018\073\018\006\126\073\111\051\041\090\126\102\073\098\054\105\012\073\053\103\109\126\090\096")
_UVRu.Visible = false
_UVRu.Choices = {
	"Yes", 
	"No"
}
_UVRu.InputType = "MultipleChoice"
_UVRu.Text = _oP2wy("\075\103\073\006\115\117\117\113\072\065\073\003\113\090\028\051\073\006\054\094\126\073\059\126\126\018\107")

-- WorksWithList for object commands --

-- functions --
function _BZTb:OnStart()
	_KHR:MoveTo(_aCNCS)
	_Urwigo.Dialog(false, {
		{
			Text = _oP2wy("\114\126\001\105\103\117\126\073\018\103\073\114\113\105\012\113\115\041\073\111\115\018\028\103\103\090\073\078\126\054\090\072\113\072\065\073\042\126\072\018\126\090\023")
		}, 
		{
			Text = _oP2wy("\063\072\073\018\006\113\051\073\114\006\126\090\113\065\103\073\109\126\073\109\113\001\001\073\126\005\041\001\103\090\126\073\018\006\126\073\117\054\072\102\073\109\103\072\028\126\090\059\115\001\073\018\006\113\072\065\051\073\018\103\073\051\126\126\073\054\090\103\115\072\028\073\018\006\126\073\114\113\105\012\113\115\041\073\041\054\090\012\096")
		}, 
		{
			Text = _oP2wy("\053\006\126\073\059\113\090\051\018\073\018\054\051\012\073\102\103\115\073\109\113\001\001\073\006\054\094\126\073\018\103\073\028\103\073\113\051\073\018\103\073\065\103\073\018\103\073\018\006\126\073\003\115\113\001\028\113\072\065\073\054\072\028\073\117\126\126\018\073\018\006\126\073\090\054\072\065\126\090\096\073\053\006\126\102\073\109\113\001\001\073\018\126\001\001\073\102\103\115\073\109\006\054\018\073\114\113\105\012\113\115\041\073\113\051\073\054\001\001\073\054\003\103\115\018\096\073\071\072\003\051\041\092")
		}
	}, function(action)
		_rKR.Visible = true
		_rKR.Active = true
	end)
end
function _BZTb:OnRestore()
end
function _aCNCS:OnEnter()
	Wherigo.PlayAudio(_pOFH)
	if _rKR.Complete == true then
		_Urwigo.MessageBox{
			Text = _oP2wy("\038\054\105\012\073\054\065\054\113\072\107\073\016\103\103\028\073\018\103\073\051\126\126\073\102\103\115\096\073\071\072\003\051\041\092")
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\098\126\001\001\103\073\063\073\054\117\073\026\054\072\065\126\090\073\114\113\105\073\095\113\115\041\073\054\072\028\073\109\126\001\105\103\117\126\073\018\103\073\018\006\126\073\114\113\105\012\113\115\041\073\111\115\018\028\103\103\090\073\078\126\054\090\072\113\072\065\073\105\126\072\018\126\090\096\073"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _oP2wy("\053\006\126\090\126\073\054\090\126\073\030\073\117\113\001\126\051\073\018\103\073\006\113\012\126\073\054\072\028\073\072\126\054\090\001\102\073\112\064\064\073\054\105\090\126\051\073\018\103\073\126\005\041\001\103\090\126\096\073\071\072\003\051\041\092\097\038\026\034\097\038\026\034\058\103\115\073\105\054\072\073\105\103\117\126\073\113\072\051\113\028\126\073\018\103\073\094\113\126\109\073\054\117\054\010\113\072\065\073\126\005\006\113\003\113\018\051\073\054\072\028\073\051\126\126\073\001\113\094\126\073\054\072\113\117\054\001\051\096\097\038\026\034\097\038\026\034\111\090\073\102\103\115\073\105\054\072\073\018\054\012\126\073\018\006\126\051\126\073\001\103\105\054\018\113\103\072\073\105\103\103\090\028\113\072\054\018\126\051\073\054\072\028\073\006\126\054\028\073\103\072\073\103\115\018\073\018\103\073\051\126\126\073\109\006\054\018\073\063\073\054\117\073\018\054\001\012\113\072\065\073\054\003\103\115\018\096\073\097\038\026\034\097\038\026\034\063\059\073\102\103\115\073\001\113\051\018\126\072\073\105\054\090\126\059\115\001\001\102\073\054\072\028\073\054\072\051\109\126\090\073\117\102\073\106\115\126\051\018\113\103\072\051\073\105\103\090\090\126\105\018\001\102\073\063\073\109\113\001\001\073\006\054\094\126\073\054\073\090\126\109\054\090\028\073\059\103\090\073\102\103\115\073\109\006\126\072\073\102\103\115\073\054\090\126\073\028\103\072\126\073\109\113\018\006\073\102\103\115\090\073\080\103\115\090\072\126\102\096\073"), 
						Callback = function(action)
							if action ~= nil then
								_gYml.Active = true
								_gYml.Visible = true
								_3rv.Active = true
								_3rv.Visible = true
								_hkX8.Active = true
								_hkX8.Visible = true
								_uxY.Active = true
								_uxY.Visible = true
								_A34Gi.Active = true
								_A34Gi.Visible = true
								_3wz.Active = true
								_3wz.Visible = true
								_3hQd.Active = true
								_3hQd.Visible = true
								_hBkXG.Visible = true
								_hBkXG.Active = true
								_JIEha.Active = true
								_JIEha.Visible = true
								_MAf.Active = true
								_MAf.Visible = true
								_btWb.Active = true
								_btWb.Visible = true
								_KNWZ.Active = true
								_KNWZ.Visible = true
								_nGr.Active = true
								_nGr.Visible = true
								_rKR.Complete = true
								_5vd:MoveTo(Player)
								_KHR:MoveTo(Player)
							end
						end
					}
				end
			end
		}
	end
end
function _aCNCS:OnExit()
	Wherigo.PlayAudio(_IqwO)
	_Urwigo.MessageBox{
		Text = _oP2wy("\053\006\054\072\012\073\102\103\115\073\059\103\090\073\105\103\117\113\072\065\073\018\103\073\018\006\126\073\003\115\113\001\028\113\072\065\096\073\063\018\073\109\113\001\001\073\003\126\073\006\126\090\126\073\054\018\073\018\006\126\073\051\018\054\090\018\113\072\065\073\041\103\113\072\018\073\103\059\073\102\103\115\090\073\054\028\094\126\072\018\115\090\126\073\109\006\126\072\126\094\126\090\073\102\103\115\073\072\126\126\028\073\113\018\096\073"), 
		Buttons = {
			_oP2wy("\091\102\073\041\001\126\054\051\115\090\126")
		}
	}
end
function _gYml:OnEnter()
	Wherigo.PlayAudio(_AHr8)
	if _hBkXG.Complete == true then
		_Urwigo.MessageBox{
			Text = _oP2wy("\058\103\115\073\006\054\094\126\073\054\001\090\126\054\028\102\073\003\126\126\072\073\006\126\090\126\020\073\102\103\115\073\051\006\103\115\001\028\073\018\090\102\073\054\072\028\073\094\113\051\113\018\073\103\018\006\126\090\073\001\103\105\054\018\113\103\072\051\096")
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\114\126\001\105\103\117\126\020\073\018\006\113\051\073\109\126\018\001\054\072\028\073\113\051\073\054\073\041\103\041\115\001\054\090\073\003\090\126\126\028\113\072\065\073\065\090\103\115\072\028\073\059\103\090\073\063\103\109\054\051\073\054\117\041\006\113\003\113\054\072\051\096\073\097\038\026\034\097\038\026\034\078\113\051\018\126\072\073\059\103\090\073\028\113\059\059\126\090\126\072\018\073\012\113\072\028\051\073\103\059\073\059\090\103\065\073\105\054\001\001\051\096\073\078\103\103\012\073\059\103\090\073\051\072\054\012\126\051\073\054\072\028\073\018\115\090\018\001\126\051\073\006\113\028\113\072\065\073\113\072\073\018\006\126\073\105\054\018\018\054\113\001\051\096"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_rIdqk)
					end)
				end
			end
		}
	end
end
function _gYml:OnExit()
	if _hBkXG.Complete == true then
		_gYml.Active = false
		_gYml.Visible = false
	end
end
function _3rv:OnEnter()
	Wherigo.PlayAudio(_jHb)
	_Urwigo.MessageBox{
		Text = _oP2wy("\075\113\028\073\102\103\115\073\012\072\103\109\073\018\006\054\018\073\109\006\126\072\073\018\115\090\018\001\126\051\073\006\113\003\126\090\072\054\018\126\073\028\126\126\041\073\113\072\073\018\006\126\073\109\126\018\001\054\072\028\073\117\115\028\073\018\006\126\102\073\003\090\126\054\018\006\126\073\018\006\090\103\115\065\006\073\018\006\126\113\090\073\003\115\018\018\023\023"), 
		Buttons = {
			_oP2wy("\113\105\012\023")
		}
	}
end
function _3rv:OnExit()
	Wherigo.PlayAudio(_jHb)
	_Urwigo.MessageBox{
		Text = _oP2wy("\075\113\028\072\124\018\073\063\073\018\126\001\001\073\102\103\115\096\073\063\018\073\109\054\051\073\072\126\054\018\073\109\054\051\072\124\018\073\113\018\107"), 
		Buttons = {
			_oP2wy("\058\126\051")
		}
	}
end
function _3rv:OnProximity()
	if true then
		Wherigo.PlayAudio(_pOFH)
		_Urwigo.MessageBox{
			Text = _oP2wy("\058\103\115\073\080\115\051\018\073\098\104\055\052\073\018\103\073\105\103\117\126\073\001\103\103\012\073\054\018\073\018\006\126\073\103\003\051\126\090\094\054\018\113\103\072\073\028\126\105\012\020\073\113\018\073\113\051\073\090\126\054\001\001\102\073\072\126\054\018\096\073")
		}
	end
end
function _3wz:OnEnter()
	Wherigo.PlayAudio(_5QEQf)
	if _JIEha.Complete == true then
		_Urwigo.MessageBox{
			Text = _oP2wy("\058\103\115\073\006\054\094\126\073\054\001\090\126\054\028\102\073\003\126\126\072\073\006\126\090\126\020\073\102\103\115\073\051\006\103\115\001\028\073\018\090\102\073\054\072\028\073\094\113\051\113\018\073\103\018\006\126\090\073\001\103\105\054\018\113\103\072\051\096")
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\114\126\001\105\103\117\126\073\018\103\073\047\072\054\012\126\073\098\113\001\001\097\038\026\034\097\038\026\034\053\006\126\073\072\113\105\012\072\054\117\126\073\109\054\051\073\065\113\094\126\072\073\018\103\073\113\018\073\003\126\105\054\115\051\126\073\103\059\073\054\001\001\073\018\006\126\073\051\072\054\012\126\051\073\059\103\115\072\028\073\003\054\051\012\113\072\065\073\113\072\073\018\006\126\073\051\115\072\073\103\072\073\018\006\126\073\109\054\090\117\073\051\054\072\028\102\073\006\113\001\001\096\073\097\038\026\034\097\038\026\034\104\001\051\103\020\073\018\006\113\051\073\113\051\073\018\006\126\073\051\113\018\126\073\109\006\126\090\126\073\041\090\126\006\113\051\018\103\090\113\105\073\059\113\090\126\110\105\090\054\105\012\126\028\073\090\103\105\012\073\054\072\028\073\059\001\054\012\126\051\073\059\090\103\117\073\051\018\103\072\126\073\018\103\103\001\073\117\054\012\113\072\065\073\109\054\051\073\059\103\115\072\028\073\006\126\090\126\096\073"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_DDWa1)
					end)
				end
			end
		}
	end
end
function _3wz:OnExit()
	if _JIEha.Complete == true then
		_3wz.Active = false
		_3wz.Visible = false
	end
end
function _3hQd:OnEnter()
	Wherigo.PlayAudio(_ybTQn)
	if _MAf.Complete == true then
		_Urwigo.MessageBox{
			Text = _oP2wy("\058\103\115\073\006\054\094\126\073\054\001\090\126\054\028\102\073\003\126\126\072\073\006\126\090\126\020\073\102\103\115\073\051\006\103\115\001\028\073\018\090\102\073\054\072\028\073\094\113\051\113\018\073\103\018\006\126\090\073\001\103\105\054\018\113\103\072\051\096")
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\104\073\051\041\126\054\090\073\041\103\113\072\018\073\117\054\028\126\073\028\115\090\113\072\065\073\018\006\126\073\104\090\105\006\054\113\105\073\018\113\117\126\073\041\126\090\113\103\028\073\109\054\051\073\059\103\115\072\028\073\072\126\054\090\073\018\006\113\051\073\001\103\105\054\018\113\103\072\096\073\097\038\026\034\097\038\026\034\091\054\028\126\073\079\020\064\064\064\073\102\126\054\090\051\073\054\065\103\023\073\097\038\026\034\097\038\026\034\050\103\018\126\033\073\063\018\073\113\051\073\113\001\001\126\065\054\001\073\018\103\073\028\113\065\073\054\072\028\073\018\054\012\126\073\054\072\102\073\054\090\018\113\059\054\105\018\051\073\059\090\103\117\073\105\103\115\072\018\102\073\103\090\073\051\018\054\018\126\073\041\054\090\012\051\096"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_9ZIGO)
					end)
				end
			end
		}
	end
end
function _3hQd:OnExit()
	if _MAf.Complete == true then
		_3hQd.Active = false
		_3hQd.Visible = false
	end
end
function _uxY:OnEnter()
	Wherigo.PlayAudio(_cKDC)
	if _KNWZ.Complete == true then
		_Urwigo.MessageBox{
			Text = _oP2wy("\058\103\115\073\006\054\094\126\073\054\001\090\126\054\028\102\073\003\126\126\072\073\006\126\090\126\020\073\102\103\115\073\051\006\103\115\001\028\073\018\090\102\073\054\072\028\073\094\113\051\113\018\073\103\018\006\126\090\073\001\103\105\054\018\113\103\072\051\096")
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\089\020\030\064\064\073\102\126\054\090\051\073\054\065\103\073\028\115\090\113\072\065\073\018\006\126\073\114\103\103\028\001\054\072\028\073\018\113\117\126\073\041\126\090\113\103\028\020\073\054\073\094\113\001\001\054\065\126\073\126\005\113\051\018\126\028\073\103\072\073\018\006\113\051\073\006\113\001\001\073\051\113\028\126\096\073\071\072\003\051\041\092\097\038\026\034\097\038\026\034\053\006\126\073\117\103\115\072\028\051\073\059\090\103\117\073\018\006\126\073\051\054\117\126\073\018\113\117\126\073\041\126\090\113\103\028\073\054\090\126\073\001\103\105\054\018\126\028\073\103\072\073\018\006\126\073\006\113\001\001\073\018\103\041\096\073\097\038\026\034\097\038\026\034\042\006\126\105\012\073\018\006\126\117\073\103\115\018\023"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_eJj)
					end)
				end
			end
		}
	end
end
function _uxY:OnExit()
	if _KNWZ.Complete == true then
		_uxY.Active = false
		_uxY.Visible = false
	end
end
function _hkX8:OnEnter()
	Wherigo.PlayAudio(_5QEQf)
	if _btWb.Complete == true then
		_Urwigo.MessageBox{
			Text = _oP2wy("\058\103\115\073\006\054\094\126\073\054\001\090\126\054\028\102\073\003\126\126\072\073\006\126\090\126\020\073\102\103\115\073\051\006\103\115\001\028\073\018\090\102\073\054\072\028\073\094\113\051\113\018\073\103\018\006\126\090\073\001\103\105\054\018\113\103\072\051\096")
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\024\090\103\117\073\018\006\113\051\073\054\090\126\054\073\054\001\001\073\054\105\090\103\051\051\073\018\103\073\018\006\126\073\078\126\054\090\072\113\072\065\073\042\126\072\018\126\090\073\006\054\051\073\003\126\126\072\073\105\103\094\126\090\126\028\073\003\102\073\018\006\126\073\042\126\028\054\090\073\026\113\094\126\090\073\113\072\073\018\006\126\073\001\054\051\018\073\089\030\064\073\102\126\054\090\051\096\073\097\038\026\034\097\038\026\034\026\113\094\126\090\051\073\001\103\094\126\073\018\103\073\109\054\072\028\126\090\096"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_UpZ1)
					end)
				end
			end
		}
	end
end
function _hkX8:OnExit()
	if _btWb.Complete == true then
		_hkX8.Active = false
		_hkX8.Visible = false
		_Urwigo.MessageBox{
			Text = _oP2wy("\053\006\126\073\105\006\054\072\105\126\073\103\059\073\028\102\113\072\065\073\003\102\073\001\113\065\006\018\072\113\072\065\073\051\018\090\113\012\126\073\113\051\073\059\054\090\073\065\090\126\054\018\126\090\073\018\006\054\072\073\018\006\126\073\105\006\054\072\105\126\073\018\006\054\018\073\102\103\115\073\109\113\001\001\073\003\126\073\126\005\041\103\051\126\028\073\018\103\073\090\054\003\113\126\051\073\059\090\103\117\073\054\073\003\054\018\073\003\113\018\126\096"), 
			Buttons = {
				_oP2wy("\114\103\109")
			}
		}
	end
end
function _A34Gi:OnEnter()
	Wherigo.PlayAudio(_IqwO)
	if _nGr.Complete == true then
		_Urwigo.MessageBox{
			Text = _oP2wy("\058\103\115\073\006\054\094\126\073\054\001\090\126\054\028\102\073\003\126\126\072\073\006\126\090\126\020\073\102\103\115\073\051\006\103\115\001\028\073\018\090\102\073\054\072\028\073\094\113\051\113\018\073\103\018\006\126\090\073\001\103\105\054\018\113\103\072\051\096")
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\104\073\117\113\028\073\089\093\064\064\051\073\059\054\090\117\073\051\113\018\126\073\054\072\028\073\028\115\117\041\073\109\054\051\073\001\103\105\054\018\126\028\073\006\126\090\126\096\073\097\038\026\034\097\038\026\034\104\090\018\113\059\054\105\018\051\073\059\090\103\117\073\018\006\126\073\059\054\090\117\073\054\090\126\073\103\072\073\028\113\051\041\001\054\102\073\113\072\073\018\006\126\073\042\126\072\018\126\090\096"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_UVRu)
					end)
				end
			end
		}
	end
end
function _A34Gi:OnExit()
	if _nGr.Complete == true then
		_A34Gi.Active = false
		_A34Gi.Visible = false
	end
end
function _l9WM:OnEnter()
	Wherigo.PlayAudio(_cKDC)
	_Urwigo.MessageBox{
		Text = _oP2wy("\075\113\028\073\102\103\115\073\012\072\103\109\073\018\006\054\018\073\053\115\090\012\126\102\073\055\115\001\018\115\090\126\051\073\006\054\094\126\073\054\073\003\103\028\102\073\018\126\117\041\126\090\054\018\115\090\126\073\103\059\073\089\064\007\073\028\126\065\090\126\126\051\107\073\097\038\026\034\097\038\026\034\063\018\073\113\051\073\051\103\073\109\054\090\117\073\003\126\105\054\115\051\126\073\018\006\126\073\059\103\103\028\073\018\006\126\102\073\126\054\018\073\059\090\103\117\073\028\126\054\028\073\054\072\113\117\054\001\051\073\113\051\073\103\059\018\126\072\073\059\115\001\001\073\103\059\073\003\054\105\018\126\090\113\054\073\054\072\028\073\018\006\126\102\073\072\126\126\028\073\018\006\126\073\006\113\065\006\126\090\073\018\126\117\041\126\090\054\018\115\090\126\051\073\018\103\073\012\113\001\001\073\103\059\059\073\018\006\126\073\003\054\105\018\126\090\113\054\096\073\097\038\026\034\097\038\026\034\104\072\028\073\028\113\028\073\102\103\115\073\054\001\051\103\073\012\072\103\109\073\018\006\054\018\073\054\073\065\090\103\115\041\073\103\059\073\053\115\090\012\126\102\073\055\115\001\018\115\090\126\051\073\113\051\073\065\054\001\001\126\028\073\054\073\095\126\018\018\001\126\107\073\097\038\026\034\097\038\026\034\098\126\090\126\073\054\018\073\114\113\105\012\113\115\041\073\109\126\073\001\113\012\126\073\018\103\073\018\126\001\001\073\041\126\103\041\001\126\073\018\103\073\001\103\103\012\073\115\041\073\113\072\073\018\006\126\073\051\012\102\073\054\072\028\073\051\126\126\073\018\006\126\073\095\126\018\018\001\126\073\103\059\073\053\055\051\096\073\071\072\003\051\041\092\097\038\026\034"), 
		Buttons = {
			_oP2wy("\114\103\109")
		}
	}
end
function _9VRdD:OnEnter()
	Wherigo.PlayAudio(_5QEQf)
	_Urwigo.MessageBox{
		Text = _oP2wy("\063\018\073\113\051\073\094\126\090\102\073\090\054\090\126\073\003\115\018\073\117\103\115\072\018\054\113\072\073\001\113\103\072\051\073\006\054\094\126\073\003\126\126\072\073\051\126\126\072\073\113\072\073\063\103\109\054\096\073\097\038\026\034\097\038\026\034\053\006\126\051\126\073\054\090\126\073\103\059\018\126\072\073\117\054\001\126\073\117\103\115\072\018\054\113\072\073\001\113\103\072\051\073\001\103\103\012\113\072\065\073\059\103\090\073\059\103\103\028\073\054\072\028\073\018\006\126\102\073\054\090\126\073\072\103\018\073\072\103\090\117\054\001\073\113\072\006\054\003\113\018\054\072\018\051\073\103\059\073\018\006\113\051\073\054\090\126\054\096\073\053\006\126\102\073\059\126\126\028\073\103\072\073\018\006\126\073\109\006\113\018\126\073\018\054\113\001\073\028\126\126\090\073\018\006\054\018\073\054\090\126\073\054\001\001\073\054\090\103\115\072\028\073\018\006\113\051\073\054\090\126\054\096\073\097\038\026\034\097\038\026\034\063\059\073\102\103\115\073\126\072\105\103\115\072\018\126\090\073\054\073\117\103\115\072\018\054\113\072\073\001\113\103\072\073\102\103\115\073\051\006\103\115\001\028\073\050\111\053\073\090\115\072\073\054\109\054\102\020\073\018\006\126\102\073\109\113\001\001\073\018\006\113\072\012\073\102\103\115\073\054\090\126\073\041\090\126\102\073\054\072\028\073\105\103\117\126\073\054\059\018\126\090\073\102\103\115\096\073\063\072\051\018\126\054\028\073\102\103\115\073\051\006\103\115\001\028\073\018\090\102\073\054\072\028\073\117\054\012\126\073\102\103\115\090\051\126\001\059\073\001\103\103\012\073\054\051\073\003\113\065\073\054\051\073\041\103\051\051\113\003\001\126\073\003\102\073\109\054\094\113\072\065\073\102\103\115\090\073\054\090\117\051\073\054\072\028\073\041\103\051\051\113\003\001\102\073\018\054\012\126\073\103\059\059\073\102\103\115\090\073\080\054\105\012\126\018\073\054\072\028\073\018\006\126\072\073\051\001\103\109\001\102\073\109\054\001\012\073\054\109\054\102\096\073\071\072\003\051\041\092"), 
		Buttons = {
			_oP2wy("\114\103\109")
		}
	}
end
function _rIdqk:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_hIN = input
	if Wherigo.NoCaseEquals(_hIN, _oP2wy("\072\103")) then
		Wherigo.PlayAudio(_EUKN)
		_Urwigo.MessageBox{
			Text = _oP2wy("\042\103\090\090\126\105\018\023\097\038\026\034\097\038\026\034\111\072\105\126\073\018\006\126\102\073\054\090\126\073\054\028\115\001\018\073\059\090\103\065\051\073\054\072\028\073\072\103\073\001\103\072\065\126\090\073\018\054\028\041\103\001\126\051\020\073\059\090\103\065\051\073\001\103\051\126\073\018\006\126\113\090\073\065\113\001\001\051\073\054\072\028\073\113\072\051\018\126\054\028\073\115\051\126\073\105\054\117\103\115\059\001\054\065\126\073\018\103\073\090\126\117\054\113\072\073\054\001\117\103\051\018\073\126\072\018\113\090\126\001\102\073\115\072\028\126\090\109\054\018\126\090\073\109\006\113\001\051\018\073\018\006\126\113\090\073\072\103\051\018\090\113\001\051\073\003\090\126\054\018\006\126\073\080\115\051\018\073\054\003\103\094\126\073\018\006\126\073\051\115\090\059\054\105\126\096\097\038\026\034\097\038\026\034\063\072\073\054\028\028\113\018\113\103\072\020\073\059\090\103\065\051\073\105\054\072\073\054\003\051\103\090\003\073\103\005\102\065\126\072\073\051\001\103\109\001\102\073\018\006\090\103\115\065\006\073\018\006\126\113\090\073\051\012\113\072\020\073\109\006\113\105\006\073\054\001\001\103\109\051\073\018\006\126\117\073\018\103\073\090\126\117\054\113\072\073\115\072\028\126\090\109\054\018\126\090\073\109\006\113\001\051\018\073\006\113\003\126\090\072\054\018\113\072\065\096"), 
			Callback = function(action)
				if action ~= nil then
					_hBkXG.Complete = true
					if ((((_JIEha.Complete and _hBkXG.Complete) and _MAf.Complete) and _KNWZ.Complete) and _btWb.Complete) and _nGr.Complete then
						_EBwn0.Visible = true
						_EBwn0:MoveTo(Player)
						_Urwigo.MessageBox{
							Text = _oP2wy("\042\103\072\065\090\054\018\115\001\054\018\113\103\072\051\023\097\038\026\034\097\038\026\034\058\103\115\073\006\054\094\126\073\028\103\072\126\073\054\073\059\113\072\028\073\080\103\003\073\126\005\041\001\103\090\113\072\065\073\018\006\126\073\109\103\072\028\126\090\059\115\001\073\051\113\018\126\051\073\018\006\054\018\073\114\113\105\012\113\115\041\073\006\054\051\073\018\103\073\103\059\059\126\090\096\073\097\038\026\034\097\038\026\034\122\001\126\054\051\126\073\018\054\012\126\073\018\006\126\051\126\073\105\103\103\090\028\072\054\018\126\051\073\054\072\028\073\059\113\072\113\051\006\073\018\006\113\051\073\054\028\094\126\072\018\115\090\126\073\003\102\073\028\113\051\105\103\094\126\090\113\072\065\073\054\073\018\090\126\054\051\115\090\126\073\105\006\126\051\018\073\059\115\001\001\073\103\059\073\113\018\126\117\051\073\059\103\090\073\102\103\115\090\073\018\090\054\028\113\072\065\073\041\001\126\054\051\115\090\126\096"), 
							Buttons = {
								_oP2wy("\058\104\023")
							}
						}
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\047\103\090\090\102\073\018\090\102\073\054\065\054\113\072\096\097\038\026\034\097\038\026\034\058\103\115\073\109\113\001\001\073\072\126\126\028\073\018\103\073\001\126\054\094\126\073\018\006\113\051\073\054\090\126\054\073\054\072\028\073\105\103\117\126\073\003\054\105\012\073\003\126\105\054\115\051\126\073\102\103\115\073\072\126\126\028\073\018\103\073\001\126\054\090\072\073\117\103\090\126\073\054\003\103\115\018\073\072\054\018\115\090\126\096\073")
		}
	end
end
function _DDWa1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_zp2MZ = input
	if Wherigo.NoCaseEquals(_zp2MZ, tostring(false)) then
		Wherigo.PlayAudio(_EUKN)
		_Urwigo.MessageBox{
			Text = _oP2wy("\024\054\001\051\126\073\113\051\073\042\103\090\090\126\105\018\023\097\038\026\034\097\038\026\034\053\126\117\041\126\090\054\018\115\090\126\073\113\051\073\018\006\126\073\028\126\105\113\028\113\072\065\073\059\054\105\018\103\090\096\073\053\006\126\073\018\006\126\090\117\103\110\051\126\072\051\113\018\113\094\126\073\041\126\090\113\103\028\073\103\105\105\115\090\051\073\054\059\018\126\090\073\018\006\126\073\126\065\065\073\006\054\051\073\003\126\126\072\073\001\054\113\028\020\073\051\103\073\051\126\005\073\028\126\018\126\090\117\113\072\054\018\113\103\072\073\113\072\073\090\126\041\018\113\001\126\051\073\113\051\073\054\018\073\018\006\126\073\117\126\090\105\102\073\103\059\073\018\006\126\073\054\117\003\113\126\072\018\073\105\103\072\028\113\018\113\103\072\051\073\054\059\059\126\105\018\113\072\065\073\126\065\065\073\105\001\115\018\105\006\126\051\073\113\072\073\018\006\126\073\072\126\051\018\096\073\024\103\090\073\126\005\054\117\041\001\126\020\073\113\072\073\117\054\072\102\073\018\115\090\018\001\126\073\051\041\126\105\113\126\051\020\073\126\065\065\051\073\059\090\103\117\073\105\103\103\001\126\090\073\072\126\051\018\051\073\006\054\018\105\006\073\054\051\073\054\001\001\073\117\054\001\126\051\020\073\054\072\028\073\126\065\065\051\073\059\090\103\117\073\109\054\090\117\126\090\073\072\126\051\018\051\073\006\054\018\105\006\073\054\051\073\054\001\001\073\059\126\117\054\001\126\051\096"), 
			Callback = function(action)
				if action ~= nil then
					_JIEha.Complete = true
					if ((((_JIEha.Complete and _hBkXG.Complete) and _MAf.Complete) and _KNWZ.Complete) and _btWb.Complete) and _nGr.Complete then
						_EBwn0.Visible = true
						_EBwn0:MoveTo(Player)
						_Urwigo.MessageBox{
							Text = _oP2wy("\042\103\072\065\090\054\018\115\001\054\018\113\103\072\051\023\097\038\026\034\097\038\026\034\058\103\115\073\006\054\094\126\073\028\103\072\126\073\054\073\059\113\072\028\073\080\103\003\073\126\005\041\001\103\090\113\072\065\073\018\006\126\073\109\103\072\028\126\090\059\115\001\073\051\113\018\126\051\073\018\006\054\018\073\114\113\105\012\113\115\041\073\006\054\051\073\018\103\073\103\059\059\126\090\096\073\097\038\026\034\097\038\026\034\122\001\126\054\051\126\073\018\054\012\126\073\018\006\126\051\126\073\105\103\103\090\028\072\054\018\126\051\073\054\072\028\073\059\113\072\113\051\006\073\018\006\113\051\073\054\028\094\126\072\018\115\090\126\073\003\102\073\028\113\051\105\103\094\126\090\113\072\065\073\054\073\018\090\126\054\051\115\090\126\073\105\006\126\051\018\073\059\115\001\001\073\103\059\073\113\018\126\117\051\073\059\103\090\073\102\103\115\090\073\018\090\054\028\113\072\065\073\041\001\126\054\051\115\090\126\096"), 
							Buttons = {
								_oP2wy("\058\104\023")
							}
						}
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\047\103\090\090\102\073\018\090\102\073\054\065\054\113\072\096\097\038\026\034\097\038\026\034\058\103\115\073\109\113\001\001\073\072\126\126\028\073\018\103\073\001\126\054\094\126\073\018\006\113\051\073\054\090\126\054\073\054\072\028\073\105\103\117\126\073\003\054\105\012\073\003\126\105\054\115\051\126\073\102\103\115\073\072\126\126\028\073\018\103\073\001\126\054\090\072\073\117\103\090\126\073\054\003\103\115\018\073\072\054\018\115\090\126\096\073")
		}
	end
end
function _9ZIGO:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_t78 = input
	if Wherigo.NoCaseEquals(_t78, _oP2wy("\018\090\115\126")) then
		Wherigo.PlayAudio(_EUKN)
		_Urwigo.MessageBox{
			Text = _oP2wy("\053\090\115\126\023\073\097\038\026\034\097\038\026\034\111\012\020\073\051\103\073\117\054\102\003\126\073\072\103\018\073\053\098\052\073\114\103\103\028\102\073\018\006\126\073\114\103\103\028\041\126\105\012\126\090\073\003\115\018\073\018\006\126\073\065\090\126\054\018\073\122\113\001\126\054\018\126\028\073\114\103\103\028\041\126\105\012\126\090\073\028\103\126\051\023\073\097\038\026\034\097\038\026\034\053\006\126\073\051\018\103\090\102\073\065\103\126\051\020\073\018\006\054\018\073\114\103\103\028\102\073\018\006\126\073\114\103\103\028\041\126\105\012\126\090\020\073\018\006\126\073\105\054\090\018\103\103\072\073\105\006\054\090\054\105\018\126\090\020\073\109\054\051\073\105\090\126\054\018\126\028\073\054\059\018\126\090\073\018\006\126\073\090\126\054\001\110\001\113\059\126\073\122\113\001\126\054\018\126\028\096\073\038\115\018\073\003\103\018\006\073\103\059\073\018\006\126\117\073\006\054\094\126\073\018\006\126\073\051\054\117\126\073\103\003\072\103\005\113\103\115\051\073\001\054\115\065\006\096\073\071\072\003\051\041\092\097\038\026\034\097\038\026\034\042\054\072\073\102\103\115\073\117\054\012\126\073\018\006\126\073\051\054\117\126\073\051\103\115\072\028\107"), 
			Callback = function(action)
				if action ~= nil then
					_MAf.Complete = true
					if ((((_JIEha.Complete and _hBkXG.Complete) and _MAf.Complete) and _KNWZ.Complete) and _btWb.Complete) and _nGr.Complete then
						_EBwn0.Visible = true
						_EBwn0:MoveTo(Player)
						_Urwigo.MessageBox{
							Text = _oP2wy("\042\103\072\065\090\054\018\115\001\054\018\113\103\072\051\023\097\038\026\034\097\038\026\034\058\103\115\073\006\054\094\126\073\028\103\072\126\073\054\073\059\113\072\028\073\080\103\003\073\126\005\041\001\103\090\113\072\065\073\018\006\126\073\109\103\072\028\126\090\059\115\001\073\051\113\018\126\051\073\018\006\054\018\073\114\113\105\012\113\115\041\073\006\054\051\073\018\103\073\103\059\059\126\090\096\073\097\038\026\034\097\038\026\034\122\001\126\054\051\126\073\018\054\012\126\073\018\006\126\051\126\073\105\103\103\090\028\072\054\018\126\051\073\054\072\028\073\059\113\072\113\051\006\073\018\006\113\051\073\054\028\094\126\072\018\115\090\126\073\003\102\073\028\113\051\105\103\094\126\090\113\072\065\073\054\073\018\090\126\054\051\115\090\126\073\105\006\126\051\018\073\059\115\001\001\073\103\059\073\113\018\126\117\051\073\059\103\090\073\102\103\115\090\073\018\090\054\028\113\072\065\073\041\001\126\054\051\115\090\126\096"), 
							Buttons = {
								_oP2wy("\058\104\023")
							}
						}
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\047\103\090\090\102\073\018\090\102\073\054\065\054\113\072\096\097\038\026\034\097\038\026\034\058\103\115\073\109\113\001\001\073\072\126\126\028\073\018\103\073\001\126\054\094\126\073\018\006\113\051\073\054\090\126\054\073\054\072\028\073\105\103\117\126\073\003\054\105\012\073\003\126\105\054\115\051\126\073\102\103\115\073\072\126\126\028\073\018\103\073\001\126\054\090\072\073\117\103\090\126\073\054\003\103\115\018\073\072\054\018\115\090\126\096\073")
		}
	end
end
function _eJj:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_n4L = input
	if Wherigo.NoCaseEquals(_n4L, _oP2wy("\018\090\115\126")) then
		Wherigo.PlayAudio(_EUKN)
		_Urwigo.MessageBox{
			Text = _oP2wy("\053\090\115\126\023\097\038\026\034\097\038\026\034\114\113\105\012\113\115\041\051\073\109\126\090\126\073\051\018\090\115\105\018\115\090\126\051\073\115\051\126\028\073\028\115\090\113\072\065\073\018\006\126\073\114\103\103\028\001\054\072\028\073\041\126\090\113\103\028\020\073\103\094\126\090\073\018\006\103\115\051\054\072\028\073\102\126\054\090\051\073\054\065\103\096\073\053\006\126\073\109\113\105\012\113\115\041\051\073\059\090\054\117\126\073\113\051\073\117\054\028\126\073\059\090\103\117\073\102\103\115\072\065\073\018\090\126\126\051\073\028\090\113\094\126\072\073\113\072\018\103\073\018\006\126\073\065\090\103\115\072\028\073\054\072\028\073\054\090\090\054\072\065\126\028\073\113\072\073\054\073\105\113\090\105\001\126\073\103\090\073\103\094\054\001\096\073\071\072\003\051\041\092\097\038\026\034\097\038\026\034\053\006\126\073\051\054\041\001\113\072\065\051\073\109\126\090\126\073\003\126\072\018\073\018\103\073\018\006\126\073\105\126\072\018\126\090\073\054\072\028\073\018\113\126\028\073\018\103\065\126\018\006\126\090\096\073\071\072\003\051\041\092\053\006\126\073\059\090\054\117\126\073\109\054\051\073\105\103\094\126\090\126\028\073\109\113\018\006\073\109\103\094\126\072\073\105\054\018\018\054\113\001\051\073\103\090\073\051\006\126\126\018\051\073\103\059\073\003\054\090\012\096\073\071\072\003\051\041\092\053\006\126\073\109\103\090\028\073\109\113\105\012\113\115\041\073\113\051\073\018\006\126\073\091\126\051\012\109\054\012\113\073\109\103\090\028\073\059\103\090\073\109\113\072\018\126\090\073\028\109\126\001\001\113\072\065\096\073\097\038\026\034\097\038\026\034\047\126\126\073\054\073\090\126\041\001\113\105\054\073\109\113\105\012\113\115\041\073\113\072\051\113\028\126\073\018\006\126\073\042\126\072\018\126\090\073\015\038\115\113\001\028\113\072\065\022\096"), 
			Callback = function(action)
				if action ~= nil then
					_KNWZ.Complete = true
					if ((((_JIEha.Complete and _hBkXG.Complete) and _KNWZ.Complete) and _MAf.Complete) and _btWb.Complete) and _nGr.Complete then
						_EBwn0.Visible = true
						_EBwn0:MoveTo(Player)
						_Urwigo.MessageBox{
							Text = _oP2wy("\042\103\072\065\090\054\018\115\001\054\018\113\103\072\051\023\097\038\026\034\097\038\026\034\058\103\115\073\006\054\094\126\073\028\103\072\126\073\054\073\059\113\072\028\073\080\103\003\073\126\005\041\001\103\090\113\072\065\073\018\006\126\073\109\103\072\028\126\090\059\115\001\073\051\113\018\126\051\073\018\006\054\018\073\114\113\105\012\113\115\041\073\006\054\051\073\018\103\073\103\059\059\126\090\096\073\097\038\026\034\097\038\026\034\122\001\126\054\051\126\073\018\054\012\126\073\018\006\126\051\126\073\105\103\103\090\028\072\054\018\126\051\073\054\072\028\073\059\113\072\113\051\006\073\018\006\113\051\073\054\028\094\126\072\018\115\090\126\073\003\102\073\028\113\051\105\103\094\126\090\113\072\065\073\054\073\018\090\126\054\051\115\090\126\073\105\006\126\051\018\073\059\115\001\001\073\103\059\073\113\018\126\117\051\073\059\103\090\073\102\103\115\090\073\018\090\054\028\113\072\065\073\041\001\126\054\051\115\090\126\096"), 
							Buttons = {
								_oP2wy("\058\104\023")
							}
						}
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\047\103\090\090\102\073\018\090\102\073\054\065\054\113\072\096\097\038\026\034\097\038\026\034\058\103\115\073\109\113\001\001\073\072\126\126\028\073\018\103\073\001\126\054\094\126\073\018\006\113\051\073\054\090\126\054\073\054\072\028\073\105\103\117\126\073\003\054\105\012\073\003\126\105\054\115\051\126\073\102\103\115\073\072\126\126\028\073\018\103\073\001\126\054\090\072\073\117\103\090\126\073\054\003\103\115\018\073\072\054\018\115\090\126\096\073")
		}
	end
end
function _UpZ1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_qDEO = input
	if Wherigo.NoCaseEquals(_qDEO, _oP2wy("\059\054\001\051\126")) then
		Wherigo.PlayAudio(_EUKN)
		_Urwigo.MessageBox{
			Text = _oP2wy("\024\054\001\051\126\073\113\051\073\042\103\090\090\126\105\018\023\097\038\026\034\097\038\026\034\114\006\113\001\126\073\117\103\051\018\073\063\103\109\054\073\003\054\018\051\073\117\113\065\090\054\018\126\073\051\103\115\018\006\073\113\072\073\018\006\126\073\059\054\001\001\020\073\083\073\103\115\018\073\103\059\073\018\006\126\073\093\073\003\054\018\073\051\041\126\105\113\126\051\073\051\041\126\072\028\073\018\006\126\073\109\113\072\018\126\090\073\006\113\003\126\090\072\054\018\113\072\065\073\113\072\073\105\054\094\126\051\073\015\041\054\090\018\113\105\115\001\054\090\001\102\073\113\072\073\126\054\051\018\126\090\072\073\063\103\109\054\022\096\073\053\006\126\073\038\113\065\073\038\090\103\109\072\073\038\054\018\073\113\051\073\018\006\126\073\103\072\001\102\073\063\103\109\054\073\003\054\018\073\018\006\054\018\073\051\103\117\126\018\113\117\126\051\073\113\051\073\059\103\115\072\028\073\006\113\003\126\090\072\054\018\113\072\065\073\113\072\073\006\126\054\018\126\028\073\003\115\113\001\028\113\072\065\051\020\073\054\072\028\073\072\103\073\003\054\018\051\073\105\054\072\073\051\115\090\094\113\094\126\073\113\072\073\041\001\054\105\126\051\073\018\006\054\018\073\090\103\115\018\113\072\126\001\102\073\090\126\054\105\006\073\018\126\117\041\126\090\054\018\115\090\126\051\073\003\126\001\103\109\073\059\090\126\126\010\113\072\065\096\097\038\026\034\097\038\026\034\063\103\109\054\051\073\003\054\018\051\073\054\090\126\073\054\001\001\073\113\072\051\126\105\018\073\126\054\018\126\090\051\096\073\053\006\126\073\078\113\018\018\001\126\073\038\090\103\109\072\073\038\054\018\020\073\113\072\073\041\054\090\018\113\105\115\001\054\090\020\073\105\054\072\073\126\054\018\073\054\003\103\115\018\073\089\020\040\064\064\073\051\117\054\001\001\073\113\072\051\126\105\018\051\073\015\113\072\105\001\115\028\113\072\065\073\117\103\051\106\115\113\018\103\126\051\022\073\113\072\073\054\072\073\006\103\115\090\096\073\071\072\003\051\041\092\091\103\051\018\073\003\054\018\051\073\105\054\018\105\006\073\113\072\051\126\105\018\051\073\115\051\113\072\065\073\018\006\126\113\090\073\109\113\072\065\096\073\052\094\126\072\073\018\006\103\115\065\006\073\018\006\126\102\073\105\054\072\073\051\126\126\073\109\126\001\001\020\073\113\018\073\113\051\073\018\006\126\113\090\073\051\126\072\051\126\073\103\059\073\006\126\054\090\113\072\065\073\018\006\054\018\073\113\051\073\117\103\051\018\073\028\126\094\126\001\103\041\126\028\073\054\072\028\073\054\001\001\103\109\051\073\018\006\126\117\073\018\103\073\105\054\018\105\006\073\041\090\126\102\073\113\072\073\018\103\018\054\001\073\028\054\090\012\072\126\051\051\096\073\071\072\003\051\041\092\047\115\090\041\090\113\051\113\072\065\001\102\020\073\078\113\018\018\001\126\073\038\090\103\109\072\073\038\054\018\051\073\105\054\072\073\051\103\117\126\018\113\117\126\051\073\003\126\073\001\103\072\065\110\001\113\094\126\028\020\073\090\126\054\105\006\113\072\065\073\054\072\073\054\065\126\073\103\059\073\112\083\073\102\126\054\090\051\096\073\071\072\003\051\041\092\053\006\126\090\126\073\054\090\126\073\093\073\028\113\059\059\126\090\126\072\018\073\012\113\072\028\051\073\103\059\073\003\054\018\051\073\018\006\054\018\073\001\113\094\126\073\113\072\073\063\103\109\054\096\097\038\026\034"), 
			Callback = function(action)
				if action ~= nil then
					_btWb.Complete = true
					if ((((_JIEha.Complete and _hBkXG.Complete) and _MAf.Complete) and _KNWZ.Complete) and _btWb.Complete) and _nGr.Complete then
						_EBwn0.Visible = true
						_EBwn0:MoveTo(Player)
						_Urwigo.MessageBox{
							Text = _oP2wy("\042\103\072\065\090\054\018\115\001\054\018\113\103\072\051\023\097\038\026\034\097\038\026\034\058\103\115\073\006\054\094\126\073\028\103\072\126\073\054\073\059\113\072\028\073\080\103\003\073\126\005\041\001\103\090\113\072\065\073\018\006\126\073\109\103\072\028\126\090\059\115\001\073\051\113\018\126\051\073\018\006\054\018\073\114\113\105\012\113\115\041\073\006\054\051\073\018\103\073\103\059\059\126\090\096\073\097\038\026\034\097\038\026\034\122\001\126\054\051\126\073\018\054\012\126\073\018\006\126\051\126\073\105\103\103\090\028\072\054\018\126\051\073\054\072\028\073\059\113\072\113\051\006\073\018\006\113\051\073\054\028\094\126\072\018\115\090\126\073\003\102\073\028\113\051\105\103\094\126\090\113\072\065\073\054\073\018\090\126\054\051\115\090\126\073\105\006\126\051\018\073\059\115\001\001\073\103\059\073\113\018\126\117\051\073\059\103\090\073\102\103\115\090\073\018\090\054\028\113\072\065\073\041\001\126\054\051\115\090\126\096"), 
							Buttons = {
								_oP2wy("\058\104\023")
							}
						}
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\047\103\090\090\102\073\018\090\102\073\054\065\054\113\072\096\097\038\026\034\097\038\026\034\058\103\115\073\109\113\001\001\073\072\126\126\028\073\018\103\073\001\126\054\094\126\073\018\006\113\051\073\054\090\126\054\073\054\072\028\073\105\103\117\126\073\003\054\105\012\073\003\126\105\054\115\051\126\073\102\103\115\073\072\126\126\028\073\018\103\073\001\126\054\090\072\073\117\103\090\126\073\054\003\103\115\018\073\072\054\018\115\090\126\096\073")
		}
	end
end
function _UVRu:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_4jfhz = input
	if Wherigo.NoCaseEquals(_4jfhz, _oP2wy("\058\126\051")) then
		Wherigo.PlayAudio(_EUKN)
		_Urwigo.MessageBox{
			Text = _oP2wy("\042\103\090\090\126\105\018\023\097\038\026\034\097\038\026\034\053\006\126\090\126\073\113\051\073\054\073\041\103\041\115\001\054\090\073\117\113\051\105\103\072\105\126\041\018\113\103\072\073\018\006\054\018\073\006\115\117\117\113\072\065\003\113\090\028\051\073\028\103\072\018\073\006\054\094\126\073\059\126\126\018\096\073\063\018\073\113\051\020\073\103\059\073\105\103\115\090\051\126\020\073\109\090\103\072\065\096\073\097\038\026\034\097\038\026\034\098\115\117\117\113\072\065\003\113\090\028\051\073\028\103\072\107\018\073\109\054\001\012\073\003\115\018\073\109\006\113\001\126\073\018\006\126\102\073\028\103\073\006\054\094\126\073\059\126\126\018\020\073\018\006\126\102\073\028\103\072\018\073\115\051\126\073\018\006\126\117\073\018\103\073\109\054\001\012\073\003\126\105\054\115\051\126\073\018\006\126\102\073\054\090\126\073\051\103\073\041\103\103\090\001\102\073\028\126\094\126\001\103\041\126\028\092\073\018\006\113\051\073\113\051\073\028\115\126\073\018\103\073\018\006\126\073\059\054\105\018\073\018\006\054\018\073\018\006\126\102\073\051\041\126\072\028\073\117\103\051\018\073\103\059\073\018\006\126\113\090\073\018\113\117\126\073\113\072\073\059\001\113\065\006\018\073\054\072\028\073\051\126\001\028\103\117\073\072\126\126\028\073\018\103\073\109\054\001\012\096\073\097\038\026\034\097\038\026\034\098\115\117\117\113\072\065\003\113\090\028\051\073\054\001\051\103\073\006\054\094\126\073\054\072\073\113\072\105\090\126\028\113\003\001\102\073\059\054\051\018\073\117\126\018\054\003\103\001\113\051\117\073\109\006\113\105\006\073\117\126\054\072\051\073\018\006\126\102\073\054\090\126\073\054\001\109\054\102\051\073\080\115\051\018\073\054\073\059\126\109\073\006\103\115\090\051\073\054\109\054\102\073\059\090\103\117\073\051\018\054\090\094\054\018\113\103\072\096"), 
			Callback = function(action)
				if action ~= nil then
					_nGr.Complete = true
					if ((((_JIEha.Complete and _hBkXG.Complete) and _MAf.Complete) and _KNWZ.Complete) and _btWb.Complete) and _nGr.Complete then
						_EBwn0.Visible = true
						_EBwn0:MoveTo(Player)
						_Urwigo.MessageBox{
							Text = _oP2wy("\042\103\072\065\090\054\018\115\001\054\018\113\103\072\051\023\097\038\026\034\097\038\026\034\058\103\115\073\006\054\094\126\073\028\103\072\126\073\054\073\059\113\072\028\073\080\103\003\073\126\005\041\001\103\090\113\072\065\073\018\006\126\073\109\103\072\028\126\090\059\115\001\073\051\113\018\126\051\073\018\006\054\018\073\114\113\105\012\113\115\041\073\006\054\051\073\018\103\073\103\059\059\126\090\096\073\097\038\026\034\097\038\026\034\122\001\126\054\051\126\073\018\054\012\126\073\018\006\126\051\126\073\105\103\103\090\028\072\054\018\126\051\073\054\072\028\073\059\113\072\113\051\006\073\018\006\113\051\073\054\028\094\126\072\018\115\090\126\073\003\102\073\028\113\051\105\103\094\126\090\113\072\065\073\054\073\018\090\126\054\051\115\090\126\073\105\006\126\051\018\073\059\115\001\001\073\103\059\073\113\018\126\117\051\073\059\103\090\073\102\103\115\090\073\018\090\054\028\113\072\065\073\041\001\126\054\051\115\090\126\096"), 
							Buttons = {
								_oP2wy("\058\104\023")
							}
						}
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _oP2wy("\047\103\090\090\102\073\018\090\102\073\054\065\054\113\072\096\097\038\026\034\097\038\026\034\058\103\115\073\109\113\001\001\073\072\126\126\028\073\018\103\073\001\126\054\094\126\073\018\006\113\051\073\054\090\126\054\073\054\072\028\073\105\103\117\126\073\003\054\105\012\073\003\126\105\054\115\051\126\073\102\103\115\073\072\126\126\028\073\018\103\073\001\126\054\090\072\073\117\103\090\126\073\054\003\103\115\018\073\072\054\018\115\090\126\096\073")
		}
	end
end
function __aAh2:On_yyh(target)
	_Urwigo.MessageBox{
		Text = _oP2wy("\122\001\126\054\051\126\073\001\103\103\012\073\054\090\103\115\072\028\073\054\072\028\073\102\103\115\073\109\113\001\001\073\051\126\126\073\001\103\018\051\073\103\059\073\109\103\072\028\126\090\059\115\001\073\018\006\113\072\065\051\096")
	}
end
function _KHR:On_zu_(target)
	_Urwigo.MessageBox{
		Text = _oP2wy("\063\018\073\113\051\073\072\103\018\073\113\072\073\006\126\090\126\073\001\103\103\012\073\054\090\103\115\072\028\073\102\103\115\020\073\113\018\073\113\051\073\126\094\126\090\102\109\006\126\090\126\096\073")
	}
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _BZTb
