require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _PkY(str)
	local res = ""
    local dtable = "\034\090\055\030\096\094\022\050\017\105\107\002\085\074\106\068\008\083\020\071\089\095\087\098\102\018\101\049\047\021\119\060\031\019\046\092\086\125\024\063\039\080\010\048\109\126\011\113\036\118\056\051\081\122\091\043\123\005\053\004\014\114\082\059\124\103\033\115\038\016\035\116\065\064\042\061\052\045\097\040\104\023\093\013\026\088\076\025\067\057\117\015\072\028\012\009\037\120\100\111\075\099\054\044\084\029\112\027\041\001\108\066\077\032\069\000\003\073\006\110\070\062\079\007\058\078\121"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_YdGE4 = Wherigo.ZCartridge()

-- Media --
_QV434 = Wherigo.ZMedia(_YdGE4)
_QV434.Id = "685bba27-a7a5-480b-b737-90b26d1c9085"
_QV434.Name = _PkY("\115\072\079\107\027")
_QV434.Description = _PkY("\042\081\100\072\100\114\099\027\114\111\041\079\102\072\091\027\111\114\062\027\068\072\079\091\062\079\120\072\114\087\041\115\072\079\066\027\104\114\063\027\068\027\062\050\027\114\025\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\035")
_QV434.AltText = ""
_QV434.Resources = {
	{
		Type = "jpg", 
		Filename = "Photo_Etape.jpg", 
		Directives = {}
	}
}
_50eiy = Wherigo.ZMedia(_YdGE4)
_50eiy.Id = "0fb50309-2a28-4b79-a1bb-c22c40fee7fe"
_50eiy.Name = _PkY("\113\100\100\068\091\068\114\089\091\010\068\010\120\010\027\062")
_50eiy.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\010\079\111\114\048\091\010\114\025\079\010\072\114\111\079\114\024\100\091\025\025\027\114\079\114\087\041\115\072\079\107\027")
_50eiy.AltText = ""
_50eiy.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus_Cuisinier.jpg", 
		Directives = {}
	}
}
_Xikb = Wherigo.ZMedia(_YdGE4)
_Xikb.Id = "e157e6de-ed6c-4ded-a279-3dbcbe1c60de"
_Xikb.Name = _PkY("\113\100\100\068\091\068\114\042\100\111\010\102\010\027\062")
_Xikb.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\079\111\114\048\091\010\114\102\100\120\072\062\100\111\027\114\111\079\114\102\010\062\102\091\111\079\072\010\100\120\114\099\079\120\068\114\111\027\114\042\079\062\102\035")
_Xikb.AltText = ""
_Xikb.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus_Policier.jpg", 
		Directives = {}
	}
}
_bNLS = Wherigo.ZMedia(_YdGE4)
_bNLS.Id = "6af1914e-35fc-41ed-8b8f-48c0117623b5"
_bNLS.Name = _PkY("\113\100\100\068\091\068\114\121\062\010\111\027\091\098")
_bNLS.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\079\111\114\048\091\010\114\066\027\111\027\114\111\100\062\068\048\091\041\010\111\114\027\068\072\114\027\120\114\107\079\120\120\027\035")
_bNLS.AltText = ""
_bNLS.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus_frileux.jpg", 
		Directives = {}
	}
}
_JymaI = Wherigo.ZMedia(_YdGE4)
_JymaI.Id = "c16a1cb9-9e8f-4297-bd2b-8a74edb70b76"
_JymaI.Name = _PkY("\093\027\024\027\062\072\050\010\111\111\027")
_JymaI.Description = _PkY("\013\120\027\114\107\081\100\072\100\114\099\091\114\050\010\111\111\079\066\027\114\099\041\093\027\024\027\062\072\050\010\111\111\027\114\072\062\027\068\114\062\027\107\062\027\068\027\120\072\079\072\010\050\027\035")
_JymaI.AltText = ""
_JymaI.Resources = {
	{
		Type = "jpg", 
		Filename = "Hebertville.jpg", 
		Directives = {}
	}
}
_u7Di = Wherigo.ZMedia(_YdGE4)
_u7Di.Id = "ae018cfd-4f31-4094-ab82-0332ed0bc79a"
_u7Di.Name = _PkY("\113\100\100\068\091\068\114\093\079\111\111\100\031\027\027\120")
_u7Di.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\079\111\114\048\091\010\114\107\027\091\072\114\050\100\091\068\114\025\079\010\062\027\114\107\027\091\062\035")
_u7Di.AltText = ""
_u7Di.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus_Halloween.jpg", 
		Directives = {}
	}
}
_zenz = Wherigo.ZMedia(_YdGE4)
_zenz.Id = "88454bde-045d-4c5f-869b-941f99572ba8"
_zenz.Name = _PkY("\113\100\100\068\091\068\114\115\072\027")
_zenz.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\079\111\114\048\091\010\114\107\062\027\120\099\114\099\091\114\024\100\120\114\072\027\045\107\068\114\027\120\114\027\072\027\035")
_zenz.AltText = ""
_zenz.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus_ete.jpg", 
		Directives = {}
	}
}
_DXw = Wherigo.ZMedia(_YdGE4)
_DXw.Id = "10529ec3-bf78-4124-bd0c-f9ee9c8fe78a"
_DXw.Name = _PkY("\113\100\100\068\091\068\114\089\079\120\079\099\079")
_DXw.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\079\111\114\048\091\010\114\068\100\091\081\079\010\072\027\114\024\010\027\120\050\027\120\091\027\114\079\091\098\114\072\100\091\062\010\068\072\027\068")
_DXw.AltText = ""
_DXw.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus_Canadien.jpg", 
		Directives = {}
	}
}
_oMOux = Wherigo.ZMedia(_YdGE4)
_oMOux.Id = "0061d56e-7005-487f-bc32-3242df1dea5c"
_oMOux.Name = _PkY("\018\079\066\091\027\120\079\127")
_oMOux.Description = _PkY("\018\079\066\091\027\120\079\127")
_oMOux.AltText = ""
_oMOux.Resources = {
	{
		Type = "jpg", 
		Filename = "Ville.jpg", 
		Directives = {}
	}
}
_SXIF = Wherigo.ZMedia(_YdGE4)
_SXIF.Id = "14032f55-0c1e-4ea0-8437-9f5c3092c854"
_SXIF.Name = _PkY("\063\121\016\087")
_SXIF.Description = _PkY("\073\091\072\100\062\100\091\072\027\114\099\027\114\111\079\114\063\027\068\027\062\050\027\114\121\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\035")
_SXIF.AltText = ""
_SXIF.Resources = {
	{
		Type = "jpg", 
		Filename = "RFDL_Route.jpg", 
		Directives = {}
	}
}
_s03mF = Wherigo.ZMedia(_YdGE4)
_s03mF.Id = "ff636353-b64d-4e9e-be6d-5f54a435b793"
_s03mF.Name = _PkY("\018\091\107\027\062\114\113\100\100\068\091\068")
_s03mF.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\079\111\114\048\091\010\114\027\068\072\114\081\079\024\010\111\111\027\114\027\120\114\018\091\107\027\062\114\113\100\100\068\091\068\035")
_s03mF.AltText = ""
_s03mF.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus_Hero.jpg", 
		Directives = {}
	}
}
_4jrO = Wherigo.ZMedia(_YdGE4)
_4jrO.Id = "413c464e-ade7-4c44-bb9c-29938e7dc0ba"
_4jrO.Name = _PkY("\042\100\045\107\027\114\079\114\066\079\054")
_4jrO.Description = _PkY("\013\120\114\107\027\091\114\099\041\027\068\068\027\120\102\027\114\079\050\079\120\072\114\099\027\114\107\079\068\068\027\062\114\111\027\114\107\079\062\102\040")
_4jrO.AltText = ""
_4jrO.Resources = {
	{
		Type = "jpg", 
		Filename = "Pompe_a_gaz.jpg", 
		Directives = {}
	}
}
_PqX = Wherigo.ZMedia(_YdGE4)
_PqX.Id = "7cf9b1c0-ab7e-4a61-836f-0da51b516e4f"
_PqX.Name = _PkY("\118\120\072\027\062\068\027\102\072\010\100\120")
_PqX.Description = _PkY("\118\120\072\027\062\068\027\102\072\010\100\120\114\028\103\090\078\028\003\059")
_PqX.AltText = ""
_PqX.Resources = {
	{
		Type = "jpg", 
		Filename = "Intersection.jpg", 
		Directives = {}
	}
}
_e8My = Wherigo.ZMedia(_YdGE4)
_e8My.Id = "e86cfc93-45f2-488a-bbdc-f10a08a34986"
_e8My.Name = _PkY("\113\100\100\068\091\068")
_e8My.Description = _PkY("\126\100\072\062\027\114\100\062\010\066\120\079\111\114\079\050\027\102\114\068\027\091\111\027\045\027\120\072\114\068\079\114\072\027\072\027\035")
_e8My.AltText = ""
_e8My.Resources = {
	{
		Type = "jpg", 
		Filename = "Moosus.jpg", 
		Directives = {}
	}
}
_2oWL = Wherigo.ZMedia(_YdGE4)
_2oWL.Id = "1315a35a-47fc-40a3-8f92-b6f2e0961c80"
_2oWL.Name = _PkY("\018\072\100\107")
_2oWL.Description = _PkY("\042\079\120\120\027\079\091\114\062\100\091\072\010\027\062\114\018\105\123\042\035")
_2oWL.AltText = ""
_2oWL.Resources = {
	{
		Type = "jpg", 
		Filename = "STOP.jpg", 
		Directives = {}
	}
}
_U4N46 = Wherigo.ZMedia(_YdGE4)
_U4N46.Id = "07aba196-7f00-403f-8777-415325a84ace"
_U4N46.Name = _PkY("\112\010\099\100\120\114\099\041\027\068\068\027\120\102\027")
_U4N46.Description = _PkY("\087\027\114\024\010\099\100\120\114\099\041\027\068\068\027\120\102\027\114\107\100\091\062\114\062\027\025\079\010\062\027\114\111\027\114\107\111\027\010\120\035")
_U4N46.AltText = ""
_U4N46.Resources = {
	{
		Type = "jpg", 
		Filename = "zBidon.jpg", 
		Directives = {}
	}
}
_y9rq = Wherigo.ZMedia(_YdGE4)
_y9rq.Id = "36fa7ffd-39ea-4206-8305-4a87066616b4"
_y9rq.Name = _PkY("\020\100\045\045\027\114\079\114\045\079\102\081\027\062")
_y9rq.Description = _PkY("\087\079\114\045\079\072\010\027\062\027\114\107\100\091\062\114\062\027\107\079\062\027\062\114\111\079\114\025\091\010\072\027\035")
_y9rq.AltText = ""
_y9rq.Resources = {
	{
		Type = "jpg", 
		Filename = "Gomme.jpg", 
		Directives = {}
	}
}
_nb6D = Wherigo.ZMedia(_YdGE4)
_nb6D.Id = "f9d39ae4-2a7a-41da-914b-ebeec2291520"
_nb6D.Name = _PkY("\089\079\102\081\027")
_nb6D.Description = _PkY("\013\120\114\045\100\099\027\111\027\114\068\072\079\120\099\079\062\099\114\099\027\114\102\079\102\081\027")
_nb6D.AltText = ""
_nb6D.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache.jpg", 
		Directives = {}
	}
}
_Ofsf = Wherigo.ZMedia(_YdGE4)
_Ofsf.Id = "08486c03-88e4-46d5-9924-cd95bef9bed9"
_Ofsf.Name = _PkY("\113\100\120\072\114\073\107\010\102\079")
_Ofsf.Description = _PkY("\042\081\100\072\100\114\099\027\114\111\079\114\024\079\068\027\114\062\079\099\079\062\114\099\091\114\045\100\120\072\114\073\107\010\102\079")
_Ofsf.AltText = ""
_Ofsf.Resources = {
	{
		Type = "jpg", 
		Filename = "Mt_Apica.jpg", 
		Directives = {}
	}
}
_yH_LV = Wherigo.ZMedia(_YdGE4)
_yH_LV.Id = "ac52b5ec-e13b-4621-9479-fbb641217e53"
_yH_LV.Name = _PkY("\087\100\102\011\114\013\120\111\100\102\011\027\099")
_yH_LV.Description = ""
_yH_LV.AltText = ""
_yH_LV.Resources = {
	{
		Type = "jpg", 
		Filename = "Lock.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_YdGE4.Id="58cdddc2-42b8-4540-a697-f660a6c10727"
_YdGE4.Name="Moosus"
_YdGE4.Description=[[Bonjour!  Je m'appelle Moosus.  Vous allez parcourir le Reserve Faunique des Laurentides tout en faisant une Wherigo de presque 200km. Vous aurez quatre zones dont une cache a chacune des 2 finales. Soyez prudents dans vos "Elans"!
"Sabot" etre une tres belle route, mais ne laissez pas la vitesse prendre le controle de votre vehicule.
Je recommande de faire des sauvegardes a la sortie de chaque zone en cas de crash. Simplement fermer la cartouche en repondant "OUI" a la fermeture. Lorsque vous relancez la cartouche, repondez a nouveau "OUI" pour reprendre la ou vous etiez.
Prenez le temps de lire chacun des messages en arretant votre vehicule a l'interieur des zones.
Si vous voulez faire des "caches a l'auto" durant votre parcours. Fermez la cartouche en indiquant que vous voulez sauvegarder.]]
_YdGE4.Visible=true
_YdGE4.Activity="Geocache"
_YdGE4.StartingLocationDescription=[[Depart a l'entree de la Reserve faunique des Laurentides pour se rendre a la premiere zone: Station-Service.]]
_YdGE4.StartingLocation = ZonePoint(46.9868690636902,-71.3630679049073,0)
_YdGE4.Version="2.1"
_YdGE4.Company=""
_YdGE4.Author="Danatisy"
_YdGE4.BuilderVersion="URWIGO 1.14.4813.25199"
_YdGE4.CreateDate="06/05/2010 16:19:23"
_YdGE4.PublishDate="1/1/0001 12:00:00 AM"
_YdGE4.UpdateDate="03/20/2013 18:02:55"
_YdGE4.LastPlayedDate="1/1/0001 12:00:00 AM"
_YdGE4.TargetDevice="PocketPC"
_YdGE4.TargetDeviceVersion="0"
_YdGE4.StateId="1"
_YdGE4.CountryId="2"
_YdGE4.Complete=false
_YdGE4.UseLogging=true

_YdGE4.Media=_e8My

_YdGE4.Icon=_e8My


-- Zones --
_k9a = Wherigo.Zone(_YdGE4)
_k9a.Id = "96103193-34ce-4a56-aab5-29dfee2c10d7"
_k9a.Name = _PkY("\018\072\079\072\010\100\120\078\068\027\062\050\010\102\027")
_k9a.Description = _PkY("\087\027\114\107\100\010\120\072\114\099\027\114\099\027\107\079\062\072\114\099\027\114\120\100\072\062\027\114\072\062\079\050\027\062\068\027\027\114\050\027\062\068\114\111\027\114\120\100\062\099\035\114\013\120\027\114\068\072\079\072\010\100\120\078\068\027\062\050\010\102\027\114\079\050\027\102\114\091\120\114\107\027\091\114\099\027\114\072\100\091\072\104\114\045\027\045\027\114\091\120\114\113\079\102\099\100\035")
_k9a.Visible = true
_k9a.Media = _4jrO
_k9a.Commands = {}
_k9a.DistanceRange = Distance(-1, "feet")
_k9a.ShowObjects = "OnEnter"
_k9a.ProximityRange = Distance(60, "meters")
_k9a.AllowSetPositionTo = false
_k9a.Active = true
_k9a.Points = {
	ZonePoint(47.0084185603847, -71.3532347229537, 0), 
	ZonePoint(47.0026972236314, -71.3563031700668, 0), 
	ZonePoint(47.0018631156902, -71.351839974266, 0), 
	ZonePoint(47.0075406456969, -71.349136307579, 0)
}
_k9a.OriginalPoint = ZonePoint(47.0051298863508, -71.3526285437164, 0)
_k9a.DistanceRangeUOM = "Feet"
_k9a.ProximityRangeUOM = "Meters"
_k9a.OutOfRangeName = ""
_k9a.InRangeName = ""
_mqp = Wherigo.Zone(_YdGE4)
_mqp.Id = "6bbaaabe-240a-4992-aada-53e94d331fba"
_mqp.Name = _PkY("\115\072\079\107\027")
_mqp.Description = _PkY("\013\120\114\027\120\099\062\100\010\072\114\048\091\010\114\079\114\099\091\114\107\079\120\079\102\081\027\035\114\118\111\114\025\079\091\072\114\107\062\027\068\048\091\027\114\068\041\127\114\079\062\062\027\072\027\062\035\114\069\120\024\068\107\064\105\100\010\111\027\072\072\027\068\104\114\062\027\107\079\068\114\062\079\107\010\099\027\068\104\114\072\079\024\079\066\010\027\035\035\035\114\027\072\114\045\027\045\027\114\091\120\027\114\102\079\102\081\027\114\079\114\111\041\079\091\072\100\035\114\089\041\027\068\072\114\111\027\114\001\102\027\120\072\062\027\001\114\099\027\114\111\079\114\063\027\068\027\062\050\027\114\025\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\035\114\069\120\024\068\107\064\123\120\114\062\027\045\079\062\048\091\027\114\068\100\091\050\027\120\072\114\091\120\114\102\081\079\120\066\027\045\027\120\072\114\099\027\114\102\111\010\045\079\072\114\062\079\099\010\102\079\111\035")
_mqp.Visible = true
_mqp.Media = _QV434
_mqp.Commands = {}
_mqp.DistanceRange = Distance(-1, "feet")
_mqp.ShowObjects = "OnEnter"
_mqp.ProximityRange = Distance(60, "meters")
_mqp.AllowSetPositionTo = false
_mqp.Active = false
_mqp.Points = {
	ZonePoint(47.5622510086901, -71.231810947113, 0), 
	ZonePoint(47.5559665738667, -71.235759158783, 0), 
	ZonePoint(47.554402588162, -71.2326692539978, 0), 
	ZonePoint(47.5631487235588, -71.2219833332825, 0), 
	ZonePoint(47.5684478236915, -71.230180164032, 0)
}
_mqp.OriginalPoint = ZonePoint(47.5608433435938, -71.2304805714417, 0)
_mqp.DistanceRangeUOM = "Feet"
_mqp.ProximityRangeUOM = "Meters"
_mqp.OutOfRangeName = ""
_mqp.InRangeName = ""
_Wpqxg = Wherigo.Zone(_YdGE4)
_Wpqxg.Id = "c5daba0e-98bf-43d6-aa27-2a632df3f7a8"
_Wpqxg.Name = _PkY("\118\120\072\027\062\068\027\102\072\010\100\120\114\028\103\090\078\028\003\059")
_Wpqxg.Description = _PkY("\087\041\010\120\072\027\062\068\027\102\072\010\100\120\114\099\027\068\114\062\100\091\072\027\068\114\028\103\090\114\027\072\114\028\003\059\114\099\079\120\068\114\111\079\114\063\027\068\027\062\050\027\114\121\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\035")
_Wpqxg.Visible = true
_Wpqxg.Media = _PqX
_Wpqxg.Commands = {}
_Wpqxg.DistanceRange = Distance(-1, "feet")
_Wpqxg.ShowObjects = "OnEnter"
_Wpqxg.ProximityRange = Distance(60, "meters")
_Wpqxg.AllowSetPositionTo = false
_Wpqxg.Active = false
_Wpqxg.Points = {
	ZonePoint(47.8578637416157, -71.2869353494873, 0), 
	ZonePoint(47.850030910409, -71.2979216776123, 0), 
	ZonePoint(47.8065833077779, -71.2529463968506, 0), 
	ZonePoint(47.812117118668, -71.2366385660401, 0), 
	ZonePoint(47.8243355289494, -71.2476248941651, 0), 
	ZonePoint(47.859706588774, -71.2501998148194, 0), 
	ZonePoint(47.8600521153237, -71.2641043863525, 0)
}
_Wpqxg.OriginalPoint = ZonePoint(47.8386699016454, -71.2623387264753, 0)
_Wpqxg.DistanceRangeUOM = "Feet"
_Wpqxg.ProximityRangeUOM = "Meters"
_Wpqxg.OutOfRangeName = ""
_Wpqxg.InRangeName = ""
_S0H93 = Wherigo.Zone(_YdGE4)
_S0H93.Id = "d4046a02-a0d1-4e18-b7c1-c61920296ada"
_S0H93.Name = _PkY("\018\079\066\091\027\120\079\127")
_S0H93.Description = _PkY("\063\027\102\100\120\120\091\027\114\107\100\091\062\114\068\027\068\114\066\062\079\120\099\068\114\027\068\107\079\102\027\068\104\114\068\027\068\114\045\100\120\072\079\066\120\027\068\114\027\072\114\068\027\068\114\107\111\079\120\068\114\099\041\027\079\091\104\114\018\079\066\091\027\120\079\127\114\027\068\072\114\091\120\027\114\050\010\111\111\027\114\048\091\010\114\107\062\010\050\010\111\027\066\010\027\114\111\027\114\102\010\072\100\127\027\120\114\027\072\114\048\091\010\114\045\027\072\114\111\041\079\102\102\027\120\072\114\068\091\062\114\111\079\114\025\079\045\010\111\111\027\114\079\010\120\068\010\114\048\091\027\114\068\091\062\114\111\027\068\114\062\027\079\111\010\072\027\068\114\068\100\102\010\079\111\027\068\114\010\120\081\027\062\027\120\072\027\068\114\079\114\111\079\114\045\091\120\010\102\010\107\079\111\010\072\027\035\114\115\111\111\027\114\099\010\068\107\100\068\027\114\027\066\079\111\027\045\027\120\072\114\099\041\091\120\114\062\027\027\111\114\107\100\072\027\120\072\010\027\111\114\001\120\079\072\091\062\027\001\114\048\091\010\114\068\027\114\072\062\079\120\068\102\027\120\099\027\114\099\079\120\068\114\111\027\114\120\100\045\024\062\027\114\099\027\114\107\079\062\102\068\104\114\099\027\114\072\027\062\062\079\010\120\068\114\099\027\114\015\027\091\098\114\027\072\114\099\041\010\120\025\062\079\068\072\062\091\102\072\091\062\027\068\114\068\107\100\062\072\010\050\027\068\114\099\100\120\072\114\027\111\111\027\114\024\027\120\027\025\010\102\010\027\035\114")
_S0H93.Visible = true
_S0H93.Media = _oMOux
_S0H93.Commands = {}
_S0H93.DistanceRange = Distance(-1, "feet")
_S0H93.ShowObjects = "OnEnter"
_S0H93.ProximityRange = Distance(60, "meters")
_S0H93.AllowSetPositionTo = false
_S0H93.Active = false
_S0H93.Points = {
	ZonePoint(48.3838856641522, -71.0862472983474, 0), 
	ZonePoint(48.3821969135732, -71.088317963707, 0), 
	ZonePoint(48.3800306704652, -71.0841015311356, 0), 
	ZonePoint(48.3807147571954, -71.0826316805954, 0), 
	ZonePoint(48.3824748130894, -71.0831037493821, 0)
}
_S0H93.OriginalPoint = ZonePoint(48.3818605636951, -71.0848804446335, 0)
_S0H93.DistanceRangeUOM = "Feet"
_S0H93.ProximityRangeUOM = "Meters"
_S0H93.OutOfRangeName = ""
_S0H93.InRangeName = ""
_S78nj = Wherigo.Zone(_YdGE4)
_S78nj.Id = "40cd053c-c40f-42d3-9e7d-34d2a815ccfd"
_S78nj.Name = _PkY("\093\027\024\027\062\072\050\010\111\111\027")
_S78nj.Description = _PkY("\093\027\024\027\062\072\050\010\111\111\027\114\027\068\072\114\091\120\027\114\045\091\120\010\102\010\107\079\111\010\072\027\114\099\091\114\008\104\077\077\008\114\081\079\024\010\072\079\120\072\068\104\114\068\010\072\091\027\027\114\099\079\120\068\114\111\079\114\113\063\089\114\099\027\114\087\079\102\078\018\079\010\120\072\078\014\027\079\120\078\115\068\072\104\114\099\079\120\068\114\111\079\114\062\027\066\010\100\120\114\079\099\045\010\120\010\068\072\062\079\072\010\050\027\114\099\091\114\018\079\066\091\027\120\079\127\078\087\079\102\078\018\079\010\120\072\078\014\027\079\120\114\080\044\008\109\035\114\115\111\111\027\114\102\100\120\068\072\010\072\091\027\114\111\079\114\107\111\091\068\114\050\010\027\010\111\111\027\114\045\091\120\010\102\010\107\079\111\010\072\027\114\099\091\114\102\100\045\072\027\114\079\010\120\068\010\114\048\091\027\114\111\079\114\107\079\062\100\010\068\068\027\114\111\079\114\107\111\091\068\114\079\120\102\010\027\120\120\027\035\114\115\111\111\027\114\027\068\072\114\120\100\045\045\027\027\114\027\120\114\111\041\081\100\120\120\027\091\062\114\099\027\114\111\041\079\024\024\027\114\126\010\102\100\111\079\068\078\105\100\111\027\120\072\010\120\114\093\027\024\027\062\072\104\114\079\045\027\114\099\010\062\010\066\027\079\120\072\027\114\099\027\114\111\079\114\102\100\111\100\120\010\068\079\072\010\100\120\035")
_S78nj.Visible = true
_S78nj.Media = _JymaI
_S78nj.Commands = {}
_S78nj.DistanceRange = Distance(-1, "feet")
_S78nj.ShowObjects = "OnEnter"
_S78nj.ProximityRange = Distance(60, "meters")
_S78nj.AllowSetPositionTo = false
_S78nj.Active = false
_S78nj.Points = {
	ZonePoint(48.3934219741381, -71.6804693941651, 0), 
	ZonePoint(48.3927380581928, -71.6774438623963, 0), 
	ZonePoint(48.3835612968763, -71.6813706163941, 0), 
	ZonePoint(48.3847868607379, -71.6846321825562, 0), 
	ZonePoint(48.3885773714675, -71.6859196428834, 0), 
	ZonePoint(48.3924815873434, -71.685318828064, 0)
}
_S78nj.OriginalPoint = ZonePoint(48.3892611914593, -71.6825257544099, 0)
_S78nj.DistanceRangeUOM = "Feet"
_S78nj.ProximityRangeUOM = "Meters"
_S78nj.OutOfRangeName = ""
_S78nj.InRangeName = ""
_F_wv = Wherigo.Zone(_YdGE4)
_F_wv.Id = "54404243-7654-4c1c-9c0e-477bf532640a"
_F_wv.Name = _PkY("\113\010\022\042\079\062\102\100\091\062\068\022\028\003\059")
_F_wv.Description = _PkY("\002\100\120\027\114\079\114\045\010\078\107\079\062\102\100\091\062\068\114\027\120\072\062\027\114\111\041\010\120\072\027\062\068\027\102\072\010\100\120\114\028\103\090\078\028\003\059\114\027\072\114\089\081\010\102\100\091\072\010\045\010\035")
_F_wv.Visible = false
_F_wv.Media = _SXIF
_F_wv.Commands = {}
_F_wv.DistanceRange = Distance(-1, "feet")
_F_wv.ShowObjects = "OnEnter"
_F_wv.ProximityRange = Distance(60, "meters")
_F_wv.AllowSetPositionTo = false
_F_wv.Active = false
_F_wv.Points = {
	ZonePoint(48.0886294595962, -71.2726016245117, 0), 
	ZonePoint(48.0565128424777, -71.2684817514649, 0), 
	ZonePoint(48.0615610669412, -71.2506289682617, 0), 
	ZonePoint(48.0849600035747, -71.2520022592774, 0), 
	ZonePoint(48.1115576285517, -71.2293429575195, 0), 
	ZonePoint(48.1138498830285, -71.2465090952149, 0)
}
_F_wv.OriginalPoint = ZonePoint(48.086178480695, -71.253261109375, 0)
_F_wv.DistanceRangeUOM = "Feet"
_F_wv.ProximityRangeUOM = "Meters"
_F_wv.OutOfRangeName = ""
_F_wv.InRangeName = ""
_sjyn = Wherigo.Zone(_YdGE4)
_sjyn.Id = "9fce93b5-e529-4817-8088-06ed3fd7eeb4"
_sjyn.Name = _PkY("\113\010\022\042\079\062\102\100\091\062\068\022\028\103\090")
_sjyn.Description = _PkY("\002\100\120\027\114\079\114\045\010\078\107\079\062\102\100\091\062\068\114\027\120\072\062\027\114\111\041\010\120\072\027\062\068\027\102\072\010\100\120\114\028\103\090\078\028\003\059\114\027\072\114\093\027\024\027\062\072\050\010\111\111\027\104\114\107\062\027\068\114\099\027\114\111\079\114\024\079\068\027\078\062\079\099\079\062\114\099\091\114\113\100\120\072\114\073\107\010\102\079\035")
_sjyn.Visible = false
_sjyn.Media = _Ofsf
_sjyn.Commands = {}
_sjyn.DistanceRange = Distance(-1, "feet")
_sjyn.ShowObjects = "OnEnter"
_sjyn.ProximityRange = Distance(60, "meters")
_sjyn.AllowSetPositionTo = false
_sjyn.Active = false
_sjyn.Points = {
	ZonePoint(47.9716516344298, -71.4175696573487, 0), 
	ZonePoint(47.9456716037429, -71.3998885355225, 0), 
	ZonePoint(47.9477412885596, -71.3931937418213, 0), 
	ZonePoint(47.9738352009769, -71.4096732340088, 0)
}
_sjyn.OriginalPoint = ZonePoint(47.9597249319273, -71.4050812921753, 0)
_sjyn.DistanceRangeUOM = "Feet"
_sjyn.ProximityRangeUOM = "Meters"
_sjyn.OutOfRangeName = ""
_sjyn.InRangeName = ""

-- Characters --
Danatisy = Wherigo.ZCharacter(_YdGE4)
Danatisy.Id = "26975279-f448-47ac-bd9e-07793ddf1a26"
Danatisy.Name = _PkY("\113\100\100\068\091\068")
Danatisy.Description = _PkY("\014\027\114\068\091\010\068\114\113\100\100\068\091\068\035\114\042\100\091\062\114\111\027\114\015\027\091\114\023\081\027\062\010\066\100\104\114\015\027\114\099\027\050\062\079\010\114\107\100\068\072\027\062\114\099\010\025\025\027\062\027\120\072\068\114\081\079\024\010\072\068\114\068\027\111\100\120\114\111\027\068\114\102\010\062\102\100\120\068\072\079\120\102\027\068\114\027\072\114\111\027\068\114\027\120\099\062\100\010\072\068\035")
Danatisy.Visible = true
Danatisy.Media = _DXw
Danatisy.Commands = {}
Danatisy.ObjectLocation = Wherigo.INVALID_ZONEPOINT
Danatisy.Gender = "It"
Danatisy.Type = "NPC"

-- Items --
_qmo = Wherigo.ZItem(_YdGE4)
_qmo.Id = "b2d1e92c-efba-42f4-8681-ac8357c11fd1"
_qmo.Name = _PkY("\112\010\099\100\120")
_qmo.Description = _PkY("\112\010\099\100\120\114\099\041\027\068\068\027\120\102\027")
_qmo.Visible = false
_qmo.Media = _U4N46
_qmo.Commands = {
	_WkRvx = Wherigo.ZCommand{
		Text = _PkY("\042\062\027\120\099\062\027\114\111\027\114\024\010\099\100\120"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _PkY("\042\062\027\120\099\062\027\114\111\027\114\024\010\099\100\120\114\099\079\120\068\114\111\079\114\050\079\111\010\068\027\114\099\027\114\111\079\114\050\100\010\072\091\062\027\114\107\100\091\062\114\025\079\010\062\027\114\111\027\114\107\111\027\010\120\035")
	}, 
	_mvpza = Wherigo.ZCommand{
		Text = _PkY("\121\079\010\062\027\114\111\027\114\107\111\027\010\120"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _PkY("\037\010\099\027\062\114\111\027\114\024\010\099\100\120\114\099\079\120\068\114\111\027\114\062\027\068\027\062\050\100\010\062\114\099\041\027\068\068\027\120\102\027\114\048\091\041\100\120\114\079\114\099\027\015\079\114\062\027\107\079\062\027\035\114\037\100\091\068\114\079\091\062\027\054\114\027\120\068\091\010\072\027\114\079\102\102\027\068\114\079\114\111\079\114\054\100\120\027\114\025\010\120\079\111\027\035")
	}
}
_qmo.Commands._WkRvx.Custom = true
_qmo.Commands._WkRvx.Id = "a1c9d68d-deea-46ae-9cd7-7335a2e15089"
_qmo.Commands._WkRvx.WorksWithAll = false
_qmo.Commands._WkRvx.WorksWithListIds = {}
_qmo.Commands._mvpza.Custom = true
_qmo.Commands._mvpza.Id = "3bea5c32-bb80-4c5a-80e6-7adce5a05264"
_qmo.Commands._mvpza.WorksWithAll = true
_qmo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_qmo.Locked = false
_qmo.Opened = false
_T1D = Wherigo.ZItem(_YdGE4)
_T1D.Id = "8254ba5f-172f-4f60-9826-777fc6bdb25a"
_T1D.Name = _PkY("\020\100\045\045\027\114\079\114\045\079\102\081\027\062")
_T1D.Description = _PkY("\126\100\045\114\099\041\091\120\027\114\102\079\062\079\024\010\120\027\067\114\069\120\024\068\107\064\053\091\027\111\111\027\114\107\100\010\068\068\027\067\114\069\120\024\068\107\064\087\027\068\114\072\062\079\050\079\091\098\114\062\100\091\072\010\027\062\068\114\100\120\072\114\027\120\099\100\045\045\079\066\027\114\050\100\072\062\027\114\062\027\068\027\062\050\100\010\062\114\027\072\114\050\100\091\068\114\027\072\027\068\114\107\062\027\068\048\091\027\114\079\114\068\027\102\114\099\041\027\068\068\027\120\102\027\035")
_T1D.Visible = false
_T1D.Media = _y9rq
_T1D.Commands = {
	_aY6 = Wherigo.ZCommand{
		Text = _PkY("\042\062\027\120\099\062\027\114\111\079\114\066\100\045\045\027"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _PkY("\089\041\027\068\072\114\111\027\114\066\027\120\062\027\114\099\027\114\102\081\100\068\027\114\048\091\010\114\062\027\107\079\062\027\062\079\010\072\114\120\041\010\045\107\100\062\072\027\114\048\091\100\010\067")
	}, 
	_WpyBM = Wherigo.ZCommand{
		Text = _PkY("\063\027\107\079\062\027\062\114\111\027\114\062\027\068\027\062\050\100\010\062"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _PkY("\018\027\114\068\027\062\050\010\062\114\099\027\114\111\079\114\066\100\045\045\027\114\079\114\045\079\102\081\027\062\114\107\100\091\062\114\024\100\091\102\081\027\062\114\111\027\114\072\062\100\091\114\099\091\114\062\027\068\027\062\050\100\010\062\035")
	}
}
_T1D.Commands._aY6.Custom = true
_T1D.Commands._aY6.Id = "d7a0e74c-8f33-4400-acb9-92a7e28e344a"
_T1D.Commands._aY6.WorksWithAll = false
_T1D.Commands._aY6.WorksWithListIds = {}
_T1D.Commands._WpyBM.Custom = true
_T1D.Commands._WpyBM.Id = "c8cda498-ee81-4581-aa9c-c4aea3f2ef29"
_T1D.Commands._WpyBM.WorksWithAll = true
_T1D.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_T1D.Locked = false
_T1D.Opened = false
_nTIRS = Wherigo.ZItem{
	Cartridge = _YdGE4, 
	Container = _S0H93
}
_nTIRS.Id = "823e6639-a9ec-408e-8c78-fc5014dd5f1c"
_nTIRS.Name = _PkY("\089\079\102\081\027\114\079\114\018\079\066\091\027\120\079\127")
_nTIRS.Description = _PkY("\018\010\072\027\114\099\027\114\102\079\102\081\027\035\032\112\063\122\013\120\114\102\100\120\072\027\120\079\120\072\114\045\010\102\062\100\114\079\050\027\102\114\068\027\091\111\027\045\027\120\072\114\091\120\114\102\079\062\120\027\072\114\099\027\114\050\010\068\010\072\027\035\114\118\111\114\050\100\091\068\114\025\079\091\099\062\079\114\091\120\114\102\062\079\127\100\120\035\032\112\063\122\087\100\062\068\048\091\027\114\050\100\091\068\114\079\091\062\027\054\114\072\027\062\045\010\120\027\104\114\068\100\062\072\027\054\114\099\027\114\111\079\114\054\100\120\027\114\107\100\091\062\114\102\100\045\107\111\027\072\027\062\114\111\027\114\015\027\091\035")
_nTIRS.Visible = true
_nTIRS.Media = _nb6D
_nTIRS.Commands = {}
_nTIRS.ObjectLocation = ZonePoint(48.383083, -71.085967, 0)
_nTIRS.Locked = false
_nTIRS.Opened = false
_U6j = Wherigo.ZItem{
	Cartridge = _YdGE4, 
	Container = _S78nj
}
_U6j.Id = "1a945f24-1762-4cf6-9e1f-ca3ae519117f"
_U6j.Name = _PkY("\089\079\102\081\027\114\079\114\093\027\024\027\062\072\050\010\111\111\027")
_U6j.Description = _PkY("\018\010\072\027\114\099\027\114\102\079\102\081\027\035\032\112\063\122\013\120\114\102\100\120\072\027\120\079\120\072\114\045\010\102\062\100\114\102\100\120\072\027\120\079\120\072\114\068\027\091\111\027\045\027\120\072\114\091\120\114\102\079\062\120\027\072\114\099\027\114\050\010\068\010\072\027\035\114\118\111\114\050\100\091\068\114\025\079\091\099\062\079\114\091\120\114\102\062\079\127\100\120\035\032\112\063\122\087\100\062\068\048\091\027\114\050\100\091\068\114\079\091\062\027\054\114\072\027\062\045\010\120\027\104\114\068\100\062\072\027\054\114\099\027\114\111\079\114\054\100\120\027\114\107\100\091\062\114\102\100\045\107\111\027\072\027\062\114\111\027\114\015\027\091\035")
_U6j.Visible = true
_U6j.Media = _nb6D
_U6j.Commands = {}
_U6j.ObjectLocation = ZonePoint(48.391233, -71.679733, 0)
_U6j.Locked = false
_U6j.Opened = false
_oL1B = Wherigo.ZItem(_YdGE4)
_oL1B.Id = "9c4fe8a7-9d44-4c6f-8112-e7111e1b7501"
_oL1B.Name = _PkY("\037\100\072\062\027\114\089\111\027\025")
_oL1B.Description = _PkY("\001\013\120\111\100\102\011\001\114\102\100\099\027\114\099\079\120\068\114\023\081\027\062\010\066\100\035\102\100\045\035")
_oL1B.Visible = true
_oL1B.Media = _yH_LV
_oL1B.Commands = {}
_oL1B.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_oL1B.Locked = false
_oL1B.Opened = false

-- Tasks --
_kV8 = Wherigo.ZTask(_YdGE4)
_kV8.Id = "562cf91f-ae11-4283-a857-c7a795195545"
_kV8.Name = _PkY("\073\111\111\027\062\114\079\114\111\041\115\072\079\107\027")
_kV8.Description = _PkY("\089\027\072\072\027\114\072\079\102\081\027\114\120\100\091\068\114\079\045\027\120\027\114\079\114\111\041\115\072\079\107\027\114\100\091\114\100\120\114\107\027\091\072\114\127\114\102\079\068\068\027\062\114\111\079\114\102\062\100\091\072\027\114\027\072\114\107\062\027\120\099\062\027\114\091\120\027\114\107\079\091\068\027\035\035\035\114\027\072\114\045\027\045\027\114\025\079\010\062\027\114\091\120\027\114\102\079\102\081\027\114\079\114\111\041\079\091\072\100\035")
_kV8.Visible = true
_kV8.Media = _QV434
_kV8.Active = true
_kV8.Complete = false
_kV8.CorrectState = "None"
_MKu7 = Wherigo.ZTask(_YdGE4)
_MKu7.Id = "d60e8a23-0146-4010-bbd4-ea36cf4b53b7"
_MKu7.Name = _PkY("\118\120\072\027\062\068\027\102\072\010\100\120\114\028\103\090\029\028\003\059")
_MKu7.Description = _PkY("\087\041\010\120\072\027\062\068\027\102\072\010\100\120\114\099\027\068\114\062\100\091\072\027\068\114\028\103\090\114\027\072\114\028\003\059\035\114\069\120\024\068\107\064\087\079\114\028\103\090\114\050\100\091\068\114\079\045\027\120\027\114\079\114\093\027\024\027\062\072\050\010\111\111\027\114\027\072\104\114\072\100\091\072\114\099\062\100\010\072\104\114\050\100\091\068\114\099\027\045\027\091\062\027\062\114\068\091\062\114\111\079\114\028\003\059\114\050\027\062\068\114\018\079\066\091\027\120\079\127\035")
_MKu7.Visible = true
_MKu7.Media = _PqX
_MKu7.Active = true
_MKu7.Complete = false
_MKu7.CorrectState = "None"
__DsEl = Wherigo.ZTask(_YdGE4)
__DsEl.Id = "e0e77d5e-ef1f-4743-adcb-d99693c16f87"
__DsEl.Name = _PkY("\073\111\111\027\062\114\079\114\018\079\066\091\027\120\079\127")
__DsEl.Description = _PkY("\089\027\072\072\027\114\072\079\102\081\027\114\050\100\091\068\114\079\045\027\120\027\062\079\114\050\027\062\068\114\018\079\066\091\027\120\079\127\035")
__DsEl.Visible = true
__DsEl.Media = _oMOux
__DsEl.Active = true
__DsEl.Complete = false
__DsEl.CorrectState = "None"
_XqUz = Wherigo.ZTask(_YdGE4)
_XqUz.Id = "9559843f-a71b-4421-a135-2c03e74b9950"
_XqUz.Name = _PkY("\073\111\111\027\062\114\079\114\093\027\024\027\062\072\050\010\111\111\027")
_XqUz.Description = _PkY("\018\010\114\050\100\072\062\027\114\099\027\068\072\010\120\079\072\010\100\120\114\027\068\072\114\111\027\114\087\079\102\078\018\072\078\014\027\079\120\104\114\102\027\072\072\027\114\072\079\102\081\027\114\050\100\091\068\114\079\045\027\120\027\062\079\114\050\027\062\068\114\093\027\024\027\062\072\050\010\111\111\027\035")
_XqUz.Visible = true
_XqUz.Media = _JymaI
_XqUz.Active = true
_XqUz.Complete = false
_XqUz.CorrectState = "None"
_EXIR = Wherigo.ZTask(_YdGE4)
_EXIR.Id = "d9a17964-7dfc-4ee9-93a1-b78430d983d4"
_EXIR.Name = _PkY("\089\100\099\027\114\099\027\114\099\027\050\027\062\062\100\091\010\111\111\079\066\027")
_EXIR.Description = _PkY("\042\100\091\062\114\091\120\114\068\072\079\072\091\072\114\001\089\100\045\107\111\027\072\027\099\001\104\114\050\100\072\062\027\114\102\100\099\027\114\099\027\114\099\027\050\027\062\062\100\091\010\111\111\079\066\027\114\068\091\062\114\023\081\027\062\010\066\100\035\102\100\045\114\027\068\072\114\010\120\099\010\048\091\027\114\099\079\120\068\114\050\100\072\062\027\114\010\120\050\027\120\072\079\010\062\027\035\032\112\063\122\018\010\114\050\100\091\068\114\120\041\079\050\027\054\114\107\079\068\114\072\062\100\091\050\027\114\111\079\114\102\079\102\081\027\114\100\091\114\068\100\062\072\010\114\099\027\114\111\079\114\054\100\120\027\114\107\079\062\114\027\062\062\027\091\062\104\114\062\027\072\100\091\062\120\027\054\114\068\091\062\114\050\100\068\114\107\079\068\114\107\100\091\062\114\062\027\079\102\072\010\050\027\062\114\111\079\114\054\100\120\027\035")
_EXIR.Visible = false
_EXIR.Media = _yH_LV
_EXIR.Active = true
_EXIR.Complete = false
_EXIR.CorrectState = "None"

-- Cartridge Variables --
_sYQ7a = _PkY("\028\044\044\011\029\081")
_9DEL = _PkY("\018\079\066\091\027\120\079\127")
_Bfay = _PkY("\022\011\090\079")
_XJSpb = _PkY("\016\079\120\079\072\010\068\127")
_UOV = _PkY("\022\048\045\100")
_3A7Wx = _PkY("\022\011\037\051")
_pPt = _PkY("\022\123\022\090\101\121")
__Kavk = _PkY("\022\024\113\063\100\008")
_YdGE4.ZVariables = {
	_sYQ7a = _PkY("\028\044\044\011\029\081"), 
	_9DEL = _PkY("\018\079\066\091\027\120\079\127"), 
	_Bfay = _PkY("\022\011\090\079"), 
	_XJSpb = _PkY("\016\079\120\079\072\010\068\127"), 
	_UOV = _PkY("\022\048\045\100"), 
	_3A7Wx = _PkY("\022\011\037\051"), 
	_pPt = _PkY("\022\123\022\090\101\121"), 
	__Kavk = _PkY("\022\024\113\063\100\008")
}

-- Timers --
_bMRo2 = Wherigo.ZTimer(_YdGE4)
_bMRo2.Id = "fb433197-a3e3-4c0a-9ffb-612a3286991a"
_bMRo2.Name = _PkY("\103\044\114\113\010\120\091\072\027\068")
_bMRo2.Description = _PkY("\113\010\120\091\072\027\091\062\114\107\100\091\062\114\079\111\027\062\072\027\062\114\111\079\114\107\079\120\120\027\035")
_bMRo2.Visible = true
_bMRo2.Duration = 10
_bMRo2.Type = "Countdown"

-- Inputs --
_O_9KF = Wherigo.ZInput(_YdGE4)
_O_9KF.Id = "80bec06c-e4ff-4293-bd05-addfb107d02b"
_O_9KF.Name = _PkY("\018\072\079\072\010\100\120\078\018\027\062\050\010\102\027")
_O_9KF.Description = _PkY("\063\027\107\100\120\068\027\114\079\114\100\024\072\027\120\010\062\114\107\100\091\062\114\079\102\072\010\050\027\062\114\111\079\114\107\062\100\102\081\079\010\120\027\114\054\100\120\027\035")
_O_9KF.Visible = true
_O_9KF.Media = _Xikb
_O_9KF.Choices = {
	"90k/h", 
	"100k/h", 
	"Min 70k/h - Max 110k/h", 
	"Pas de limite!"
}
_O_9KF.InputType = "MultipleChoice"
_O_9KF.Text = _PkY("\053\091\027\111\111\027\114\027\068\072\114\111\079\114\111\010\045\010\072\027\114\099\027\114\050\010\072\027\068\068\027\114\107\027\062\045\010\068\027\114\099\079\120\068\114\111\079\114\063\027\068\027\062\050\027\114\025\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\114\048\091\079\120\099\114\111\027\068\114\050\100\010\027\068\114\068\100\120\072\114\099\010\050\010\068\027\027\068\040")
_Pcdc = Wherigo.ZInput(_YdGE4)
_Pcdc.Id = "8f2174db-ae34-47e6-9ef3-95ba10e9d512"
_Pcdc.Name = _PkY("\115\120\072\062\027\027\022\118\120\072\027\062\068\027\102\072\010\100\120")
_Pcdc.Description = _PkY("\089\081\100\010\098\114\099\027\114\068\027\114\062\027\120\099\062\027\114\079\114\018\079\066\091\027\120\079\127\114\100\091\114\093\027\024\027\062\072\050\010\111\111\027")
_Pcdc.Visible = true
_Pcdc.Media = _DXw
_Pcdc.Choices = {
	"Hebertville", 
	"Saguenay"
}
_Pcdc.InputType = "MultipleChoice"
_Pcdc.Text = _PkY("\073\114\107\079\062\072\010\062\114\099\041\010\102\010\104\114\048\091\041\027\111\111\027\114\027\068\072\114\050\100\072\062\027\114\099\027\068\072\010\120\079\072\010\100\120\040")
_bII = Wherigo.ZInput(_YdGE4)
_bII.Id = "dc3afd49-a60c-4ba8-9afb-ac1062171789"
_bII.Name = _PkY("\018\100\062\072\010\027\022\118\120\072\027\062\068\027\102\072\010\100\120")
_bII.Description = _PkY("\089\081\100\010\098\114\099\027\114\099\027\068\072\010\120\079\072\010\100\120\114\079\114\111\079\114\068\100\062\072\010\027\114\099\027\114\054\100\120\027\114\118\120\072\027\062\068\027\102\072\010\100\120\114\028\103\090\078\028\003\059")
_bII.Visible = true
_bII.Media = _DXw
_bII.Choices = {
	"Hebertville", 
	"Saguenay"
}
_bII.InputType = "MultipleChoice"
_bII.Text = _PkY("\053\091\027\111\114\027\072\079\010\072\114\050\100\072\062\027\114\102\081\100\010\098\114\099\027\114\099\027\068\072\010\120\079\072\010\100\120\114\099\027\015\079\040")

-- WorksWithList for object commands --
_qmo.Commands._WkRvx.WorksWithList = {}
_T1D.Commands._aY6.WorksWithList = {}

-- functions --
function _YdGE4:OnStart()
	_Urwigo.MessageBox{
		Text = _PkY("\115\068\072\078\102\027\114\048\091\027\114\050\100\091\068\114\079\050\027\054\114\111\027\114\066\100\091\072\114\099\027\114\025\079\010\062\027\114\091\120\027\114\072\062\079\050\027\062\068\027\027\114\027\120\114\045\079\114\102\100\045\107\079\066\120\010\027\040\032\112\063\122\016\010\062\010\066\027\100\120\068\078\120\100\091\068\114\099\100\120\102\114\050\027\062\068\114\111\079\114\107\062\027\045\010\027\062\027\114\054\100\120\027\035\035\035"), 
		Media = _e8My, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _k9a)
			end
		end
	}
end
function _YdGE4:OnRestore()
end
function _k9a:OnEnter()
	_Bfay = _PkY("\022\011\090\079")
	_Urwigo.Dialog(false, {
		{
			Text = _PkY("\113\100\100\068\091\068\114\050\100\091\068\114\068\100\091\081\079\010\072\027\114\091\120\114\024\100\120\114\099\027\107\079\062\072\067\032\112\063\122\087\079\114\062\027\068\027\062\050\027\114\025\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\114\027\068\072\114\091\120\114\027\120\099\062\100\010\072\114\099\027\114\107\062\027\099\010\111\027\102\072\010\100\120\114\107\100\091\062\114\111\079\114\107\027\102\081\027\035\114\073\050\027\102\114\107\111\091\068\114\099\027\114\008\104\044\044\044\114\111\079\102\068\114\027\072\114\090\114\062\010\050\010\027\062\027\068\114\062\027\107\079\062\072\010\068\114\099\079\120\068\114\008\051\114\068\027\102\072\027\091\062\068\114\099\041\081\027\024\027\062\066\027\045\027\120\072\104\114\111\079\114\062\027\068\027\062\050\027\114\025\079\091\120\010\048\091\027\114\100\025\025\062\027\114\091\120\027\114\099\010\050\027\062\068\010\072\027\114\010\120\072\027\062\027\068\068\079\120\072\027\114\107\100\091\062\114\072\100\091\072\027\068\114\111\027\068\114\102\079\072\027\066\100\062\010\027\068\114\099\027\114\107\027\102\081\027\091\062\068\035\114\087\027\114\107\100\010\068\068\100\120\114\027\068\072\114\099\100\120\102\114\010\120\099\010\066\027\120\027\114\107\079\062\072\100\091\072\035"), 
			Media = _Xikb
		}, 
		{
			Text = _PkY("\018\100\127\027\054\114\107\062\091\099\027\120\072\068\067\114\069\120\024\068\107\064\042\111\091\068\010\027\091\062\068\114\099\027\114\045\027\068\114\102\100\111\111\027\066\091\027\068\114\113\100\100\068\027\078\089\100\107\068\114\068\100\120\072\114\079\114\111\041\079\025\025\091\072\035\032\112\063\122\013\120\027\114\107\027\072\010\072\027\114\048\091\027\068\072\010\100\120\114\107\100\091\062\114\079\102\072\010\050\027\062\114\111\079\114\107\062\100\102\081\079\010\120\027\114\054\100\120\027\040"), 
			Media = _Xikb, 
			Buttons = {
				_PkY("\123\126\126\023\023\073\079\079\035\035\035")
			}
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_O_9KF)
		end)
	end)
end
function _k9a:OnExit()
	_Bfay = _PkY("\022\011\090\079")
	_kV8.Active = true
	Danatisy:MoveTo(_mqp)
	_mqp.Active = true
	_Urwigo.Dialog(false, {
		{
			Text = _PkY("\014\027\114\068\091\010\068\114\045\079\010\120\072\027\120\079\120\072\114\018\091\107\027\062\114\113\100\100\068\091\068\067\032\112\063\122\037\100\091\068\114\050\100\010\102\010\114\027\120\114\062\100\091\072\027\114\050\027\062\068\114\111\027\114\120\100\062\099\035\114\069\120\024\068\107\064\089\027\072\072\027\114\079\091\072\100\062\100\091\072\027\114\068\027\062\079\114\024\010\027\120\072\100\072\114\102\100\045\107\111\027\072\027\027\114\027\072\114\068\027\062\079\114\079\114\077\114\050\100\010\027\068\114\099\010\050\010\068\027\027\068\035\114\069\120\024\068\107\064\042\100\091\062\114\050\100\072\062\027\114\079\066\062\027\045\027\120\072\104\114\015\041\079\010\114\107\027\120\068\027\114\050\100\091\068\114\079\102\102\100\045\107\079\066\120\027\062\114\107\100\091\062\114\111\027\068\114\107\062\100\102\081\079\010\120\068\114\011\010\111\100\045\027\072\062\027\068\035\114\042\079\062\114\068\027\102\091\062\010\072\027\104\114\111\079\010\068\068\027\054\114\050\100\072\062\027\114\107\079\068\068\079\066\027\062\114\068\091\010\050\062\027\114\111\027\114\099\027\062\100\091\111\027\045\027\120\072\114\099\091\114\015\027\091\035\032\112\063\122\089\081\079\048\091\027\114\079\120\120\027\027\104\114\028\104\003\114\045\010\111\111\010\100\120\114\099\027\114\107\027\062\068\100\120\120\027\068\114\072\062\079\050\027\062\068\027\120\072\114\111\079\114\063\027\068\027\062\050\027\114\025\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\035\032\112\063\122\013\120\114\107\027\091\114\099\041\081\010\068\072\100\010\062\027\114\068\091\062\114\102\027\072\072\027\114\062\100\091\072\027\035\035\035"), 
			Media = _s03mF
		}, 
		{
			Text = _PkY("\087\027\114\102\081\027\045\010\120\114\099\027\068\114\014\027\068\091\010\072\027\068\104\114\107\062\027\045\010\027\062\114\102\081\027\045\010\120\114\079\114\072\062\079\050\027\062\068\027\062\114\111\027\114\068\027\102\072\027\091\062\104\114\027\068\072\114\099\027\025\062\010\102\081\027\114\027\120\114\028\103\003\103\114\069\120\024\068\107\064\027\072\114\062\027\111\010\027\114\053\091\027\024\027\102\114\079\091\114\111\079\102\114\018\079\010\120\072\078\014\027\079\120\114\027\120\114\072\062\100\010\068\114\015\100\091\062\068\114\027\120\114\107\079\068\068\079\120\072\114\107\079\062\114\111\027\114\111\079\102\114\018\079\010\120\072\078\089\081\079\062\111\027\068\104\114\111\079\114\050\079\111\111\027\027\114\099\027\114\111\079\114\062\010\050\010\027\062\027\114\014\079\102\048\091\027\068\078\089\079\062\072\010\027\062\114\015\091\068\048\091\041\079\091\114\111\079\102\114\014\079\102\048\091\027\068\078\089\079\062\072\010\027\062\104\114\111\079\114\062\010\050\010\027\062\027\114\042\010\011\079\091\024\079\104\114\111\079\114\062\010\050\010\027\062\027\114\079\091\098\114\115\102\100\062\102\027\068\114\027\072\114\111\079\114\062\010\050\010\027\062\027\114\113\027\072\079\024\027\072\102\081\100\091\079\120\027\035\032\112\063\122\087\027\114\107\062\027\045\010\027\062\114\102\081\027\045\010\120\114\107\111\091\068\114\100\091\114\045\100\010\120\068\114\102\079\062\062\100\068\068\079\024\111\027\114\048\091\041\100\120\114\079\107\107\027\111\079\010\072\114\111\079\114\001\062\100\091\072\027\114\099\027\114\053\091\027\024\027\102\001\114\107\027\062\045\027\072\114\099\027\068\114\028\051\051\028\114\099\027\114\062\027\111\010\027\062\114\093\027\024\027\062\072\050\010\111\111\027\114\079\091\114\111\079\102\114\018\079\010\120\072\078\014\027\079\120\114\079\114\053\091\027\024\027\102\114\027\120\114\077\044\114\081\027\091\062\027\068\035\114\013\120\114\027\045\024\062\079\120\102\081\027\045\027\120\072\114\050\027\062\068\114\089\081\010\102\100\091\072\010\045\010\114\027\068\072\114\102\100\120\068\072\062\091\010\072\114\027\120\114\028\051\051\008\035\114\087\079\114\062\027\068\027\062\050\027\114\079\114\027\072\027\114\102\062\027\027\027\114\027\120\114\028\051\090\059\114\068\100\091\068\114\111\041\079\107\107\027\111\111\079\072\010\100\120\114\099\027\114\001\042\079\062\102\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\001\035")
		}, 
		{
			Text = _PkY("\115\120\114\028\090\077\077\114\027\072\114\028\090\077\059\104\114\099\027\068\114\072\062\079\050\079\091\098\114\099\041\079\062\107\027\120\072\079\066\027\114\107\027\062\045\027\072\072\027\120\072\114\099\027\114\045\027\072\072\062\027\114\027\120\114\107\111\079\102\027\114\111\079\114\062\100\091\072\027\114\079\102\072\091\027\111\111\027\114\080\062\100\091\072\027\114\028\003\059\109\114\010\120\079\091\066\091\062\027\027\114\027\120\114\028\090\077\051\035\114\069\120\024\068\107\064\087\027\114\107\079\062\102\114\027\072\079\120\072\114\099\041\079\102\102\027\068\114\111\010\045\010\072\027\104\114\010\111\114\127\114\079\050\079\010\072\114\099\027\068\114\024\079\062\062\010\027\062\027\068\114\079\091\098\114\072\062\100\010\068\114\027\120\072\062\027\027\068\114\099\027\114\111\079\114\062\100\091\072\027\114\107\100\091\062\114\050\027\062\010\025\010\027\062\114\111\027\068\114\079\111\111\027\062\078\050\027\120\091\027\068\035\114\089\027\068\114\024\079\062\062\010\027\062\027\068\114\068\027\062\100\120\072\114\027\111\010\045\010\120\027\027\068\114\027\120\114\028\090\003\003\035\114\123\120\114\062\027\072\062\100\091\050\027\114\079\091\114\102\027\120\072\062\027\114\099\091\114\072\062\079\015\027\072\114\091\120\027\114\081\079\111\072\027\114\062\100\091\072\010\027\062\027\114\079\050\027\102\114\111\027\114\062\027\068\072\079\091\062\079\120\072\114\087\041\115\072\079\107\027\104\114\068\010\072\091\027\114\068\091\062\114\111\027\068\114\024\027\062\066\027\068\114\099\091\114\111\079\102\114\014\079\102\048\091\027\068\078\089\079\062\072\010\027\062\104\114\027\072\114\111\027\114\107\100\068\072\027\114\099\027\114\111\079\114\042\100\111\010\102\027\114\107\062\100\050\010\120\102\010\079\111\027\035\114\073\107\062\027\068\114\091\120\114\010\120\102\027\120\099\010\027\104\114\102\027\091\098\078\102\010\114\068\027\062\100\120\072\114\099\027\045\100\111\010\068\114\027\120\114\008\044\044\059\035\114\115\120\114\008\044\044\090\104\114\100\120\114\127\114\062\027\072\062\100\091\050\027\114\091\120\027\114\050\010\027\010\111\111\027\114\102\081\079\107\027\111\111\027\104\114\107\111\091\068\010\027\091\062\068\114\102\081\079\111\027\072\068\104\114\099\027\068\114\062\027\068\072\079\091\062\079\120\072\068\114\025\062\079\120\102\081\010\068\027\068\114\062\027\102\100\120\068\072\062\091\010\072\068\104\114\111\027\114\107\100\068\072\027\114\099\027\114\111\079\114\042\079\072\062\100\091\010\111\111\027\114\018\027\102\100\091\062\068\114\080\091\120\027\114\091\120\010\072\027\114\068\107\027\102\010\079\111\027\114\099\091\114\113\010\120\010\068\072\027\062\027\114\099\027\068\114\105\062\079\120\068\107\100\062\072\068\114\099\091\114\053\091\027\024\027\102\114\068\107\027\102\010\079\111\010\068\027\027\114\099\079\120\068\114\111\079\114\099\027\068\010\120\102\079\062\102\027\062\079\072\010\100\120\114\099\027\068\114\050\027\081\010\102\091\111\027\068\114\079\102\102\010\099\027\120\072\027\068\114\099\079\120\068\114\111\079\114\062\027\068\027\062\050\027\114\121\079\091\120\010\048\091\027\109\104\114\091\120\114\050\027\081\010\102\091\111\027\114\079\045\024\091\111\079\120\102\010\027\062\114\027\072\114\091\120\027\114\102\079\068\027\062\120\027\114\099\027\114\111\079\114\089\105\073\053\035")
		}, 
		{
			Text = _PkY("\115\120\114\015\091\010\111\111\027\072\114\028\090\059\008\104\114\091\120\027\114\068\072\079\072\010\100\120\114\062\079\099\079\062\114\099\027\114\111\079\114\111\010\066\120\027\114\042\010\120\027\072\062\027\027\114\079\114\027\072\027\114\027\072\079\024\111\010\027\114\079\091\114\045\100\120\072\114\073\107\010\102\079\104\114\079\091\114\102\027\120\072\062\027\114\099\027\114\111\079\114\062\027\068\027\062\050\027\114\080\062\100\091\072\027\114\028\103\090\109\104\114\099\079\120\068\114\111\027\114\102\079\099\062\027\114\099\027\114\111\041\027\072\079\024\111\010\068\068\027\045\027\120\072\114\099\041\091\120\027\114\111\010\066\120\027\114\099\027\114\099\027\025\027\120\068\027\114\099\027\114\111\041\073\045\027\062\010\048\091\027\114\099\091\114\126\100\062\099\114\102\100\120\072\062\027\114\111\027\068\114\024\100\045\024\079\062\099\010\027\062\068\114\107\062\100\050\027\120\079\120\072\114\099\041\013\120\010\100\120\114\068\100\050\010\027\072\010\048\091\027\035\114\087\079\114\068\072\079\072\010\100\120\114\062\079\099\079\062\114\079\114\027\072\027\114\100\025\025\010\102\010\027\111\111\027\045\027\120\072\114\025\027\062\045\027\027\114\027\120\114\028\090\090\052\035\032\112\063\122\115\120\114\028\090\051\028\104\114\111\079\114\062\027\068\027\062\050\027\114\079\114\027\072\027\114\079\045\107\091\072\027\027\114\099\027\114\099\027\091\098\114\107\100\062\072\010\100\120\068\114\099\027\114\068\100\120\114\072\027\062\062\010\072\100\010\062\027\114\079\114\068\079\114\024\100\062\099\091\062\027\114\068\091\099\114\027\072\114\079\114\068\079\114\024\100\062\099\091\062\027\114\027\068\072\114\107\100\091\062\114\107\027\062\045\027\072\072\062\027\114\111\079\114\102\062\027\079\072\010\100\120\104\114\062\027\068\107\027\102\072\010\050\027\045\027\120\072\104\114\099\091\114\042\079\062\102\114\120\079\072\010\100\120\079\111\114\099\027\114\111\079\114\014\079\102\048\091\027\068\078\089\079\062\072\010\027\062\114\027\072\114\099\091\114\042\079\062\102\114\120\079\072\010\100\120\079\111\114\099\027\068\114\020\062\079\120\099\068\078\014\079\062\099\010\120\068\035")
		}
	}, function(action)
		_Urwigo.MessageBox{
			Text = _PkY("\042\100\091\062\114\079\025\025\010\102\081\027\062\114\111\079\114\054\100\120\027\114\001\087\041\115\072\079\107\027\001\104\114\079\107\107\091\127\027\054\114\068\091\062\114\111\027\114\024\100\091\072\100\120\035\035\035"), 
			Buttons = {
				_PkY("\087\041\115\072\079\107\027\035\035\035")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _mqp)
					--[[Ajout de sauvegarde automatique le 17 mai 2011.]]
					_YdGE4:RequestSync()
				end
			end
		}
	end)
end
function _mqp:OnEnter()
	_Bfay = _PkY("\022\045\048\107")
	_Urwigo.Dialog(false, {
		{
			Text = _PkY("\089\041\027\068\072\114\027\120\102\100\062\027\114\045\100\010\104\114\045\079\010\068\114\015\041\079\010\114\099\091\114\062\027\050\027\072\010\062\114\045\100\120\114\072\079\024\111\010\027\062\114\107\100\091\062\114\050\100\091\068\035\114\115\120\072\062\027\054\114\050\100\010\062\067\114\118\111\114\127\114\027\120\114\079\114\107\100\091\062\114\072\100\091\068\114\111\027\068\114\066\100\091\072\068\114\010\102\010\035"), 
			Media = _50eiy
		}, 
		{
			Text = _PkY("\014\027\114\068\091\010\068\114\102\027\111\091\010\114\048\091\010\114\062\027\068\072\027\114\099\027\114\111\041\010\120\102\027\120\099\010\027\114\099\027\114\111\041\079\120\102\010\027\120\120\027\114\001\115\072\079\107\027\001\035\032\112\063\122\073\114\111\041\079\091\072\100\045\120\027\104\114\015\027\114\045\041\079\045\091\068\027\114\079\114\025\079\010\062\027\114\099\027\068\114\093\100\091\078\093\100\091\114\079\091\098\114\107\079\068\068\079\120\072\068\035\032\112\063\122\013\120\114\107\027\091\114\099\041\081\010\068\072\100\010\062\027\035\035\035\032\112\063\122"), 
			Media = _u7Di
		}, 
		{
			Text = _PkY("\087\041\115\072\079\107\027\114\027\068\072\114\091\120\027\114\081\079\111\072\027\114\062\100\091\072\010\027\062\027\114\072\062\027\068\114\025\062\027\048\091\027\120\072\027\027\114\068\010\072\091\027\027\114\079\114\045\010\078\102\081\027\045\010\120\114\027\120\072\062\027\114\053\091\027\024\027\102\114\027\072\114\111\079\114\062\027\066\010\100\120\114\099\091\114\018\079\066\091\027\120\079\127\078\087\079\102\078\018\079\010\120\072\078\014\027\079\120\104\114\068\091\062\114\111\027\068\114\062\010\050\027\068\114\099\091\114\087\079\102\114\014\079\102\048\091\027\068\078\089\079\062\072\010\027\062\035\032\112\063\122\089\100\120\068\072\062\091\010\072\027\114\050\027\062\068\114\028\090\103\003\104\114\027\111\111\027\114\079\114\027\072\027\114\027\120\072\010\027\062\027\045\027\120\072\114\062\079\068\027\027\114\107\079\062\114\091\120\114\050\010\100\111\027\120\072\114\010\120\102\027\120\099\010\027\114\111\027\114\059\114\068\027\107\072\027\045\024\062\027\114\008\044\044\052\035\114\105\027\045\107\100\062\079\010\062\027\045\027\120\072\114\062\027\045\107\111\079\102\027\027\114\107\079\062\114\091\120\114\107\027\072\010\072\114\099\027\107\079\120\120\027\091\062\104\114\027\111\111\027\114\079\114\027\072\027\114\062\027\102\100\120\068\072\062\091\010\072\027\114\027\120\114\008\044\044\103\035\114\123\120\114\062\027\072\062\100\091\050\027\114\027\066\079\111\027\045\027\120\072\114\068\091\062\114\107\111\079\102\027\114\091\120\027\114\068\072\079\072\010\100\120\078\068\027\062\050\010\102\027\114\100\025\025\062\079\120\072\114\091\120\114\068\027\062\050\010\102\027\114\099\027\114\062\027\045\100\062\048\091\079\066\027\114\079\010\120\068\010\114\048\091\027\114\099\027\068\114\062\027\068\010\099\027\120\102\027\068\114\081\027\024\027\062\066\027\079\120\072\114\111\027\068\114\072\062\079\050\079\010\111\111\027\091\062\068\035")
		}, 
		{
			Text = _PkY("\087\041\081\010\050\027\062\114\010\102\010\104\114\010\111\114\025\079\010\072\114\025\062\100\010\099\114\027\072\114\102\041\027\068\072\114\107\100\091\062\114\102\027\072\072\027\114\062\079\010\068\100\120\114\048\091\027\114\015\041\079\010\114\062\027\050\027\072\091\114\091\120\114\081\079\024\010\072\114\107\111\091\068\114\102\081\079\091\099\035\114\069\120\024\068\107\064\118\111\114\120\041\027\068\072\114\107\079\068\114\062\079\062\027\114\048\091\041\010\111\114\127\114\079\010\072\114\099\027\114\111\079\114\120\027\010\066\027\114\010\102\010\114\079\114\107\079\062\072\010\062\114\099\027\114\068\027\107\072\027\045\024\062\027\114\027\072\114\015\091\068\048\091\041\079\091\114\045\100\010\068\114\099\027\114\045\079\010\035\032\112\063\122\089\100\120\072\010\120\091\100\120\068\114\120\100\072\062\027\114\062\100\091\072\027\114\027\072\114\068\091\062\050\027\010\111\111\027\054\114\050\100\072\062\027\114\062\027\102\027\107\072\027\091\062\114\020\042\018\114\107\100\091\062\114\111\079\114\107\062\100\102\081\079\010\120\027\114\027\072\079\107\027\035\035\035"), 
			Media = _bNLS
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _Wpqxg)
	end)
	_kV8.Complete = true
	_k9a.Active = false
	_k9a.Visible = false
	_MKu7.Active = true
	_Wpqxg.Active = true
	_Wpqxg.Visible = true
	Danatisy:MoveTo(_Wpqxg)
	--[[Ajout de sauvegarde automatique le 17 mai 2011.]]
	_YdGE4:RequestSync()
end
function _Wpqxg:OnEnter()
	_Bfay = _PkY("\022\023\107\048\098\066")
	_mqp.Active = false
	_mqp.Visible = false
	_Urwigo.MessageBox{
		Text = _PkY("\037\100\091\068\114\079\107\107\062\100\102\081\027\054\114\099\027\114\111\041\010\120\072\027\062\068\027\102\072\010\100\120\114\099\027\068\114\062\100\091\072\027\068\114\028\103\090\114\027\072\114\028\003\059\035\114\118\111\114\025\079\091\099\062\079\114\102\081\100\010\068\010\062\114\091\120\027\114\099\027\068\072\010\120\079\072\010\100\120\125\114\093\027\024\027\062\072\050\010\111\111\027\114\100\091\114\018\079\066\091\027\120\079\127\035"), 
		Media = _DXw, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_Pcdc)
				end)
			end
		end
	}
end
function _Wpqxg:OnExit()
	_Bfay = _PkY("\022\023\107\048\098\066")
	_MKu7.Complete = true
	_sjyn.Active = true
	_F_wv.Active = true
	_Urwigo.MessageBox{
		Text = _PkY("\063\027\120\099\100\120\068\078\120\100\091\068\114\050\027\062\068\114\120\100\072\062\027\114\099\027\068\072\010\120\079\072\010\100\120\035\032\112\063\122\042\027\120\099\079\120\072\114\048\091\041\100\120\114\062\100\091\111\027\104\114\091\120\114\107\027\091\114\099\041\081\010\068\072\100\010\062\027\035\035\035\032\112\063\122\087\079\114\062\100\091\072\027\114\028\003\059\114\072\010\062\027\114\068\027\068\114\100\062\010\066\010\120\027\068\114\099\027\068\114\107\062\027\045\010\027\062\068\114\102\081\027\045\010\120\068\114\099\027\114\072\027\062\062\027\114\099\027\114\111\079\114\025\010\120\114\099\091\114\086\118\086\027\114\068\010\027\102\111\027\035\114\115\111\111\027\114\025\091\072\114\079\068\107\081\079\111\072\027\027\114\099\079\120\068\114\111\027\068\114\079\120\120\027\027\068\114\028\090\077\044\104\114\069\120\024\068\107\064\010\120\079\091\066\091\062\027\027\114\100\025\025\010\102\010\027\111\111\027\045\027\120\072\114\027\120\114\028\090\059\028\114\027\072\114\107\062\010\068\114\111\027\114\120\100\045\114\099\027\114\001\028\003\059\001\114\027\120\114\028\090\003\059\035\032\112\063\122\115\111\111\027\114\079\114\027\072\027\114\120\100\045\045\027\027\114\024\100\091\111\027\050\079\062\099\114\105\079\111\024\100\072\114\027\120\114\111\041\081\100\120\120\027\091\062\114\099\041\073\120\072\100\120\010\100\114\105\079\111\024\100\072\104\114\099\027\107\091\072\027\114\099\027\114\089\081\010\102\100\091\072\010\045\010\114\027\072\114\045\010\120\010\068\072\062\027\114\099\027\114\111\079\114\037\100\010\062\010\027\114\068\100\091\068\114\016\091\107\111\027\068\068\010\068\035\032\112\063\122\087\079\114\062\100\091\072\027\114\028\103\090\114\027\068\072\114\091\120\027\114\062\100\091\072\027\114\120\079\072\010\100\120\079\111\027\114\099\091\114\053\091\027\024\027\102\114\099\041\100\062\010\027\120\072\079\072\010\100\120\114\120\100\062\099\078\068\091\099\114\099\091\114\018\079\066\091\027\120\079\127\078\087\079\102\078\018\079\010\120\072\078\014\027\079\120\035\114\115\111\111\027\114\099\027\024\091\072\027\114\027\120\114\107\111\027\010\120\114\102\100\027\091\062\114\099\027\114\111\079\114\063\027\068\027\062\050\027\114\025\079\091\120\010\048\091\027\114\099\027\068\114\087\079\091\062\027\120\072\010\099\027\068\114\100\091\114\027\111\111\027\114\068\027\114\068\027\107\079\062\027\114\099\027\114\111\079\114\062\100\091\072\027\114\028\003\059\114\079\091\114\011\045\114\028\103\103\035\114\073\114\107\079\062\072\010\062\114\099\041\093\027\024\027\062\072\050\010\111\111\027\104\114\027\111\111\027\114\025\079\010\072\114\091\120\027\114\024\100\091\102\111\027\114\068\091\062\114\027\111\111\027\078\045\027\045\027\114\079\091\072\100\091\062\114\099\091\114\087\079\102\078\018\079\010\120\072\078\014\027\079\120\035"), 
		Media = _DXw, 
		Buttons = {
			_PkY("\016\027\068\072\010\120\079\072\010\100\120\040\040\040")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_bII)
				end)
				--[[Ajout de sauvegarde automatique le 17 mai 2011.]]
				_YdGE4:RequestSync()
			end
		end
	}
end
function _S0H93:OnEnter()
	_Bfay = _PkY("\022\018\044\093\090\052")
	__DsEl.Complete = true
	_nTIRS:MoveTo(_S0H93)
	_nTIRS.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _PkY("\112\010\027\120\050\027\120\091\114\079\114\018\079\066\091\027\120\079\127\035\114\069\120\024\068\107\064\018\010\114\050\100\091\068\114\027\072\027\068\114\010\102\010\104\114\102\041\027\068\072\114\048\091\027\114\111\079\114\072\062\079\050\027\062\068\027\027\114\068\041\027\068\072\114\072\027\062\045\010\120\027\027\114\027\120\114\072\100\091\072\027\114\068\027\102\091\062\010\072\027\035\114\069\120\024\068\107\064\016\079\120\068\114\102\027\072\114\001\115\111\079\120\001\114\099\041\027\120\072\081\100\091\068\010\079\068\045\027\104\114\015\027\114\050\100\091\068\114\027\120\102\100\091\062\079\066\027\114\079\114\102\100\120\072\010\120\091\027\062\114\050\100\072\062\027\114\066\027\100\072\100\091\062\010\068\045\027\114\099\079\120\068\114\120\100\072\062\027\114\062\027\066\010\100\120\035"), 
			Media = _e8My
		}, 
		{
			Text = _PkY("\105\062\100\010\068\114\079\091\072\062\027\068\114\102\079\062\072\100\091\102\081\027\068\114\023\081\027\062\010\066\100\114\068\100\120\072\114\079\114\050\100\072\062\027\114\099\010\068\107\100\068\010\072\010\100\120\114\099\079\120\068\114\111\027\068\114\111\010\045\010\072\027\068\114\099\027\114\111\041\079\062\100\120\099\010\068\068\027\045\027\120\072\114\099\027\114\089\081\010\102\100\091\072\010\045\010\125\032\112\063\122\028\109\114\087\079\114\042\091\111\107\027\062\010\027\104\114\091\120\027\114\102\079\062\072\100\091\102\081\027\114\027\120\114\077\114\054\100\120\027\068\114\048\091\010\114\107\062\027\120\099\114\027\120\050\010\062\100\120\114\008\044\114\045\010\120\091\072\027\068\064\032\112\063\122\008\109\114\087\027\114\042\027\072\010\072\114\042\062\010\120\102\027\125\114\091\120\027\114\102\079\062\072\100\091\102\081\027\114\001\105\100\091\062\114\099\027\114\050\010\111\111\027\001\114\027\120\114\090\114\054\100\120\027\068\114\048\091\010\104\114\027\111\111\027\104\114\107\027\091\072\114\107\062\027\120\099\062\027\114\015\091\068\048\091\041\079\114\008\114\081\027\091\062\027\068\114\068\010\114\050\100\091\068\114\027\072\027\068\114\079\114\107\010\027\099\068\035\032\112\063\122\052\109\114\087\079\114\113\079\010\068\100\120\114\099\027\114\018\079\010\120\072\078\126\010\102\100\111\079\068\035\114\013\120\114\015\027\091\114\001\014\100\091\027\062\114\042\079\062\072\100\091\072\001\114\079\114\089\081\010\102\100\091\072\010\045\010\114\027\072\114\091\120\027\114\102\079\102\081\027\114\079\114\111\079\114\025\010\120\079\111\027\035\114\089\100\045\107\072\027\054\114\052\044\114\045\010\120\091\072\027\068\035"), 
			Media = _s03mF
		}, 
		{
			Text = _PkY("\014\041\027\068\107\027\062\027\114\048\091\027\114\050\100\091\068\114\079\050\027\054\114\079\010\045\027\114\050\100\072\062\027\114\027\098\107\027\062\010\027\120\102\027\114\027\072\114\048\091\041\027\111\111\027\114\079\114\068\091\114\062\027\120\099\062\027\114\111\041\091\072\010\111\111\027\114\079\114\111\041\079\066\062\027\079\024\111\027\035\114\014\041\079\010\114\107\111\079\102\027\114\091\120\027\114\102\079\102\081\027\114\099\079\120\068\114\111\027\068\114\027\120\050\010\062\100\120\068\035\114\089\081\100\010\068\010\062\114\001\089\079\102\081\027\114\089\081\010\102\100\091\072\010\045\010\001\114\099\079\120\068\114\111\079\114\018\027\102\072\010\100\120\114\001\037\100\091\068\114\050\100\127\027\054\001\114\107\100\091\062\114\072\062\100\091\050\027\062\114\111\079\114\102\079\102\081\027\114\027\072\114\068\010\066\120\027\062\114\111\027\114\102\079\062\120\027\072\114\099\027\114\050\010\068\010\072\027\068\035"), 
			Media = _e8My
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _nTIRS)
	end)
end
function _S0H93:OnExit()
	_Bfay = _PkY("\022\018\044\093\090\052")
	_YdGE4.Complete = true
	_oL1B:MoveTo(Player)
	_Urwigo.MessageBox{
		Text = _PkY("\113\027\062\102\010\114\099\041\079\050\100\010\062\114\015\100\091\027\114\102\027\072\072\027\114\023\081\027\062\010\066\100\035\114\014\041\079\010\114\107\111\079\102\027\114\091\120\114\118\072\027\045\114\099\079\120\068\114\111\041\010\120\050\027\120\072\079\010\062\027\114\099\091\114\045\027\120\091\114\107\062\010\120\102\010\107\079\111\114\107\100\091\062\114\111\027\114\099\027\050\027\062\062\100\091\010\111\111\079\066\027\035\114\037\100\072\062\027\114\102\100\099\027\114\001\013\120\111\100\102\011\001\114\068\027\062\079\125\114")..string.sub(Player.CompletionCode, 1, 15), 
		Media = _e8My, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _EXIR)
			end
		end
	}
	--[[Ajout de sauvegarde automatique le 17 mai 2011.]]
	_YdGE4:RequestSync()
end
function _S78nj:OnEnter()
	_Bfay = _PkY("\022\018\003\051\120\015")
	_XqUz.Complete = true
	_U6j:MoveTo(_S78nj)
	_U6j.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _PkY("\112\010\027\120\050\027\120\091\114\079\114\093\027\024\027\062\072\050\010\111\111\027\035\114\069\120\024\068\107\064\018\010\114\050\100\091\068\114\027\072\027\068\114\010\102\010\104\114\102\041\027\068\072\114\048\091\027\114\111\079\114\072\062\079\050\027\062\068\027\027\114\068\041\027\068\072\114\072\027\062\045\010\120\027\027\114\027\120\114\072\100\091\072\027\114\068\027\102\091\062\010\072\027\035\114\069\120\024\068\107\064\016\079\120\068\114\102\027\072\114\001\115\111\079\120\001\114\099\041\027\120\072\081\100\091\068\010\079\068\045\027\104\114\015\027\114\050\100\091\068\114\027\120\102\100\091\062\079\066\027\114\079\114\102\100\120\072\010\120\091\027\062\114\050\100\072\062\027\114\066\027\100\072\100\091\062\010\068\045\027\114\099\079\120\068\114\120\100\072\062\027\114\062\027\066\010\100\120\035"), 
			Media = _e8My
		}, 
		{
			Text = _PkY("\016\027\091\098\114\079\091\072\062\027\068\114\102\079\062\072\100\091\102\081\027\068\114\023\081\027\062\010\066\100\114\068\100\120\072\114\079\114\050\100\072\062\027\114\099\010\068\107\100\068\010\072\010\100\120\114\079\114\089\081\010\102\100\091\072\010\045\010\114\068\010\114\050\100\091\068\114\079\111\111\027\054\114\107\079\062\114\111\079\125\032\112\063\122\028\109\114\087\079\114\042\091\111\107\027\062\010\027\104\114\091\120\027\114\102\079\062\072\100\091\102\081\027\114\027\120\114\077\114\054\100\120\027\068\114\048\091\010\114\107\062\027\120\099\114\027\120\050\010\062\100\120\114\008\044\114\045\010\120\091\072\027\068\064\032\112\063\122\008\109\114\087\027\114\042\027\072\010\072\114\042\062\010\120\102\027\125\114\091\120\027\114\102\079\062\072\100\091\102\081\027\114\001\105\100\091\062\114\099\027\114\050\010\111\111\027\001\114\027\120\114\090\114\054\100\120\027\068\114\048\091\010\104\114\027\111\111\027\104\114\107\027\091\072\114\107\062\027\120\099\062\027\114\015\091\068\048\091\041\079\114\008\114\081\027\091\062\027\068\114\068\010\114\050\100\091\068\114\027\072\027\068\114\079\114\107\010\027\099\068\035\032\112\063\122\052\109\114\087\079\114\113\079\010\068\100\120\114\099\027\114\018\079\010\120\072\078\126\010\102\100\111\079\068\035\114\013\120\114\015\027\091\114\001\014\100\091\027\062\114\042\079\062\072\100\091\072\001\114\079\114\089\081\010\102\100\091\072\010\045\010\114\027\072\114\091\120\027\114\102\079\102\081\027\114\079\114\111\079\114\025\010\120\079\111\027\035\114\089\100\045\107\072\027\054\114\052\044\114\045\010\120\091\072\027\068\035"), 
			Media = _s03mF
		}, 
		{
			Text = _PkY("\014\041\027\068\107\027\062\027\114\048\091\027\114\050\100\091\068\114\079\050\027\054\114\079\010\045\027\114\050\100\072\062\027\114\027\098\107\027\062\010\027\120\102\027\114\027\072\114\048\091\041\027\111\111\027\114\079\114\068\091\114\062\027\120\099\062\027\114\111\041\091\072\010\111\111\027\114\079\114\111\041\079\066\062\027\079\024\111\027\035\114\014\041\079\010\114\107\111\079\102\027\114\091\120\027\114\102\079\102\081\027\114\099\079\120\068\114\111\027\068\114\027\120\050\010\062\100\120\068\035\114\089\081\100\010\068\010\062\114\001\089\079\102\081\027\114\093\027\024\027\062\072\050\010\111\111\027\001\114\099\079\120\068\114\111\079\114\018\027\102\072\010\100\120\114\001\037\100\091\068\114\050\100\127\027\054\001\114\107\100\091\062\114\072\062\100\091\050\027\062\114\111\079\114\102\079\102\081\027\114\027\072\114\068\010\066\120\027\062\114\111\027\114\102\079\062\120\027\072\114\099\027\114\050\010\068\010\072\027\068\035"), 
			Media = _e8My
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _U6j)
	end)
end
function _S78nj:OnExit()
	_Bfay = _PkY("\022\018\003\051\120\015")
	_YdGE4.Complete = true
	_oL1B:MoveTo(Player)
	_Urwigo.MessageBox{
		Text = _PkY("\113\027\062\102\010\114\099\041\079\050\100\010\062\114\015\100\091\027\114\102\027\072\072\027\114\023\081\027\062\010\066\100\035\114\014\041\079\010\114\107\111\079\102\027\114\091\120\114\118\072\027\045\114\099\079\120\068\114\111\041\010\120\050\027\120\072\079\010\062\027\114\099\091\114\045\027\120\091\114\107\062\010\120\102\010\107\079\111\114\107\100\091\062\114\111\027\114\099\027\050\027\062\062\100\091\010\111\111\079\066\027\035\114\037\100\072\062\027\114\102\100\099\027\114\001\013\120\111\100\102\011\001\114\068\027\062\079\125\114")..string.sub(Player.CompletionCode, 1, 15), 
		Media = _e8My, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _EXIR)
			end
		end
	}
	--[[Ajout de sauvegarde automatique le 17 mai 2011.]]
	_YdGE4:RequestSync()
end
function _F_wv:OnEnter()
	_Bfay = _PkY("\022\121\022\031\050")
	_F_wv.Active = true
	_Wpqxg.Active = false
	_Wpqxg.Visible = false
	_Urwigo.Dialog(false, {
		{
			Text = _PkY("\042\111\091\068\114\048\091\027\114\048\091\027\111\048\091\027\068\114\011\010\111\100\045\027\072\062\027\068\114\079\050\079\120\072\114\099\041\079\062\062\010\050\027\062\114\079\114\089\081\010\102\100\091\072\010\045\010\035\032\112\063\122\115\120\102\100\062\027\114\091\120\114\107\027\091\114\099\041\081\010\068\072\100\010\062\027\035\035\035"), 
			Media = _SXIF
		}, 
		{
			Text = _PkY("\073\050\079\120\072\114\111\041\079\062\062\010\050\027\027\114\099\027\068\114\115\091\062\100\107\027\027\120\068\104\114\089\081\010\102\100\091\072\010\045\010\114\027\068\072\114\091\120\114\111\010\027\091\114\099\027\114\107\100\062\072\079\066\027\114\025\062\027\048\091\027\120\072\027\114\107\079\062\114\111\027\068\114\072\062\010\024\091\068\114\045\100\120\072\079\066\120\079\010\068\027\068\114\048\091\010\114\107\079\062\072\027\120\072\114\099\091\114\018\079\066\091\027\120\079\127\114\107\100\091\062\114\068\027\114\062\027\120\099\062\027\114\079\091\114\111\079\102\114\018\079\010\120\072\078\014\027\079\120\114\027\120\114\107\079\068\068\079\120\072\114\107\079\062\114\111\079\114\062\010\050\010\027\062\027\114\089\081\010\102\100\091\072\010\045\010\114\027\072\114\111\027\114\087\079\102\114\101\027\120\100\066\079\045\010\035\114\016\091\114\028\003\027\114\079\091\114\028\090\027\114\068\010\027\102\111\027\104\114\091\120\114\099\027\024\079\062\102\079\099\027\062\027\114\079\050\027\102\114\091\120\114\107\100\068\072\027\114\099\027\114\072\062\079\010\072\027\114\027\068\072\114\010\120\068\072\079\111\111\027\114\027\072\114\068\091\062\050\027\010\111\111\027\114\107\079\062\114\111\027\068\114\079\091\072\100\062\010\072\027\068\114\025\062\079\120\102\079\010\068\027\068\104\114\107\091\010\068\114\111\027\068\114\073\120\066\111\079\010\068\114\107\062\027\120\120\027\120\072\114\111\027\114\062\027\111\079\010\068\114\099\027\114\068\079\114\068\091\107\027\062\050\010\068\010\100\120\035"), 
			Media = _oMOux
		}, 
		{
			Text = _PkY("\118\111\114\025\079\091\099\062\079\114\079\072\072\027\120\099\062\027\114\111\041\010\120\068\072\079\111\111\079\072\010\100\120\114\099\027\068\114\068\102\010\027\062\010\027\068\114\099\091\114\045\079\062\102\081\079\120\099\114\099\027\114\024\100\010\068\114\042\027\072\027\062\114\113\102\087\027\100\099\114\068\091\062\114\111\079\114\063\010\050\010\027\062\027\078\099\091\078\113\100\091\111\010\120\114\027\072\114\111\079\114\063\010\050\010\027\062\027\114\089\081\010\102\100\091\072\010\045\010\114\027\120\114\028\051\077\008\114\107\100\091\062\114\048\091\027\114\099\027\024\091\072\027\114\111\079\114\102\100\111\100\120\010\068\079\072\010\100\120\114\099\091\114\072\027\062\062\010\072\100\010\062\027\114\107\079\062\114\099\027\068\114\025\079\045\010\111\111\027\068\114\099\027\114\024\091\102\081\027\062\100\120\068\104\114\099\027\114\050\100\010\072\091\062\010\027\062\068\114\027\072\114\099\027\114\025\111\100\072\072\027\091\062\068\035\114\073\114\111\079\114\025\010\120\114\099\091\114\028\090\027\114\068\010\027\102\111\027\104\114\111\041\091\062\024\079\120\010\068\079\072\010\100\120\114\068\027\114\099\027\050\027\111\100\107\107\027\114\027\072\114\089\081\010\102\100\091\072\010\045\010\114\099\027\050\010\027\120\072\114\102\081\027\025\078\111\010\027\091\114\099\027\114\102\100\045\072\027\114\027\072\114\068\010\027\066\027\114\099\041\027\050\027\102\081\027\035\114\087\027\114\102\081\027\045\010\120\114\099\027\114\025\027\062\114\079\062\062\010\050\079\120\072\114\027\120\114\028\051\090\052\114\025\079\050\100\062\010\068\027\062\079\114\111\041\027\068\068\100\062\114\010\120\099\091\068\072\062\010\027\111\114\099\027\114\111\079\114\050\010\111\111\027\035")
		}, 
		{
			Text = _PkY("\115\120\114\028\051\090\103\104\114\111\027\068\114\027\120\072\062\027\107\062\027\120\027\091\062\068\114\014\091\111\010\027\120\078\115\099\100\091\079\062\099\078\073\111\025\062\027\099\114\016\091\024\091\102\114\027\072\114\014\100\068\027\107\081\078\016\100\045\010\120\010\048\091\027\114\020\091\079\127\114\025\100\120\099\027\120\072\114\111\079\114\089\100\045\107\079\066\120\010\027\114\099\027\114\042\091\111\107\027\114\099\027\114\089\081\010\102\100\091\072\010\045\010\104\114\091\120\027\114\027\120\072\062\027\107\062\010\068\027\114\045\091\111\072\010\120\079\072\010\100\120\079\111\027\114\100\027\091\050\062\079\120\072\114\099\079\120\068\114\111\079\114\025\079\024\062\010\102\079\072\010\100\120\114\099\027\114\111\079\114\107\091\111\107\027\114\099\027\114\024\100\010\068\035\114\087\027\114\107\062\027\045\010\027\062\114\045\100\091\111\010\120\114\099\027\114\111\079\114\042\091\111\107\027\062\010\027\114\099\027\114\089\081\010\102\100\091\072\010\045\010\114\027\068\072\114\045\010\068\114\027\120\114\045\079\062\102\081\027\114\027\120\114\028\051\090\051\035\114\087\027\114\068\091\102\102\027\068\114\099\027\114\111\041\027\120\072\062\027\107\062\010\068\027\114\027\120\072\062\079\010\120\027\114\091\120\027\114\102\062\100\010\068\068\079\120\102\027\114\062\079\107\010\099\027\114\099\027\114\111\079\114\050\010\111\111\027\114\027\072\114\111\027\114\099\027\050\027\111\100\107\107\027\045\027\120\072\114\099\027\068\114\010\120\025\062\079\068\072\062\091\102\072\091\062\027\068\114\045\091\120\010\102\010\107\079\111\027\068\114\015\091\068\048\091\027\114\099\079\120\068\114\111\027\068\114\079\120\120\027\027\068\114\028\090\008\044\035\114\087\041\079\102\072\010\050\010\072\027\114\027\102\100\120\100\045\010\048\091\027\114\099\027\114\111\079\114\062\027\066\010\100\120\114\099\091\114\111\079\102\114\018\079\010\120\072\078\014\027\079\120\114\027\068\072\114\045\079\010\120\072\027\120\091\027\114\107\079\062\114\111\041\079\062\062\010\050\027\027\114\099\027\068\114\079\111\091\045\010\120\027\062\010\027\068\114\099\027\114\111\079\114\102\100\045\107\079\066\120\010\027\114\073\111\102\079\120\114\099\079\120\068\114\111\027\068\114\079\120\120\027\027\068\114\028\090\052\044\114\027\072\114\028\090\077\044\035")
		}, 
		{
			Text = _PkY("\073\091\114\099\027\024\091\072\114\099\027\068\114\079\120\120\027\027\068\114\028\090\051\044\104\114\111\041\081\127\099\062\100\027\111\027\102\072\062\010\102\010\072\027\104\114\111\027\068\114\010\120\099\091\068\072\062\010\027\068\114\099\091\114\107\079\107\010\027\062\114\027\072\114\099\091\114\024\100\010\068\114\027\072\114\111\027\114\072\027\098\072\010\111\027\114\068\100\120\072\114\027\120\102\100\062\027\114\099\027\068\114\107\100\010\120\072\068\078\025\100\062\072\068\114\099\027\114\111\041\027\102\100\120\100\045\010\027\114\102\081\010\102\100\091\072\010\045\010\027\120\120\027\035\032\112\063\122\018\079\066\091\027\120\079\127\114\102\100\045\107\072\027\114\079\091\015\100\091\062\099\041\081\091\010\114\091\120\114\107\027\091\114\107\111\091\068\114\099\027\114\028\077\103\104\044\044\044\114\081\079\024\010\072\079\120\072\068\114\062\027\107\079\062\072\010\068\114\068\091\062\114\091\120\114\072\027\062\062\010\072\100\010\062\027\114\099\027\114\028\104\028\103\103\114\011\045\114\102\079\062\062\027\068\104\114\068\100\010\072\114\008\114\025\100\010\068\114\111\079\114\068\091\107\027\062\025\010\102\010\027\114\099\027\114\111\041\010\111\027\114\099\027\114\113\100\120\072\062\027\079\111\035"), 
			Buttons = {
				_PkY("\018\079\066\091\027\120\079\127\035\035\035")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _S0H93)
	end)
	_F_wv.Active = false
	--[[Ajout de sauvegarde automatique le 17 mai 2011.]]
	_YdGE4:RequestSync()
end
function _sjyn:OnEnter()
	_Bfay = _PkY("\022\068\015\127\120")
	_sjyn.Active = true
	_Urwigo.Dialog(false, {
		{
			Text = _PkY("\002\100\120\027\114\099\027\114\111\079\114\024\079\068\027\078\062\079\099\079\062\114\099\091\114\113\100\120\072\114\073\107\010\102\079\035\032\112\063\122\042\111\091\068\114\048\091\027\114\048\091\027\111\048\091\027\068\114\011\010\111\100\045\027\072\062\027\068\114\079\050\079\120\072\114\099\041\079\062\062\010\050\027\062\114\079\114\093\027\024\027\062\072\050\010\111\111\027\035\032\112\063\122\013\120\114\107\027\091\114\099\041\081\010\068\072\100\010\062\027\035\035\035"), 
			Media = _Ofsf
		}, 
		{
			Text = _PkY("\126\010\102\100\111\079\068\078\105\100\111\027\120\072\010\120\114\093\027\024\027\062\072\104\114\102\091\062\027\114\099\027\114\101\079\045\100\091\062\079\068\011\079\104\114\107\079\062\072\010\102\010\107\027\114\079\050\027\102\114\068\027\068\114\102\100\120\025\062\027\062\027\068\114\099\091\114\102\100\111\111\027\066\027\114\099\027\114\087\079\114\042\100\102\079\072\010\027\062\027\104\114\079\114\111\079\114\025\100\120\099\079\072\010\100\120\114\099\041\091\120\027\114\079\068\068\100\102\010\079\072\010\100\120\114\099\027\114\102\100\111\100\120\010\068\079\072\010\100\120\114\048\091\010\114\068\027\114\120\100\045\045\027\114\001\073\089\118\101\001\114\068\100\010\072\114\111\041\073\068\068\100\102\010\079\072\010\100\120\114\099\027\068\114\102\100\045\072\027\068\114\099\027\114\087\041\118\068\111\027\072\078\101\079\045\100\091\062\079\068\011\079\035\114\113\035\114\093\027\024\027\062\072\114\099\027\050\010\027\120\072\114\111\041\079\045\027\114\027\072\114\111\041\079\066\027\120\072\114\107\062\010\120\102\010\107\079\111\114\099\027\114\111\041\079\068\068\100\102\010\079\072\010\100\120\114\027\072\114\068\041\027\045\024\079\062\048\091\027\114\068\091\062\114\111\027\114\066\062\079\120\099\114\025\111\027\091\050\027\114\079\114\111\041\027\072\027\114\099\027\114\028\051\077\090\114\079\050\027\102\114\077\077\114\081\100\045\045\027\068\114\079\025\010\120\114\099\027\114\107\062\100\102\027\099\027\062\114\079\114\111\041\027\098\107\111\100\062\079\072\010\100\120\114\099\027\068\114\102\079\120\072\100\120\068\114\048\091\027\114\111\027\114\066\100\091\050\027\062\120\027\045\027\120\072\114\111\091\010\114\079\114\102\100\120\102\027\099\027\068\035"), 
			Media = _JymaI
		}, 
		{
			Text = _PkY("\089\041\027\068\072\114\099\100\120\102\114\027\120\114\028\051\077\090\114\048\091\027\114\025\091\072\114\025\100\120\099\027\027\114\111\079\114\045\091\120\010\102\010\107\079\111\010\072\027\114\099\041\093\027\024\027\062\072\050\010\111\111\027\035\114\042\062\027\045\010\027\062\027\114\079\114\027\072\062\027\114\102\100\111\100\120\010\068\027\027\114\079\091\114\087\079\102\078\018\079\010\120\072\078\014\027\079\120\104\114\102\027\072\072\027\114\045\091\120\010\102\010\107\079\111\010\072\027\114\100\025\025\062\079\010\072\114\111\041\079\068\068\010\068\027\114\099\091\114\099\027\050\027\111\100\107\107\027\045\027\120\072\114\025\091\072\091\062\114\107\079\062\114\068\079\114\102\081\091\072\027\114\099\027\068\114\073\091\111\120\079\010\027\068\104\114\068\010\072\091\027\027\114\027\120\114\107\111\027\010\120\114\102\100\027\091\062\114\099\091\114\050\010\111\111\079\066\027\035\114\089\041\027\068\072\114\079\114\102\027\072\114\027\120\099\062\100\010\072\114\048\091\027\114\068\027\114\068\100\120\072\114\027\072\079\024\111\010\068\114\111\027\068\114\045\100\091\111\010\120\068\114\079\114\068\102\010\027\114\027\072\114\079\114\025\079\062\010\120\027\104\114\120\027\102\027\068\068\079\010\062\027\068\114\079\114\111\079\114\068\091\062\050\010\027\114\099\027\068\114\107\062\027\045\010\027\062\068\114\102\100\111\100\120\068\035")
		}, 
		{
			Text = _PkY("\115\120\114\028\090\008\103\104\114\091\120\114\102\100\045\010\072\027\114\099\027\114\102\010\072\100\127\027\120\068\114\027\072\114\099\027\114\107\062\027\072\062\027\068\114\099\027\114\111\079\114\062\027\066\010\100\120\114\099\027\102\010\099\027\114\099\027\114\062\027\120\099\062\027\114\091\120\114\050\010\024\062\079\120\072\114\081\100\045\045\079\066\027\114\079\114\126\010\102\100\111\079\068\078\105\100\111\027\120\072\010\120\078\093\027\024\027\062\072\114\027\072\114\068\027\068\114\102\100\045\107\079\066\120\100\120\068\104\114\027\120\114\027\111\027\050\079\120\072\114\091\120\114\045\100\120\091\045\027\120\072\114\027\120\114\111\027\091\062\114\081\100\120\120\027\091\062\035\114\115\111\027\050\027\114\027\120\114\025\079\102\027\114\099\091\114\107\062\027\068\024\127\072\027\062\027\104\114\120\100\091\068\114\111\041\079\107\107\027\111\100\120\068\114\079\025\025\027\102\072\091\027\091\068\027\045\027\120\072\114\111\027\114\045\100\120\091\045\027\120\072\114\093\027\024\027\062\072\114\069\120\024\068\107\064\027\072\114\102\041\027\068\072\114\111\027\114\008\027\114\027\062\010\066\027\114\079\091\114\018\079\066\091\027\120\079\127\114\087\079\102\078\018\079\010\120\072\078\014\027\079\120\104\114\111\027\114\028\027\062\114\027\072\079\120\072\114\102\027\111\091\010\114\099\027\068\114\001\008\028\001\114\068\010\072\091\027\114\079\114\087\079\114\112\079\010\027\035")
		}, 
		{
			Text = _PkY("\093\027\024\027\062\072\050\010\111\111\027\114\102\100\045\107\072\027\114\079\091\015\100\091\062\099\041\081\091\010\114\008\104\077\077\008\114\081\079\024\010\072\079\120\072\068\114\062\027\107\079\062\072\010\068\114\068\091\062\114\091\120\114\072\027\062\062\010\072\100\010\062\027\114\099\027\114\008\103\052\114\011\045\114\102\079\062\062\027\068\035"), 
			Buttons = {
				_PkY("\093\027\024\027\062\072\050\010\111\111\027\035\035\035")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _S78nj)
	end)
	_Wpqxg.Visible = false
	_Wpqxg.Active = false
	_sjyn.Active = false
	--[[Ajout de sauvegarde automatique le 17 mai 2011.]]
	_YdGE4:RequestSync()
end
function _EXIR:OnSetComplete()
	_YdGE4.Complete = true
	_Urwigo.MessageBox{
		Text = _PkY("\037\100\091\068\114\079\050\027\054\114\102\100\045\107\111\027\072\027\114\050\100\072\062\027\114\023\081\027\062\010\066\100\035\114\069\120\024\068\107\064\014\041\079\010\114\107\111\079\102\027\114\099\079\120\068\114\050\100\072\062\027\114\010\120\050\027\120\072\079\010\062\027\114\091\120\114\118\072\027\045\114\102\100\120\072\027\120\079\120\072\114\050\100\072\062\027\114\102\100\099\027\114\099\027\114\099\027\050\027\062\100\091\010\111\111\079\066\027\035"), 
		Callback = function(action)
			if action ~= nil then
				_oL1B:MoveTo(Player)
			end
		end
	}
end
function _O_9KF:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_sYQ7a = input
	if Wherigo.NoCaseEquals(_sYQ7a, _PkY("\028\044\044\011\029\081")) then
		--[[Changement de la reponse a la question Zone Station-Service le 05 juin 2011.]]
		--[[La reponse est maintenant 100km/h.]]
		_mqp.Active = true
		_mqp.Visible = true
		_Urwigo.MessageBox{
			Text = _PkY("\018\091\107\027\062\067\114\069\120\024\068\107\064\037\100\091\068\114\079\050\027\054\114\111\079\114\107\027\062\045\010\068\068\010\100\120\114\099\027\114\102\010\062\102\091\111\027\062\067"), 
			Media = _Xikb, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _mqp)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _PkY("\093\091\045\067\114\063\027\107\100\120\068\027\114\010\120\102\100\062\062\027\102\072\027\035\114\115\068\068\079\127\027\054\114\099\027\114\120\100\091\050\027\079\091\035\035\035"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_O_9KF)
					end)
				end
			end
		}
	end
end
function _Pcdc:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_9DEL = input
	if Wherigo.NoCaseEquals(_9DEL, _PkY("\018\079\066\091\027\120\079\127")) then
		_Urwigo.MessageBox{
			Text = _PkY("\123\101\067\114\062\027\120\099\100\120\068\078\120\100\091\068\114\079\114\018\079\066\091\027\120\079\127\035"), 
			Media = _DXw, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _S0H93)
				end
			end
		}
		_S0H93.Active = true
		_S0H93.Visible = true
		_XqUz.Complete = true
		Danatisy:MoveTo(_S0H93)
	elseif Wherigo.NoCaseEquals(_9DEL, _PkY("\093\027\024\027\062\072\050\010\111\111\027")) then
		_Urwigo.MessageBox{
			Text = _PkY("\123\101\067\114\063\027\120\099\100\120\068\078\120\100\091\068\114\079\114\093\027\024\027\062\072\050\010\111\111\027\035"), 
			Media = _DXw, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _S78nj)
				end
			end
		}
		_S78nj.Active = true
		_S78nj.Visible = true
		__DsEl.Complete = true
		Danatisy:MoveTo(_S78nj)
	end
end
function _bII:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_9DEL = input
	if Wherigo.NoCaseEquals(_9DEL, _PkY("\018\079\066\091\027\120\079\127")) then
		_Urwigo.MessageBox{
			Text = _PkY("\123\101\067\114\062\027\120\099\100\120\068\078\120\100\091\068\114\079\114\018\079\066\091\027\120\079\127\035"), 
			Media = _DXw, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _S0H93)
				end
			end
		}
		Danatisy:MoveTo(_S0H93)
	elseif Wherigo.NoCaseEquals(_9DEL, _PkY("\093\027\024\027\062\072\050\010\111\111\027")) then
		_Urwigo.MessageBox{
			Text = _PkY("\123\101\067\114\063\027\120\099\100\120\068\078\120\100\091\068\114\079\114\093\027\024\027\062\072\050\010\111\111\027\035"), 
			Media = _DXw, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _S78nj)
				end
			end
		}
		Danatisy:MoveTo(_S78nj)
	end
end
function _bMRo2:OnTick()
	_T1D:MoveTo(Player)
	_qmo:MoveTo(Player)
	_T1D.Commands._aY6.Enabled = true
	_qmo.Commands._WkRvx.Enabled = true
	_Urwigo.Dialog(false, {
		{
			Text = _T1D.Commands._aY6.EmptyTargetListText, 
			Media = _y9rq
		}, 
		{
			Text = _PkY("\014\041\079\010\114\079\015\100\091\072\027\114\099\079\120\068\114\050\100\072\062\027\114\010\120\050\027\120\072\079\010\062\027\114\099\027\114\111\079\114\066\100\045\045\027\114\079\114\045\079\102\081\027\062\035\114\069\120\024\068\107\064\037\100\091\068\114\107\100\091\062\062\027\054\114\062\027\107\079\062\027\062\114\072\027\045\107\100\062\079\010\062\027\045\027\120\072\114\111\027\114\062\027\068\027\062\050\100\010\062\114\099\041\027\068\068\027\120\102\027\114\027\072\114\062\027\107\079\062\072\010\062\035")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _T1D)
	end)
end
function _qmo:On_WkRvx(target)
end
function _qmo:On_mvpza(target)
end
function _T1D:On_aY6(target)
end
function _T1D:On_WpyBM(target)
end
function _oL1B:OnClick()
	_Urwigo.MessageBox{
		Text = string.sub(Player.CompletionCode, 1, 15), 
		Media = _yH_LV, 
		Buttons = {
			_PkY("\063\027\072\100\091\062")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _YdGE4
