﻿require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _FJOj(str)
	local res = ""
    local dtable = "\116\081\017\064\051\000\021\106\078\083\070\073\046\037\077\001\097\126\004\028\079\084\115\049\066\059\020\013\117\050\044\031\055\074\111\067\098\060\088\123\057\007\016\063\112\040\056\039\114\119\122\025\053\011\014\094\042\107\043\104\032\092\095\091\068\035\012\076\087\034\015\075\082\026\052\054\096\072\089\099\030\108\027\048\120\061\045\105\033\086\125\003\109\005\069\018\041\008\121\036\118\038\029\058\065\024\103\022\124\093\019\009\100\101\023\071\002\062\090\110\085\010\080\102\006\113\047"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_YQ8fd = Wherigo.ZCartridge()

-- Media --
_Y_u = Wherigo.ZMedia(_YQ8fd)
_Y_u.Id = "c552c279-5988-4202-ae9c-349c70a5364a"
_Y_u.Name = _FJOj("\009\010\116\072\017\049\001\114")
_Y_u.Description = ""
_Y_u.AltText = ""
_Y_u.Resources = {
	{
		Type = "jpg", 
		Filename = "Bodentypen-NSG-Eldena.jpg", 
		Directives = {}
	}
}
_6RM3g = Wherigo.ZMedia(_YQ8fd)
_6RM3g.Id = "3f4f9240-8dd1-458e-89c6-4042ad068153"
_6RM3g.Name = _FJOj("\025\035\113\114\120\060\035\049\088\051\035\120\001")
_6RM3g.Description = ""
_6RM3g.AltText = ""
_6RM3g.Resources = {
	{
		Type = "png", 
		Filename = "800px-Soil_profile.png", 
		Directives = {}
	}
}
_PnWe = Wherigo.ZMedia(_YQ8fd)
_PnWe.Id = "e1630356-51d1-4026-816d-6ed0c7453d5a"
_PnWe.Name = _FJOj("\114\029\082\114")
_PnWe.Description = ""
_PnWe.AltText = ""
_PnWe.Resources = {
	{
		Type = "jpg", 
		Filename = "nsg.jpg", 
		Directives = {}
	}
}
_dxo = Wherigo.ZMedia(_YQ8fd)
_dxo.Id = "c45f0662-861e-47de-96c3-bb9a7482071d"
_dxo.Name = _FJOj("\088\080\035\063\114\029\082\114")
_dxo.Description = ""
_dxo.AltText = ""
_dxo.Resources = {
	{
		Type = "png", 
		Filename = "eule.png", 
		Directives = {}
	}
}
_wqpP = Wherigo.ZMedia(_YQ8fd)
_wqpP.Id = "0f1e235b-0c7e-4324-a056-3694665ec2b5"
_wqpP.Name = _FJOj("\088\080\035\063\082\088\001\114\049\017\001\029\049")
_wqpP.Description = ""
_wqpP.AltText = ""
_wqpP.Resources = {
	{
		Type = "png", 
		Filename = "ico_literatur.png", 
		Directives = {}
	}
}
_639 = Wherigo.ZMedia(_YQ8fd)
_639.Id = "95ceda21-66bd-4d83-a499-97b374fffec5"
_639.Name = _FJOj("\088\080\035\063\023\035\082")
_639.Description = ""
_639.AltText = ""
_639.Resources = {
	{
		Type = "png", 
		Filename = "sol.png", 
		Directives = {}
	}
}
_46Nki = Wherigo.ZMedia(_YQ8fd)
_46Nki.Id = "52872b82-a0a0-4254-8047-381a5c9e24d5"
_46Nki.Name = _FJOj("\023\035\082")
_46Nki.Description = ""
_46Nki.AltText = ""
_46Nki.Resources = {
	{
		Type = "jpg", 
		Filename = "fons.jpg", 
		Directives = {}
	}
}
_dyrBq = Wherigo.ZMedia(_YQ8fd)
_dyrBq.Id = "52b3527c-f75e-4562-aabf-9c6e6ae88dcb"
_dyrBq.Name = _FJOj("\088\080\035\063\045\017\045\114\049")
_dyrBq.Description = ""
_dyrBq.AltText = ""
_dyrBq.Resources = {
	{
		Type = "png", 
		Filename = "ico_antworten.png", 
		Directives = {}
	}
}
_jsbs1 = Wherigo.ZMedia(_YQ8fd)
_jsbs1.Id = "f7663b16-e13a-4a40-a28c-9b580981b07b"
_jsbs1.Name = _FJOj("\088\080\035\063\124\029\080\060\023")
_jsbs1.Description = ""
_jsbs1.AltText = ""
_jsbs1.Resources = {
	{
		Type = "png", 
		Filename = "fuchs.png", 
		Directives = {}
	}
}
_4eXU = Wherigo.ZMedia(_YQ8fd)
_4eXU.Id = "6129f100-40c4-4113-839f-c54dc786f017"
_4eXU.Name = _FJOj("\088\080\035\063\035\080\114\082\082")
_4eXU.Description = ""
_4eXU.AltText = ""
_4eXU.Resources = {
	{
		Type = "png", 
		Filename = "specht.png", 
		Directives = {}
	}
}
_THS = Wherigo.ZMedia(_YQ8fd)
_THS.Id = "8edabe39-5b11-44d0-8f8a-cc6e89a05f20"
_THS.Name = _FJOj("\088\080\035\063\114\023\126\029\088\049\035\082")
_THS.Description = ""
_THS.AltText = ""
_THS.Resources = {
	{
		Type = "png", 
		Filename = "esquirol.png", 
		Directives = {}
	}
}
_Jvs = Wherigo.ZMedia(_YQ8fd)
_Jvs.Id = "6660f79a-d114-4a8e-b9cb-34246c891428"
_Jvs.Name = _FJOj("\088\080\035\063\049\114\060")
_Jvs.Description = ""
_Jvs.AltText = ""
_Jvs.Resources = {
	{
		Type = "png", 
		Filename = "reh.png", 
		Directives = {}
	}
}
_cT3_l = Wherigo.ZMedia(_YQ8fd)
_cT3_l.Id = "85db3443-d57d-42f1-9567-c5a809988199"
_cT3_l.Name = _FJOj("\088\080\035\063\017\093\023\114\082")
_cT3_l.Description = ""
_cT3_l.AltText = ""
_cT3_l.Resources = {
	{
		Type = "png", 
		Filename = "amsel.png", 
		Directives = {}
	}
}
_EeYaY = Wherigo.ZMedia(_YQ8fd)
_EeYaY.Id = "c5656e33-7ce6-4683-9f3c-c12c83769a84"
_EeYaY.Name = _FJOj("\088\080\035\063\093\114\088\023\114")
_EeYaY.Description = ""
_EeYaY.AltText = ""
_EeYaY.Resources = {
	{
		Type = "png", 
		Filename = "meise.png", 
		Directives = {}
	}
}
_89Lm9 = Wherigo.ZMedia(_YQ8fd)
_89Lm9.Id = "d3f87833-2bfc-4ef2-b24b-5dd90891913e"
_89Lm9.Name = _FJOj("\023\035\063\023\045\114\080\060\001")
_89Lm9.Description = ""
_89Lm9.AltText = ""
_89Lm9.Resources = {
	{
		Type = "wav", 
		Filename = "spechtwav.wav", 
		Directives = {}
	}
}
_wmJ = Wherigo.ZMedia(_YQ8fd)
_wmJ.Id = "9f166848-f1e0-4658-96c8-6efdf13fa1b4"
_wmJ.Name = _FJOj("\023\035\063\058\035\060\082\093\114\088\023\114")
_wmJ.Description = ""
_wmJ.AltText = ""
_wmJ.Resources = {
	{
		Type = "wav", 
		Filename = "kohlmeisewav.wav", 
		Directives = {}
	}
}
_59iM5 = Wherigo.ZMedia(_YQ8fd)
_59iM5.Id = "60c8832d-fe03-46c8-b031-9ae206243cc5"
_59iM5.Name = _FJOj("\023\035\063\093\114\049\082\017")
_59iM5.Description = ""
_59iM5.AltText = ""
_59iM5.Resources = {
	{
		Type = "wav", 
		Filename = "merlawav.wav", 
		Directives = {}
	}
}
_B8Fd = Wherigo.ZMedia(_YQ8fd)
_B8Fd.Id = "04f9c587-0e8b-4923-8a63-8830826b8121"
_B8Fd.Name = _FJOj("\023\035\063\124\029\080\060\023")
_B8Fd.Description = ""
_B8Fd.AltText = ""
_B8Fd.Resources = {
	{
		Type = "ogg", 
		Filename = "fuchs.ogg", 
		Directives = {}
	}
}
_Nnoss = Wherigo.ZMedia(_YQ8fd)
_Nnoss.Id = "1b5cb0b1-bac6-4f85-a5ae-5a764d42db23"
_Nnoss.Name = _FJOj("\088\080\035")
_Nnoss.Description = ""
_Nnoss.AltText = ""
_Nnoss.Resources = {
	{
		Type = "png", 
		Filename = "earthigo.png", 
		Directives = {}
	}
}
-- Cartridge Info --
_YQ8fd.Id="022dce77-7ab1-43a9-85c5-363ee9a75e86"
_YQ8fd.Name="Die Böden eines Waldes"
_YQ8fd.Description=[[]]
_YQ8fd.Visible=true
_YQ8fd.Activity="TourGuide"
_YQ8fd.StartingLocationDescription=[[]]
_YQ8fd.StartingLocation = ZonePoint(54.0739667,13.4610667,0)
_YQ8fd.Version=""
_YQ8fd.Company=""
_YQ8fd.Author="SastR'e.O"
_YQ8fd.BuilderVersion="URWIGO 1.22.5798.37755"
_YQ8fd.CreateDate="04/03/2019 21:24:55"
_YQ8fd.PublishDate="1/1/0001 12:00:00 AM"
_YQ8fd.UpdateDate="04/06/2019 15:18:00"
_YQ8fd.LastPlayedDate="1/1/0001 12:00:00 AM"
_YQ8fd.TargetDevice="PocketPC"
_YQ8fd.TargetDeviceVersion="0"
_YQ8fd.StateId="1"
_YQ8fd.CountryId="2"
_YQ8fd.Complete=false
_YQ8fd.UseLogging=true

_YQ8fd.Icon=_Nnoss


-- Zones --
_Kvree = Wherigo.Zone(_YQ8fd)
_Kvree.Id = "bfc18d19-65cb-41fc-9c1d-a2e283e94acc"
_Kvree.Name = _FJOj("\009\010\116\061\095\082\113\114\120\017")
_Kvree.Description = _FJOj("\065\017\023\061\009\017\001\029\049\023\080\060\029\001\051\107\114\037\088\114\001\061\095\082\113\114\120\017\061\046\009\010\116\061\095\082\113\114\120\017\097\061\088\023\001\061\114\088\120\061\017\082\023\061\009\017\001\029\049\023\080\060\029\001\051\107\114\037\088\114\001\061\017\029\023\107\114\050\088\114\023\114\120\114\049\061\068\017\029\037\050\017\082\113\061\088\093\061\010\195\188\113\035\023\001\114\120\061\113\114\049\061\078\017\120\023\114\023\001\017\113\001\061\116\049\114\088\124\023\050\017\082\113\061\088\120\061\015\114\080\058\082\114\120\037\029\049\107\087\090\035\049\045\035\093\093\114\049\120\031\061\113\088\114\061\114\088\120\061\116\114\037\088\114\001\061\101\035\120\061\075\084\033\031\024\061\060\017\061\029\093\124\017\023\023\001\013\061\065\088\114\023\114\023\061\069\017\082\113\107\114\037\088\114\001\061\023\001\114\060\001\061\017\082\023\061\009\017\001\029\049\023\080\060\029\001\051\061\023\114\088\001\061\024\041\076\024\013\038\025\073\118\065\114\049\061\107\049\195\182\195\159\001\114\061\022\114\088\082\061\113\114\023\061\009\010\116\061\095\082\113\114\120\017\061\050\088\049\113\061\101\035\120\061\120\017\001\029\049\120\017\060\114\120\061\095\023\080\060\114\120\087\025\029\080\060\114\120\050\017\082\113\037\114\023\001\195\164\120\113\114\120\061\114\088\120\107\114\120\035\093\093\114\120\031\061\113\088\114\061\001\114\088\082\050\114\088\023\114\061\093\114\060\049\114\049\114\061\060\029\120\113\114\049\001\061\034\017\060\049\114\061\017\082\001\061\023\088\120\113\013\061\069\088\049\061\124\088\120\113\114\120\061\017\037\114\049\061\017\029\080\060\061\025\114\049\107\087\105\060\035\049\120\031\061\010\001\088\114\082\087\095\088\080\060\114\031\061\078\017\088\120\037\029\080\060\114\031\061\090\035\107\114\082\087\072\088\049\023\080\060\114\031\061\025\114\049\107\087\121\082\093\114\061\029\120\113\061\010\045\088\001\051\087\105\060\035\049\120\031\061\029\013\017\013\038\025\073\118\121\120\001\114\049\061\113\114\120\061\015\088\001\037\114\050\035\060\120\114\049\120\061\113\114\023\061\069\017\082\113\114\023\061\050\088\049\061\058\195\182\120\120\114\120\104\061\078\088\049\023\080\060\114\031\061\011\195\188\080\060\023\114\031\061\069\017\082\113\093\195\164\029\023\114\031\061\010\045\114\080\060\001\114\031\061\073\035\001\093\088\082\017\120\061\029\120\113\061\101\088\114\082\061\093\114\060\049\061\124\088\120\113\114\120\013")
_Kvree.Visible = true
_Kvree.Commands = {}
_Kvree.DistanceRange = Distance(0, "meters")
_Kvree.ShowObjects = "OnEnter"
_Kvree.ProximityRange = Distance(60, "meters")
_Kvree.AllowSetPositionTo = false
_Kvree.Active = true
_Kvree.Points = {
	ZonePoint(54.0833465464072, 13.4444711634283, 0), 
	ZonePoint(54.0824291312182, 13.4451671468074, 0), 
	ZonePoint(54.0824099181179, 13.4457239335106, 0), 
	ZonePoint(54.0834137907018, 13.4464362929692, 0), 
	ZonePoint(54.0832648924743, 13.4476317467732, 0), 
	ZonePoint(54.082986307259, 13.4491629102071, 0), 
	ZonePoint(54.0827029169316, 13.4504975606869, 0), 
	ZonePoint(54.0831256001004, 13.4505712530447, 0), 
	ZonePoint(54.0830343393261, 13.4521515447171, 0), 
	ZonePoint(54.0829478815653, 13.45305222909, 0), 
	ZonePoint(54.0827461460897, 13.4537400244293, 0), 
	ZonePoint(54.0820304575635, 13.4536908961908, 0), 
	ZonePoint(54.0817758808166, 13.4531095453683, 0), 
	ZonePoint(54.0806903096149, 13.4528065878973, 0), 
	ZonePoint(54.080257994594, 13.4529867247719, 0), 
	ZonePoint(54.0798160679184, 13.4537891526678, 0), 
	ZonePoint(54.0793501183928, 13.4551483672668, 0), 
	ZonePoint(54.0792156165259, 13.4564502655876, 0), 
	ZonePoint(54.0795134415023, 13.4576784715507, 0), 
	ZonePoint(54.07999860342, 13.4578913605843, 0), 
	ZonePoint(54.080555812091, 13.4591031904678, 0), 
	ZonePoint(54.0812042782806, 13.4588084210366, 0), 
	ZonePoint(54.0815453193965, 13.458996745951, 0), 
	ZonePoint(54.0817662741164, 13.4597172934493, 0), 
	ZonePoint(54.0821457370862, 13.4594470881374, 0), 
	ZonePoint(54.0823090491951, 13.4599219944431, 0), 
	ZonePoint(54.082304245907, 13.4604705931066, 0), 
	ZonePoint(54.0820784907369, 13.460920935293, 0), 
	ZonePoint(54.0813579872995, 13.4609454994123, 0), 
	ZonePoint(54.0805894365128, 13.461518662195, 0), 
	ZonePoint(54.0790667032363, 13.4618379957454, 0), 
	ZonePoint(54.0784470260683, 13.4617888675069, 0), 
	ZonePoint(54.0766263706378, 13.4613303372807, 0), 
	ZonePoint(54.0765447034834, 13.4629925093506, 0), 
	ZonePoint(54.0765398995281, 13.4641879631546, 0), 
	ZonePoint(54.0764198004657, 13.4649494508517, 0), 
	ZonePoint(54.0759970490021, 13.4657109385488, 0), 
	ZonePoint(54.0758048878227, 13.4660630242582, 0), 
	ZonePoint(54.0755935094979, 13.4671356574659, 0), 
	ZonePoint(54.0755262525325, 13.4677743245667, 0), 
	ZonePoint(54.0760883252507, 13.468396615588, 0), 
	ZonePoint(54.0767945083911, 13.4688551458142, 0), 
	ZonePoint(54.0776399907706, 13.468961590331, 0), 
	ZonePoint(54.0784182036492, 13.4686013165818, 0), 
	ZonePoint(54.0789081820507, 13.4684784959855, 0), 
	ZonePoint(54.0800802637792, 13.4686995730588, 0), 
	ZonePoint(54.0806182574241, 13.469190855444, 0), 
	ZonePoint(54.0814156280347, 13.4700178474591, 0), 
	ZonePoint(54.0817614707654, 13.4709430959513, 0), 
	ZonePoint(54.082092900678, 13.4717782760062, 0), 
	ZonePoint(54.0821025073027, 13.4725888919418, 0), 
	ZonePoint(54.0819824243345, 13.4741364314552, 0), 
	ZonePoint(54.0817710774668, 13.4747259703174, 0), 
	ZonePoint(54.0813147566955, 13.4750616799473, 0), 
	ZonePoint(54.0803204403753, 13.4760524327574, 0), 
	ZonePoint(54.0797776392894, 13.4768548606533, 0), 
	ZonePoint(54.0794317800279, 13.4775590320721, 0), 
	ZonePoint(54.0795566739826, 13.4785743490014, 0), 
	ZonePoint(54.078994648227, 13.4800727602763, 0), 
	ZonePoint(54.0776976366693, 13.480416657946, 0), 
	ZonePoint(54.0760835212427, 13.4802283330316, 0), 
	ZonePoint(54.0758961644938, 13.4800318200776, 0), 
	ZonePoint(54.0749353473664, 13.4801055124353, 0), 
	ZonePoint(54.0740753971789, 13.4803511536279, 0), 
	ZonePoint(54.0736862518543, 13.4802610851906, 0), 
	ZonePoint(54.0734364282419, 13.480048196157, 0), 
	ZonePoint(54.0728214714066, 13.4799663157594, 0), 
	ZonePoint(54.0725812514187, 13.4800727602762, 0), 
	ZonePoint(54.0721200251458, 13.4798598712426, 0), 
	ZonePoint(54.0718317561232, 13.4796551702487, 0), 
	ZonePoint(54.0712840394661, 13.4797534267258, 0), 
	ZonePoint(54.0706354182906, 13.4803347775482, 0), 
	ZonePoint(54.0701741704011, 13.4804575981446, 0), 
	ZonePoint(54.0699483492534, 13.4804330340253, 0), 
	ZonePoint(54.0693717790501, 13.4805886067805, 0), 
	ZonePoint(54.0688432493304, 13.4804985383433, 0), 
	ZonePoint(54.0685645673148, 13.4807196154166, 0), 
	ZonePoint(54.0680168075573, 13.4812436499608, 0), 
	ZonePoint(54.0674978705953, 13.481137205444, 0), 
	ZonePoint(54.0672191795502, 13.480768743655, 0), 
	ZonePoint(54.0663734849296, 13.4792621443404, 0), 
	ZonePoint(54.0658160858767, 13.4789182466707, 0), 
	ZonePoint(54.0656430984425, 13.4783287078084, 0), 
	ZonePoint(54.0646484067114, 13.4778456134629, 0), 
	ZonePoint(54.0639227952991, 13.4777637330654, 0), 
	ZonePoint(54.0633509469091, 13.4781813230928, 0), 
	ZonePoint(54.0621687815767, 13.4790001270682, 0), 
	ZonePoint(54.0619299151891, 13.4792100768974, 0), 
	ZonePoint(54.0615180481154, 13.4725027832684, 0), 
	ZonePoint(54.0616015670185, 13.4718857286085, 0), 
	ZonePoint(54.0618899070673, 13.4711406169029, 0), 
	ZonePoint(54.0615775385912, 13.4696667697472, 0), 
	ZonePoint(54.0612363334173, 13.4665471266011, 0), 
	ZonePoint(54.0609576003501, 13.4639433299595, 0), 
	ZonePoint(54.0610729383979, 13.4618390037427, 0), 
	ZonePoint(54.0613324478344, 13.4610038236879, 0), 
	ZonePoint(54.0619716030504, 13.4607254303363, 0), 
	ZonePoint(54.06113541304, 13.4596855492876, 0), 
	ZonePoint(54.0631345519725, 13.4555751533313, 0), 
	ZonePoint(54.0645713736442, 13.4525701427417, 0), 
	ZonePoint(54.0649269673206, 13.4508588424332, 0), 
	ZonePoint(54.0650855418974, 13.4497452690267, 0), 
	ZonePoint(54.0650086573297, 13.4494996278341, 0), 
	ZonePoint(54.0652248948134, 13.4490820378067, 0), 
	ZonePoint(54.065955288656, 13.4486562597395, 0), 
	ZonePoint(54.0661858095979, 13.4480737811574, 0), 
	ZonePoint(54.0662578849072, 13.447557948493, 0), 
	ZonePoint(54.066373205142, 13.4472795626106, 0), 
	ZonePoint(54.0669449965758, 13.4471567453095, 0), 
	ZonePoint(54.0672765359019, 13.4467637299461, 0), 
	ZonePoint(54.067608072581, 13.4464771562437, 0), 
	ZonePoint(54.0680549221776, 13.4463543389426, 0), 
	ZonePoint(54.0683576240111, 13.446280648562, 0), 
	ZonePoint(54.068415281253, 13.4466572882852, 0), 
	ZonePoint(54.0685882524983, 13.4467801055863, 0), 
	ZonePoint(54.0689053645767, 13.4466818517455, 0), 
	ZonePoint(54.0688909504438, 13.4458221306381, 0), 
	ZonePoint(54.0692176695595, 13.4457484402575, 0), 
	ZonePoint(54.0695203629166, 13.4460186383199, 0), 
	ZonePoint(54.0696020416985, 13.4464198415034, 0), 
	ZonePoint(54.0699527781705, 13.4475988875935, 0), 
	ZonePoint(54.0701497658486, 13.4482047862787, 0), 
	ZonePoint(54.0718073080732, 13.4490808830263, 0), 
	ZonePoint(54.0724126548237, 13.4504810002584, 0), 
	ZonePoint(54.0727633675538, 13.4512342797049, 0), 
	ZonePoint(54.0723982419084, 13.4527244629578, 0), 
	ZonePoint(54.0720283087035, 13.4537233770064, 0), 
	ZonePoint(54.071446978436, 13.4544029660722, 0), 
	ZonePoint(54.071216365827, 13.4549106109166, 0), 
	ZonePoint(54.0717640686818, 13.4558440224047, 0), 
	ZonePoint(54.0725952179844, 13.4567283069723, 0), 
	ZonePoint(54.0732149658836, 13.4571540736159, 0), 
	ZonePoint(54.0751942538063, 13.4559832153459, 0), 
	ZonePoint(54.0758812176023, 13.4536333109857, 0), 
	ZonePoint(54.0751606259161, 13.4522659450339, 0), 
	ZonePoint(54.0755065114865, 13.4517664880096, 0), 
	ZonePoint(54.0755929824288, 13.4503499951375, 0), 
	ZonePoint(54.075525727267, 13.4495230253104, 0), 
	ZonePoint(54.0752278816693, 13.4495148374903, 0), 
	ZonePoint(54.074949249982, 13.4498669137533, 0), 
	ZonePoint(54.0745889476137, 13.4496376547913, 0), 
	ZonePoint(54.0744063932202, 13.4488761875249, 0), 
	ZonePoint(54.0740412820248, 13.446796481227, 0), 
	ZonePoint(54.0738395086708, 13.4460186383204, 0), 
	ZonePoint(54.0736617551417, 13.4444957037873, 0), 
	ZonePoint(54.0728930824703, 13.4445038916074, 0), 
	ZonePoint(54.0721243955669, 13.4444711403271, 0), 
	ZonePoint(54.071619937052, 13.4442418813652, 0), 
	ZonePoint(54.0712692146629, 13.4436605461402, 0), 
	ZonePoint(54.0709713385263, 13.4426616320916, 0), 
	ZonePoint(54.0708464220911, 13.4421130481469, 0), 
	ZonePoint(54.071591110666, 13.4405082354131, 0), 
	ZonePoint(54.0727441504944, 13.4393210015029, 0), 
	ZonePoint(54.0731573153063, 13.4392718745825, 0), 
	ZonePoint(54.0737482299265, 13.4396485143058, 0), 
	ZonePoint(54.0743343320543, 13.4402789764512, 0), 
	ZonePoint(54.0747186568264, 13.4412205757593, 0), 
	ZonePoint(54.074992486056, 13.441998418666, 0), 
	ZonePoint(54.0755785706174, 13.4441108762443, 0), 
	ZonePoint(54.076736303508, 13.4450688511925, 0), 
	ZonePoint(54.0774568678429, 13.4460432017809, 0), 
	ZonePoint(54.078090954111, 13.4470339280095, 0), 
	ZonePoint(54.07850886931, 13.4476807657951, 0), 
	ZonePoint(54.0793302765764, 13.4476480145148, 0), 
	ZonePoint(54.0796425031448, 13.4472877504318, 0), 
	ZonePoint(54.0796376996769, 13.4449705973519, 0), 
	ZonePoint(54.0797385723856, 13.4431938403966, 0), 
	ZonePoint(54.0798730689493, 13.4429318301544, 0), 
	ZonePoint(54.0804398711076, 13.443111962196, 0), 
	ZonePoint(54.0814101415815, 13.4436196070403, 0), 
	ZonePoint(54.0819240875439, 13.4437751756218, 0), 
	ZonePoint(54.0823419641493, 13.4437178608812, 0), 
	ZonePoint(54.082889520229, 13.4436523583207, 0), 
	ZonePoint(54.0832545536021, 13.4439716833034, 0), 
	ZonePoint(54.0833794327031, 13.4442582570059, 0)
}
_Kvree.OriginalPoint = ZonePoint(54.0742062434436, 13.4587003542151, 0)
_Kvree.DistanceRangeUOM = "Meters"
_Kvree.ProximityRangeUOM = "Meters"
_Kvree.OutOfRangeName = ""
_Kvree.InRangeName = ""
_9xV7F = Wherigo.Zone(_YQ8fd)
_9xV7F.Id = "75d9b8e9-78f3-46a1-8cb4-983c4886fcae"
_9xV7F.Name = _FJOj("\073\114\060\037\049\029\080\060")
_9xV7F.Description = ""
_9xV7F.Visible = false
_9xV7F.Commands = {}
_9xV7F.DistanceRange = Distance(-1, "feet")
_9xV7F.ShowObjects = "OnEnter"
_9xV7F.ProximityRange = Distance(60, "meters")
_9xV7F.AllowSetPositionTo = false
_9xV7F.Active = true
_9xV7F.Points = {
	ZonePoint(54.0708444555304, 13.4421093894085, 0), 
	ZonePoint(54.0709788589396, 13.4427065583315, 0), 
	ZonePoint(54.0712668647798, 13.4436554842914, 0), 
	ZonePoint(54.0716220692313, 13.4442281120258, 0), 
	ZonePoint(54.0721212703509, 13.4444735239119, 0), 
	ZonePoint(54.0736620359531, 13.4444980651005, 0), 
	ZonePoint(54.0738396283129, 13.4459950776062, 0), 
	ZonePoint(54.0740508182384, 13.4468212976229, 0), 
	ZonePoint(54.0745883877464, 13.4496353539177, 0), 
	ZonePoint(54.0749579627452, 13.4498644050115, 0), 
	ZonePoint(54.075226742496, 13.4495208283708, 0), 
	ZonePoint(54.0755291176355, 13.449529008767, 0), 
	ZonePoint(54.0756011113917, 13.4503552287838, 0), 
	ZonePoint(54.0755099192794, 13.4517622569312, 0), 
	ZonePoint(54.0751643473518, 13.4522612610997, 0), 
	ZonePoint(54.0758794860743, 13.453627387266, 0), 
	ZonePoint(54.0751931451223, 13.455975160977, 0), 
	ZonePoint(54.0732156518022, 13.4571613184268, 0), 
	ZonePoint(54.0717660701702, 13.455852455034, 0), 
	ZonePoint(54.0712236640311, 13.4549117094703, 0), 
	ZonePoint(54.0714396673249, 13.4544045249056, 0), 
	ZonePoint(54.0720204706084, 13.4537337324167, 0), 
	ZonePoint(54.0723900684676, 13.4527520848721, 0), 
	ZonePoint(54.0727596630366, 13.4512305311779, 0), 
	ZonePoint(54.0717996703174, 13.4490709065796, 0), 
	ZonePoint(54.0701484309155, 13.448211964978, 0), 
	ZonePoint(54.0695195986448, 13.446019618795, 0), 
	ZonePoint(54.0692267803682, 13.4457578461164, 0), 
	ZonePoint(54.0689051579142, 13.4457987480974, 0), 
	ZonePoint(54.0691257236655, 13.4445395758706, 0), 
	ZonePoint(54.0692911472101, 13.4441824971794, 0), 
	ZonePoint(54.0696550766883, 13.4435998951042, 0), 
	ZonePoint(54.0702285348474, 13.4420024378012, 0), 
	ZonePoint(54.0703510505859, 13.4419551504445, 0)
}
_9xV7F.OriginalPoint = ZonePoint(54.072326548464, 13.448476570491, 0)
_9xV7F.DistanceRangeUOM = "Feet"
_9xV7F.ProximityRangeUOM = "Meters"
_9xV7F.OutOfRangeName = ""
_9xV7F.InRangeName = ""
_v_f = Wherigo.Zone(_YQ8fd)
_v_f.Id = "ef208639-f8c5-4a7b-bb0e-784b08ee4206"
_v_f.Name = _FJOj("\010\001\017\001\088\035\120\061\024")
_v_f.Description = _FJOj("\009\061\053\075\061\084\075\013\075\005\047\061\095\061\084\024\005\061\030\033\013\076\076\075")
_v_f.Visible = true
_v_f.Commands = {}
_v_f.DistanceRange = Distance(-1, "feet")
_v_f.ShowObjects = "OnEnter"
_v_f.ProximityRange = Distance(60, "meters")
_v_f.AllowSetPositionTo = false
_v_f.Active = true
_v_f.Points = {
	ZonePoint(54.0741156956448, 13.4604721283175, 0), 
	ZonePoint(54.0741156956448, 13.461339238468, 0), 
	ZonePoint(54.073626124812, 13.461339238468, 0), 
	ZonePoint(54.073626124812, 13.4604721283175, 0)
}
_v_f.OriginalPoint = ZonePoint(54.0738709102284, 13.4609056833927, 0)
_v_f.DistanceRangeUOM = "Feet"
_v_f.ProximityRangeUOM = "Meters"
_v_f.OutOfRangeName = ""
_v_f.InRangeName = ""
_d16 = Wherigo.Zone(_YQ8fd)
_d16.Id = "e03c85b2-f990-4829-ade5-465f0be32fe2"
_d16.Name = _FJOj("\010\001\017\001\088\035\120\061\030")
_d16.Description = _FJOj("\009\061\053\075\061\084\075\013\005\033\024\061\095\061\084\024\005\061\030\033\013\047\075\076")
_d16.Visible = true
_d16.Commands = {}
_d16.DistanceRange = Distance(-1, "feet")
_d16.ShowObjects = "OnEnter"
_d16.ProximityRange = Distance(60, "meters")
_d16.AllowSetPositionTo = false
_d16.Active = true
_d16.Points = {
	ZonePoint(54.0729973538029, 13.4637115209551, 0), 
	ZonePoint(54.0724885702909, 13.4637115209551, 0), 
	ZonePoint(54.0724885702909, 13.4646113522433, 0), 
	ZonePoint(54.0729973538029, 13.4646113522433, 0)
}
_d16.OriginalPoint = ZonePoint(54.0727429620469, 13.4641614365992, 0)
_d16.DistanceRangeUOM = "Feet"
_d16.ProximityRangeUOM = "Meters"
_d16.OutOfRangeName = ""
_d16.InRangeName = ""
_JZ2N3 = Wherigo.Zone(_YQ8fd)
_JZ2N3.Id = "2e2af3a1-9c45-4c3a-922d-2a30fc8a541a"
_JZ2N3.Name = _FJOj("\010\001\017\001\088\035\120\061\005")
_JZ2N3.Description = _FJOj("\009\061\053\075\061\084\075\013\075\075\005\061\095\061\084\024\005\061\030\047\013\005\005\047")
_JZ2N3.Visible = true
_JZ2N3.Commands = {}
_JZ2N3.DistanceRange = Distance(-1, "feet")
_JZ2N3.ShowObjects = "OnEnter"
_JZ2N3.ProximityRange = Distance(60, "meters")
_JZ2N3.AllowSetPositionTo = false
_JZ2N3.Active = true
_JZ2N3.Points = {
	ZonePoint(54.0742622707441, 13.4718030024982, 0), 
	ZonePoint(54.0736965311578, 13.4718030024982, 0), 
	ZonePoint(54.0736965311578, 13.472855429758, 0), 
	ZonePoint(54.0742622707441, 13.472855429758, 0)
}
_JZ2N3.OriginalPoint = ZonePoint(54.0739794009509, 13.4723292161281, 0)
_JZ2N3.DistanceRangeUOM = "Feet"
_JZ2N3.ProximityRangeUOM = "Meters"
_JZ2N3.OutOfRangeName = ""
_JZ2N3.InRangeName = ""
_VYtV = Wherigo.Zone(_YQ8fd)
_VYtV.Id = "6e14ca78-fd05-4216-bc2e-cc531b043dfd"
_VYtV.Name = _FJOj("\010\001\017\001\088\035\120\061\075")
_VYtV.Description = _FJOj("\009\061\053\075\061\084\075\013\005\041\076\061\095\061\084\024\005\061\030\033\013\075\075\033")
_VYtV.Visible = true
_VYtV.Commands = {}
_VYtV.DistanceRange = Distance(-1, "feet")
_VYtV.ShowObjects = "OnEnter"
_VYtV.ProximityRange = Distance(60, "meters")
_VYtV.AllowSetPositionTo = false
_VYtV.Active = true
_VYtV.Points = {
	ZonePoint(54.0734317566633, 13.456912325393, 0), 
	ZonePoint(54.0734317566633, 13.4574846409638, 0), 
	ZonePoint(54.0730623695568, 13.4574846409638, 0), 
	ZonePoint(54.0730623695568, 13.456912325393, 0)
}
_VYtV.OriginalPoint = ZonePoint(54.07324706311, 13.4571984831784, 0)
_VYtV.DistanceRangeUOM = "Feet"
_VYtV.ProximityRangeUOM = "Meters"
_VYtV.OutOfRangeName = ""
_VYtV.InRangeName = ""
_6QyW = Wherigo.Zone(_YQ8fd)
_6QyW.Id = "b33109e8-e283-4cd8-91b2-2c4084079473"
_6QyW.Name = _FJOj("\010\001\017\001\088\035\120\061\053")
_6QyW.Description = _FJOj("\009\061\053\075\061\084\005\013\076\033\084\061\095\061\084\024\005\061\030\033\013\041\005\076")
_6QyW.Visible = true
_6QyW.Commands = {}
_6QyW.DistanceRange = Distance(-1, "feet")
_6QyW.ShowObjects = "OnEnter"
_6QyW.ProximityRange = Distance(60, "meters")
_6QyW.AllowSetPositionTo = false
_6QyW.Active = true
_6QyW.Points = {
	ZonePoint(54.0615913955894, 13.4649182184423, 0), 
	ZonePoint(54.061126730301, 13.4649182184423, 0), 
	ZonePoint(54.061126730301, 13.4657915405557, 0), 
	ZonePoint(54.0615913955894, 13.4657915405557, 0)
}
_6QyW.OriginalPoint = ZonePoint(54.0613590629452, 13.465354879499, 0)
_6QyW.DistanceRangeUOM = "Feet"
_6QyW.ProximityRangeUOM = "Meters"
_6QyW.OutOfRangeName = ""
_6QyW.InRangeName = ""
_r6Z0k = Wherigo.Zone(_YQ8fd)
_r6Z0k.Id = "aa0d2a80-633e-43f4-a77b-c725b6b3717a"
_r6Z0k.Name = _FJOj("\058\035\082\082\029\101\088\084\024")
_r6Z0k.Description = ""
_r6Z0k.Visible = false
_r6Z0k.Commands = {}
_r6Z0k.DistanceRange = Distance(30, "meters")
_r6Z0k.ShowObjects = "OnEnter"
_r6Z0k.ProximityRange = Distance(60, "meters")
_r6Z0k.AllowSetPositionTo = false
_r6Z0k.Active = true
_r6Z0k.Points = {
	ZonePoint(54.0617047070988, 13.4716198243904, 0), 
	ZonePoint(54.0618867390094, 13.4711382729447, 0), 
	ZonePoint(54.0615753681512, 13.4696609710519, 0), 
	ZonePoint(54.0609574098423, 13.4639639725925, 0), 
	ZonePoint(54.0610349832761, 13.4625708583774, 0), 
	ZonePoint(54.0615879388687, 13.4614962025384, 0), 
	ZonePoint(54.063106643245, 13.460896167443, 0), 
	ZonePoint(54.0641520958682, 13.4605586477019, 0), 
	ZonePoint(54.0647353369477, 13.4611961849907, 0), 
	ZonePoint(54.0650171786798, 13.461947108792, 0), 
	ZonePoint(54.0655040669209, 13.4645862456959, 0), 
	ZonePoint(54.0665461804898, 13.4668199476327, 0), 
	ZonePoint(54.0669643134029, 13.4670824525274, 0), 
	ZonePoint(54.0669643134029, 13.467701214065, 0), 
	ZonePoint(54.066964295201, 13.4682074218099, 0), 
	ZonePoint(54.0669973358514, 13.4689011950849, 0), 
	ZonePoint(54.0671844302045, 13.4695385725652, 0), 
	ZonePoint(54.0671803672949, 13.4705348528848, 0), 
	ZonePoint(54.0671693699757, 13.4713406506416, 0), 
	ZonePoint(54.0669824267596, 13.4720714727493, 0), 
	ZonePoint(54.0666525168322, 13.4733644845351, 0), 
	ZonePoint(54.0663445985352, 13.4740390993799, 0), 
	ZonePoint(54.066069669555, 13.4740765779824, 0), 
	ZonePoint(54.0658827168087, 13.4740203600786, 0), 
	ZonePoint(54.0658277305467, 13.4738891849699, 0), 
	ZonePoint(54.0658057360215, 13.4736455740538, 0), 
	ZonePoint(54.0658057360215, 13.472352562268, 0), 
	ZonePoint(54.0658167332856, 13.4710970290846, 0), 
	ZonePoint(54.0658607223127, 13.4699164531063, 0), 
	ZonePoint(54.0658607223127, 13.4695604063826, 0), 
	ZonePoint(54.0657507496576, 13.4688483129354, 0), 
	ZonePoint(54.0656077847706, 13.4685297448142, 0), 
	ZonePoint(54.0654318273109, 13.468286133898, 0), 
	ZonePoint(54.0653108561249, 13.4681362194881, 0), 
	ZonePoint(54.0652778639221, 13.467667736957, 0), 
	ZonePoint(54.0652668665154, 13.466899425606, 0), 
	ZonePoint(54.0652668665154, 13.4664496823761, 0), 
	ZonePoint(54.0648599604181, 13.4655876745189, 0), 
	ZonePoint(54.0647719801972, 13.4648193631679, 0), 
	ZonePoint(54.0647279900168, 13.4638823981057, 0), 
	ZonePoint(54.0645740240186, 13.4633576976709, 0), 
	ZonePoint(54.0642880856504, 13.463057868851, 0), 
	ZonePoint(54.0640791294439, 13.4626081256211, 0), 
	ZonePoint(54.0638993019318, 13.4621255428526, 0), 
	ZonePoint(54.0636243464651, 13.4618069628002, 0), 
	ZonePoint(54.063415379093, 13.4617882227971, 0), 
	ZonePoint(54.0631954123022, 13.4618631828094, 0), 
	ZonePoint(54.0631404204224, 13.4619568828249, 0), 
	ZonePoint(54.0631624171831, 13.4623691628927, 0), 
	ZonePoint(54.063184413932, 13.4627814429605, 0), 
	ZonePoint(54.0632614024617, 13.4631937230283, 0), 
	ZonePoint(54.0634043807811, 13.463587263093, 0), 
	ZonePoint(54.0635702627564, 13.4637819407708, 0), 
	ZonePoint(54.0637473915478, 13.4639369249144, 0), 
	ZonePoint(54.0638335620374, 13.4642305790787, 0), 
	ZonePoint(54.0638814344544, 13.4646384320847, 0), 
	ZonePoint(54.0638814344544, 13.4650462850907, 0), 
	ZonePoint(54.0638335620374, 13.4655601798782, 0), 
	ZonePoint(54.0637617533085, 13.4658293628622, 0), 
	ZonePoint(54.0635846245795, 13.466155645267, 0), 
	ZonePoint(54.0633883459164, 13.4662861582288, 0), 
	ZonePoint(54.0632686633494, 13.4663595717699, 0), 
	ZonePoint(54.0631011071763, 13.4664003570705, 0), 
	ZonePoint(54.0629526997156, 13.4662127446878, 0), 
	ZonePoint(54.0629239756296, 13.4657885775615, 0), 
	ZonePoint(54.0629096135792, 13.4653562533752, 0), 
	ZonePoint(54.0629191882801, 13.4647363168061, 0), 
	ZonePoint(54.0629526997156, 13.4643937202811, 0), 
	ZonePoint(54.062904826228, 13.4640919090567, 0), 
	ZonePoint(54.0626798200973, 13.4634719724876, 0), 
	ZonePoint(54.0624643875533, 13.4629662347602, 0), 
	ZonePoint(54.0621962921601, 13.462680737656, 0), 
	ZonePoint(54.0620813936047, 13.4625175964536, 0), 
	ZonePoint(54.0617558459716, 13.4626644235357, 0), 
	ZonePoint(54.0616026462025, 13.4629336065197, 0), 
	ZonePoint(54.0615643461719, 13.4636840560507, 0), 
	ZonePoint(54.0615547711587, 13.4642713643793, 0), 
	ZonePoint(54.0615978587006, 13.4648260444674, 0), 
	ZonePoint(54.0616840336502, 13.4653154680746, 0), 
	ZonePoint(54.0618132957393, 13.4658130487419, 0), 
	ZonePoint(54.0619042577091, 13.4663106294092, 0), 
	ZonePoint(54.0620861810509, 13.4668897806777, 0), 
	ZonePoint(54.0622585287449, 13.4676239160884, 0), 
	ZonePoint(54.0623638520261, 13.4681051828266, 0), 
	ZonePoint(54.0624213009759, 13.4686027636945, 0), 
	ZonePoint(54.0624500254211, 13.469132972816, 0), 
	ZonePoint(54.0624978994522, 13.4696550248741, 0), 
	ZonePoint(54.0625122616507, 13.4699649932836, 0), 
	ZonePoint(54.062521836447, 13.4704054747076, 0), 
	ZonePoint(54.0624691750402, 13.4708296420048, 0), 
	ZonePoint(54.0623303401019, 13.471253809302, 0), 
	ZonePoint(54.0621771423901, 13.4715719347749, 0), 
	ZonePoint(54.0620766060846, 13.4717432331065, 0), 
	ZonePoint(54.0619760695358, 13.4718084896137, 0), 
	ZonePoint(54.0619425572988, 13.4718248037405, 0)
}
_r6Z0k.OriginalPoint = ZonePoint(54.0638109653849, 13.4666638831707, 0)
_r6Z0k.DistanceRangeUOM = "Meters"
_r6Z0k.ProximityRangeUOM = "Meters"
_r6Z0k.OutOfRangeName = ""
_r6Z0k.InRangeName = ""
_jS8 = Wherigo.Zone(_YQ8fd)
_jS8.Id = "e2ad7cff-b5a3-4095-85c8-4dd4f0c4a484"
_jS8.Name = _FJOj("\058\035\082\082\029\101\088\084\030")
_jS8.Description = ""
_jS8.Visible = false
_jS8.Commands = {}
_jS8.DistanceRange = Distance(30, "meters")
_jS8.ShowObjects = "OnEnter"
_jS8.ProximityRange = Distance(60, "meters")
_jS8.AllowSetPositionTo = false
_jS8.Active = true
_jS8.Points = {
	ZonePoint(54.0616596807263, 13.4747354663202, 0), 
	ZonePoint(54.0619665602832, 13.4749315430959, 0), 
	ZonePoint(54.0623405666775, 13.475282847319, 0), 
	ZonePoint(54.0625083889649, 13.4756178118109, 0), 
	ZonePoint(54.0624748245617, 13.4760017954966, 0), 
	ZonePoint(54.0624076956739, 13.4763122503915, 0), 
	ZonePoint(54.0623165920097, 13.4765655162267, 0), 
	ZonePoint(54.0622734375727, 13.4768759711216, 0), 
	ZonePoint(54.0622158982536, 13.4772599548073, 0), 
	ZonePoint(54.0622686426325, 13.4777909960748, 0), 
	ZonePoint(54.0623597464018, 13.4782403386858, 0), 
	ZonePoint(54.0624700296447, 13.4787877196846, 0), 
	ZonePoint(54.0621487689473, 13.4790083060573, 0), 
	ZonePoint(54.0619329954421, 13.4792125526986, 0)
}
_jS8.OriginalPoint = ZonePoint(54.0622388448423, 13.4769016478422, 0)
_jS8.DistanceRangeUOM = "Meters"
_jS8.ProximityRangeUOM = "Meters"
_jS8.OutOfRangeName = ""
_jS8.InRangeName = ""
_ke5xj = Wherigo.Zone(_YQ8fd)
_ke5xj.Id = "3ea732f5-6e83-42ce-8110-b13939ec5e89"
_ke5xj.Name = _FJOj("\058\035\082\082\029\101\088\084\005")
_ke5xj.Description = ""
_ke5xj.Visible = false
_ke5xj.Commands = {}
_ke5xj.DistanceRange = Distance(30, "meters")
_ke5xj.ShowObjects = "OnEnter"
_ke5xj.ProximityRange = Distance(60, "meters")
_ke5xj.AllowSetPositionTo = false
_ke5xj.Active = true
_ke5xj.Points = {
	ZonePoint(54.0650864538752, 13.4780640015227, 0), 
	ZonePoint(54.0648991961902, 13.4769753750191, 0), 
	ZonePoint(54.0648220898391, 13.4762809063875, 0), 
	ZonePoint(54.0647670137865, 13.475548898911, 0), 
	ZonePoint(54.0644806171351, 13.4751547410391, 0), 
	ZonePoint(54.0642603106747, 13.4746855054772, 0), 
	ZonePoint(54.0641721877633, 13.4743288864502, 0), 
	ZonePoint(54.064205233877, 13.4738596508883, 0), 
	ZonePoint(54.0639628950994, 13.4734279541714, 0), 
	ZonePoint(54.0636654773941, 13.4729587186095, 0), 
	ZonePoint(54.0636434463682, 13.4726959466948, 0), 
	ZonePoint(54.0637095394107, 13.4722079417105, 0), 
	ZonePoint(54.0637976633038, 13.4717011673037, 0), 
	ZonePoint(54.0637536013807, 13.4712131623193, 0), 
	ZonePoint(54.0636544618826, 13.4707814656024, 0), 
	ZonePoint(54.0637205549076, 13.4703685383079, 0), 
	ZonePoint(54.0637425858926, 13.4701245358158, 0), 
	ZonePoint(54.0637866478274, 13.4696365308314, 0), 
	ZonePoint(54.0639304905352, 13.4694404540561, 0), 
	ZonePoint(54.0641989955903, 13.4695221527126, 0), 
	ZonePoint(54.0643716050661, 13.4697427390853, 0), 
	ZonePoint(54.0645106510666, 13.4700286843831, 0), 
	ZonePoint(54.0646113392591, 13.4703963283375, 0), 
	ZonePoint(54.0646353126022, 13.4707966517546, 0), 
	ZonePoint(54.0646065445888, 13.4709600490677, 0), 
	ZonePoint(54.064549008502, 13.471164295709, 0), 
	ZonePoint(54.0645298297887, 13.4715074300665, 0), 
	ZonePoint(54.0645681872065, 13.4717770356331, 0), 
	ZonePoint(54.0644866776514, 13.4722999070349, 0), 
	ZonePoint(54.064457909535, 13.4726103619298, 0), 
	ZonePoint(54.0646496966015, 13.4730433648094, 0), 
	ZonePoint(54.064875045273, 13.4739828993596, 0), 
	ZonePoint(54.0651099819476, 13.4740891076131, 0), 
	ZonePoint(54.0651339550029, 13.4739338801657, 0), 
	ZonePoint(54.0650092949641, 13.4736969540617, 0), 
	ZonePoint(54.0649373755406, 13.4733701594355, 0), 
	ZonePoint(54.0648942238268, 13.4729943456154, 0), 
	ZonePoint(54.0647983309689, 13.4727165701832, 0), 
	ZonePoint(54.0647791523708, 13.4723979454227, 0), 
	ZonePoint(54.0647887416709, 13.4719894521399, 0), 
	ZonePoint(54.0647935363202, 13.4716463177825, 0), 
	ZonePoint(54.0647983309689, 13.4714420711411, 0), 
	ZonePoint(54.0648366881386, 13.4711397861119, 0), 
	ZonePoint(54.0648654559927, 13.4707312928292, 0), 
	ZonePoint(54.0648606613517, 13.4703391392778, 0), 
	ZonePoint(54.0648606613517, 13.4701594022334, 0), 
	ZonePoint(54.0647839470211, 13.4697754185476, 0), 
	ZonePoint(54.0647072325488, 13.4695793417719, 0), 
	ZonePoint(54.0644866776515, 13.4690891498326, 0), 
	ZonePoint(54.06434283687, 13.4688603935943, 0), 
	ZonePoint(54.0641078958555, 13.4687378456095, 0), 
	ZonePoint(54.0639640537621, 13.4687215058782, 0), 
	ZonePoint(54.0637866478274, 13.4687378456095, 0), 
	ZonePoint(54.0635373192869, 13.4689992813104, 0), 
	ZonePoint(54.0634414232958, 13.4691871882204, 0), 
	ZonePoint(54.0633263478142, 13.469456793787, 0), 
	ZonePoint(54.0631825030139, 13.4700205145172, 0), 
	ZonePoint(54.0631105804269, 13.4703636488746, 0), 
	ZonePoint(54.0631057855833, 13.4707884818887, 0), 
	ZonePoint(54.0630722216629, 13.4712133149026, 0), 
	ZonePoint(54.0630961958945, 13.4719649425428, 0), 
	ZonePoint(54.0630530422676, 13.4725204934073, 0), 
	ZonePoint(54.063024273158, 13.4728554578991, 0), 
	ZonePoint(54.0631105804269, 13.4732476114505, 0), 
	ZonePoint(54.0632400409938, 13.4736397650019, 0), 
	ZonePoint(54.0633023737154, 13.4739992390906, 0), 
	ZonePoint(54.0633311426323, 13.4744976008955, 0), 
	ZonePoint(54.0633455270833, 13.4748080557903, 0), 
	ZonePoint(54.0633838855949, 13.4753309271922, 0), 
	ZonePoint(54.0634941661183, 13.4757475903406, 0), 
	ZonePoint(54.0635469088738, 13.476090724698, 0), 
	ZonePoint(54.0637003419635, 13.4763685001303, 0), 
	ZonePoint(54.0638106216466, 13.4766054262343, 0), 
	ZonePoint(54.0638106216466, 13.4770465989796, 0), 
	ZonePoint(54.0638010321206, 13.4773733936057, 0), 
	ZonePoint(54.0637818530619, 13.4778799252763, 0), 
	ZonePoint(54.0639154856091, 13.4777630486013, 0), 
	ZonePoint(54.0646538706002, 13.4778529171232, 0)
}
_ke5xj.OriginalPoint = ZonePoint(54.0641273730297, 13.4725263544566, 0)
_ke5xj.DistanceRangeUOM = "Meters"
_ke5xj.ProximityRangeUOM = "Meters"
_ke5xj.OutOfRangeName = ""
_ke5xj.InRangeName = ""
_xBqW = Wherigo.Zone(_YQ8fd)
_xBqW.Id = "16eefe2d-7b11-4a38-95e4-a7c62ad7f285"
_xBqW.Name = _FJOj("\107\082\114\099\084\024")
_xBqW.Description = ""
_xBqW.Visible = false
_xBqW.Commands = {}
_xBqW.DistanceRange = Distance(-1, "feet")
_xBqW.ShowObjects = "OnEnter"
_xBqW.ProximityRange = Distance(60, "meters")
_xBqW.AllowSetPositionTo = false
_xBqW.Active = true
_xBqW.Points = {
	ZonePoint(54.0651045666749, 13.474078439191, 0), 
	ZonePoint(54.0651764858088, 13.4742500063697, 0), 
	ZonePoint(54.0652148426292, 13.4744869324737, 0), 
	ZonePoint(54.0652148426292, 13.4747810476373, 0), 
	ZonePoint(54.0651333343434, 13.4751078422634, 0), 
	ZonePoint(54.0650278527949, 13.4753937875613, 0), 
	ZonePoint(54.0648983978009, 13.4755408451431, 0), 
	ZonePoint(54.0647662347449, 13.4755419027276, 0), 
	ZonePoint(54.0644875233207, 13.4751533053168, 0), 
	ZonePoint(54.0642634138916, 13.4746876229745, 0), 
	ZonePoint(54.0641744013215, 13.4743235351606, 0), 
	ZonePoint(54.0642127590675, 13.4738496829527, 0), 
	ZonePoint(54.0636711232936, 13.4729558227702, 0), 
	ZonePoint(54.0636481657527, 13.4726962245083, 0), 
	ZonePoint(54.0638026071468, 13.4716969490071, 0), 
	ZonePoint(54.063758779242, 13.4712097577486, 0), 
	ZonePoint(54.0636606880493, 13.4707794647391, 0), 
	ZonePoint(54.0637253865215, 13.4703598401515, 0), 
	ZonePoint(54.063790084893, 13.469637943615, 0), 
	ZonePoint(54.0639299165127, 13.4694459120241, 0), 
	ZonePoint(54.0641991432308, 13.4695241471167, 0), 
	ZonePoint(54.0643723657004, 13.4697446278323, 0), 
	ZonePoint(54.0645080213467, 13.4700255629376, 0), 
	ZonePoint(54.0646040235364, 13.4703882892761, 0), 
	ZonePoint(54.0646290675494, 13.470797245442, 0), 
	ZonePoint(54.0645998495328, 13.4709750524707, 0), 
	ZonePoint(54.0645435004427, 13.47115641564, 0), 
	ZonePoint(54.0645247173957, 13.471497805135, 0), 
	ZonePoint(54.064564370485, 13.4717751840998, 0), 
	ZonePoint(54.0644850642685, 13.4722837122018, 0), 
	ZonePoint(54.0644537591414, 13.4726179894157, 0), 
	ZonePoint(54.0646457635497, 13.4730482824252, 0), 
	ZonePoint(54.0648732458845, 13.4739906596772, 0)
}
_xBqW.OriginalPoint = ZonePoint(54.0644443726819, 13.4725394496365, 0)
_xBqW.DistanceRangeUOM = "Feet"
_xBqW.ProximityRangeUOM = "Meters"
_xBqW.OutOfRangeName = ""
_xBqW.InRangeName = ""
_PnJo = Wherigo.Zone(_YQ8fd)
_PnJo.Id = "e7d2909d-c330-452d-aeb0-0533b914486c"
_PnJo.Name = _FJOj("\107\082\114\099\084\030")
_PnJo.Description = ""
_PnJo.Visible = false
_PnJo.Commands = {}
_PnJo.DistanceRange = Distance(-1, "feet")
_PnJo.ShowObjects = "OnEnter"
_PnJo.ProximityRange = Distance(60, "meters")
_PnJo.AllowSetPositionTo = false
_PnJo.Active = true
_PnJo.Points = {
	ZonePoint(54.0619424369809, 13.4718217338595, 0), 
	ZonePoint(54.0619280557551, 13.4731939171962, 0), 
	ZonePoint(54.0619664056796, 13.4749173141252, 0), 
	ZonePoint(54.0616601172022, 13.4747293631397, 0), 
	ZonePoint(54.0615182273983, 13.4725037934509, 0), 
	ZonePoint(54.0616016920475, 13.4718851846237, 0), 
	ZonePoint(54.0617060226232, 13.4716220981109, 0)
}
_PnJo.OriginalPoint = ZonePoint(54.0617604225267, 13.4729533435009, 0)
_PnJo.DistanceRangeUOM = "Feet"
_PnJo.ProximityRangeUOM = "Meters"
_PnJo.OutOfRangeName = ""
_PnJo.InRangeName = ""
_daK = Wherigo.Zone(_YQ8fd)
_daK.Id = "32e4d761-4048-4397-bffb-8ae8954cb0b9"
_daK.Name = _FJOj("\045\023\114\029\113\035\084\024")
_daK.Description = ""
_daK.Visible = false
_daK.Commands = {}
_daK.DistanceRange = Distance(-1, "feet")
_daK.ShowObjects = "OnEnter"
_daK.ProximityRange = Distance(60, "meters")
_daK.AllowSetPositionTo = false
_daK.Active = true
_daK.Points = {
	ZonePoint(54.066455828012, 13.4793407881701, 0), 
	ZonePoint(54.0663359531101, 13.4787361510163, 0), 
	ZonePoint(54.0664606230009, 13.4783848078053, 0), 
	ZonePoint(54.0666476271353, 13.4780988307731, 0), 
	ZonePoint(54.0668825798541, 13.4776085844322, 0), 
	ZonePoint(54.0671894548725, 13.4770039472783, 0), 
	ZonePoint(54.0674244045256, 13.4766199209779, 0), 
	ZonePoint(54.0674483789052, 13.476293090084, 0), 
	ZonePoint(54.0672853528506, 13.4758355268325, 0), 
	ZonePoint(54.0673524813036, 13.4752717435404, 0), 
	ZonePoint(54.0675490711486, 13.4748550341507, 0), 
	ZonePoint(54.0677984032719, 13.474511861712, 0), 
	ZonePoint(54.0681292455089, 13.474160518501, 0), 
	ZonePoint(54.0684888536462, 13.4736702721601, 0), 
	ZonePoint(54.0687621537478, 13.4731636842745, 0), 
	ZonePoint(54.0688820216459, 13.4725590471206, 0), 
	ZonePoint(54.0689012004774, 13.4719135561051, 0), 
	ZonePoint(54.0688772269366, 13.4714233097642, 0), 
	ZonePoint(54.068709411763, 13.4712680650896, 0), 
	ZonePoint(54.0685703643911, 13.4714314805366, 0), 
	ZonePoint(54.0683689846132, 13.4717011160241, 0), 
	ZonePoint(54.0681617648191, 13.4722616128925, 0), 
	ZonePoint(54.0678202816823, 13.473012473113, 0), 
	ZonePoint(54.0674677800149, 13.4736694758058, 0), 
	ZonePoint(54.0670932437145, 13.4743452500042, 0), 
	ZonePoint(54.0669330679896, 13.4742414597418, 0), 
	ZonePoint(54.0668083997886, 13.4740617029327, 0), 
	ZonePoint(54.0670001972835, 13.4735387735024, 0), 
	ZonePoint(54.0671824040831, 13.4732119426084, 0), 
	ZonePoint(54.0674413281598, 13.4723703530566, 0), 
	ZonePoint(54.0676427124366, 13.4716431543176, 0), 
	ZonePoint(54.067834506078, 13.471161078749, 0), 
	ZonePoint(54.0678536853934, 13.4704665630994, 0), 
	ZonePoint(54.0679304025665, 13.4699518044414, 0), 
	ZonePoint(54.0680262988335, 13.4689631409873, 0), 
	ZonePoint(54.0679639662851, 13.4685872854592, 0), 
	ZonePoint(54.0679304025665, 13.4681705760695, 0), 
	ZonePoint(54.0679783507277, 13.467713012818, 0), 
	ZonePoint(54.0678365914347, 13.4671556385181, 0), 
	ZonePoint(54.0676162783298, 13.4667238938914, 0), 
	ZonePoint(54.0673298695459, 13.4663860067922, 0), 
	ZonePoint(54.0669663478599, 13.4656726895828, 0), 
	ZonePoint(54.0668011096779, 13.4648092003293, 0), 
	ZonePoint(54.0667019664531, 13.4638518535482, 0), 
	ZonePoint(54.0667129823787, 13.4630822218223, 0), 
	ZonePoint(54.0667570460517, 13.4621811895577, 0), 
	ZonePoint(54.0664375833631, 13.4613740148207, 0), 
	ZonePoint(54.0661621825211, 13.4608671841719, 0), 
	ZonePoint(54.0657215373749, 13.4602101814791, 0), 
	ZonePoint(54.06456482162, 13.460135095457, 0), 
	ZonePoint(54.063968500588, 13.4603236914098, 0), 
	ZonePoint(54.0637575078908, 13.4604135698976, 0), 
	ZonePoint(54.0634793795177, 13.4604299114423, 0), 
	ZonePoint(54.0630382065535, 13.4607567423362, 0), 
	ZonePoint(54.0628799585875, 13.4607567423362, 0), 
	ZonePoint(54.0625778471597, 13.4608384500596, 0), 
	ZonePoint(54.0622085968747, 13.4609773531895, 0), 
	ZonePoint(54.061743432752, 13.4611897932706, 0), 
	ZonePoint(54.061628339794, 13.4612633302217, 0), 
	ZonePoint(54.0615899754038, 13.4614757703028, 0), 
	ZonePoint(54.0632472715349, 13.4608420327586, 0), 
	ZonePoint(54.0641531505132, 13.4605503968694, 0), 
	ZonePoint(54.0647375780776, 13.4611870166764, 0), 
	ZonePoint(54.065021439927, 13.4619338890758, 0), 
	ZonePoint(54.0655077575566, 13.4645728382203, 0), 
	ZonePoint(54.0665534255321, 13.4668170119537, 0), 
	ZonePoint(54.0669729376185, 13.467080195561, 0), 
	ZonePoint(54.0669666762752, 13.4681933910897, 0), 
	ZonePoint(54.0670021572079, 13.4688975850663, 0), 
	ZonePoint(54.067192084038, 13.4695342048733, 0), 
	ZonePoint(54.0671733001045, 13.4713338117023, 0), 
	ZonePoint(54.0666556950384, 13.4733752629273, 0), 
	ZonePoint(54.0663467986184, 13.4740438915515, 0), 
	ZonePoint(54.066073381627, 13.4740865699743, 0), 
	ZonePoint(54.0658813625111, 13.4740296654106, 0), 
	ZonePoint(54.0658250089064, 13.4738945170717, 0), 
	ZonePoint(54.0658020500085, 13.4736526726756, 0), 
	ZonePoint(54.0658020500085, 13.4722762935397, 0), 
	ZonePoint(54.0658124858728, 13.4711595414758, 0), 
	ZonePoint(54.0658584036444, 13.4699147541435, 0), 
	ZonePoint(54.0658584036444, 13.4695555440848, 0), 
	ZonePoint(54.0657477834721, 13.4688513501082, 0), 
	ZonePoint(54.0656037680893, 13.4685277054018, 0), 
	ZonePoint(54.0653094742322, 13.4681435995964, 0), 
	ZonePoint(54.0652739918532, 13.4676670238749, 0), 
	ZonePoint(54.0652614686534, 13.4664471322892, 0), 
	ZonePoint(54.0648544626035, 13.4655900072976, 0), 
	ZonePoint(54.0647667992399, 13.4648111260811, 0), 
	ZonePoint(54.064725054716, 13.4638793138494, 0), 
	ZonePoint(54.0645726868477, 13.4633600597051, 0), 
	ZonePoint(54.0642825601828, 13.4630648672805, 0), 
	ZonePoint(54.0638964172332, 13.4621259419785, 0), 
	ZonePoint(54.0636271586734, 13.4618129668778, 0), 
	ZonePoint(54.0634079934407, 13.4617987407368, 0), 
	ZonePoint(54.0631992635723, 13.4618698714415, 0), 
	ZonePoint(54.0631533428605, 13.4619516717519, 0), 
	ZonePoint(54.0631909143557, 13.4627767879265, 0), 
	ZonePoint(54.0632702318452, 13.4631857894786, 0), 
	ZonePoint(54.063410080734, 13.4635805648897, 0), 
	ZonePoint(54.0635708020097, 13.4637726177924, 0), 
	ZonePoint(54.0637544827061, 13.4639255488075, 0), 
	ZonePoint(54.0638379736631, 13.4642100716263, 0), 
	ZonePoint(54.0638880681568, 13.464629742784, 0), 
	ZonePoint(54.063883893618, 13.4650565270123, 0), 
	ZonePoint(54.0638379736631, 13.4655615550157, 0), 
	ZonePoint(54.0637649190849, 13.4658354082288, 0), 
	ZonePoint(54.0635895875728, 13.4661661660056, 0), 
	ZonePoint(54.0632744064458, 13.4663617754436, 0), 
	ZonePoint(54.0631032474806, 13.4664044538664, 0), 
	ZonePoint(54.0629504075574, 13.4662137418374, 0), 
	ZonePoint(54.0629222422731, 13.4657911182152, 0), 
	ZonePoint(54.0629086139029, 13.4653746868805, 0), 
	ZonePoint(54.0629167909255, 13.46473068898, 0), 
	ZonePoint(54.0629513161146, 13.464393209311, 0), 
	ZonePoint(54.0629031625535, 13.464092883367, 0), 
	ZonePoint(54.0626778394881, 13.4634721065447, 0), 
	ZonePoint(54.0624634180165, 13.462967435113, 0), 
	ZonePoint(54.0621944810465, 13.4626841379597, 0), 
	ZonePoint(54.0620809091679, 13.4625215904127, 0), 
	ZonePoint(54.0617565461726, 13.4626655610972, 0), 
	ZonePoint(54.0616048124733, 13.4629349256036, 0), 
	ZonePoint(54.0615666518149, 13.4636718078167, 0), 
	ZonePoint(54.0615575659387, 13.4642693635609, 0), 
	ZonePoint(54.0616011781264, 13.4648235732926, 0), 
	ZonePoint(54.0616865851945, 13.4653127640055, 0), 
	ZonePoint(54.0618174212136, 13.4658081470058, 0), 
	ZonePoint(54.0619073707377, 13.46630662615, 0), 
	ZonePoint(54.0620899949297, 13.4668871531035, 0), 
	ZonePoint(54.0623671097072, 13.4681008414544, 0), 
	ZonePoint(54.0624243495784, 13.4686024167423, 0), 
	ZonePoint(54.0624516066322, 13.4691148285333, 0), 
	ZonePoint(54.0625006692839, 13.4696489133306, 0), 
	ZonePoint(54.0625242920215, 13.470405920478, 0), 
	ZonePoint(54.0624725036946, 13.4708300921721, 0), 
	ZonePoint(54.0623316754617, 13.4712573600099, 0), 
	ZonePoint(54.0621808524375, 13.471568522457, 0), 
	ZonePoint(54.0620790920154, 13.4717450026509, 0), 
	ZonePoint(54.0619446225038, 13.4718270504603, 0), 
	ZonePoint(54.0619309938128, 13.4731909017832, 0), 
	ZonePoint(54.0619700627151, 13.4749262903564, 0), 
	ZonePoint(54.062339852598, 13.4752792507442, 0), 
	ZonePoint(54.0625124806544, 13.4756167304132, 0), 
	ZonePoint(54.0624788636681, 13.4760022003103, 0), 
	ZonePoint(54.0624098124758, 13.4763102666137, 0), 
	ZonePoint(54.0623189554688, 13.4765641504014, 0), 
	ZonePoint(54.0622181039584, 13.4772592346738, 0), 
	ZonePoint(54.0622698926024, 13.4777902233274, 0), 
	ZonePoint(54.0624743208301, 13.4787856335437, 0), 
	ZonePoint(54.0637799120426, 13.4778614346337, 0), 
	ZonePoint(54.0638085230281, 13.4770480585368, 0), 
	ZonePoint(54.0638103401051, 13.4766068580521, 0), 
	ZonePoint(54.0637013153494, 13.4763715511269, 0), 
	ZonePoint(54.0635459545782, 13.4760944462611, 0), 
	ZonePoint(54.06349325898, 13.4757507743046, 0), 
	ZonePoint(54.0633805992008, 13.4753327948981, 0), 
	ZonePoint(54.0633415316254, 13.4747692967351, 0), 
	ZonePoint(54.0633015554636, 13.4740045492283, 0), 
	ZonePoint(54.0632397740471, 13.473646944625, 0), 
	ZonePoint(54.0631098510624, 13.4732552824403, 0), 
	ZonePoint(54.0630226298097, 13.4728527837525, 0), 
	ZonePoint(54.0630944056456, 13.4719703827831, 0), 
	ZonePoint(54.0630707832323, 13.4712118275638, 0), 
	ZonePoint(54.0631043997395, 13.4707953962291, 0), 
	ZonePoint(54.0631080339549, 13.4703603880319, 0), 
	ZonePoint(54.0631807181954, 13.4700244564347, 0), 
	ZonePoint(54.0633251777457, 13.4694532179124, 0), 
	ZonePoint(54.0635368691351, 13.4689949886371, 0), 
	ZonePoint(54.0637858095601, 13.4687349125618, 0), 
	ZonePoint(54.0639602486768, 13.4687163356993, 0), 
	ZonePoint(54.0641101567073, 13.4687349125619, 0), 
	ZonePoint(54.0643463743239, 13.4688556621682, 0), 
	ZonePoint(54.0644908298197, 13.4690925171652, 0), 
	ZonePoint(54.0647879159582, 13.4697721207189, 0), 
	ZonePoint(54.0648651398357, 13.4701544944723, 0), 
	ZonePoint(54.0648705909275, 13.4707334733539, 0), 
	ZonePoint(54.0648387928819, 13.4711483566168, 0), 
	ZonePoint(54.0648024522285, 13.4714409422014, 0), 
	ZonePoint(54.0647815563383, 13.4723976506208, 0), 
	ZonePoint(54.064800635195, 13.4727150053555, 0), 
	ZonePoint(54.0648978463759, 13.4729874660057, 0), 
	ZonePoint(54.0649387295149, 13.4733574551841, 0), 
	ZonePoint(54.0650132275757, 13.4736933867812, 0), 
	ZonePoint(54.0651395105687, 13.4739271456345, 0), 
	ZonePoint(54.0651140722989, 13.4740912412533, 0), 
	ZonePoint(54.0651803934698, 13.4742491445847, 0), 
	ZonePoint(54.0652185508078, 13.474482903438, 0), 
	ZonePoint(54.0652176423002, 13.4747801332382, 0), 
	ZonePoint(54.0651358765312, 13.4751129686917, 0), 
	ZonePoint(54.0650313978142, 13.4753978139169, 0), 
	ZonePoint(54.0649005719198, 13.4755433326732, 0), 
	ZonePoint(54.0647724711655, 13.4755495249607, 0), 
	ZonePoint(54.0648260736569, 13.4762724745269, 0), 
	ZonePoint(54.0649014804344, 13.4769660107274, 0), 
	ZonePoint(54.065087725503, 13.4780527571845, 0), 
	ZonePoint(54.0656437302023, 13.478322121691, 0), 
	ZonePoint(54.0658190700096, 13.4789134851477, 0), 
	ZonePoint(54.0663768818819, 13.4792556090323, 0), 
	ZonePoint(54.0664377501507, 13.4793701663511, 0)
}
_daK.OriginalPoint = ZonePoint(54.0647645316035, 13.4696432793013, 0)
_daK.DistanceRangeUOM = "Feet"
_daK.ProximityRangeUOM = "Meters"
_daK.OutOfRangeName = ""
_daK.InRangeName = ""
_x8no = Wherigo.Zone(_YQ8fd)
_x8no.Id = "fd2148ef-fe8b-4042-a235-99d130dd3b55"
_x8no.Name = _FJOj("\037\049\017\029\120\084\024")
_x8no.Description = ""
_x8no.Visible = false
_x8no.Commands = {}
_x8no.DistanceRange = Distance(-1, "feet")
_x8no.ShowObjects = "OnEnter"
_x8no.ProximityRange = Distance(60, "meters")
_x8no.AllowSetPositionTo = false
_x8no.Active = true
_x8no.Points = {
	ZonePoint(54.0740911070637, 13.460494164923, 0), 
	ZonePoint(54.0739472835902, 13.4606085557359, 0), 
	ZonePoint(54.0738082537589, 13.4606984342317, 0), 
	ZonePoint(54.0737219591466, 13.4609762404915, 0), 
	ZonePoint(54.0737651064752, 13.4612949006132, 0), 
	ZonePoint(54.0738801657988, 13.4617442930923, 0), 
	ZonePoint(54.0740048130394, 13.4621446609374, 0), 
	ZonePoint(54.0740431659613, 13.4623162471567, 0), 
	ZonePoint(54.0743883406634, 13.4622181978885, 0), 
	ZonePoint(54.0744410754346, 13.4620139285798, 0), 
	ZonePoint(54.0745033982597, 13.4616462438241, 0), 
	ZonePoint(54.0744602516984, 13.4612622175237, 0), 
	ZonePoint(54.0744075169516, 13.4609680697192, 0), 
	ZonePoint(54.074311635422, 13.4604614818335, 0)
}
_x8no.OriginalPoint = ZonePoint(54.0741267195188, 13.4613462597536, 0)
_x8no.DistanceRangeUOM = "Feet"
_x8no.ProximityRangeUOM = "Meters"
_x8no.OutOfRangeName = ""
_x8no.InRangeName = ""
_ja8Ru = Wherigo.Zone(_YQ8fd)
_ja8Ru.Id = "07566aed-6a43-4bae-be0d-09f43e42cb24"
_ja8Ru.Name = _FJOj("\093\035\035\049\084\024")
_ja8Ru.Description = ""
_ja8Ru.Visible = false
_ja8Ru.Commands = {}
_ja8Ru.DistanceRange = Distance(-1, "feet")
_ja8Ru.ShowObjects = "OnEnter"
_ja8Ru.ProximityRange = Distance(60, "meters")
_ja8Ru.AllowSetPositionTo = false
_ja8Ru.Active = true
_ja8Ru.Points = {
	ZonePoint(54.0708489659059, 13.442117815772, 0), 
	ZonePoint(54.0709735857971, 13.4427059393592, 0), 
	ZonePoint(54.0712707547974, 13.4436534718052, 0), 
	ZonePoint(54.0716254375942, 13.4442252586261, 0), 
	ZonePoint(54.0721191126595, 13.4444784785039, 0), 
	ZonePoint(54.0736672012533, 13.4445029836533, 0), 
	ZonePoint(54.0738253618534, 13.4459977977707, 0), 
	ZonePoint(54.0740266562911, 13.4467329522547, 0), 
	ZonePoint(54.0745826072867, 13.4496245598915, 0), 
	ZonePoint(54.07518446502, 13.4496301700655, 0), 
	ZonePoint(54.0753496215345, 13.4492173177006, 0), 
	ZonePoint(54.0759772102969, 13.4488982954187, 0), 
	ZonePoint(54.0765167088421, 13.449198551684, 0), 
	ZonePoint(54.076758930398, 13.4497990642148, 0), 
	ZonePoint(54.0770451904146, 13.450606002928, 0), 
	ZonePoint(54.0771112501381, 13.4510751533427, 0), 
	ZonePoint(54.0771332700226, 13.4516193678237, 0), 
	ZonePoint(54.0774046338313, 13.4516485188272, 0), 
	ZonePoint(54.0775771571046, 13.452375504928, 0), 
	ZonePoint(54.0775196494265, 13.4526777351047, 0), 
	ZonePoint(54.0774238031193, 13.4532985322245, 0), 
	ZonePoint(54.0773183719257, 13.4537722984475, 0), 
	ZonePoint(54.077303994924, 13.4540908653905, 0), 
	ZonePoint(54.0772464868675, 13.4544747793988, 0), 
	ZonePoint(54.0771458475769, 13.4547279992766, 0), 
	ZonePoint(54.0770020767384, 13.4550547346028, 0), 
	ZonePoint(54.0768487206285, 13.4552262706491, 0), 
	ZonePoint(54.0768103815125, 13.4554468169942, 0), 
	ZonePoint(54.0768103815125, 13.4558470677688, 0), 
	ZonePoint(54.0766953639521, 13.4564106862065, 0), 
	ZonePoint(54.0765180445887, 13.4568436105137, 0), 
	ZonePoint(54.0763215546797, 13.457072325242, 0), 
	ZonePoint(54.0761538186556, 13.457178514223, 0), 
	ZonePoint(54.0759237795777, 13.457129503924, 0), 
	ZonePoint(54.0757560419463, 13.4567700950651, 0), 
	ZonePoint(54.075784797017, 13.4566148957852, 0), 
	ZonePoint(54.0758518921044, 13.4563044972253, 0), 
	ZonePoint(54.0759812894667, 13.4559940986654, 0), 
	ZonePoint(54.0760531767159, 13.4558143942359, 0), 
	ZonePoint(54.0761011014796, 13.4554958272928, 0), 
	ZonePoint(54.0760963090057, 13.455136418434, 0), 
	ZonePoint(54.0760963090057, 13.4547034941267, 0), 
	ZonePoint(54.0761298563112, 13.4544911161647, 0), 
	ZonePoint(54.0761154788979, 13.4539601712595, 0), 
	ZonePoint(54.0760483842365, 13.4536497726996, 0), 
	ZonePoint(54.0758950246033, 13.4534864050366, 0), 
	ZonePoint(54.075861477108, 13.4535844256344, 0), 
	ZonePoint(54.0752001066653, 13.4559450883663, 0), 
	ZonePoint(54.0734459861989, 13.4570233149427, 0), 
	ZonePoint(54.0734411934185, 13.4574807443994, 0), 
	ZonePoint(54.0730577691938, 13.4574807443994, 0), 
	ZonePoint(54.0730721476662, 13.4569743046438, 0), 
	ZonePoint(54.07184995974, 13.4558797413009, 0), 
	ZonePoint(54.0714856928496, 13.4552752809475, 0), 
	ZonePoint(54.071289179121, 13.4549485456212, 0), 
	ZonePoint(54.0712843860916, 13.454572799996, 0), 
	ZonePoint(54.0712508348704, 13.4540663602404, 0), 
	ZonePoint(54.0711070436153, 13.4527512505524, 0), 
	ZonePoint(54.071174146263, 13.4523755049272, 0), 
	ZonePoint(54.0714617278106, 13.4525470409735, 0), 
	ZonePoint(54.0719218541434, 13.4525307042072, 0), 
	ZonePoint(54.0722957030341, 13.4528084292345, 0), 
	ZonePoint(54.0724251114812, 13.4526287248051, 0), 
	ZonePoint(54.072760612984, 13.4512809415844, 0), 
	ZonePoint(54.0718164089759, 13.4490591413662, 0), 
	ZonePoint(54.0704168386585, 13.4484791861622, 0), 
	ZonePoint(54.0701340430362, 13.4488222582547, 0), 
	ZonePoint(54.0700429728496, 13.4489202788525, 0), 
	ZonePoint(54.0698128999093, 13.448789584722, 0), 
	ZonePoint(54.0697457950616, 13.4486262170589, 0), 
	ZonePoint(54.0697745542953, 13.4483403236484, 0), 
	ZonePoint(54.0699758683737, 13.4479972515559, 0), 
	ZonePoint(54.0700285933282, 13.4478012103602, 0), 
	ZonePoint(54.0695301001737, 13.4459959976829, 0), 
	ZonePoint(54.0692472985119, 13.4457264410388, 0), 
	ZonePoint(54.0689405284297, 13.4457427778051, 0), 
	ZonePoint(54.0691322599966, 13.4445420254812, 0), 
	ZonePoint(54.0696834833202, 13.4435699878857, 0), 
	ZonePoint(54.0702394924765, 13.4420098267031, 0), 
	ZonePoint(54.070349455546, 13.4419594682535, 0)
}
_ja8Ru.OriginalPoint = ZonePoint(54.0738400697839, 13.4515789506767, 0)
_ja8Ru.DistanceRangeUOM = "Feet"
_ja8Ru.ProximityRangeUOM = "Meters"
_ja8Ru.OutOfRangeName = ""
_ja8Ru.InRangeName = ""
_iR0vR = Wherigo.Zone(_YQ8fd)
_iR0vR.Id = "9f8cc279-907f-49c3-8271-c9c321e96c57"
_iR0vR.Name = _FJOj("\045\023\114\029\113\035\084\024")
_iR0vR.Description = ""
_iR0vR.Visible = false
_iR0vR.Commands = {}
_iR0vR.DistanceRange = Distance(-1, "feet")
_iR0vR.ShowObjects = "OnEnter"
_iR0vR.ProximityRange = Distance(60, "meters")
_iR0vR.AllowSetPositionTo = false
_iR0vR.Active = true
_iR0vR.Points = {
	ZonePoint(54.0740365307447, 13.4623102898045, 0), 
	ZonePoint(54.0739981904527, 13.4621550962778, 0), 
	ZonePoint(54.0738783768121, 13.4617548603404, 0), 
	ZonePoint(54.0737681479573, 13.4613301201619, 0), 
	ZonePoint(54.0737154297059, 13.4609952288673, 0), 
	ZonePoint(54.0737969033389, 13.4606930098942, 0), 
	ZonePoint(54.0733559852985, 13.460227429314, 0), 
	ZonePoint(54.0730205010438, 13.4598516976176, 0), 
	ZonePoint(54.0727521116881, 13.4593126043142, 0), 
	ZonePoint(54.0724980987355, 13.4586754940465, 0), 
	ZonePoint(54.072368695313, 13.4584141154751, 0), 
	ZonePoint(54.072148229294, 13.458365106993, 0), 
	ZonePoint(54.0719229693263, 13.4583977793144, 0), 
	ZonePoint(54.0717504289499, 13.4586264855643, 0), 
	ZonePoint(54.07162581601, 13.4588061833322, 0), 
	ZonePoint(54.07162581601, 13.4589532087785, 0), 
	ZonePoint(54.0717408433524, 13.4592227554303, 0), 
	ZonePoint(54.0719229693263, 13.459631159448, 0), 
	ZonePoint(54.0721003017436, 13.4599252103409, 0), 
	ZonePoint(54.0723159752845, 13.4602846058765, 0), 
	ZonePoint(54.0724980987354, 13.4605623206086, 0), 
	ZonePoint(54.0726802213874, 13.4608155310996, 0), 
	ZonePoint(54.0729725745003, 13.4610524054299, 0), 
	ZonePoint(54.0730540495912, 13.4611994308763, 0), 
	ZonePoint(54.0730492569432, 13.461444473287, 0), 
	ZonePoint(54.0730205010437, 13.4616323391351, 0), 
	ZonePoint(54.0729198552387, 13.4619182219475, 0), 
	ZonePoint(54.0727569043703, 13.4620815835547, 0), 
	ZonePoint(54.0725651966476, 13.4622857855635, 0), 
	ZonePoint(54.0724166225535, 13.4623838025278, 0), 
	ZonePoint(54.0722344987452, 13.4625716683759, 0), 
	ZonePoint(54.0721692306623, 13.4626093420296, 0), 
	ZonePoint(54.0718609286124, 13.462684402624, 0), 
	ZonePoint(54.0716186896815, 13.4627782283671, 0), 
	ZonePoint(54.0714204931412, 13.4630597055964, 0), 
	ZonePoint(54.0713434164534, 13.4634725388659, 0), 
	ZonePoint(54.0712443176445, 13.4637352509466, 0), 
	ZonePoint(54.0713103835434, 13.4641480842161, 0), 
	ZonePoint(54.0713103835434, 13.4645609174856, 0), 
	ZonePoint(54.0712002736535, 13.4650300462011, 0), 
	ZonePoint(54.0711342075794, 13.4653678188762, 0), 
	ZonePoint(54.0710351082712, 13.4658181824429, 0), 
	ZonePoint(54.0711782516405, 13.4661371899694, 0), 
	ZonePoint(54.0713764493371, 13.4665687883876, 0), 
	ZonePoint(54.0712773506071, 13.467037917103, 0), 
	ZonePoint(54.0710791524374, 13.4675070458184, 0), 
	ZonePoint(54.0709249976513, 13.4678260533449, 0), 
	ZonePoint(54.0708919644084, 13.4682388866144, 0), 
	ZonePoint(54.0709029754923, 13.4686141895867, 0), 
	ZonePoint(54.0709360087264, 13.4688581365187, 0), 
	ZonePoint(54.0707267977996, 13.4695149167203, 0), 
	ZonePoint(54.0706827532596, 13.4694398561258, 0), 
	ZonePoint(54.0702863502973, 13.4694398561258, 0), 
	ZonePoint(54.0700000569154, 13.4695149167203, 0), 
	ZonePoint(54.0697688185119, 13.4696838030578, 0), 
	ZonePoint(54.069570613141, 13.4697963939496, 0), 
	ZonePoint(54.0695485902636, 13.4701154014761, 0), 
	ZonePoint(54.0695596017038, 13.4709223028666, 0), 
	ZonePoint(54.0694825215614, 13.4714477270278, 0), 
	ZonePoint(54.069416452754, 13.4719919163377, 0), 
	ZonePoint(54.0693613953342, 13.4725736359448, 0), 
	ZonePoint(54.0693283608473, 13.4729677040658, 0), 
	ZonePoint(54.0693283608473, 13.4734743630784, 0), 
	ZonePoint(54.0694959919143, 13.4736534212852, 0), 
	ZonePoint(54.069721262981, 13.4738249493975, 0), 
	ZonePoint(54.069793157745, 13.4739801414991, 0), 
	ZonePoint(54.0697596068706, 13.4742415176703, 0), 
	ZonePoint(54.0696541610889, 13.474421213788, 0), 
	ZonePoint(54.069505577942, 13.4745110618468, 0), 
	ZonePoint(54.0694049245404, 13.4746254139217, 0), 
	ZonePoint(54.0695678870683, 13.4748949580982, 0), 
	ZonePoint(54.0697596068706, 13.4752625183389, 0), 
	ZonePoint(54.0700280131066, 13.4756790866117, 0), 
	ZonePoint(54.0703251751297, 13.4759404627829, 0), 
	ZonePoint(54.0705887848216, 13.4758832867455, 0), 
	ZonePoint(54.0707388352547, 13.4758367939037, 0), 
	ZonePoint(54.0710328582953, 13.4760984091695, 0), 
	ZonePoint(54.0711957426675, 13.4762535329238, 0), 
	ZonePoint(54.0714688120931, 13.4763025193725, 0), 
	ZonePoint(54.0716364854118, 13.4761065735776, 0), 
	ZonePoint(54.0717945767778, 13.4766290956975, 0), 
	ZonePoint(54.0717562516534, 13.4768821923493, 0), 
	ZonePoint(54.0716029508022, 13.4773149059798, 0), 
	ZonePoint(54.0715167188246, 13.4777231263859, 0), 
	ZonePoint(54.0715167188246, 13.4780088806702, 0), 
	ZonePoint(54.071650857379, 13.4785395671982, 0), 
	ZonePoint(54.0717658329378, 13.4787436774012, 0), 
	ZonePoint(54.0719670393996, 13.4788334858906, 0), 
	ZonePoint(54.0722017790393, 13.4788743079312, 0), 
	ZonePoint(54.07239819282, 13.4786212112794, 0), 
	ZonePoint(54.0726506674932, 13.4784643571481, 0), 
	ZonePoint(54.0727800118596, 13.4782684113532, 0), 
	ZonePoint(54.0728854032676, 13.4779336706201, 0), 
	ZonePoint(54.072947679883, 13.4776887383765, 0), 
	ZonePoint(54.0730243278967, 13.4773376688273, 0), 
	ZonePoint(54.0730722328334, 13.476782489075, 0), 
	ZonePoint(54.0730578613582, 13.4764314195257, 0), 
	ZonePoint(54.0729716324024, 13.4762191449146, 0), 
	ZonePoint(54.072952470388, 13.4758680753654, 0), 
	ZonePoint(54.0729955849081, 13.4754843481836, 0), 
	ZonePoint(54.0730626518505, 13.4749128396151, 0), 
	ZonePoint(54.0731057662562, 13.4745617700658, 0), 
	ZonePoint(54.0731249282, 13.4742025361085, 0), 
	ZonePoint(54.0732063663622, 13.4734269173369, 0), 
	ZonePoint(54.0732734329641, 13.4728880664008, 0), 
	ZonePoint(54.0732973852956, 13.4724390239542, 0), 
	ZonePoint(54.0732973852956, 13.4719573238749, 0), 
	ZonePoint(54.0733213376133, 13.4715817611013, 0), 
	ZonePoint(54.0733261280752, 13.4712306915521, 0), 
	ZonePoint(54.0733261280752, 13.4706265253511, 0), 
	ZonePoint(54.0732303187324, 13.4702264693531, 0), 
	ZonePoint(54.073077023324, 13.4694426861734, 0), 
	ZonePoint(54.0730818138141, 13.4690752878079, 0), 
	ZonePoint(54.073273432964, 13.4684221351582, 0), 
	ZonePoint(54.0734315180969, 13.4680057503439, 0), 
	ZonePoint(54.0735848121963, 13.4674832282241, 0), 
	ZonePoint(54.0737524769694, 13.4669851993288, 0), 
	ZonePoint(54.0739009794887, 13.4666831162282, 0), 
	ZonePoint(54.0738195426891, 13.4659891415379, 0), 
	ZonePoint(54.0738578659088, 13.4657197160698, 0), 
	ZonePoint(54.0738818179032, 13.4653114956637, 0), 
	ZonePoint(54.0739728353558, 13.4649196040739, 0), 
	ZonePoint(54.0739872065142, 13.4645766989328, 0), 
	ZonePoint(54.0742602575801, 13.4642664514241, 0), 
	ZonePoint(54.0743273224795, 13.4639643683236, 0), 
	ZonePoint(54.0744997745804, 13.4635479835094, 0), 
	ZonePoint(54.0746099519364, 13.4633357088982, 0), 
	ZonePoint(54.0746099519364, 13.4630989410627, 0), 
	ZonePoint(54.0745237262044, 13.4628213511865, 0), 
	ZonePoint(54.0744662422835, 13.4626090765754, 0), 
	ZonePoint(54.0743895969319, 13.4622171849855, 0)
}
_iR0vR.OriginalPoint = ZonePoint(54.0720751985412, 13.4685153374612, 0)
_iR0vR.DistanceRangeUOM = "Feet"
_iR0vR.ProximityRangeUOM = "Meters"
_iR0vR.OutOfRangeName = ""
_iR0vR.InRangeName = ""
_7L8Hp = Wherigo.Zone(_YQ8fd)
_7L8Hp.Id = "7027a106-c4ab-4a97-800b-d93d8b6f70bc"
_7L8Hp.Name = _FJOj("\107\082\114\099\084\084")
_7L8Hp.Description = _FJOj("\119\035\120\017\061\107\114\120\114\049\017\082\061\045\114\049\061\124\035\049\017\031\061\088\061\045\114\049\061\035\120\061\045\017\023\023\114\120\061\126\029\017\120\061\124\017\120\061\082\048\114\017\049\001\060\080\017\080\060\114\013\061\095\023\061\045\035\001\061\093\088\082\082\035\049\017\049\061\088\061\045\049\114\080\088\023\017\049\061\114\120\080\017\049\017\013")
_7L8Hp.Visible = false
_7L8Hp.Commands = {}
_7L8Hp.DistanceRange = Distance(-1, "feet")
_7L8Hp.ShowObjects = "OnEnter"
_7L8Hp.ProximityRange = Distance(60, "meters")
_7L8Hp.AllowSetPositionTo = false
_7L8Hp.Active = true
_7L8Hp.Points = {
	ZonePoint(54.0727903502715, 13.4782490291566, 0), 
	ZonePoint(54.0746870087155, 13.4786979898188, 0), 
	ZonePoint(54.0766483106712, 13.4765841954511, 0), 
	ZonePoint(54.0773560776412, 13.4736113881677, 0), 
	ZonePoint(54.0770527507451, 13.4702077398411, 0), 
	ZonePoint(54.0758899771098, 13.4689582993161, 0), 
	ZonePoint(54.0753844131962, 13.4673641855429, 0), 
	ZonePoint(54.0759152551439, 13.4657269876136, 0), 
	ZonePoint(54.0762691460044, 13.4643482946205, 0), 
	ZonePoint(54.0764460903033, 13.4621510026628, 0), 
	ZonePoint(54.0765472009927, 13.4609446462938, 0), 
	ZonePoint(54.0768758090321, 13.4600829631732, 0), 
	ZonePoint(54.0780385550533, 13.4589196909603, 0), 
	ZonePoint(54.0793529243795, 13.457282493031, 0), 
	ZonePoint(54.0813244003314, 13.4565500623784, 0), 
	ZonePoint(54.0822848290512, 13.4546112753569, 0), 
	ZonePoint(54.0822090065392, 13.4523708992432, 0), 
	ZonePoint(54.0813244003314, 13.4512937953423, 0), 
	ZonePoint(54.0795804071531, 13.4509922062501, 0), 
	ZonePoint(54.0780891084893, 13.4506906171578, 0), 
	ZonePoint(54.0778300492923, 13.4507820240919, 0), 
	ZonePoint(54.0775840700747, 13.4523809272264, 0), 
	ZonePoint(54.0774298111694, 13.4533189503242, 0), 
	ZonePoint(54.0773297510323, 13.4537666431663, 0), 
	ZonePoint(54.0773151589089, 13.454065105061, 0), 
	ZonePoint(54.0772526211788, 13.4544737136075, 0), 
	ZonePoint(54.0770108077359, 13.4550599780436, 0), 
	ZonePoint(54.0768586313126, 13.4552269745799, 0), 
	ZonePoint(54.0768190236589, 13.4554508210011, 0), 
	ZonePoint(54.0768190236589, 13.4558274514873, 0), 
	ZonePoint(54.0767043697114, 13.4564066096878, 0), 
	ZonePoint(54.0765250919951, 13.4568507494122, 0), 
	ZonePoint(54.076322882479, 13.4570817020689, 0), 
	ZonePoint(54.0761561110029, 13.4571882956027, 0), 
	ZonePoint(54.0759226298107, 13.4571349988358, 0), 
	ZonePoint(54.0757558567266, 13.4567761339385, 0), 
	ZonePoint(54.0758398379595, 13.4562602231106, 0), 
	ZonePoint(54.0760409858997, 13.4558112672144, 0), 
	ZonePoint(54.0760888781228, 13.4554602653319, 0), 
	ZonePoint(54.0760888781228, 13.4547011217256, 0), 
	ZonePoint(54.0755524820685, 13.4547990757393, 0), 
	ZonePoint(54.0752124416945, 13.455941872566, 0), 
	ZonePoint(54.0732391946883, 13.457174460572, 0), 
	ZonePoint(54.0729470312135, 13.4569295755376, 0), 
	ZonePoint(54.0717927259021, 13.4559173840625, 0), 
	ZonePoint(54.0712179561023, 13.4549296810908, 0), 
	ZonePoint(54.0712754334404, 13.4547419358979, 0), 
	ZonePoint(54.0710790522069, 13.4527338786166, 0), 
	ZonePoint(54.0708686831443, 13.4519151970987, 0), 
	ZonePoint(54.069073813773, 13.4501919532456, 0), 
	ZonePoint(54.0679786839351, 13.4504443058521, 0), 
	ZonePoint(54.0674435651667, 13.4517757075321, 0), 
	ZonePoint(54.0671657554735, 13.4525556988268, 0), 
	ZonePoint(54.0665384977593, 13.4536058184042, 0), 
	ZonePoint(54.0663074004392, 13.4548622115388, 0), 
	ZonePoint(54.0656030959121, 13.4582751003523, 0), 
	ZonePoint(54.0647337035389, 13.4593814763962, 0), 
	ZonePoint(54.064172440567, 13.4594002285326, 0), 
	ZonePoint(54.063958159847, 13.4596316530038, 0), 
	ZonePoint(54.0634838966287, 13.4598520445313, 0), 
	ZonePoint(54.063301854763, 13.4596316530038, 0), 
	ZonePoint(54.0631533463343, 13.459394936178, 0), 
	ZonePoint(54.0628802810633, 13.4595010506172, 0), 
	ZonePoint(54.0622287496556, 13.4597459300922, 0), 
	ZonePoint(54.0619748412659, 13.4599989722163, 0), 
	ZonePoint(54.0618646541232, 13.460423429973, 0), 
	ZonePoint(54.0619796320046, 13.4607172853429, 0), 
	ZonePoint(54.0613347454559, 13.4610125804121, 0), 
	ZonePoint(54.0610761646739, 13.4618475352746, 0), 
	ZonePoint(54.0610386286201, 13.4625510291588, 0), 
	ZonePoint(54.0615849833896, 13.4614780233355, 0), 
	ZonePoint(54.0616225189496, 13.4612541843723, 0), 
	ZonePoint(54.061701760576, 13.4612044423806, 0), 
	ZonePoint(54.0623294323279, 13.4609237554268, 0), 
	ZonePoint(54.0625045948448, 13.460856248438, 0), 
	ZonePoint(54.062815297968, 13.4607603174538, 0), 
	ZonePoint(54.0630363336743, 13.4607425524567, 0), 
	ZonePoint(54.0634763163428, 13.46041922951, 0), 
	ZonePoint(54.0637599045972, 13.4603979115136, 0), 
	ZonePoint(54.0640309797948, 13.4602913215313, 0), 
	ZonePoint(54.0645585287609, 13.4601243305588, 0), 
	ZonePoint(54.0650110061321, 13.4601492015548, 0), 
	ZonePoint(54.0657262022445, 13.4601882845484, 0), 
	ZonePoint(54.066168241496, 13.4608598014378, 0), 
	ZonePoint(54.0664184503076, 13.4613074793641, 0), 
	ZonePoint(54.0667645700118, 13.4621601992237, 0), 
	ZonePoint(54.0667186988915, 13.4630697670739, 0), 
	ZonePoint(54.0667103586824, 13.4638478739458, 0), 
	ZonePoint(54.0668104410814, 13.4648178427861, 0), 
	ZonePoint(54.0669751595045, 13.4656634566468, 0), 
	ZonePoint(54.0673316996763, 13.466366950531, 0), 
	ZonePoint(54.0676319416571, 13.4667186974731, 0), 
	ZonePoint(54.0678341867677, 13.4671024214098, 0), 
	ZonePoint(54.0679863912013, 13.4677064313104, 0), 
	ZonePoint(54.0679426064214, 13.4681683212344, 0), 
	ZonePoint(54.0679759662579, 13.4686088931618, 0), 
	ZonePoint(54.0680385158791, 13.4689641931033, 0), 
	ZonePoint(54.0679426064214, 13.4699590329395, 0), 
	ZonePoint(54.0678633767023, 13.4704671118558, 0), 
	ZonePoint(54.0678487817376, 13.4711599467417, 0), 
	ZonePoint(54.0676507067088, 13.471650260661, 0), 
	ZonePoint(54.0675339462492, 13.4720624085929, 0), 
	ZonePoint(54.0674067603749, 13.4725029805204, 0), 
	ZonePoint(54.067196173071, 13.4732100274039, 0), 
	ZonePoint(54.0670064350806, 13.4735546683471, 0), 
	ZonePoint(54.0668187812703, 13.4740663002629, 0), 
	ZonePoint(54.0669376287819, 13.4742297382359, 0), 
	ZonePoint(54.0670898365018, 13.4743256692202, 0), 
	ZonePoint(54.0678216767894, 13.472996847439, 0), 
	ZonePoint(54.0681406800577, 13.4722791415572, 0), 
	ZonePoint(54.0683637723905, 13.4716928966538, 0), 
	ZonePoint(54.0687140457843, 13.4712452187275, 0), 
	ZonePoint(54.0688766717127, 13.4714051037012, 0), 
	ZonePoint(54.0689100307988, 13.4718883116217, 0), 
	ZonePoint(54.0688912663162, 13.472559828511, 0), 
	ZonePoint(54.0687745093449, 13.4731638384116, 0), 
	ZonePoint(54.068499295185, 13.4736683643285, 0), 
	ZonePoint(54.0681365100962, 13.4741657842466, 0), 
	ZonePoint(54.0678195917926, 13.4745068721904, 0), 
	ZonePoint(54.0675527113452, 13.4748692781308, 0), 
	ZonePoint(54.0673588049442, 13.4752743200641, 0), 
	ZonePoint(54.067294169276, 13.4758356939717, 0), 
	ZonePoint(54.0674609707952, 13.4762798188985, 0), 
	ZonePoint(54.06743595061, 13.4766280128411, 0), 
	ZonePoint(54.0672045131825, 13.4769975247803, 0), 
	ZonePoint(54.0667395494069, 13.4779213046282, 0), 
	ZonePoint(54.0666540622268, 13.4781238255948, 0), 
	ZonePoint(54.0664705769535, 13.478390300551, 0), 
	ZonePoint(54.0664761864751, 13.4793525391861, 0), 
	ZonePoint(54.067031848248, 13.4802994064894, 0), 
	ZonePoint(54.0676449836444, 13.480283081191, 0), 
	ZonePoint(54.068425760146, 13.4755569073238, 0), 
	ZonePoint(54.0693071098454, 13.4734917570847, 0), 
	ZonePoint(54.0693236444791, 13.4729624819111, 0), 
	ZonePoint(54.069412580824, 13.4719928058324, 0), 
	ZonePoint(54.0694833667582, 13.4714221352215, 0), 
	ZonePoint(54.0695550600814, 13.4709210585874, 0), 
	ZonePoint(54.069545984984, 13.470121501119, 0), 
	ZonePoint(54.0695686727237, 13.469793636161, 0), 
	ZonePoint(54.069756526732, 13.4696838323308, 0), 
	ZonePoint(54.0699979224225, 13.4695075275892, 0), 
	ZonePoint(54.070283783925, 13.4694332940138, 0), 
	ZonePoint(54.0706821717523, 13.4694302009483, 0), 
	ZonePoint(54.0707266384936, 13.4695044345237, 0), 
	ZonePoint(54.070933544337, 13.4688533442061, 0), 
	ZonePoint(54.0708981526211, 13.4686089920204, 0), 
	ZonePoint(54.0708890778173, 13.468231638012, 0), 
	ZonePoint(54.0709226545814, 13.4678218068145, 0), 
	ZonePoint(54.0710878155667, 13.4674815695939, 0), 
	ZonePoint(54.071275662702, 13.4670361681415, 0), 
	ZonePoint(54.0713727620957, 13.4665660221639, 0), 
	ZonePoint(54.0710306445308, 13.4658190468114, 0), 
	ZonePoint(54.071135004299, 13.465356633498, 0), 
	ZonePoint(54.071197620034, 13.4650318616056, 0), 
	ZonePoint(54.0713074242109, 13.4645586225623, 0), 
	ZonePoint(54.0713074242109, 13.4641518844305, 0), 
	ZonePoint(54.0712402712777, 13.4637343205688, 0), 
	ZonePoint(54.0713382782249, 13.4634729565221, 0), 
	ZonePoint(54.0714172280974, 13.4630476599963, 0), 
	ZonePoint(54.0716168707834, 13.4627677375557, 0), 
	ZonePoint(54.0718528109019, 13.4626764921193, 0), 
	ZonePoint(54.0721667906726, 13.4626007120111, 0), 
	ZonePoint(54.0722294048515, 13.4625682348219, 0), 
	ZonePoint(54.0724118021389, 13.4623780112849, 0), 
	ZonePoint(54.0725633455444, 13.4622805797172, 0), 
	ZonePoint(54.0729163397153, 13.4619140514386, 0), 
	ZonePoint(54.0730188798759, 13.4616294893996, 0), 
	ZonePoint(54.0730461028849, 13.4614408123955, 0), 
	ZonePoint(54.0730515474845, 13.4612010998082, 0), 
	ZonePoint(54.0729707858498, 13.4610603653216, 0), 
	ZonePoint(54.0726794981993, 13.4608237458, 0), 
	ZonePoint(54.072492564861, 13.4605623817533, 0), 
	ZonePoint(54.0722393868133, 13.4601742020153, 0), 
	ZonePoint(54.0719208703022, 13.4596375551265, 0), 
	ZonePoint(54.0716250379636, 13.458960173751, 0), 
	ZonePoint(54.0716232230348, 13.4588086135345, 0), 
	ZonePoint(54.0717493603995, 13.4586214830632, 0), 
	ZonePoint(54.0719217777601, 13.4583925962057, 0), 
	ZonePoint(54.0721495490703, 13.4583585724836, 0), 
	ZonePoint(54.0723709669949, 13.4584065150011, 0), 
	ZonePoint(54.0725061765402, 13.4586833443761, 0), 
	ZonePoint(54.0727466488046, 13.4592942248404, 0), 
	ZonePoint(54.0730216021775, 13.4598447905247, 0), 
	ZonePoint(54.0733346656821, 13.4601974000079, 0), 
	ZonePoint(54.0737965434694, 13.4606768251825, 0), 
	ZonePoint(54.0740851010507, 13.4604866016455, 0), 
	ZonePoint(54.0743119530869, 13.4604541244563, 0), 
	ZonePoint(54.0744740173734, 13.4612752813054, 0), 
	ZonePoint(54.0745157106055, 13.4616447932446, 0), 
	ZonePoint(54.0744010541164, 13.4622203791498, 0), 
	ZonePoint(54.0745245332291, 13.4627950667975, 0), 
	ZonePoint(54.0746183525337, 13.4630899962589, 0), 
	ZonePoint(54.0746225222757, 13.4633458386832, 0), 
	ZonePoint(54.0745120239724, 13.4635448272354, 0), 
	ZonePoint(54.0744244590704, 13.4637722427237, 0), 
	ZonePoint(54.0743348090984, 13.4639570178079, 0), 
	ZonePoint(54.0742764322683, 13.4642626073702, 0), 
	ZonePoint(54.0739928864977, 13.4645930705017, 0), 
	ZonePoint(54.0739776039722, 13.4649119076155, 0), 
	ZonePoint(54.0738868531876, 13.4653125010569, 0), 
	ZonePoint(54.0738623504418, 13.4657161878838, 0), 
	ZonePoint(54.0738224200102, 13.4659806723566, 0), 
	ZonePoint(54.0739050033604, 13.4666813242057, 0), 
	ZonePoint(54.0737552641977, 13.4669844759991, 0), 
	ZonePoint(54.0735873741911, 13.4674840577811, 0), 
	ZonePoint(54.0734385414013, 13.4680052932626, 0), 
	ZonePoint(54.073274280203, 13.4684244470178, 0), 
	ZonePoint(54.0730855151504, 13.4690771513893, 0), 
	ZonePoint(54.0730800699919, 13.4694468109742, 0), 
	ZonePoint(54.0732361642519, 13.4702340776214, 0), 
	ZonePoint(54.073332361585, 13.470623844213, 0), 
	ZonePoint(54.073330546543, 13.4712069474075, 0), 
	ZonePoint(54.0733251014167, 13.471570420221, 0), 
	ZonePoint(54.0733005983393, 13.471957093427, 0), 
	ZonePoint(54.0733051359473, 13.4724288347381, 0), 
	ZonePoint(54.073279725336, 13.4728959359708, 0), 
	ZonePoint(54.0732352567289, 13.4732191947709, 0), 
	ZonePoint(54.0731281688672, 13.4742137182565, 0), 
	ZonePoint(54.0731100183548, 13.4745833778413, 0), 
	ZonePoint(54.0730673646194, 13.474901996563, 0), 
	ZonePoint(54.0729557386789, 13.4758717729634, 0), 
	ZonePoint(54.0729738892588, 13.4762135920775, 0), 
	ZonePoint(54.0730628269854, 13.4764239423015, 0), 
	ZonePoint(54.0730773474124, 13.4767827750365, 0), 
	ZonePoint(54.0730274334231, 13.4773473179171, 0), 
	ZonePoint(54.0729475709154, 13.477707697345, 0), 
	ZonePoint(54.0728867664031, 13.4779613549681, 0)
}
_7L8Hp.OriginalPoint = ZonePoint(54.070934213159, 13.4646778751028, 0)
_7L8Hp.DistanceRangeUOM = "Feet"
_7L8Hp.ProximityRangeUOM = "Meters"
_7L8Hp.OutOfRangeName = ""
_7L8Hp.InRangeName = ""

-- Characters --
_awN = Wherigo.ZCharacter{
	Cartridge = _YQ8fd, 
	Container = _Kvree
}
_awN.Id = "780710b4-b987-4f89-9960-dbd734a0e51b"
_awN.Name = _FJOj("\095\029\082\114")
_awN.Description = _FJOj("\012\080\060\061\060\114\082\124\114\061\113\088\049\061\093\088\001\061\113\114\093\061\095\017\049\001\060\080\017\080\060\114\013\061\069\017\023\061\050\088\082\082\023\001\061\113\029\061\050\088\023\023\114\120\044")
_awN.Visible = true
_awN.Media = _PnWe
_awN.Icon = _dxo
_awN.Commands = {
	_pUbli = Wherigo.ZCommand{
		Text = _FJOj("\069\017\023\061\088\023\001\061\113\114\049\061\025\035\113\114\120\044"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_vGo = Wherigo.ZCommand{
		Text = _FJOj("\025\035\113\114\120\060\035\049\088\051\035\120\001\114"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_QzazA = Wherigo.ZCommand{
		Text = _FJOj("\069\114\082\080\060\114\120\061\025\035\113\114\120\001\099\045\061\124\088\120\113\114\061\088\080\060\061\060\088\114\049\044"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_8fw9o = Wherigo.ZCommand{
		Text = _FJOj("\090\114\049\001\114\088\082\029\120\107\061\113\114\049\061\025\195\182\113\114\120"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_Ipi = Wherigo.ZCommand{
		Text = _FJOj("\025\035\113\114\120\001\099\045\114\120"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}
}
_awN.Commands._pUbli.Custom = true
_awN.Commands._pUbli.Id = "76b526b4-a8a1-48de-ad68-28e5b96d1771"
_awN.Commands._pUbli.WorksWithAll = true
_awN.Commands._vGo.Custom = true
_awN.Commands._vGo.Id = "b34191de-cd70-4b97-bf8b-bea68f403146"
_awN.Commands._vGo.WorksWithAll = true
_awN.Commands._QzazA.Custom = true
_awN.Commands._QzazA.Id = "b7d6e049-62ff-4005-aaf3-074c8c5c6320"
_awN.Commands._QzazA.WorksWithAll = true
_awN.Commands._8fw9o.Custom = true
_awN.Commands._8fw9o.Id = "d53375c2-0ccc-498e-8e9d-a905bf7fd13b"
_awN.Commands._8fw9o.WorksWithAll = true
_awN.Commands._Ipi.Custom = true
_awN.Commands._Ipi.Id = "fbc6cce6-9b98-4404-be86-10f3de8897ad"
_awN.Commands._Ipi.WorksWithAll = true
_awN.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_awN.Gender = "It"
_awN.Type = "NPC"
_NdiZ = Wherigo.ZCharacter{
	Cartridge = _YQ8fd, 
	Container = _Kvree
}
_NdiZ.Id = "8bebffaa-0c6a-4b5d-8bda-4984af356ee2"
_NdiZ.Name = _FJOj("\011\029\080\060\023")
_NdiZ.Description = ""
_NdiZ.Visible = false
_NdiZ.Icon = _jsbs1
_NdiZ.Commands = {}
_NdiZ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_NdiZ.Gender = "Male"
_NdiZ.Type = "NPC"
_4vC = Wherigo.ZCharacter{
	Cartridge = _YQ8fd, 
	Container = _9xV7F
}
_4vC.Id = "a495bda6-78dc-496a-b7ea-cb09dcabc0c2"
_4vC.Name = _FJOj("\073\114\060")
_4vC.Description = ""
_4vC.Visible = false
_4vC.Icon = _Jvs
_4vC.Commands = {}
_4vC.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_4vC.Gender = "Male"
_4vC.Type = "NPC"
_mQiIa = Wherigo.ZCharacter{
	Cartridge = _YQ8fd, 
	Container = _Kvree
}
_mQiIa.Id = "27b31f74-3470-4e48-a300-87db9feab00a"
_mQiIa.Name = _FJOj("\072\035\060\082\093\114\088\023\114")
_mQiIa.Description = ""
_mQiIa.Visible = false
_mQiIa.Icon = _EeYaY
_mQiIa.Commands = {}
_mQiIa.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_mQiIa.Gender = "Male"
_mQiIa.Type = "NPC"
_Ch1o = Wherigo.ZCharacter{
	Cartridge = _YQ8fd, 
	Container = _Kvree
}
_Ch1o.Id = "10660309-6abb-4583-b0f7-2a5cb9097e57"
_Ch1o.Name = _FJOj("\010\045\114\080\060\001")
_Ch1o.Description = ""
_Ch1o.Visible = false
_Ch1o.Icon = _4eXU
_Ch1o.Commands = {}
_Ch1o.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Ch1o.Gender = "Male"
_Ch1o.Type = "NPC"
_KIhF = Wherigo.ZCharacter{
	Cartridge = _YQ8fd, 
	Container = _Kvree
}
_KIhF.Id = "ed709971-b3a9-4c09-8eff-b5040c85f951"
_KIhF.Name = _FJOj("\095\088\080\060\060\195\182\049\120\080\060\114\120")
_KIhF.Description = ""
_KIhF.Visible = false
_KIhF.Icon = _THS
_KIhF.Commands = {}
_KIhF.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KIhF.Gender = "Male"
_KIhF.Type = "NPC"
_6_P = Wherigo.ZCharacter{
	Cartridge = _YQ8fd, 
	Container = _Kvree
}
_6_P.Id = "e6dbb79c-f914-43f8-ba26-f2ae19bc07dd"
_6_P.Name = _FJOj("\105\093\023\114\082")
_6_P.Description = ""
_6_P.Visible = false
_6_P.Icon = _cT3_l
_6_P.Commands = {}
_6_P.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_6_P.Gender = "Male"
_6_P.Type = "NPC"

-- Items --
_bmWd = Wherigo.ZItem{
	Cartridge = _YQ8fd, 
	Container = Player
}
_bmWd.Id = "a2022065-d27c-4abd-a012-c2d8785c47c8"
_bmWd.Name = _FJOj("\068\088\001\114\049\017\001\029\049")
_bmWd.Description = _FJOj("\024\013\061\072\069\105\010\009\012\021\069\010\072\012\031\061\034\061\046\030\084\084\024\097\061\065\088\114\061\025\195\182\113\114\120\061\088\093\061\009\017\001\029\049\023\080\060\029\001\051\107\114\037\088\114\001\061\095\082\113\114\120\017\061\046\090\035\049\045\035\093\093\114\049\120\097\031\061\116\049\114\088\124\023\050\017\082\113\114\049\061\116\114\035\107\049\017\124\088\023\080\060\114\061\105\049\037\114\088\001\114\120\031\061\030\005\031\061\024\053\053\087\024\047\053\038\025\073\118\038\025\073\118\030\013\061\025\035\113\114\120\082\114\060\049\045\124\017\113\061\095\082\113\114\120\017\061\046\060\001\001\045\023\104\127\127\107\114\035\013\029\120\088\087\107\049\114\088\124\023\050\017\082\113\013\113\114\097\061\064\084\047\013\024\084\013\030\084\024\047\110\038\025\073\118\038\025\073\118\005\013\061\012\120\124\035\001\017\124\114\082\038\025\073\118\038\025\073\118\075\013\061\025\035\113\114\120\001\099\045\114\120\061\046\060\001\001\045\023\104\127\127\050\050\050\013\037\035\113\114\120\001\099\045\114\120\013\113\114\127\097\061\064\084\033\013\024\084\013\030\084\024\047\110\038\025\073\118\038\025\073\118\053\013\061\025\035\113\114\120\050\114\082\001\114\120\061\046\060\001\001\045\023\104\127\127\050\050\050\013\037\035\113\114\120\050\114\082\001\114\120\013\113\114\127\097\061\064\084\047\013\024\084\013\030\084\024\047\110\038\025\073\118\038\025\073\118\076\013\061\069\088\058\088\045\114\113\088\017\061\046\060\001\001\045\023\104\127\127\113\114\013\050\088\058\088\045\114\113\088\017\013\035\049\107\127\050\088\058\088\127\025\035\113\114\120\063\046\025\035\113\114\120\058\029\120\113\114\097\097\061\046\060\001\001\045\023\104\127\127\113\114\013\050\088\058\088\045\114\113\088\017\013\035\049\107\127\050\088\058\088\127\025\035\113\114\120\060\035\049\088\051\035\120\001\097\061\064\084\047\013\024\084\013\030\084\024\047\110\038\025\073\118")
_bmWd.Visible = true
_bmWd.Icon = _wqpP
_bmWd.Commands = {}
_bmWd.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_bmWd.Locked = false
_bmWd.Opened = false
_FsyzO = Wherigo.ZItem(_YQ8fd)
_FsyzO.Id = "1138deb1-48ff-46c8-a7ba-1dc5680f9e96"
_FsyzO.Name = _FJOj("\025\035\113\114\120\045\049\035\124\088\082")
_FsyzO.Description = _FJOj("\078\088\114\049\061\107\088\037\001\061\114\023\061\114\088\120\114\061\011\049\017\107\114\061\051\029\061\113\088\114\023\114\093\061\025\035\113\114\120\045\049\035\124\088\082")
_FsyzO.Visible = true
_FsyzO.Media = _46Nki
_FsyzO.Icon = _639
_FsyzO.Commands = {
	_eJOne = Wherigo.ZCommand{
		Text = _FJOj("\011\049\017\107\114\061\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_IwMXh = Wherigo.ZCommand{
		Text = _FJOj("\011\049\017\107\114\061\030"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_bM1f8 = Wherigo.ZCommand{
		Text = _FJOj("\011\049\017\107\114\061\005"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_Os4Q = Wherigo.ZCommand{
		Text = _FJOj("\011\049\017\107\114\061\075"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}, 
	_Ua5e1 = Wherigo.ZCommand{
		Text = _FJOj("\011\049\017\107\114\061\053"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _FJOj("\009\035\001\060\088\120\107\061\017\101\017\088\082\017\037\082\114")
	}
}
_FsyzO.Commands._eJOne.Custom = true
_FsyzO.Commands._eJOne.Id = "f90b2e28-3c64-4893-b1ac-14b9a4aee475"
_FsyzO.Commands._eJOne.WorksWithAll = true
_FsyzO.Commands._IwMXh.Custom = true
_FsyzO.Commands._IwMXh.Id = "31d52ea3-8c47-46b1-9ece-ef8b99432cbf"
_FsyzO.Commands._IwMXh.WorksWithAll = true
_FsyzO.Commands._bM1f8.Custom = true
_FsyzO.Commands._bM1f8.Id = "ea90b5c7-b21f-4a5f-97d4-ad9a3a4f591a"
_FsyzO.Commands._bM1f8.WorksWithAll = true
_FsyzO.Commands._Os4Q.Custom = true
_FsyzO.Commands._Os4Q.Id = "4a64f7ea-f40e-4498-9e0f-60c30978de5f"
_FsyzO.Commands._Os4Q.WorksWithAll = true
_FsyzO.Commands._Ua5e1.Custom = true
_FsyzO.Commands._Ua5e1.Id = "48745bde-a68a-4f90-881b-8134020afa81"
_FsyzO.Commands._Ua5e1.WorksWithAll = true
_FsyzO.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FsyzO.Locked = false
_FsyzO.Opened = false
_eeSm = Wherigo.ZItem{
	Cartridge = _YQ8fd, 
	Container = Player
}
_eeSm.Id = "873054b6-d11e-4a69-9779-18f5c228d5cf"
_eeSm.Name = _FJOj("\105\120\001\050\035\049\001\114\120")
_eeSm.Description = _FJOj("\065\029\061\060\017\023\001\061\124\035\082\107\114\120\113\114\023\061\107\114\017\120\001\050\035\049\001\114\001\104\038\025\073\118\011\049\017\107\114\061\024\017\104\038\025\073\118\011\049\017\107\114\061\024\037\104\038\025\073\118\011\049\017\107\114\061\030\104\038\025\073\118\011\049\017\107\114\061\005\104\038\025\073\118\011\049\017\107\114\061\075\104\038\025\073\118\011\049\017\107\114\061\053\017\104\038\025\073\118\011\049\017\107\114\061\053\037\104")
_eeSm.Visible = true
_eeSm.Icon = _dyrBq
_eeSm.Commands = {}
_eeSm.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_eeSm.Locked = false
_eeSm.Opened = false
_Cb55 = Wherigo.ZItem(_YQ8fd)
_Cb55.Id = "5cf075c1-e977-4cbf-88fe-e66cc91fbebe"
_Cb55.Name = _FJOj("\036\035\093\045\082\114\001\088\035\120\061\036\035\113\114")
_Cb55.Description = _FJOj("\024\030\005")
_Cb55.Visible = true
_Cb55.Icon = _dyrBq
_Cb55.Commands = {}
_Cb55.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Cb55.Locked = false
_Cb55.Opened = false

-- Tasks --
_xxNd = Wherigo.ZTask(_YQ8fd)
_xxNd.Id = "7827f525-2c1a-48dd-b5da-55e965b7e19c"
_xxNd.Name = _FJOj("\011\049\017\107\114\061\024")
_xxNd.Description = _FJOj("\116\114\060\061\051\029\061\010\001\017\001\088\035\120\061\024\013")
_xxNd.Visible = true
_xxNd.Active = true
_xxNd.Complete = false
_xxNd.CorrectState = "None"
_5EVC4 = Wherigo.ZTask(_YQ8fd)
_5EVC4.Id = "6eb87bc1-8d9b-4d6d-a76e-96acaa79ae09"
_5EVC4.Name = _FJOj("\011\049\017\107\114\061\030")
_5EVC4.Description = _FJOj("\116\114\060\061\051\029\061\010\001\017\001\088\035\120\061\030\013")
_5EVC4.Visible = true
_5EVC4.Active = true
_5EVC4.Complete = false
_5EVC4.CorrectState = "None"
_vVWw = Wherigo.ZTask(_YQ8fd)
_vVWw.Id = "df12ef2a-2e8b-4f4c-98d2-465d43c32b99"
_vVWw.Name = _FJOj("\011\049\017\107\114\061\005")
_vVWw.Description = _FJOj("\116\114\060\061\051\029\061\010\001\017\001\088\035\120\061\005\013")
_vVWw.Visible = true
_vVWw.Active = true
_vVWw.Complete = false
_vVWw.CorrectState = "None"
_yK6nl = Wherigo.ZTask(_YQ8fd)
_yK6nl.Id = "8366c159-aa73-4359-afa6-df56025066ae"
_yK6nl.Name = _FJOj("\011\049\017\107\114\061\075")
_yK6nl.Description = _FJOj("\116\114\060\061\051\029\061\010\001\017\001\088\035\120\061\075\013")
_yK6nl.Visible = true
_yK6nl.Active = true
_yK6nl.Complete = false
_yK6nl.CorrectState = "None"
_S3ITz = Wherigo.ZTask(_YQ8fd)
_S3ITz.Id = "b0347d9d-8141-42e9-8bba-5f53943ac9e7"
_S3ITz.Name = _FJOj("\011\049\017\107\114\061\053")
_S3ITz.Description = _FJOj("\116\114\060\061\051\029\061\010\001\017\001\088\035\120\061\053\013")
_S3ITz.Visible = true
_S3ITz.Active = true
_S3ITz.Complete = false
_S3ITz.CorrectState = "None"

-- Cartridge Variables --
_LkYm = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\116\082\114\099\114\013")
_nr6 = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\123\023\114\029\113\035\107\082\114\099\061\093\088\001\061\025\049\017\029\120\114\049\113\114\120\013")
_Ns1 = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\025\049\017\029\120\114\049\113\114\120\013")
_jN9e = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\009\088\114\113\114\049\093\035\035\049\114\013")
_u81Fe = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\072\035\082\082\029\101\088\023\035\082\013")
_0RpN = ""
_WF0E = ""
_jseot = ""
_EBPV = ""
_eQb = ""
_VX1 = ""
_DRff = ""
_nv9O = ""
_Fiu = 30
_Jau5 = _FJOj("\063\072\101\049\114\114")
_zXCy2 = _FJOj("\063\017\050\009")
_k6a = _FJOj("\063\037\093\069\113")
_G60 = _FJOj("\063\085\085\009\113")
_Kbrdm = _FJOj("\063\037\041\072\030\093")
_N9T = _FJOj("\063\037\039\005")
_YQ8fd.ZVariables = {
	_LkYm = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\116\082\114\099\114\013"), 
	_nr6 = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\123\023\114\029\113\035\107\082\114\099\061\093\088\001\061\025\049\017\029\120\114\049\113\114\120\013"), 
	_Ns1 = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\025\049\017\029\120\114\049\113\114\120\013"), 
	_jN9e = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\009\088\114\113\114\049\093\035\035\049\114\013"), 
	_u81Fe = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\072\035\082\082\029\101\088\023\035\082\013"), 
	_0RpN = "", 
	_WF0E = "", 
	_jseot = "", 
	_EBPV = "", 
	_eQb = "", 
	_VX1 = "", 
	_DRff = "", 
	_nv9O = "", 
	_Fiu = 30, 
	_Jau5 = _FJOj("\063\072\101\049\114\114"), 
	_zXCy2 = _FJOj("\063\017\050\009"), 
	_k6a = _FJOj("\063\037\093\069\113"), 
	_G60 = _FJOj("\063\085\085\009\113"), 
	_Kbrdm = _FJOj("\063\037\041\072\030\093"), 
	_N9T = _FJOj("\063\037\039\005")
}

-- Timers --
_bX3 = Wherigo.ZTimer(_YQ8fd)
_bX3.Id = "f93cdd8a-0e0a-468a-9d89-c7c1342d89c8"
_bX3.Name = _FJOj("\017\120\088\093\017\082")
_bX3.Description = _FJOj("\105\045\017\049\114\088\085\061\029\120\061\017\120\088\093\017\082\061\080\017\113\017\061\085\031\061\114\082\061\001\114\093\035\023\061\114\023\061\107\114\120\114\049\017\061\080\017\113\017\061\080\035\045\061\114\120\001\049\114\061\005\084\061\023\114\107\035\120\023\061\088\061\053\061\093\088\120\029\001\023\061\046\005\084\087\005\084\084\097")
_bX3.Visible = true
_bX3.Duration = 10
_bX3.Type = "Countdown"
_AMasp = Wherigo.ZTimer(_YQ8fd)
_AMasp.Id = "1f2f5957-438c-4d66-85c4-60271f931cb7"
_AMasp.Name = _FJOj("\017\120\088\093\017\082\065\114\023\017\045\017\049\114\088\085")
_AMasp.Description = _FJOj("\068\048\017\120\088\093\017\082\061\114\082\061\045\035\001\023\061\101\114\029\049\114\061\029\120\023\061\005\084\061\023\114\107\035\120\023\013")
_AMasp.Visible = true
_AMasp.Duration = 30
_AMasp.Type = "Countdown"

-- Inputs --
_b9K2m = Wherigo.ZInput(_YQ8fd)
_b9K2m.Id = "e231913c-7bf6-47e2-87bd-4259bdbe12c9"
_b9K2m.Name = _FJOj("\010\001\017\001\088\035\120\024\017")
_b9K2m.Description = ""
_b9K2m.Visible = true
_b9K2m.InputType = "Text"
_b9K2m.Text = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\114\088\120\114\061\113\114\049\061\050\114\120\088\107\114\120\061\025\114\049\114\088\080\060\114\120\061\093\088\001\061\025\049\017\029\120\114\049\113\114\013\061\069\017\049\029\093\061\023\088\120\113\061\025\049\017\029\120\114\049\113\114\120\061\088\093\061\009\010\116\061\095\082\113\114\120\017\061\120\088\080\060\001\061\023\035\061\060\195\164\029\124\088\107\044")
_mtvUi = Wherigo.ZInput(_YQ8fd)
_mtvUi.Id = "6af3bd3e-37b3-4a51-ae1a-046bf24f6208"
_mtvUi.Name = _FJOj("\010\001\017\001\088\035\120\024\037")
_mtvUi.Description = ""
_mtvUi.Visible = true
_mtvUi.InputType = "Text"
_mtvUi.Text = _FJOj("\025\114\049\195\188\060\049\114\061\113\088\114\061\101\114\049\023\080\060\088\114\113\114\120\114\120\061\010\080\060\088\080\060\001\114\120\061\113\114\023\061\123\049\035\124\088\082\023\031\061\113\088\114\061\113\029\061\114\049\058\114\120\120\114\120\061\058\017\120\120\023\001\013\061\072\017\120\120\023\001\061\113\029\061\114\088\120\061\029\120\001\114\049\023\080\060\088\114\113\061\051\050\088\023\080\060\114\120\061\113\114\120\061\010\080\060\088\080\060\001\114\120\061\093\114\049\058\114\120\044\061\069\088\049\113\061\114\023\061\107\049\195\182\037\114\049\061\035\113\114\049\061\124\114\088\120\114\049\061\088\120\061\113\114\120\061\029\120\001\114\049\114\120\061\010\080\060\088\080\060\001\114\120\044")
_GCVu = Wherigo.ZInput(_YQ8fd)
_GCVu.Id = "80824e1a-594c-4414-b97e-3da2c4758c82"
_GCVu.Name = _FJOj("\010\001\017\001\088\035\120\030")
_GCVu.Description = ""
_GCVu.Visible = true
_GCVu.InputType = "Text"
_GCVu.Text = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\017\029\080\060\061\114\088\120\061\025\049\017\029\120\114\049\113\045\049\035\124\088\082\061\017\037\114\049\031\061\113\017\023\061\120\088\080\060\001\061\195\188\037\114\049\061\114\088\120\061\023\017\120\113\088\107\114\049\061\010\029\037\023\001\049\017\001\061\082\088\114\107\001\061\088\093\061\116\114\107\114\120\023\017\001\051\061\051\029\093\061\123\049\035\124\088\082\061\101\035\120\061\010\001\017\001\088\035\120\061\024\013\038\025\073\118\072\017\120\120\023\001\061\113\029\061\060\088\114\049\061\114\088\120\061\121\120\001\114\049\023\080\060\088\114\113\061\051\050\088\023\080\060\114\120\061\113\088\114\061\035\037\114\049\114\061\029\120\113\061\029\120\001\114\049\114\061\010\080\060\088\080\060\001\061\093\114\049\058\114\120\044")
_9il = Wherigo.ZInput(_YQ8fd)
_9il.Id = "94e8b052-2a1d-409b-a9a5-f34ae7b64971"
_9il.Name = _FJOj("\010\001\017\001\088\035\120\005")
_9il.Description = ""
_9il.Visible = true
_9il.InputType = "Text"
_9il.Text = _FJOj("\078\088\114\049\061\124\088\120\113\114\023\001\061\113\029\061\114\088\120\061\025\114\088\023\045\088\114\082\061\101\035\120\061\116\082\114\099\013\061\105\120\061\113\114\120\061\069\195\164\120\113\114\120\061\113\114\023\061\123\049\035\124\088\082\023\061\058\017\120\120\061\113\017\023\061\101\035\049\060\114\049\061\088\093\061\116\049\029\120\113\050\017\023\023\114\049\061\107\114\082\195\182\023\001\114\061\095\088\023\114\120\061\035\085\088\113\088\114\049\114\120\061\029\120\113\061\011\082\114\080\058\114\120\061\114\120\001\023\001\114\060\114\120\013\038\025\073\118\072\017\120\120\023\001\061\113\029\061\113\088\114\061\011\082\114\080\058\114\120\061\114\049\058\114\120\120\114\120\044\061\012\120\061\050\114\082\080\060\114\093\061\078\035\049\088\051\035\120\001\061\023\035\082\082\001\114\023\001\061\113\029\061\113\088\114\061\023\114\060\114\120\044\061\069\114\082\080\060\114\061\011\017\049\037\114\061\060\017\037\114\120\061\113\088\114\044")
_CmMmR = Wherigo.ZInput(_YQ8fd)
_CmMmR.Id = "c2906308-0bf2-4d37-9b30-c352d92d8058"
_CmMmR.Name = _FJOj("\010\001\017\001\088\035\120\075")
_CmMmR.Description = ""
_CmMmR.Visible = true
_CmMmR.InputType = "Text"
_CmMmR.Text = _FJOj("\090\035\120\061\060\088\114\049\061\017\029\023\061\060\017\023\001\061\113\029\061\114\088\120\061\023\080\060\195\182\120\114\120\061\025\082\088\080\058\061\113\114\093\061\073\114\060\037\049\029\080\060\013\061\012\120\113\114\093\061\124\082\088\114\195\159\114\120\061\113\114\049\061\025\088\114\049\037\017\080\060\031\061\113\114\049\061\058\029\049\051\061\060\088\120\001\114\049\061\113\114\093\061\073\114\060\037\049\029\080\060\061\001\049\035\080\058\114\120\107\114\082\114\107\001\061\088\023\001\031\061\029\120\113\061\113\114\049\061\078\035\060\114\120\061\116\049\017\037\114\120\031\061\113\114\049\061\037\114\049\114\088\001\023\061\017\120\061\113\114\049\061\116\049\035\195\159\114\120\061\069\088\114\023\114\127\095\088\080\060\114\120\037\049\088\120\058\061\113\017\023\061\009\010\116\061\073\088\080\060\001\029\120\107\061\116\049\114\088\124\023\050\017\082\113\114\049\061\025\035\113\113\114\120\061\101\114\049\082\195\164\023\023\001\013\061\065\029\061\058\017\120\120\023\001\061\093\088\001\061\078\088\082\124\114\061\113\114\049\061\090\114\107\114\001\017\001\088\035\120\061\114\049\058\114\120\120\114\120\061\050\035\061\113\088\114\061\025\195\164\080\060\114\061\124\082\088\114\195\159\114\120\013\038\025\073\118\105\029\023\061\050\114\082\080\060\114\093\061\025\035\113\114\120\061\113\114\120\058\023\001\061\113\029\031\061\113\017\023\023\061\113\114\049\061\073\114\060\037\049\029\080\060\061\114\120\001\023\001\017\120\113\114\120\061\088\023\001\044\061\069\017\049\029\093\044")
_nl4mU = Wherigo.ZInput(_YQ8fd)
_nl4mU.Id = "dece761c-e265-47dc-a50f-7536084bf5a9"
_nl4mU.Name = _FJOj("\010\001\017\001\088\035\120\053\017")
_nl4mU.Description = ""
_nl4mU.Visible = true
_nl4mU.InputType = "Text"
_nl4mU.Text = _FJOj("\078\088\114\049\061\037\114\124\088\120\113\114\023\001\061\113\029\061\113\088\080\060\061\107\017\120\051\061\120\017\060\031\061\023\195\188\113\082\088\080\060\061\113\114\023\061\095\037\114\049\001\023\037\114\049\107\023\031\061\113\114\049\061\060\195\182\080\060\023\001\114\061\123\029\120\058\001\061\113\114\023\061\009\010\116\061\095\082\113\114\120\017\031\061\029\120\113\061\017\093\061\073\017\120\113\114\061\113\114\023\061\009\017\001\029\049\023\080\060\029\001\051\107\114\037\088\114\001\031\061\120\114\037\114\120\061\114\088\120\114\093\061\105\080\058\114\049\013\038\025\073\118\010\080\060\017\029\114\061\113\088\049\061\113\017\023\023\061\123\049\035\124\088\082\061\017\120\013\061\069\088\114\061\101\088\114\082\114\061\010\080\060\088\080\060\001\114\061\058\017\120\120\023\001\061\113\029\061\114\049\058\114\120\120\114\120\044")
_cp9 = Wherigo.ZInput(_YQ8fd)
_cp9.Id = "f82daf85-6ce7-4fc8-9bdb-2e153cc72b2b"
_cp9.Name = _FJOj("\010\001\017\001\088\035\120\053\037")
_cp9.Description = ""
_cp9.Visible = true
_cp9.InputType = "Text"
_cp9.Text = _FJOj("\069\114\082\080\060\114\120\061\025\035\113\114\120\001\099\045\061\107\082\017\029\037\023\001\061\113\029\031\061\113\017\023\023\061\114\023\061\088\023\001\044\061\069\017\049\029\093\044")
__Yz = Wherigo.ZInput(_YQ8fd)
__Yz.Id = "28c18de6-657e-4bb5-8d45-288d4b840687"
__Yz.Name = _FJOj("\025\035\113\114\120\001\099\045\114\120")
__Yz.Description = ""
__Yz.Visible = true
__Yz.Choices = {
	"Gleye", 
	"Pseudogleye", 
	"Braunerden", 
	"Niedermoore", 
	"Kolluvisol"
}
__Yz.InputType = "MultipleChoice"
__Yz.Text = _FJOj("\195\156\037\114\049\061\050\114\082\080\060\114\120\061\025\035\120\113\114\001\099\045\061\050\088\082\082\023\001\061\113\029\061\050\017\023\061\050\088\023\023\114\120\044")

-- WorksWithList for object commands --

-- functions --
function _YQ8fd:OnStart()
	_bX3:Start()
	_Urwigo.OldDialog{
		{
			Text = _FJOj("\069\088\082\082\058\035\093\093\114\120\061\088\093\061\009\010\116\061\095\082\113\114\120\017\013\061\012\080\060\061\037\088\120\061\113\088\114\061\095\029\082\114\061\113\114\023\061\069\017\082\113\114\023\013\038\025\073\118\012\080\060\061\050\114\049\113\114\061\113\088\049\061\093\088\001\061\113\114\093\061\095\017\049\001\060\080\017\080\060\114\061\060\114\082\124\114\120\013\061\012\080\060\061\051\114\088\107\114\061\113\088\049\061\050\035\061\113\088\114\061\025\035\113\114\120\045\049\035\124\088\082\114\061\023\088\120\113\061\029\120\113\061\050\017\023\061\113\017\049\195\188\037\114\049\061\082\114\049\120\114\120\061\058\017\120\120\023\001\013\061\065\029\061\058\017\120\120\023\001\061\093\088\080\060\061\017\029\080\060\061\124\049\017\107\114\120\061\029\120\113\061\088\080\060\061\114\049\051\195\164\060\082\114\061\113\088\049\061\017\082\082\114\023\061\050\017\023\061\088\080\060\061\195\188\037\114\049\061\025\195\182\113\114\120\061\050\088\023\023\114\013\038\025\073\118\090\088\114\082\082\114\088\080\060\001\061\058\017\120\120\023\001\061\113\029\061\017\029\080\060\061\029\120\001\114\049\050\114\107\023\061\017\120\113\114\049\114\061\022\088\114\049\061\023\114\060\114\120\061\035\113\114\049\061\060\195\182\049\114\120\013\038\025\073\118\090\088\114\082\061\010\045\017\195\159\089"), 
			Media = _PnWe
		}
	}
end
function _YQ8fd:OnRestore()
end
function _Kvree:OnEnter()
	_Jau5 = _FJOj("\063\072\101\049\114\114")
	_awN:MoveTo(_Kvree)
end
function _9xV7F:OnEnter()
	_Jau5 = _FJOj("\063\041\085\090\033\011")
	_awN:MoveTo(_9xV7F)
end
function _v_f:OnEnter()
	_Jau5 = _FJOj("\063\101\063\124")
	_FsyzO:MoveTo(_v_f)
	_FsyzO.Commands._eJOne.Enabled = true
	_FsyzO.Commands._IwMXh.Enabled = false
	_FsyzO.Commands._bM1f8.Enabled = false
	_FsyzO.Commands._Os4Q.Enabled = false
	_FsyzO.Commands._Ua5e1.Enabled = false
	_FsyzO.Name = _FJOj("\025\035\113\114\120\045\049\035\124\088\082")
	_FsyzO.Description = _FJOj("\078\088\114\049\061\107\088\037\001\061\114\023\061\114\088\120\114\061\011\049\017\107\114\061\051\029\061\113\088\114\023\114\093\061\025\035\113\114\120\045\049\035\124\088\082")
end
function _d16:OnEnter()
	_Jau5 = _FJOj("\063\113\024\076")
	_FsyzO:MoveTo(_d16)
	_FsyzO.Commands._eJOne.Enabled = false
	_FsyzO.Commands._IwMXh.Enabled = true
	_FsyzO.Commands._bM1f8.Enabled = false
	_FsyzO.Commands._Os4Q.Enabled = false
	_FsyzO.Commands._Ua5e1.Enabled = false
	_FsyzO.Name = _FJOj("\025\035\113\114\120\045\049\035\124\088\082")
	_FsyzO.Description = _FJOj("\078\088\114\049\061\107\088\037\001\061\114\023\061\114\088\120\114\061\011\049\017\107\114\061\051\029\061\113\088\114\023\114\093\061\025\035\113\114\120\045\049\035\124\088\082")
end
function _JZ2N3:OnEnter()
	_Jau5 = _FJOj("\063\034\119\030\009\005")
	_FsyzO:MoveTo(_JZ2N3)
	_FsyzO.Commands._eJOne.Enabled = false
	_FsyzO.Commands._IwMXh.Enabled = false
	_FsyzO.Commands._bM1f8.Enabled = true
	_FsyzO.Commands._Os4Q.Enabled = false
	_FsyzO.Commands._Ua5e1.Enabled = false
	_FsyzO.Name = _FJOj("\025\035\113\114\120\045\049\035\124\088\082")
	_FsyzO.Description = _FJOj("\078\088\114\049\061\107\088\037\001\061\114\023\061\114\088\120\114\061\011\049\017\107\114\061\051\029\061\113\088\114\023\114\093\061\025\035\113\114\120\045\049\035\124\088\082")
end
function _VYtV:OnEnter()
	_Jau5 = _FJOj("\063\090\079\001\090")
	_FsyzO:MoveTo(_VYtV)
	_FsyzO.Commands._eJOne.Enabled = false
	_FsyzO.Commands._IwMXh.Enabled = false
	_FsyzO.Commands._bM1f8.Enabled = false
	_FsyzO.Commands._Os4Q.Enabled = true
	_FsyzO.Commands._Ua5e1.Enabled = false
	_FsyzO.Name = _FJOj("\073\114\060\037\049\029\080\060")
	_FsyzO.Description = _FJOj("\078\088\114\049\061\107\088\037\001\061\114\023\061\114\088\120\114\061\011\049\017\107\114\061\051\029\061\113\114\093\061\073\114\060\037\049\029\080\060")
end
function _6QyW:OnEnter()
	_Jau5 = _FJOj("\063\076\002\099\069")
	_FsyzO:MoveTo(_6QyW)
	_FsyzO.Commands._eJOne.Enabled = false
	_FsyzO.Commands._IwMXh.Enabled = false
	_FsyzO.Commands._bM1f8.Enabled = false
	_FsyzO.Commands._Os4Q.Enabled = false
	_FsyzO.Commands._Ua5e1.Enabled = true
	_FsyzO.Name = _FJOj("\025\035\113\114\120\045\049\035\124\088\082")
	_FsyzO.Description = _FJOj("\078\088\114\049\061\107\088\037\001\061\114\023\061\114\088\120\114\061\011\049\017\107\114\061\051\029\061\113\088\114\023\114\093\061\025\035\113\114\120\045\049\035\124\088\082")
end
function _r6Z0k:OnEnter()
	_Jau5 = _FJOj("\063\049\076\119\084\058")
	_0RpN = _FJOj("\058\035\082\082\029\101\088")
end
function _jS8:OnEnter()
	_Jau5 = _FJOj("\063\008\010\047")
	_0RpN = _FJOj("\058\035\082\082\029\101\088")
end
function _ke5xj:OnEnter()
	_Jau5 = _FJOj("\063\058\114\053\085\008")
	_0RpN = _FJOj("\058\035\082\082\029\101\088")
end
function _xBqW:OnEnter()
	_Jau5 = _FJOj("\063\085\025\126\069")
	_0RpN = _FJOj("\107\082\114\099")
end
function _PnJo:OnEnter()
	_Jau5 = _FJOj("\063\123\120\034\035")
	_0RpN = _FJOj("\107\082\114\099")
end
function _x8no:OnEnter()
	_Jau5 = _FJOj("\063\085\047\120\035")
	_0RpN = _FJOj("\037\049\017\029\120")
end
function _ja8Ru:OnEnter()
	_Jau5 = _FJOj("\063\008\017\047\073\029")
	_0RpN = _FJOj("\093\035\035\049")
end
function _iR0vR:OnEnter()
	_Jau5 = _FJOj("\063\088\073\084\101\073")
	_0RpN = _FJOj("\045\023\114\029\113\035")
end
function _7L8Hp:OnEnter()
	_Jau5 = _FJOj("\063\033\068\047\078\045")
	_0RpN = _FJOj("\107\082\114\099")
end
function _b9K2m:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_WF0E = input
	_SN1T()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_mtvUi)
	end)
end
function _mtvUi:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_jseot = input
	_SN1T()
	_xxNd.Complete = true
	_Okmy2()
end
function _GCVu:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_EBPV = input
	_SN1T()
	_5EVC4.Complete = true
	_Okmy2()
end
function _9il:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_eQb = input
	_SN1T()
	_vVWw.Complete = true
	_Okmy2()
end
function _CmMmR:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_VX1 = input
	_SN1T()
	_yK6nl.Complete = true
	_Okmy2()
end
function _nl4mU:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_DRff = input
	_SN1T()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_cp9)
	end)
end
function _cp9:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_nv9O = input
	_SN1T()
	_S3ITz.Complete = true
	_Okmy2()
end
function __Yz:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 36021 then
		_Urwigo.OldDialog{
			{
				Text = _FJOj("\116\082\114\099\114\061\023\088\120\113\061\101\035\093\061\116\049\029\120\113\050\017\023\023\114\049\061\037\114\114\088\120\124\082\029\023\023\001\114\061\025\195\182\113\114\120\061\029\120\113\061\113\017\060\114\049\061\088\120\061\009\088\114\113\114\049\029\120\107\114\120\061\029\120\113\061\010\114\120\058\114\120\061\060\195\164\029\124\088\107\061\017\120\051\029\001\049\114\124\124\114\120\013\061\065\017\023\061\060\035\080\060\017\120\023\001\114\060\114\120\113\114\061\029\120\113\061\037\114\050\114\107\082\088\080\060\114\061\116\049\029\120\113\050\017\023\023\114\049\061\082\195\182\023\001\061\088\120\061\023\114\088\120\114\093\061\001\088\114\124\114\049\114\120\061\045\114\049\093\017\120\114\120\001\114\120\061\069\088\049\058\029\120\107\023\037\114\049\114\088\080\060\061\101\114\049\023\080\060\088\114\113\114\120\114\061\025\035\113\114\120\045\017\049\001\088\058\114\082\013\064\030\110\038\025\073\118\065\088\114\061\029\120\001\114\049\023\080\060\088\114\113\082\088\080\060\114\120\061\025\035\113\114\120\001\099\045\114\120\061\113\114\049\061\116\082\114\099\114\061\050\114\049\113\114\120\061\017\029\124\061\116\049\029\120\113\061\113\114\023\061\078\029\093\029\023\107\114\060\017\082\001\114\023\061\088\093\061\021\037\114\049\037\035\113\114\120\061\029\120\113\061\113\114\049\061\078\195\182\060\114\061\113\114\023\061\116\049\029\120\113\050\017\023\023\114\049\023\045\088\114\107\114\082\023\061\037\114\023\001\088\093\093\001\013\064\076\110")
			}, 
			{
				Text = _FJOj("\116\082\114\099\114\061\060\017\037\114\120\061\088\113\114\017\082\001\099\045\088\023\080\060\061\113\088\114\061\078\035\049\088\051\035\120\001\088\114\049\029\120\107\061\105\127\116\035\127\116\049\104\038\025\073\118\038\025\073\118\087\105\060\104\061\078\029\093\035\023\114\049\061\021\037\114\049\037\035\113\114\120\031\061\035\124\001\061\035\037\114\049\060\017\082\037\061\113\114\023\061\116\049\029\120\113\050\017\023\023\114\049\114\088\120\124\082\029\023\023\114\023\038\025\073\118\087\116\035\104\061\021\085\088\113\017\001\088\035\120\023\060\035\049\088\051\035\120\001\013\061\010\017\029\114\049\023\001\035\124\124\017\049\093\114\061\010\080\060\088\080\060\001\061\050\035\061\101\035\049\061\017\082\082\114\093\061\095\088\023\114\120\061\088\120\061\049\114\113\029\051\088\114\049\001\114\061\011\035\049\093\061\093\035\037\088\082\088\023\088\114\049\001\061\023\088\120\113\013\061\116\049\029\120\113\050\017\023\023\114\049\061\023\001\114\088\107\001\061\029\120\113\061\023\088\120\058\001\061\088\093\061\034\017\060\049\114\023\101\114\049\082\017\029\124\061\017\037\060\195\164\120\107\088\107\061\101\035\120\061\011\017\058\001\035\049\114\120\061\050\088\114\061\009\088\114\113\114\049\023\080\060\082\017\107\031\061\010\080\060\120\114\114\023\080\060\093\114\082\051\114\061\035\113\114\049\061\123\124\082\017\120\051\114\120\101\114\049\037\049\017\029\080\060\031\061\029\120\113\061\113\049\088\120\107\001\061\120\029\049\061\113\029\049\080\060\061\101\035\049\195\188\037\114\049\107\114\060\114\120\113\114\061\195\132\120\113\114\049\029\120\107\114\120\061\113\114\023\061\116\049\029\120\113\050\017\023\023\114\049\023\045\088\114\107\114\082\023\061\035\113\114\049\061\072\017\045\088\082\082\017\049\058\049\195\164\124\001\114\061\114\088\120\013\038\025\073\118\087\116\049\104\061\073\114\113\029\058\001\088\035\120\023\060\035\049\088\051\035\120\001\013\061\012\120\061\113\088\114\023\114\049\061\010\080\060\088\080\060\001\061\060\114\049\049\023\080\060\114\120\061\023\017\029\114\049\023\001\035\124\124\124\049\114\088\114\031\061\017\120\017\114\049\035\037\114\120\061\025\114\113\088\120\107\029\120\107\114\120\013\061\065\088\114\061\114\049\060\195\164\082\001\061\107\114\050\195\182\060\120\082\088\080\060\061\114\088\120\114\061\037\082\195\164\029\082\088\080\060\087\107\049\017\029\114\061\011\017\049\037\114\061\029\120\113\061\023\001\195\164\120\113\088\107\061\088\093\061\116\049\029\120\113\050\017\023\023\114\049\037\114\049\114\088\080\060\013")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 53441 then
		_Urwigo.OldDialog{
			{
				Text = _FJOj("\065\017\023\061\050\088\080\060\001\088\107\023\001\114\061\121\120\001\114\049\023\080\060\088\114\113\061\051\050\088\023\080\060\114\120\061\116\082\114\099\114\061\029\120\113\061\123\023\114\029\113\035\107\082\114\099\114\061\088\023\001\031\061\113\017\023\061\123\023\114\029\113\035\107\082\114\099\114\061\120\088\080\060\001\061\093\088\001\061\113\114\120\061\011\195\188\195\159\114\120\061\088\093\061\116\049\029\120\113\050\017\023\023\114\049\061\023\001\114\060\001\031\061\017\037\114\049\061\017\029\124\061\114\088\120\114\049\061\001\035\120\088\107\114\120\061\010\080\060\088\080\060\001\031\061\113\088\114\061\113\017\023\061\069\017\023\023\114\049\061\037\114\088\061\060\035\060\114\120\061\009\088\114\113\114\049\023\080\060\082\195\164\107\114\120\061\023\001\017\029\001\013\061\121\120\001\114\049\061\010\017\029\114\049\023\001\035\124\124\093\017\120\107\114\082\061\023\088\120\113\061\113\088\114\061\107\082\114\088\080\060\114\120\061\123\049\035\051\114\023\023\114\061\050\088\114\061\037\114\088\093\061\116\082\114\099\061\051\029\061\037\114\035\037\017\080\060\001\114\120\013\064\053\110")
			}, 
			{
				Text = _FJOj("\123\023\114\029\113\035\107\082\114\099\114\061\060\017\037\114\120\061\114\088\120\114\061\078\035\049\088\051\035\120\001\088\114\049\029\120\107\061\105\060\127\010\050\127\010\113\104\038\025\073\118\038\025\073\118\087\105\060\104\061\078\029\093\035\023\114\049\061\021\037\114\049\037\035\113\114\120\031\061\035\124\001\061\035\037\114\049\060\017\082\037\061\113\114\023\061\116\049\029\120\113\050\017\023\023\114\049\114\088\120\124\082\029\023\023\114\023\013\038\025\073\118\087\010\050\104\061\010\001\017\029\050\017\023\023\114\049\082\114\088\001\114\120\113\114\061\010\080\060\088\080\060\001\061\088\093\061\121\120\001\114\049\037\035\113\114\120\061\101\035\093\061\051\114\088\001\050\114\088\023\114\061\017\029\124\001\049\114\001\114\120\113\114\120\061\010\001\017\029\050\017\023\023\114\049\061\107\114\045\049\195\164\107\001\061\046\072\114\120\120\051\114\088\080\060\114\120\061\113\114\023\061\123\023\114\029\113\035\107\082\114\099\097\013\061\065\017\049\088\120\061\058\195\182\120\120\114\120\061\058\082\114\088\120\114\061\023\080\060\050\017\049\051\037\049\017\029\120\114\061\015\017\120\107\017\120\087\072\120\195\182\082\082\080\060\114\120\061\114\088\120\107\114\082\017\107\114\049\001\061\023\114\088\120\013\038\025\073\118\087\010\113\104\061\065\088\080\060\001\114\031\061\050\017\023\023\114\049\023\001\017\029\114\120\113\114\031\061\001\035\120\049\114\088\080\060\114\061\029\120\113\061\093\114\088\023\001\061\037\082\017\029\107\049\017\029\061\037\088\023\061\049\035\023\001\037\049\017\029\120\061\093\017\049\093\035\049\088\114\049\001\114\061\121\120\001\114\049\037\035\113\114\120\061\078\035\049\088\051\035\120\001\013")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 22382 then
		_Urwigo.OldDialog{
			{
				Text = _FJOj("\025\049\017\029\114\049\113\114\120\061\023\088\120\113\061\114\088\120\061\025\035\113\114\120\001\099\045\061\113\114\023\061\107\114\093\195\164\195\159\088\107\001\061\060\029\093\088\113\114\120\061\072\082\088\093\017\023\013\061\065\017\023\061\105\029\023\107\017\120\107\023\093\017\001\114\049\088\017\082\061\113\114\049\061\025\035\113\114\120\037\088\082\113\029\120\107\061\088\023\001\061\114\088\120\061\023\080\060\050\017\080\060\061\023\080\060\082\029\124\124\088\107\114\049\061\010\017\120\113\013\061\065\088\114\061\025\049\017\029\120\114\049\113\114\120\061\088\093\061\009\010\116\061\095\082\113\114\120\017\061\114\120\001\023\001\017\120\113\114\120\061\029\120\001\114\049\061\025\114\113\088\120\107\029\120\107\114\120\061\023\080\060\050\017\080\060\124\082\088\114\195\159\114\120\113\114\120\061\037\088\023\061\023\001\114\060\114\120\113\114\120\061\069\017\023\023\114\049\023\061\051\050\088\023\080\060\114\120\061\120\088\114\113\114\049\001\017\029\114\120\113\114\120\061\022\035\001\114\088\023\037\082\195\182\080\058\114\120\061\113\114\049\061\082\114\001\051\001\114\120\061\107\049\035\195\159\114\120\061\023\058\017\120\113\088\120\017\101\088\023\080\060\114\120\061\090\114\049\107\082\114\001\023\080\060\114\049\029\120\107\013\064\030\110")
			}, 
			{
				Text = _FJOj("\025\049\017\029\120\114\049\113\114\120\061\060\017\037\114\120\061\114\088\120\114\061\001\099\045\088\023\080\060\114\061\078\035\049\088\051\035\120\001\088\114\049\029\120\107\061\105\060\127\025\101\127\036\064\053\110\104\038\025\073\118\038\025\073\118\087\105\060\104\061\078\029\093\035\023\114\049\061\021\037\114\049\037\035\113\114\120\013\061\078\029\093\029\023\023\080\060\088\080\060\001\061\093\088\001\061\050\114\120\088\107\114\049\061\017\082\023\061\005\084\014\061\035\049\107\017\120\088\023\080\060\114\049\061\010\029\037\023\001\017\120\051\013\038\025\073\118\087\025\101\104\061\015\088\120\114\049\017\082\088\023\080\060\114\049\061\090\114\049\050\088\001\001\114\049\029\120\107\023\060\035\049\088\051\035\120\001\031\061\113\114\049\061\113\029\049\080\060\061\113\088\114\023\114\049\061\090\114\049\050\088\001\001\114\049\029\120\107\061\046\119\114\049\058\082\114\088\120\114\049\029\120\107\031\061\068\195\182\023\029\120\107\061\035\113\114\049\061\119\114\049\124\017\082\082\061\101\035\120\061\116\114\023\001\114\088\120\114\120\061\029\120\113\061\015\088\120\114\049\017\082\114\120\061\017\120\061\113\114\049\061\095\049\113\035\037\114\049\124\082\195\164\080\060\114\061\088\120\061\105\037\060\195\164\120\107\088\107\058\114\088\001\061\101\035\120\061\058\082\088\093\017\001\088\023\080\060\114\120\061\025\114\113\088\120\107\029\120\107\114\120\097\061\101\114\049\037\049\017\029\120\001\061\029\120\113\061\101\114\049\082\114\060\093\001\061\088\023\001\013\038\025\073\118\087\036\104\061\121\120\001\114\049\107\049\029\120\113\013\061\105\029\023\107\017\120\107\023\107\114\023\001\114\088\120\031\061\017\029\023\061\113\114\093\061\025\035\113\114\120\061\114\120\001\023\001\114\060\001\013")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 13349 then
		_Urwigo.OldDialog{
			{
				Text = _FJOj("\095\088\120\061\015\035\035\049\037\035\113\114\120\061\088\023\001\061\114\088\120\061\050\017\023\023\114\049\107\114\023\195\164\001\001\088\107\001\114\049\061\025\035\113\114\120\031\061\113\114\049\061\017\029\023\061\093\195\164\080\060\001\088\107\114\120\061\022\035\049\124\023\080\060\088\080\060\001\114\120\061\046\035\049\107\017\120\088\023\080\060\114\023\061\010\114\113\088\093\114\120\001\097\061\037\114\023\001\114\060\001\013\061\065\088\114\061\022\035\049\124\017\029\124\082\017\107\114\061\093\029\023\023\061\093\088\120\113\114\023\001\114\120\023\061\005\084\061\080\093\061\093\195\164\080\060\001\088\107\061\023\114\088\120\013\061\015\035\035\049\114\061\050\114\049\113\114\120\061\001\049\017\113\088\001\088\035\120\114\082\082\061\120\017\080\060\061\113\114\049\061\069\017\023\023\114\049\101\114\049\023\035\049\107\029\120\107\061\088\120\061\078\035\080\060\093\035\035\049\114\061\029\120\113\061\009\088\114\113\114\049\093\035\035\049\114\061\029\120\001\114\049\023\080\060\088\114\113\114\120\031\061\050\035\037\114\088\061\009\088\114\113\114\049\093\035\035\049\114\061\072\035\120\001\017\058\001\061\051\029\093\061\116\049\029\120\113\050\017\023\023\114\049\061\060\017\037\114\120\061\029\120\113\061\078\035\080\060\093\035\035\049\114\061\029\120\017\037\060\195\164\120\107\088\107\061\113\017\101\035\120\061\113\029\049\080\060\061\073\114\107\114\120\050\017\023\023\114\049\061\114\120\001\023\001\017\120\113\114\120\061\023\088\120\113\013\064\053\110")
			}, 
			{
				Text = _FJOj("\065\088\114\061\022\035\049\124\023\080\060\088\080\060\001\114\120\061\114\120\001\023\001\114\060\114\120\031\061\050\114\120\120\061\015\088\058\049\035\035\049\107\017\120\088\023\093\114\120\061\017\037\107\114\023\001\035\049\037\114\120\114\061\123\124\082\017\120\051\114\120\049\114\023\001\114\061\017\029\124\107\049\029\120\113\061\101\035\120\061\010\017\029\114\049\023\001\035\124\124\093\017\120\107\114\082\061\120\088\080\060\001\061\101\035\082\082\023\001\195\164\120\113\088\107\061\017\037\037\017\029\114\120\061\058\195\182\120\120\114\120\013\061\065\088\114\023\061\045\017\023\023\088\114\049\001\061\060\195\164\029\124\088\107\061\017\120\061\107\049\029\120\113\050\017\023\023\114\049\037\114\114\088\120\124\082\029\195\159\001\114\120\061\010\001\017\120\113\035\049\001\114\120\013\061\022\035\049\124\114\061\050\017\080\060\023\114\120\061\107\114\050\195\182\060\120\082\088\080\060\061\120\029\049\061\082\017\120\107\023\017\093\013\061\065\017\061\120\114\037\114\120\061\113\114\120\061\107\049\035\037\114\120\061\123\124\082\017\120\051\114\120\049\114\023\001\114\120\061\017\029\080\060\061\123\035\082\082\114\120\061\120\088\080\060\001\061\101\035\082\082\023\001\195\164\120\113\088\107\061\017\037\107\114\037\017\029\001\061\050\088\049\113\061\037\088\082\113\114\001\061\082\114\001\051\001\114\049\114\049\061\114\088\120\061\124\017\120\001\017\023\001\088\023\080\060\114\023\061\105\049\080\060\088\101\061\113\114\049\061\008\195\188\120\107\023\001\114\120\061\095\120\001\050\088\080\058\082\029\120\107\061\029\120\023\114\049\114\049\061\060\114\088\093\088\023\080\060\114\120\061\011\082\035\049\017\013\064\030\110")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 41117 then
		_Urwigo.OldDialog{
			{
				Text = _FJOj("\072\035\082\082\029\101\088\023\035\082\061\023\088\120\113\061\025\195\182\113\114\120\061\113\114\023\023\114\120\061\037\035\113\114\120\037\088\082\113\114\120\113\114\061\123\049\035\051\114\023\023\114\061\023\088\080\060\061\088\120\113\088\049\114\058\001\061\017\029\124\061\113\017\023\061\093\114\120\023\080\060\082\088\080\060\114\061\069\088\049\058\114\120\061\051\029\049\195\188\080\058\101\114\049\124\035\082\107\114\120\061\082\017\023\023\114\120\013\061\065\088\114\023\114\049\061\025\035\113\114\120\061\114\120\001\050\088\080\058\114\082\001\061\023\088\080\060\061\017\120\061\010\001\017\120\113\035\049\001\114\120\031\061\017\120\061\113\114\120\114\120\061\023\088\080\060\061\017\029\124\107\049\029\120\113\061\113\114\049\061\068\017\107\114\061\101\035\120\061\017\120\113\114\049\114\049\061\010\001\114\082\082\114\061\017\037\107\114\001\049\017\107\114\120\114\023\061\025\035\113\114\120\093\017\001\114\049\088\017\082\061\050\088\114\113\114\049\061\017\120\023\017\093\093\114\082\120\061\058\017\120\120\013\061\065\088\114\061\011\017\058\001\035\049\114\120\031\061\113\088\114\061\051\029\061\095\049\035\023\088\035\120\061\101\035\120\061\025\035\113\114\120\093\017\001\114\049\088\017\082\061\017\120\061\017\120\113\114\049\114\049\061\010\001\114\082\082\114\061\124\195\188\060\049\114\120\061\023\088\120\113\061\037\114\088\093\061\072\035\082\082\029\101\088\023\035\082\061\195\188\037\114\049\050\088\114\107\114\120\113\061\093\114\120\023\080\060\082\088\080\060\114\120\061\121\049\023\045\049\029\120\107\023\061\050\088\114\061\037\114\088\023\045\088\114\082\023\050\114\088\023\114\061\113\088\114\061\073\035\113\029\120\107\061\101\035\120\061\069\195\164\082\113\114\049\120\061\017\120\061\078\017\120\107\082\017\107\114\120\013\061\072\035\082\082\029\101\088\023\035\082\061\025\195\182\113\114\120\061\124\088\120\113\114\120\061\023\088\080\060\061\035\124\001\061\088\093\061\025\114\049\114\088\080\060\061\101\035\120\061\105\080\058\114\049\037\114\049\107\114\120\061\023\035\050\088\114\061\017\120\061\069\114\107\037\195\182\023\080\060\029\120\107\114\120\061\029\120\113\061\037\114\088\061\060\088\023\001\035\049\088\023\080\060\114\120\061\105\080\058\114\049\001\114\049\049\017\023\023\114\120\061\029\120\001\114\049\061\069\017\082\113\013\061\078\195\164\029\124\088\107\114\049\061\023\088\120\113\061\058\035\082\082\029\101\088\017\082\114\061\195\156\037\114\049\113\114\080\058\029\120\107\114\120\061\037\114\088\061\114\049\035\113\088\114\049\001\114\120\061\025\195\182\113\114\120\061\050\088\114\061\025\049\017\029\120\114\049\113\114\120\013\038\025\073\118\065\029\049\080\060\061\113\114\120\061\124\114\060\082\114\120\113\114\120\061\025\114\050\029\080\060\023\061\050\088\049\113\061\060\029\093\035\023\114\023\061\021\037\114\049\037\035\113\114\120\093\017\001\114\049\088\017\082\061\082\114\088\080\060\001\114\049\061\113\114\120\061\078\017\120\107\061\060\088\120\029\120\001\114\049\061\107\114\001\049\017\107\114\120\013\061\105\093\061\078\017\120\107\124\029\195\159\061\035\113\114\049\061\088\120\061\010\114\120\058\114\120\061\082\017\107\114\049\001\061\023\088\080\060\061\113\088\114\023\114\023\061\015\017\001\114\049\088\017\082\061\050\088\114\113\114\049\061\017\037\031\061\113\114\049\061\072\035\082\082\029\101\088\023\035\082\061\114\120\001\023\001\114\060\001\013\064\075\110")
			}, 
			{
				Text = _FJOj("\072\035\082\082\029\101\088\023\035\082\037\195\182\113\114\120\061\060\017\037\114\120\061\114\088\120\114\061\001\099\045\088\023\080\060\114\061\078\035\049\088\051\035\120\001\088\114\049\029\120\107\061\105\060\127\015\127\012\012\104\038\025\073\118\038\025\073\118\087\105\060\104\061\078\029\093\035\023\114\049\061\021\037\114\049\037\035\113\114\120\013\061\078\029\093\029\023\023\080\060\088\080\060\001\061\093\088\001\061\050\114\120\088\107\114\049\061\017\082\023\061\005\084\014\061\035\049\107\017\120\088\023\080\060\114\049\061\010\029\037\023\001\017\120\051\013\038\025\073\118\087\015\104\061\025\035\113\114\120\060\035\049\088\051\035\120\001\061\017\029\023\061\023\114\113\088\093\114\120\001\088\114\049\001\114\093\031\061\060\029\093\035\023\114\093\061\025\035\113\114\120\093\017\001\114\049\088\017\082\013\061\065\114\049\061\080\060\017\049\017\058\001\114\049\088\023\001\088\023\080\060\114\061\015\087\078\035\049\088\051\035\120\001\061\088\023\001\061\023\114\060\049\061\113\029\120\058\114\082\031\061\060\029\093\035\023\061\029\120\113\061\120\195\164\060\049\023\001\035\124\124\049\114\088\080\060\061\023\035\050\088\114\061\093\088\120\113\114\023\001\114\120\023\061\075\084\061\080\093\061\093\195\164\080\060\001\088\107\013")
			}
		}
	end
end
function _bX3:OnTick()
	local _rndChoiceValue = math.random()
	if _rndChoiceValue < 0.272727272727273 then
		Wherigo.PlayAudio(_wmJ)
		_mQiIa.Visible = true
	elseif _rndChoiceValue < 0.318181818181818 then
		Wherigo.PlayAudio(_B8Fd)
		_NdiZ.Visible = true
	elseif _rndChoiceValue < 0.409090909090909 then
		Wherigo.PlayAudio(_wmJ)
		_KIhF.Visible = true
	elseif _rndChoiceValue < 0.681818181818182 then
		Wherigo.PlayAudio(_59iM5)
		_6_P.Visible = true
	elseif _rndChoiceValue < 0.818181818181818 then
		Wherigo.PlayAudio(_89Lm9)
		_Ch1o.Visible = true
	else
		Wherigo.PlayAudio(_wmJ)
		_4vC.Visible = true
	end
	_AMasp:Start()
	_Fiu = math.random(30, 300)
	_bX3.Duration = _Fiu
	_bX3:Start()
end
function _AMasp:OnTick()
	Wherigo.Command "StopSound"
	_NdiZ.Visible = false
	_mQiIa.Visible = false
	_KIhF.Visible = false
	_Ch1o.Visible = false
	_4vC.Visible = false
	_6_P.Visible = false
end
function _awN:On_pUbli(target)
	_Urwigo.MessageBox{
		Text = _FJOj("\065\114\049\061\025\035\113\114\120\061\088\023\001\061\113\114\049\061\035\037\114\049\023\001\114\061\022\114\088\082\061\113\114\049\061\095\049\113\058\049\029\023\001\114\013\061\065\088\114\061\025\195\182\113\114\120\061\023\088\120\113\061\113\017\023\061\095\049\107\114\037\120\088\023\061\113\114\023\061\119\029\023\017\093\093\114\120\050\088\049\058\114\120\023\061\101\035\120\061\107\114\035\082\035\107\088\023\080\060\114\093\061\010\029\037\023\001\049\017\001\031\061\073\114\082\088\114\124\031\061\072\082\088\093\017\031\061\025\035\113\114\120\050\017\023\023\114\049\031\061\022\088\114\049\087\061\029\120\113\061\123\124\082\017\120\051\114\120\050\114\082\001\031\061\093\114\120\023\080\060\082\088\080\060\114\049\061\022\195\164\001\088\107\058\114\088\001\061\029\120\113\061\101\114\049\124\195\188\107\037\017\049\114\049\061\119\114\088\001\013\061\065\088\114\023\114\061\011\017\058\001\035\049\114\120\061\050\114\080\060\023\114\082\120\061\101\035\120\061\021\049\001\061\051\029\061\021\049\001\013\061\065\114\023\060\017\082\037\061\107\088\037\001\061\114\023\061\088\093\061\009\010\116\061\095\082\113\114\120\017\061\017\029\080\060\061\101\088\114\082\114\061\101\114\049\023\080\060\088\114\113\114\120\017\049\001\088\107\114\120\061\025\195\182\113\114\120\013\064\005\110\038\025\073\118\069\088\080\060\001\088\107\023\001\114\120\061\095\049\058\114\120\120\029\120\107\023\093\114\049\058\093\017\082\061\113\114\049\061\025\035\113\114\120\061\088\023\001\061\113\088\114\061\105\029\023\037\088\082\113\029\120\107\061\029\120\113\061\105\037\124\035\082\107\114\061\029\120\001\114\049\023\080\060\088\114\113\082\088\080\060\061\107\114\124\195\164\049\037\001\114\049\061\025\035\113\114\120\060\035\049\088\051\035\120\001\114\031\061\113\088\114\061\101\035\120\061\035\037\114\120\061\120\017\080\060\061\029\120\001\114\120\061\113\017\023\061\025\035\113\114\120\045\049\035\124\088\082\061\037\088\082\113\114\120\013\061\025\035\113\114\120\045\049\035\124\088\082\114\061\093\088\001\061\107\082\114\088\080\060\114\120\061\035\113\114\049\061\195\164\060\120\082\088\080\060\114\120\061\015\114\049\058\093\017\082\114\061\050\114\049\113\114\120\061\088\120\061\025\035\113\114\120\001\099\045\114\120\061\051\029\023\017\093\093\114\120\107\114\124\017\023\023\001\031\061\113\088\114\061\037\114\023\001\088\093\093\001\114\061\050\088\023\023\114\120\023\080\060\017\124\001\082\088\080\060\114\061\025\114\051\114\088\080\060\120\029\120\107\114\120\061\001\049\017\107\114\120\013")
	}
end
function _awN:On_vGo(target)
	_Urwigo.OldDialog{
		{
			Text = _FJOj("\025\035\113\114\120\060\035\049\088\051\035\120\001\114\061\023\088\120\113\061\025\114\049\114\088\080\060\114\061\088\120\120\114\049\060\017\082\037\061\113\114\023\061\025\035\113\114\120\023\031\061\113\088\114\061\114\088\120\060\114\088\001\082\088\080\060\061\195\164\060\120\082\088\080\060\114\061\015\114\049\058\093\017\082\114\061\029\120\113\061\095\088\107\114\120\023\080\060\017\124\001\114\120\061\037\114\023\088\001\051\114\120\061\029\120\113\061\023\088\080\060\061\101\035\120\061\113\017\049\195\188\037\114\049\082\088\114\107\114\120\113\114\120\061\035\113\114\049\061\113\017\049\029\120\001\114\049\124\035\082\107\114\120\113\114\120\061\025\114\049\114\088\080\060\114\120\061\029\120\001\114\049\023\080\060\114\088\113\114\120\013")
		}, 
		{
			Text = _FJOj("\065\088\114\061\025\035\113\114\120\060\035\049\088\051\035\120\001\114\061\082\017\023\023\114\120\061\023\088\080\060\031\061\088\093\061\025\035\113\114\120\045\049\035\124\088\082\061\101\035\120\061\035\037\114\120\061\120\017\080\060\061\029\120\001\114\120\031\061\107\049\035\037\061\050\088\114\061\124\035\082\107\001\061\114\088\120\001\114\088\082\114\120\104\064\076\110\038\025\073\118\061\102\120\037\023\045\026\102\120\037\023\045\026\102\120\037\023\045\026\021\087\078\035\049\088\051\035\120\001\114\104\061\035\049\107\017\120\088\023\080\060\114\061\105\029\124\082\017\107\114\013\038\025\073\118\061\102\120\037\023\045\026\102\120\037\023\045\026\102\120\037\023\045\026\105\087\078\035\049\088\051\035\120\001\114\104\061\093\088\120\114\049\017\082\088\023\080\060\114\049\061\021\037\114\049\037\035\113\114\120\013\038\025\073\118\061\102\120\037\023\045\026\102\120\037\023\045\026\102\120\037\023\045\026\025\087\078\035\049\088\051\035\120\001\114\104\061\093\088\120\114\049\017\082\088\023\080\060\114\049\061\121\120\001\114\049\037\035\113\114\120\013\038\025\073\118\061\102\120\037\023\045\026\102\120\037\023\045\026\102\120\037\023\045\026\036\087\078\035\049\088\051\035\120\001\114\104\061\093\088\120\114\049\017\082\088\023\080\060\114\049\061\121\120\001\114\049\107\049\029\120\113\013\038\025\073\118"), 
			Media = _6RM3g
		}, 
		{
			Text = _FJOj("\105\029\195\159\114\049\113\114\093\061\107\088\037\001\061\114\023\061\050\114\088\001\114\049\114\061\101\035\049\017\120\107\114\023\001\114\082\082\001\114\061\025\029\080\060\023\001\017\037\114\120\061\051\029\049\061\072\114\120\120\051\114\088\080\060\120\029\120\107\061\037\114\023\035\120\113\114\049\114\049\061\123\049\035\051\114\023\023\114\061\029\120\113\061\095\088\107\114\120\023\080\060\017\124\001\114\120\031\061\113\088\114\061\120\088\080\060\001\061\113\029\049\080\060\061\113\088\114\061\025\035\113\114\120\037\088\082\113\029\120\107\061\114\120\001\023\001\017\120\113\114\120\061\023\088\120\113\031\061\029\120\113\061\093\088\001\061\049\195\182\093\088\023\080\060\114\061\119\017\060\082\114\120\061\050\088\049\113\061\114\088\120\061\051\050\114\088\001\114\061\010\080\060\088\080\060\001\061\037\114\051\114\088\080\060\120\114\001\013\061\065\088\114\061\023\114\060\114\120\061\050\114\049\113\114\120\061\050\088\049\061\124\195\188\049\061\008\114\113\114\120\061\025\035\113\114\120\001\099\045\061\107\114\120\017\029\114\049\061\017\120\023\114\060\114\120\013")
		}
	}
end
function _awN:On_QzazA(target)
	if Wherigo.NoCaseEquals(_0RpN, _FJOj("\107\082\114\099")) then
		_Urwigo.MessageBox{
			Text = _LkYm
		}
	elseif Wherigo.NoCaseEquals(_0RpN, _FJOj("\045\023\114\029\113\035")) then
		_Urwigo.MessageBox{
			Text = _nr6
		}
	elseif Wherigo.NoCaseEquals(_0RpN, _FJOj("\037\049\017\029\120")) then
		_Urwigo.MessageBox{
			Text = _Ns1
		}
	elseif Wherigo.NoCaseEquals(_0RpN, _FJOj("\093\035\035\049")) then
		_Urwigo.MessageBox{
			Text = _jN9e
		}
	elseif Wherigo.NoCaseEquals(_0RpN, _FJOj("\058\035\082\082\029\101\088")) then
		_Urwigo.MessageBox{
			Text = _u81Fe
		}
	end
end
function _awN:On_8fw9o(target)
	_Urwigo.OldDialog{
		{
			Text = _FJOj("\012\093\061\009\010\116\061\095\082\113\114\120\017\061\113\035\093\088\120\088\114\049\114\120\061\120\195\164\023\023\114\107\114\045\049\195\164\107\001\114\061\025\195\182\113\114\120\031\061\050\035\037\114\088\061\116\049\029\120\113\050\017\023\023\114\049\061\101\114\049\023\080\060\088\114\113\114\120\114\061\022\099\045\114\120\061\101\035\120\061\009\088\114\113\114\049\093\035\035\049\037\195\182\113\114\120\061\029\120\113\061\116\082\114\099\114\120\061\029\120\113\061\010\001\017\029\050\195\164\023\023\114\049\061\123\023\114\029\113\035\107\082\114\099\114\061\045\049\195\164\107\114\120\013\061\065\088\114\061\090\114\049\001\114\088\082\029\120\107\061\113\114\049\061\025\195\182\113\114\120\061\060\195\164\120\107\114\120\061\101\035\120\061\113\114\049\061\105\029\023\045\049\195\164\107\029\120\107\061\101\035\120\061\069\017\023\023\114\049\031\061\010\029\037\023\001\049\017\001\061\029\120\113\061\073\114\082\088\114\124\061\017\037\013\061\065\017\037\114\088\061\023\045\088\114\082\001\061\037\114\023\035\120\113\114\049\023\061\113\017\023\061\025\035\113\114\120\050\017\023\023\114\049\031\061\113\114\049\114\120\061\095\049\023\080\060\114\088\120\029\120\107\023\124\035\049\093\061\101\035\120\061\010\029\037\023\001\049\017\001\061\029\120\113\061\073\114\082\088\114\124\061\107\114\023\001\114\029\114\049\001\061\050\088\049\113\031\061\114\088\120\114\061\050\114\023\114\120\001\082\088\080\060\114\061\073\035\082\082\114\013\061\025\195\182\113\114\120\061\035\060\120\114\061\078\099\113\049\035\093\035\049\045\060\088\114\093\114\049\058\093\017\082\114\061\023\088\120\113\061\017\029\124\061\058\082\114\088\120\114\061\105\049\114\017\082\114\061\037\114\107\049\114\120\051\001\013"), 
			Media = _Y_u
		}, 
		{
			Text = _FJOj("\012\120\061\113\114\120\061\010\114\120\058\114\120\061\029\120\113\061\009\088\114\113\114\049\029\120\107\114\120\031\061\093\088\001\061\107\017\120\051\008\195\164\060\049\088\107\061\060\035\060\114\093\061\116\049\029\120\113\050\017\023\023\114\049\023\001\017\120\113\031\061\060\017\037\114\120\061\023\088\080\060\061\009\088\114\113\114\049\093\035\035\049\114\061\107\114\037\088\082\113\114\001\013\061\065\088\114\061\073\114\060\037\049\029\080\060\087\022\035\049\124\114\061\023\088\120\113\061\101\114\049\037\049\114\088\001\114\001\061\101\035\120\061\093\088\120\114\049\017\082\088\023\080\060\114\120\061\017\120\001\060\049\035\045\035\107\114\120\061\017\029\124\107\114\037\049\017\080\060\001\114\120\061\025\035\113\114\120\093\017\001\114\049\088\017\082\088\114\120\061\037\114\113\114\080\058\001\013\061\065\088\114\061\017\120\107\049\114\120\051\114\120\113\114\120\061\025\114\049\114\088\080\060\114\061\113\114\049\061\010\114\120\058\114\120\061\050\114\049\113\114\120\061\101\035\120\061\116\082\114\099\114\120\061\017\029\124\061\023\017\120\113\088\107\114\120\061\035\113\114\049\061\082\114\060\093\088\107\114\120\061\010\029\037\023\001\049\017\001\114\120\061\114\088\120\107\114\120\035\093\093\114\120\013"), 
			Media = _Y_u
		}, 
		{
			Text = _FJOj("\012\120\061\113\114\120\061\001\088\114\124\023\001\114\120\061\025\114\049\114\088\080\060\114\120\061\113\035\093\088\120\088\114\049\114\120\061\116\049\029\120\113\050\017\023\023\114\049\037\195\182\113\114\120\013\061\116\082\114\099\061\029\120\113\061\123\023\114\029\113\035\107\082\114\099\114\031\061\113\088\114\061\113\029\049\080\060\061\113\088\114\061\195\156\037\114\049\082\017\107\114\049\029\120\107\061\101\035\120\061\107\049\029\120\113\087\061\029\120\113\061\023\001\017\029\050\017\023\023\114\049\037\114\114\088\120\124\082\029\023\023\001\114\120\061\025\114\049\114\088\080\060\114\120\061\114\120\001\023\001\114\060\114\120\061\124\088\120\113\114\120\061\060\088\114\049\061\124\082\195\164\080\060\114\120\060\017\124\001\114\061\090\114\049\037\049\114\088\001\029\120\107\013"), 
			Media = _Y_u
		}, 
		{
			Text = _FJOj("\025\049\017\029\120\114\049\113\114\120\061\037\088\082\113\114\120\061\023\088\080\060\061\088\120\061\010\001\017\120\113\035\049\001\114\120\061\124\049\114\088\061\101\035\120\061\116\049\029\120\113\050\017\023\023\114\049\061\050\035\061\113\114\049\061\035\037\114\049\124\082\195\164\080\060\114\120\120\017\060\114\061\078\017\029\045\001\101\114\049\050\088\001\001\114\049\029\120\107\023\037\114\049\114\088\080\060\061\088\120\061\011\035\049\093\061\114\088\120\114\049\061\037\049\017\029\114\120\061\011\195\164\049\037\029\120\107\061\051\029\093\061\090\035\049\023\080\060\114\088\120\061\058\035\093\093\114\120\061\058\017\120\120\013\061\065\114\023\060\017\082\037\061\120\114\060\093\114\120\061\025\049\017\029\120\114\049\113\114\120\061\114\088\120\061\107\114\049\088\120\107\114\120\061\105\120\001\114\088\082\061\113\114\023\061\009\010\116\061\095\082\113\114\120\017\061\114\088\120\013"), 
			Media = _Y_u
		}, 
		{
			Text = _FJOj("\065\088\114\061\009\029\001\051\029\120\107\061\113\114\049\061\068\017\120\113\023\080\060\017\124\001\061\113\029\049\080\060\061\113\114\120\061\015\114\120\023\080\060\114\120\061\124\195\188\060\049\001\114\061\051\029\049\061\050\114\088\001\114\049\114\120\061\065\088\124\124\114\049\114\120\051\088\114\049\029\120\107\061\113\114\049\061\025\035\113\114\120\113\114\080\058\114\013\061\095\023\061\037\088\082\113\114\001\114\120\061\023\088\080\060\061\095\049\035\023\088\035\120\023\087\061\029\120\113\061\105\058\058\029\093\029\082\017\001\088\035\120\023\045\049\035\124\088\082\114\013\061\011\049\195\188\060\114\049\114\061\105\080\058\114\049\120\029\001\051\029\120\107\061\050\088\049\113\061\195\188\037\114\049\061\072\035\082\082\029\101\088\017\082\037\195\182\113\114\120\061\023\088\080\060\001\037\017\049\013"), 
			Media = _Y_u
		}
	}
end
function _awN:On_Ipi(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(__Yz)
	end)
end
function _FsyzO:On_eJOne(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_b9K2m)
	end)
end
function _FsyzO:On_IwMXh(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_GCVu)
	end)
end
function _FsyzO:On_bM1f8(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_9il)
	end)
end
function _FsyzO:On_Os4Q(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_CmMmR)
	end)
end
function _FsyzO:On_Ua5e1(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_nl4mU)
	end)
end

-- Urwigo functions --
function _SN1T()
	_eeSm.Description = ((((((((((((_FJOj("\065\029\061\060\017\023\001\061\124\035\082\107\114\120\113\114\023\061\107\114\017\120\001\050\035\049\001\114\001\104\038\025\073\118\011\049\017\107\114\061\024\017\104\061").._WF0E).._FJOj("\038\025\073\118\011\049\017\107\114\061\024\037\104\061")).._jseot).._FJOj("\038\025\073\118\011\049\017\107\114\061\030\104\061")).._EBPV).._FJOj("\038\025\073\118\011\049\017\107\114\061\005\104\061")).._eQb).._FJOj("\038\025\073\118\011\049\017\107\114\061\075\104\061")).._VX1).._FJOj("\038\025\073\118\011\049\017\107\114\061\053\017\104\061")).._DRff).._FJOj("\038\025\073\118\011\049\017\107\114\061\053\037\104\061")).._nv9O
end
function _Okmy2()
	if _xxNd.Complete == true then
		if _5EVC4.Complete == true then
			if _vVWw.Complete == true then
				if _yK6nl.Complete == true then
					if _S3ITz.Complete == true then
						_YQ8fd.Complete = true
						_Urwigo.Dialog(false, {
							{
								Text = _FJOj("\065\029\061\060\017\023\001\061\017\082\082\114\061\113\088\114\061\011\049\017\107\114\120\061\107\114\017\120\001\050\035\049\001\114\001\089\038\025\073\118\095\023\061\088\023\001\061\058\114\088\120\114\061\068\035\107\037\114\113\088\120\107\029\120\107\061\017\037\114\049\061\050\114\120\120\061\113\029\061\114\023\061\093\195\182\080\060\001\114\023\001\031\061\113\029\061\058\017\120\120\023\001\061\017\029\080\060\061\107\114\049\120\114\061\114\088\120\061\011\035\001\035\061\101\035\093\061\113\114\093\061\021\049\001\061\088\093\061\009\010\116\031\061\113\114\049\061\113\029\061\017\093\061\082\088\114\037\023\001\114\120\061\060\017\001\001\114\023\001\013\061\095\023\061\107\088\037\001\061\101\088\114\082\114\061\023\080\060\195\182\120\114\061\095\080\058\114\120\061\060\088\114\049\089\038\025\073\118\015\088\001\061\105\037\023\114\120\113\029\120\107\061\113\114\049\061\105\120\001\050\035\049\001\114\120\061\017\120\061\093\088\080\060\061\060\017\023\001\061\113\029\061\068\035\107\124\049\114\088\107\017\037\114\013\061\065\029\061\037\049\017\029\080\060\023\001\061\009\012\036\078\022\061\017\120\061\093\114\088\120\114\049\061\105\120\001\050\035\049\001\127\025\114\023\001\195\164\001\088\107\029\120\107\061\050\017\049\001\114\120\013\061\012\080\060\061\093\114\082\113\114\061\093\088\080\060\061\050\114\120\120\061\050\017\023\061\124\017\082\023\080\060\061\023\114\088\120\061\023\035\082\082\001\114\013"), 
								Media = _PnWe
							}, 
							{
								Text = _FJOj("\078\088\114\049\061\060\017\023\001\061\113\029\061\017\029\080\060\061\113\114\120\061\036\035\093\045\082\114\001\088\035\120\061\036\035\113\114\104\061")..string.sub(Player.CompletionCode, 1, 15)
							}
						}, function(action)
							_Cb55.Description = string.sub(Player.CompletionCode, 1, 15)
							_Cb55:MoveTo(Player)
						end)
					end
				end
			end
		end
	end
end

-- Begin user functions --
-- End user functions --
return _YQ8fd
